/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactory;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryService;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.MojoRow;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import ai.h2o.mojos.runtime.frame.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoFrameBuilder {
    private static final Logger log = LoggerFactory.getLogger(MojoFrameBuilder.class);
    private final Map<String, StringConverter> stringConvertersMap;
    public static final StringConverter DEFAULT_CONVERTER = new StringConverter(){

        @Override
        public final Object convert(String s2, MojoColumn.Type outputType) {
            return outputType.parse(s2);
        }
    };
    private final MojoFrameMeta _meta;
    private final Set<String> _missingValues;
    private final MojoColumnBuilder[] _columnBuilders;
    private final StringConverter[] _stringConverters;

    public MojoFrameBuilder(MojoFrameMeta frameMeta) {
        this(frameMeta, Collections.emptyList(), Collections.emptyMap());
    }

    public MojoFrameBuilder(MojoFrameMeta frameMeta, Set<String> missingValues) {
        this(frameMeta, missingValues, Collections.emptyMap());
    }

    public MojoFrameBuilder(MojoFrameMeta frameMeta, Collection<String> missingValues, Map<String, StringConverter> stringConverters) {
        this(frameMeta, missingValues, stringConverters, null);
    }

    private MojoFrameBuilder(MojoFrameMeta frameMeta, Collection<String> missingValues, Map<String, StringConverter> stringConverters, MojoFrameBuilder shared) {
        this._meta = frameMeta;
        this._missingValues = missingValues != null ? new HashSet<String>(missingValues) : new HashSet<String>(0);
        this._columnBuilders = new MojoColumnBuilder[frameMeta.size()];
        this._stringConverters = new StringConverter[frameMeta.size()];
        int n2 = 0;
        if (shared != null && stringConverters == null) {
            stringConverters = shared.stringConvertersMap;
        }
        log.trace("Contructing MojoFrameBuilder[{}]", (Object)frameMeta.size());
        for (MojoColumnMeta mojoColumnMeta : frameMeta.getColumns()) {
            String string = mojoColumnMeta.getColumnName();
            if (shared != null) {
                Integer n3 = shared._meta.indexOf(string);
                if (n3 != null) {
                    log.trace("shared: {} ({})", (Object)string, (Object)mojoColumnMeta.getColumnType());
                    this._columnBuilders[n2] = shared._columnBuilders[n3];
                    this._stringConverters[n2] = shared._stringConverters[n3];
                    ++n2;
                    continue;
                }
                log.trace("not shared: {} ({})", (Object)string, (Object)mojoColumnMeta.getColumnType());
            }
            this._columnBuilders[n2] = new MojoColumnBuilder(mojoColumnMeta.getColumnType());
            this._stringConverters[n2] = stringConverters.getOrDefault(string, DEFAULT_CONVERTER);
            ++n2;
        }
        this.stringConvertersMap = stringConverters;
    }

    public static MojoFrameBuilder withSharedColumns(MojoFrameMeta frameMeta, MojoFrameBuilder shared) {
        return new MojoFrameBuilder(frameMeta, shared._missingValues, null, shared);
    }

    public static MojoFrame getEmpty(MojoFrameMeta meta, int nrows) {
        MojoColumnFactory mojoColumnFactory = MojoColumnFactoryService.getInstance().getMojoColumnFactory();
        MojoColumn[] mojoColumnArray = new MojoColumn[meta.size()];
        for (int i2 = 0; i2 < meta.size(); ++i2) {
            MojoColumn.Type type = meta.getColumnType(i2);
            mojoColumnArray[i2] = mojoColumnFactory.create(type, nrows);
        }
        return new MojoFrame(meta, mojoColumnArray, nrows);
    }

    public static MojoFrame fromColumns(MojoFrameMeta meta, MojoColumn[] columns) {
        int n2;
        if (columns.length != meta.size()) {
            throw new IllegalArgumentException(String.format("Number of columns(%d) does not match size of frame meta (%d)", columns.length, meta.size()));
        }
        int n3 = n2 = columns.length == 0 ? 0 : columns[0].size();
        if (columns.length > 0) {
            String string = meta.getColumnName(0);
            int n4 = 0;
            for (MojoColumnMeta mojoColumnMeta : meta.getColumns()) {
                MojoColumn mojoColumn = columns[n4];
                if (mojoColumn != null) {
                    if (mojoColumn.size() != n2) {
                        throw new IllegalArgumentException(String.format("Number of rows in columns %d ('%s') and 0 ('%s') do not match (%d != %d)", n4, mojoColumnMeta.getColumnName(), string, mojoColumn.size(), n2));
                    }
                    if (mojoColumn.getType() != mojoColumnMeta.getColumnType()) {
                        throw new IllegalArgumentException(String.format("Type of column %d ('%s') does not match frame meta: %s != %s", new Object[]{n4, mojoColumnMeta.getColumnName(), mojoColumn.getType(), mojoColumnMeta.getColumnType()}));
                    }
                }
                ++n4;
            }
        }
        return new MojoFrame(meta, columns, n2);
    }

    public MojoRowBuilder addRow(MojoRowBuilder rowBuilder) {
        this.addRow(rowBuilder.toMojoRow());
        rowBuilder.clear();
        return rowBuilder;
    }

    void addRow(MojoRow row) {
        Object[] objectArray = row.getValues();
        if (objectArray.length != this._columnBuilders.length) {
            throw new IllegalArgumentException("Row argument does not have the same column count as frame");
        }
        for (int i2 = 0; i2 < this._columnBuilders.length; ++i2) {
            this._columnBuilders[i2].pushValue(objectArray[i2]);
        }
    }

    public MojoRowBuilder getMojoRowBuilder() {
        return this.getMojoRowBuilder(false);
    }

    public MojoRowBuilder getMojoRowBuilder(boolean strictMode) {
        return new MojoRowBuilder(this._meta.getColumnNamesMap(), this._meta.getColumnTypes(), this._missingValues, this._stringConverters, strictMode);
    }

    public MojoFrame toMojoFrame() {
        int n2 = this._columnBuilders.length == 0 ? 0 : this._columnBuilders[0].size();
        return this.toMojoFrame(n2);
    }

    public MojoFrame toMojoFrame(int nrows) {
        MojoColumn[] mojoColumnArray = new MojoColumn[this._columnBuilders.length];
        for (int i2 = 0; i2 < mojoColumnArray.length; ++i2) {
            mojoColumnArray[i2] = this._columnBuilders[i2].toMojoColumn();
            mojoColumnArray[i2].resize(nrows);
        }
        return new MojoFrame(this._meta, mojoColumnArray, nrows);
    }

    private static class MojoColumnBuilder {
        private final MojoColumn.Type colType;
        private final List<Object> values = new ArrayList<Object>();

        MojoColumnBuilder(MojoColumn.Type type) {
            this.colType = type;
        }

        void pushValue(Object value) {
            this.values.add(value == null ? this.colType.NULL : value);
        }

        MojoColumn toMojoColumn() {
            MojoColumn mojoColumn = MojoColumnFactoryService.getInstance().getMojoColumnFactory().create(this.colType, this.values.size());
            mojoColumn.fillFromParsedListData(this.values);
            return mojoColumn;
        }

        int size() {
            return this.values.size();
        }
    }
}

