/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.utils.BatchedCsvReader;
import ai.h2o.mojos.runtime.utils.Consts;
import ai.h2o.mojos.runtime.utils.CsvProcessingConfig;
import ai.h2o.mojos.runtime.utils.DatatableLikeCSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedCsvMojoProcessor {
    private static final Logger log;
    static final char ESCAPE_CHAR;
    static final char SEPARATOR;
    static final boolean IGNORE_LEADING_WHITESPACE;
    static final boolean IGNORE_UNQUOTED_FIELD_SURROUNDING_SPACES;
    private int batchSize = Consts.propExist("parser.csv.batch") ? Consts.getSysProp("parser.csv.batch", 1000) : Consts.getSysProp("batch", 1000);
    private final MojoPipeline pipeline;
    private final CsvProcessingConfig config;

    public BatchedCsvMojoProcessor(MojoPipeline pipeline) {
        this(pipeline, new CsvProcessingConfig());
    }

    public BatchedCsvMojoProcessor(MojoPipeline pipeline, CsvProcessingConfig config) {
        this.pipeline = pipeline;
        this.config = config;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long processCsv(Reader reader, final BatchHandler batchHandler) throws IOException {
        return this.processCsv(reader, new DualBatchHandler(){

            @Override
            public void handleBatch(int batchNo, MojoFrame iframe, MojoFrame oframe) throws IOException {
                batchHandler.handleBatch(batchNo, oframe);
            }
        });
    }

    public long processCsv(Reader reader, DualBatchHandler batchHandler) throws IOException {
        CSVReader cSVReader = this.openCsvReader(reader);
        int n2 = 0;
        BatchedCsvReader batchedCsvReader = new BatchedCsvReader(this.pipeline, cSVReader, this.batchSize, this.config);
        for (MojoFrame mojoFrame : batchedCsvReader) {
            MojoFrame mojoFrame2 = batchedCsvReader.getOutputFrame();
            int n3 = mojoFrame.getNrows();
            if (n3 == 0) break;
            log.debug("Processing batch #{} with {} rows", (Object)n2, (Object)n3);
            this.pipeline.transform(mojoFrame, mojoFrame2);
            batchHandler.handleBatch(n2, mojoFrame, mojoFrame2);
            ++n2;
        }
        return batchedCsvReader.getTotalDataRows();
    }

    protected CSVReader openCsvReader(Reader reader) {
        return BatchedCsvMojoProcessor.readerToCsvReader(reader);
    }

    public static CSVReader readerToCsvReader(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        DatatableLikeCSVParserBuilder datatableLikeCSVParserBuilder = new DatatableLikeCSVParserBuilder().withIgnoreUnquotedFieldSurroundingSpaces(IGNORE_UNQUOTED_FIELD_SURROUNDING_SPACES).withEscapeChar(ESCAPE_CHAR).withSeparator(SEPARATOR).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).withIgnoreLeadingWhiteSpace(IGNORE_LEADING_WHITESPACE);
        CSVReaderBuilder cSVReaderBuilder = new CSVReaderBuilder(bufferedReader).withCSVParser(datatableLikeCSVParserBuilder.build());
        cSVReaderBuilder.withKeepCarriageReturn(Consts.getSysProp("parser.csv.keepCarriageReturn", true));
        return cSVReaderBuilder.build();
    }

    static String stripCrFromEol(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int n2 = value.length();
        while (value.charAt(--n2) == '\r') {
        }
        return value.substring(0, n2 + 1);
    }

    static {
        String string;
        log = LoggerFactory.getLogger(BatchedCsvMojoProcessor.class);
        String string2 = Consts.propExist("parser.csv.separator") ? Consts.getSysProp("parser.csv.separator", ",") : Consts.getSysProp("separator", ",");
        switch (string2) {
            case "TAB": {
                SEPARATOR = (char)9;
                break;
            }
            default: {
                if (string2.length() != 1) {
                    throw new IllegalStateException("Separator value is '%s', but it must be 'TAB' or exactly one character");
                }
                SEPARATOR = string2.charAt(0);
            }
        }
        if ((string = Consts.propExist("parser.csv.escapeChar") ? Consts.getSysProp("parser.csv.escapeChar", "") : Consts.getSysProp("escapeChar", "")).length() == 0) {
            ESCAPE_CHAR = '\u0000';
        } else if (string.length() == 1) {
            ESCAPE_CHAR = string.charAt(0);
        } else {
            throw new IllegalStateException("Escape char value is '%s', but it must be either empty string or exactly one character");
        }
        IGNORE_LEADING_WHITESPACE = Consts.getSysProp("parser.csv.ignoreLeadingWhitespace", true);
        IGNORE_UNQUOTED_FIELD_SURROUNDING_SPACES = Consts.getSysProp("parser.csv.ignoreUnquotedFieldSurroundingSpaces", true);
    }

    public static interface DualBatchHandler {
        public void handleBatch(int var1, MojoFrame var2, MojoFrame var3) throws IOException;
    }

    public static interface BatchHandler {
        public void handleBatch(int var1, MojoFrame var2) throws IOException;
    }
}

