/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

public class Op {

    public static enum Binary {
        ADD{

            @Override
            public final String write(String lh, String rh) {
                return "(" + lh + " + " + rh + ")";
            }
        }
        ,
        SUBTRACT{

            @Override
            public final String write(String lh, String rh) {
                return "(" + lh + " - " + rh + ")";
            }
        }
        ,
        DIVIDE{

            @Override
            public final String write(String lh, String rh) {
                return "(" + lh + " / " + rh + ")";
            }
        }
        ,
        MULTIPLY{

            @Override
            public final String write(String lh, String rh) {
                return "(" + lh + " * " + rh + ")";
            }
        }
        ,
        POW{

            @Override
            public final String write(String lh, String rh) {
                return "Math.pow(" + lh + ", " + rh + ")";
            }
        }
        ,
        MIN{

            @Override
            public final String write(String lh, String rh) {
                return "(" + rh + " < " + lh + " ? " + rh + " : " + lh + ")";
            }
        }
        ,
        MAX{

            @Override
            public final String write(String lh, String rh) {
                return "(" + rh + " > " + lh + " ? " + rh + " : " + lh + ")";
            }
        }
        ,
        OR{

            @Override
            public final String write(String lh, String rh) {
                return "(" + lh + " || " + rh + ")";
            }
        }
        ,
        EQ{

            @Override
            public final String write(String lh, String rh) {
                return "(" + lh + " == " + rh + ")";
            }
        };


        public abstract String write(String var1, String var2);
    }

    public static enum Unary {
        SIGNUM{

            @Override
            public final String write(String val) {
                return "(" + val + " > 0 ? 1 : " + val + " < 0 ? -1 : 0)";
            }
        }
        ,
        ABS{

            @Override
            public final String write(String val) {
                return "Math.abs(" + val + ")";
            }
        };


        public abstract String write(String var1);
    }
}

