/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RFC4180Parser
implements ICSVParser {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    private final char separator;
    private final String separatorAsString;
    private final char quotechar;
    private final CSVReaderNullFieldIndicator nullFieldIndicator;
    private String pending;

    public RFC4180Parser() {
        this('\"', ',', CSVReaderNullFieldIndicator.NEITHER);
    }

    RFC4180Parser(char quoteChar, char separator, CSVReaderNullFieldIndicator nullFieldIndicator) {
        this.quotechar = quoteChar;
        this.separator = separator;
        this.separatorAsString = SPECIAL_REGEX_CHARS.matcher(Character.toString(separator)).replaceAll("\\\\$0");
        this.nullFieldIndicator = nullFieldIndicator;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public char getQuotechar() {
        return this.quotechar;
    }

    @Override
    public boolean isPending() {
        return this.pending != null;
    }

    @Override
    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    @Override
    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    @Override
    public String parseToLine(String[] values) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (int i2 = 0; i2 < values.length; ++i2) {
            stringBuilder.append(this.convertToCsvValue(values[i2]));
            if (i2 >= values.length - 1) continue;
            stringBuilder.append(this.getSeparator());
        }
        return stringBuilder.toString();
    }

    private String convertToCsvValue(String value) {
        String string;
        String string2 = value == null && !this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.NEITHER) ? "" : value;
        StringBuilder stringBuilder = new StringBuilder(string2 == null ? 16 : string2.length() << 1);
        boolean bl = string2 != null && string2.contains(Character.toString(this.getQuotechar()));
        boolean bl2 = this.isSurroundWithQuotes(value, bl);
        String string3 = string = !bl ? string2 : string2.replaceAll(Character.toString(this.getQuotechar()), Character.toString(this.getQuotechar()) + Character.toString(this.getQuotechar()));
        if (bl2) {
            stringBuilder.append(this.getQuotechar());
        }
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(this.getQuotechar());
        }
        return stringBuilder.toString();
    }

    private boolean isSurroundWithQuotes(String value, boolean containsQuoteChar) {
        if (value == null) {
            return this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.EMPTY_QUOTES);
        }
        return containsQuoteChar || value.contains(Character.toString(this.getSeparator())) || value.contains("\n");
    }

    protected String[] parseLine(String nextLine, boolean multi) throws IOException {
        String[] stringArray;
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String string = this.pending;
                this.pending = null;
                return new String[]{string};
            }
            return null;
        }
        String string = multi && this.pending != null ? this.pending + nextLine : nextLine;
        this.pending = null;
        if (!StringUtils.contains((CharSequence)string, this.quotechar)) {
            RFC4180Parser rFC4180Parser = this;
            stringArray = rFC4180Parser.handleEmptySeparators(rFC4180Parser.tokenizeStringIntoArray(string));
        } else {
            RFC4180Parser rFC4180Parser = this;
            stringArray = rFC4180Parser.handleEmptySeparators(rFC4180Parser.splitWhileNotInQuotes(string, multi));
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!StringUtils.contains((CharSequence)stringArray[i2], this.quotechar)) continue;
                stringArray[i2] = this.handleQuotes(stringArray[i2]);
            }
        }
        return stringArray;
    }

    private String[] tokenizeStringIntoArray(String nextLine) {
        return nextLine.split(this.separatorAsString, -1);
    }

    private String[] handleEmptySeparators(String[] strings) {
        if (this.nullFieldIndicator == CSVReaderNullFieldIndicator.EMPTY_SEPARATORS || this.nullFieldIndicator == CSVReaderNullFieldIndicator.BOTH) {
            for (int i2 = 0; i2 < strings.length; ++i2) {
                if (!strings[i2].isEmpty()) continue;
                strings[i2] = null;
            }
        }
        return strings;
    }

    private String[] splitWhileNotInQuotes(String nextLine, boolean multi) {
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < nextLine.length()) {
            int n3 = nextLine.indexOf(this.separator, n2);
            int n4 = nextLine.indexOf(this.quotechar, n2);
            if (n3 == -1) {
                arrayList.add(nextLine.substring(n2));
                n2 = nextLine.length();
                continue;
            }
            if (n4 == -1 || n4 > n3 || n4 != n2) {
                arrayList.add(nextLine.substring(n2, n3));
                n2 = n3 + 1;
                continue;
            }
            int n5 = this.findEndOfFieldFromPosition(nextLine, n2);
            arrayList.add(n5 >= nextLine.length() ? nextLine.substring(n2) : nextLine.substring(n2, n5));
            n2 = n5 + 1;
        }
        if (multi && this.lastElementStartedWithQuoteButDidNotEndInOne(arrayList)) {
            ArrayList<String> arrayList2 = arrayList;
            this.pending = (String)arrayList2.get(arrayList2.size() - 1) + "\n";
            ArrayList<String> arrayList3 = arrayList;
            arrayList3.remove(arrayList3.size() - 1);
        } else if (nextLine.lastIndexOf(this.separator) == nextLine.length() - 1) {
            arrayList.add("");
        }
        ArrayList<String> arrayList4 = arrayList;
        return arrayList4.toArray(new String[arrayList4.size()]);
    }

    private boolean lastElementStartedWithQuoteButDidNotEndInOne(List<String> elements) {
        List<String> list = elements;
        String string = list.get(list.size() - 1);
        return string.startsWith(Character.toString(this.quotechar)) && !string.endsWith(Character.toString(this.quotechar));
    }

    private int findEndOfFieldFromPosition(String nextLine, int currentPosition) {
        int n2 = nextLine.indexOf(this.quotechar, currentPosition + 1);
        boolean bl = false;
        while (this.haveNotFoundLastQuote(nextLine, n2)) {
            if (!bl && nextLine.charAt(n2 + 1) == this.separator) {
                return n2 + 1;
            }
            do {
                n2 = nextLine.indexOf(this.quotechar, n2 + 1);
                boolean bl2 = bl = !bl;
            } while (this.haveNotFoundLastQuote(nextLine, n2) && nextLine.charAt(n2 + 1) == this.quotechar);
        }
        return nextLine.length();
    }

    private boolean haveNotFoundLastQuote(String nextLine, int nextQuote) {
        return nextQuote != -1 && nextQuote < nextLine.length() - 1;
    }

    private String handleQuotes(String element) {
        String string = element;
        String string2 = Character.toString(this.getQuotechar());
        if (StringUtils.startsWith(string, string2) && StringUtils.endsWith(string = StringUtils.removeStart(string, string2), string2)) {
            string = StringUtils.removeEnd(string, string2);
        }
        if ((string = StringUtils.replace(string, string2 + string2, string2)).isEmpty() && (this.nullFieldIndicator == CSVReaderNullFieldIndicator.BOTH || this.nullFieldIndicator == CSVReaderNullFieldIndicator.EMPTY_QUOTES)) {
            string = null;
        }
        return string;
    }

    @Override
    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }

    @Override
    public String getPendingText() {
        return StringUtils.defaultString(this.pending);
    }
}

