/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import com.opencsv.ResultSetHelperService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ResultSetColumnNameHelperService
extends ResultSetHelperService
implements ResultSetHelper {
    private String[] columnNames;
    private String[] columnHeaders;
    private final Map<String, Integer> columnNamePositionMap = new HashMap<String, Integer>();
    private Locale errorLocale = Locale.getDefault();

    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    public void setColumnNames(String[] columnNames, String[] columnHeaders) {
        if (columnHeaders.length != columnNames.length) {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("column.count.mismatch"));
        }
        if (this.hasInvalidValue(columnNames)) {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("column.name.bogus"));
        }
        if (this.hasInvalidValue(columnHeaders)) {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.name.bogus"));
        }
        this.columnNames = Arrays.copyOf(columnNames, columnNames.length);
        this.columnHeaders = Arrays.copyOf(columnHeaders, columnHeaders.length);
    }

    private boolean hasInvalidValue(String[] strings) {
        String[] stringArray = strings;
        int n2 = strings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (!StringUtils.isBlank(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getColumnNames(ResultSet rs) throws SQLException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        return Arrays.copyOf(this.columnHeaders, this.columnHeaders.length);
    }

    private void populateColumnData(ResultSet rs) throws SQLException {
        Object[] objectArray = super.getColumnNames(rs);
        if (this.columnNames == null) {
            this.columnNames = Arrays.copyOf(objectArray, objectArray.length);
            this.columnHeaders = Arrays.copyOf(objectArray, objectArray.length);
        }
        String[] stringArray = this.columnNames;
        int n2 = this.columnNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            int n3 = ArrayUtils.indexOf(objectArray, string);
            if (n3 == -1) {
                throw new UnsupportedOperationException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("column.nonexistant"), string));
            }
            this.columnNamePositionMap.put(string, n3);
        }
    }

    @Override
    public String[] getColumnValues(ResultSet rs) throws SQLException, IOException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        String[] stringArray = super.getColumnValues(rs, false, "dd-MMM-yyyy", "dd-MMM-yyyy HH:mm:ss");
        return this.getColumnValueSubset(stringArray);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim) throws SQLException, IOException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        String[] stringArray = super.getColumnValues(rs, trim, "dd-MMM-yyyy", "dd-MMM-yyyy HH:mm:ss");
        return this.getColumnValueSubset(stringArray);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim, String dateFormatString, String timeFormatString) throws SQLException, IOException {
        if (this.columnNamePositionMap.isEmpty()) {
            this.populateColumnData(rs);
        }
        String[] stringArray = super.getColumnValues(rs, trim, dateFormatString, timeFormatString);
        return this.getColumnValueSubset(stringArray);
    }

    private String[] getColumnValueSubset(String[] realColumnValues) {
        ArrayList<String> arrayList = new ArrayList<String>(realColumnValues.length);
        String[] stringArray = this.columnNames;
        int n2 = this.columnNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            arrayList.add(realColumnValues[this.columnNamePositionMap.get(string)]);
        }
        return arrayList.toArray(new String[this.columnNames.length]);
    }
}

