/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.BeanField;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.bean.opencsvUtils;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import com.opencsv.exceptions.CsvRuntimeException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ProcessCsvBean<T>
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<T> mappingStrategy;
    private final T bean;
    private final BlockingQueue<OrderedObject<String[]>> resultantLineQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;
    private final List<String> contents = new ArrayList<String>();
    private final Locale errorLocale;

    public ProcessCsvBean(long lineNumber, MappingStrategy<T> mappingStrategy, T bean, BlockingQueue<OrderedObject<String[]>> resultantLineQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions, Locale errorLocale) {
        this.lineNumber = lineNumber;
        this.mappingStrategy = mappingStrategy;
        this.bean = bean;
        this.resultantLineQueue = resultantLineQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    private void writeWithReflection(int numColumns) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        for (int i2 = 0; i2 <= numColumns; ++i2) {
            BeanField beanField = this.mappingStrategy.findField(i2);
            String string = beanField != null ? beanField.write(this.bean) : "";
            this.contents.add(StringUtils.defaultString(string));
        }
    }

    private void writeWithIntrospection(int numColumns) {
        for (int i2 = 0; i2 <= numColumns; ++i2) {
            try {
                PropertyDescriptor propertyDescriptor = this.mappingStrategy.findDescriptor(i2);
                Object object = propertyDescriptor != null ? propertyDescriptor.getReadMethod().invoke(this.bean, null) : null;
                this.contents.add(Objects.toString(object, ""));
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                CsvBeanIntrospectionException csvBeanIntrospectionException = new CsvBeanIntrospectionException(this.bean, null, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("error.introspecting.beans"));
                csvBeanIntrospectionException.initCause(reflectiveOperationException);
                throw csvBeanIntrospectionException;
            }
        }
    }

    @Override
    public void run() {
        try {
            int n2 = this.mappingStrategy.findMaxFieldIndex();
            if (this.mappingStrategy.isAnnotationDriven()) {
                this.writeWithReflection(n2);
            } else {
                this.writeWithIntrospection(n2);
            }
            opencsvUtils.queueRefuseToAcceptDefeat(this.resultantLineQueue, new OrderedObject<String[]>(this.lineNumber, this.contents.toArray(new String[this.contents.size()])));
            return;
        }
        catch (CsvException csvException) {
            CsvException csvException2 = csvException;
            CsvException csvException3 = csvException;
            csvException.setLineNumber(this.lineNumber);
            if (this.throwExceptions) {
                throw new RuntimeException(csvException3);
            }
            opencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, csvException3));
            return;
        }
        catch (CsvRuntimeException csvRuntimeException) {
            CsvRuntimeException csvRuntimeException2 = csvRuntimeException;
            throw csvRuntimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

