/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.ModelCategory;
import hex.genmodel.CategoricalEncoding;
import hex.genmodel.IGenModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Random;
import water.genmodel.IGeneratedModel;

public abstract class GenModel
implements IGenModel,
Serializable,
IGeneratedModel {
    public final String[] _names;
    public final String[][] _domains;
    public final String _responseColumn;
    public String _offsetColumn;

    public GenModel(String[] names, String[][] domains, String responseColumn) {
        this._names = names;
        this._domains = domains;
        this._responseColumn = responseColumn;
    }

    @Deprecated
    public GenModel(String[] names, String[][] domains) {
        this(names, domains, null);
    }

    public boolean requiresOffset() {
        return false;
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    @Override
    public int nfeatures() {
        return this._names.length;
    }

    public int nCatFeatures() {
        int n2 = 0;
        String[][] stringArray = this.getDomainValues();
        for (int i2 = 0; i2 < this.nfeatures(); ++i2) {
            if (stringArray[i2] == null) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public String[] features() {
        return Arrays.copyOf(this._names, this.nfeatures());
    }

    @Override
    public int nclasses() {
        return 0;
    }

    @Override
    public abstract ModelCategory getModelCategory();

    public String[] getOutputNames() {
        String[] stringArray;
        ModelCategory modelCategory = this.getModelCategory();
        switch (modelCategory) {
            case AutoEncoder: {
                int n2;
                LinkedList<String> linkedList = new LinkedList<String>();
                String[] stringArray2 = this.getNames();
                int n3 = this.nCatFeatures();
                String[][] stringArray3 = this.getDomainValues();
                for (n2 = 0; n2 <= n3 - 1; ++n2) {
                    String[] stringArray4 = stringArray3[n2];
                    int n4 = stringArray4.length - 1;
                    for (int i2 = 0; i2 <= n4; ++i2) {
                        linkedList.add("reconstr_" + stringArray2[n2] + "." + stringArray4[i2]);
                    }
                    linkedList.add("reconstr_" + stringArray2[n2] + ".missing(NA)");
                }
                for (n2 = n3; n2 < stringArray2.length; ++n2) {
                    linkedList.add("reconstr_" + stringArray2[n2]);
                }
                stringArray = linkedList.toArray(new String[0]);
                break;
            }
            case Binomial: 
            case Multinomial: 
            case Ordinal: {
                GenModel genModel = this;
                String[] stringArray5 = genModel.getDomainValues(genModel.getResponseIdx());
                String[] stringArray6 = new String[1 + stringArray5.length];
                stringArray = stringArray6;
                stringArray6[0] = "predict";
                System.arraycopy(stringArray5, 0, stringArray, 1, stringArray.length - 1);
                for (int i3 = 1; i3 < stringArray.length; ++i3) {
                    try {
                        Integer.valueOf(stringArray[i3]);
                        stringArray[i3] = "p" + stringArray[i3];
                        continue;
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case Clustering: {
                stringArray = new String[]{"cluster"};
                break;
            }
            case Regression: {
                stringArray = new String[]{"predict"};
                break;
            }
            case CoxPH: {
                stringArray = new String[]{"lp"};
                break;
            }
            default: {
                throw new UnsupportedOperationException("Getting output column names for model category '" + (Object)((Object)modelCategory) + "' is not supported.");
            }
        }
        return stringArray;
    }

    public String[][] getOutputDomains() {
        ModelCategory modelCategory = this.getModelCategory();
        String[][] stringArray = new String[this.getOutputNames().length][];
        switch (modelCategory) {
            case Binomial: 
            case Multinomial: 
            case Ordinal: {
                GenModel genModel = this;
                stringArray[0] = genModel.getDomainValues(genModel.getResponseIdx());
                break;
            }
            case Regression: {
                stringArray[0] = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Getting output domains for model category '" + (Object)((Object)modelCategory) + "' is not yet supported.");
            }
        }
        return stringArray;
    }

    @Override
    public EnumSet<ModelCategory> getModelCategories() {
        return EnumSet.of(this.getModelCategory());
    }

    @Override
    public abstract String getUUID();

    @Override
    public int getNumCols() {
        return this.nfeatures();
    }

    @Override
    public String[] getNames() {
        return this._names;
    }

    public int getOrigNumCols() {
        String[] stringArray = this.getOrigNames();
        if (stringArray == null || stringArray.length == 0) {
            return 0;
        }
        boolean bl = false;
        if (this.isSupervised()) {
            String string = this.getResponseName();
            bl = stringArray[stringArray.length - 1].equals(string);
        }
        if (bl) {
            return stringArray.length - 1;
        }
        return stringArray.length;
    }

    @Override
    public String[] getOrigNames() {
        return null;
    }

    @Override
    public String getResponseName() {
        int n2 = this.getResponseIdx();
        if (n2 < this._names.length) {
            return this._names[n2];
        }
        return this._responseColumn;
    }

    @Override
    public int getResponseIdx() {
        if (!this.isSupervised()) {
            throw new UnsupportedOperationException("Cannot provide response index for unsupervised models.");
        }
        return this._domains.length - 1;
    }

    @Override
    public String getOffsetName() {
        return this._offsetColumn;
    }

    @Override
    public int getNumClasses(int colIdx) {
        String[] stringArray = this.getDomainValues(colIdx);
        if (stringArray != null) {
            return stringArray.length;
        }
        return -1;
    }

    @Override
    public int getNumResponseClasses() {
        if (!this.isClassifier()) {
            throw new UnsupportedOperationException("Cannot provide number of response classes for non-classifiers.");
        }
        return this.nclasses();
    }

    @Override
    public CategoricalEncoding getCategoricalEncoding() {
        return CategoricalEncoding.AUTO;
    }

    @Override
    public boolean isClassifier() {
        ModelCategory modelCategory = this.getModelCategory();
        return modelCategory == ModelCategory.Binomial || modelCategory == ModelCategory.Multinomial || modelCategory == ModelCategory.Ordinal;
    }

    @Override
    public boolean isAutoEncoder() {
        return this.getModelCategory() == ModelCategory.AutoEncoder;
    }

    @Override
    public String[] getDomainValues(String name) {
        int n2 = this.getColIdx(name);
        if (n2 != -1) {
            return this.getDomainValues(n2);
        }
        return null;
    }

    @Override
    public String[] getDomainValues(int i2) {
        return this.getDomainValues()[i2];
    }

    @Override
    public String[][] getDomainValues() {
        return this._domains;
    }

    @Override
    public String[][] getOrigDomainValues() {
        return null;
    }

    @Override
    public double[] getOrigProjectionArray() {
        return null;
    }

    @Override
    public int getColIdx(String name) {
        String[] stringArray = this.getNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(name)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int mapEnum(int colIdx, String enumValue) {
        String[] stringArray = this.getDomainValues(colIdx);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!enumValue.equals(stringArray[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public int getPredsSize() {
        if (this.isClassifier()) {
            return 1 + this.getNumResponseClasses();
        }
        return 2;
    }

    public int getPredsSize(ModelCategory mc) {
        if (mc == ModelCategory.DimReduction) {
            return this.nclasses();
        }
        return this.getPredsSize();
    }

    public static String createAuxKey(String k2) {
        return k2 + ".aux";
    }

    public abstract double[] score0(double[] var1, double[] var2);

    public double[] score0(double[] row, double offset, double[] preds) {
        throw new UnsupportedOperationException("`offset` column is not supported");
    }

    public boolean calibrateClassProbabilities(double[] preds) {
        return false;
    }

    public static double[] correctProbabilities(double[] scored, double[] priorClassDist, double[] modelClassDist) {
        int n2;
        double d2 = 0.0;
        for (n2 = 1; n2 < scored.length; ++n2) {
            double d3 = priorClassDist[n2 - 1];
            double d4 = modelClassDist[n2 - 1];
            assert (!Double.isNaN(scored[n2])) : "Predicted NaN class probability";
            if (d3 != 0.0 && d4 != 0.0) {
                int n3 = n2;
                scored[n3] = scored[n3] * (d3 / d4);
            }
            d2 += scored[n2];
        }
        if (d2 > 0.0) {
            n2 = 1;
            while (n2 < scored.length) {
                int n4 = n2++;
                scored[n4] = scored[n4] / d2;
            }
        }
        return scored;
    }

    public static int getPrediction(double[] preds, double[] priorClassDist, double[] data, double threshold) {
        if (preds.length == 3) {
            return GenModel.getPredictionBinomial(preds, threshold);
        }
        return GenModel.getPredictionMultinomial(preds, priorClassDist, data);
    }

    public static int getPredictionBinomial(double[] preds, double threshold) {
        if (preds[2] >= threshold) {
            return 1;
        }
        return 0;
    }

    public static int getPredictionMultinomial(double[] preds, double[] priorClassDist, double[] data) {
        double d2;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        int n3 = 1;
        int n4 = 0;
        for (int i2 = 2; i2 < preds.length; ++i2) {
            if (preds[n3] < preds[i2]) {
                n3 = i2;
                n4 = 0;
                continue;
            }
            if (preds[n3] != preds[i2]) continue;
            ++n4;
            arrayList.add(i2 - 1);
        }
        if (n4 == 0) {
            return n3 - 1;
        }
        long l2 = 0L;
        if (data != null) {
            double[] dArray = data;
            int n5 = data.length;
            for (n2 = 0; n2 < n5; ++n2) {
                d2 = dArray[n2];
                l2 ^= Double.doubleToRawLongBits(d2) >> 6;
            }
        }
        if (priorClassDist != null) {
            assert (preds.length == priorClassDist.length + 1);
            double d3 = 0.0;
            for (Integer n6 : arrayList) {
                d3 += priorClassDist[n6];
            }
            Random random = new Random(l2);
            d2 = random.nextDouble();
            double d4 = 0.0;
            for (Integer n7 : arrayList) {
                if (!(d2 <= (d4 += priorClassDist[n7] / d3))) continue;
                return n7;
            }
        }
        double d5 = preds[n3];
        n2 = (int)l2 % (n4 + 1);
        for (n3 = 1; n3 < preds.length; ++n3) {
            if (d5 != preds[n3] || --n2 >= 0) continue;
            return n3 - 1;
        }
        throw new RuntimeException("Should Not Reach Here");
    }

    public static boolean bitSetContains(byte[] bits, int nbits, int bitoff, double dnum) {
        assert (!Double.isNaN(dnum));
        int n2 = (int)dnum;
        assert ((n2 -= bitoff) >= 0 && n2 < nbits) : "Must have " + bitoff + " <= idx <= " + (bitoff + nbits - 1) + ": " + n2;
        return (bits[n2 >> 3] & 1 << (n2 & 7)) != 0;
    }

    public static boolean bitSetIsInRange(int nbits, int bitoff, double dnum) {
        assert (!Double.isNaN(dnum));
        int n2 = (int)dnum;
        return (n2 -= bitoff) >= 0 && n2 < nbits;
    }

    public static void Kmeans_preprocessData(double[] data, double[] means, double[] mults, int[] modes) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = GenModel.Kmeans_preprocessData(data[i2], i2, means, mults, modes);
        }
    }

    public static double Kmeans_preprocessData(double d2, int i2, double[] means, double[] mults, int[] modes) {
        if (modes[i2] == -1) {
            if (Double.isNaN(d2)) {
                d2 = means[i2];
            }
            if (mults != null) {
                d2 -= means[i2];
                d2 *= mults[i2];
            }
        } else if (Double.isNaN(d2)) {
            d2 = modes[i2];
        }
        return d2;
    }

    public static int KMeans_closest(double[][] centers, double[] point, String[][] domains) {
        int n2 = -1;
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < centers.length; ++i2) {
            double d3;
            double d4 = GenModel.KMeans_distance(centers[i2], point, domains);
            if (!(d3 < d2)) continue;
            n2 = i2;
            d2 = d4;
        }
        return n2;
    }

    public static int KMeans_distances(double[][] centers, double[] point, String[][] domains, double[] distances) {
        int n2 = -1;
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < centers.length; ++i2) {
            distances[i2] = GenModel.KMeans_distance(centers[i2], point, domains);
            if (!(distances[i2] < d2)) continue;
            n2 = i2;
            d2 = distances[i2];
        }
        return n2;
    }

    public static double[] KMeans_simplex(double[][] centers, double[] point, String[][] domains) {
        double[] dArray = new double[centers.length];
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < centers.length; ++i2) {
            dArray[i2] = GenModel.KMeans_distance(centers[i2], point, domains);
            d2 += dArray[i2];
            d3 += 1.0 / dArray[i2];
        }
        double[] dArray2 = new double[centers.length];
        if (d2 == 0.0) {
            Random random = new Random();
            int n2 = random.nextInt(centers.length);
            dArray2[n2] = 1.0;
        } else {
            int n3;
            int n4 = -1;
            for (n3 = 0; n3 < centers.length; ++n3) {
                if (dArray[n3] != 0.0) continue;
                n4 = n3;
                break;
            }
            if (n4 == -1) {
                for (n3 = 0; n3 < centers.length; ++n3) {
                    dArray2[n3] = 1.0 / (dArray[n3] * d3);
                }
            } else {
                dArray2[n4] = 1.0;
            }
        }
        return dArray2;
    }

    public static double KMeans_distance(double[] center, float[] point, int[] modes, double[] colSum, double[] colSumSq) {
        double d2 = 0.0;
        int n2 = point.length;
        for (int i2 = 0; i2 < center.length; ++i2) {
            double d3;
            float f2 = point[i2];
            if (Float.isNaN(f2)) {
                --n2;
                continue;
            }
            if (modes[i2] != -1) {
                if ((double)f2 != center[i2]) {
                    d2 += 1.0;
                }
                if (f2 == (float)modes[i2]) continue;
                int n3 = i2;
                colSum[n3] = colSum[n3] + 1.0;
                continue;
            }
            double d4 = d3 = (double)f2 - center[i2];
            d2 += d4 * d4;
            int n4 = i2;
            colSum[n4] = colSum[n4] + (double)f2;
            int n5 = i2;
            float f3 = f2;
            colSumSq[n5] = colSumSq[n5] + (double)(f3 * f3);
        }
        if (n2 > 0 && n2 < point.length) {
            double d5 = (double)point.length / (double)n2;
            d2 *= d5;
        }
        return d2;
    }

    public static double KMeans_distance(double[] center, double[] point, String[][] domains) {
        double d2 = 0.0;
        int n2 = point.length;
        for (int i2 = 0; i2 < center.length; ++i2) {
            double d3;
            double d4 = point[i2];
            if (Double.isNaN(d4)) {
                --n2;
                continue;
            }
            if (domains[i2] != null) {
                if (d4 == center[i2]) continue;
                d2 += 1.0;
                continue;
            }
            double d5 = d3 = d4 - center[i2];
            d2 += d5 * d5;
        }
        if (n2 > 0 && n2 < point.length) {
            d2 *= (double)point.length / (double)n2;
        }
        return d2;
    }

    public static double log_rescale(double[] preds) {
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i2 = 1; i2 < preds.length; ++i2) {
            d2 = Math.max(d2, preds[i2]);
        }
        assert (!Double.isInfinite(d2)) : "Something is wrong with GBM trees since returned prediction is " + Arrays.toString(preds);
        double d3 = 0.0;
        for (int i3 = 1; i3 < preds.length; ++i3) {
            preds[i3] = Math.exp(preds[i3] - d2);
            d3 += preds[i3];
        }
        return d3;
    }

    public static void GBM_rescale(double[] preds) {
        double d2 = GenModel.log_rescale(preds);
        int n2 = 1;
        while (n2 < preds.length) {
            int n3 = n2++;
            preds[n3] = preds[n3] / d2;
        }
    }

    public static double GLM_identityInv(double x2) {
        return x2;
    }

    public static double GLM_logitInv(double x2) {
        return 1.0 / (Math.exp(-x2) + 1.0);
    }

    public static double GLM_logInv(double x2) {
        return Math.exp(x2);
    }

    public static double GLM_inverseInv(double x2) {
        double d2 = x2 < 0.0 ? Math.min(-1.0E-5, x2) : Math.max(1.0E-5, x2);
        return 1.0 / d2;
    }

    public static double GLM_ologitInv(double x2) {
        return GenModel.GLM_logitInv(x2);
    }

    public static double GLM_tweedieInv(double x2, double tweedie_link_power) {
        if (tweedie_link_power == 0.0) {
            return Math.max(2.0E-16, Math.exp(x2));
        }
        return Math.pow(x2, 1.0 / tweedie_link_power);
    }

    public String getHeader() {
        return null;
    }

    public static void setInput(double[] from, float[] to, int _nums, int _cats, int[] _catOffsets, double[] _normMul, double[] _normSub, boolean useAllFactorLevels, boolean replaceMissingWithZero) {
        int n2;
        double[] dArray = new double[_nums];
        int[] nArray = new int[_cats];
        GenModel.setCats(from, dArray, nArray, _cats, _catOffsets, _normMul, _normSub, useAllFactorLevels);
        assert (to.length == _nums + _catOffsets[_cats]);
        Arrays.fill(to, 0.0f);
        for (n2 = 0; n2 < _cats; ++n2) {
            if (nArray[n2] < 0) continue;
            to[nArray[n2]] = 1.0f;
        }
        for (n2 = 0; n2 < _nums; ++n2) {
            to[_catOffsets[_cats] + n2] = Double.isNaN(dArray[n2]) ? (replaceMissingWithZero ? 0.0f : Float.NaN) : (float)dArray[n2];
        }
    }

    public static void setInput(double[] from, double[] to, double[] nums, int[] cats, int _nums, int _cats, int[] _catOffsets, double[] _normMul, double[] _normSub, boolean useAllFactorLevels, boolean replaceMissingWithZero) {
        int n2;
        GenModel.setCats(from, nums, cats, _cats, _catOffsets, _normMul, _normSub, useAllFactorLevels);
        assert (to.length == _nums + _catOffsets[_cats]);
        Arrays.fill(to, 0.0);
        for (n2 = 0; n2 < _cats; ++n2) {
            if (cats[n2] < 0) continue;
            to[cats[n2]] = 1.0;
        }
        for (n2 = 0; n2 < _nums; ++n2) {
            to[_catOffsets[_cats] + n2] = Double.isNaN(nums[n2]) ? (replaceMissingWithZero ? 0.0 : Double.NaN) : nums[n2];
        }
    }

    public static void setCats(double[] from, double[] nums, int[] cats, int _cats, int[] _catOffsets, double[] _normMul, double[] _normSub, boolean useAllFactorLevels) {
        GenModel.setCats(from, cats, _cats, _catOffsets, useAllFactorLevels);
        for (int i2 = _cats; i2 < from.length; ++i2) {
            double d2 = from[i2];
            if (_normMul != null && _normMul.length > 0) {
                d2 = (d2 - _normSub[i2 - _cats]) * _normMul[i2 - _cats];
            }
            nums[i2 - _cats] = d2;
        }
    }

    public static void setCats(double[] from, int[] to, int cats, int[] catOffsets, boolean useAllFactorLevels) {
        for (int i2 = 0; i2 < cats; ++i2) {
            if (Double.isNaN(from[i2])) {
                to[i2] = catOffsets[i2 + 1] - 1;
                continue;
            }
            int n2 = (int)from[i2];
            to[i2] = useAllFactorLevels ? n2 + catOffsets[i2] : (n2 != 0 ? n2 - 1 + catOffsets[i2] : -1);
            if (to[i2] < catOffsets[i2 + 1]) continue;
            to[i2] = catOffsets[i2 + 1] - 1;
        }
    }

    public static float[] convertDouble2Float(double[] input) {
        int n2 = input.length;
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = (float)input[i2];
        }
        return fArray;
    }

    public static void img2pixels(BufferedImage img, int w2, int h2, int channels, float[] pixels, int start, float[] mean) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(w2, h2, img.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(img, 0, 0, w2, h2, null);
        graphics2D.dispose();
        int n2 = start;
        int n3 = start + w2 * h2;
        int n4 = n3 + w2 * h2;
        for (int i2 = 0; i2 < h2; ++i2) {
            for (int i3 = 0; i3 < w2; ++i3) {
                Color color = new Color(bufferedImage.getRGB(i3, i2));
                int n5 = color.getRed();
                int n6 = color.getGreen();
                int n7 = color.getBlue();
                if (channels == 1) {
                    pixels[n2] = (n5 + n6 + n7) / 3;
                    if (mean != null) {
                        int n8 = n2;
                        pixels[n8] = pixels[n8] - mean[n2];
                    }
                } else {
                    pixels[n2] = n5;
                    pixels[n3] = n6;
                    pixels[n4] = n7;
                    if (mean != null) {
                        int n9 = n2;
                        pixels[n9] = pixels[n9] - mean[n2 - start];
                        int n10 = n3;
                        pixels[n10] = pixels[n10] - mean[n3 - start];
                        int n11 = n4;
                        pixels[n11] = pixels[n11] - mean[n4 - start];
                    }
                }
                ++n2;
                ++n3;
                ++n4;
            }
        }
    }

    @Deprecated
    public GenModel internal_threadSafeInstance() {
        return this;
    }
}

