/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

public class GamUtilsISplines {
    public static double[] fillKnots(double[] knots, int m2) {
        int n2;
        int n3 = knots.length + 2 * m2 - 2;
        double[] dArray = new double[n3];
        int n4 = m2 > 0 ? m2 - 1 : 0;
        for (n2 = 0; n2 < n4; ++n2) {
            dArray[n2] = knots[0];
        }
        n2 = knots.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2 + n4] = knots[i2];
        }
        double d2 = knots[knots.length - 1];
        for (int i3 = n2 + n4; i3 < n3; ++i3) {
            dArray[i3] = d2;
        }
        return dArray;
    }

    public static double[] extractKnots(int index, int order, double[] knots) {
        double[] dArray = new double[order + 1];
        int n2 = Math.min(index + order, knots.length - 1);
        int n3 = 0;
        for (int i2 = index; i2 <= n2; ++i2) {
            dArray[n3++] = knots[i2];
        }
        return dArray;
    }

    static double[] formNumerator(int order, double[] knots) {
        double[] dArray = new double[2];
        if (order == 1) {
            dArray[0] = 1.0;
            dArray[1] = 1.0;
        } else {
            dArray[0] = knots[0];
            dArray[1] = knots[order];
        }
        return dArray;
    }

    static double[] formDenominator(int order, double[] knots) {
        double d2;
        int n2;
        double[] dArray;
        double[] dArray2 = new double[2];
        if (order == 1) {
            dArray2[0] = 1.0;
            dArray = dArray2;
            n2 = 1;
            d2 = 1.0;
        } else {
            double d3 = knots[order - 1] - knots[0];
            dArray2[0] = d3 == 0.0 ? 0.0 : 1.0 / d3;
            d3 = knots[order] - knots[1];
            dArray = dArray2;
            n2 = 1;
            d2 = d3 == 0.0 ? 0.0 : 1.0 / d3;
        }
        dArray[n2] = d2;
        return dArray2;
    }
}

