/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.algos.gam.GamUtilsISplines;
import hex.genmodel.algos.gam.NBSplinesTypeII;
import java.io.Serializable;

public class ISplines
implements Serializable {
    private final double[] _knotsWDuplicates;
    private final int _order;
    public int _numIBasis;
    NBSplinesTypeII _bSplines;
    private final ISplineBasis[] _iSplines;

    public ISplines(int order, double[] knots) {
        this._knotsWDuplicates = GamUtilsISplines.fillKnots(knots, order);
        this._order = order;
        this._bSplines = new NBSplinesTypeII(order + 1, knots);
        this._numIBasis = knots.length + order - 2;
        this._iSplines = new ISplineBasis[this._numIBasis];
        for (int i2 = 0; i2 < this._numIBasis; ++i2) {
            this._iSplines[i2] = new ISplineBasis(i2, this._order, this._knotsWDuplicates);
        }
    }

    public void gamifyVal(double[] gamifiedResults, double val) {
        if (gamifiedResults == null) {
            gamifiedResults = new double[this._numIBasis];
        }
        for (int i2 = 0; i2 < this._numIBasis; ++i2) {
            gamifiedResults[i2] = val < this._iSplines[i2]._knots[0] ? 0.0 : (val >= this._iSplines[i2]._knots[this._order] ? 1.0 : this.sumNBSpline(i2 + 1, val));
        }
    }

    public double sumNBSpline(int startIndex, double val) {
        double d2 = 0.0;
        int n2 = this._bSplines._basisFuncs.length;
        for (int i2 = startIndex; i2 < n2 && !(val < this._bSplines._basisFuncs[i2]._knots[0]); ++i2) {
            if (val >= this._bSplines._basisFuncs[i2]._knots[this._bSplines._order]) {
                d2 += 1.0;
                continue;
            }
            d2 += NBSplinesTypeII.BSplineBasis.evaluate(val, this._bSplines._basisFuncs[i2]);
        }
        return d2;
    }

    private static class ISplineBasis
    implements Serializable {
        private double[] _knots;
        private int _NSplineBasisStartIndex;
        private int _order;

        public ISplineBasis(int basisInd, int order, double[] knots) {
            this._NSplineBasisStartIndex = basisInd;
            this._order = order;
            this._knots = GamUtilsISplines.extractKnots(basisInd, order, knots);
        }
    }
}

