/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.isoforextended;

import hex.genmodel.MojoModel;
import hex.genmodel.algos.tree.ScoreIsolationTree;
import hex.genmodel.algos.tree.ScoreIsolationTree0;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.genmodel.utils.MathUtils;

public final class ExtendedIsolationForestMojoModel
extends MojoModel {
    public static final int NODE = 78;
    public static final int LEAF = 76;
    int _ntrees;
    long _sample_size;
    byte[][] _compressedTrees;
    private ScoreIsolationTree _scoreIsolationTree;

    public ExtendedIsolationForestMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    public final void postInit() {
        this._scoreIsolationTree = new ScoreIsolationTree0();
    }

    @Override
    public final double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }

    @Override
    public final double[] score0(double[] row, double offset, double[] preds) {
        double d2;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this._ntrees; ++i2) {
            double d4 = this._scoreIsolationTree.scoreTree(this._compressedTrees[i2], row);
            d3 += d4;
        }
        preds[0] = d2 = ExtendedIsolationForestMojoModel.anomalyScore(d3 /= (double)this._ntrees, this._sample_size);
        preds[1] = d3;
        return preds;
    }

    @Override
    public final int getPredsSize() {
        return 2;
    }

    @Override
    public final String[] getOutputNames() {
        return new String[]{"anomaly_score", "mean_length"};
    }

    public static double scoreTree0(byte[] isolationTree, double[] row) {
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(isolationTree);
        int n2 = byteBufferWrapper.get4();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 2 * n2 << 3;
        double d2 = -1.0;
        while (byteBufferWrapper.hasRemaining()) {
            int n6 = byteBufferWrapper.get4();
            int n7 = byteBufferWrapper.get1U();
            if (n6 != n4) {
                if (n7 == 78) {
                    byteBufferWrapper.skip(n5);
                    continue;
                }
                if (n7 == 76) {
                    byteBufferWrapper.skip(4);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown node type: " + n7);
            }
            if (n7 == 78) {
                double d3;
                ExtendedIsolationForestMojoModel.loadNode(byteBufferWrapper, dArray, dArray2);
                double d4 = ArrayUtils.subAndMul(row, dArray2, dArray);
                if (d3 <= 0.0) {
                    ++n3;
                    n4 = ExtendedIsolationForestMojoModel.leftChildIndex(n6);
                    continue;
                }
                ++n3;
                n4 = ExtendedIsolationForestMojoModel.rightChildIndex(n6);
                continue;
            }
            if (n7 == 76) {
                int n8 = byteBufferWrapper.get4();
                d2 = (double)n3 + ExtendedIsolationForestMojoModel.averagePathLengthOfUnsuccessfulSearch(n8);
                break;
            }
            throw new UnsupportedOperationException("Unknown node type: " + n7);
        }
        return d2;
    }

    private static void loadNode(ByteBufferWrapper ab, double[] n2, double[] p2) {
        int n3;
        for (n3 = 0; n3 < n2.length; ++n3) {
            n2[n3] = ab.get8d();
        }
        for (n3 = 0; n3 < n2.length; ++n3) {
            p2[n3] = ab.get8d();
        }
    }

    public static int leftChildIndex(int i2) {
        return 2 * i2 + 1;
    }

    public static int rightChildIndex(int i2) {
        return 2 * i2 + 2;
    }

    public static double anomalyScore(double pathLength, long sample_size) {
        return Math.pow(2.0, -1.0 * (pathLength / ExtendedIsolationForestMojoModel.averagePathLengthOfUnsuccessfulSearch(sample_size)));
    }

    public static double averagePathLengthOfUnsuccessfulSearch(long n2) {
        if (n2 < 2L) {
            return 0.0;
        }
        if (n2 == 2L) {
            return 1.0;
        }
        return 2.0 * MathUtils.harmonicNumberEstimation(n2 - 1L) - 2.0 * ((double)n2 - 1.0) / (double)n2;
    }
}

