/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.utils.ArrayUtils;
import java.util.Arrays;

public class ContributionComposer {
    public final int[] composeContributions(int[] contribNameIds, float[] contribs, int topN, int bottomN, boolean compareAbs) {
        assert (contribNameIds.length == contribs.length) : "contribNameIds must have the same length as contribs";
        if (this.returnOnlyTopN(topN, bottomN)) {
            return this.composeSortedContributions(contribNameIds, contribs, topN, compareAbs, -1);
        }
        if (this.returnOnlyBottomN(topN, bottomN)) {
            return this.composeSortedContributions(contribNameIds, contribs, bottomN, compareAbs, 1);
        }
        if (this.returnAllTopN(topN, bottomN, contribs.length)) {
            return this.composeSortedContributions(contribNameIds, contribs, contribs.length, compareAbs, -1);
        }
        this.composeSortedContributions(contribNameIds, contribs, contribNameIds.length, compareAbs, -1);
        int[] nArray = Arrays.copyOfRange(contribNameIds, contribNameIds.length - 1 - bottomN, contribNameIds.length);
        this.reverse(nArray, contribs, nArray.length - 1);
        int[] nArray2 = Arrays.copyOf(contribNameIds, topN);
        return ArrayUtils.append(nArray2, nArray);
    }

    private boolean returnOnlyTopN(int topN, int bottomN) {
        return topN != 0 && bottomN == 0;
    }

    private boolean returnOnlyBottomN(int topN, int bottomN) {
        return topN == 0 && bottomN != 0;
    }

    private boolean returnAllTopN(int topN, int bottomN, int len) {
        return topN + bottomN >= len || topN < 0 || bottomN < 0;
    }

    public int checkAndAdjustInput(int n2, int len) {
        if (n2 < 0 || n2 > len) {
            return len;
        }
        return n2;
    }

    private int[] composeSortedContributions(int[] contribNameIds, float[] contribs, int n2, boolean compareAbs, int increasing) {
        int n3 = this.checkAndAdjustInput(n2, contribs.length);
        this.sortContributions(contribNameIds, contribs, compareAbs, increasing);
        if (n3 < contribs.length) {
            int n4 = contribNameIds[contribs.length - 1];
            int[] nArray = Arrays.copyOfRange(contribNameIds, 0, n3 + 1);
            int[] nArray2 = nArray;
            nArray[n3] = n4;
            return nArray2;
        }
        return contribNameIds;
    }

    private void sortContributions(int[] contribNameIds, float[] contribs, boolean compareAbs, int increasing) {
        ArrayUtils.sort(contribNameIds, contribs, 0, contribs.length - 1, compareAbs, increasing);
    }

    private void reverse(int[] contribNameIds, float[] contribs, int len) {
        for (int i2 = 0; i2 < len / 2; ++i2) {
            if (contribs[contribNameIds[i2]] == contribs[contribNameIds[len - i2 - 1]]) continue;
            int n2 = contribNameIds[i2];
            contribNameIds[i2] = contribNameIds[len - i2 - 1];
            contribNameIds[len - i2 - 1] = n2;
        }
    }
}

