/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import ai.h2o.a.a.a;
import ai.h2o.a.a.b;
import hex.genmodel.tools.PrintMojo;
import hex.genmodel.utils.GenmodelBitSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SharedTreeNode
implements a<double[]>,
b {
    final int internalId;
    final SharedTreeNode parent;
    final int subgraphNumber;
    int nodeNumber;
    float weight;
    final int depth;
    int colId;
    String colName;
    boolean leftward;
    boolean naVsRest;
    float splitValue = Float.NaN;
    String[] domainValues;
    GenmodelBitSet bs;
    float predValue = Float.NaN;
    float squaredError = Float.NaN;
    SharedTreeNode leftChild;
    public SharedTreeNode rightChild;
    float gain = Float.NaN;
    private boolean inclusiveNa;
    private BitSet inclusiveLevels;

    SharedTreeNode(int id, SharedTreeNode p2, int sn, int d2) {
        this.internalId = id;
        this.parent = p2;
        this.subgraphNumber = sn;
        this.depth = d2;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    public void setNodeNumber(int id) {
        this.nodeNumber = id;
    }

    public void setWeight(float w2) {
        this.weight = w2;
    }

    public void setCol(int v1, String v2) {
        this.colId = v1;
        this.colName = v2;
    }

    public int getColId() {
        return this.colId;
    }

    public void setLeftward(boolean v2) {
        this.leftward = v2;
    }

    void setNaVsRest(boolean v2) {
        this.naVsRest = v2;
    }

    public void setSplitValue(float v2) {
        this.splitValue = v2;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    void setBitset(String[] v1, GenmodelBitSet v2) {
        assert (v1 != null);
        this.domainValues = v1;
        this.bs = v2;
    }

    public void setPredValue(float v2) {
        this.predValue = v2;
    }

    public void setSquaredError(float v2) {
        this.squaredError = v2;
    }

    private boolean findInclusiveNa(int colIdToFind) {
        while (this_.parent != null) {
            if (this_.parent.getColId() == colIdToFind) {
                return this_.inclusiveNa;
            }
            SharedTreeNode this_ = this_.parent;
        }
        return true;
    }

    private boolean calculateChildInclusiveNa(boolean includeThisSplitEdge) {
        SharedTreeNode sharedTreeNode = this;
        return sharedTreeNode.findInclusiveNa(sharedTreeNode.colId) && includeThisSplitEdge;
    }

    private BitSet findInclusiveLevels(int colIdToFind) {
        while (this_.parent != null) {
            if (this_.parent.getColId() == colIdToFind) {
                return this_.inclusiveLevels;
            }
            SharedTreeNode this_ = this_.parent;
        }
        return null;
    }

    private boolean calculateIncludeThisLevel(BitSet inheritedInclusiveLevels, int i2) {
        if (inheritedInclusiveLevels == null) {
            return true;
        }
        return inheritedInclusiveLevels.get(i2);
    }

    private BitSet calculateChildInclusiveLevels(boolean includeAllLevels, boolean discardAllLevels, boolean nodeBitsetDoesContain) {
        SharedTreeNode sharedTreeNode = this;
        BitSet bitSet = sharedTreeNode.findInclusiveLevels(sharedTreeNode.colId);
        BitSet bitSet2 = new BitSet();
        for (int i2 = 0; i2 < this.domainValues.length; ++i2) {
            boolean bl = false;
            if (discardAllLevels) {
                bl = false;
            } else if (includeAllLevels) {
                bl = this.calculateIncludeThisLevel(bitSet, i2);
            } else if (!Float.isNaN(this.splitValue)) {
                bl = this.splitValue < (float)i2 ^ !nodeBitsetDoesContain;
            } else if (this.bs.isInRange(i2) && this.bs.contains(i2) == nodeBitsetDoesContain) {
                bl = this.calculateIncludeThisLevel(bitSet, i2);
            }
            if (!bl) continue;
            bitSet2.set(i2);
        }
        return bitSet2;
    }

    void setLeftChild(SharedTreeNode v2) {
        this.leftChild = v2;
        SharedTreeNode sharedTreeNode = this;
        boolean bl = sharedTreeNode.calculateChildInclusiveNa(sharedTreeNode.leftward);
        v2.setInclusiveNa(bl);
        if (!this.isBitset()) {
            return;
        }
        SharedTreeNode sharedTreeNode2 = this;
        BitSet bitSet = sharedTreeNode2.calculateChildInclusiveLevels(sharedTreeNode2.naVsRest, false, false);
        v2.setInclusiveLevels(bitSet);
    }

    void setRightChild(SharedTreeNode v2) {
        this.rightChild = v2;
        SharedTreeNode sharedTreeNode = this;
        boolean bl = sharedTreeNode.calculateChildInclusiveNa(!sharedTreeNode.leftward);
        v2.setInclusiveNa(bl);
        if (!this.isBitset()) {
            return;
        }
        BitSet bitSet = this.calculateChildInclusiveLevels(false, this.naVsRest, true);
        v2.setInclusiveLevels(bitSet);
    }

    public void setInclusiveNa(boolean v2) {
        this.inclusiveNa = v2;
    }

    public boolean getInclusiveNa() {
        return this.inclusiveNa;
    }

    private void setInclusiveLevels(BitSet v2) {
        this.inclusiveLevels = v2;
    }

    public BitSet getInclusiveLevels() {
        return this.inclusiveLevels;
    }

    public String getName() {
        return "Node " + this.nodeNumber;
    }

    public void print() {
        this.print(System.out, null);
    }

    public void print(PrintStream out, String description) {
        out.print(this.getPrintString(description));
    }

    public String getPrintString(String description) {
        return "        Node " + this.nodeNumber + (description != null ? " (" + description + ")" : "") + "\n            weight:      " + this.weight + "\n            depth:       " + this.depth + "\n            colId:       " + this.colId + "\n            colName:     " + (this.colName != null ? this.colName : "") + "\n            leftward:    " + this.leftward + "\n            naVsRest:    " + this.naVsRest + "\n            splitVal:    " + this.splitValue + "\n            isBitset:    " + this.isBitset() + "\n            predValue:   " + this.predValue + "\n            squaredErr:  " + this.squaredError + "\n            leftChild:   " + (this.leftChild != null ? this.leftChild.getName() : "") + "\n            rightChild:  " + (this.rightChild != null ? this.rightChild.getName() : "");
    }

    void printEdges() {
        if (this.leftChild != null) {
            System.out.println("        " + this.getName() + " ---left---> " + this.leftChild.getName());
            this.leftChild.printEdges();
        }
        if (this.rightChild != null) {
            System.out.println("        " + this.getName() + " ---right--> " + this.rightChild.getName());
            this.rightChild.printEdges();
        }
    }

    private String getDotName() {
        return "SG_" + this.subgraphNumber + "_Node_" + this.nodeNumber;
    }

    public boolean isBitset() {
        return this.domainValues != null;
    }

    public static String escapeQuotes(String s2) {
        return s2.replace("\"", "\\\"");
    }

    private void printDotNode(PrintStream os, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        float f2;
        os.print("\"" + this.getDotName() + "\"");
        os.print(" [");
        if (this.leftChild == null && this.rightChild == null) {
            os.print("fontsize=" + treeOptions._fontSize + ", label=\"");
            f2 = treeOptions._setDecimalPlace ? treeOptions.roundNPlace(this.predValue) : this.predValue;
            os.print(f2);
        } else if (this.isBitset() && (Float.isNaN(this.splitValue) || !treeOptions._internal)) {
            os.print("shape=box, fontsize=" + treeOptions._fontSize + ", label=\"");
            os.print(SharedTreeNode.escapeQuotes(this.colName));
        } else {
            assert (!Float.isNaN(this.splitValue));
            f2 = treeOptions._setDecimalPlace ? treeOptions.roundNPlace(this.splitValue) : this.splitValue;
            os.print("shape=box, fontsize=" + treeOptions._fontSize + ", label=\"");
            os.print(SharedTreeNode.escapeQuotes(this.colName) + " < " + f2);
        }
        if (detail) {
            os.print("\\n\\nN" + this.getNodeNumber() + "\\n");
            if (!(this.leftChild == null && this.rightChild == null || Float.isNaN(this.predValue))) {
                f2 = treeOptions._setDecimalPlace ? treeOptions.roundNPlace(this.predValue) : this.predValue;
                os.print("\\nPred: " + f2);
            }
            if (!Float.isNaN(this.squaredError)) {
                os.print("\\nSE: " + this.squaredError);
            }
            os.print("\\nW: " + this.getWeight());
            if (this.naVsRest) {
                os.print("\\nnasVsRest");
            }
            if (this.leftChild != null) {
                os.print("\\nL: N" + this.leftChild.getNodeNumber());
            }
            if (this.rightChild != null) {
                os.print("\\nR: N" + this.rightChild.getNodeNumber());
            }
        }
        os.print("\"]");
        os.println("");
    }

    void printDotNodesAtLevel(PrintStream os, int levelToPrint, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        if (this.getDepth() == levelToPrint) {
            this.printDotNode(os, detail, treeOptions);
            return;
        }
        assert (this.getDepth() < levelToPrint);
        if (this.leftChild != null) {
            this.leftChild.printDotNodesAtLevel(os, levelToPrint, detail, treeOptions);
        }
        if (this.rightChild != null) {
            this.rightChild.printDotNodesAtLevel(os, levelToPrint, detail, treeOptions);
        }
    }

    private void printDotEdgesCommon(PrintStream os, int maxLevelsToPrintPerEdge, ArrayList<String> arr, SharedTreeNode child, float totalWeight, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        int n2;
        if (this.isBitset() || !Float.isNaN(this.splitValue) && treeOptions._internal) {
            BitSet bitSet = child.getInclusiveLevels();
            int n3 = bitSet.cardinality();
            if (n3 > 0 && n3 <= maxLevelsToPrintPerEdge) {
                n2 = bitSet.nextSetBit(0);
                while (n2 >= 0) {
                    arr.add(this.domainValues[n2]);
                    n2 = bitSet.nextSetBit(n2 + 1);
                }
            } else {
                arr.add(n3 + " levels");
            }
        }
        if (detail) {
            try {
                float f2 = child.getWeight() / totalWeight * 14.0f;
                n2 = Math.round(f2) + 1;
                os.print("penwidth=");
                os.print(n2);
                os.print(",");
            }
            catch (Exception exception) {}
        }
        os.print("fontsize=" + treeOptions._fontSize + ", label=\"");
        for (String string : arr) {
            os.print(SharedTreeNode.escapeQuotes(string) + "\n");
        }
        os.print("\"");
        os.println("]");
    }

    void printDotEdges(PrintStream os, int maxLevelsToPrintPerEdge, float totalWeight, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        ArrayList<String> arrayList;
        assert (this.leftChild == null == (this.rightChild == null));
        if (this.leftChild != null) {
            os.print("\"" + this.getDotName() + "\" -> \"" + this.leftChild.getDotName() + "\" [");
            arrayList = new ArrayList<String>();
            if (this.leftChild.getInclusiveNa()) {
                arrayList.add("[NA]");
            }
            if (this.naVsRest) {
                arrayList.add("[Not NA]");
            } else if (!this.isBitset() || !Float.isNaN(this.splitValue) && treeOptions._internal) {
                arrayList.add("<");
            }
            this.printDotEdgesCommon(os, maxLevelsToPrintPerEdge, arrayList, this.leftChild, totalWeight, detail, treeOptions);
        }
        if (this.rightChild != null) {
            os.print("\"" + this.getDotName() + "\" -> \"" + this.rightChild.getDotName() + "\" [");
            arrayList = new ArrayList();
            if (this.rightChild.getInclusiveNa()) {
                arrayList.add("[NA]");
            }
            if (!this.naVsRest && (!this.isBitset() || !Float.isNaN(this.splitValue) && treeOptions._internal)) {
                arrayList.add(">=");
            }
            this.printDotEdgesCommon(os, maxLevelsToPrintPerEdge, arrayList, this.rightChild, totalWeight, detail, treeOptions);
        }
    }

    public Map<String, Object> toJson() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("nodeNumber", this.nodeNumber);
        if (!Float.isNaN(this.weight)) {
            linkedHashMap.put("weight", Float.valueOf(this.weight));
        }
        if (this.isLeaf()) {
            if (!Float.isNaN(this.predValue)) {
                linkedHashMap.put("predValue", Float.valueOf(this.predValue));
            }
        } else {
            linkedHashMap.put("colId", this.colId);
            linkedHashMap.put("colName", this.colName);
            linkedHashMap.put("leftward", this.leftward);
            linkedHashMap.put("isCategorical", this.isBitset());
            linkedHashMap.put("inclusiveNa", this.inclusiveNa);
            if (!Float.isNaN(this.splitValue)) {
                linkedHashMap.put("splitValue", Float.valueOf(this.splitValue));
            }
        }
        if (this.inclusiveLevels != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n2 = this.inclusiveLevels.nextSetBit(0);
            while (n2 >= 0) {
                arrayList.add(n2);
                n2 = this.inclusiveLevels.nextSetBit(n2 + 1);
            }
            linkedHashMap.put("matchValues", arrayList);
            linkedHashMap.put("inclusiveNa", this.inclusiveNa);
        }
        if (!this.isLeaf()) {
            linkedHashMap.put("rightChild", this.rightChild.toJson());
            linkedHashMap.put("leftChild", this.leftChild.toJson());
        }
        return linkedHashMap;
    }

    public SharedTreeNode getParent() {
        return this.parent;
    }

    public int getSubgraphNumber() {
        return this.subgraphNumber;
    }

    public String getColName() {
        return this.colName;
    }

    public boolean isLeftward() {
        return this.leftward;
    }

    public boolean isNaVsRest() {
        return this.naVsRest;
    }

    public float getSplitValue() {
        return this.splitValue;
    }

    public String[] getDomainValues() {
        return this.domainValues;
    }

    public void setDomainValues(String[] domainValues) {
        this.domainValues = domainValues;
    }

    public GenmodelBitSet getBs() {
        return this.bs;
    }

    public float getPredValue() {
        return this.predValue;
    }

    public float getSquaredError() {
        return this.squaredError;
    }

    public SharedTreeNode getLeftChild() {
        return this.leftChild;
    }

    public SharedTreeNode getRightChild() {
        return this.rightChild;
    }

    public boolean isInclusiveNa() {
        return this.inclusiveNa;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SharedTreeNode sharedTreeNode = (SharedTreeNode)o2;
        return this.subgraphNumber == sharedTreeNode.subgraphNumber && this.nodeNumber == sharedTreeNode.nodeNumber && Float.compare(sharedTreeNode.weight, this.weight) == 0 && this.depth == sharedTreeNode.depth && this.colId == sharedTreeNode.colId && this.leftward == sharedTreeNode.leftward && this.naVsRest == sharedTreeNode.naVsRest && Float.compare(sharedTreeNode.splitValue, this.splitValue) == 0 && Float.compare(sharedTreeNode.predValue, this.predValue) == 0 && Float.compare(sharedTreeNode.squaredError, this.squaredError) == 0 && this.inclusiveNa == sharedTreeNode.inclusiveNa && Objects.equals(this.colName, sharedTreeNode.colName) && Arrays.equals(this.domainValues, sharedTreeNode.domainValues) && Objects.equals(this.leftChild, sharedTreeNode.leftChild) && Objects.equals(this.rightChild, sharedTreeNode.rightChild) && Objects.equals(this.inclusiveLevels, sharedTreeNode.inclusiveLevels);
    }

    public int hashCode() {
        return Objects.hash(this.subgraphNumber, this.nodeNumber);
    }

    @Override
    public final boolean isLeaf() {
        return this.leftChild == null && this.rightChild == null;
    }

    @Override
    public final float getLeafValue() {
        return this.predValue;
    }

    @Override
    public final int getSplitIndex() {
        return this.colId;
    }

    @Override
    public final int next(double[] value) {
        double d2 = value[this.colId];
        if (Double.isNaN(d2) || this.bs != null && !this.bs.isInRange((int)d2) || this.domainValues != null && this.domainValues.length <= (int)d2 ? !this.leftward : !this.naVsRest && (this.bs == null ? d2 >= (double)this.splitValue : this.bs.contains((int)d2))) {
            return this.getRightChildIndex();
        }
        return this.getLeftChildIndex();
    }

    @Override
    public final int getLeftChildIndex() {
        if (this.leftChild != null) {
            return this.leftChild.internalId;
        }
        return -1;
    }

    @Override
    public final int getRightChildIndex() {
        if (this.rightChild != null) {
            return this.rightChild.internalId;
        }
        return -1;
    }

    public float getGain(boolean useSquaredErrorForGain) {
        if (useSquaredErrorForGain) {
            return this.getSquaredError() - this.getRightChild().getSquaredError() - this.getLeftChild().getSquaredError();
        }
        return this.gain;
    }

    public void setGain(float gain) {
        this.gain = gain;
    }

    public String getDebugId() {
        return "#" + this.getNodeNumber() + "[internalId=" + this.internalId + "]";
    }
}

