/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.b.a.n;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.parameters.KeyValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class VariableImportances
implements Serializable {
    public final String[] _variables;
    public final double[] _importances;

    public VariableImportances(String[] variableNames, double[] relativeImportances) {
        this._variables = variableNames;
        this._importances = relativeImportances;
    }

    protected static VariableImportances extractFromJson(n modelJson) {
        Table table = ModelJsonReader.readTable(modelJson, "output.variable_importances");
        if (table == null) {
            return null;
        }
        double[] dArray = new double[table.rows()];
        String[] stringArray = new String[table.rows()];
        int n2 = table.findColumnIndex("Relative Importance");
        int n3 = table.findColumnIndex("Variable");
        if (n2 == -1) {
            return null;
        }
        if (n3 == -1) {
            return null;
        }
        for (int i2 = 0; i2 < table.rows(); ++i2) {
            dArray[i2] = (Double)table.getCell(n2, i2);
            stringArray[i2] = (String)table.getCell(n3, i2);
        }
        return new VariableImportances(stringArray, dArray);
    }

    public KeyValue[] topN(int n2) {
        if (n2 <= 0 || n2 > this._importances.length) {
            n2 = this._importances.length;
        }
        KeyValue[] keyValueArray = new KeyValue[this._importances.length];
        for (int i2 = 0; i2 < this._importances.length; ++i2) {
            keyValueArray[i2] = new KeyValue(this._variables[i2], this._importances[i2]);
        }
        Arrays.sort(keyValueArray, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue o1, KeyValue o2) {
                if (o1.getValue() > o2.getValue()) {
                    return -1;
                }
                return 0;
            }
        });
        return Arrays.copyOfRange(keyValueArray, 0, n2);
    }
}

