/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

public class ParseUtils {
    public static double[] parseArrayOfDoubles(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] stringArray = input.substring(1, input.length() - 1).split(",");
        double[] dArray = new double[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            dArray[i2] = Double.parseDouble(stringArray[i2].trim());
        }
        return dArray;
    }

    public static long[] parseArrayOfLongs(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] stringArray = input.substring(1, input.length() - 1).split(",");
        long[] lArray = new long[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            lArray[i2] = Long.parseLong(stringArray[i2].trim());
        }
        return lArray;
    }

    public static int[] parseArrayOfInts(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] stringArray = input.substring(1, input.length() - 1).split(",");
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringArray[i2].trim());
        }
        return nArray;
    }

    public static Object tryParse(String input, Object defVal) {
        if (input.equals("null")) {
            return defVal;
        }
        if (input.equals("true")) {
            return Boolean.TRUE;
        }
        if (input.equals("false")) {
            return Boolean.FALSE;
        }
        if (defVal != null && !defVal.getClass().isArray()) {
            if (defVal instanceof Boolean) {
                return Boolean.valueOf(input);
            }
            if (defVal instanceof Long) {
                return Long.valueOf(input);
            }
            if (defVal instanceof Integer) {
                return Integer.valueOf(input);
            }
            if (defVal instanceof Float) {
                return Float.valueOf(input);
            }
            if (defVal instanceof Double) {
                return Double.valueOf(input);
            }
        }
        if (defVal != null && defVal.getClass().isArray()) {
            if (defVal instanceof Long[]) {
                return ParseUtils.parseArrayOfLongs(input);
            }
            if (defVal instanceof Integer[]) {
                return ParseUtils.parseArrayOfInts(input);
            }
            if (defVal instanceof Double[]) {
                return ParseUtils.parseArrayOfDoubles(input);
            }
        }
        if ("[]".equals(input) && defVal != null && defVal.getClass().isArray()) {
            return defVal;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            if (defVal instanceof Number && !(defVal instanceof Double) && !(defVal instanceof Float) && !(defVal instanceof Long)) {
                throw numberFormatException;
            }
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException numberFormatException2) {
                if (defVal instanceof Number && !(defVal instanceof Double)) {
                    throw numberFormatException2;
                }
                try {
                    return Double.parseDouble(input);
                }
                catch (NumberFormatException numberFormatException3) {
                    if (defVal instanceof Number) {
                        throw numberFormatException3;
                    }
                    try {
                        return ParseUtils.parseArrayOfInts(input);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        if (defVal instanceof int[]) {
                            throw numberFormatException4;
                        }
                        try {
                            return ParseUtils.parseArrayOfLongs(input);
                        }
                        catch (NumberFormatException numberFormatException5) {
                            if (defVal instanceof long[]) {
                                throw numberFormatException5;
                            }
                            try {
                                return ParseUtils.parseArrayOfDoubles(input);
                            }
                            catch (NumberFormatException numberFormatException6) {
                                if (defVal instanceof double[]) {
                                    throw numberFormatException6;
                                }
                                return input;
                            }
                        }
                    }
                }
            }
        }
    }
}

