/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.LazyDynaMap;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.WrapDynaClass;

public class LazyDynaList
extends ArrayList<Object> {
    private DynaClass elementDynaClass;
    private transient WrapDynaClass wrapDynaClass;
    private Class<?> elementType;
    private Class<?> elementDynaBeanType;

    public LazyDynaList() {
    }

    public LazyDynaList(int capacity) {
        super(capacity);
    }

    public LazyDynaList(DynaClass elementDynaClass) {
        this.setElementDynaClass(elementDynaClass);
    }

    public LazyDynaList(Class<?> elementType) {
        this.setElementType(elementType);
    }

    public LazyDynaList(Collection<?> collection) {
        super(collection.size());
        this.addAll(collection);
    }

    public LazyDynaList(Object[] array) {
        super(array.length);
        Object[] objectArray = array;
        int n2 = array.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            this.add(object);
        }
    }

    @Override
    public void add(int index, Object element) {
        DynaBean dynaBean = this.transform(element);
        this.growList(index);
        super.add(index, dynaBean);
    }

    @Override
    public boolean add(Object element) {
        DynaBean dynaBean = this.transform(element);
        return super.add(dynaBean);
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        LazyDynaList lazyDynaList = this;
        lazyDynaList.ensureCapacity(lazyDynaList.size() + collection.size());
        for (Object obj : collection) {
            this.add(obj);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<?> collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.ensureCapacity((index > this.size() ? index : this.size()) + collection.size());
        if (this.size() == 0) {
            this.transform(collection.iterator().next());
        }
        this.growList(index);
        int n2 = index;
        for (Object obj : collection) {
            this.add(n2++, obj);
        }
        return true;
    }

    @Override
    public Object get(int index) {
        this.growList(index + 1);
        return super.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        DynaBean dynaBean = this.transform(element);
        this.growList(index + 1);
        return super.set(index, dynaBean);
    }

    @Override
    public Object[] toArray() {
        if (this.size() == 0 && this.elementType == null) {
            return new LazyDynaBean[0];
        }
        Object[] objectArray = (Object[])Array.newInstance(this.elementType, this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            objectArray[i2] = Map.class.isAssignableFrom(this.elementType) ? ((LazyDynaMap)this.get(i2)).getMap() : (DynaBean.class.isAssignableFrom(this.elementType) ? this.get(i2) : ((WrapDynaBean)this.get(i2)).getInstance());
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] model) {
        Class<?> clazz = model.getClass().getComponentType();
        if (DynaBean.class.isAssignableFrom(clazz) || this.size() == 0 && this.elementType == null) {
            return super.toArray(model);
        }
        if (clazz.isAssignableFrom(this.elementType)) {
            Object[] objectArray;
            if (model.length >= this.size()) {
                objectArray = model;
            } else {
                Object[] objectArray2 = (Object[])Array.newInstance(clazz, this.size());
                objectArray = objectArray2;
            }
            for (int i2 = 0; i2 < this.size(); ++i2) {
                Object object = Map.class.isAssignableFrom(this.elementType) ? ((LazyDynaMap)this.get(i2)).getMap() : (DynaBean.class.isAssignableFrom(this.elementType) ? this.get(i2) : ((WrapDynaBean)this.get(i2)).getInstance());
                Array.set(objectArray, i2, object);
            }
            return objectArray;
        }
        throw new IllegalArgumentException("Invalid array type: " + clazz.getName() + " - not compatible with '" + this.elementType.getName());
    }

    public DynaBean[] toDynaBeanArray() {
        if (this.size() == 0 && this.elementDynaBeanType == null) {
            return new LazyDynaBean[0];
        }
        DynaBean[] dynaBeanArray = (DynaBean[])Array.newInstance(this.elementDynaBeanType, this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            dynaBeanArray[i2] = (DynaBean)this.get(i2);
        }
        return dynaBeanArray;
    }

    public void setElementType(Class<?> elementType) {
        DynaBean dynaBean;
        Object obj;
        if (elementType == null) {
            throw new IllegalArgumentException("Element Type is missing");
        }
        boolean bl = this.elementType != null && !this.elementType.equals(elementType);
        if (bl && this.size() > 0) {
            throw new IllegalStateException("Element Type cannot be reset");
        }
        this.elementType = elementType;
        try {
            obj = elementType.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error creating type: " + elementType.getName() + " - " + exception);
        }
        if (Map.class.isAssignableFrom(elementType)) {
            dynaBean = this.createDynaBeanForMapProperty(obj);
            this.elementDynaClass = dynaBean.getDynaClass();
        } else if (DynaBean.class.isAssignableFrom(elementType)) {
            dynaBean = (DynaBean)obj;
            this.elementDynaClass = dynaBean.getDynaClass();
        } else {
            dynaBean = new WrapDynaBean(obj);
            this.wrapDynaClass = (WrapDynaClass)dynaBean.getDynaClass();
        }
        this.elementDynaBeanType = dynaBean.getClass();
        if (WrapDynaBean.class.isAssignableFrom(this.elementDynaBeanType)) {
            this.elementType = ((WrapDynaBean)dynaBean).getInstance().getClass();
            return;
        }
        if (LazyDynaMap.class.isAssignableFrom(this.elementDynaBeanType)) {
            this.elementType = ((LazyDynaMap)dynaBean).getMap().getClass();
        }
    }

    public void setElementDynaClass(DynaClass elementDynaClass) {
        block6: {
            if (elementDynaClass == null) {
                throw new IllegalArgumentException("Element DynaClass is missing");
            }
            if (this.size() > 0) {
                throw new IllegalStateException("Element DynaClass cannot be reset");
            }
            try {
                DynaBean dynaBean = elementDynaClass.newInstance();
                this.elementDynaBeanType = dynaBean.getClass();
                if (WrapDynaBean.class.isAssignableFrom(this.elementDynaBeanType)) {
                    this.elementType = ((WrapDynaBean)dynaBean).getInstance().getClass();
                    this.wrapDynaClass = (WrapDynaClass)elementDynaClass;
                    break block6;
                }
                if (LazyDynaMap.class.isAssignableFrom(this.elementDynaBeanType)) {
                    this.elementType = ((LazyDynaMap)dynaBean).getMap().getClass();
                    this.elementDynaClass = elementDynaClass;
                    break block6;
                }
                this.elementType = dynaBean.getClass();
                this.elementDynaClass = elementDynaClass;
                return;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error creating DynaBean from " + elementDynaClass.getClass().getName() + " - " + exception);
            }
        }
    }

    private void growList(int requiredSize) {
        if (requiredSize < this.size()) {
            return;
        }
        this.ensureCapacity(requiredSize + 1);
        for (int i2 = this.size(); i2 < requiredSize; ++i2) {
            DynaBean dynaBean = this.transform(null);
            super.add(dynaBean);
        }
    }

    private DynaBean transform(Object element) {
        Class<?> newDynaBeanType;
        DynaBean dynaBean;
        if (element == null) {
            if (this.elementType == null) {
                this.setElementDynaClass(new LazyDynaClass());
            }
            if (this.getDynaClass() == null) {
                LazyDynaList lazyDynaList = this;
                lazyDynaList.setElementType(lazyDynaList.elementType);
            }
            try {
                dynaBean = this.getDynaClass().newInstance();
                newDynaBeanType = dynaBean.getClass();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error creating DynaBean: " + this.getDynaClass().getClass().getName() + " - " + exception);
            }
        } else {
            element.getClass();
            dynaBean = Map.class.isAssignableFrom(element.getClass()) ? this.createDynaBeanForMapProperty(element) : (DynaBean.class.isAssignableFrom(element.getClass()) ? (DynaBean)element : new WrapDynaBean(element));
            newDynaBeanType = dynaBean.getClass();
        }
        Class<?> newElementType = dynaBean.getClass();
        if (WrapDynaBean.class.isAssignableFrom(newDynaBeanType)) {
            newElementType = ((WrapDynaBean)dynaBean).getInstance().getClass();
        } else if (LazyDynaMap.class.isAssignableFrom(newDynaBeanType)) {
            newElementType = ((LazyDynaMap)dynaBean).getMap().getClass();
        }
        if (this.elementType != null && !newElementType.equals(this.elementType)) {
            throw new IllegalArgumentException("Element Type " + newElementType + " doesn't match other elements " + this.elementType);
        }
        return dynaBean;
    }

    private LazyDynaMap createDynaBeanForMapProperty(Object value) {
        Map map = (Map)value;
        return new LazyDynaMap(map);
    }

    private DynaClass getDynaClass() {
        if (this.elementDynaClass == null) {
            return this.wrapDynaClass;
        }
        return this.elementDynaClass;
    }
}

