/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.IterableMap;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.EmptyMapIterator;

public class AbstractHashedMap
extends AbstractMap
implements IterableMap {
    protected static final String NO_NEXT_ENTRY = "No next() entry in the iteration";
    protected static final String NO_PREVIOUS_ENTRY = "No previous() entry in the iteration";
    protected static final String REMOVE_INVALID = "remove() can only be called once after next()";
    protected static final String GETKEY_INVALID = "getKey() can only be called after next() and before remove()";
    protected static final String GETVALUE_INVALID = "getValue() can only be called after next() and before remove()";
    protected static final String SETVALUE_INVALID = "setValue() can only be called after next() and before remove()";
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final int DEFAULT_THRESHOLD = 12;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final Object NULL = new Object();
    protected transient float loadFactor;
    protected transient int size;
    protected transient HashEntry[] data;
    protected transient int threshold;
    protected transient int modCount;
    protected transient EntrySet entrySet;
    protected transient KeySet keySet;
    protected transient Values values;

    protected AbstractHashedMap() {
    }

    protected AbstractHashedMap(int initialCapacity, float loadFactor, int threshold) {
        this.loadFactor = loadFactor;
        this.data = new HashEntry[initialCapacity];
        this.threshold = threshold;
        this.init();
    }

    protected AbstractHashedMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    protected AbstractHashedMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = loadFactor;
        initialCapacity = this.calculateNewCapacity(initialCapacity);
        this.threshold = this.calculateThreshold(initialCapacity, loadFactor);
        this.data = new HashEntry[initialCapacity];
        this.init();
    }

    protected AbstractHashedMap(Map map) {
        this(Math.max(2 * map.size(), 16), 0.75f);
        this.putAll(map);
    }

    protected void init() {
    }

    public Object get(Object key) {
        key = this.convertKey(key);
        int n2 = this.hash(key);
        HashEntry hashEntry = this.data[this.hashIndex(n2, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(key, hashEntry.key)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        key = this.convertKey(key);
        int n2 = this.hash(key);
        HashEntry hashEntry = this.data[this.hashIndex(n2, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(key, hashEntry.key)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            int n2 = this.data.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                HashEntry hashEntry = this.data[i2];
                while (hashEntry != null) {
                    if (hashEntry.getValue() == null) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        } else {
            int n3 = this.data.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                HashEntry hashEntry = this.data[i3];
                while (hashEntry != null) {
                    if (this.isEqualValue(value, hashEntry.getValue())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        }
        return false;
    }

    public Object put(Object key, Object value) {
        key = this.convertKey(key);
        int n2 = this.hash(key);
        int n3 = this.hashIndex(n2, this.data.length);
        HashEntry hashEntry = this.data[n3];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(key, hashEntry.key)) {
                Object object = hashEntry.getValue();
                this.updateEntry(hashEntry, value);
                return object;
            }
            hashEntry = hashEntry.next;
        }
        this.addMapping(n3, n2, key, value);
        return null;
    }

    public void putAll(Map map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        int n3 = (int)((float)(this.size + n2) / this.loadFactor + 1.0f);
        AbstractHashedMap abstractHashedMap = this;
        abstractHashedMap.ensureCapacity(abstractHashedMap.calculateNewCapacity(n3));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        key = this.convertKey(key);
        int n2 = this.hash(key);
        int n3 = this.hashIndex(n2, this.data.length);
        HashEntry hashEntry = this.data[n3];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(key, hashEntry.key)) {
                Object object = hashEntry.getValue();
                this.removeMapping(hashEntry, n3, hashEntry2);
                return object;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public void clear() {
        ++this.modCount;
        HashEntry[] hashEntryArray = this.data;
        for (int i2 = this.data.length - 1; i2 >= 0; --i2) {
            hashEntryArray[i2] = null;
        }
        this.size = 0;
    }

    protected Object convertKey(Object key) {
        if (key == null) {
            return NULL;
        }
        return key;
    }

    protected int hash(Object key) {
        int n2 = key.hashCode();
        n2 += ~(n2 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    protected boolean isEqualKey(Object key1, Object key2) {
        return key1 == key2 || key1.equals(key2);
    }

    protected boolean isEqualValue(Object value1, Object value2) {
        return value1 == value2 || value1.equals(value2);
    }

    protected int hashIndex(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    protected HashEntry getEntry(Object key) {
        key = this.convertKey(key);
        int n2 = this.hash(key);
        HashEntry hashEntry = this.data[this.hashIndex(n2, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(key, hashEntry.key)) {
                return hashEntry;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected void updateEntry(HashEntry entry, Object newValue) {
        entry.setValue(newValue);
    }

    protected void reuseEntry(HashEntry entry, int hashIndex, int hashCode, Object key, Object value) {
        entry.next = this.data[hashIndex];
        entry.hashCode = hashCode;
        entry.key = key;
        entry.value = value;
    }

    protected void addMapping(int hashIndex, int hashCode, Object key, Object value) {
        ++this.modCount;
        AbstractHashedMap abstractHashedMap = this;
        HashEntry hashEntry = abstractHashedMap.createEntry(abstractHashedMap.data[hashIndex], hashCode, key, value);
        this.addEntry(hashEntry, hashIndex);
        ++this.size;
        this.checkCapacity();
    }

    protected HashEntry createEntry(HashEntry next, int hashCode, Object key, Object value) {
        return new HashEntry(next, hashCode, key, value);
    }

    protected void addEntry(HashEntry entry, int hashIndex) {
        this.data[hashIndex] = entry;
    }

    protected void removeMapping(HashEntry entry, int hashIndex, HashEntry previous) {
        ++this.modCount;
        this.removeEntry(entry, hashIndex, previous);
        --this.size;
        this.destroyEntry(entry);
    }

    protected void removeEntry(HashEntry entry, int hashIndex, HashEntry previous) {
        if (previous == null) {
            this.data[hashIndex] = entry.next;
            return;
        }
        previous.next = entry.next;
    }

    protected void destroyEntry(HashEntry entry) {
        entry.next = null;
        entry.key = null;
        entry.value = null;
    }

    protected void checkCapacity() {
        int n2;
        if (this.size >= this.threshold && (n2 = this.data.length << 1) <= 0x40000000) {
            this.ensureCapacity(n2);
        }
    }

    protected void ensureCapacity(int newCapacity) {
        int n2 = this.data.length;
        if (newCapacity <= n2) {
            return;
        }
        if (this.size == 0) {
            this.threshold = this.calculateThreshold(newCapacity, this.loadFactor);
            this.data = new HashEntry[newCapacity];
            return;
        }
        HashEntry[] hashEntryArray = this.data;
        HashEntry[] hashEntryArray2 = new HashEntry[newCapacity];
        ++this.modCount;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            HashEntry hashEntry;
            HashEntry hashEntry2 = hashEntryArray[i2];
            if (hashEntry2 == null) continue;
            hashEntryArray[i2] = null;
            do {
                hashEntry = hashEntry2.next;
                int n3 = this.hashIndex(hashEntry2.hashCode, newCapacity);
                hashEntry2.next = hashEntryArray2[n3];
                hashEntryArray2[n3] = hashEntry2;
            } while ((hashEntry2 = hashEntry) != null);
        }
        this.threshold = this.calculateThreshold(newCapacity, this.loadFactor);
        this.data = hashEntryArray2;
    }

    protected int calculateNewCapacity(int proposedCapacity) {
        int n2;
        if (proposedCapacity > 0x40000000) {
            n2 = 0x40000000;
        } else {
            for (n2 = 1; n2 < proposedCapacity; n2 <<= 1) {
            }
            if (n2 > 0x40000000) {
                n2 = 0x40000000;
            }
        }
        return n2;
    }

    protected int calculateThreshold(int newCapacity, float factor) {
        return (int)((float)newCapacity * factor);
    }

    protected HashEntry entryNext(HashEntry entry) {
        return entry.next;
    }

    protected int entryHashCode(HashEntry entry) {
        return entry.hashCode;
    }

    protected Object entryKey(HashEntry entry) {
        return entry.key;
    }

    protected Object entryValue(HashEntry entry) {
        return entry.value;
    }

    public MapIterator mapIterator() {
        if (this.size == 0) {
            return EmptyMapIterator.INSTANCE;
        }
        return new HashMapIterator(this);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new EntrySetIterator(this);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new KeySetIterator(this);
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator createValuesIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeFloat(this.loadFactor);
        out.writeInt(this.data.length);
        out.writeInt(this.size);
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            out.writeObject(mapIterator.next());
            out.writeObject(mapIterator.getValue());
        }
    }

    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.loadFactor = in.readFloat();
        int n2 = in.readInt();
        int n3 = in.readInt();
        this.init();
        this.threshold = this.calculateThreshold(n2, this.loadFactor);
        this.data = new HashEntry[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = in.readObject();
            Object object2 = in.readObject();
            this.put(object, object2);
        }
    }

    protected Object clone() {
        try {
            AbstractHashedMap abstractHashedMap = (AbstractHashedMap)super.clone();
            ((AbstractHashedMap)super.clone()).data = new HashEntry[this.data.length];
            abstractHashedMap.entrySet = null;
            abstractHashedMap.keySet = null;
            abstractHashedMap.values = null;
            abstractHashedMap.modCount = 0;
            abstractHashedMap.size = 0;
            abstractHashedMap.init();
            abstractHashedMap.putAll((Map)this);
            return abstractHashedMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        if (map.size() != this.size()) {
            return false;
        }
        MapIterator mapIterator = this.mapIterator();
        try {
            while (mapIterator.hasNext()) {
                Object object = mapIterator.next();
                Object object2 = mapIterator.getValue();
                if (!(object2 == null ? map.get(object) != null || !map.containsKey(object) : !object2.equals(map.get(object)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.createEntrySetIterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().hashCode();
        }
        return n2;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(32 * this.size());
        stringBuffer.append('{');
        MapIterator mapIterator = this.mapIterator();
        boolean bl = mapIterator.hasNext();
        while (bl) {
            Object object = mapIterator.next();
            Object object2 = mapIterator.getValue();
            stringBuffer.append(object == this ? "(this Map)" : object).append('=').append(object2 == this ? "(this Map)" : object2);
            bl = mapIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(',').append(' ');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    protected static abstract class HashIterator
    implements Iterator {
        protected final AbstractHashedMap parent;
        protected int hashIndex;
        protected HashEntry last;
        protected HashEntry next;
        protected int expectedModCount;

        protected HashIterator(AbstractHashedMap parent) {
            this.parent = parent;
            HashEntry[] hashEntryArray = parent.data;
            int n2 = parent.data.length;
            HashEntry hashEntry = null;
            while (n2 > 0 && hashEntry == null) {
                hashEntry = hashEntryArray[--n2];
            }
            this.next = hashEntry;
            this.hashIndex = n2;
            this.expectedModCount = parent.modCount;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected HashEntry nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            HashEntry hashEntry = this.next;
            if (hashEntry == null) {
                throw new NoSuchElementException(AbstractHashedMap.NO_NEXT_ENTRY);
            }
            HashEntry[] hashEntryArray = this.parent.data;
            int n2 = this.hashIndex;
            HashEntry hashEntry2 = hashEntry.next;
            while (hashEntry2 == null && n2 > 0) {
                hashEntry2 = hashEntryArray[--n2];
            }
            this.next = hashEntry2;
            this.hashIndex = n2;
            this.last = hashEntry;
            return hashEntry;
        }

        protected HashEntry currentEntry() {
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException(AbstractHashedMap.REMOVE_INVALID);
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class HashEntry
    implements Map.Entry,
    KeyValue {
        protected HashEntry next;
        protected int hashCode;
        protected Object key;
        protected Object value;

        protected HashEntry(HashEntry next, int hashCode, Object key, Object value) {
            this.next = next;
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            if (this.key == NULL) {
                return null;
            }
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object object = this.value;
            this.value = value;
            return object;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    protected static class ValuesIterator
    extends HashIterator {
        protected ValuesIterator(AbstractHashedMap parent) {
            super(parent);
        }

        public Object next() {
            return super.nextEntry().getValue();
        }
    }

    protected static class Values
    extends AbstractCollection {
        protected final AbstractHashedMap parent;

        protected Values(AbstractHashedMap parent) {
            this.parent = parent;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object value) {
            return this.parent.containsValue(value);
        }

        public Iterator iterator() {
            return this.parent.createValuesIterator();
        }
    }

    protected static class KeySetIterator
    extends EntrySetIterator {
        protected KeySetIterator(AbstractHashedMap parent) {
            super(parent);
        }

        public Object next() {
            return super.nextEntry().getKey();
        }
    }

    protected static class KeySet
    extends AbstractSet {
        protected final AbstractHashedMap parent;

        protected KeySet(AbstractHashedMap parent) {
            this.parent = parent;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object key) {
            return this.parent.containsKey(key);
        }

        public boolean remove(Object key) {
            boolean bl = this.parent.containsKey(key);
            this.parent.remove(key);
            return bl;
        }

        public Iterator iterator() {
            return this.parent.createKeySetIterator();
        }
    }

    protected static class EntrySetIterator
    extends HashIterator {
        protected EntrySetIterator(AbstractHashedMap parent) {
            super(parent);
        }

        public Object next() {
            return super.nextEntry();
        }
    }

    protected static class EntrySet
    extends AbstractSet {
        protected final AbstractHashedMap parent;

        protected EntrySet(AbstractHashedMap parent) {
            this.parent = parent;
        }

        public int size() {
            return this.parent.size();
        }

        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Object entry) {
            if (entry instanceof Map.Entry) {
                Map.Entry entry2 = (Map.Entry)entry;
                HashEntry hashEntry = this.parent.getEntry(entry2.getKey());
                return hashEntry != null && hashEntry.equals(entry2);
            }
            return false;
        }

        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            if (!this.contains(obj)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object k2 = entry.getKey();
            this.parent.remove(k2);
            return true;
        }

        public Iterator iterator() {
            return this.parent.createEntrySetIterator();
        }
    }

    protected static class HashMapIterator
    extends HashIterator
    implements MapIterator {
        protected HashMapIterator(AbstractHashedMap parent) {
            super(parent);
        }

        public Object next() {
            return super.nextEntry().getKey();
        }

        public Object getKey() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETKEY_INVALID);
            }
            return hashEntry.getKey();
        }

        public Object getValue() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETVALUE_INVALID);
            }
            return hashEntry.getValue();
        }

        public Object setValue(Object value) {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.SETVALUE_INVALID);
            }
            return hashEntry.setValue(value);
        }
    }
}

