/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.IterableMap;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;

public class MultiKeyMap
implements Serializable,
IterableMap {
    private static final long serialVersionUID = -1788199231038721040L;
    protected final AbstractHashedMap map;

    public static MultiKeyMap decorate(AbstractHashedMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (map.size() > 0) {
            throw new IllegalArgumentException("Map must be empty");
        }
        return new MultiKeyMap(map);
    }

    public MultiKeyMap() {
        this.map = new HashedMap();
    }

    protected MultiKeyMap(AbstractHashedMap map) {
        this.map = map;
    }

    public Object get(Object key1, Object key2) {
        int n2 = this.hash(key1, key2);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object key1, Object key2) {
        int n2 = this.hash(key1, key2);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object key1, Object key2, Object value) {
        int n2 = this.hash(key1, key2);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2)) {
                Object object = hashEntry.getValue();
                this.map.updateEntry(hashEntry, value);
                return object;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n3, n2, new MultiKey(key1, key2), value);
        return null;
    }

    public Object remove(Object key1, Object key2) {
        int n2 = this.hash(key1, key2);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2)) {
                Object object = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n3, hashEntry2);
                return object;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object key1, Object key2) {
        int n2 = 0;
        if (key1 != null) {
            n2 = 0 ^ key1.hashCode();
        }
        if (key2 != null) {
            n2 ^= key2.hashCode();
        }
        int n3 = n2;
        n2 = n3 + ~(n3 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry entry, Object key1, Object key2) {
        MultiKey multiKey = (MultiKey)entry.getKey();
        return multiKey.size() == 2 && (key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0))) && (key2 == null ? multiKey.getKey(1) == null : key2.equals(multiKey.getKey(1)));
    }

    public Object get(Object key1, Object key2, Object key3) {
        int n2 = this.hash(key1, key2, key3);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object key1, Object key2, Object key3) {
        int n2 = this.hash(key1, key2, key3);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object key1, Object key2, Object key3, Object value) {
        int n2 = this.hash(key1, key2, key3);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3)) {
                Object object = hashEntry.getValue();
                this.map.updateEntry(hashEntry, value);
                return object;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n3, n2, new MultiKey(key1, key2, key3), value);
        return null;
    }

    public Object remove(Object key1, Object key2, Object key3) {
        int n2 = this.hash(key1, key2, key3);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3)) {
                Object object = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n3, hashEntry2);
                return object;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object key1, Object key2, Object key3) {
        int n2 = 0;
        if (key1 != null) {
            n2 = 0 ^ key1.hashCode();
        }
        if (key2 != null) {
            n2 ^= key2.hashCode();
        }
        if (key3 != null) {
            n2 ^= key3.hashCode();
        }
        int n3 = n2;
        n2 = n3 + ~(n3 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry entry, Object key1, Object key2, Object key3) {
        MultiKey multiKey = (MultiKey)entry.getKey();
        return multiKey.size() == 3 && (key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0))) && (key2 == null ? multiKey.getKey(1) == null : key2.equals(multiKey.getKey(1))) && (key3 == null ? multiKey.getKey(2) == null : key3.equals(multiKey.getKey(2)));
    }

    public Object get(Object key1, Object key2, Object key3, Object key4) {
        int n2 = this.hash(key1, key2, key3, key4);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object key1, Object key2, Object key3, Object key4) {
        int n2 = this.hash(key1, key2, key3, key4);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object key1, Object key2, Object key3, Object key4, Object value) {
        int n2 = this.hash(key1, key2, key3, key4);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4)) {
                Object object = hashEntry.getValue();
                this.map.updateEntry(hashEntry, value);
                return object;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n3, n2, new MultiKey(key1, key2, key3, key4), value);
        return null;
    }

    public Object remove(Object key1, Object key2, Object key3, Object key4) {
        int n2 = this.hash(key1, key2, key3, key4);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4)) {
                Object object = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n3, hashEntry2);
                return object;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object key1, Object key2, Object key3, Object key4) {
        int n2 = 0;
        if (key1 != null) {
            n2 = 0 ^ key1.hashCode();
        }
        if (key2 != null) {
            n2 ^= key2.hashCode();
        }
        if (key3 != null) {
            n2 ^= key3.hashCode();
        }
        if (key4 != null) {
            n2 ^= key4.hashCode();
        }
        int n3 = n2;
        n2 = n3 + ~(n3 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry entry, Object key1, Object key2, Object key3, Object key4) {
        MultiKey multiKey = (MultiKey)entry.getKey();
        return multiKey.size() == 4 && (key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0))) && (key2 == null ? multiKey.getKey(1) == null : key2.equals(multiKey.getKey(1))) && (key3 == null ? multiKey.getKey(2) == null : key3.equals(multiKey.getKey(2))) && (key4 == null ? multiKey.getKey(3) == null : key4.equals(multiKey.getKey(3)));
    }

    public Object get(Object key1, Object key2, Object key3, Object key4, Object key5) {
        int n2 = this.hash(key1, key2, key3, key4, key5);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4, key5)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object key1, Object key2, Object key3, Object key4, Object key5) {
        int n2 = this.hash(key1, key2, key3, key4, key5);
        AbstractHashedMap abstractHashedMap = this.map;
        AbstractHashedMap.HashEntry hashEntry = this.map.data[abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4, key5)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object key1, Object key2, Object key3, Object key4, Object key5, Object value) {
        int n2 = this.hash(key1, key2, key3, key4, key5);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4, key5)) {
                Object object = hashEntry.getValue();
                this.map.updateEntry(hashEntry, value);
                return object;
            }
            hashEntry = hashEntry.next;
        }
        this.map.addMapping(n3, n2, new MultiKey(key1, key2, key3, key4, key5), value);
        return null;
    }

    public Object remove(Object key1, Object key2, Object key3, Object key4, Object key5) {
        int n2 = this.hash(key1, key2, key3, key4, key5);
        AbstractHashedMap abstractHashedMap = this.map;
        int n3 = abstractHashedMap.hashIndex(n2, abstractHashedMap.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.map.data[n3];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n2 && this.isEqualKey(hashEntry, key1, key2, key3, key4, key5)) {
                Object object = hashEntry.getValue();
                this.map.removeMapping(hashEntry, n3, hashEntry2);
                return object;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected int hash(Object key1, Object key2, Object key3, Object key4, Object key5) {
        int n2 = 0;
        if (key1 != null) {
            n2 = 0 ^ key1.hashCode();
        }
        if (key2 != null) {
            n2 ^= key2.hashCode();
        }
        if (key3 != null) {
            n2 ^= key3.hashCode();
        }
        if (key4 != null) {
            n2 ^= key4.hashCode();
        }
        if (key5 != null) {
            n2 ^= key5.hashCode();
        }
        int n3 = n2;
        n2 = n3 + ~(n3 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry entry, Object key1, Object key2, Object key3, Object key4, Object key5) {
        MultiKey multiKey = (MultiKey)entry.getKey();
        return multiKey.size() == 5 && (key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0))) && (key2 == null ? multiKey.getKey(1) == null : key2.equals(multiKey.getKey(1))) && (key3 == null ? multiKey.getKey(2) == null : key3.equals(multiKey.getKey(2))) && (key4 == null ? multiKey.getKey(3) == null : key4.equals(multiKey.getKey(3))) && (key5 == null ? multiKey.getKey(4) == null : key5.equals(multiKey.getKey(4)));
    }

    public boolean removeAll(Object key1) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() <= 0 || !(key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Object key1, Object key2) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() < 2 || !(key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0))) || !(key2 == null ? multiKey.getKey(1) == null : key2.equals(multiKey.getKey(1)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Object key1, Object key2, Object key3) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() < 3 || !(key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0))) || !(key2 == null ? multiKey.getKey(1) == null : key2.equals(multiKey.getKey(1))) || !(key3 == null ? multiKey.getKey(2) == null : key3.equals(multiKey.getKey(2)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Object key1, Object key2, Object key3, Object key4) {
        boolean bl = false;
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            MultiKey multiKey = (MultiKey)mapIterator.next();
            if (multiKey.size() < 4 || !(key1 == null ? multiKey.getKey(0) == null : key1.equals(multiKey.getKey(0))) || !(key2 == null ? multiKey.getKey(1) == null : key2.equals(multiKey.getKey(1))) || !(key3 == null ? multiKey.getKey(2) == null : key3.equals(multiKey.getKey(2))) || !(key4 == null ? multiKey.getKey(3) == null : key4.equals(multiKey.getKey(3)))) continue;
            mapIterator.remove();
            bl = true;
        }
        return bl;
    }

    protected void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null");
        }
        if (!(key instanceof MultiKey)) {
            throw new ClassCastException("Key must be a MultiKey");
        }
    }

    public Object clone() {
        return new MultiKeyMap((AbstractHashedMap)this.map.clone());
    }

    public Object put(Object key, Object value) {
        this.checkKey(key);
        return this.map.put(key, value);
    }

    public void putAll(Map mapToCopy) {
        Iterator iterator = mapToCopy.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            this.checkKey(k2);
        }
        this.map.putAll(mapToCopy);
    }

    public MapIterator mapIterator() {
        return this.map.mapIterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

