/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final int INDEX_NOT_FOUND = -1;

    public static String toString(Object array) {
        return ArrayUtils.toString(array, "{}");
    }

    public static String toString(Object array, String stringIfNull) {
        if (array == null) {
            return stringIfNull;
        }
        return new ToStringBuilder(array, ToStringStyle.SIMPLE_STYLE).append(array).toString();
    }

    public static int hashCode(Object array) {
        return new HashCodeBuilder().append(array).toHashCode();
    }

    @Deprecated
    public static boolean isEquals(Object array1, Object array2) {
        return new EqualsBuilder().append(array1, array2).isEquals();
    }

    public static Map<Object, Object> toMap(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i2 = 0; i2 < array.length; ++i2) {
            Object[] objectArray;
            Object object = array[i2];
            if (object instanceof Map.Entry) {
                objectArray = (Object[])object;
                hashMap.put(objectArray.getKey(), objectArray.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
                if (objectArray.length < 2) {
                    throw new IllegalArgumentException("Array element " + i2 + ", '" + object + "', has a length less than 2");
                }
                hashMap.put(objectArray[0], objectArray[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i2 + ", '" + object + "', is neither of type Map.Entry nor an Array");
        }
        return hashMap;
    }

    public static <T> T[] toArray(T ... items) {
        return items;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static long[] clone(long[] array) {
        if (array == null) {
            return null;
        }
        return (long[])array.clone();
    }

    public static int[] clone(int[] array) {
        if (array == null) {
            return null;
        }
        return (int[])array.clone();
    }

    public static short[] clone(short[] array) {
        if (array == null) {
            return null;
        }
        return (short[])array.clone();
    }

    public static char[] clone(char[] array) {
        if (array == null) {
            return null;
        }
        return (char[])array.clone();
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    public static double[] clone(double[] array) {
        if (array == null) {
            return null;
        }
        return (double[])array.clone();
    }

    public static float[] clone(float[] array) {
        if (array == null) {
            return null;
        }
        return (float[])array.clone();
    }

    public static boolean[] clone(boolean[] array) {
        if (array == null) {
            return null;
        }
        return (boolean[])array.clone();
    }

    public static <T> T[] nullToEmpty(T[] array, Class<T[]> type) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        if (array == null) {
            Class<T[]> clazz = type;
            return clazz.cast(Array.newInstance(clazz.getComponentType(), 0));
        }
        return array;
    }

    public static Object[] nullToEmpty(Object[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_OBJECT_ARRAY;
        }
        return array;
    }

    public static Class<?>[] nullToEmpty(Class<?>[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_CLASS_ARRAY;
        }
        return array;
    }

    public static String[] nullToEmpty(String[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_STRING_ARRAY;
        }
        return array;
    }

    public static long[] nullToEmpty(long[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_LONG_ARRAY;
        }
        return array;
    }

    public static int[] nullToEmpty(int[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_INT_ARRAY;
        }
        return array;
    }

    public static short[] nullToEmpty(short[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_SHORT_ARRAY;
        }
        return array;
    }

    public static char[] nullToEmpty(char[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_CHAR_ARRAY;
        }
        return array;
    }

    public static byte[] nullToEmpty(byte[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_BYTE_ARRAY;
        }
        return array;
    }

    public static double[] nullToEmpty(double[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return array;
    }

    public static float[] nullToEmpty(float[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return array;
    }

    public static boolean[] nullToEmpty(boolean[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return array;
    }

    public static Long[] nullToEmpty(Long[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        return array;
    }

    public static Integer[] nullToEmpty(Integer[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return array;
    }

    public static Short[] nullToEmpty(Short[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        return array;
    }

    public static Character[] nullToEmpty(Character[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return array;
    }

    public static Byte[] nullToEmpty(Byte[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        return array;
    }

    public static Double[] nullToEmpty(Double[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return array;
    }

    public static Float[] nullToEmpty(Float[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return array;
    }

    public static Boolean[] nullToEmpty(Boolean[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return array;
    }

    public static <T> T[] subarray(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int n2 = endIndexExclusive - startIndexInclusive;
        Class<?> clazz = array.getClass().getComponentType();
        if (n2 <= 0) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, 0);
            return objectArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2);
        System.arraycopy(array, startIndexInclusive, objectArray, 0, n2);
        return objectArray;
    }

    public static long[] subarray(long[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[n2];
        System.arraycopy(array, startIndexInclusive, lArray, 0, n2);
        return lArray;
    }

    public static int[] subarray(int[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[n2];
        System.arraycopy(array, startIndexInclusive, nArray, 0, n2);
        return nArray;
    }

    public static short[] subarray(short[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[n2];
        System.arraycopy(array, startIndexInclusive, sArray, 0, n2);
        return sArray;
    }

    public static char[] subarray(char[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[n2];
        System.arraycopy(array, startIndexInclusive, cArray, 0, n2);
        return cArray;
    }

    public static byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(array, startIndexInclusive, byArray, 0, n2);
        return byArray;
    }

    public static double[] subarray(double[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[n2];
        System.arraycopy(array, startIndexInclusive, dArray, 0, n2);
        return dArray;
    }

    public static float[] subarray(float[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[n2];
        System.arraycopy(array, startIndexInclusive, fArray, 0, n2);
        return fArray;
    }

    public static boolean[] subarray(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        int n2;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[n2];
        System.arraycopy(array, startIndexInclusive, blArray, 0, n2);
        return blArray;
    }

    public static boolean isSameLength(Object[] array1, Object[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(long[] array1, long[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(int[] array1, int[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(short[] array1, short[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(char[] array1, char[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(byte[] array1, byte[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(double[] array1, double[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(float[] array1, float[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(boolean[] array1, boolean[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static boolean isSameType(Object array1, Object array2) {
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return array1.getClass().getName().equals(array2.getClass().getName());
    }

    public static void reverse(Object[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(long[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(int[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(short[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(char[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(double[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(float[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            boolean bl = array[i2];
            array[i2] = array[n2];
            array[n2] = bl;
        }
    }

    public static void reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            byte by = array[i2];
            array[i2] = array[n2];
            array[n2] = by;
        }
    }

    public static void reverse(char[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            char c2 = array[i2];
            array[i2] = array[n2];
            array[n2] = c2;
        }
    }

    public static void reverse(double[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            double d2 = array[i2];
            array[i2] = array[n2];
            array[n2] = d2;
        }
    }

    public static void reverse(float[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            float f2 = array[i2];
            array[i2] = array[n2];
            array[n2] = f2;
        }
    }

    public static void reverse(int[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            int n3 = array[i2];
            array[i2] = array[n2];
            array[n2] = n3;
        }
    }

    public static void reverse(long[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            long l2 = array[i2];
            array[i2] = array[n2];
            array[n2] = l2;
        }
    }

    public static void reverse(Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            Object object = array[i2];
            array[i2] = array[n2];
            array[n2] = object;
        }
    }

    public static void reverse(short[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int n2 = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int i2 = Math.min(array.length, endIndexExclusive) - 1; i2 > n2; --i2, ++n2) {
            short s2 = array[i2];
            array[i2] = array[n2];
            array[n2] = s2;
        }
    }

    public static void swap(Object[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(long[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(int[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(short[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(char[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(byte[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(double[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(float[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            boolean bl = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = bl;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(byte[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            byte by = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = by;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(char[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            char c2 = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = c2;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(double[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            double d2 = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = d2;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(float[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            float f2 = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = f2;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(int[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            int n3 = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = n3;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(long[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            long l2 = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = l2;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(Object[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            Object object = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = object;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(short[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        if (offset1 == offset2) {
            return;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int n2 = 0;
        while (n2 < len) {
            short s2 = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = s2;
            ++n2;
            ++offset1;
            ++offset2;
        }
    }

    public static void shift(Object[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(long[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(int[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(short[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(char[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(byte[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(double[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(float[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(boolean[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(boolean[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(byte[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(char[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(double[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(float[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(int[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(long[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(Object[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static void shift(short[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n2;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n2 = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            int n3 = n2 - offset;
            if (offset > n3) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + n2 - n3, n3);
                n2 = offset;
                offset -= n3;
                continue;
            }
            if (offset < n3) {
                int n5 = startIndexInclusive;
                ArrayUtils.swap(array, n5, n5 + n3, offset);
                startIndexInclusive += offset;
                n2 = n3;
                continue;
            }
            int n6 = startIndexInclusive;
            ArrayUtils.swap(array, n6, n6 + n3, offset);
            return;
        }
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i2 = startIndex; i2 < array.length; ++i2) {
                if (array[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = startIndex; i3 < array.length; ++i3) {
                if (!objectToFind.equals(array[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.lastIndexOf(array, objectToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        block6: {
            block5: {
                if (array == null) {
                    return -1;
                }
                if (startIndex < 0) {
                    return -1;
                }
                if (startIndex >= array.length) {
                    startIndex = array.length - 1;
                }
                if (objectToFind != null) break block5;
                for (int i2 = startIndex; i2 >= 0; --i2) {
                    if (array[i2] != null) continue;
                    return i2;
                }
                break block6;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block6;
            for (int i3 = startIndex; i3 >= 0; --i3) {
                if (!objectToFind.equals(array[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind) != -1;
    }

    public static int indexOf(long[] array, long valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(long[] array, long valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(int[] array, int valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(int[] array, int valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(short[] array, short valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(short[] array, short valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(char[] array, char valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(char[] array, char valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(byte[] array, byte valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(double[] array, double valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.indexOf(array, valueToFind, 0, tolerance);
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double d2 = valueToFind - tolerance;
        double d3 = valueToFind + tolerance;
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (!(array[i2] >= d2) || !(array[i2] <= d3)) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double d2 = valueToFind - tolerance;
        double d3 = valueToFind + tolerance;
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (!(array[i2] >= d2) || !(array[i2] <= d3)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(double[] array, double valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static boolean contains(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.indexOf(array, valueToFind, 0, tolerance) != -1;
    }

    public static int indexOf(float[] array, float valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(float[] array, float valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(float[] array, float valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(float[] array, float valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(boolean[] array, boolean valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i2 = startIndex; i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static char[] toPrimitive(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            cArray[i2] = array[i2].charValue();
        }
        return cArray;
    }

    public static char[] toPrimitive(Character[] array, char valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Character c2 = array[i2];
            cArray[i2] = c2 == null ? valueForNull : c2.charValue();
        }
        return cArray;
    }

    public static Character[] toObject(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] characterArray = new Character[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            characterArray[i2] = Character.valueOf(array[i2]);
        }
        return characterArray;
    }

    public static long[] toPrimitive(Long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            lArray[i2] = array[i2];
        }
        return lArray;
    }

    public static long[] toPrimitive(Long[] array, long valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Long l2 = array[i2];
            lArray[i2] = l2 == null ? valueForNull : l2;
        }
        return lArray;
    }

    public static Long[] toObject(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] longArray = new Long[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            longArray[i2] = array[i2];
        }
        return longArray;
    }

    public static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            nArray[i2] = array[i2];
        }
        return nArray;
    }

    public static int[] toPrimitive(Integer[] array, int valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Integer n2 = array[i2];
            nArray[i2] = n2 == null ? valueForNull : n2;
        }
        return nArray;
    }

    public static Integer[] toObject(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] integerArray = new Integer[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            integerArray[i2] = array[i2];
        }
        return integerArray;
    }

    public static short[] toPrimitive(Short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            sArray[i2] = array[i2];
        }
        return sArray;
    }

    public static short[] toPrimitive(Short[] array, short valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Short s2 = array[i2];
            sArray[i2] = s2 == null ? valueForNull : s2;
        }
        return sArray;
    }

    public static Short[] toObject(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] shortArray = new Short[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            shortArray[i2] = array[i2];
        }
        return shortArray;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            byArray[i2] = array[i2];
        }
        return byArray;
    }

    public static byte[] toPrimitive(Byte[] array, byte valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Byte by = array[i2];
            byArray[i2] = by == null ? valueForNull : by;
        }
        return byArray;
    }

    public static Byte[] toObject(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] byteArray = new Byte[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            byteArray[i2] = array[i2];
        }
        return byteArray;
    }

    public static double[] toPrimitive(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            dArray[i2] = array[i2];
        }
        return dArray;
    }

    public static double[] toPrimitive(Double[] array, double valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Double d2 = array[i2];
            dArray[i2] = d2 == null ? valueForNull : d2;
        }
        return dArray;
    }

    public static Double[] toObject(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] doubleArray = new Double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            doubleArray[i2] = array[i2];
        }
        return doubleArray;
    }

    public static float[] toPrimitive(Float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            fArray[i2] = array[i2].floatValue();
        }
        return fArray;
    }

    public static float[] toPrimitive(Float[] array, float valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Float f2 = array[i2];
            fArray[i2] = f2 == null ? valueForNull : f2.floatValue();
        }
        return fArray;
    }

    public static Float[] toObject(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] floatArray = new Float[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            floatArray[i2] = Float.valueOf(array[i2]);
        }
        return floatArray;
    }

    public static Object toPrimitive(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> clazz = array.getClass().getComponentType();
        Class<?> clazz2 = ClassUtils.wrapperToPrimitive(clazz);
        if (Integer.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Integer[])array);
        }
        if (Long.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Long[])array);
        }
        if (Short.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Short[])array);
        }
        if (Double.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Double[])array);
        }
        if (Float.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Float[])array);
        }
        return array;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            blArray[i2] = array[i2];
        }
        return blArray;
    }

    public static boolean[] toPrimitive(Boolean[] array, boolean valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Boolean bl = array[i2];
            blArray[i2] = bl == null ? valueForNull : bl;
        }
        return blArray;
    }

    public static Boolean[] toObject(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] booleanArray = new Boolean[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            booleanArray[i2] = array[i2] ? Boolean.TRUE : Boolean.FALSE;
        }
        return booleanArray;
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(long[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(int[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(short[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(char[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(double[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(float[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(long[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(short[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(char[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(double[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(float[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        Class<?> clazz = array1.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, array1.length + array2.length);
        System.arraycopy(array1, 0, objectArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, objectArray, array1.length, array2.length);
        }
        catch (ArrayStoreException arrayStoreException) {
            Class<?> clazz2 = array2.getClass().getComponentType();
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Cannot store " + clazz2.getName() + " in an array of " + clazz.getName(), arrayStoreException);
            }
            throw arrayStoreException;
        }
        return objectArray;
    }

    public static boolean[] addAll(boolean[] array1, boolean ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        boolean[] blArray = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, blArray, 0, array1.length);
        System.arraycopy(array2, 0, blArray, array1.length, array2.length);
        return blArray;
    }

    public static char[] addAll(char[] array1, char ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        char[] cArray = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, cArray, 0, array1.length);
        System.arraycopy(array2, 0, cArray, array1.length, array2.length);
        return cArray;
    }

    public static byte[] addAll(byte[] array1, byte ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        byte[] byArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, byArray, 0, array1.length);
        System.arraycopy(array2, 0, byArray, array1.length, array2.length);
        return byArray;
    }

    public static short[] addAll(short[] array1, short ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        short[] sArray = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, sArray, 0, array1.length);
        System.arraycopy(array2, 0, sArray, array1.length, array2.length);
        return sArray;
    }

    public static int[] addAll(int[] array1, int ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        int[] nArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, nArray, 0, array1.length);
        System.arraycopy(array2, 0, nArray, array1.length, array2.length);
        return nArray;
    }

    public static long[] addAll(long[] array1, long ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        long[] lArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, lArray, 0, array1.length);
        System.arraycopy(array2, 0, lArray, array1.length, array2.length);
        return lArray;
    }

    public static float[] addAll(float[] array1, float ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        float[] fArray = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, fArray, 0, array1.length);
        System.arraycopy(array2, 0, fArray, array1.length, array2.length);
        return fArray;
    }

    public static double[] addAll(double[] array1, double ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        double[] dArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, dArray, 0, array1.length);
        System.arraycopy(array2, 0, dArray, array1.length, array2.length);
        return dArray;
    }

    public static <T> T[] add(T[] array, T element) {
        Class<?> clazz;
        if (array != null) {
            clazz = array.getClass().getComponentType();
        } else if (element != null) {
            clazz = element.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        Object[] objectArray = (Object[])ArrayUtils.copyArrayGrow1(array, clazz);
        Object[] objectArray2 = objectArray;
        objectArray[objectArray2.length - 1] = element;
        return objectArray2;
    }

    public static boolean[] add(boolean[] array, boolean element) {
        boolean[] blArray = (boolean[])ArrayUtils.copyArrayGrow1(array, Boolean.TYPE);
        boolean[] blArray2 = blArray;
        blArray[blArray2.length - 1] = element;
        return blArray2;
    }

    public static byte[] add(byte[] array, byte element) {
        byte[] byArray = (byte[])ArrayUtils.copyArrayGrow1(array, Byte.TYPE);
        byte[] byArray2 = byArray;
        byArray[byArray2.length - 1] = element;
        return byArray2;
    }

    public static char[] add(char[] array, char element) {
        char[] cArray = (char[])ArrayUtils.copyArrayGrow1(array, Character.TYPE);
        char[] cArray2 = cArray;
        cArray[cArray2.length - 1] = element;
        return cArray2;
    }

    public static double[] add(double[] array, double element) {
        double[] dArray = (double[])ArrayUtils.copyArrayGrow1(array, Double.TYPE);
        double[] dArray2 = dArray;
        dArray[dArray2.length - 1] = element;
        return dArray2;
    }

    public static float[] add(float[] array, float element) {
        float[] fArray = (float[])ArrayUtils.copyArrayGrow1(array, Float.TYPE);
        float[] fArray2 = fArray;
        fArray[fArray2.length - 1] = element;
        return fArray2;
    }

    public static int[] add(int[] array, int element) {
        int[] nArray = (int[])ArrayUtils.copyArrayGrow1(array, Integer.TYPE);
        int[] nArray2 = nArray;
        nArray[nArray2.length - 1] = element;
        return nArray2;
    }

    public static long[] add(long[] array, long element) {
        long[] lArray = (long[])ArrayUtils.copyArrayGrow1(array, Long.TYPE);
        long[] lArray2 = lArray;
        lArray[lArray2.length - 1] = element;
        return lArray2;
    }

    public static short[] add(short[] array, short element) {
        short[] sArray = (short[])ArrayUtils.copyArrayGrow1(array, Short.TYPE);
        short[] sArray2 = sArray;
        sArray[sArray2.length - 1] = element;
        return sArray2;
    }

    private static Object copyArrayGrow1(Object array, Class<?> newArrayComponentType) {
        if (array != null) {
            int n2 = Array.getLength(array);
            Object object = Array.newInstance(array.getClass().getComponentType(), n2 + 1);
            System.arraycopy(array, 0, object, 0, n2);
            return object;
        }
        return Array.newInstance(newArrayComponentType, 1);
    }

    @Deprecated
    public static <T> T[] add(T[] array, int index, T element) {
        Class<?> clss;
        if (array != null) {
            clss = array.getClass().getComponentType();
        } else if (element != null) {
            clss = element.getClass();
        } else {
            throw new IllegalArgumentException("Array and element cannot both be null");
        }
        Object[] objectArray = (Object[])ArrayUtils.add(array, index, element, clss);
        return objectArray;
    }

    @Deprecated
    public static boolean[] add(boolean[] array, int index, boolean element) {
        return (boolean[])ArrayUtils.add(array, index, element, Boolean.TYPE);
    }

    @Deprecated
    public static char[] add(char[] array, int index, char element) {
        return (char[])ArrayUtils.add(array, index, Character.valueOf(element), Character.TYPE);
    }

    @Deprecated
    public static byte[] add(byte[] array, int index, byte element) {
        return (byte[])ArrayUtils.add(array, index, element, Byte.TYPE);
    }

    @Deprecated
    public static short[] add(short[] array, int index, short element) {
        return (short[])ArrayUtils.add(array, index, element, Short.TYPE);
    }

    @Deprecated
    public static int[] add(int[] array, int index, int element) {
        return (int[])ArrayUtils.add(array, index, element, Integer.TYPE);
    }

    @Deprecated
    public static long[] add(long[] array, int index, long element) {
        return (long[])ArrayUtils.add(array, index, element, Long.TYPE);
    }

    @Deprecated
    public static float[] add(float[] array, int index, float element) {
        return (float[])ArrayUtils.add(array, index, Float.valueOf(element), Float.TYPE);
    }

    @Deprecated
    public static double[] add(double[] array, int index, double element) {
        return (double[])ArrayUtils.add(array, index, element, Double.TYPE);
    }

    private static Object add(Object array, int index, Object element, Class<?> clss) {
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object object = Array.newInstance(clss, 1);
            Array.set(object, 0, element);
            return object;
        }
        int n2 = Array.getLength(array);
        if (index > n2 || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + n2);
        }
        Object object = Array.newInstance(clss, n2 + 1);
        System.arraycopy(array, 0, object, 0, index);
        Array.set(object, index, element);
        if (index < n2) {
            System.arraycopy(array, index, object, index + 1, n2 - index);
        }
        return object;
    }

    public static <T> T[] remove(T[] array, int index) {
        return (Object[])ArrayUtils.remove(array, index);
    }

    public static <T> T[] removeElement(T[] array, Object element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static boolean[] remove(boolean[] array, int index) {
        return (boolean[])ArrayUtils.remove((Object)array, index);
    }

    public static boolean[] removeElement(boolean[] array, boolean element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static byte[] remove(byte[] array, int index) {
        return (byte[])ArrayUtils.remove((Object)array, index);
    }

    public static byte[] removeElement(byte[] array, byte element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static char[] remove(char[] array, int index) {
        return (char[])ArrayUtils.remove((Object)array, index);
    }

    public static char[] removeElement(char[] array, char element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static double[] remove(double[] array, int index) {
        return (double[])ArrayUtils.remove((Object)array, index);
    }

    public static double[] removeElement(double[] array, double element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static float[] remove(float[] array, int index) {
        return (float[])ArrayUtils.remove((Object)array, index);
    }

    public static float[] removeElement(float[] array, float element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static int[] remove(int[] array, int index) {
        return (int[])ArrayUtils.remove((Object)array, index);
    }

    public static int[] removeElement(int[] array, int element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static long[] remove(long[] array, int index) {
        return (long[])ArrayUtils.remove((Object)array, index);
    }

    public static long[] removeElement(long[] array, long element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    public static short[] remove(short[] array, int index) {
        return (short[])ArrayUtils.remove((Object)array, index);
    }

    public static short[] removeElement(short[] array, short element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, n2);
    }

    private static Object remove(Object array, int index) {
        int n2 = ArrayUtils.getLength(array);
        if (index < 0 || index >= n2) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + n2);
        }
        Object object = Array.newInstance(array.getClass().getComponentType(), n2 - 1);
        System.arraycopy(array, 0, object, 0, index);
        if (index < n2 - 1) {
            System.arraycopy(array, index + 1, object, index, n2 - index - 1);
        }
        return object;
    }

    public static <T> T[] removeAll(T[] array, int ... indices) {
        return (Object[])ArrayUtils.removeAll(array, indices);
    }

    @SafeVarargs
    public static <T> T[] removeElements(T[] array, T ... values) {
        Object object;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<T, MutableInt> hashMap = new HashMap<T, MutableInt>(values.length);
        Object object2 = values;
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = object2[i2];
            MutableInt mutableInt = (MutableInt)hashMap.get(object);
            if (mutableInt == null) {
                hashMap.put(object, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object2 = new BitSet();
        for (n2 = 0; n2 < array.length; ++n2) {
            T t2 = array[n2];
            object = (MutableInt)hashMap.get(t2);
            if (object == null) continue;
            if (((MutableInt)object).decrementAndGet() == 0) {
                hashMap.remove(t2);
            }
            ((BitSet)object2).set(n2);
        }
        Object[] objectArray = (Object[])ArrayUtils.removeAll(array, object2);
        return objectArray;
    }

    public static byte[] removeAll(byte[] array, int ... indices) {
        return (byte[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static byte[] removeElements(byte[] array, byte ... values) {
        int n2;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Byte, MutableInt> hashMap = new HashMap<Byte, MutableInt>(values.length);
        Object object = values;
        int n3 = values.length;
        for (n2 = 0; n2 < n3; ++n2) {
            byte by = object[n2];
            Byte by2 = by;
            MutableInt mutableInt = (MutableInt)hashMap.get(by2);
            if (mutableInt == null) {
                hashMap.put(by2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n3 = 0; n3 < array.length; ++n3) {
            n2 = array[n3];
            MutableInt mutableInt = (MutableInt)hashMap.get((byte)n2);
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove((byte)n2);
            }
            ((BitSet)object).set(n3);
        }
        return (byte[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    public static short[] removeAll(short[] array, int ... indices) {
        return (short[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static short[] removeElements(short[] array, short ... values) {
        int n2;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Short, MutableInt> hashMap = new HashMap<Short, MutableInt>(values.length);
        Object object = values;
        int n3 = values.length;
        for (n2 = 0; n2 < n3; ++n2) {
            short s2 = object[n2];
            Short s3 = s2;
            MutableInt mutableInt = (MutableInt)hashMap.get(s3);
            if (mutableInt == null) {
                hashMap.put(s3, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n3 = 0; n3 < array.length; ++n3) {
            n2 = array[n3];
            MutableInt mutableInt = (MutableInt)hashMap.get((short)n2);
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove((short)n2);
            }
            ((BitSet)object).set(n3);
        }
        return (short[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    public static int[] removeAll(int[] array, int ... indices) {
        return (int[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static int[] removeElements(int[] array, int ... values) {
        int n2;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Integer, MutableInt> hashMap = new HashMap<Integer, MutableInt>(values.length);
        Object object = values;
        int n3 = values.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = object[n2];
            Integer n5 = n4;
            MutableInt mutableInt = (MutableInt)hashMap.get(n5);
            if (mutableInt == null) {
                hashMap.put(n5, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n3 = 0; n3 < array.length; ++n3) {
            n2 = array[n3];
            MutableInt mutableInt = (MutableInt)hashMap.get(n2);
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove(n2);
            }
            ((BitSet)object).set(n3);
        }
        return (int[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    public static char[] removeAll(char[] array, int ... indices) {
        return (char[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static char[] removeElements(char[] array, char ... values) {
        int n2;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Character, MutableInt> hashMap = new HashMap<Character, MutableInt>(values.length);
        Object object = values;
        int n3 = values.length;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = object[n2];
            Character c3 = Character.valueOf(c2);
            MutableInt mutableInt = (MutableInt)hashMap.get(c3);
            if (mutableInt == null) {
                hashMap.put(c3, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n3 = 0; n3 < array.length; ++n3) {
            n2 = array[n3];
            MutableInt mutableInt = (MutableInt)hashMap.get(Character.valueOf((char)n2));
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove(Character.valueOf((char)n2));
            }
            ((BitSet)object).set(n3);
        }
        return (char[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    public static long[] removeAll(long[] array, int ... indices) {
        return (long[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static long[] removeElements(long[] array, long ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Long, MutableInt> hashMap = new HashMap<Long, MutableInt>(values.length);
        Object object = values;
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = object[i2];
            Long l3 = l2;
            MutableInt mutableInt = (MutableInt)hashMap.get(l3);
            if (mutableInt == null) {
                hashMap.put(l3, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n2 = 0; n2 < array.length; ++n2) {
            long l4 = array[n2];
            MutableInt mutableInt = (MutableInt)hashMap.get(l4);
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove(l4);
            }
            ((BitSet)object).set(n2);
        }
        return (long[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    public static float[] removeAll(float[] array, int ... indices) {
        return (float[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static float[] removeElements(float[] array, float ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Float, MutableInt> hashMap = new HashMap<Float, MutableInt>(values.length);
        Object object = values;
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = object[i2];
            Float f3 = Float.valueOf(f2);
            MutableInt mutableInt = (MutableInt)hashMap.get(f3);
            if (mutableInt == null) {
                hashMap.put(f3, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n2 = 0; n2 < array.length; ++n2) {
            float f4 = array[n2];
            MutableInt mutableInt = (MutableInt)hashMap.get(Float.valueOf(f4));
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove(Float.valueOf(f4));
            }
            ((BitSet)object).set(n2);
        }
        return (float[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    public static double[] removeAll(double[] array, int ... indices) {
        return (double[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static double[] removeElements(double[] array, double ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Double, MutableInt> hashMap = new HashMap<Double, MutableInt>(values.length);
        Object object = values;
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = object[i2];
            Double d3 = d2;
            MutableInt mutableInt = (MutableInt)hashMap.get(d3);
            if (mutableInt == null) {
                hashMap.put(d3, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n2 = 0; n2 < array.length; ++n2) {
            double d4 = array[n2];
            MutableInt mutableInt = (MutableInt)hashMap.get(d4);
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove(d4);
            }
            ((BitSet)object).set(n2);
        }
        return (double[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    public static boolean[] removeAll(boolean[] array, int ... indices) {
        return (boolean[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static boolean[] removeElements(boolean[] array, boolean ... values) {
        int n2;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Boolean, MutableInt> hashMap = new HashMap<Boolean, MutableInt>(2);
        Object object = values;
        int n3 = values.length;
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl = object[n2];
            Boolean bl2 = bl;
            MutableInt mutableInt = (MutableInt)hashMap.get(bl2);
            if (mutableInt == null) {
                hashMap.put(bl2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        object = new BitSet();
        for (n3 = 0; n3 < array.length; ++n3) {
            n2 = array[n3];
            MutableInt mutableInt = (MutableInt)hashMap.get(n2 != 0);
            if (mutableInt == null) continue;
            if (mutableInt.decrementAndGet() == 0) {
                hashMap.remove(n2 != 0);
            }
            ((BitSet)object).set(n3);
        }
        return (boolean[])ArrayUtils.removeAll((Object)array, (BitSet)object);
    }

    static Object removeAll(Object array, int ... indices) {
        int n2;
        int n3;
        int n4 = ArrayUtils.getLength(array);
        int n5 = 0;
        int[] nArray = ArrayUtils.clone(indices);
        Arrays.sort(nArray);
        if (ArrayUtils.isNotEmpty(nArray)) {
            int n6 = nArray.length;
            n3 = n4;
            while (--n6 >= 0) {
                n2 = nArray[n6];
                if (n2 < 0 || n2 >= n4) {
                    throw new IndexOutOfBoundsException("Index: " + n2 + ", Length: " + n4);
                }
                if (n2 >= n3) continue;
                ++n5;
                n3 = n2;
            }
        }
        Object object = Array.newInstance(array.getClass().getComponentType(), n4 - n5);
        if (n5 < n4) {
            n3 = n4;
            n2 = n4 - n5;
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                int n7 = nArray[i2];
                if (n3 - n7 > 1) {
                    int n8 = n3 - n7 - 1;
                    System.arraycopy(array, n7 + 1, object, n2 -= n8, n8);
                }
                n3 = n7;
            }
            if (n3 > 0) {
                System.arraycopy(array, 0, object, 0, n3);
            }
        }
        return object;
    }

    static Object removeAll(Object array, BitSet indices) {
        int n2;
        int n3;
        int n4 = ArrayUtils.getLength(array);
        int n5 = indices.cardinality();
        Object object = Array.newInstance(array.getClass().getComponentType(), n4 - n5);
        int n6 = 0;
        int n7 = 0;
        while ((n3 = indices.nextSetBit(n6)) != -1) {
            n2 = n3 - n6;
            if (n2 > 0) {
                System.arraycopy(array, n6, object, n7, n2);
                n7 += n2;
            }
            n6 = indices.nextClearBit(n3);
        }
        n2 = n4 - n6;
        if (n2 > 0) {
            System.arraycopy(array, n6, object, n7, n2);
        }
        return object;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayUtils.isSorted(array, new Comparator<T>(){

            @Override
            public final int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public static <T> boolean isSorted(T[] array, Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator should not be null.");
        }
        if (array == null || array.length < 2) {
            return true;
        }
        T t2 = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            T t3 = array[i2];
            if (comparator.compare(t2, t3) > 0) {
                return false;
            }
            t2 = t3;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        int n2 = array[0];
        int n3 = array.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            int n4 = array[i2];
            if (NumberUtils.compare(n2, n4) > 0) {
                return false;
            }
            n2 = n4;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        long l2 = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            long l3 = array[i2];
            if (NumberUtils.compare(l2, l3) > 0) {
                return false;
            }
            l2 = l3;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        short s2 = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            short s3 = array[i2];
            if (NumberUtils.compare(s2, s3) > 0) {
                return false;
            }
            s2 = s3;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        double d2 = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            double d3 = array[i2];
            if (Double.compare(d2, d3) > 0) {
                return false;
            }
            d2 = d3;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        float f2 = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            float f3 = array[i2];
            if (Float.compare(f2, f3) > 0) {
                return false;
            }
            f2 = f3;
        }
        return true;
    }

    public static boolean isSorted(byte[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        byte by = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            byte by2 = array[i2];
            if (NumberUtils.compare(by, by2) > 0) {
                return false;
            }
            by = by2;
        }
        return true;
    }

    public static boolean isSorted(char[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        char c2 = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            char c3 = array[i2];
            if (CharUtils.compare(c2, c3) > 0) {
                return false;
            }
            c2 = c3;
        }
        return true;
    }

    public static boolean isSorted(boolean[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        boolean bl = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            boolean bl2 = array[i2];
            if (BooleanUtils.compare(bl, bl2) > 0) {
                return false;
            }
            bl = bl2;
        }
        return true;
    }

    public static boolean[] removeAllOccurences(boolean[] array, boolean element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static char[] removeAllOccurences(char[] array, char element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static byte[] removeAllOccurences(byte[] array, byte element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static short[] removeAllOccurences(short[] array, short element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static int[] removeAllOccurences(int[] array, int element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static long[] removeAllOccurences(long[] array, long element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static float[] removeAllOccurences(float[] array, float element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static double[] removeAllOccurences(double[] array, double element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static <T> T[] removeAllOccurences(T[] array, T element) {
        int n2 = ArrayUtils.indexOf(array, element);
        if (n2 == -1) {
            return ArrayUtils.clone(array);
        }
        int[] nArray = new int[array.length - n2];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        int n3 = 1;
        while ((n2 = ArrayUtils.indexOf(array, element, nArray2[n3 - 1] + 1)) != -1) {
            nArray2[n3++] = n2;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(nArray2, n3));
    }

    public static String[] toStringArray(Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            stringArray[i2] = array[i2].toString();
        }
        return stringArray;
    }

    public static String[] toStringArray(Object[] array, String valueForNullElements) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Object object = array[i2];
            stringArray[i2] = object == null ? valueForNullElements : object.toString();
        }
        return stringArray;
    }

    public static boolean[] insert(int index, boolean[] array, boolean ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        boolean[] blArray = new boolean[array.length + values.length];
        System.arraycopy(values, 0, blArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, blArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, blArray, index + values.length, array.length - index);
        }
        return blArray;
    }

    public static byte[] insert(int index, byte[] array, byte ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        byte[] byArray = new byte[array.length + values.length];
        System.arraycopy(values, 0, byArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, byArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, byArray, index + values.length, array.length - index);
        }
        return byArray;
    }

    public static char[] insert(int index, char[] array, char ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        char[] cArray = new char[array.length + values.length];
        System.arraycopy(values, 0, cArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, cArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, cArray, index + values.length, array.length - index);
        }
        return cArray;
    }

    public static double[] insert(int index, double[] array, double ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        double[] dArray = new double[array.length + values.length];
        System.arraycopy(values, 0, dArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, dArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, dArray, index + values.length, array.length - index);
        }
        return dArray;
    }

    public static float[] insert(int index, float[] array, float ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        float[] fArray = new float[array.length + values.length];
        System.arraycopy(values, 0, fArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, fArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, fArray, index + values.length, array.length - index);
        }
        return fArray;
    }

    public static int[] insert(int index, int[] array, int ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        int[] nArray = new int[array.length + values.length];
        System.arraycopy(values, 0, nArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, nArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, nArray, index + values.length, array.length - index);
        }
        return nArray;
    }

    public static long[] insert(int index, long[] array, long ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        long[] lArray = new long[array.length + values.length];
        System.arraycopy(values, 0, lArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, lArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, lArray, index + values.length, array.length - index);
        }
        return lArray;
    }

    public static short[] insert(int index, short[] array, short ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        short[] sArray = new short[array.length + values.length];
        System.arraycopy(values, 0, sArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, sArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, sArray, index + values.length, array.length - index);
        }
        return sArray;
    }

    @SafeVarargs
    public static <T> T[] insert(int index, T[] array, T ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        Class<?> clazz = array.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, array.length + values.length);
        System.arraycopy(values, 0, objectArray, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, objectArray, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, objectArray, index + values.length, array.length - index);
        }
        return objectArray;
    }

    public static void shuffle(Object[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(Object[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(boolean[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(boolean[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(byte[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(byte[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(char[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(char[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(short[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(short[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(int[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(int[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(long[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(long[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(float[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(float[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(double[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(double[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }
}

