/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerBuilderBlobDefault;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.PointerFactory;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.SetPointerBuilder;
import org.capnproto.WireHelpers;

public final class Data {
    public static final Factory factory = new Factory();

    public static final class Builder {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Builder() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Builder(ByteBuffer byteBuffer, int n2, int n3) {
            this.buffer = byteBuffer;
            this.offset = n2;
            this.size = n3;
        }

        public final ByteBuffer asByteBuffer() {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byteBuffer.position(this.offset);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(this.size);
            return byteBuffer2;
        }

        public final byte[] toArray() {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byte[] byArray = new byte[this.size];
            byteBuffer.position(this.offset);
            byteBuffer.get(byArray, 0, this.size);
            return byArray;
        }
    }

    public static final class Reader {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Reader() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Reader(ByteBuffer byteBuffer, int n2, int n3) {
            this.buffer = byteBuffer;
            this.offset = n2 << 3;
            this.size = n3;
        }

        public Reader(byte[] byArray) {
            this.buffer = ByteBuffer.wrap(byArray);
            this.offset = 0;
            this.size = byArray.length;
        }

        public final int size() {
            return this.size;
        }

        public final ByteBuffer asByteBuffer() {
            ByteBuffer byteBuffer = this.buffer.asReadOnlyBuffer();
            byteBuffer.position(this.offset);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(this.size);
            return byteBuffer2;
        }

        public final byte[] toArray() {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byte[] byArray = new byte[this.size];
            byteBuffer.position(this.offset);
            byteBuffer.get(byArray, 0, this.size);
            return byArray;
        }
    }

    public static final class Factory
    implements FromPointerBuilderBlobDefault<Builder>,
    FromPointerReaderBlobDefault<Reader>,
    PointerFactory<Builder, Reader>,
    SetPointerBuilder<Builder, Reader> {
        @Override
        public final Reader fromPointerReaderBlobDefault(SegmentReader segmentReader, int n2, ByteBuffer byteBuffer, int n3, int n4) {
            return WireHelpers.readDataPointer(segmentReader, n2, byteBuffer, n3, n4);
        }

        @Override
        public final Reader fromPointerReader(SegmentReader segmentReader, int n2, int n3) {
            return WireHelpers.readDataPointer(segmentReader, n2, null, 0, 0);
        }

        @Override
        public final Builder fromPointerBuilderBlobDefault(SegmentBuilder segmentBuilder, int n2, ByteBuffer byteBuffer, int n3, int n4) {
            return WireHelpers.getWritableDataPointer(n2, segmentBuilder, byteBuffer, n3, n4);
        }

        @Override
        public final Builder fromPointerBuilder(SegmentBuilder segmentBuilder, int n2) {
            return WireHelpers.getWritableDataPointer(n2, segmentBuilder, null, 0, 0);
        }

        @Override
        public final Builder initFromPointerBuilder(SegmentBuilder segmentBuilder, int n2, int n3) {
            return WireHelpers.initDataPointer(n2, segmentBuilder, n3);
        }

        @Override
        public final void setPointerBuilder(SegmentBuilder segmentBuilder, int n2, Reader reader) {
            WireHelpers.setDataPointer(n2, segmentBuilder, reader);
        }
    }
}

