/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public final class YearMonthDay
extends BasePartial
implements Serializable,
ReadablePartial {
    private static final long serialVersionUID = 797544782896179L;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
    public static final int YEAR = 0;
    public static final int MONTH_OF_YEAR = 1;
    public static final int DAY_OF_MONTH = 2;

    public static YearMonthDay fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new YearMonthDay(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static YearMonthDay fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new YearMonthDay(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public YearMonthDay() {
    }

    public YearMonthDay(DateTimeZone dateTimeZone) {
        super(ISOChronology.getInstance(dateTimeZone));
    }

    public YearMonthDay(Chronology chronology) {
        super(chronology);
    }

    public YearMonthDay(long l2) {
        super(l2);
    }

    public YearMonthDay(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public YearMonthDay(Object object) {
        super(object, null, ISODateTimeFormat.dateOptionalTimeParser());
    }

    public YearMonthDay(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.dateOptionalTimeParser());
    }

    public YearMonthDay(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public YearMonthDay(int n2, int n3, int n4, Chronology chronology) {
        super(new int[]{n2, n3, n4}, chronology);
    }

    YearMonthDay(YearMonthDay yearMonthDay, int[] nArray) {
        super((BasePartial)yearMonthDay, nArray);
    }

    YearMonthDay(YearMonthDay yearMonthDay, Chronology chronology) {
        super((BasePartial)yearMonthDay, chronology);
    }

    public final int size() {
        return 3;
    }

    protected final DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            case 0: {
                return chronology.year();
            }
            case 1: {
                return chronology.monthOfYear();
            }
            case 2: {
                return chronology.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    public final DateTimeFieldType getFieldType(int n2) {
        return FIELD_TYPES[n2];
    }

    public final DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public final YearMonthDay withChronologyRetainFields(Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        if ((chronology = chronology.withUTC()) == this.getChronology()) {
            return this;
        }
        YearMonthDay yearMonthDay = new YearMonthDay(this, chronology);
        chronology.validate(yearMonthDay, this.getValues());
        return yearMonthDay;
    }

    public final YearMonthDay withField(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3 = this.indexOfSupported(dateTimeFieldType);
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n3).set(this, n3, nArray, n2);
        return new YearMonthDay(this, nArray);
    }

    public final YearMonthDay withFieldAdded(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n3).add(this, n3, nArray, n2);
        return new YearMonthDay(this, nArray);
    }

    public final YearMonthDay withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            DurationFieldType durationFieldType = readablePeriod.getFieldType(i2);
            int n3 = this.indexOf(durationFieldType);
            if (n3 < 0) continue;
            nArray = this.getField(n3).add(this, n3, nArray, FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2));
        }
        return new YearMonthDay(this, nArray);
    }

    public final YearMonthDay plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public final YearMonthDay plusYears(int n2) {
        return this.withFieldAdded(DurationFieldType.years(), n2);
    }

    public final YearMonthDay plusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), n2);
    }

    public final YearMonthDay plusDays(int n2) {
        return this.withFieldAdded(DurationFieldType.days(), n2);
    }

    public final YearMonthDay minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public final YearMonthDay minusYears(int n2) {
        return this.withFieldAdded(DurationFieldType.years(), FieldUtils.safeNegate(n2));
    }

    public final YearMonthDay minusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(n2));
    }

    public final YearMonthDay minusDays(int n2) {
        return this.withFieldAdded(DurationFieldType.days(), FieldUtils.safeNegate(n2));
    }

    public final Property property(DateTimeFieldType dateTimeFieldType) {
        YearMonthDay yearMonthDay = this;
        return new Property(yearMonthDay, yearMonthDay.indexOfSupported(dateTimeFieldType));
    }

    public final LocalDate toLocalDate() {
        return new LocalDate(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), this.getChronology());
    }

    public final DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    public final DateTime toDateTimeAtMidnight(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chronology);
    }

    public final DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public final DateTime toDateTimeAtCurrentTime(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        long l2 = DateTimeUtils.currentTimeMillis();
        long l3 = chronology.set(this, l2);
        return new DateTime(l3, chronology);
    }

    public final DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    public final DateMidnight toDateMidnight(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chronology);
    }

    public final DateTime toDateTime(TimeOfDay timeOfDay) {
        return this.toDateTime(timeOfDay, null);
    }

    public final DateTime toDateTime(TimeOfDay timeOfDay, DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        long l2 = DateTimeUtils.currentTimeMillis();
        l2 = chronology.set(this, l2);
        if (timeOfDay != null) {
            l2 = chronology.set(timeOfDay, l2);
        }
        return new DateTime(l2, chronology);
    }

    public final Interval toInterval() {
        return this.toInterval(null);
    }

    public final Interval toInterval(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        return this.toDateMidnight(dateTimeZone).toInterval();
    }

    public final int getYear() {
        return this.getValue(0);
    }

    public final int getMonthOfYear() {
        return this.getValue(1);
    }

    public final int getDayOfMonth() {
        return this.getValue(2);
    }

    public final YearMonthDay withYear(int n2) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().year().set(this, 0, nArray, n2);
        return new YearMonthDay(this, nArray);
    }

    public final YearMonthDay withMonthOfYear(int n2) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().monthOfYear().set(this, 1, nArray, n2);
        return new YearMonthDay(this, nArray);
    }

    public final YearMonthDay withDayOfMonth(int n2) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().dayOfMonth().set(this, 2, nArray, n2);
        return new YearMonthDay(this, nArray);
    }

    public final Property year() {
        return new Property(this, 0);
    }

    public final Property monthOfYear() {
        return new Property(this, 1);
    }

    public final Property dayOfMonth() {
        return new Property(this, 2);
    }

    public final String toString() {
        return ISODateTimeFormat.yearMonthDay().print(this);
    }

    @Deprecated
    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final YearMonthDay iYearMonthDay;
        private final int iFieldIndex;

        Property(YearMonthDay yearMonthDay, int n2) {
            this.iYearMonthDay = yearMonthDay;
            this.iFieldIndex = n2;
        }

        public DateTimeField getField() {
            return this.iYearMonthDay.getField(this.iFieldIndex);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iYearMonthDay;
        }

        public YearMonthDay getYearMonthDay() {
            return this.iYearMonthDay;
        }

        public int get() {
            return this.iYearMonthDay.getValue(this.iFieldIndex);
        }

        public YearMonthDay addToCopy(int n2) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().add(this.iYearMonthDay, this.iFieldIndex, nArray, n2);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }

        public YearMonthDay addWrapFieldToCopy(int n2) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().addWrapField(this.iYearMonthDay, this.iFieldIndex, nArray, n2);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }

        public YearMonthDay setCopy(int n2) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().set(this.iYearMonthDay, this.iFieldIndex, nArray, n2);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }

        public YearMonthDay setCopy(String string, Locale locale) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().set(this.iYearMonthDay, this.iFieldIndex, nArray, string, locale);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }

        public YearMonthDay setCopy(String string) {
            return this.setCopy(string, null);
        }

        public YearMonthDay withMaximumValue() {
            Property property = this;
            return property.setCopy(property.getMaximumValue());
        }

        public YearMonthDay withMinimumValue() {
            Property property = this;
            return property.setCopy(property.getMinimumValue());
        }
    }
}

