/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.convert.ToString;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public abstract class AbstractPeriod
implements ReadablePeriod {
    protected AbstractPeriod() {
    }

    public int size() {
        return this.getPeriodType().size();
    }

    public DurationFieldType getFieldType(int n2) {
        return this.getPeriodType().getFieldType(n2);
    }

    public DurationFieldType[] getFieldTypes() {
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[this.size()];
        for (int i2 = 0; i2 < durationFieldTypeArray.length; ++i2) {
            durationFieldTypeArray[i2] = this.getFieldType(i2);
        }
        return durationFieldTypeArray;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.getValue(i2);
        }
        return nArray;
    }

    public int get(DurationFieldType durationFieldType) {
        int n2 = this.indexOf(durationFieldType);
        if (n2 == -1) {
            return 0;
        }
        return this.getValue(n2);
    }

    public boolean isSupported(DurationFieldType durationFieldType) {
        return this.getPeriodType().isSupported(durationFieldType);
    }

    public int indexOf(DurationFieldType durationFieldType) {
        return this.getPeriodType().indexOf(durationFieldType);
    }

    public Period toPeriod() {
        return new Period(this);
    }

    public MutablePeriod toMutablePeriod() {
        return new MutablePeriod(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod readablePeriod = (ReadablePeriod)object;
        if (this.size() != readablePeriod.size()) {
            return false;
        }
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.getValue(i2) == readablePeriod.getValue(i2) && this.getFieldType(i2) == readablePeriod.getFieldType(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 17;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = n2 * 27 + this.getValue(i2);
            n2 = n2 * 27 + this.getFieldType(i2).hashCode();
        }
        return n2;
    }

    @ToString
    public String toString() {
        return ISOPeriodFormat.standard().print(this);
    }

    public String toString(PeriodFormatter periodFormatter) {
        if (periodFormatter == null) {
            return this.toString();
        }
        return periodFormatter.print(this);
    }
}

