/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

final class BasicWeekyearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = 6215066916806820644L;
    private static final long WEEK_53 = 31449600000L;
    private final BasicChronology iChronology;

    BasicWeekyearDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.weekyear(), basicChronology.getAverageMillisPerYear());
        this.iChronology = basicChronology;
    }

    public final boolean isLenient() {
        return false;
    }

    public final int get(long l2) {
        return this.iChronology.getWeekyear(l2);
    }

    public final long add(long l2, int n2) {
        if (n2 == 0) {
            return l2;
        }
        return this.set(l2, this.get(l2) + n2);
    }

    public final long add(long l2, long l3) {
        return this.add(l2, FieldUtils.safeToInt(l3));
    }

    public final long addWrapField(long l2, int n2) {
        return this.add(l2, n2);
    }

    public final long getDifferenceAsLong(long l2, long l3) {
        if (l2 < l3) {
            return -this.getDifference(l3, l2);
        }
        int n2 = this.get(l2);
        int n3 = this.get(l3);
        long l4 = this.remainder(l2);
        long l5 = this.remainder(l3);
        if (l5 >= 31449600000L && this.iChronology.getWeeksInYear(n2) <= 52) {
            l5 -= 604800000L;
        }
        int n4 = n2 - n3;
        if (l4 < l5) {
            --n4;
        }
        return n4;
    }

    public final long set(long l2, int n2) {
        long l3;
        int n3;
        FieldUtils.verifyValueBounds(this, Math.abs(n2), this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        int n4 = this.get(l2);
        if (n4 == n2) {
            return l2;
        }
        int n5 = this.iChronology.getDayOfWeek(l2);
        int n6 = this.iChronology.getWeeksInYear(n4);
        int n7 = this.iChronology.getWeeksInYear(n2);
        int n8 = n7 < n6 ? n7 : n6;
        int n9 = this.iChronology.getWeekOfWeekyear(l2);
        if (n9 > n8) {
            n9 = n8;
        }
        if ((n3 = this.get(l3 = this.iChronology.setYear(l2, n2))) < n2) {
            l3 += 604800000L;
        } else if (n3 > n2) {
            l3 -= 604800000L;
        }
        int n10 = this.iChronology.getWeekOfWeekyear(l3);
        l3 += (long)(n9 - n10) * 604800000L;
        l3 = this.iChronology.dayOfWeek().set(l3, n5);
        return l3;
    }

    public final DurationField getRangeDurationField() {
        return null;
    }

    public final boolean isLeap(long l2) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(l2)) > 52;
    }

    public final int getLeapAmount(long l2) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(l2)) - 52;
    }

    public final DurationField getLeapDurationField() {
        return this.iChronology.weeks();
    }

    public final int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    public final int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    public final long roundFloor(long l2) {
        l2 = this.iChronology.weekOfWeekyear().roundFloor(l2);
        int n2 = this.iChronology.getWeekOfWeekyear(l2);
        if (n2 > 1) {
            l2 -= 604800000L * (long)(n2 - 1);
        }
        return l2;
    }

    public final long remainder(long l2) {
        return l2 - this.roundFloor(l2);
    }

    private Object readResolve() {
        return this.iChronology.weekyear();
    }
}

