/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

final class NameScope {
    private final String opPrefix;
    private final String opName;
    private final Map<String, Integer> ids;
    private static final Pattern NAME_REGEX = Pattern.compile("[A-Za-z0-9.][A-Za-z0-9_.\\-]*");

    final NameScope withSubScope(String scopeName) {
        NameScope.checkPattern(NAME_REGEX, scopeName);
        String string = this.opName != null ? this.opName : scopeName;
        NameScope nameScope = this;
        String string2 = nameScope.fullyQualify(nameScope.makeUnique(string));
        return new NameScope(string2, null, null);
    }

    final NameScope withName(String name) {
        NameScope.checkPattern(NAME_REGEX, name);
        return new NameScope(this.opPrefix, name, this.ids);
    }

    final String makeOpName(String name) {
        NameScope.checkPattern(NAME_REGEX, name);
        String string = this.opName != null ? this.opName : name;
        NameScope nameScope = this;
        return nameScope.fullyQualify(nameScope.makeUnique(string));
    }

    NameScope() {
        this(null, null, null);
    }

    private NameScope(String opPrefix, String opName, Map<String, Integer> ids) {
        this.opPrefix = opPrefix;
        this.opName = opName;
        if (ids != null) {
            this.ids = ids;
            return;
        }
        this.ids = new HashMap<String, Integer>();
    }

    private String makeUnique(String id) {
        if (!this.ids.containsKey(id)) {
            this.ids.put(id, 1);
            return id;
        }
        int n2 = this.ids.get(id);
        this.ids.put(id, n2 + 1);
        return String.format("%s_%d", id, n2);
    }

    private String fullyQualify(String name) {
        if (this.opPrefix != null) {
            return String.format("%s/%s", this.opPrefix, name);
        }
        return name;
    }

    private static void checkPattern(Pattern pattern, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Names cannot be null");
        }
        if (!pattern.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("invalid name: '%s' does not match the regular expression %s", name, NAME_REGEX.pattern()));
        }
    }
}

