/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BarrierTakeMany
extends PrimitiveOp {
    private Output<Long> indices;
    private Output<String> keys;
    private List<Output<?>> values;

    public static BarrierTakeMany create(Scope scope, Operand<String> handle, Operand<Integer> numElements, List<Class<?>> componentTypes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BarrierTakeMany", scope.makeOpName("BarrierTakeMany"));
        operationBuilder.addInput(handle.asOutput());
        operationBuilder.addInput(numElements.asOutput());
        DataType[] dataTypeArray = new DataType[componentTypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(componentTypes.get(i2));
        }
        operationBuilder.setAttr("component_types", dataTypeArray);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.allowSmallBatch != null) {
                    operationBuilder.setAttr("allow_small_batch", options2.allowSmallBatch);
                }
                if (options2.waitForIncomplete != null) {
                    operationBuilder.setAttr("wait_for_incomplete", options2.waitForIncomplete);
                }
                if (options2.timeoutMs == null) continue;
                operationBuilder.setAttr("timeout_ms", options2.timeoutMs);
            }
        }
        return new BarrierTakeMany(operationBuilder.build());
    }

    public static Options allowSmallBatch(Boolean allowSmallBatch) {
        return new Options().allowSmallBatch(allowSmallBatch);
    }

    public static Options waitForIncomplete(Boolean waitForIncomplete) {
        return new Options().waitForIncomplete(waitForIncomplete);
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    public final Output<Long> indices() {
        return this.indices;
    }

    public final Output<String> keys() {
        return this.keys;
    }

    public final List<Output<?>> values() {
        return this.values;
    }

    private BarrierTakeMany(Operation operation) {
        super(operation);
        this.indices = operation.output(0);
        this.keys = operation.output(1);
        int n2 = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(2, n2));
    }

    public static class Options {
        private Boolean allowSmallBatch;
        private Boolean waitForIncomplete;
        private Long timeoutMs;

        public Options allowSmallBatch(Boolean allowSmallBatch) {
            this.allowSmallBatch = allowSmallBatch;
            return this;
        }

        public Options waitForIncomplete(Boolean waitForIncomplete) {
            this.waitForIncomplete = waitForIncomplete;
            return this;
        }

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        private Options() {
        }
    }
}

