/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesTrainingPredict
extends PrimitiveOp {
    private Output<Float> partialLogits;
    private Output<Integer> treeIds;
    private Output<Integer> nodeIds;

    public static BoostedTreesTrainingPredict create(Scope scope, Operand<?> treeEnsembleHandle, Operand<Integer> cachedTreeIds, Operand<Integer> cachedNodeIds, Iterable<Operand<Integer>> bucketizedFeatures, Long logitsDimension) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BoostedTreesTrainingPredict", scope.makeOpName("BoostedTreesTrainingPredict"));
        operationBuilder.addInput(treeEnsembleHandle.asOutput());
        operationBuilder.addInput(cachedTreeIds.asOutput());
        operationBuilder.addInput(cachedNodeIds.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(bucketizedFeatures));
        operationBuilder.setAttr("logits_dimension", logitsDimension);
        return new BoostedTreesTrainingPredict(operationBuilder.build());
    }

    public final Output<Float> partialLogits() {
        return this.partialLogits;
    }

    public final Output<Integer> treeIds() {
        return this.treeIds;
    }

    public final Output<Integer> nodeIds() {
        return this.nodeIds;
    }

    private BoostedTreesTrainingPredict(Operation operation) {
        super(operation);
        this.partialLogits = operation.output(0);
        this.treeIds = operation.output(1);
        this.nodeIds = operation.output(2);
    }
}

