/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ImageSummary
extends PrimitiveOp
implements Operand<String> {
    private Output<String> summary;

    public static <T extends Number> ImageSummary create(Scope scope, Operand<String> tag, Operand<T> tensor, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ImageSummary", scope.makeOpName("ImageSummary"));
        operationBuilder.addInput(tag.asOutput());
        operationBuilder.addInput(tensor.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.maxImages != null) {
                    operationBuilder.setAttr("max_images", options2.maxImages);
                }
                if (options2.badColor == null) continue;
                operationBuilder.setAttr("bad_color", options2.badColor);
            }
        }
        return new ImageSummary(operationBuilder.build());
    }

    public static Options maxImages(Long maxImages) {
        return new Options().maxImages(maxImages);
    }

    public static Options badColor(Tensor<?> badColor) {
        return new Options().badColor(badColor);
    }

    public final Output<String> summary() {
        return this.summary;
    }

    @Override
    public final Output<String> asOutput() {
        return this.summary;
    }

    private ImageSummary(Operation operation) {
        super(operation);
        this.summary = operation.output(0);
    }

    public static class Options {
        private Long maxImages;
        private Tensor<?> badColor;

        public Options maxImages(Long maxImages) {
            this.maxImages = maxImages;
            return this;
        }

        public Options badColor(Tensor<?> badColor) {
            this.badColor = badColor;
            return this;
        }

        private Options() {
        }
    }
}

