/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class InitializeTableFromTextFile
extends PrimitiveOp {
    public static InitializeTableFromTextFile create(Scope scope, Operand<?> tableHandle, Operand<String> filename, Long keyIndex, Long valueIndex, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("InitializeTableFromTextFileV2", scope.makeOpName("InitializeTableFromTextFile"));
        operationBuilder.addInput(tableHandle.asOutput());
        operationBuilder.addInput(filename.asOutput());
        operationBuilder.setAttr("key_index", keyIndex);
        operationBuilder.setAttr("value_index", valueIndex);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.vocabSize != null) {
                    operationBuilder.setAttr("vocab_size", options2.vocabSize);
                }
                if (options2.delimiter == null) continue;
                operationBuilder.setAttr("delimiter", options2.delimiter);
            }
        }
        return new InitializeTableFromTextFile(operationBuilder.build());
    }

    public static Options vocabSize(Long vocabSize) {
        return new Options().vocabSize(vocabSize);
    }

    public static Options delimiter(String delimiter) {
        return new Options().delimiter(delimiter);
    }

    private InitializeTableFromTextFile(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long vocabSize;
        private String delimiter;

        public Options vocabSize(Long vocabSize) {
            this.vocabSize = vocabSize;
            return this;
        }

        public Options delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        private Options() {
        }
    }
}

