/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class LRN<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> LRN<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("LRN", scope.makeOpName("LRN"));
        operationBuilder.addInput(input.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.depthRadius != null) {
                    operationBuilder.setAttr("depth_radius", options2.depthRadius);
                }
                if (options2.bias != null) {
                    operationBuilder.setAttr("bias", options2.bias.floatValue());
                }
                if (options2.alpha != null) {
                    operationBuilder.setAttr("alpha", options2.alpha.floatValue());
                }
                if (options2.beta == null) continue;
                operationBuilder.setAttr("beta", options2.beta.floatValue());
            }
        }
        return new LRN<T>(operationBuilder.build());
    }

    public static Options depthRadius(Long depthRadius) {
        return new Options().depthRadius(depthRadius);
    }

    public static Options bias(Float bias) {
        return new Options().bias(bias);
    }

    public static Options alpha(Float alpha) {
        return new Options().alpha(alpha);
    }

    public static Options beta(Float beta) {
        return new Options().beta(beta);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private LRN(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Long depthRadius;
        private Float bias;
        private Float alpha;
        private Float beta;

        public Options depthRadius(Long depthRadius) {
            this.depthRadius = depthRadius;
            return this;
        }

        public Options bias(Float bias) {
            this.bias = bias;
            return this;
        }

        public Options alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Options beta(Float beta) {
            this.beta = beta;
            return this;
        }

        private Options() {
        }
    }
}

