/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedResizeBilinear<T>
extends PrimitiveOp {
    private Output<T> resizedImages;
    private Output<Float> outMin;
    private Output<Float> outMax;

    public static <T> QuantizedResizeBilinear<T> create(Scope scope, Operand<T> images, Operand<Integer> size, Operand<Float> min, Operand<Float> max, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedResizeBilinear", scope.makeOpName("QuantizedResizeBilinear"));
        operationBuilder.addInput(images.asOutput());
        operationBuilder.addInput(size.asOutput());
        operationBuilder.addInput(min.asOutput());
        operationBuilder.addInput(max.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.alignCorners == null) continue;
                operationBuilder.setAttr("align_corners", options2.alignCorners);
            }
        }
        return new QuantizedResizeBilinear<T>(operationBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public final Output<T> resizedImages() {
        return this.resizedImages;
    }

    public final Output<Float> outMin() {
        return this.outMin;
    }

    public final Output<Float> outMax() {
        return this.outMax;
    }

    private QuantizedResizeBilinear(Operation operation) {
        super(operation);
        this.resizedImages = operation.output(0);
        this.outMin = operation.output(1);
        this.outMax = operation.output(2);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

