/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SampleDistortedBoundingBox<T extends Number>
extends PrimitiveOp {
    private Output<T> begin;
    private Output<T> size;
    private Output<Float> bboxes;

    public static <T extends Number> SampleDistortedBoundingBox<T> create(Scope scope, Operand<T> imageSize, Operand<Float> boundingBoxes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SampleDistortedBoundingBox", scope.makeOpName("SampleDistortedBoundingBox"));
        operationBuilder.addInput(imageSize.asOutput());
        operationBuilder.addInput(boundingBoxes.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                float[] fArray;
                Options options2 = optionsArray[i2];
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 != null) {
                    operationBuilder.setAttr("seed2", options2.seed2);
                }
                if (options2.minObjectCovered != null) {
                    operationBuilder.setAttr("min_object_covered", options2.minObjectCovered.floatValue());
                }
                if (options2.aspectRatioRange != null) {
                    fArray = new float[options2.aspectRatioRange.size()];
                    for (n3 = 0; n3 < fArray.length; ++n3) {
                        fArray[n3] = ((Float)options2.aspectRatioRange.get(n3)).floatValue();
                    }
                    operationBuilder.setAttr("aspect_ratio_range", fArray);
                }
                if (options2.areaRange != null) {
                    fArray = new float[options2.areaRange.size()];
                    for (n3 = 0; n3 < fArray.length; ++n3) {
                        fArray[n3] = ((Float)options2.areaRange.get(n3)).floatValue();
                    }
                    operationBuilder.setAttr("area_range", fArray);
                }
                if (options2.maxAttempts != null) {
                    operationBuilder.setAttr("max_attempts", options2.maxAttempts);
                }
                if (options2.useImageIfNoBoundingBoxes == null) continue;
                operationBuilder.setAttr("use_image_if_no_bounding_boxes", options2.useImageIfNoBoundingBoxes);
            }
        }
        return new SampleDistortedBoundingBox<T>(operationBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options minObjectCovered(Float minObjectCovered) {
        return new Options().minObjectCovered(minObjectCovered);
    }

    public static Options aspectRatioRange(List<Float> aspectRatioRange) {
        return new Options().aspectRatioRange(aspectRatioRange);
    }

    public static Options areaRange(List<Float> areaRange) {
        return new Options().areaRange(areaRange);
    }

    public static Options maxAttempts(Long maxAttempts) {
        return new Options().maxAttempts(maxAttempts);
    }

    public static Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
        return new Options().useImageIfNoBoundingBoxes(useImageIfNoBoundingBoxes);
    }

    public final Output<T> begin() {
        return this.begin;
    }

    public final Output<T> size() {
        return this.size;
    }

    public final Output<Float> bboxes() {
        return this.bboxes;
    }

    private SampleDistortedBoundingBox(Operation operation) {
        super(operation);
        this.begin = operation.output(0);
        this.size = operation.output(1);
        this.bboxes = operation.output(2);
    }

    public static class Options {
        private Long seed;
        private Long seed2;
        private Float minObjectCovered;
        private List<Float> aspectRatioRange;
        private List<Float> areaRange;
        private Long maxAttempts;
        private Boolean useImageIfNoBoundingBoxes;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options minObjectCovered(Float minObjectCovered) {
            this.minObjectCovered = minObjectCovered;
            return this;
        }

        public Options aspectRatioRange(List<Float> aspectRatioRange) {
            this.aspectRatioRange = aspectRatioRange;
            return this;
        }

        public Options areaRange(List<Float> areaRange) {
            this.areaRange = areaRange;
            return this;
        }

        public Options maxAttempts(Long maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
            this.useImageIfNoBoundingBoxes = useImageIfNoBoundingBoxes;
            return this;
        }

        private Options() {
        }
    }
}

