/*
 * Decompiled with CFR 0.152.
 */
package picocli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    public static final String VERSION = "4.5.1";
    private final Tracer tracer = new Tracer();
    private final Model.CommandSpec commandSpec;
    private final Interpreter interpreter;
    private final IFactory factory;
    private Object executionResult;
    private PrintWriter out;
    private PrintWriter err;
    private Help.ColorScheme colorScheme = Help.defaultColorScheme(Help.Ansi.AUTO);
    private IExitCodeExceptionMapper exitCodeExceptionMapper;
    private IExecutionStrategy executionStrategy = new RunLast();
    private IParameterExceptionHandler parameterExceptionHandler = new IParameterExceptionHandler(){

        public int handleParseException(ParameterException ex, String[] args) {
            CommandLine commandLine = ex.getCommandLine();
            DefaultExceptionHandler.internalHandleParseException(ex, commandLine.getErr(), commandLine.getColorScheme());
            return CommandLine.mappedExitCode(ex, commandLine.getExitCodeExceptionMapper(), commandLine.getCommandSpec().exitCodeOnInvalidInput());
        }
    };
    private IExecutionExceptionHandler executionExceptionHandler = new IExecutionExceptionHandler(){

        public int handleExecutionException(Exception ex, CommandLine commandLine, ParseResult parseResult) throws Exception {
            throw ex;
        }
    };

    public CommandLine(Object command) {
        this(command, new DefaultFactory());
    }

    public CommandLine(Object command, IFactory factory) {
        this.factory = Assert.notNull(factory, "factory");
        this.interpreter = new Interpreter();
        this.commandSpec = Model.CommandSpec.forAnnotatedObject(command, factory);
        this.commandSpec.commandLine(this);
        this.commandSpec.validate();
        if (this.commandSpec.unmatchedArgsBindings().size() > 0) {
            this.setUnmatchedArgumentsAllowed(true);
        }
    }

    private CommandLine copy() {
        CommandLine commandLine = new CommandLine(this.commandSpec.copy(), this.factory);
        new CommandLine(this.commandSpec.copy(), this.factory).err = this.err;
        commandLine.out = this.out;
        commandLine.colorScheme = this.colorScheme;
        commandLine.executionStrategy = this.executionStrategy;
        commandLine.exitCodeExceptionMapper = this.exitCodeExceptionMapper;
        commandLine.executionExceptionHandler = this.executionExceptionHandler;
        commandLine.parameterExceptionHandler = this.parameterExceptionHandler;
        commandLine.interpreter.converterRegistry.clear();
        commandLine.interpreter.converterRegistry.putAll(this.interpreter.converterRegistry);
        return commandLine;
    }

    public Model.CommandSpec getCommandSpec() {
        return this.commandSpec;
    }

    public CommandLine addMixin(String name, Object mixin) {
        this.getCommandSpec().addMixin(name, Model.CommandSpec.forAnnotatedObject(mixin, this.factory));
        return this;
    }

    public Map<String, Object> getMixins() {
        Map<String, Model.CommandSpec> map = this.getCommandSpec().mixins();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (String string : map.keySet()) {
            linkedHashMap.put(string, map.get(string).userObject.getInstance());
        }
        return linkedHashMap;
    }

    public CommandLine addSubcommand(Object command) {
        return this.addSubcommand(null, command, new String[0]);
    }

    public CommandLine addSubcommand(String name, Object command) {
        return this.addSubcommand(name, command, new String[0]);
    }

    public CommandLine addSubcommand(String name, Object command, String ... aliases) {
        CommandLine commandLine = CommandLine.toCommandLine(command, this.factory);
        commandLine.getCommandSpec().aliases.addAll(Arrays.asList(aliases));
        this.getCommandSpec().addSubcommand(name, commandLine);
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new LinkedHashMap<String, CommandLine>(this.getCommandSpec().subcommands());
    }

    public CommandLine getParent() {
        Model.CommandSpec commandSpec = this.getCommandSpec().parent();
        if (commandSpec == null) {
            return null;
        }
        return commandSpec.commandLine();
    }

    public <T> T getCommand() {
        return (T)this.getCommandSpec().userObject();
    }

    public boolean isUsageHelpRequested() {
        return this.interpreter.parseResultBuilder != null && this.interpreter.parseResultBuilder.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.interpreter.parseResultBuilder != null && this.interpreter.parseResultBuilder.versionHelpRequested;
    }

    public Help getHelp() {
        return this.getHelpFactory().create(this.getCommandSpec(), this.getColorScheme());
    }

    public IHelpFactory getHelpFactory() {
        return this.getCommandSpec().usageMessage().helpFactory();
    }

    public CommandLine setHelpFactory(IHelpFactory helpFactory) {
        this.getCommandSpec().usageMessage().helpFactory(helpFactory);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setHelpFactory(helpFactory);
        }
        return this;
    }

    public List<String> getHelpSectionKeys() {
        return this.getCommandSpec().usageMessage().sectionKeys();
    }

    public CommandLine setHelpSectionKeys(List<String> keys) {
        this.getCommandSpec().usageMessage().sectionKeys(keys);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setHelpSectionKeys(keys);
        }
        return this;
    }

    public Map<String, IHelpSectionRenderer> getHelpSectionMap() {
        return this.getCommandSpec().usageMessage().sectionMap();
    }

    public CommandLine setHelpSectionMap(Map<String, IHelpSectionRenderer> map) {
        this.getCommandSpec().usageMessage().sectionMap(map);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setHelpSectionMap(map);
        }
        return this;
    }

    public boolean isAdjustLineBreaksForWideCJKCharacters() {
        return this.getCommandSpec().usageMessage().adjustLineBreaksForWideCJKCharacters();
    }

    public CommandLine setAdjustLineBreaksForWideCJKCharacters(boolean adjustForWideChars) {
        this.getCommandSpec().usageMessage().adjustLineBreaksForWideCJKCharacters(adjustForWideChars);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAdjustLineBreaksForWideCJKCharacters(adjustForWideChars);
        }
        return this;
    }

    public boolean isToggleBooleanFlags() {
        return this.getCommandSpec().parser().toggleBooleanFlags();
    }

    public CommandLine setToggleBooleanFlags(boolean newValue) {
        this.getCommandSpec().parser().toggleBooleanFlags(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setToggleBooleanFlags(newValue);
        }
        return this;
    }

    public boolean isInterpolateVariables() {
        return this.getCommandSpec().interpolateVariables();
    }

    public CommandLine setInterpolateVariables(boolean interpolate) {
        this.getCommandSpec().interpolateVariables(interpolate);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setInterpolateVariables(interpolate);
        }
        return this;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.getCommandSpec().parser().overwrittenOptionsAllowed();
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean newValue) {
        this.getCommandSpec().parser().overwrittenOptionsAllowed(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setOverwrittenOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isPosixClusteredShortOptionsAllowed() {
        return this.getCommandSpec().parser().posixClusteredShortOptionsAllowed();
    }

    public CommandLine setPosixClusteredShortOptionsAllowed(boolean newValue) {
        this.getCommandSpec().parser().posixClusteredShortOptionsAllowed(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setPosixClusteredShortOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isCaseInsensitiveEnumValuesAllowed() {
        return this.getCommandSpec().parser().caseInsensitiveEnumValuesAllowed();
    }

    public CommandLine setCaseInsensitiveEnumValuesAllowed(boolean newValue) {
        this.getCommandSpec().parser().caseInsensitiveEnumValuesAllowed(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setCaseInsensitiveEnumValuesAllowed(newValue);
        }
        return this;
    }

    public boolean isTrimQuotes() {
        return this.getCommandSpec().parser().trimQuotes();
    }

    public CommandLine setTrimQuotes(boolean newValue) {
        this.getCommandSpec().parser().trimQuotes(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setTrimQuotes(newValue);
        }
        return this;
    }

    @Deprecated
    public boolean isSplitQuotedStrings() {
        return this.getCommandSpec().parser().splitQuotedStrings();
    }

    @Deprecated
    public CommandLine setSplitQuotedStrings(boolean newValue) {
        this.getCommandSpec().parser().splitQuotedStrings(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setSplitQuotedStrings(newValue);
        }
        return this;
    }

    public String getEndOfOptionsDelimiter() {
        return this.getCommandSpec().parser().endOfOptionsDelimiter();
    }

    public CommandLine setEndOfOptionsDelimiter(String delimiter) {
        this.getCommandSpec().parser().endOfOptionsDelimiter(delimiter);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setEndOfOptionsDelimiter(delimiter);
        }
        return this;
    }

    public boolean isSubcommandsCaseInsensitive() {
        return this.getCommandSpec().subcommandsCaseInsensitive();
    }

    public CommandLine setSubcommandsCaseInsensitive(boolean newValue) {
        this.getCommandSpec().subcommandsCaseInsensitive(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setSubcommandsCaseInsensitive(newValue);
        }
        return this;
    }

    public boolean isOptionsCaseInsensitive() {
        return this.getCommandSpec().optionsCaseInsensitive();
    }

    public CommandLine setOptionsCaseInsensitive(boolean newValue) {
        this.getCommandSpec().optionsCaseInsensitive(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setOptionsCaseInsensitive(newValue);
        }
        return this;
    }

    public boolean isAbbreviatedSubcommandsAllowed() {
        return this.getCommandSpec().parser().abbreviatedSubcommandsAllowed();
    }

    public CommandLine setAbbreviatedSubcommandsAllowed(boolean newValue) {
        this.getCommandSpec().parser().abbreviatedSubcommandsAllowed(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAbbreviatedSubcommandsAllowed(newValue);
        }
        return this;
    }

    public boolean isAbbreviatedOptionsAllowed() {
        return this.getCommandSpec().parser().abbreviatedOptionsAllowed();
    }

    public CommandLine setAbbreviatedOptionsAllowed(boolean newValue) {
        this.getCommandSpec().parser().abbreviatedOptionsAllowed(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAbbreviatedOptionsAllowed(newValue);
        }
        return this;
    }

    public IDefaultValueProvider getDefaultValueProvider() {
        return this.getCommandSpec().defaultValueProvider();
    }

    public CommandLine setDefaultValueProvider(IDefaultValueProvider newValue) {
        this.getCommandSpec().defaultValueProvider(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setDefaultValueProvider(newValue);
        }
        return this;
    }

    public boolean isStopAtPositional() {
        return this.getCommandSpec().parser().stopAtPositional();
    }

    public CommandLine setStopAtPositional(boolean newValue) {
        this.getCommandSpec().parser().stopAtPositional(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setStopAtPositional(newValue);
        }
        return this;
    }

    public boolean isStopAtUnmatched() {
        return this.getCommandSpec().parser().stopAtUnmatched();
    }

    public CommandLine setStopAtUnmatched(boolean newValue) {
        this.getCommandSpec().parser().stopAtUnmatched(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setStopAtUnmatched(newValue);
        }
        if (newValue) {
            this.setUnmatchedArgumentsAllowed(true);
        }
        return this;
    }

    public boolean isUnmatchedOptionsAllowedAsOptionParameters() {
        return this.getCommandSpec().parser().unmatchedOptionsAllowedAsOptionParameters();
    }

    public CommandLine setUnmatchedOptionsAllowedAsOptionParameters(boolean newValue) {
        this.getCommandSpec().parser().unmatchedOptionsAllowedAsOptionParameters(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUnmatchedOptionsAllowedAsOptionParameters(newValue);
        }
        return this;
    }

    public boolean isUnmatchedOptionsArePositionalParams() {
        return this.getCommandSpec().parser().unmatchedOptionsArePositionalParams();
    }

    public CommandLine setUnmatchedOptionsArePositionalParams(boolean newValue) {
        this.getCommandSpec().parser().unmatchedOptionsArePositionalParams(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUnmatchedOptionsArePositionalParams(newValue);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.getCommandSpec().parser().unmatchedArgumentsAllowed();
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean newValue) {
        this.getCommandSpec().parser().unmatchedArgumentsAllowed(newValue);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUnmatchedArgumentsAllowed(newValue);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        if (this.interpreter.parseResultBuilder == null) {
            return Collections.emptyList();
        }
        return UnmatchedArgumentException.stripErrorMessage(this.interpreter.parseResultBuilder.unmatched);
    }

    private static int mappedExitCode(Throwable t2, IExitCodeExceptionMapper mapper, int defaultExitCode) {
        try {
            if (mapper != null) {
                return mapper.getExitCode(t2);
            }
            return defaultExitCode;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return defaultExitCode;
        }
    }

    public Help.ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public CommandLine setColorScheme(Help.ColorScheme colorScheme) {
        this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setColorScheme(colorScheme);
        }
        return this;
    }

    public PrintWriter getOut() {
        if (this.out == null) {
            this.setOut(new PrintWriter(System.out, true));
        }
        return this.out;
    }

    public CommandLine setOut(PrintWriter out) {
        this.out = Assert.notNull(out, "out");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setOut(out);
        }
        return this;
    }

    public PrintWriter getErr() {
        if (this.err == null) {
            this.setErr(new PrintWriter(System.err, true));
        }
        return this.err;
    }

    public CommandLine setErr(PrintWriter err) {
        this.err = Assert.notNull(err, "err");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setErr(err);
        }
        return this;
    }

    public IExitCodeExceptionMapper getExitCodeExceptionMapper() {
        return this.exitCodeExceptionMapper;
    }

    public CommandLine setExitCodeExceptionMapper(IExitCodeExceptionMapper exitCodeExceptionMapper) {
        this.exitCodeExceptionMapper = Assert.notNull(exitCodeExceptionMapper, "exitCodeExceptionMapper");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setExitCodeExceptionMapper(exitCodeExceptionMapper);
        }
        return this;
    }

    public IExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public CommandLine setExecutionStrategy(IExecutionStrategy executionStrategy) {
        this.executionStrategy = Assert.notNull(executionStrategy, "executionStrategy");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setExecutionStrategy(executionStrategy);
        }
        return this;
    }

    public IParameterExceptionHandler getParameterExceptionHandler() {
        return this.parameterExceptionHandler;
    }

    public CommandLine setParameterExceptionHandler(IParameterExceptionHandler parameterExceptionHandler) {
        this.parameterExceptionHandler = Assert.notNull(parameterExceptionHandler, "parameterExceptionHandler");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setParameterExceptionHandler(parameterExceptionHandler);
        }
        return this;
    }

    public IExecutionExceptionHandler getExecutionExceptionHandler() {
        return this.executionExceptionHandler;
    }

    public CommandLine setExecutionExceptionHandler(IExecutionExceptionHandler executionExceptionHandler) {
        this.executionExceptionHandler = Assert.notNull(executionExceptionHandler, "executionExceptionHandler");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setExecutionExceptionHandler(executionExceptionHandler);
        }
        return this;
    }

    public static <T> T populateCommand(T command, String ... args) {
        CommandLine commandLine = CommandLine.toCommandLine(command, new DefaultFactory());
        commandLine.parse(args);
        return command;
    }

    public static <T> T populateSpec(Class<T> spec, String ... args) {
        CommandLine commandLine = CommandLine.toCommandLine(spec, new DefaultFactory());
        commandLine.parse(args);
        return commandLine.getCommand();
    }

    @Deprecated
    public List<CommandLine> parse(String ... args) {
        return this.interpreter.parse(args);
    }

    public ParseResult parseArgs(String ... args) {
        this.interpreter.parse(args);
        return this.getParseResult();
    }

    public ParseResult getParseResult() {
        if (this.interpreter.parseResultBuilder == null) {
            return null;
        }
        return this.interpreter.parseResultBuilder.build();
    }

    public <T> T getExecutionResult() {
        return (T)this.executionResult;
    }

    public void setExecutionResult(Object result) {
        this.executionResult = result;
    }

    public void clearExecutionResults() {
        this.executionResult = null;
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.clearExecutionResults();
        }
    }

    public static DefaultExceptionHandler<List<Object>> defaultExceptionHandler() {
        return new DefaultExceptionHandler<List<Object>>();
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
        PrintStream printStream = out;
        return CommandLine.printHelpIfRequested(parsedCommands, printStream, printStream, ansi);
    }

    public static boolean printHelpIfRequested(ParseResult parseResult) {
        return CommandLine.executeHelpRequest(parseResult) != null;
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, PrintStream err, Help.Ansi ansi) {
        return CommandLine.printHelpIfRequested(parsedCommands, out, err, Help.defaultColorScheme(ansi));
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, PrintStream err, Help.ColorScheme colorScheme) {
        for (CommandLine commandLine : parsedCommands) {
            commandLine.setOut(new PrintWriter(out, true)).setErr(new PrintWriter(err, true)).setColorScheme(colorScheme);
        }
        return CommandLine.executeHelpRequest(parsedCommands) != null;
    }

    public static Integer executeHelpRequest(ParseResult parseResult) {
        return CommandLine.executeHelpRequest(parseResult.asCommandLineList());
    }

    static Integer executeHelpRequest(List<CommandLine> parsedCommands) {
        for (CommandLine commandLine : parsedCommands) {
            Help.ColorScheme colorScheme = commandLine.getColorScheme();
            PrintWriter printWriter = commandLine.getOut();
            if (commandLine.isUsageHelpRequested()) {
                commandLine.usage(printWriter, colorScheme);
                return commandLine.getCommandSpec().exitCodeOnUsageHelp();
            }
            if (commandLine.isVersionHelpRequested()) {
                commandLine.printVersionHelp(printWriter, colorScheme.ansi, new Object[0]);
                return commandLine.getCommandSpec().exitCodeOnVersionHelp();
            }
            if (!commandLine.getCommandSpec().helpCommand()) continue;
            PrintWriter printWriter2 = commandLine.getErr();
            if (commandLine.getCommand() instanceof IHelpCommandInitializable2) {
                ((IHelpCommandInitializable2)commandLine.getCommand()).init(commandLine, colorScheme, printWriter, printWriter2);
            } else if (commandLine.getCommand() instanceof IHelpCommandInitializable) {
                ((IHelpCommandInitializable)commandLine.getCommand()).init(commandLine, colorScheme.ansi, System.out, System.err);
            }
            CommandLine.executeUserObject(commandLine, new ArrayList<Object>());
            return commandLine.getCommandSpec().exitCodeOnUsageHelp();
        }
        return null;
    }

    private static List<Object> executeUserObject(CommandLine parsed, List<Object> executionResultList) {
        Object t2 = parsed.getCommand();
        if (t2 instanceof Runnable) {
            try {
                ((Runnable)t2).run();
                parsed.setExecutionResult(null);
                executionResultList.add(null);
                return executionResultList;
            }
            catch (ParameterException parameterException) {
                ParameterException parameterException2 = parameterException;
                throw parameterException;
            }
            catch (ExecutionException executionException) {
                ExecutionException executionException2 = executionException;
                throw executionException;
            }
            catch (Exception exception) {
                throw new ExecutionException(parsed, "Error while running command (" + t2 + "): " + exception, exception);
            }
        }
        if (t2 instanceof Callable) {
            try {
                Callable callable = (Callable)t2;
                Object v2 = callable.call();
                parsed.setExecutionResult(v2);
                executionResultList.add(v2);
                return executionResultList;
            }
            catch (ParameterException parameterException) {
                ParameterException parameterException3 = parameterException;
                throw parameterException;
            }
            catch (ExecutionException executionException) {
                ExecutionException executionException3 = executionException;
                throw executionException;
            }
            catch (Exception exception) {
                throw new ExecutionException(parsed, "Error while calling command (" + t2 + "): " + exception, exception);
            }
        }
        if (t2 instanceof Method) {
            try {
                Method method = (Method)t2;
                Object[] objectArray = parsed.getCommandSpec().commandMethodParamValues();
                Object object = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, objectArray) : (parsed.getCommandSpec().parent() != null ? method.invoke(parsed.getCommandSpec().parent().userObject(), objectArray) : method.invoke(parsed.factory.create(method.getDeclaringClass()), objectArray));
                parsed.setExecutionResult(object);
                executionResultList.add(object);
                return executionResultList;
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ParameterException) {
                    throw (ParameterException)throwable;
                }
                if (throwable instanceof ExecutionException) {
                    throw (ExecutionException)throwable;
                }
                throw new ExecutionException(parsed, "Error while calling command (" + t2 + "): " + throwable, throwable);
            }
            catch (Exception exception) {
                throw new ExecutionException(parsed, "Unhandled error while calling command (" + t2 + "): " + exception, exception);
            }
        }
        if (parsed.getSubcommands().isEmpty()) {
            throw new ExecutionException(parsed, "Parsed command (" + t2 + ") is not a Method, Runnable or Callable");
        }
        throw new ParameterException(parsed, "Missing required subcommand");
    }

    public int execute(String ... args) {
        ParseResult[] parseResultArray = new ParseResult[1];
        this.clearExecutionResults();
        try {
            parseResultArray[0] = this.parseArgs(args);
            CommandLine commandLine = this;
            return commandLine.enrichForBackwardsCompatibility(commandLine.getExecutionStrategy()).execute(parseResultArray[0]);
        }
        catch (ParameterException parameterException) {
            try {
                return this.getParameterExceptionHandler().handleParseException(parameterException, args);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                return CommandLine.handleUnhandled(exception, parameterException.getCommandLine(), parameterException.getCommandLine().getCommandSpec().exitCodeOnInvalidInput());
            }
        }
        catch (ExecutionException executionException) {
            try {
                ExecutionException executionException2 = executionException.getCause() instanceof Exception ? (Exception)executionException.getCause() : executionException;
                return this.getExecutionExceptionHandler().handleExecutionException(executionException2, executionException.getCommandLine(), parseResultArray[0]);
            }
            catch (Exception exception) {
                Exception exception3 = exception;
                return CommandLine.handleUnhandled(exception, executionException.getCommandLine(), executionException.getCommandLine().getCommandSpec().exitCodeOnExecutionException());
            }
        }
        catch (Exception exception) {
            Exception exception4 = exception;
            CommandLine commandLine = this;
            return CommandLine.handleUnhandled(exception, commandLine, commandLine.getCommandSpec().exitCodeOnExecutionException());
        }
    }

    private static int handleUnhandled(Exception ex, CommandLine cmd, int defaultExitCode) {
        cmd.getErr().print(CommandLine.throwableToColorString(ex, cmd.getColorScheme()));
        cmd.getErr().flush();
        return CommandLine.mappedExitCode(ex, cmd.getExitCodeExceptionMapper(), defaultExitCode);
    }

    private static String throwableToColorString(Throwable t2, Help.ColorScheme existingColorScheme) {
        Help.ColorScheme colorScheme = new Help.ColorScheme.Builder(existingColorScheme).applySystemProperties().build();
        ColoredStackTraceWriter coloredStackTraceWriter = new ColoredStackTraceWriter(colorScheme);
        t2.printStackTrace(new PrintWriter(coloredStackTraceWriter));
        return coloredStackTraceWriter.toString();
    }

    private <T> T enrichForBackwardsCompatibility(T obj) {
        if (obj instanceof AbstractHandler) {
            AbstractHandler abstractHandler = (AbstractHandler)obj;
            if (abstractHandler.out() != System.out) {
                this.setOut(new PrintWriter(abstractHandler.out(), true));
            }
            if (abstractHandler.err() != System.err) {
                this.setErr(new PrintWriter(abstractHandler.err(), true));
            }
            if (abstractHandler.ansi() != Help.Ansi.AUTO) {
                this.setColorScheme(abstractHandler.colorScheme());
            }
        }
        return obj;
    }

    @Deprecated
    public List<Object> parseWithHandler(IParseResultHandler handler, PrintStream out, String ... args) {
        return this.parseWithHandlers(handler, out, Help.Ansi.AUTO, CommandLine.defaultExceptionHandler(), args);
    }

    @Deprecated
    public <R> R parseWithHandler(IParseResultHandler2<R> handler, String[] args) {
        return this.parseWithHandlers(handler, new DefaultExceptionHandler(), args);
    }

    @Deprecated
    public List<Object> parseWithHandlers(IParseResultHandler handler, PrintStream out, Help.Ansi ansi, IExceptionHandler exceptionHandler, String ... args) {
        this.clearExecutionResults();
        try {
            List<CommandLine> list = this.parse(args);
            return handler.handleParseResult(list, out, ansi);
        }
        catch (ParameterException parameterException) {
            return exceptionHandler.handleException(parameterException, out, ansi, args);
        }
    }

    @Deprecated
    public <R> R parseWithHandlers(IParseResultHandler2<R> handler, IExceptionHandler2<R> exceptionHandler, String ... args) {
        this.clearExecutionResults();
        ParseResult parseResult = null;
        try {
            parseResult = this.parseArgs(args);
            return handler.handleParseResult(parseResult);
        }
        catch (ParameterException parameterException) {
            return exceptionHandler.handleParseException(parameterException, args);
        }
        catch (ExecutionException executionException) {
            return exceptionHandler.handleExecutionException(executionException, parseResult);
        }
    }

    static String versionString() {
        return String.format("%s, JVM: %s (%s %s %s), OS: %s %s %s", VERSION, System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public static void usage(Object command, PrintStream out) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out);
    }

    public static void usage(Object command, PrintStream out, Help.Ansi ansi) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out, ansi);
    }

    public static void usage(Object command, PrintStream out, Help.ColorScheme colorScheme) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out, colorScheme);
    }

    public void usage(PrintStream out) {
        this.usage(out, this.getColorScheme());
    }

    public void usage(PrintWriter writer) {
        this.usage(writer, this.getColorScheme());
    }

    public void usage(PrintStream out, Help.Ansi ansi) {
        this.usage(out, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintWriter writer, Help.Ansi ansi) {
        this.usage(writer, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintStream out, Help.ColorScheme colorScheme) {
        out.print(this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)));
        out.flush();
    }

    public void usage(PrintWriter writer, Help.ColorScheme colorScheme) {
        writer.print(this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)));
        writer.flush();
    }

    public String getUsageMessage() {
        return this.usage(new StringBuilder(), this.getHelp()).toString();
    }

    public String getUsageMessage(Help.Ansi ansi) {
        return this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), Help.defaultColorScheme(ansi))).toString();
    }

    public String getUsageMessage(Help.ColorScheme colorScheme) {
        return this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)).toString();
    }

    private StringBuilder usage(StringBuilder sb, Help help) {
        for (String string : this.getHelpSectionKeys()) {
            IHelpSectionRenderer iHelpSectionRenderer = this.getHelpSectionMap().get(string);
            if (iHelpSectionRenderer == null) continue;
            sb.append(iHelpSectionRenderer.render(help));
        }
        return sb;
    }

    public void printVersionHelp(PrintStream out) {
        this.printVersionHelp(out, this.getColorScheme().ansi());
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi) {
        for (String string : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(string, this.getColorScheme()));
        }
        out.flush();
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi, Object ... params) {
        for (String string : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(CommandLine.format(string, params), this.getColorScheme()));
        }
        out.flush();
    }

    public void printVersionHelp(PrintWriter out) {
        this.printVersionHelp(out, this.getColorScheme().ansi(), new Object[0]);
    }

    public void printVersionHelp(PrintWriter out, Help.Ansi ansi, Object ... params) {
        for (String string : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(CommandLine.format(string, params), this.getColorScheme()));
        }
        out.flush();
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C callable, String ... args) {
        CommandLine commandLine = new CommandLine(callable);
        List<Object> list = commandLine.parseWithHandler(new RunLast(), args);
        return CommandLine.firstElement(list);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, String ... args) {
        return CommandLine.call(callable, out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, Help.Ansi ansi, String ... args) {
        return CommandLine.call(callable, out, System.err, ansi, args);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine commandLine = new CommandLine(callable);
        List list = (List)commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
        return CommandLine.firstElement(list);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, String ... args) {
        CommandLine commandLine = new CommandLine(callableClass, factory);
        List<Object> list = commandLine.parseWithHandler(new RunLast(), args);
        return CommandLine.firstElement(list);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, PrintStream out, String ... args) {
        return CommandLine.call(callableClass, factory, out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, PrintStream out, Help.Ansi ansi, String ... args) {
        return CommandLine.call(callableClass, factory, out, System.err, ansi, args);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine commandLine = new CommandLine(callableClass, factory);
        List list = (List)commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
        return CommandLine.firstElement(list);
    }

    private static <T> T firstElement(List<Object> results) {
        if (results == null || results.isEmpty()) {
            return null;
        }
        return (T)results.get(0);
    }

    @Deprecated
    public static <R extends Runnable> void run(R runnable, String ... args) {
        CommandLine.run(runnable, System.out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static <R extends Runnable> void run(R runnable, PrintStream out, String ... args) {
        CommandLine.run(runnable, out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static <R extends Runnable> void run(R runnable, PrintStream out, Help.Ansi ansi, String ... args) {
        CommandLine.run(runnable, out, System.err, ansi, args);
    }

    @Deprecated
    public static <R extends Runnable> void run(R runnable, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine commandLine = new CommandLine(runnable);
        commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, String ... args) {
        CommandLine.run(runnableClass, factory, System.out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, PrintStream out, String ... args) {
        CommandLine.run(runnableClass, factory, out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, PrintStream out, Help.Ansi ansi, String ... args) {
        CommandLine.run(runnableClass, factory, out, System.err, ansi, args);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine commandLine = new CommandLine(runnableClass, factory);
        commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
    }

    @Deprecated
    public static Object invoke(String methodName, Class<?> cls, String ... args) {
        return CommandLine.invoke(methodName, cls, System.out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static Object invoke(String methodName, Class<?> cls, PrintStream out, String ... args) {
        return CommandLine.invoke(methodName, cls, out, System.err, Help.Ansi.AUTO, args);
    }

    @Deprecated
    public static Object invoke(String methodName, Class<?> cls, PrintStream out, Help.Ansi ansi, String ... args) {
        return CommandLine.invoke(methodName, cls, out, System.err, ansi, args);
    }

    @Deprecated
    public static Object invoke(String methodName, Class<?> cls, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        List<Method> list = CommandLine.getCommandMethods(cls, methodName);
        if (list.size() != 1) {
            throw new InitializationException("Expected exactly one @Command-annotated method for " + cls.getName() + "::" + methodName + "(...), but got: " + list);
        }
        Method method = list.get(0);
        CommandLine commandLine = new CommandLine(method);
        List list2 = (List)commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
        if (list2 == null) {
            return null;
        }
        return list2.get(0);
    }

    public static List<Method> getCommandMethods(Class<?> cls, String methodName) {
        return CommandLine.getCommandMethods(cls, methodName, true);
    }

    private static List<Method> getCommandMethods(Class<?> cls, String methodName, boolean includeInherited) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (includeInherited) {
            hashSet.addAll(Arrays.asList(Assert.notNull(cls, "class").getMethods()));
        }
        hashSet.addAll(Arrays.asList(Assert.notNull(cls, "class").getDeclaredMethods()));
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : hashSet) {
            if (!method.isAnnotationPresent(Command.class) || methodName != null && !methodName.equals(method.getName())) continue;
            arrayList.add(method);
        }
        Collections.sort(arrayList, new Comparator<Method>(){

            @Override
            public final int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return arrayList;
    }

    public <K> CommandLine registerConverter(Class<K> cls, ITypeConverter<K> converter) {
        this.interpreter.converterRegistry.put(Assert.notNull(cls, "class"), Assert.notNull(converter, "converter"));
        for (CommandLine commandLine : this.getCommandSpec().commands.values()) {
            commandLine.registerConverter(cls, converter);
        }
        return this;
    }

    public String getSeparator() {
        return this.getCommandSpec().parser().separator();
    }

    public CommandLine setSeparator(String separator) {
        this.getCommandSpec().parser().separator(Assert.notNull(separator, "separator"));
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setSeparator(separator);
        }
        return this;
    }

    public ResourceBundle getResourceBundle() {
        return this.getCommandSpec().resourceBundle();
    }

    public CommandLine setResourceBundle(ResourceBundle bundle) {
        this.getCommandSpec().resourceBundle(bundle);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setResourceBundle(bundle);
        }
        return this;
    }

    public int getUsageHelpWidth() {
        return this.getCommandSpec().usageMessage().width();
    }

    public CommandLine setUsageHelpWidth(int width) {
        this.getCommandSpec().usageMessage().width(width);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUsageHelpWidth(width);
        }
        return this;
    }

    public int getUsageHelpLongOptionsMaxWidth() {
        return this.getCommandSpec().usageMessage().longOptionsMaxWidth();
    }

    public CommandLine setUsageHelpLongOptionsMaxWidth(int columnWidth) {
        this.getCommandSpec().usageMessage().longOptionsMaxWidth(columnWidth);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUsageHelpLongOptionsMaxWidth(columnWidth);
        }
        return this;
    }

    public boolean isUsageHelpAutoWidth() {
        return this.getCommandSpec().usageMessage().autoWidth();
    }

    public CommandLine setUsageHelpAutoWidth(boolean detectTerminalSize) {
        this.getCommandSpec().usageMessage().autoWidth(detectTerminalSize);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUsageHelpAutoWidth(detectTerminalSize);
        }
        return this;
    }

    public String getCommandName() {
        return this.getCommandSpec().name();
    }

    public CommandLine setCommandName(String commandName) {
        this.getCommandSpec().name(Assert.notNull(commandName, "commandName"));
        return this;
    }

    public boolean isExpandAtFiles() {
        return this.getCommandSpec().parser().expandAtFiles();
    }

    public CommandLine setExpandAtFiles(boolean expandAtFiles) {
        this.getCommandSpec().parser().expandAtFiles(expandAtFiles);
        return this;
    }

    public Character getAtFileCommentChar() {
        return this.getCommandSpec().parser().atFileCommentChar();
    }

    public CommandLine setAtFileCommentChar(Character atFileCommentChar) {
        this.getCommandSpec().parser().atFileCommentChar(atFileCommentChar);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAtFileCommentChar(atFileCommentChar);
        }
        return this;
    }

    public boolean isUseSimplifiedAtFiles() {
        return this.getCommandSpec().parser().useSimplifiedAtFiles();
    }

    public CommandLine setUseSimplifiedAtFiles(boolean simplifiedAtFiles) {
        this.getCommandSpec().parser().useSimplifiedAtFiles(simplifiedAtFiles);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUseSimplifiedAtFiles(simplifiedAtFiles);
        }
        return this;
    }

    public INegatableOptionTransformer getNegatableOptionTransformer() {
        return this.getCommandSpec().negatableOptionTransformer();
    }

    public CommandLine setNegatableOptionTransformer(INegatableOptionTransformer transformer) {
        this.getCommandSpec().negatableOptionTransformer(transformer);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setNegatableOptionTransformer(transformer);
        }
        return this;
    }

    private static boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static String str(String[] arr, int i2) {
        if (arr == null || arr.length <= i2) {
            return "";
        }
        return arr[i2];
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object obj, IFactory factory) {
        if (obj instanceof CommandLine) {
            return (CommandLine)obj;
        }
        return new CommandLine(obj, factory);
    }

    private static boolean isMultiValue(Class<?> cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls) || Map.class.isAssignableFrom(cls);
    }

    private static String format(String formatString, Object ... params) {
        try {
            if (formatString == null) {
                return "";
            }
            return String.format(formatString, params);
        }
        catch (IllegalFormatException illegalFormatException) {
            new Tracer().warn("Could not format '%s' (Underlying error: %s). Using raw String: '%%n' format strings have not been replaced with newlines. Please ensure to escape '%%' characters with another '%%'.%n", formatString, illegalFormatException.getMessage());
            return formatString;
        }
    }

    public static IFactory defaultFactory() {
        return new DefaultFactory();
    }

    private static void validatePositionalParameters(List<Model.PositionalParamSpec> positionals) {
        int n2 = 0;
        for (Model.PositionalParamSpec positionalParamSpec : positionals) {
            Range range = positionalParamSpec.index();
            if (range.min > n2 && !range.isRelative()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Model.PositionalParamSpec positionalParamSpec2 : positionals) {
                    arrayList.add(positionalParamSpec2.index().internalToString());
                }
                throw new ParameterIndexGapException("Command definition should have a positional parameter with index=" + n2 + ". Nearest positional parameter '" + positionalParamSpec.paramLabel() + "' has index=" + range + ". (Full list: " + arrayList + ")");
            }
            n2 = (n2 = Math.max(n2, range.max)) == Integer.MAX_VALUE ? n2 : n2 + 1;
        }
    }

    private static Stack<String> copy(Stack<String> stack) {
        return (Stack)stack.clone();
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Collections.reverse(stack);
        return stack;
    }

    private static <T> List<T> reverseList(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    private static <T> T[] reverseArray(T[] all) {
        for (int i2 = 0; i2 < all.length / 2; ++i2) {
            T t2 = all[i2];
            all[i2] = all[all.length - i2 - 1];
            all[all.length - i2 - 1] = t2;
        }
        return all;
    }

    static <K, T> void addValueToListInMap(Map<K, List<T>> map, K key, T value) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        list.add(value);
    }

    static <T> List<T> flatList(Collection<? extends Collection<T>> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Collection<T> collection2 : collection) {
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    private static String optionDescription(String prefix, Model.ArgSpec argSpec, int optionParamIndex) {
        String string;
        if (argSpec.isOption()) {
            string = prefix + "option '" + ((Model.OptionSpec)argSpec).longestName() + "'";
            if (optionParamIndex >= 0) {
                if (argSpec.arity().max > 1) {
                    string = string + " at index " + optionParamIndex;
                }
                string = string + " (" + argSpec.paramLabel() + ")";
            }
        } else {
            string = prefix + "positional parameter at index " + ((Model.PositionalParamSpec)argSpec).index() + " (" + argSpec.paramLabel() + ")";
        }
        return string;
    }

    private static String createMissingParameterMessage(Model.ArgSpec argSpec, Range arity, List<Model.PositionalParamSpec> missingList, Stack<String> args, int available) {
        if (arity.min == 1) {
            if (argSpec.isOption()) {
                return "Missing required parameter for " + CommandLine.optionDescription("", argSpec, 0);
            }
            String string = "";
            String string2 = ": ";
            String string3 = "";
            String string4 = " at index ";
            int n2 = 0;
            for (Model.PositionalParamSpec positionalParamSpec : missingList) {
                if (positionalParamSpec.arity().min <= 0) continue;
                string2 = string2 + string + "'" + positionalParamSpec.paramLabel() + "'";
                string3 = string3 + string + positionalParamSpec.index();
                string = ", ";
                ++n2;
            }
            Object object = "Missing required parameter";
            if (n2 > 1 || arity.min - available > 1) {
                object = (String)object + "s";
            }
            if (n2 > 1) {
                string4 = " at indices ";
            }
            if (System.getProperty("picocli.verbose.errors") != null) {
                return (String)object + string2 + string4 + string3;
            }
            return (String)object + string2;
        }
        if (args.isEmpty()) {
            return CommandLine.optionDescription("", argSpec, 0) + " requires at least " + arity.min + " values, but none were specified.";
        }
        return CommandLine.optionDescription("", argSpec, 0) + " requires at least " + arity.min + " values, but only " + available + " were specified: " + CommandLine.reverse(args);
    }

    String smartUnquoteIfEnabled(String value) {
        if (value == null || !this.commandSpec.parser().trimQuotes()) {
            return value;
        }
        return CommandLine.smartUnquote(value);
    }

    static String smartUnquote(String value) {
        int n2;
        String string = CommandLine.unquote(value);
        if (string == value) {
            return value;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i2 = 0; i2 < string.length(); i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            switch (n2) {
                case 92: {
                    ++n3;
                    break;
                }
                case 34: {
                    if (n3 == 0) {
                        return value;
                    }
                    n3 = 0;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if ((n3 & 1) != 0) continue;
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    private static String unquote(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (Exception exception) {
            new Tracer().warn("Could not close " + closeable + ": " + exception.toString(), new Object[0]);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AbbreviationMatcher {
        AbbreviationMatcher() {
        }

        public static List<String> splitIntoChunks(String command, boolean caseInsensitive) {
            String string;
            int n2;
            int n3;
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            for (n2 = 0; n2 < command.length() && !Character.isLetterOrDigit(n3 = command.codePointAt(n2)); n2 += Character.charCount(n3)) {
                stringBuilder.appendCodePoint(n3);
            }
            if (stringBuilder.length() > 0) {
                arrayList.add(stringBuilder.toString());
            }
            for (int i2 = n2; i2 < command.length(); i2 += Character.charCount(n3)) {
                n3 = command.codePointAt(i2);
                if ((caseInsensitive || !Character.isUpperCase(n3)) && 45 != n3) continue;
                String string2 = AbbreviationMatcher.makeCanonical(command.substring(n2, i2));
                if (string2.length() > 0) {
                    arrayList.add(string2);
                }
                n2 = i2;
            }
            if (n2 < command.length() && (string = AbbreviationMatcher.makeCanonical(command.substring(n2))).length() > 0) {
                arrayList.add(string);
            }
            return arrayList;
        }

        private static String makeCanonical(String str) {
            if ("-".equals(str)) {
                return "";
            }
            if (str.startsWith("-") && str.length() > 1) {
                String string = String.valueOf(Character.toChars(Character.toUpperCase(str.codePointAt(1))));
                return string + str.substring(1 + string.length());
            }
            return str;
        }

        public static String match(Set<String> set, String abbreviation, boolean caseInsensitive) {
            if (set.contains(abbreviation)) {
                return abbreviation;
            }
            List<String> list = AbbreviationMatcher.splitIntoChunks(abbreviation, caseInsensitive);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : set) {
                List<String> list2 = AbbreviationMatcher.splitIntoChunks(string, caseInsensitive);
                if (!AbbreviationMatcher.matchKeyChunks(list, list2, caseInsensitive)) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 1) {
                String string = ((Object)arrayList).toString();
                throw new IllegalArgumentException("'" + abbreviation + "' is not unique: it matches '" + string.substring(1, string.length() - 1).replace(", ", "', '") + "'");
            }
            if (arrayList.isEmpty()) {
                return abbreviation;
            }
            return (String)arrayList.get(0);
        }

        private static boolean matchKeyChunks(List<String> abbreviatedKeyChunks, List<String> keyChunks, boolean caseInsensitive) {
            if (abbreviatedKeyChunks.size() > keyChunks.size()) {
                return false;
            }
            int n2 = 0;
            if (AbbreviationMatcher.isNonAlphabetic(keyChunks.get(0))) {
                if (!keyChunks.get(0).equals(abbreviatedKeyChunks.get(0))) {
                    return false;
                }
                ++n2;
            }
            if (!AbbreviationMatcher.startsWith(keyChunks.get(n2), abbreviatedKeyChunks.get(n2), caseInsensitive)) {
                return false;
            }
            int n3 = ++n2;
            int n4 = n2;
            while (n3 < abbreviatedKeyChunks.size()) {
                boolean bl = false;
                for (int i2 = n4; i2 < keyChunks.size(); ++i2) {
                    bl = AbbreviationMatcher.startsWith(keyChunks.get(i2), abbreviatedKeyChunks.get(n3), caseInsensitive);
                    if (!bl) continue;
                    n4 = i2 + 1;
                    break;
                }
                if (!bl) break;
                ++n3;
                ++n2;
            }
            return n2 == abbreviatedKeyChunks.size();
        }

        private static boolean startsWith(String str, String prefix, boolean caseInsensitive) {
            if (prefix.length() > str.length()) {
                return false;
            }
            String string = str.substring(0, prefix.length());
            if (caseInsensitive) {
                return string.equalsIgnoreCase(prefix);
            }
            return string.equals(prefix);
        }

        private static boolean isNonAlphabetic(String str) {
            int n2;
            for (int i2 = 0; i2 < str.length(); i2 += Character.charCount(n2)) {
                n2 = str.codePointAt(i2);
                if (!Character.isLetterOrDigit(n2)) continue;
                return false;
            }
            return true;
        }
    }

    public static class PropertiesDefaultProvider
    implements IDefaultValueProvider {
        private Properties properties;
        private File location;

        public PropertiesDefaultProvider() {
        }

        public PropertiesDefaultProvider(Properties properties) {
            this.properties = properties;
        }

        public PropertiesDefaultProvider(File file) {
            this(PropertiesDefaultProvider.createProperties(file, null));
            this.properties.remove("__picocli_internal_location");
            this.location = file;
        }

        private static Properties createProperties(File file, Model.CommandSpec commandSpec) {
            if (file == null) {
                throw new NullPointerException("file is null");
            }
            Tracer tracer = new Tracer();
            Properties properties = new Properties();
            if (file.exists() && file.canRead()) {
                FileInputStream fileInputStream = null;
                try {
                    String string = commandSpec == null ? "unknown command" : commandSpec.qualifiedName();
                    tracer.debug("Reading defaults from %s for %s%n", file.getAbsolutePath(), string);
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    properties.put("__picocli_internal_location", file);
                    CommandLine.close(fileInputStream);
                }
                catch (IOException iOException) {
                    tracer.warn("could not read defaults from %s: %s%n", file.getAbsolutePath(), iOException);
                }
                finally {
                    CommandLine.close(fileInputStream);
                }
            } else {
                tracer.warn("defaults configuration file %s does not exist or is not readable%n", file.getAbsolutePath());
            }
            return properties;
        }

        private static Properties loadProperties(Model.CommandSpec commandSpec) {
            while (commandSpec != null) {
                Properties properties = System.getProperties();
                for (String string : commandSpec.names()) {
                    String string2 = properties.getProperty("picocli.defaults." + string + ".path");
                    File file = new File(properties.getProperty("user.home"), "." + string + ".properties");
                    File file2 = string2 == null ? file : new File(string2);
                    if (!file2.canRead()) continue;
                    return PropertiesDefaultProvider.createProperties(file2, commandSpec);
                }
                commandSpec = commandSpec.parent();
            }
            return null;
        }

        public String defaultValue(Model.ArgSpec argSpec) throws Exception {
            if (this.properties == null) {
                this.properties = PropertiesDefaultProvider.loadProperties(argSpec.command());
                File file = this.location = this.properties == null ? null : (File)this.properties.remove("__picocli_internal_location");
            }
            if (this.properties == null || this.properties.isEmpty()) {
                return null;
            }
            if (argSpec.isOption()) {
                return this.optionDefaultValue((Model.OptionSpec)argSpec);
            }
            return this.positionalDefaultValue((Model.PositionalParamSpec)argSpec);
        }

        private String optionDefaultValue(Model.OptionSpec option) {
            String string = this.getValue(option.descriptionKey(), option.command());
            string = string != null ? string : this.getValue(PropertiesDefaultProvider.stripPrefix(option.longestName()), option.command());
            return string;
        }

        private static String stripPrefix(String prefixed) {
            for (int i2 = 0; i2 < prefixed.length(); ++i2) {
                if (!Character.isJavaIdentifierPart(prefixed.charAt(i2))) continue;
                return prefixed.substring(i2);
            }
            return prefixed;
        }

        private String positionalDefaultValue(Model.PositionalParamSpec positional) {
            String string = this.getValue(positional.descriptionKey(), positional.command());
            string = string != null ? string : this.getValue(positional.paramLabel(), positional.command());
            return string;
        }

        private String getValue(String key, Model.CommandSpec spec) {
            String string = null;
            if (spec != null) {
                String string2 = spec.qualifiedName(".");
                string = this.properties.getProperty(string2 + "." + key);
            }
            if (string != null) {
                return string;
            }
            if (key == null) {
                return null;
            }
            return this.properties.getProperty(key);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.location + "]";
        }
    }

    public static class MissingTypeConverterException
    extends ParameterException {
        private static final long serialVersionUID = -6050931703233083760L;

        public MissingTypeConverterException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    public static class OverwrittenOptionException
    extends ParameterException {
        private static final long serialVersionUID = 1338029208271055776L;
        private final Model.ArgSpec overwrittenArg;

        public OverwrittenOptionException(CommandLine commandLine, Model.ArgSpec overwritten, String msg) {
            super(commandLine, msg);
            this.overwrittenArg = overwritten;
        }

        public Model.ArgSpec getOverwritten() {
            return this.overwrittenArg;
        }
    }

    public static class MaxValuesExceededException
    extends ParameterException {
        private static final long serialVersionUID = 6536145439570100641L;

        public MaxValuesExceededException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmatchedArgumentException
    extends ParameterException {
        private static final long serialVersionUID = -8700426380701452440L;
        private List<String> unmatched = Collections.emptyList();

        public UnmatchedArgumentException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }

        public UnmatchedArgumentException(CommandLine commandLine, Stack<String> args) {
            this(commandLine, new ArrayList<String>(CommandLine.reverse(args)));
        }

        public UnmatchedArgumentException(CommandLine commandLine, List<String> args) {
            this(commandLine, args, "");
        }

        public UnmatchedArgumentException(CommandLine commandLine, List<String> args, String extraMsg) {
            this(commandLine, UnmatchedArgumentException.describe(Assert.notNull(args, "unmatched list"), commandLine) + ": " + UnmatchedArgumentException.quoteElements(args) + extraMsg);
            this.unmatched = new ArrayList<String>(args);
        }

        public static boolean printSuggestions(ParameterException ex, PrintStream out) {
            return ex instanceof UnmatchedArgumentException && ((UnmatchedArgumentException)ex).printSuggestions(out);
        }

        public static boolean printSuggestions(ParameterException ex, PrintWriter writer) {
            return ex instanceof UnmatchedArgumentException && ((UnmatchedArgumentException)ex).printSuggestions(writer);
        }

        public List<String> getUnmatched() {
            return UnmatchedArgumentException.stripErrorMessage(this.unmatched);
        }

        static List<String> stripErrorMessage(List<String> unmatched) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : unmatched) {
                if (string == null) {
                    arrayList.add(null);
                    continue;
                }
                int n2 = string.indexOf(" (while processing option:");
                arrayList.add(n2 < 0 ? string : string.substring(0, n2));
            }
            return Collections.unmodifiableList(arrayList);
        }

        public boolean isUnknownOption() {
            return UnmatchedArgumentException.isUnknownOption(this.unmatched, this.getCommandLine());
        }

        public boolean printSuggestions(PrintStream out) {
            return this.printSuggestions(new PrintWriter(out, true));
        }

        public boolean printSuggestions(PrintWriter writer) {
            List<String> list = this.getSuggestions();
            if (!list.isEmpty()) {
                writer.println(this.isUnknownOption() ? "Possible solutions: " + UnmatchedArgumentException.str(list) : "Did you mean: " + UnmatchedArgumentException.str(list).replace(", ", " or ") + "?");
                writer.flush();
            }
            return !list.isEmpty();
        }

        private static String str(List<String> list) {
            String string = list.toString();
            return string.substring(0, string.length() - 1).substring(1);
        }

        public List<String> getSuggestions() {
            if (this.unmatched.isEmpty()) {
                return Collections.emptyList();
            }
            String string = this.unmatched.get(0);
            String string2 = Model.CommandSpec.stripPrefix(string);
            Model.CommandSpec commandSpec = this.getCommandLine().getCommandSpec();
            if (commandSpec.resemblesOption(string, null)) {
                return commandSpec.findVisibleOptionNamesWithPrefix(string2.substring(0, Math.min(2, string2.length())));
            }
            if (!commandSpec.subcommands().isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Map.Entry<String, CommandLine> entry : commandSpec.subcommands().entrySet()) {
                    if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
                    arrayList.add(entry.getKey());
                }
                List<String> list = CosineSimilarity.mostSimilar(string, arrayList);
                return list.subList(0, Math.min(3, list.size()));
            }
            return Collections.emptyList();
        }

        private static boolean isUnknownOption(List<String> unmatch, CommandLine cmd) {
            return unmatch != null && !unmatch.isEmpty() && cmd.getCommandSpec().resemblesOption(unmatch.get(0), null);
        }

        private static String describe(List<String> unmatch, CommandLine cmd) {
            String string;
            String string2 = unmatch.size() == 1 ? "" : "s";
            String string3 = string = unmatch.size() == 1 ? " at" : " from";
            if (UnmatchedArgumentException.isUnknownOption(unmatch, cmd)) {
                return "Unknown option" + string2;
            }
            return "Unmatched argument" + string2 + string + " index " + (cmd.interpreter.parseResultBuilder == null ? "0" : Integer.valueOf(cmd.interpreter.parseResultBuilder.originalArgList.indexOf(unmatch.get(0))));
        }

        static String quoteElements(List<String> list) {
            String string = "";
            String string2 = "";
            for (String string3 : list) {
                int n2;
                if (string.length() > 0) {
                    string = string + ", ";
                }
                if (string3 != null && (n2 = string3.indexOf(" (while processing option:")) >= 0) {
                    string2 = string3.substring(n2);
                    string3 = string3.substring(0, n2);
                }
                string = string + "'" + string3 + "'" + string2;
                string2 = "";
            }
            return string;
        }
    }

    public static class ParameterIndexGapException
    extends InitializationException {
        private static final long serialVersionUID = -1520981133257618319L;

        public ParameterIndexGapException(String msg) {
            super(msg);
        }
    }

    public static class DuplicateOptionAnnotationsException
    extends DuplicateNameException {
        private static final long serialVersionUID = -3355128012575075641L;

        public DuplicateOptionAnnotationsException(String msg) {
            super(msg);
        }

        private static DuplicateOptionAnnotationsException create(String name, Model.ArgSpec argSpec1, Model.ArgSpec argSpec2) {
            return new DuplicateOptionAnnotationsException("Option name '" + name + "' is used by both " + argSpec1.toString() + " and " + argSpec2.toString());
        }
    }

    public static class DuplicateNameException
    extends InitializationException {
        private static final long serialVersionUID = -4126747467955626054L;

        public DuplicateNameException(String msg) {
            super(msg);
        }
    }

    public static class MutuallyExclusiveArgsException
    extends ParameterException {
        private static final long serialVersionUID = -5557715106221420986L;

        public MutuallyExclusiveArgsException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MissingParameterException
    extends ParameterException {
        private static final long serialVersionUID = 5075678535706338753L;
        private final List<Model.ArgSpec> missing;

        public MissingParameterException(CommandLine commandLine, Model.ArgSpec missing, String msg) {
            this(commandLine, Collections.singletonList(missing), msg);
        }

        public MissingParameterException(CommandLine commandLine, Collection<Model.ArgSpec> missing, String msg) {
            super(commandLine, msg);
            this.missing = Collections.unmodifiableList(new ArrayList<Model.ArgSpec>(missing));
        }

        public List<Model.ArgSpec> getMissing() {
            return this.missing;
        }

        private static MissingParameterException create(CommandLine cmd, Collection<Model.ArgSpec> missing, String separator) {
            String string = Model.ArgSpec.describe(missing, ", ", separator, "'", "'");
            String string2 = Model.ArgSpec.describeTypes(missing);
            return new MissingParameterException(cmd, missing, "Missing required " + string2 + ": " + string);
        }
    }

    public static class ParameterException
    extends PicocliException {
        private static final long serialVersionUID = 1477112829129763139L;
        private final CommandLine commandLine;
        private Model.ArgSpec argSpec = null;
        private String value = null;

        public ParameterException(CommandLine commandLine, String msg) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String msg, Throwable t2) {
            super(msg, t2);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String msg, Throwable t2, Model.ArgSpec argSpec, String value) {
            super(msg, t2);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
            if (argSpec == null && value == null) {
                throw new IllegalArgumentException("ArgSpec and value cannot both be null");
            }
            this.argSpec = argSpec;
            this.value = value;
        }

        public ParameterException(CommandLine commandLine, String msg, Model.ArgSpec argSpec, String value) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
            if (argSpec == null && value == null) {
                throw new IllegalArgumentException("ArgSpec and value cannot both be null");
            }
            this.argSpec = argSpec;
            this.value = value;
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }

        public Model.ArgSpec getArgSpec() {
            return this.argSpec;
        }

        public String getValue() {
            return this.value;
        }

        private static ParameterException create(CommandLine cmd, Exception ex, String arg, int i2, String[] args) {
            String string = ex.getClass().getSimpleName() + ": " + ex.getLocalizedMessage() + " while processing argument at or before arg[" + i2 + "] '" + arg + "' in " + Arrays.toString(args) + ": " + ex.toString();
            return new ParameterException(cmd, string, ex, null, arg);
        }
    }

    public static class TypeConversionException
    extends PicocliException {
        private static final long serialVersionUID = 4251973913816346114L;

        public TypeConversionException(String msg) {
            super(msg);
        }
    }

    public static class ExecutionException
    extends PicocliException {
        private static final long serialVersionUID = 7764539594267007998L;
        private final CommandLine commandLine;

        public ExecutionException(CommandLine commandLine, String msg) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ExecutionException(CommandLine commandLine, String msg, Throwable t2) {
            super(msg, t2);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }

    public static class InitializationException
    extends PicocliException {
        private static final long serialVersionUID = 8423014001666638895L;

        public InitializationException(String msg) {
            super(msg);
        }

        public InitializationException(String msg, Exception ex) {
            super(msg, ex);
        }
    }

    public static class PicocliException
    extends RuntimeException {
        private static final long serialVersionUID = -2574128880125050818L;

        public PicocliException(String msg) {
            super(msg);
        }

        public PicocliException(String msg, Throwable t2) {
            super(msg, t2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CosineSimilarity {
        private CosineSimilarity() {
        }

        static List<String> mostSimilar(String pattern, Iterable<String> candidates) {
            return CosineSimilarity.mostSimilar(pattern, candidates, 0.0);
        }

        static List<String> mostSimilar(String pattern, Iterable<String> candidates, double threshold) {
            pattern = pattern.toLowerCase();
            TreeMap<Double, String> treeMap = new TreeMap<Double, String>();
            for (String string : candidates) {
                double d2;
                double d3 = CosineSimilarity.similarity(pattern, string.toLowerCase(), 2);
                if (!(d2 > threshold)) continue;
                treeMap.put(d3, string);
            }
            return CommandLine.reverseList(new ArrayList(treeMap.values()));
        }

        private static double similarity(String sequence1, String sequence2, int degree) {
            Map<String, Integer> map = CosineSimilarity.countNgramFrequency(sequence1, degree);
            Map<String, Integer> map2 = CosineSimilarity.countNgramFrequency(sequence2, degree);
            Map<String, Integer> map3 = map;
            Map<String, Integer> map4 = map2;
            return CosineSimilarity.dotProduct(map, map2) / Math.sqrt(CosineSimilarity.dotProduct(map3, map3) * CosineSimilarity.dotProduct(map4, map4));
        }

        private static Map<String, Integer> countNgramFrequency(String sequence, int degree) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n2 = 0;
            while (n2 + degree <= sequence.length()) {
                String string;
                int n3 = n2;
                hashMap.put(string, 1 + (hashMap.containsKey(string = sequence.substring(n3, n3 + degree)) ? (Integer)hashMap.get(string) : 0));
                ++n2;
            }
            return hashMap;
        }

        private static double dotProduct(Map<String, Integer> m1, Map<String, Integer> m2) {
            double d2 = 0.0;
            for (String string : m1.keySet()) {
                d2 += (double)(m1.get(string) * (m2.containsKey(string) ? m2.get(string) : 0));
            }
            return d2;
        }
    }

    static class Tracer {
        TraceLevel level = TraceLevel.lookup(System.getProperty("picocli.trace"));
        PrintStream stream = System.err;

        Tracer() {
        }

        void warn(String msg, Object ... params) {
            TraceLevel.WARN.print(this, msg, params);
        }

        void info(String msg, Object ... params) {
            TraceLevel.INFO.print(this, msg, params);
        }

        void debug(String msg, Object ... params) {
            TraceLevel.DEBUG.print(this, msg, params);
        }

        boolean isWarn() {
            return this.level.isEnabled(TraceLevel.WARN);
        }

        boolean isInfo() {
            return this.level.isEnabled(TraceLevel.INFO);
        }

        boolean isDebug() {
            return this.level.isEnabled(TraceLevel.DEBUG);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TraceLevel {
        OFF,
        WARN,
        INFO,
        DEBUG;


        public final boolean isEnabled(TraceLevel other) {
            return this.ordinal() >= other.ordinal();
        }

        private void print(Tracer tracer, String msg, Object ... params) {
            if (tracer.level.isEnabled(this)) {
                tracer.stream.printf(this.prefix(msg), params);
            }
        }

        private String prefix(String msg) {
            return "[picocli " + (Object)((Object)this) + "] " + msg;
        }

        static TraceLevel lookup(String key) {
            if (key == null) {
                return WARN;
            }
            if (CommandLine.empty(key) || "true".equalsIgnoreCase(key)) {
                return INFO;
            }
            return TraceLevel.valueOf(key.toUpperCase(Locale.ENGLISH));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Assert {
        static <T> T notNull(T object, String description) {
            if (object == null) {
                throw new NullPointerException(description);
            }
            return object;
        }

        static boolean equals(Object obj1, Object obj2) {
            if (obj1 == null) {
                return obj2 == null;
            }
            return obj1.equals(obj2);
        }

        static int hashCode(Object obj) {
            if (obj == null) {
                return 0;
            }
            return obj.hashCode();
        }

        static int hashCode(boolean bool) {
            if (bool) {
                return 1;
            }
            return 0;
        }

        static void assertTrue(boolean condition, String message) {
            if (!condition) {
                throw new IllegalStateException(message);
            }
        }

        static void assertTrue(boolean condition, IHelpSectionRenderer producer) {
            if (!condition) {
                throw new IllegalStateException(producer.render(null));
            }
        }

        private Assert() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Help {
        protected static final String DEFAULT_COMMAND_NAME = "<main class>";
        protected static final String DEFAULT_SEPARATOR = "=";
        public final Model.PositionalParamSpec AT_FILE_POSITIONAL_PARAM = ((Model.PositionalParamSpec.Builder)((Model.PositionalParamSpec.Builder)((Model.PositionalParamSpec.Builder)((Model.PositionalParamSpec.Builder)Model.PositionalParamSpec.builder().paramLabel("${picocli.atfile.label:-@<filename>}")).description("${picocli.atfile.description:-One or more argument files containing options.}")).arity("0..*")).descriptionKey("picocli.atfile")).build();
        public final Model.OptionSpec END_OF_OPTIONS_OPTION = this.createEndOfOptionsOption("--");
        private final Model.CommandSpec commandSpec;
        private final ColorScheme colorScheme;
        private final Map<String, Help> allCommands = new LinkedHashMap<String, Help>();
        private final Map<String, Help> visibleCommands = new LinkedHashMap<String, Help>();
        private List<String> aliases;
        private final IParamLabelRenderer parameterLabelRenderer;

        private Model.OptionSpec createEndOfOptionsOption(String name) {
            return ((Model.OptionSpec.Builder)((Model.OptionSpec.Builder)((Model.OptionSpec.Builder)Model.OptionSpec.builder(name, new String[0]).description("${picocli.endofoptions.description:-This option can be used to separate command-line options from the list of positional parameters.}")).arity("0")).descriptionKey("picocli.endofoptions")).build();
        }

        public Help(Object command) {
            this(command, Ansi.AUTO);
        }

        public Help(Object command, Ansi ansi) {
            this(command, Help.defaultColorScheme(ansi));
        }

        @Deprecated
        public Help(Object command, ColorScheme colorScheme) {
            this(Model.CommandSpec.forAnnotatedObject(command, new DefaultFactory()), colorScheme);
        }

        public Help(Model.CommandSpec commandSpec, ColorScheme colorScheme) {
            this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            this.aliases = new ArrayList<String>(Arrays.asList(commandSpec.aliases()));
            this.aliases.add(0, commandSpec.name());
            this.colorScheme = new ColorScheme.Builder(colorScheme).applySystemProperties().build();
            this.parameterLabelRenderer = new DefaultParamLabelRenderer(commandSpec);
            this.registerSubcommands(commandSpec.subcommands());
            this.AT_FILE_POSITIONAL_PARAM.commandSpec = commandSpec;
        }

        Help withCommandNames(List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public ColorScheme colorScheme() {
            return this.colorScheme;
        }

        private IHelpFactory getHelpFactory() {
            return this.commandSpec.usageMessage().helpFactory();
        }

        public Map<String, Help> subcommands() {
            return Collections.unmodifiableMap(this.visibleCommands);
        }

        public Map<String, Help> allSubcommands() {
            return Collections.unmodifiableMap(this.allCommands);
        }

        protected List<String> aliases() {
            return Collections.unmodifiableList(this.aliases);
        }

        public IParamLabelRenderer parameterLabelRenderer() {
            return this.parameterLabelRenderer;
        }

        public Help addAllSubcommands(Map<String, CommandLine> subcommands) {
            if (subcommands != null) {
                this.registerSubcommands(subcommands);
            }
            return this;
        }

        private void registerSubcommands(Map<String, CommandLine> subcommands) {
            Object object;
            IdentityHashMap<CommandLine, ArrayList<String>> identityHashMap = new IdentityHashMap<CommandLine, ArrayList<String>>();
            for (CommandLine object2 : subcommands.values()) {
                if (identityHashMap.containsKey(object2)) continue;
                identityHashMap.put(object2, new ArrayList<String>(Arrays.asList(object2.commandSpec.aliases())));
            }
            for (Map.Entry entry : subcommands.entrySet()) {
                object = (List)identityHashMap.get(entry.getValue());
                if (object.contains(entry.getKey())) continue;
                object.add(0, entry.getKey());
            }
            for (Map.Entry entry : subcommands.entrySet()) {
                object = (CommandLine)entry.getValue();
                List list = (List)identityHashMap.remove(object);
                if (list == null) continue;
                String string = list.toString().substring(1, list.toString().length() - 1);
                Help help = this.getHelpFactory().create(((CommandLine)object).commandSpec, this.colorScheme).withCommandNames(list);
                this.allCommands.put(string, help);
                if (help.commandSpec().usageMessage().hidden()) continue;
                this.visibleCommands.put(string, help);
            }
        }

        @Deprecated
        public Help addSubcommand(String commandName, Object command) {
            Help help = this.getHelpFactory().create(Model.CommandSpec.forAnnotatedObject(command, this.commandSpec.commandLine().factory), Help.defaultColorScheme(Ansi.AUTO));
            this.visibleCommands.put(commandName, help);
            this.allCommands.put(commandName, help);
            return this;
        }

        List<Model.OptionSpec> options() {
            return this.commandSpec.options();
        }

        List<Model.PositionalParamSpec> positionalParameters() {
            return this.commandSpec.positionalParameters();
        }

        String commandName() {
            return this.commandSpec.name();
        }

        public String fullSynopsis() {
            Help help = this;
            return this.synopsisHeading(new Object[0]) + help.synopsis(help.synopsisHeadingLength());
        }

        @Deprecated
        public String synopsis() {
            return this.synopsis(0);
        }

        public String synopsis(int synopsisHeadingLength) {
            if (!CommandLine.empty(this.commandSpec.usageMessage().customSynopsis())) {
                return this.customSynopsis(new Object[0]);
            }
            if (this.commandSpec.usageMessage().abbreviateSynopsis()) {
                return this.abbreviatedSynopsis();
            }
            return this.detailedSynopsis(synopsisHeadingLength, Help.createShortOptionArityAndNameComparator(), true);
        }

        public String abbreviatedSynopsis() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.commandSpec.optionsMap().isEmpty()) {
                stringBuilder.append(" [OPTIONS]");
            }
            for (Model.PositionalParamSpec positionalParamSpec : this.commandSpec.positionalParameters()) {
                if (positionalParamSpec.hidden()) continue;
                stringBuilder.append(' ').append(this.parameterLabelRenderer().renderParameterLabel(positionalParamSpec, this.ansi(), this.colorScheme.parameterStyles));
            }
            if (!this.commandSpec.subcommands().isEmpty()) {
                stringBuilder.append(" ").append(this.commandSpec.usageMessage().synopsisSubcommandLabel());
            }
            return this.colorScheme.commandText(this.commandSpec.qualifiedName()).toString() + stringBuilder.toString() + System.getProperty("line.separator");
        }

        @Deprecated
        public String detailedSynopsis(Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            return this.detailedSynopsis(0, optionSort, clusterBooleanOptions);
        }

        public String detailedSynopsis(int synopsisHeadingLength, Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            HashSet<Model.ArgSpec> hashSet = new HashSet<Model.ArgSpec>();
            Ansi.Text text = this.createDetailedSynopsisGroupsText(hashSet);
            Ansi.Text text2 = this.createDetailedSynopsisOptionsText(hashSet, optionSort, clusterBooleanOptions);
            Ansi.Text text3 = this.createDetailedSynopsisEndOfOptionsText();
            Ansi.Text text4 = this.createDetailedSynopsisPositionalsText(hashSet);
            Ansi.Text text5 = this.createDetailedSynopsisCommandText();
            return this.makeSynopsisFromParts(synopsisHeadingLength, text2, text, text3, text4, text5);
        }

        protected String makeSynopsisFromParts(int synopsisHeadingLength, Ansi.Text optionText, Ansi.Text groupsText, Ansi.Text endOfOptionsText, Ansi.Text positionalParamText, Ansi.Text commandText) {
            boolean bl = true;
            for (Model.ArgGroupSpec argGroupSpec : this.commandSpec().argGroups()) {
                if (!argGroupSpec.validate()) continue;
                bl &= argGroupSpec.allOptionsNested().isEmpty();
            }
            Ansi.Text text = bl ? optionText.concat(endOfOptionsText).concat(groupsText).concat(positionalParamText).concat(commandText) : optionText.concat(groupsText).concat(endOfOptionsText).concat(positionalParamText).concat(commandText);
            return this.insertSynopsisCommandName(synopsisHeadingLength, text);
        }

        protected Ansi.Text createDetailedSynopsisGroupsText(Set<Model.ArgSpec> outparam_groupArgs) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            for (Model.ArgGroupSpec argGroupSpec : this.commandSpec().argGroups()) {
                if (!argGroupSpec.validate()) continue;
                text = text.concat(" ").concat(argGroupSpec.synopsisText(this.colorScheme(), outparam_groupArgs));
            }
            return text;
        }

        protected Ansi.Text createDetailedSynopsisOptionsText(Collection<Model.ArgSpec> done, Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            return this.createDetailedSynopsisOptionsText(done, this.commandSpec.options(), optionSort, clusterBooleanOptions);
        }

        protected Ansi.Text createDetailedSynopsisOptionsText(Collection<Model.ArgSpec> done, List<Model.OptionSpec> optionList, Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            ArrayList<Model.OptionSpec> arrayList = new ArrayList<Model.OptionSpec>(optionList);
            if (optionSort != null) {
                Collections.sort(arrayList, optionSort);
            }
            arrayList.removeAll(done);
            if (clusterBooleanOptions) {
                ArrayList arrayList2 = new ArrayList();
                StringBuilder object = new StringBuilder("-");
                StringBuilder stringBuilder = new StringBuilder("-");
                for (Model.OptionSpec optionSpec : arrayList) {
                    String string;
                    boolean bl;
                    if (optionSpec.hidden() || !(bl = optionSpec.typeInfo().isBoolean()) || optionSpec.arity().max > 0 || (string = optionSpec.shortestName()).length() != 2 || !string.startsWith("-") || optionSpec.negatable() && !string.equals(this.commandSpec.negatableOptionTransformer().makeSynopsis(string, this.commandSpec))) continue;
                    arrayList2.add(optionSpec);
                    if (optionSpec.required()) {
                        object.append(string.substring(1));
                        continue;
                    }
                    stringBuilder.append(string.substring(1));
                }
                arrayList.removeAll(arrayList2);
                if (object.length() > 1) {
                    text = text.concat(" ").concat(this.colorScheme.optionText(object.toString()));
                }
                if (stringBuilder.length() > 1) {
                    text = text.concat(" [").concat(this.colorScheme.optionText(stringBuilder.toString())).concat("]");
                }
            }
            for (Model.OptionSpec optionSpec : arrayList) {
                text = Help.concatOptionText(" ", text, this.colorScheme, optionSpec, this.parameterLabelRenderer());
            }
            return text;
        }

        static Ansi.Text concatOptionText(String prefix, Ansi.Text text, ColorScheme colorScheme, Model.OptionSpec option, IParamLabelRenderer parameterLabelRenderer) {
            if (!option.hidden()) {
                Object object;
                String string = option.shortestName();
                if (option.negatable) {
                    object = option.commandSpec == null ? RegexTransformer.createDefault() : option.commandSpec.negatableOptionTransformer();
                    string = object.makeSynopsis(option.shortestName(), option.commandSpec);
                }
                object = colorScheme.optionText(string);
                Ansi.Text text2 = parameterLabelRenderer.renderParameterLabel(option, colorScheme.ansi(), colorScheme.optionParamStyles);
                text = text.concat(prefix);
                if (option.required()) {
                    text = text.concat((Ansi.Text)object).concat(text2).concat("");
                    if (option.isMultiValue()) {
                        text = text.concat(" [").concat((Ansi.Text)object).concat(text2).concat("]...");
                    }
                } else {
                    text = text.concat("[").concat((Ansi.Text)object).concat(text2).concat("]");
                    if (option.isMultiValue()) {
                        text = text.concat("...");
                    }
                }
            }
            return text;
        }

        protected Ansi.Text createDetailedSynopsisEndOfOptionsText() {
            if (!this.commandSpec.usageMessage.showEndOfOptionsDelimiterInUsageHelp()) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                return ansi.new Ansi.Text(0);
            }
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            return ansi.new Ansi.Text(0).concat(" [").concat(this.colorScheme.optionText(this.commandSpec.parser().endOfOptionsDelimiter())).concat("]");
        }

        protected Ansi.Text createDetailedSynopsisPositionalsText(Collection<Model.ArgSpec> done) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            ArrayList<Model.PositionalParamSpec> arrayList = new ArrayList<Model.PositionalParamSpec>(this.commandSpec.positionalParameters());
            if (this.hasAtFileParameter()) {
                arrayList.add(0, this.AT_FILE_POSITIONAL_PARAM);
                this.AT_FILE_POSITIONAL_PARAM.messages(this.commandSpec.usageMessage().messages());
            }
            arrayList.removeAll(done);
            for (Model.PositionalParamSpec positionalParamSpec : arrayList) {
                text = Help.concatPositionalText(" ", text, this.colorScheme, positionalParamSpec, this.parameterLabelRenderer());
            }
            return text;
        }

        static Ansi.Text concatPositionalText(String prefix, Ansi.Text text, ColorScheme colorScheme, Model.PositionalParamSpec positionalParam, IParamLabelRenderer parameterLabelRenderer) {
            if (!positionalParam.hidden()) {
                Ansi.Text text2 = parameterLabelRenderer.renderParameterLabel(positionalParam, colorScheme.ansi(), colorScheme.parameterStyles);
                text = text.concat(prefix).concat(text2);
            }
            return text;
        }

        protected Ansi.Text createDetailedSynopsisCommandText() {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            if (!this.commandSpec.subcommands().isEmpty()) {
                return text.concat(" ").concat(this.commandSpec.usageMessage().synopsisSubcommandLabel());
            }
            return text;
        }

        protected String insertSynopsisCommandName(int synopsisHeadingLength, Ansi.Text optionsAndPositionalsAndCommandsDetails) {
            int n2;
            if (synopsisHeadingLength < 0) {
                throw new IllegalArgumentException("synopsisHeadingLength must be a positive number but was " + synopsisHeadingLength);
            }
            String string = this.commandSpec.qualifiedName();
            int n3 = synopsisHeadingLength + string.length() + 1;
            if ((double)n2 > this.commandSpec.usageMessage().synopsisAutoIndentThreshold() * (double)this.width()) {
                n3 = this.commandSpec.usageMessage().synopsisIndent() < 0 ? synopsisHeadingLength : this.commandSpec.usageMessage().synopsisIndent();
                n3 = Math.min(n3, (int)(0.9 * (double)this.width()));
            }
            TextTable textTable = TextTable.forColumnWidths(this.colorScheme, this.width());
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters());
            textTable.indentWrappedLines = n3;
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(Help.stringOf('X', synopsisHeadingLength), optionsAndPositionalsAndCommandsDetails.colorScheme);
            textTable.addRowValues(text.concat(this.colorScheme.commandText(string)).concat(optionsAndPositionalsAndCommandsDetails));
            return textTable.toString().substring(synopsisHeadingLength);
        }

        public int synopsisHeadingLength() {
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            String[] stringArray = ansi.new Ansi.Text(this.commandSpec.usageMessage().synopsisHeading()).toString().split("\\r?\\n|\\r|%n", -1);
            return stringArray[stringArray.length - 1].length();
        }

        private List<Model.OptionSpec> excludeHiddenAndGroupOptions(List<Model.OptionSpec> all) {
            ArrayList<Model.OptionSpec> arrayList = new ArrayList<Model.OptionSpec>(all);
            for (Model.ArgGroupSpec argGroupSpec : this.optionSectionGroups()) {
                arrayList.removeAll(argGroupSpec.allOptionsNested());
            }
            Iterator<Model.ArgGroupSpec> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!((Model.OptionSpec)((Object)iterator.next())).hidden()) continue;
                iterator.remove();
            }
            return arrayList;
        }

        private List<Model.PositionalParamSpec> excludeHiddenAndGroupParams(List<Model.PositionalParamSpec> all) {
            ArrayList<Model.PositionalParamSpec> arrayList = new ArrayList<Model.PositionalParamSpec>(all);
            for (Model.ArgGroupSpec argGroupSpec : this.optionSectionGroups()) {
                arrayList.removeAll(argGroupSpec.allPositionalParametersNested());
            }
            Iterator<Model.ArgGroupSpec> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!((Model.PositionalParamSpec)((Object)iterator.next())).hidden()) continue;
                iterator.remove();
            }
            return arrayList;
        }

        private static Comparator<Model.OptionSpec> createOrderComparatorIfNecessary(List<Model.OptionSpec> options) {
            for (Model.OptionSpec optionSpec : options) {
                if (optionSpec.order() == -1) continue;
                return Help.createOrderComparator();
            }
            return null;
        }

        public Comparator<Model.OptionSpec> createDefaultOptionSort() {
            if (this.commandSpec.usageMessage().sortOptions()) {
                return Help.createShortOptionNameComparator();
            }
            return Help.createOrderComparatorIfNecessary(this.commandSpec.options());
        }

        public String optionList() {
            Help help = this;
            return help.optionList(help.createDefaultLayout(), this.createDefaultOptionSort(), this.parameterLabelRenderer());
        }

        public String optionListExcludingGroups(List<Model.OptionSpec> options) {
            return this.optionListExcludingGroups(options, this.createDefaultLayout(), this.createDefaultOptionSort(), this.parameterLabelRenderer());
        }

        public String optionList(Layout layout, Comparator<Model.OptionSpec> optionSort, IParamLabelRenderer valueLabelRenderer) {
            Help help = this;
            List<Model.OptionSpec> list = help.excludeHiddenAndGroupOptions(help.options());
            return this.optionListExcludingGroups(list, layout, optionSort, valueLabelRenderer) + this.optionListGroupSections();
        }

        public String optionListExcludingGroups(List<Model.OptionSpec> optionList, Layout layout, Comparator<Model.OptionSpec> optionSort, IParamLabelRenderer valueLabelRenderer) {
            ArrayList<Model.OptionSpec> arrayList = new ArrayList<Model.OptionSpec>(optionList);
            if (optionSort != null) {
                Collections.sort(arrayList, optionSort);
            }
            layout.addAllOptions(arrayList, valueLabelRenderer);
            return layout.toString();
        }

        public String optionListGroupSections() {
            Help help = this;
            return help.optionListGroupSections(help.optionSectionGroups(), this.createDefaultOptionSort(), this.parameterLabelRenderer());
        }

        private String optionListGroupSections(List<Model.ArgGroupSpec> groupList, Comparator<Model.OptionSpec> optionSort, IParamLabelRenderer paramLabelRenderer) {
            HashSet<Model.ArgSpec> hashSet = new HashSet<Model.ArgSpec>();
            ArrayList<Model.ArgGroupSpec> arrayList = new ArrayList<Model.ArgGroupSpec>(groupList);
            Collections.sort(arrayList, new SortByOrder());
            StringBuilder stringBuilder = new StringBuilder();
            for (Model.ArgGroupSpec argGroupSpec : arrayList) {
                ArrayList<Model.OptionSpec> arrayList2 = new ArrayList<Model.OptionSpec>(argGroupSpec.allOptionsNested());
                if (optionSort != null) {
                    Collections.sort(arrayList2, optionSort);
                }
                arrayList2.removeAll(hashSet);
                hashSet.addAll(arrayList2);
                ArrayList<Model.PositionalParamSpec> arrayList3 = new ArrayList<Model.PositionalParamSpec>(argGroupSpec.allPositionalParametersNested());
                arrayList3.removeAll(hashSet);
                hashSet.addAll(arrayList3);
                Layout layout = this.createDefaultLayout();
                layout.addPositionalParameters(arrayList3, paramLabelRenderer);
                layout.addOptions(arrayList2, paramLabelRenderer);
                stringBuilder.append(this.createHeading(argGroupSpec.heading(), new Object[0]));
                stringBuilder.append(layout);
            }
            return stringBuilder.toString();
        }

        public List<Model.ArgGroupSpec> optionSectionGroups() {
            ArrayList<Model.ArgGroupSpec> arrayList = new ArrayList<Model.ArgGroupSpec>();
            Help.optionSectionGroups(this.commandSpec.argGroups(), arrayList);
            return arrayList;
        }

        private static void optionSectionGroups(List<Model.ArgGroupSpec> groups, List<Model.ArgGroupSpec> result) {
            for (Model.ArgGroupSpec argGroupSpec : groups) {
                Help.optionSectionGroups(argGroupSpec.subgroups(), result);
                if (argGroupSpec.heading() == null) continue;
                result.add(argGroupSpec);
            }
        }

        public String parameterList() {
            Help help = this;
            return help.parameterList(help.excludeHiddenAndGroupParams(this.positionalParameters()));
        }

        public String parameterList(List<Model.PositionalParamSpec> positionalParams) {
            return this.parameterList(positionalParams, this.createDefaultLayout(), this.parameterLabelRenderer());
        }

        public String parameterList(Layout layout, IParamLabelRenderer paramLabelRenderer) {
            Help help = this;
            return help.parameterList(help.excludeHiddenAndGroupParams(this.positionalParameters()), layout, paramLabelRenderer);
        }

        public String parameterList(List<Model.PositionalParamSpec> positionalParams, Layout layout, IParamLabelRenderer paramLabelRenderer) {
            layout.addAllPositionalParameters(positionalParams, paramLabelRenderer);
            return layout.toString();
        }

        public boolean hasAtFileParameter() {
            return this.commandSpec.parser.expandAtFiles() && this.commandSpec.usageMessage.showAtFileInUsageHelp();
        }

        public String atFileParameterList() {
            if (this.hasAtFileParameter()) {
                this.AT_FILE_POSITIONAL_PARAM.messages(this.commandSpec.usageMessage().messages());
                Layout layout = this.createDefaultLayout();
                layout.addPositionalParameter(this.AT_FILE_POSITIONAL_PARAM, this.parameterLabelRenderer());
                return layout.toString();
            }
            return "";
        }

        public String endOfOptionsList() {
            Model.OptionSpec optionSpec;
            if (!this.commandSpec.usageMessage.showEndOfOptionsDelimiterInUsageHelp()) {
                return "";
            }
            if ("--".equals(this.commandSpec.parser().endOfOptionsDelimiter())) {
                optionSpec = this.END_OF_OPTIONS_OPTION;
            } else {
                Help help = this;
                optionSpec = help.createEndOfOptionsOption(help.commandSpec.parser().endOfOptionsDelimiter());
            }
            Model.OptionSpec optionSpec2 = optionSpec;
            optionSpec.commandSpec = this.commandSpec;
            try {
                optionSpec2.messages(this.commandSpec.usageMessage().messages());
                Layout layout = this.createDefaultLayout();
                layout.addOption(optionSpec2, this.parameterLabelRenderer());
                String string = layout.toString();
                return string;
            }
            finally {
                optionSpec2.commandSpec = null;
            }
        }

        private static String heading(Ansi ansi, int usageWidth, boolean adjustCJK, String values, Object ... params) {
            StringBuilder stringBuilder = Help.join(ansi, usageWidth, adjustCJK, new String[]{values}, new StringBuilder(), params);
            return Help.trimLineSeparator(stringBuilder.toString()) + new String(Help.spaces(Help.countTrailingSpaces(values)));
        }

        static String trimLineSeparator(String result) {
            if (result.endsWith(System.getProperty("line.separator"))) {
                return result.substring(0, result.length() - System.getProperty("line.separator").length());
            }
            return result;
        }

        private static char[] spaces(int length) {
            char[] cArray = new char[length];
            Arrays.fill(cArray, ' ');
            return cArray;
        }

        private static int countTrailingSpaces(String str) {
            if (str == null) {
                return 0;
            }
            int n2 = 0;
            for (int i2 = str.length() - 1; i2 >= 0 && str.charAt(i2) == ' '; --i2) {
                ++n2;
            }
            return n2;
        }

        @Deprecated
        public static StringBuilder join(Ansi ansi, int usageHelpWidth, String[] values, StringBuilder sb, Object ... params) {
            return Help.join(ansi, usageHelpWidth, Model.UsageMessageSpec.DEFAULT_ADJUST_CJK, values, sb, params);
        }

        public static StringBuilder join(Ansi ansi, int usageHelpWidth, boolean adjustCJK, String[] values, StringBuilder sb, Object ... params) {
            if (values != null) {
                TextTable textTable = TextTable.forColumnWidths(ansi, usageHelpWidth);
                textTable.setAdjustLineBreaksForWideCJKCharacters(adjustCJK);
                textTable.indentWrappedLines = 0;
                String[] stringArray = values;
                int n2 = values.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = stringArray[i2];
                    textTable.addRowValues(CommandLine.format(string, params));
                }
                textTable.toString(sb);
            }
            return sb;
        }

        private int width() {
            return this.commandSpec.usageMessage().width();
        }

        private boolean adjustCJK() {
            return this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters();
        }

        public String customSynopsis(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().customSynopsis(), new StringBuilder(), params).toString();
        }

        public String description(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().description(), new StringBuilder(), params).toString();
        }

        public String header(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().header(), new StringBuilder(), params).toString();
        }

        public String footer(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().footer(), new StringBuilder(), params).toString();
        }

        public String headerHeading(Object ... params) {
            Help help = this;
            return help.createHeading(help.commandSpec.usageMessage().headerHeading(), params);
        }

        public String synopsisHeading(Object ... params) {
            Help help = this;
            return help.createHeading(help.commandSpec.usageMessage().synopsisHeading(), params);
        }

        public String descriptionHeading(Object ... params) {
            if (CommandLine.empty(this.commandSpec.usageMessage().descriptionHeading())) {
                return "";
            }
            Help help = this;
            return help.createHeading(help.commandSpec.usageMessage().descriptionHeading(), params);
        }

        public String parameterListHeading(Object ... params) {
            if (this.hasAtFileParameter() || !this.commandSpec.positionalParameters().isEmpty()) {
                Help help = this;
                return help.createHeading(help.commandSpec.usageMessage().parameterListHeading(), params);
            }
            return "";
        }

        public String optionListHeading(Object ... params) {
            boolean bl = false;
            for (Model.OptionSpec optionSpec : this.commandSpec.options()) {
                bl |= !optionSpec.hidden();
            }
            if (this.commandSpec.usageMessage().showEndOfOptionsDelimiterInUsageHelp() || bl) {
                Help help = this;
                return help.createHeading(help.commandSpec.usageMessage().optionListHeading(), params);
            }
            return "";
        }

        public String commandListHeading(Object ... params) {
            if (this.visibleCommands.isEmpty()) {
                return "";
            }
            Help help = this;
            return help.createHeading(help.commandSpec.usageMessage().commandListHeading(), params);
        }

        public String footerHeading(Object ... params) {
            Help help = this;
            return help.createHeading(help.commandSpec.usageMessage().footerHeading(), params);
        }

        public String exitCodeListHeading(Object ... params) {
            Help help = this;
            return help.createHeading(help.commandSpec.usageMessage().exitCodeListHeading(), params);
        }

        public String exitCodeList() {
            Help help = this;
            return help.createTextTable(help.commandSpec.usageMessage().exitCodeList()).toString();
        }

        public String createHeading(String text, Object ... params) {
            return Help.heading(this.ansi(), this.width(), this.adjustCJK(), text, params);
        }

        public TextTable createTextTable(Map<?, ?> map) {
            if (map == null || map.isEmpty()) {
                return TextTable.forColumnWidths(this.colorScheme, 10, this.width() - 10);
            }
            int n2 = Math.min(this.width() - 3 - 1, Help.maxLength(map.keySet()));
            TextTable textTable = TextTable.forColumns(this.ansi(), new Column(n2 + 3, 2, Column.Overflow.SPAN), new Column(this.width() - (n2 + 3), 2, Column.Overflow.WRAP));
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.adjustCJK());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                textTable.addRowValues(CommandLine.format(String.valueOf(entry.getKey()), new Object[0]), CommandLine.format(String.valueOf(entry.getValue()), new Object[0]));
            }
            return textTable;
        }

        public String commandList() {
            Help help = this;
            return help.commandList(help.subcommands());
        }

        public String commandList(Map<String, Help> subcommands) {
            if (subcommands.isEmpty()) {
                return "";
            }
            int n2 = Help.maxLength(subcommands.keySet());
            TextTable textTable = TextTable.forColumns(this.colorScheme().ansi(), new Column(n2 + 2, 2, Column.Overflow.SPAN), new Column(this.width() - (n2 + 2), 2, Column.Overflow.WRAP));
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.adjustCJK());
            for (Map.Entry<String, Help> entry : subcommands.entrySet()) {
                Help help = entry.getValue();
                Model.UsageMessageSpec usageMessageSpec = help.commandSpec().usageMessage();
                String string = !CommandLine.empty(usageMessageSpec.header()) ? usageMessageSpec.header()[0] : (!CommandLine.empty(usageMessageSpec.description()) ? usageMessageSpec.description()[0] : "");
                Ansi.Text[] textArray = this.colorScheme().text(CommandLine.format(string, new Object[0])).splitLines();
                for (int i2 = 0; i2 < textArray.length; ++i2) {
                    textTable.addRowValues(i2 == 0 ? help.commandNamesText(", ") : Ansi.EMPTY_TEXT, textArray[i2]);
                }
            }
            return textTable.toString();
        }

        private static int maxLength(Collection<?> any) {
            int n2 = 0;
            for (Object obj : any) {
                n2 = Math.max(n2, String.valueOf(obj).length());
            }
            return n2;
        }

        public Ansi.Text commandNamesText(String separator) {
            Ansi.Text text = this.colorScheme().commandText(this.aliases().get(0));
            for (int i2 = 1; i2 < this.aliases().size(); ++i2) {
                text = text.concat(separator).concat(this.colorScheme().commandText(this.aliases().get(i2)));
            }
            return text;
        }

        private static String join(String[] names, int offset, int length, String separator) {
            if (names == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = offset; i2 < offset + length; ++i2) {
                stringBuilder.append(i2 > offset ? separator : "").append(names[i2]);
            }
            return stringBuilder.toString();
        }

        private static String stringOf(char chr, int length) {
            char[] cArray = new char[length];
            Arrays.fill(cArray, chr);
            return new String(cArray);
        }

        public Layout createDefaultLayout() {
            Help help = this;
            return help.createDefaultLayout(help.options(), this.positionalParameters(), this.colorScheme());
        }

        public Layout createDefaultLayout(List<Model.OptionSpec> options, List<Model.PositionalParamSpec> positionals, ColorScheme aColorScheme) {
            Help help = this;
            return help.createLayout(help.calcLongOptionColumnWidth(options, positionals, aColorScheme), aColorScheme);
        }

        private Layout createLayout(int longOptionsColumnWidth, ColorScheme aColorScheme) {
            TextTable textTable = TextTable.forDefaultColumns(aColorScheme, longOptionsColumnWidth, this.width());
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters());
            return new Layout(aColorScheme, textTable, this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
        }

        private int calcLongOptionColumnWidth(List<Model.OptionSpec> options, List<Model.PositionalParamSpec> positionalParamSpecs, ColorScheme aColorScheme) {
            Object object;
            int n2 = 0;
            DefaultOptionRenderer defaultOptionRenderer = new DefaultOptionRenderer(false, " ");
            boolean bl = this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters();
            int n3 = this.commandSpec.usageMessage().longOptionsMaxWidth() + 1;
            for (Model.OptionSpec object22 : options) {
                if (object22.hidden()) continue;
                object = defaultOptionRenderer.render(object22, this.parameterLabelRenderer(), aColorScheme);
                int text = bl ? object[0][3].getCJKAdjustedLength() : object[0][3].length;
                if (text >= n3) continue;
                n2 = Math.max(n2, text);
            }
            ArrayList<Model.PositionalParamSpec> arrayList = new ArrayList<Model.PositionalParamSpec>(positionalParamSpecs);
            if (this.hasAtFileParameter()) {
                arrayList.add(0, this.AT_FILE_POSITIONAL_PARAM);
                this.AT_FILE_POSITIONAL_PARAM.messages(this.commandSpec.usageMessage().messages());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (Model.PositionalParamSpec)iterator.next();
                if (object.hidden()) continue;
                Ansi.Text text = this.parameterLabelRenderer().renderParameterLabel((Model.ArgSpec)object, aColorScheme.ansi(), aColorScheme.parameterStyles);
                int n4 = bl ? text.getCJKAdjustedLength() : text.length;
                if (n4 >= n3) continue;
                n2 = Math.max(n2, n4);
            }
            return n2 + 3;
        }

        public IOptionRenderer createDefaultOptionRenderer() {
            return new DefaultOptionRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IOptionRenderer createMinimalOptionRenderer() {
            return new MinimalOptionRenderer();
        }

        public IParameterRenderer createDefaultParameterRenderer() {
            return new DefaultParameterRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IParameterRenderer createMinimalParameterRenderer() {
            return new MinimalParameterRenderer();
        }

        public static IParamLabelRenderer createMinimalParamLabelRenderer() {
            return new IParamLabelRenderer(){

                @Override
                public final Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> styles) {
                    if (argSpec.command() != null && argSpec.command().commandLine() != null) {
                        return argSpec.command().commandLine().getColorScheme().apply(argSpec.paramLabel(), styles);
                    }
                    return ansi.apply(argSpec.paramLabel(), styles);
                }

                @Override
                public final String separator() {
                    return "";
                }
            };
        }

        public IParamLabelRenderer createDefaultParamLabelRenderer() {
            return new DefaultParamLabelRenderer(this.commandSpec);
        }

        public static Comparator<Model.OptionSpec> createShortOptionNameComparator() {
            return new SortByShortestOptionNameAlphabetically();
        }

        public static Comparator<Model.OptionSpec> createShortOptionArityAndNameComparator() {
            return new SortByOptionArityAndNameAlphabetically();
        }

        public static Comparator<String> shortestFirst() {
            return new ShortestFirst();
        }

        static Comparator<Model.OptionSpec> createOrderComparator() {
            return new SortByOrder<Model.OptionSpec>();
        }

        public Ansi ansi() {
            return this.colorScheme.ansi;
        }

        private static void addTrailingDefaultLine(List<Ansi.Text[]> result, Model.ArgSpec arg, ColorScheme scheme) {
            Ansi.Text text = Ansi.EMPTY_TEXT;
            Ansi.Text[] textArray = new Ansi.Text[5];
            textArray[0] = text;
            textArray[1] = text;
            textArray[2] = text;
            textArray[3] = text;
            Ansi ansi = scheme.ansi();
            ((Object)((Object)ansi)).getClass();
            textArray[4] = ansi.new Ansi.Text("  Default: " + arg.defaultValueString(true), scheme);
            result.add(textArray);
        }

        private static Ansi.Text[] createDescriptionFirstLines(ColorScheme scheme, Model.ArgSpec arg, String[] description, boolean[] showDefault) {
            Ansi ansi = scheme.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text[] textArray = ansi.new Ansi.Text(CommandLine.str(description, 0), scheme).splitLines();
            if (textArray.length == 0 || textArray.length == 1 && textArray[0].plain.length() == 0) {
                if (showDefault[0]) {
                    Ansi.Text[] textArray2 = new Ansi.Text[1];
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    textArray2[0] = ansi2.new Ansi.Text("  Default: " + arg.defaultValueString(true), scheme);
                    textArray = textArray2;
                    showDefault[0] = false;
                } else {
                    textArray = new Ansi.Text[]{Ansi.EMPTY_TEXT};
                }
            }
            return textArray;
        }

        public static ColorScheme defaultColorScheme(Ansi ansi) {
            return new ColorScheme.Builder(ansi).commands(Ansi.Style.bold).options(Ansi.Style.fg_yellow).parameters(Ansi.Style.fg_yellow).optionParams(Ansi.Style.italic).errors(Ansi.Style.fg_red, Ansi.Style.bold).stackTraces(Ansi.Style.italic).build();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Ansi {
            AUTO,
            ON,
            OFF;

            static Text EMPTY_TEXT;
            static Boolean tty;

            static boolean isTTY() {
                if (tty == null) {
                    tty = Ansi.calcTTY();
                }
                return tty;
            }

            static final boolean isWindows() {
                return System.getProperty("os.name").toLowerCase().contains("win");
            }

            static final boolean isMac() {
                return System.getProperty("os.name").toLowerCase().contains("mac");
            }

            static final boolean isXterm() {
                return System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
            }

            static final boolean hasOsType() {
                return System.getenv("OSTYPE") != null;
            }

            static final boolean hintDisabled() {
                return "0".equals(System.getenv("CLICOLOR")) || "OFF".equals(System.getenv("ConEmuANSI"));
            }

            static final boolean hintEnabled() {
                return System.getenv("ANSICON") != null || "1".equals(System.getenv("CLICOLOR")) || "ON".equals(System.getenv("ConEmuANSI"));
            }

            static final boolean forceDisabled() {
                return System.getenv("NO_COLOR") != null;
            }

            static final boolean forceEnabled() {
                return System.getenv("CLICOLOR_FORCE") != null && !"0".equals(System.getenv("CLICOLOR_FORCE"));
            }

            static boolean calcTTY() {
                try {
                    return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
                }
                catch (Throwable throwable) {
                    return true;
                }
            }

            static boolean isPseudoTTY() {
                return Ansi.isWindows() && (Ansi.isXterm() || Ansi.hasOsType());
            }

            static boolean ansiPossible() {
                if (Ansi.forceDisabled()) {
                    return false;
                }
                if (Ansi.forceEnabled()) {
                    return true;
                }
                if (Ansi.isWindows() && Ansi.isJansiConsoleInstalled()) {
                    return true;
                }
                if (Ansi.hintDisabled()) {
                    return false;
                }
                if (!Ansi.isTTY() && !Ansi.isPseudoTTY()) {
                    return false;
                }
                return Ansi.hintEnabled() || !Ansi.isWindows() || Ansi.isXterm() || Ansi.hasOsType();
            }

            static boolean isJansiConsoleInstalled() {
                try {
                    if (Boolean.getBoolean("org.fusesource.jansi.Ansi.disable")) {
                        return false;
                    }
                    Class<?> clazz = Class.forName("org.fusesource.jansi.Ansi");
                    Boolean bl = (Boolean)clazz.getDeclaredMethod("isEnabled", new Class[0]).invoke(null, new Object[0]);
                    if (!bl.booleanValue()) {
                        return false;
                    }
                    Class<?> clazz2 = Class.forName("org.fusesource.jansi.AnsiConsole");
                    Field field = clazz2.getField("out");
                    return field.get(null) == System.out;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public final boolean enabled() {
                boolean bl;
                if (this == ON) {
                    return true;
                }
                if (this == OFF) {
                    return false;
                }
                String string = System.getProperty("picocli.ansi");
                boolean bl2 = string == null || "AUTO".equalsIgnoreCase(string);
                boolean bl3 = bl = "TTY".equalsIgnoreCase(string) && (Ansi.isTTY() || Ansi.isPseudoTTY());
                if (bl2) {
                    return Ansi.ansiPossible();
                }
                return bl || Boolean.getBoolean("picocli.ansi");
            }

            public final Text text(String stringWithMarkup) {
                return new Text(stringWithMarkup);
            }

            public final String string(String stringWithMarkup) {
                return new Text(stringWithMarkup).toString();
            }

            public static Ansi valueOf(boolean enabled) {
                if (enabled) {
                    return ON;
                }
                return OFF;
            }

            @Deprecated
            public final Text apply(String plainText, List<IStyle> styles) {
                return Help.defaultColorScheme(this).apply(plainText, styles);
            }

            static {
                Ansi ansi = OFF;
                ((Object)((Object)ansi)).getClass();
                EMPTY_TEXT = ansi.new Text(0);
            }

            public class Text
            implements Cloneable {
                private final int maxLength;
                private int from;
                private int length;
                private StringBuilder plain = new StringBuilder();
                private List<StyledSection> sections = new ArrayList<StyledSection>();
                private ColorScheme colorScheme;

                public Text(int maxLength) {
                    this(maxLength, Help.defaultColorScheme(this$0));
                }

                public Text(int maxLength, ColorScheme colorScheme) {
                    this.maxLength = maxLength;
                    this.colorScheme = colorScheme;
                }

                public Text(Text other) {
                    this.maxLength = other.maxLength;
                    this.from = other.from;
                    this.length = other.length;
                    this.plain = new StringBuilder(other.plain);
                    this.sections = new ArrayList<StyledSection>(other.sections);
                    this.colorScheme = other.colorScheme;
                }

                public Text(String input) {
                    this(input, Help.defaultColorScheme(this$0));
                }

                public Text(String input, ColorScheme colorScheme) {
                    this.colorScheme = colorScheme;
                    this.maxLength = -1;
                    this.plain.setLength(0);
                    int n2 = 0;
                    while (true) {
                        int n3;
                        if ((n3 = input.indexOf("@|", n2)) == -1) {
                            if (n2 == 0) {
                                this.plain.append(input);
                                this.length = this.plain.length();
                                return;
                            }
                            this.plain.append(input.substring(n2));
                            this.length = this.plain.length();
                            return;
                        }
                        this.plain.append(input, n2, n3);
                        int n4 = input.indexOf("|@", n3);
                        if (n4 == -1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        String string = input.substring(n3 += 2, n4);
                        String[] stringArray = string.split(" ", 2);
                        if (stringArray.length == 1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        Object[] objectArray = colorScheme.parse(stringArray[0]);
                        Text text = this;
                        text.addStyledSection(text.plain.length(), stringArray[1].length(), Style.on((IStyle[])objectArray), Style.off((IStyle[])CommandLine.reverseArray(objectArray)) + colorScheme.resetStyle().off());
                        this.plain.append(stringArray[1]);
                        n2 = n4 + 2;
                    }
                }

                private void addStyledSection(int start, int length, String startStyle, String endStyle) {
                    this.sections.add(new StyledSection(start, length, startStyle, endStyle));
                }

                public Object clone() {
                    return new Text(this);
                }

                public Text[] splitLines() {
                    ArrayList<Text> arrayList = new ArrayList<Text>();
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < this.plain.length()) {
                        boolean bl;
                        char c2 = this.plain.charAt(n4);
                        boolean bl2 = bl = c2 == '\n';
                        if (c2 == '\r' && n4 + 1 < this.plain.length() && this.plain.charAt(n4 + 1) == '\n') {
                            bl = true;
                            ++n4;
                        }
                        if (bl |= c2 == '\r') {
                            arrayList.add(this.substring(n2, n3));
                            n2 = n4 + 1;
                        }
                        n3 = ++n4;
                    }
                    arrayList.add(this.substring(n2, this.plain.length()));
                    ArrayList<Text> arrayList2 = arrayList;
                    return arrayList2.toArray(new Text[arrayList2.size()]);
                }

                public Text substring(int start) {
                    return this.substring(start, this.length);
                }

                public Text substring(int start, int end) {
                    Text text = (Text)this.clone();
                    ((Text)this.clone()).from = this.from + start;
                    text.length = end - start;
                    text.sections.clear();
                    for (StyledSection styledSection : this.sections) {
                        if (styledSection.startIndex >= text.from + text.length || styledSection.startIndex + styledSection.length <= text.from) continue;
                        text.sections.add(styledSection);
                    }
                    return text;
                }

                @Deprecated
                public Text append(String string) {
                    return this.concat(string);
                }

                @Deprecated
                public Text append(Text text) {
                    return this.concat(text);
                }

                public Text concat(String string) {
                    return this.concat(new Text(string, this.colorScheme));
                }

                public Text concat(Text other) {
                    Text text = (Text)this.clone();
                    ((Text)this.clone()).plain = new StringBuilder(this.plain.toString().substring(this.from, this.from + this.length));
                    text.from = 0;
                    text.sections = new ArrayList<StyledSection>();
                    Iterator<StyledSection> iterator = this.sections.iterator();
                    while (iterator.hasNext()) {
                        StyledSection styledSection;
                        StyledSection styledSection2 = styledSection = iterator.next();
                        text.sections.add(styledSection2.withStartIndex(styledSection2.startIndex - this.from));
                    }
                    text.plain.append(other.plain.toString(), other.from, other.from + other.length);
                    for (StyledSection styledSection : other.sections) {
                        int n2 = text.length + styledSection.startIndex - other.from;
                        text.sections.add(styledSection.withStartIndex(n2));
                    }
                    text.length = text.plain.length();
                    return text;
                }

                public void getStyledChars(int from, int length, Text destination, int offset) {
                    if (destination.length < offset) {
                        for (int i2 = destination.length; i2 < offset; ++i2) {
                            destination.plain.append(' ');
                        }
                        destination.length = offset;
                    }
                    for (StyledSection styledSection : this.sections) {
                        if (styledSection.startIndex - from + styledSection.length < 0) continue;
                        StyledSection styledSection2 = styledSection;
                        destination.sections.add(styledSection2.withStartIndex(styledSection2.startIndex - from + destination.length));
                    }
                    int n2 = from;
                    destination.plain.append(this.plain.toString(), n2, n2 + length);
                    destination.length = destination.plain.length();
                }

                public String plainString() {
                    return this.plain.toString().substring(this.from, this.from + this.length);
                }

                public boolean equals(Object obj) {
                    return this.toString().equals(String.valueOf(obj));
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                public String toString() {
                    if (!Ansi.this.enabled()) {
                        return this.plain.toString().substring(this.from, this.from + this.length);
                    }
                    if (this.length == 0) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder(this.plain.length() + 20 * this.sections.size());
                    StyledSection styledSection = null;
                    int n2 = Math.min(this.from + this.length, this.plain.length());
                    for (int i2 = this.from; i2 < n2; ++i2) {
                        StyledSection styledSection2 = this.findSectionContaining(i2);
                        if (styledSection2 != styledSection) {
                            if (styledSection != null) {
                                stringBuilder.append(styledSection.endStyles);
                            }
                            if (styledSection2 != null) {
                                stringBuilder.append(styledSection2.startStyles);
                            }
                            styledSection = styledSection2;
                        }
                        stringBuilder.append(this.plain.charAt(i2));
                    }
                    if (styledSection != null) {
                        stringBuilder.append(styledSection.endStyles);
                    }
                    return stringBuilder.toString();
                }

                private StyledSection findSectionContaining(int index) {
                    for (StyledSection styledSection : this.sections) {
                        if (index < styledSection.startIndex || index >= styledSection.startIndex + styledSection.length) continue;
                        return styledSection;
                    }
                    return null;
                }

                public int getCJKAdjustedLength() {
                    Text text = this;
                    return text.getCJKAdjustedLength(text.from, this.length);
                }

                public int getCJKAdjustedLength(int fromPosition, int charCount) {
                    int n2 = 0;
                    for (int i2 = fromPosition; i2 < fromPosition + charCount; ++i2) {
                        n2 += Model.UsageMessageSpec.isCharCJK(this.plain.charAt(i2)) ? 2 : 1;
                    }
                    return n2;
                }
            }

            private static class StyledSection {
                int startIndex;
                int length;
                String startStyles;
                String endStyles;

                StyledSection(int start, int len, String style1, String style2) {
                    this.startIndex = start;
                    this.length = len;
                    this.startStyles = style1;
                    this.endStyles = style2;
                }

                StyledSection withStartIndex(int newStart) {
                    return new StyledSection(newStart, this.length, this.startStyles, this.endStyles);
                }
            }

            static class Palette256Color
            implements IStyle {
                private final int fgbg;
                private final int color;

                Palette256Color(boolean foreground, String color) {
                    this.fgbg = foreground ? 38 : 48;
                    String[] stringArray = color.split(";");
                    if (stringArray.length == 3) {
                        this.color = 16 + 36 * Integer.decode(stringArray[0]) + 6 * Integer.decode(stringArray[1]) + Integer.decode(stringArray[2]);
                        return;
                    }
                    this.color = Integer.decode(color);
                }

                public String on() {
                    return String.format("\u001b[%d;5;%dm", this.fgbg, this.color);
                }

                public String off() {
                    return "\u001b[" + (this.fgbg + 1) + "m";
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof Palette256Color)) {
                        return false;
                    }
                    Palette256Color palette256Color = (Palette256Color)obj;
                    return palette256Color.fgbg == this.fgbg && palette256Color.color == this.color;
                }

                public int hashCode() {
                    return (17 + this.fgbg) * 37 + this.color;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Style implements IStyle
            {
                reset(0, 0),
                bold(1, 21),
                faint(2, 22),
                italic(3, 23),
                underline(4, 24),
                blink(5, 25),
                reverse(7, 27),
                fg_black(30, 39),
                fg_red(31, 39),
                fg_green(32, 39),
                fg_yellow(33, 39),
                fg_blue(34, 39),
                fg_magenta(35, 39),
                fg_cyan(36, 39),
                fg_white(37, 39),
                bg_black(40, 49),
                bg_red(41, 49),
                bg_green(42, 49),
                bg_yellow(43, 49),
                bg_blue(44, 49),
                bg_magenta(45, 49),
                bg_cyan(46, 49),
                bg_white(47, 49);

                private final int startCode;
                private final int endCode;

                private Style(int startCode, int endCode) {
                    this.startCode = startCode;
                    this.endCode = endCode;
                }

                @Override
                public final String on() {
                    return "\u001b[" + this.startCode + "m";
                }

                @Override
                public final String off() {
                    return "\u001b[" + this.endCode + "m";
                }

                public static String on(IStyle ... styles) {
                    StringBuilder stringBuilder = new StringBuilder();
                    IStyle[] iStyleArray = styles;
                    int n2 = styles.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        IStyle iStyle = iStyleArray[i2];
                        stringBuilder.append(iStyle.on());
                    }
                    return stringBuilder.toString();
                }

                public static String off(IStyle ... styles) {
                    StringBuilder stringBuilder = new StringBuilder();
                    IStyle[] iStyleArray = styles;
                    int n2 = styles.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        IStyle iStyle = iStyleArray[i2];
                        stringBuilder.append(iStyle.off());
                    }
                    return stringBuilder.toString();
                }

                public static IStyle fg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("fg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(true, str);
                        }
                    }
                }

                public static IStyle bg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("bg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(false, str);
                        }
                    }
                }

                public static IStyle[] parse(String commaSeparatedCodes) {
                    String[] stringArray = commaSeparatedCodes.split(",");
                    IStyle[] iStyleArray = new IStyle[stringArray.length];
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        int n2;
                        if (stringArray[i2].toLowerCase(Locale.ENGLISH).startsWith("fg(")) {
                            n2 = stringArray[i2].indexOf(41);
                            iStyleArray[i2] = Style.fg(stringArray[i2].substring(3, n2 < 0 ? stringArray[i2].length() : n2));
                            continue;
                        }
                        if (stringArray[i2].toLowerCase(Locale.ENGLISH).startsWith("bg(")) {
                            n2 = stringArray[i2].indexOf(41);
                            iStyleArray[i2] = Style.bg(stringArray[i2].substring(3, n2 < 0 ? stringArray[i2].length() : n2));
                            continue;
                        }
                        iStyleArray[i2] = Style.fg(stringArray[i2]);
                    }
                    return iStyleArray;
                }
            }

            public static interface IStyle {
                public static final String CSI = "\u001b[";

                public String on();

                public String off();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ColorScheme {
            private static final Ansi.IStyle EMPTY_STYLE = new Ansi.IStyle(){

                public final String on() {
                    return "";
                }

                public final String off() {
                    return "";
                }
            };
            private final List<Ansi.IStyle> commandStyles;
            private final List<Ansi.IStyle> optionStyles;
            private final List<Ansi.IStyle> parameterStyles;
            private final List<Ansi.IStyle> optionParamStyles;
            private final List<Ansi.IStyle> errorStyles;
            private final List<Ansi.IStyle> stackTraceStyles;
            private final Ansi ansi;
            private final Map<String, Ansi.IStyle> markupMap;

            ColorScheme(Builder builder) {
                Assert.notNull(builder, "builder");
                this.ansi = Assert.notNull(builder.ansi(), "ansi");
                this.commandStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.commandStyles()));
                this.optionStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.optionStyles()));
                this.parameterStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.parameterStyles()));
                this.optionParamStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.optionParamStyles()));
                this.errorStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.errorStyles()));
                this.stackTraceStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.stackTraceStyles()));
                this.markupMap = builder.markupMap == null ? null : Collections.unmodifiableMap(new HashMap(builder.markupMap));
            }

            public Ansi.Text commandText(String command) {
                return this.apply(command, this.commandStyles);
            }

            public Ansi.Text optionText(String option) {
                return this.apply(option, this.optionStyles);
            }

            public Ansi.Text parameterText(String parameter) {
                return this.apply(parameter, this.parameterStyles);
            }

            public Ansi.Text optionParamText(String optionParam) {
                return this.apply(optionParam, this.optionParamStyles);
            }

            public Ansi.Text errorText(String error) {
                return this.apply(error, this.errorStyles);
            }

            public Ansi.Text stackTraceText(String stackTrace) {
                return this.apply(stackTrace, this.stackTraceStyles);
            }

            public Ansi.Text stackTraceText(Throwable t2) {
                StringWriter stringWriter = new StringWriter();
                t2.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                return this.stackTraceText(stringWriter.toString());
            }

            public String richStackTraceString(Throwable t2) {
                return CommandLine.throwableToColorString(t2, this);
            }

            public Ansi ansi() {
                return this.ansi;
            }

            public List<Ansi.IStyle> commandStyles() {
                return this.commandStyles;
            }

            public List<Ansi.IStyle> optionStyles() {
                return this.optionStyles;
            }

            public List<Ansi.IStyle> parameterStyles() {
                return this.parameterStyles;
            }

            public List<Ansi.IStyle> optionParamStyles() {
                return this.optionParamStyles;
            }

            public List<Ansi.IStyle> errorStyles() {
                return this.errorStyles;
            }

            public List<Ansi.IStyle> stackTraceStyles() {
                return this.stackTraceStyles;
            }

            public Map<String, Ansi.IStyle> customMarkupMap() {
                if (this.markupMap == null) {
                    return Collections.emptyMap();
                }
                return this.markupMap;
            }

            public Ansi.IStyle[] parse(String commaSeparatedCodes) {
                if (this.markupMap == null) {
                    return Ansi.Style.parse(commaSeparatedCodes);
                }
                String[] stringArray = commaSeparatedCodes.split(",");
                ArrayList<Ansi.IStyle> arrayList = new ArrayList<Ansi.IStyle>();
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = stringArray2[i2];
                    Ansi.IStyle iStyle = this.markupMap.containsKey(string = string.toLowerCase(Locale.ENGLISH).replace("(", "_").replace(")", "")) ? this.markupMap.get(string) : this.markupMap.get("fg_" + string);
                    if (iStyle == null) continue;
                    arrayList.add(iStyle);
                }
                return arrayList.toArray(new Ansi.IStyle[0]);
            }

            public Ansi.IStyle resetStyle() {
                if (this.markupMap == null) {
                    return Ansi.Style.reset;
                }
                if (this.markupMap.containsKey("reset")) {
                    return this.markupMap.get("reset");
                }
                return EMPTY_STYLE;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof ColorScheme)) {
                    return false;
                }
                ColorScheme colorScheme = (ColorScheme)obj;
                if (this.ansi.equals((Object)colorScheme.ansi) && this.commandStyles.equals(colorScheme.commandStyles) && this.optionStyles.equals(colorScheme.optionStyles) && this.parameterStyles.equals(colorScheme.parameterStyles) && this.optionParamStyles.equals(colorScheme.optionParamStyles) && this.errorStyles.equals(colorScheme.errorStyles) && this.stackTraceStyles.equals(colorScheme.stackTraceStyles) && this.markupMap == null) {
                    return colorScheme.markupMap == null;
                }
                return this.markupMap.equals(colorScheme.markupMap);
            }

            public int hashCode() {
                int n2 = 629 + this.ansi.hashCode();
                n2 = n2 * 37 + this.commandStyles.hashCode();
                n2 = n2 * 37 + this.optionStyles.hashCode();
                n2 = n2 * 37 + this.parameterStyles.hashCode();
                n2 = n2 * 37 + this.optionParamStyles.hashCode();
                n2 = n2 * 37 + this.errorStyles.hashCode();
                n2 = n2 * 37 + this.stackTraceStyles.hashCode();
                n2 = n2 * 37 + (this.markupMap == null ? 0 : this.markupMap.hashCode());
                return n2;
            }

            public String toString() {
                return "ColorScheme[ansi=" + (Object)((Object)this.ansi) + ", commands=" + this.commandStyles + ", optionStyles=" + this.optionStyles + ", parameterStyles=" + this.parameterStyles + ", optionParamStyles=" + this.optionParamStyles + ", errorStyles=" + this.errorStyles + ", stackTraceStyles=" + this.stackTraceStyles + ", customMarkupMap=" + this.markupMap + "]";
            }

            public Ansi.Text apply(String plainText, List<Ansi.IStyle> styles) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                Ansi.Text text = ansi.new Ansi.Text(plainText.length());
                text.colorScheme = this;
                if (plainText.length() == 0) {
                    return text;
                }
                List<Ansi.IStyle> list = styles;
                Object[] objectArray = list.toArray(new Ansi.IStyle[list.size()]);
                text.sections.add(new Ansi.StyledSection(0, plainText.length(), Ansi.Style.on((Ansi.IStyle[])objectArray), Ansi.Style.off((Ansi.IStyle[])CommandLine.reverseArray(objectArray)) + this.resetStyle().off()));
                text.plain.append(plainText);
                Ansi.Text text2 = text;
                text2.length = text2.plain.length();
                return text;
            }

            public Ansi.Text text(String stringWithMarkup) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                return ansi.new Ansi.Text(stringWithMarkup, this);
            }

            public String string(String stringWithMarkup) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                return ansi.new Ansi.Text(stringWithMarkup, this).toString();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder {
                private final List<Ansi.IStyle> commandStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> optionStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> parameterStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> optionParamStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> errorStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> stackTraceStyles = new ArrayList<Ansi.IStyle>();
                private Ansi ansi = Ansi.AUTO;
                private Map<String, Ansi.IStyle> markupMap;

                public Builder() {
                }

                public Builder(Ansi ansi) {
                    this.ansi = Assert.notNull(ansi, "ansi");
                }

                public Builder(ColorScheme existing) {
                    Assert.notNull(existing, "colorScheme");
                    this.ansi = Assert.notNull(existing.ansi(), "ansi");
                    this.commandStyles.addAll(existing.commandStyles());
                    this.optionStyles.addAll(existing.optionStyles());
                    this.parameterStyles.addAll(existing.parameterStyles());
                    this.optionParamStyles.addAll(existing.optionParamStyles());
                    this.errorStyles.addAll(existing.errorStyles());
                    this.stackTraceStyles.addAll(existing.stackTraceStyles());
                    if (existing.markupMap != null) {
                        this.markupMap = new HashMap<String, Ansi.IStyle>(existing.markupMap);
                    }
                }

                public Ansi ansi() {
                    return this.ansi;
                }

                public Builder ansi(Ansi ansi) {
                    this.ansi = Assert.notNull(ansi, "ansi");
                    return this;
                }

                public List<Ansi.IStyle> commandStyles() {
                    return this.commandStyles;
                }

                public List<Ansi.IStyle> optionStyles() {
                    return this.optionStyles;
                }

                public List<Ansi.IStyle> parameterStyles() {
                    return this.parameterStyles;
                }

                public List<Ansi.IStyle> optionParamStyles() {
                    return this.optionParamStyles;
                }

                public List<Ansi.IStyle> errorStyles() {
                    return this.errorStyles;
                }

                public List<Ansi.IStyle> stackTraceStyles() {
                    return this.stackTraceStyles;
                }

                public Map<String, Ansi.IStyle> customMarkupMap() {
                    return this.markupMap;
                }

                public Builder customMarkupMap(Map<String, Ansi.IStyle> newValue) {
                    this.markupMap = newValue;
                    return this;
                }

                public Builder commands(Ansi.IStyle ... styles) {
                    Builder builder = this;
                    return builder.addAll(builder.commandStyles, styles);
                }

                public Builder options(Ansi.IStyle ... styles) {
                    Builder builder = this;
                    return builder.addAll(builder.optionStyles, styles);
                }

                public Builder parameters(Ansi.IStyle ... styles) {
                    Builder builder = this;
                    return builder.addAll(builder.parameterStyles, styles);
                }

                public Builder optionParams(Ansi.IStyle ... styles) {
                    Builder builder = this;
                    return builder.addAll(builder.optionParamStyles, styles);
                }

                public Builder errors(Ansi.IStyle ... styles) {
                    Builder builder = this;
                    return builder.addAll(builder.errorStyles, styles);
                }

                public Builder stackTraces(Ansi.IStyle ... styles) {
                    Builder builder = this;
                    return builder.addAll(builder.stackTraceStyles, styles);
                }

                public Builder applySystemProperties() {
                    Builder builder = this;
                    builder.replace(builder.commandStyles, System.getProperty("picocli.color.commands"));
                    Builder builder2 = this;
                    builder2.replace(builder2.optionStyles, System.getProperty("picocli.color.options"));
                    Builder builder3 = this;
                    builder3.replace(builder3.parameterStyles, System.getProperty("picocli.color.parameters"));
                    Builder builder4 = this;
                    builder4.replace(builder4.optionParamStyles, System.getProperty("picocli.color.optionParams"));
                    Builder builder5 = this;
                    builder5.replace(builder5.errorStyles, System.getProperty("picocli.color.errors"));
                    Builder builder6 = this;
                    builder6.replace(builder6.stackTraceStyles, System.getProperty("picocli.color.stackTraces"));
                    return this;
                }

                private void replace(List<Ansi.IStyle> styles, String property) {
                    if (property != null) {
                        styles.clear();
                        this.addAll(styles, Ansi.Style.parse(property));
                    }
                }

                private Builder addAll(List<Ansi.IStyle> styles, Ansi.IStyle ... add) {
                    styles.addAll(Arrays.asList(add));
                    return this;
                }

                public ColorScheme build() {
                    return new ColorScheme(this);
                }
            }
        }

        public static class Column {
            public final int width;
            public int indent;
            public final Overflow overflow;

            public Column(int width, int indent, Overflow overflow) {
                this.width = width;
                this.indent = indent;
                this.overflow = Assert.notNull(overflow, "overflow");
            }

            public boolean equals(Object obj) {
                return obj instanceof Column && ((Column)obj).width == this.width && ((Column)obj).indent == this.indent && ((Column)obj).overflow == this.overflow;
            }

            public int hashCode() {
                return 17 * this.width + 37 * this.indent + 37 * this.overflow.hashCode();
            }

            public String toString() {
                return String.format("Column[width=%d, indent=%d, overflow=%s]", new Object[]{this.width, this.indent, this.overflow});
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Overflow {
                TRUNCATE,
                SPAN,
                WRAP;

            }
        }

        public static class TextTable {
            private static final int OPTION_SEPARATOR_COLUMN = 2;
            private static final int LONG_OPTION_COLUMN = 3;
            private final Column[] columns;
            protected final List<Ansi.Text> columnValues = new ArrayList<Ansi.Text>();
            public int indentWrappedLines = 2;
            private final ColorScheme colorScheme;
            private final int tableWidth;
            private boolean adjustLineBreaksForWideCJKCharacters = true;

            @Deprecated
            public static TextTable forDefaultColumns(Ansi ansi, int usageHelpWidth) {
                return TextTable.forDefaultColumns(Help.defaultColorScheme(ansi), 24, usageHelpWidth);
            }

            @Deprecated
            public static TextTable forDefaultColumns(Ansi ansi, int longOptionsColumnWidth, int usageHelpWidth) {
                return TextTable.forDefaultColumns(Help.defaultColorScheme(ansi), longOptionsColumnWidth, usageHelpWidth);
            }

            public static TextTable forDefaultColumns(ColorScheme colorScheme, int longOptionsColumnWidth, int usageHelpWidth) {
                int n2 = usageHelpWidth - 5 - longOptionsColumnWidth;
                return TextTable.forColumns(colorScheme, new Column(2, 0, Column.Overflow.TRUNCATE), new Column(2, 0, Column.Overflow.SPAN), new Column(1, 0, Column.Overflow.TRUNCATE), new Column(longOptionsColumnWidth, 1, Column.Overflow.SPAN), new Column(n2, 1, Column.Overflow.WRAP));
            }

            @Deprecated
            public static TextTable forColumnWidths(Ansi ansi, int ... columnWidths) {
                return TextTable.forColumnWidths(Help.defaultColorScheme(ansi), columnWidths);
            }

            public static TextTable forColumnWidths(ColorScheme colorScheme, int ... columnWidths) {
                Column[] columnArray = new Column[columnWidths.length];
                for (int i2 = 0; i2 < columnWidths.length; ++i2) {
                    columnArray[i2] = new Column(columnWidths[i2], 0, i2 == columnWidths.length - 1 ? Column.Overflow.WRAP : Column.Overflow.SPAN);
                }
                return new TextTable(colorScheme, columnArray);
            }

            @Deprecated
            public static TextTable forColumns(Ansi ansi, Column ... columns) {
                return new TextTable(ansi, columns);
            }

            public static TextTable forColumns(ColorScheme colorScheme, Column ... columns) {
                return new TextTable(colorScheme, columns);
            }

            @Deprecated
            protected TextTable(Ansi ansi, Column[] columns) {
                this(Help.defaultColorScheme(ansi), columns);
            }

            protected TextTable(ColorScheme colorScheme, Column[] columns) {
                this.colorScheme = Assert.notNull(colorScheme, "ansi");
                this.columns = (Column[])Assert.notNull(columns, "columns").clone();
                if (columns.length == 0) {
                    throw new IllegalArgumentException("At least one column is required");
                }
                int n2 = 0;
                Column[] columnArray = columns;
                int n3 = columns.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Column column = columnArray[i2];
                    n2 += column.width;
                }
                this.tableWidth = n2;
            }

            public boolean isAdjustLineBreaksForWideCJKCharacters() {
                return this.adjustLineBreaksForWideCJKCharacters;
            }

            public TextTable setAdjustLineBreaksForWideCJKCharacters(boolean adjustLineBreaksForWideCJKCharacters) {
                this.adjustLineBreaksForWideCJKCharacters = adjustLineBreaksForWideCJKCharacters;
                return this;
            }

            public Column[] columns() {
                return (Column[])this.columns.clone();
            }

            public Ansi.Text textAt(int row, int col) {
                return this.columnValues.get(col + row * this.columns.length);
            }

            @Deprecated
            public Ansi.Text cellAt(int row, int col) {
                return this.textAt(row, col);
            }

            public int rowCount() {
                return this.columnValues.size() / this.columns.length;
            }

            public void addEmptyRow() {
                Column[] columnArray = this.columns;
                int n2 = this.columns.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Column column = columnArray[i2];
                    Ansi ansi = this.colorScheme.ansi();
                    ((Object)((Object)ansi)).getClass();
                    this.columnValues.add(ansi.new Ansi.Text(column.width, this.colorScheme));
                }
            }

            public void addRowValues(String ... values) {
                int n2 = values.length;
                Ansi.Text[][] textArrayArray = new Ansi.Text[n2][];
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Ansi.Text[] textArray;
                    if (values[i2] == null) {
                        Ansi.Text[] textArray2 = new Ansi.Text[1];
                        textArray = textArray2;
                        textArray2[0] = Ansi.EMPTY_TEXT;
                    } else {
                        textArray = this.colorScheme.text(values[i2]).splitLines();
                    }
                    textArrayArray[i2] = textArray;
                    n3 = Math.max(n3, textArrayArray[i2].length);
                }
                Object[] objectArray = new Ansi.Text[n2];
                for (int i3 = 0; i3 < n3; ++i3) {
                    Arrays.fill(objectArray, Ansi.EMPTY_TEXT);
                    for (int i4 = 0; i4 < n2; ++i4) {
                        if (i3 >= textArrayArray[i4].length) continue;
                        objectArray[i4] = textArrayArray[i4][i3];
                    }
                    this.addRowValues((Ansi.Text[])objectArray);
                }
            }

            public void addRowValues(Ansi.Text ... values) {
                if (values.length > this.columns.length) {
                    throw new IllegalArgumentException(values.length + " values don't fit in " + this.columns.length + " columns");
                }
                this.addEmptyRow();
                int n2 = this.unindent(values);
                for (int i2 = 0; i2 < values.length; ++i2) {
                    int n3 = this.rowCount() - 1;
                    Cell cell = this.putValue(n3, i2, values[i2]);
                    if (cell.row == n3 && cell.column == i2 || i2 == values.length - 1) continue;
                    this.addEmptyRow();
                }
                this.reindent(n2);
            }

            private int unindent(Ansi.Text[] values) {
                if (this.columns.length <= 3) {
                    return 0;
                }
                int n2 = this.columns[3].indent;
                if (Help.DEFAULT_SEPARATOR.equals(values[2].toString())) {
                    this.columns[3].indent = 0;
                }
                return n2;
            }

            private void reindent(int oldIndent) {
                if (this.columns.length <= 3) {
                    return;
                }
                this.columns[3].indent = oldIndent;
            }

            public Cell putValue(int row, int col, Ansi.Text value) {
                if (row > this.rowCount() - 1) {
                    throw new IllegalArgumentException("Cannot write to row " + row + ": rowCount=" + this.rowCount());
                }
                if (value == null || value.plain.length() == 0) {
                    return new Cell(col, row);
                }
                Column column = this.columns[col];
                int n2 = column.indent;
                switch (column.overflow) {
                    case TRUNCATE: {
                        this.copy(value, this.textAt(row, col), n2);
                        return new Cell(col, row);
                    }
                    case SPAN: {
                        int n3 = col;
                        do {
                            boolean bl = col == this.columns.length - 1;
                            int n4 = bl ? this.copy(BreakIterator.getLineInstance(), value, this.textAt(row, col), n2) : this.copy(value, this.textAt(row, col), n2);
                            value = value.substring(n4);
                            n2 = 0;
                            if (value.length > 0) {
                                ++col;
                            }
                            if (value.length <= 0 || col < this.columns.length) continue;
                            this.addEmptyRow();
                            ++row;
                            col = n3;
                            n2 = column.indent + this.indentWrappedLines;
                        } while (value.length > 0);
                        return new Cell(col, row);
                    }
                    case WRAP: {
                        BreakIterator breakIterator = BreakIterator.getLineInstance();
                        do {
                            int n5 = this.copy(breakIterator, value, this.textAt(row, col), n2);
                            value = value.substring(n5);
                            n2 = column.indent + this.indentWrappedLines;
                            if (value.length <= 0) continue;
                            ++row;
                            this.addEmptyRow();
                        } while (value.length > 0);
                        return new Cell(col, row);
                    }
                }
                throw new IllegalStateException(column.overflow.toString());
            }

            private int length(Ansi.Text str) {
                return str.getCJKAdjustedLength();
            }

            private int length(Ansi.Text str, int from, int length) {
                if (!this.adjustLineBreaksForWideCJKCharacters) {
                    return length - from;
                }
                return str.getCJKAdjustedLength(from, length);
            }

            private int copy(BreakIterator line, Ansi.Text text, Ansi.Text columnValue, int offset) {
                line.setText(text.plainString().replace("-", "\u00ff"));
                Count count = new Count();
                int n2 = line.first();
                int n3 = line.next();
                while (n3 != -1) {
                    Ansi.Text text2 = text.substring(n2, n3);
                    if (columnValue.maxLength < offset + count.columnCount + this.length(text2)) break;
                    this.copy(text2, columnValue, offset + count.charCount, count);
                    n2 = n3;
                    n3 = line.next();
                }
                if (count.charCount == 0 && this.length(text) + offset > columnValue.maxLength) {
                    this.copy(text, columnValue, offset, count);
                }
                return count.charCount;
            }

            private int copy(Ansi.Text value, Ansi.Text destination, int offset) {
                Count count = new Count();
                this.copy(value, destination, offset, count);
                return count.charCount;
            }

            private void copy(Ansi.Text value, Ansi.Text destination, int offset, Count count) {
                int n2 = Math.min(value.length, destination.maxLength - offset);
                Ansi.Text text = value;
                text.getStyledChars(text.from, n2, destination, offset);
                Ansi.Text text2 = value;
                count.columnCount += this.length(text2, text2.from, n2);
                count.charCount += n2;
            }

            public StringBuilder toString(StringBuilder text) {
                int n2 = this.columns.length;
                StringBuilder stringBuilder = new StringBuilder(this.tableWidth);
                for (int i2 = 0; i2 < this.columnValues.size(); ++i2) {
                    int n3;
                    Ansi.Text text2 = this.columnValues.get(i2);
                    stringBuilder.append(text2.toString());
                    stringBuilder.append(new String(Help.spaces(this.columns[i2 % n2].width - text2.length)));
                    if (i2 % n2 != n2 - 1) continue;
                    for (n3 = stringBuilder.length() - 1; n3 >= 0 && stringBuilder.charAt(n3) == ' '; --n3) {
                    }
                    stringBuilder.setLength(n3 + 1);
                    text.append(stringBuilder.toString()).append(System.getProperty("line.separator"));
                    stringBuilder.setLength(0);
                }
                return text;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            static class Count {
                int charCount;
                int columnCount;

                Count() {
                }
            }

            public static class Cell {
                public final int column;
                public final int row;

                public Cell(int column, int row) {
                    this.column = column;
                    this.row = row;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SortByOrder<T extends Model.IOrdered>
        implements Comparator<T> {
            SortByOrder() {
            }

            @Override
            public int compare(T o1, T o2) {
                return Integer.signum(o1.order() - o2.order());
            }
        }

        static class SortByOptionArityAndNameAlphabetically
        extends SortByShortestOptionNameAlphabetically {
            SortByOptionArityAndNameAlphabetically() {
            }

            public int compare(Model.OptionSpec o1, Model.OptionSpec o2) {
                Range range = o1.arity();
                Range range2 = o2.arity();
                int n2 = range.max - range2.max;
                if (n2 == 0) {
                    n2 = range.min - range2.min;
                }
                if (n2 == 0) {
                    if (o1.isMultiValue() && !o2.isMultiValue()) {
                        n2 = 1;
                    }
                    if (!o1.isMultiValue() && o2.isMultiValue()) {
                        n2 = -1;
                    }
                }
                if (n2 == 0) {
                    return super.compare(o1, o2);
                }
                return n2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SortByShortestOptionNameAlphabetically
        implements Comparator<Model.OptionSpec> {
            SortByShortestOptionNameAlphabetically() {
            }

            @Override
            public int compare(Model.OptionSpec o1, Model.OptionSpec o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String[] stringArray = ShortestFirst.sort(o1.names());
                String[] stringArray2 = ShortestFirst.sort(o2.names());
                String string = Model.CommandSpec.stripPrefix(stringArray[0]);
                String string2 = Model.CommandSpec.stripPrefix(stringArray2[0]);
                int n2 = string.toUpperCase().compareTo(string2.toUpperCase());
                int n3 = n2 = n2 == 0 ? -string.compareTo(string2) : n2;
                if (o1.help() == o2.help()) {
                    return n2;
                }
                if (o2.help()) {
                    return -1;
                }
                return 1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortestFirst
        implements Comparator<String> {
            ShortestFirst() {
            }

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }

            public static String[] sort(String[] names) {
                Arrays.sort(names, new ShortestFirst());
                return names;
            }

            public static String[] longestFirst(String[] names) {
                Arrays.sort(names, Collections.reverseOrder(new ShortestFirst()));
                return names;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Layout {
            protected final ColorScheme colorScheme;
            protected final TextTable table;
            protected IOptionRenderer optionRenderer;
            protected IParameterRenderer parameterRenderer;

            public Layout(ColorScheme colorScheme, int tableWidth) {
                ColorScheme colorScheme2 = colorScheme;
                this(colorScheme2, TextTable.forDefaultColumns(colorScheme2, 24, tableWidth));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable) {
                this(colorScheme, textTable, new DefaultOptionRenderer(false, " "), new DefaultParameterRenderer(false, " "));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable, IOptionRenderer optionRenderer, IParameterRenderer parameterRenderer) {
                this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
                this.table = Assert.notNull(textTable, "textTable");
                this.optionRenderer = Assert.notNull(optionRenderer, "optionRenderer");
                this.parameterRenderer = Assert.notNull(parameterRenderer, "parameterRenderer");
            }

            public void layout(Model.ArgSpec argSpec, Ansi.Text[][] cellValues) {
                Ansi.Text[][] textArray = cellValues;
                int n2 = cellValues.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Ansi.Text[] textArray2 = textArray[i2];
                    this.table.addRowValues(textArray2);
                }
            }

            public void addOptions(List<Model.OptionSpec> options, IParamLabelRenderer paramLabelRenderer) {
                for (Model.OptionSpec optionSpec : options) {
                    if (optionSpec.hidden()) continue;
                    this.addOption(optionSpec, paramLabelRenderer);
                }
            }

            public void addAllOptions(List<Model.OptionSpec> options, IParamLabelRenderer paramLabelRenderer) {
                for (Model.OptionSpec optionSpec : options) {
                    this.addOption(optionSpec, paramLabelRenderer);
                }
            }

            public void addOption(Model.OptionSpec option, IParamLabelRenderer paramLabelRenderer) {
                Ansi.Text[][] textArray = this.optionRenderer.render(option, paramLabelRenderer, this.colorScheme);
                this.layout(option, textArray);
            }

            public void addPositionalParameters(List<Model.PositionalParamSpec> params, IParamLabelRenderer paramLabelRenderer) {
                for (Model.PositionalParamSpec positionalParamSpec : params) {
                    if (positionalParamSpec.hidden()) continue;
                    this.addPositionalParameter(positionalParamSpec, paramLabelRenderer);
                }
            }

            public void addAllPositionalParameters(List<Model.PositionalParamSpec> params, IParamLabelRenderer paramLabelRenderer) {
                for (Model.PositionalParamSpec positionalParamSpec : params) {
                    this.addPositionalParameter(positionalParamSpec, paramLabelRenderer);
                }
            }

            public void addPositionalParameter(Model.PositionalParamSpec param, IParamLabelRenderer paramLabelRenderer) {
                Ansi.Text[][] textArray = this.parameterRenderer.render(param, paramLabelRenderer, this.colorScheme);
                this.layout(param, textArray);
            }

            public String toString() {
                return this.table.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DefaultParamLabelRenderer
        implements IParamLabelRenderer {
            private final Model.CommandSpec commandSpec;

            public DefaultParamLabelRenderer(Model.CommandSpec commandSpec) {
                this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            }

            @Override
            public String separator() {
                return this.commandSpec.parser().separator();
            }

            @Override
            public Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> styles) {
                String string;
                int n2;
                Ansi.Text text;
                ColorScheme colorScheme;
                Range range = argSpec.isOption() ? argSpec.arity() : ((Model.PositionalParamSpec)argSpec).capacity();
                ColorScheme colorScheme2 = colorScheme = this.commandSpec.commandLine() == null ? Help.defaultColorScheme(ansi) : this.commandSpec.commandLine().getColorScheme();
                if (range.max == 0) {
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    return ansi2.new Ansi.Text("", colorScheme);
                }
                if (argSpec.hideParamSyntax()) {
                    return colorScheme.apply((argSpec.isOption() ? this.separator() : "") + argSpec.paramLabel(), styles);
                }
                String string2 = argSpec.splitRegex();
                if (!CommandLine.empty(string2)) {
                    string2 = CommandLine.empty(argSpec.splitRegexSynopsisLabel()) ? string2 : argSpec.splitRegexSynopsisLabel();
                }
                String string3 = CommandLine.empty(string2) ? " " : string2;
                String string4 = CommandLine.empty(string2) ? " [" : "[" + string2;
                boolean bl = !CommandLine.empty(string2) && !this.commandSpec.parser().limitSplit();
                boolean bl2 = !CommandLine.empty(string2) && this.commandSpec.parser().limitSplit();
                Ansi.Text text2 = text = colorScheme.apply(argSpec.paramLabel(), styles);
                int n3 = 1;
                if (bl) {
                    text2 = text.concat("[" + string2).concat(text).concat("...]");
                    ++n3;
                    string3 = " ";
                    string4 = " [";
                }
                Ansi.Text text3 = text2;
                for (int i2 = 1; i2 < range.min; ++i2) {
                    text3 = text3.concat(string3).concat(text2);
                    int n4 = n3;
                    n3 = n4 + n4;
                }
                if (!range.isVariable) {
                    for (n2 = i2; n2 < range.max; ++n2) {
                        text3 = text3.concat(string4).concat(text);
                        ++n3;
                    }
                    for (n2 = i2; n2 < range.max; ++n2) {
                        text3 = text3.concat("]");
                    }
                }
                int n5 = n2 = range.isVariable || bl2 && n3 == 1 ? 1 : 0;
                if (bl2 && n2 != 0 && n3 == 1) {
                    text3 = text3.concat(string4).concat(text2).concat("]");
                }
                if (n2 != 0) {
                    if (!argSpec.arity().isVariable && argSpec.arity().min > 1) {
                        Ansi ansi3 = ansi;
                        ((Object)((Object)ansi3)).getClass();
                        text3 = ansi3.new Ansi.Text("(", colorScheme).concat(text3).concat(")");
                    }
                    text3 = text3.concat("...");
                }
                String string5 = string = argSpec.isOption() ? this.separator() : "";
                if (range.min == 0) {
                    String string6 = CommandLine.empty(string.trim()) ? string + "[" : "[" + string;
                    Ansi ansi4 = ansi;
                    ((Object)((Object)ansi4)).getClass();
                    text3 = ansi4.new Ansi.Text(string6, colorScheme).concat(text3).concat("]");
                } else {
                    Ansi ansi5 = ansi;
                    ((Object)((Object)ansi5)).getClass();
                    text3 = ansi5.new Ansi.Text(string, colorScheme).concat(text3);
                }
                return text3;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IParamLabelRenderer {
            public Ansi.Text renderParameterLabel(Model.ArgSpec var1, Ansi var2, List<Ansi.IStyle> var3);

            public String separator();
        }

        static class DefaultParameterRenderer
        implements IParameterRenderer {
            private final String requiredMarker;
            private final boolean showDefaultValues;

            public DefaultParameterRenderer(boolean showDefaultValues, String requiredMarker) {
                this.showDefaultValues = showDefaultValues;
                this.requiredMarker = Assert.notNull(requiredMarker, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec param, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                int n2;
                Ansi.Text text = paramLabelRenderer.renderParameterLabel(param, scheme.ansi(), scheme.parameterStyles);
                Ansi.Text text2 = scheme.parameterText(param.arity().min > 0 ? this.requiredMarker : "");
                Ansi.Text text3 = Ansi.EMPTY_TEXT;
                boolean[] blArray = new boolean[]{param.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> arrayList = new ArrayList<Ansi.Text[]>();
                String[] stringArray = param.description();
                Ansi.Text[] textArray = Help.createDescriptionFirstLines(scheme, param, stringArray, blArray);
                arrayList.add(new Ansi.Text[]{text2, text3, text3, text, textArray[0]});
                for (n2 = 1; n2 < textArray.length; ++n2) {
                    arrayList.add(new Ansi.Text[]{text3, text3, text3, text3, textArray[n2]});
                }
                for (n2 = 1; n2 < stringArray.length; ++n2) {
                    Ansi.Text[] textArray2;
                    Ansi ansi = scheme.ansi();
                    ((Object)((Object)ansi)).getClass();
                    Ansi.Text[] textArray3 = textArray2 = ansi.new Ansi.Text(stringArray[n2], scheme).splitLines();
                    int n3 = textArray2.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Ansi.Text text4 = textArray3[i2];
                        arrayList.add(new Ansi.Text[]{text3, text3, text3, text3, text4});
                    }
                }
                if (blArray[0]) {
                    Help.addTrailingDefaultLine(arrayList, param, scheme);
                }
                ArrayList<Ansi.Text[]> arrayList2 = arrayList;
                return (Ansi.Text[][])arrayList2.toArray((T[])new Ansi.Text[arrayList2.size()][]);
            }
        }

        public static interface IParameterRenderer {
            public Ansi.Text[][] render(Model.PositionalParamSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        static class MinimalParameterRenderer
        implements IParameterRenderer {
            MinimalParameterRenderer() {
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec param, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = parameterLabelRenderer.renderParameterLabel(param, scheme.ansi(), scheme.parameterStyles);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(param.description().length == 0 ? "" : param.description()[0], scheme);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class MinimalOptionRenderer
        implements IOptionRenderer {
            MinimalOptionRenderer() {
            }

            public Ansi.Text[][] render(Model.OptionSpec option, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text text = option.negatable() ? scheme.optionText(option.commandSpec.negatableOptionTransformer().makeSynopsis(option.names()[0], option.commandSpec)) : scheme.optionText(option.names()[0]);
                Ansi.Text text2 = parameterLabelRenderer.renderParameterLabel(option, scheme.ansi(), scheme.optionParamStyles);
                text = text.concat(text2);
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = text;
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(option.description().length == 0 ? "" : option.description()[0], scheme);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class DefaultOptionRenderer
        implements IOptionRenderer {
            private final String requiredMarker;
            private final boolean showDefaultValues;
            private String sep;

            public DefaultOptionRenderer(boolean showDefaultValues, String requiredMarker) {
                this.showDefaultValues = showDefaultValues;
                this.requiredMarker = Assert.notNull(requiredMarker, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.OptionSpec option, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                Object object;
                String[] stringArray = ShortestFirst.sort(option.names());
                int n2 = stringArray[0].length() == 2 ? 1 : 0;
                String string = n2 > 0 ? stringArray[0] : "";
                String string2 = this.sep = n2 > 0 && stringArray.length > 1 ? "," : "";
                if (option.negatable()) {
                    object = option.commandSpec.negatableOptionTransformer();
                    if (n2 > 0) {
                        string = object.makeSynopsis(string, option.commandSpec);
                    }
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        stringArray[i2] = object.makeSynopsis(stringArray[i2], option.commandSpec);
                    }
                }
                object = Help.join(stringArray, n2, stringArray.length - n2, ", ");
                Ansi.Text text = this.createLongOptionText(option, paramLabelRenderer, scheme, (String)object);
                String string3 = option.required() ? this.requiredMarker : "";
                return this.renderDescriptionLines(option, scheme, string3, string, text);
            }

            private Ansi.Text createLongOptionText(Model.OptionSpec option, IParamLabelRenderer renderer, ColorScheme scheme, String longOption) {
                Ansi.Text text = renderer.renderParameterLabel(option, scheme.ansi(), scheme.optionParamStyles);
                if (text.length > 0 && longOption.length() == 0) {
                    this.sep = renderer.separator();
                    int n2 = text.plainString().indexOf(this.sep);
                    Ansi.Text text2 = text.substring(0, n2);
                    text = text2.concat(text.substring(n2 + this.sep.length()));
                }
                Ansi.Text text3 = scheme.optionText(longOption);
                text3 = text3.concat(text);
                return text3;
            }

            private Ansi.Text[][] renderDescriptionLines(Model.OptionSpec option, ColorScheme scheme, String requiredOption, String shortOption, Ansi.Text longOptionText) {
                int n2;
                Ansi.Text text = Ansi.EMPTY_TEXT;
                boolean[] blArray = new boolean[]{option.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> arrayList = new ArrayList<Ansi.Text[]>();
                String[] stringArray = option.description();
                Ansi.Text[] textArray = Help.createDescriptionFirstLines(scheme, option, stringArray, blArray);
                Ansi.Text[] textArray2 = new Ansi.Text[5];
                textArray2[0] = scheme.optionText(requiredOption);
                textArray2[1] = scheme.optionText(shortOption);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[2] = ansi.new Ansi.Text(this.sep, scheme);
                textArray2[3] = longOptionText;
                textArray2[4] = textArray[0];
                arrayList.add(textArray2);
                for (n2 = 1; n2 < textArray.length; ++n2) {
                    arrayList.add(new Ansi.Text[]{text, text, text, text, textArray[n2]});
                }
                for (n2 = 1; n2 < stringArray.length; ++n2) {
                    Ansi.Text[] textArray3;
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    Ansi.Text[] textArray4 = textArray3 = ansi2.new Ansi.Text(stringArray[n2], scheme).splitLines();
                    int n3 = textArray3.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Ansi.Text text2 = textArray4[i2];
                        arrayList.add(new Ansi.Text[]{text, text, text, text, text2});
                    }
                }
                if (blArray[0]) {
                    Help.addTrailingDefaultLine(arrayList, option, scheme);
                }
                ArrayList<Ansi.Text[]> arrayList2 = arrayList;
                return (Ansi.Text[][])arrayList2.toArray((T[])new Ansi.Text[arrayList2.size()][]);
            }
        }

        public static interface IOptionRenderer {
            public Ansi.Text[][] render(Model.OptionSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Visibility {
            ALWAYS,
            NEVER,
            ON_DEMAND;

        }
    }

    public static interface IHelpSectionRenderer {
        public String render(Help var1);
    }

    public static interface IHelpCommandInitializable2 {
        public void init(CommandLine var1, Help.ColorScheme var2, PrintWriter var3, PrintWriter var4);
    }

    @Deprecated
    public static interface IHelpCommandInitializable {
        @Deprecated
        public void init(CommandLine var1, Help.Ansi var2, PrintStream var3, PrintStream var4);
    }

    @Command(name="help", header={"Displays help information about the specified command"}, synopsisHeading="%nUsage: ", helpCommand=true, description={"%nWhen no COMMAND is given, the usage help for the main command is displayed.", "If a COMMAND is specified, the help for that command is shown.%n"})
    public static final class HelpCommand
    implements Runnable,
    IHelpCommandInitializable,
    IHelpCommandInitializable2 {
        @Option(names={"-h", "--help"}, usageHelp=true, descriptionKey="helpCommand.help", description={"Show usage help for the help command and exit."})
        private boolean helpRequested;
        @Parameters(paramLabel="COMMAND", descriptionKey="helpCommand.command", description={"The COMMAND to display the usage help message for."})
        private String[] commands = new String[0];
        private CommandLine self;
        private PrintStream out;
        private PrintStream err;
        private PrintWriter outWriter;
        private PrintWriter errWriter;
        private Help.Ansi ansi;
        private Help.ColorScheme colorScheme;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void run() {
            Help.ColorScheme colorScheme;
            CommandLine commandLine;
            if (this.self == null) {
                return;
            }
            CommandLine commandLine2 = commandLine = this.self.getParent();
            if (commandLine2 == null) {
                return;
            }
            Help.ColorScheme colorScheme2 = colorScheme = this.colorScheme != null ? this.colorScheme : Help.defaultColorScheme(this.ansi);
            if (this.commands.length > 0) {
                CommandLine commandLine3 = commandLine.getSubcommands().get(this.commands[0]);
                if (commandLine3 == null) throw new ParameterException(commandLine, "Unknown subcommand '" + this.commands[0] + "'.", null, this.commands[0]);
                if (this.outWriter != null) {
                    commandLine3.usage(this.outWriter, colorScheme);
                    return;
                } else {
                    commandLine3.usage(this.out, colorScheme);
                }
                return;
            } else {
                if (this.outWriter != null) {
                    commandLine.usage(this.outWriter, colorScheme);
                    return;
                }
                commandLine.usage(this.out, colorScheme);
            }
        }

        @Deprecated
        public final void init(CommandLine helpCommandLine, Help.Ansi ansi, PrintStream out, PrintStream err) {
            this.self = Assert.notNull(helpCommandLine, "helpCommandLine");
            this.ansi = Assert.notNull(ansi, "ansi");
            this.out = Assert.notNull(out, "out");
            this.err = Assert.notNull(err, "err");
        }

        public final void init(CommandLine helpCommandLine, Help.ColorScheme colorScheme, PrintWriter out, PrintWriter err) {
            this.self = Assert.notNull(helpCommandLine, "helpCommandLine");
            this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
            this.outWriter = Assert.notNull(out, "outWriter");
            this.errWriter = Assert.notNull(err, "errWriter");
        }
    }

    static class AutoHelpMixin {
        private static final String KEY = "mixinStandardHelpOptions";
        @Option(names={"${picocli.help.name.0:--h}", "${picocli.help.name.1:---help}"}, usageHelp=true, descriptionKey="mixinStandardHelpOptions.help", description={"Show this help message and exit."})
        private boolean helpRequested;
        @Option(names={"${picocli.version.name.0:--V}", "${picocli.version.name.1:---version}"}, versionHelp=true, descriptionKey="mixinStandardHelpOptions.version", description={"Print version information and exit."})
        private boolean versionRequested;

        AutoHelpMixin() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuiltIn {
        static Set<String> traced = new HashSet<String>();

        private static TypeConversionException fail(String value, Class<?> c2) {
            return BuiltIn.fail(value, c2, "'%s' is not a %s");
        }

        private static TypeConversionException fail(String value, Class<?> c2, String template) {
            return new TypeConversionException(String.format(template, value, c2.getSimpleName()));
        }

        static void handle(Exception e2, String fqcn, Tracer tracer) {
            if (!traced.contains(fqcn)) {
                tracer.debug("Could not register converter for %s: %s%n", fqcn, e2.toString());
            }
            traced.add(fqcn);
        }

        static boolean excluded(String fqcn, Tracer tracer) {
            String[] stringArray;
            String[] stringArray2 = stringArray = System.getProperty("picocli.converters.excludes", "").split(",");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                if (!fqcn.matches(string)) continue;
                tracer.debug("BuiltIn type converter for %s is not loaded: (picocli.converters.excludes=%s)%n", fqcn, System.getProperty("picocli.converters.excludes"));
                return true;
            }
            return false;
        }

        private BuiltIn() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ReflectionConverter
        implements ITypeConverter<Object> {
            private final Method method;
            private final Class<?>[] paramTypes;

            public ReflectionConverter(Method method, Class<?> ... paramTypes) {
                this.method = Assert.notNull(method, "method");
                this.paramTypes = Assert.notNull(paramTypes, "paramTypes");
            }

            @Override
            public Object convert(String s2) {
                try {
                    if (this.paramTypes.length > 1) {
                        return this.method.invoke(null, s2, new String[0]);
                    }
                    return this.method.invoke(null, s2);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new TypeConversionException(String.format("cannot convert '%s' to %s (%s)", s2, this.method.getReturnType(), invocationTargetException.getTargetException()));
                }
                catch (Exception exception) {
                    throw new TypeConversionException(String.format("Internal error converting '%s' to %s (%s)", s2, this.method.getReturnType(), exception));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class NetworkInterfaceConverter
        implements ITypeConverter<NetworkInterface> {
            NetworkInterfaceConverter() {
            }

            @Override
            public NetworkInterface convert(String s2) throws Exception {
                try {
                    InetAddress inetAddress = new InetAddressConverter().convert(s2);
                    return NetworkInterface.getByInetAddress(inetAddress);
                }
                catch (Exception exception) {
                    try {
                        return NetworkInterface.getByName(s2);
                    }
                    catch (Exception exception2) {
                        throw new TypeConversionException("'" + s2 + "' is not an InetAddress or NetworkInterface name");
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ClassConverter
        implements ITypeConverter<Class<?>> {
            ClassConverter() {
            }

            @Override
            public Class<?> convert(String s2) throws Exception {
                return Class.forName(s2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteOrderConverter
        implements ITypeConverter<ByteOrder> {
            ByteOrderConverter() {
            }

            @Override
            public ByteOrder convert(String s2) throws Exception {
                if (s2.equalsIgnoreCase(ByteOrder.BIG_ENDIAN.toString())) {
                    return ByteOrder.BIG_ENDIAN;
                }
                if (s2.equalsIgnoreCase(ByteOrder.LITTLE_ENDIAN.toString())) {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                throw new TypeConversionException("'" + s2 + "' is not a valid ByteOrder");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TimeZoneConverter
        implements ITypeConverter<TimeZone> {
            TimeZoneConverter() {
            }

            @Override
            public TimeZone convert(String s2) throws Exception {
                return TimeZone.getTimeZone(s2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CurrencyConverter
        implements ITypeConverter<Currency> {
            CurrencyConverter() {
            }

            @Override
            public Currency convert(String s2) throws Exception {
                return Currency.getInstance(s2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class UUIDConverter
        implements ITypeConverter<UUID> {
            UUIDConverter() {
            }

            @Override
            public UUID convert(String s2) throws Exception {
                return UUID.fromString(s2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class PatternConverter
        implements ITypeConverter<Pattern> {
            PatternConverter() {
            }

            @Override
            public Pattern convert(String s2) {
                return Pattern.compile(s2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class InetAddressConverter
        implements ITypeConverter<InetAddress> {
            InetAddressConverter() {
            }

            @Override
            public InetAddress convert(String s2) throws Exception {
                return InetAddress.getByName(s2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharsetConverter
        implements ITypeConverter<Charset> {
            CharsetConverter() {
            }

            @Override
            public Charset convert(String s2) {
                return Charset.forName(s2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigIntegerConverter
        implements ITypeConverter<BigInteger> {
            BigIntegerConverter() {
            }

            @Override
            public BigInteger convert(String value) {
                return new BigInteger(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigDecimalConverter
        implements ITypeConverter<BigDecimal> {
            BigDecimalConverter() {
            }

            @Override
            public BigDecimal convert(String value) {
                return new BigDecimal(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601TimeConverter
        implements ITypeConverter<Object> {
            private final Constructor<?> constructor;

            ISO8601TimeConverter(Constructor<?> constructor) throws NoSuchMethodException {
                this.constructor = Assert.notNull(constructor, "time class constructor");
            }

            @Override
            public Object convert(String value) {
                try {
                    if (value.length() <= 5) {
                        return this.createTime(new SimpleDateFormat("HH:mm").parse(value).getTime());
                    }
                    if (value.length() <= 8) {
                        return this.createTime(new SimpleDateFormat("HH:mm:ss").parse(value).getTime());
                    }
                    if (value.length() <= 12) {
                        try {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss.SSS").parse(value).getTime());
                        }
                        catch (ParseException parseException) {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss,SSS").parse(value).getTime());
                        }
                    }
                }
                catch (ParseException parseException) {}
                throw new TypeConversionException("'" + value + "' is not a HH:mm[:ss[.SSS]] time");
            }

            private Object createTime(long epochMillis) {
                try {
                    return this.constructor.newInstance(epochMillis);
                }
                catch (Exception exception) {
                    throw new TypeConversionException("Unable to create new java.sql.Time with long value " + epochMillis + ": " + exception.getMessage());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601DateConverter
        implements ITypeConverter<Date> {
            ISO8601DateConverter() {
            }

            @Override
            public Date convert(String value) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                catch (ParseException parseException) {
                    throw new TypeConversionException("'" + value + "' is not a yyyy-MM-dd date");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URIConverter
        implements ITypeConverter<URI> {
            URIConverter() {
            }

            @Override
            public URI convert(String value) throws URISyntaxException {
                return new URI(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URLConverter
        implements ITypeConverter<URL> {
            URLConverter() {
            }

            @Override
            public URL convert(String value) throws MalformedURLException {
                return new URL(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FileConverter
        implements ITypeConverter<File> {
            FileConverter() {
            }

            @Override
            public File convert(String value) {
                return new File(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DoubleConverter
        implements ITypeConverter<Double> {
            DoubleConverter() {
            }

            @Override
            public Double convert(String value) {
                try {
                    return Double.valueOf(value);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(value, Double.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FloatConverter
        implements ITypeConverter<Float> {
            FloatConverter() {
            }

            @Override
            public Float convert(String value) {
                try {
                    return Float.valueOf(value);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(value, Float.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class LongConverter
        implements ITypeConverter<Long> {
            LongConverter() {
            }

            @Override
            public Long convert(String value) {
                try {
                    return Long.valueOf(value);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(value, Long.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class IntegerConverter
        implements ITypeConverter<Integer> {
            IntegerConverter() {
            }

            @Override
            public Integer convert(String value) {
                try {
                    return Integer.valueOf(value);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(value, Integer.TYPE, "'%s' is not an %s");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortConverter
        implements ITypeConverter<Short> {
            ShortConverter() {
            }

            @Override
            public Short convert(String value) {
                try {
                    return Short.valueOf(value);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(value, Short.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteConverter
        implements ITypeConverter<Byte> {
            ByteConverter() {
            }

            @Override
            public Byte convert(String value) {
                try {
                    return Byte.valueOf(value);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(value, Byte.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharacterConverter
        implements ITypeConverter<Character> {
            CharacterConverter() {
            }

            @Override
            public Character convert(String value) {
                if (value.length() > 1) {
                    throw new TypeConversionException("'" + value + "' is not a single character");
                }
                return Character.valueOf(value.charAt(0));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BooleanConverter
        implements ITypeConverter<Boolean> {
            BooleanConverter() {
            }

            @Override
            public Boolean convert(String value) {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return Boolean.parseBoolean(value);
                }
                throw new TypeConversionException("'" + value + "' is not a boolean");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharSequenceConverter
        implements ITypeConverter<CharSequence> {
            CharSequenceConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringBuilderConverter
        implements ITypeConverter<StringBuilder> {
            StringBuilderConverter() {
            }

            @Override
            public StringBuilder convert(String value) {
                return new StringBuilder(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringConverter
        implements ITypeConverter<String> {
            StringConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharArrayConverter
        implements ITypeConverter<char[]> {
            CharArrayConverter() {
            }

            @Override
            public char[] convert(String value) {
                return value.toCharArray();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PositionalParametersSorter
    implements Comparator<Model.ArgSpec> {
        private static final Range OPTION_INDEX = new Range(0, 0, false, true, "0");

        PositionalParametersSorter() {
        }

        @Override
        public int compare(Model.ArgSpec p1, Model.ArgSpec p2) {
            int n2 = this.index(p1).compareTo(this.index(p2));
            if (n2 == 0) {
                return p1.arity().compareTo(p2.arity());
            }
            return n2;
        }

        private Range index(Model.ArgSpec arg) {
            if (arg.isOption()) {
                return OPTION_INDEX;
            }
            return ((Model.PositionalParamSpec)arg).index();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Interpreter {
        private final Map<Class<?>, ITypeConverter<?>> converterRegistry = new HashMap();
        private boolean isHelpRequested;
        private int position;
        private int interactiveCount;
        private boolean endOfOptions;
        private ParseResult.Builder parseResultBuilder;

        Interpreter() {
            this.registerBuiltInConverters();
        }

        private void registerBuiltInConverters() {
            Exception exception;
            this.converterRegistry.put(Object.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(String.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(StringBuilder.class, new BuiltIn.StringBuilderConverter());
            this.converterRegistry.put(char[].class, new BuiltIn.CharArrayConverter());
            this.converterRegistry.put(CharSequence.class, new BuiltIn.CharSequenceConverter());
            this.converterRegistry.put(Byte.class, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Byte.TYPE, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Boolean.class, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Boolean.TYPE, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Character.class, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Character.TYPE, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Short.class, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Short.TYPE, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Integer.class, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Integer.TYPE, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Long.class, new BuiltIn.LongConverter());
            this.converterRegistry.put(Long.TYPE, new BuiltIn.LongConverter());
            this.converterRegistry.put(Float.class, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Float.TYPE, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Double.class, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(Double.TYPE, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(File.class, new BuiltIn.FileConverter());
            this.converterRegistry.put(URI.class, new BuiltIn.URIConverter());
            this.converterRegistry.put(URL.class, new BuiltIn.URLConverter());
            this.converterRegistry.put(Date.class, new BuiltIn.ISO8601DateConverter());
            this.converterRegistry.put(BigDecimal.class, new BuiltIn.BigDecimalConverter());
            this.converterRegistry.put(BigInteger.class, new BuiltIn.BigIntegerConverter());
            this.converterRegistry.put(Charset.class, new BuiltIn.CharsetConverter());
            this.converterRegistry.put(InetAddress.class, new BuiltIn.InetAddressConverter());
            this.converterRegistry.put(Pattern.class, new BuiltIn.PatternConverter());
            this.converterRegistry.put(UUID.class, new BuiltIn.UUIDConverter());
            this.converterRegistry.put(Currency.class, new BuiltIn.CurrencyConverter());
            this.converterRegistry.put(TimeZone.class, new BuiltIn.TimeZoneConverter());
            this.converterRegistry.put(ByteOrder.class, new BuiltIn.ByteOrderConverter());
            this.converterRegistry.put(Class.class, new BuiltIn.ClassConverter());
            this.converterRegistry.put(NetworkInterface.class, new BuiltIn.NetworkInterfaceConverter());
            if (!this.excl("java.sql.Time")) {
                try {
                    this.reg(Class.forName("java.sql.Time"), new BuiltIn.ISO8601TimeConverter(Class.forName("java.sql.Time").getDeclaredConstructor(Long.TYPE)));
                }
                catch (Exception exception2) {
                    exception = exception2;
                    BuiltIn.handle(exception2, "java.sql.Time", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.sql.Connection")) {
                try {
                    this.reg(Class.forName("java.sql.Connection"), Class.forName("java.sql.DriverManager").getDeclaredMethod("getConnection", String.class), String.class);
                }
                catch (Exception exception3) {
                    exception = exception3;
                    BuiltIn.handle(exception3, "java.sql.Connection", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.sql.Driver")) {
                try {
                    this.reg(Class.forName("java.sql.Driver"), Class.forName("java.sql.DriverManager").getDeclaredMethod("getDriver", String.class), String.class);
                }
                catch (Exception exception4) {
                    exception = exception4;
                    BuiltIn.handle(exception4, "java.sql.DriverManager", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.sql.Timestamp")) {
                try {
                    this.reg(Class.forName("java.sql.Timestamp"), Class.forName("java.sql.Timestamp").getDeclaredMethod("valueOf", String.class), String.class);
                }
                catch (Exception exception5) {
                    exception = exception5;
                    BuiltIn.handle(exception5, "java.sql.Timestamp", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.Duration")) {
                try {
                    this.reg(Class.forName("java.time.Duration"), Class.forName("java.time.Duration").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception6) {
                    exception = exception6;
                    BuiltIn.handle(exception6, "java.time.Duration", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.Instant")) {
                try {
                    this.reg(Class.forName("java.time.Instant"), Class.forName("java.time.Instant").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception7) {
                    exception = exception7;
                    BuiltIn.handle(exception7, "java.time.Instant", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.LocalDate")) {
                try {
                    this.reg(Class.forName("java.time.LocalDate"), Class.forName("java.time.LocalDate").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception8) {
                    exception = exception8;
                    BuiltIn.handle(exception8, "java.time.LocalDate", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.LocalDateTime")) {
                try {
                    this.reg(Class.forName("java.time.LocalDateTime"), Class.forName("java.time.LocalDateTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception9) {
                    exception = exception9;
                    BuiltIn.handle(exception9, "java.time.LocalDateTime", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.LocalTime")) {
                try {
                    this.reg(Class.forName("java.time.LocalTime"), Class.forName("java.time.LocalTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception10) {
                    exception = exception10;
                    BuiltIn.handle(exception10, "java.time.LocalTime", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.MonthDay")) {
                try {
                    this.reg(Class.forName("java.time.MonthDay"), Class.forName("java.time.MonthDay").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception11) {
                    exception = exception11;
                    BuiltIn.handle(exception11, "java.time.MonthDay", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.OffsetDateTime")) {
                try {
                    this.reg(Class.forName("java.time.OffsetDateTime"), Class.forName("java.time.OffsetDateTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception12) {
                    exception = exception12;
                    BuiltIn.handle(exception12, "java.time.OffsetDateTime", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.OffsetTime")) {
                try {
                    this.reg(Class.forName("java.time.OffsetTime"), Class.forName("java.time.OffsetTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception13) {
                    exception = exception13;
                    BuiltIn.handle(exception13, "java.time.OffsetTime", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.Period")) {
                try {
                    this.reg(Class.forName("java.time.Period"), Class.forName("java.time.Period").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception14) {
                    exception = exception14;
                    BuiltIn.handle(exception14, "java.time.Period", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.Year")) {
                try {
                    this.reg(Class.forName("java.time.Year"), Class.forName("java.time.Year").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception15) {
                    exception = exception15;
                    BuiltIn.handle(exception15, "java.time.Year", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.YearMonth")) {
                try {
                    this.reg(Class.forName("java.time.YearMonth"), Class.forName("java.time.YearMonth").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception16) {
                    exception = exception16;
                    BuiltIn.handle(exception16, "java.time.YearMonth", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.ZonedDateTime")) {
                try {
                    this.reg(Class.forName("java.time.ZonedDateTime"), Class.forName("java.time.ZonedDateTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception17) {
                    exception = exception17;
                    BuiltIn.handle(exception17, "java.time.ZonedDateTime", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.ZoneId")) {
                try {
                    this.reg(Class.forName("java.time.ZoneId"), Class.forName("java.time.ZoneId").getDeclaredMethod("of", String.class), String.class);
                }
                catch (Exception exception18) {
                    exception = exception18;
                    BuiltIn.handle(exception18, "java.time.ZoneId", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.time.ZoneOffset")) {
                try {
                    this.reg(Class.forName("java.time.ZoneOffset"), Class.forName("java.time.ZoneOffset").getDeclaredMethod("of", String.class), String.class);
                }
                catch (Exception exception19) {
                    exception = exception19;
                    BuiltIn.handle(exception19, "java.time.ZoneOffset", CommandLine.this.tracer);
                }
            }
            if (!this.excl("java.nio.file.Path")) {
                try {
                    this.reg(Class.forName("java.nio.file.Path"), Class.forName("java.nio.file.Paths").getDeclaredMethod("get", String.class, String[].class), String.class, String[].class);
                    return;
                }
                catch (Exception exception20) {
                    exception = exception20;
                    BuiltIn.handle(exception20, "java.nio.file.Path", CommandLine.this.tracer);
                }
            }
        }

        private boolean excl(String fqcn) {
            return BuiltIn.excluded(fqcn, CommandLine.this.tracer);
        }

        private void reg(Class<?> cls, Method method, Class<?> ... paramTypes) {
            this.converterRegistry.put(cls, new BuiltIn.ReflectionConverter(method, paramTypes));
        }

        private void reg(Class<?> timeClass, BuiltIn.ISO8601TimeConverter converter) {
            this.converterRegistry.put(timeClass, converter);
        }

        private Model.ParserSpec config() {
            return CommandLine.this.commandSpec.parser();
        }

        List<CommandLine> parse(String ... args) {
            Assert.notNull(args, "argument array");
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Picocli version: %s%n", CommandLine.versionString());
            }
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Parsing %d command line args %s%n", args.length, Arrays.toString(args));
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Parser configuration: optionsCaseInsensitive=%s, subcommandsCaseInsensitive=%s, %s%n", CommandLine.this.commandSpec.optionsCaseInsensitive(), CommandLine.this.commandSpec.subcommandsCaseInsensitive(), this.config());
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("(ANSI is %s by default: systemproperty[picocli.ansi]=%s, isatty=%s, TERM=%s, OSTYPE=%s, isWindows=%s, JansiConsoleInstalled=%s, ANSICON=%s, ConEmuANSI=%s, NO_COLOR=%s, CLICOLOR=%s, CLICOLOR_FORCE=%s)%n", Help.Ansi.AUTO.enabled() ? "enabled" : "disabled", System.getProperty("picocli.ansi"), Help.Ansi.isTTY(), System.getenv("TERM"), System.getenv("OSTYPE"), Help.Ansi.isWindows(), Help.Ansi.isJansiConsoleInstalled(), System.getenv("ANSICON"), System.getenv("ConEmuANSI"), System.getenv("NO_COLOR"), System.getenv("CLICOLOR"), System.getenv("CLICOLOR_FORCE"));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = args;
            int n2 = args.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = object[i2];
                this.addOrExpand(string, arrayList, new LinkedHashSet<String>());
            }
            object = new Stack();
            object.addAll(CommandLine.reverseList(arrayList));
            ArrayList<CommandLine> arrayList2 = new ArrayList<CommandLine>();
            this.parse(arrayList2, (Stack<String>)object, args, new ArrayList<Object>(), new HashSet<Model.ArgSpec>());
            return arrayList2;
        }

        private void addOrExpand(String arg, List<String> arguments, Set<String> visited) {
            if (this.config().expandAtFiles() && !arg.equals("@") && arg.startsWith("@")) {
                if ((arg = arg.substring(1)).startsWith("@")) {
                    if (CommandLine.this.tracer.isInfo()) {
                        CommandLine.this.tracer.info("Not expanding @-escaped argument %s (trimmed leading '@' char)%n", arg);
                    }
                } else {
                    if (CommandLine.this.tracer.isInfo()) {
                        CommandLine.this.tracer.info("Expanding argument file @%s%n", arg);
                    }
                    this.expandArgumentFile(arg, arguments, visited);
                    return;
                }
            }
            arguments.add(arg);
        }

        private void expandArgumentFile(String fileName, List<String> arguments, Set<String> visited) {
            File file = new File(fileName);
            if (!file.canRead()) {
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("File %s does not exist or cannot be read; treating argument literally%n", fileName);
                }
                arguments.add("@" + fileName);
                return;
            }
            if (visited.contains(file.getAbsolutePath())) {
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Already visited file %s; ignoring...%n", file.getAbsolutePath());
                    return;
                }
            } else {
                this.expandValidArgumentFile(fileName, file, arguments, visited);
            }
        }

        private void expandValidArgumentFile(String fileName, File file, List<String> arguments, Set<String> visited) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LineNumberReader lineNumberReader = null;
            try {
                visited.add(file.getAbsolutePath());
                lineNumberReader = new LineNumberReader(new FileReader(file));
                if (CommandLine.this.commandSpec.parser().useSimplifiedAtFiles()) {
                    String string;
                    while ((string = lineNumberReader.readLine()) != null) {
                        if (string.length() <= 0 || string.trim().startsWith(String.valueOf(CommandLine.this.commandSpec.parser().atFileCommentChar()))) continue;
                        this.addOrExpand(string, arrayList, visited);
                    }
                } else {
                    StreamTokenizer streamTokenizer = new StreamTokenizer(lineNumberReader);
                    streamTokenizer.resetSyntax();
                    streamTokenizer.wordChars(32, 255);
                    streamTokenizer.whitespaceChars(0, 32);
                    streamTokenizer.quoteChar(34);
                    streamTokenizer.quoteChar(39);
                    if (CommandLine.this.commandSpec.parser().atFileCommentChar() != null) {
                        streamTokenizer.commentChar(CommandLine.this.commandSpec.parser().atFileCommentChar().charValue());
                    }
                    while (streamTokenizer.nextToken() != -1) {
                        this.addOrExpand(streamTokenizer.sval, arrayList, visited);
                    }
                }
            }
            catch (Exception exception) {
                try {
                    throw new InitializationException("Could not read argument file @" + fileName, exception);
                }
                catch (Throwable throwable) {
                    CommandLine.close(lineNumberReader);
                    throw throwable;
                }
            }
            CommandLine.close(lineNumberReader);
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Expanded file @%s to arguments %s%n", fileName, arrayList);
            }
            arguments.addAll(arrayList);
        }

        private void clear() {
            CommandLine.this.getCommandSpec().userObject();
            this.position = 0;
            this.endOfOptions = false;
            this.isHelpRequested = false;
            this.parseResultBuilder = ParseResult.builder(CommandLine.this.getCommandSpec());
            for (Model.OptionSpec object : CommandLine.this.getCommandSpec().options()) {
                this.clear(object);
            }
            for (Model.PositionalParamSpec positionalParamSpec : CommandLine.this.getCommandSpec().positionalParameters()) {
                this.clear(positionalParamSpec);
            }
            for (Model.ArgGroupSpec argGroupSpec : CommandLine.this.getCommandSpec().argGroups()) {
                this.clear(argGroupSpec);
            }
            for (Model.UnmatchedArgsBinding unmatchedArgsBinding : CommandLine.this.getCommandSpec().unmatchedArgsBindings()) {
                unmatchedArgsBinding.clear();
            }
        }

        private void clear(Model.ArgSpec argSpec) {
            argSpec.resetStringValues();
            argSpec.resetOriginalStringValues();
            argSpec.typedValues.clear();
            argSpec.typedValueAtPosition.clear();
            if (argSpec.inherited()) {
                CommandLine.this.tracer.debug("Not applying initial value for inherited %s%n", CommandLine.optionDescription("", argSpec, -1));
                return;
            }
            if (argSpec.group() == null) {
                argSpec.applyInitialValue(CommandLine.this.tracer);
            }
        }

        private void clear(Model.ArgGroupSpec group) {
            for (Model.ArgSpec object : group.args()) {
                this.clear(object);
            }
            for (Model.ArgGroupSpec argGroupSpec : group.subgroups()) {
                this.clear(argGroupSpec);
            }
        }

        void maybeThrow(PicocliException ex) throws PicocliException {
            if (CommandLine.this.commandSpec.parser().collectErrors) {
                this.parseResultBuilder.addError(ex);
                return;
            }
            throw ex;
        }

        private void parse(List<CommandLine> parsedCommands, Stack<String> argumentStack, String[] originalArgs, List<Object> nowProcessing, Collection<Model.ArgSpec> inheritedRequired) {
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Initializing %s: %d options, %d positional parameters, %d required, %d groups, %d subcommands.%n", CommandLine.this.commandSpec.toString(), new HashSet<Model.OptionSpec>(CommandLine.this.commandSpec.optionsMap().values()).size(), CommandLine.this.commandSpec.positionalParameters().size(), CommandLine.this.commandSpec.requiredArgs().size(), CommandLine.this.commandSpec.argGroups().size(), CommandLine.this.commandSpec.subcommands().size());
            }
            this.clear();
            parsedCommands.add(CommandLine.this);
            ArrayList<Model.ArgSpec> arrayList = new ArrayList<Model.ArgSpec>(CommandLine.this.commandSpec.requiredArgs());
            this.addPostponedRequiredArgs(inheritedRequired, arrayList);
            LinkedHashSet<Model.ArgSpec> linkedHashSet = new LinkedHashSet<Model.ArgSpec>();
            Collections.sort(arrayList, new PositionalParametersSorter());
            boolean bl = CommandLine.this.commandSpec.parser().collectErrors();
            do {
                int n2 = argumentStack.size();
                try {
                    this.processArguments(parsedCommands, argumentStack, arrayList, linkedHashSet, originalArgs, nowProcessing);
                    this.applyDefaultValues(arrayList, linkedHashSet);
                }
                catch (InitializationException initializationException) {
                    this.maybeThrow(initializationException);
                }
                catch (ParameterException parameterException) {
                    this.maybeThrow(parameterException);
                }
                catch (Exception exception) {
                    int n3 = originalArgs.length - argumentStack.size() - 1;
                    String string = n3 >= 0 && n3 < originalArgs.length ? originalArgs[n3] : "?";
                    Interpreter interpreter = this;
                    interpreter.maybeThrow(ParameterException.create(interpreter.CommandLine.this, exception, string, n3, originalArgs));
                }
                if (!bl || n2 != argumentStack.size() || n2 <= 0) continue;
                this.parseResultBuilder.unmatched.add(argumentStack.pop());
            } while (!argumentStack.isEmpty() && bl);
            if (!this.isAnyHelpRequested()) {
                this.validateConstraints(argumentStack, arrayList, linkedHashSet);
            }
        }

        private void addPostponedRequiredArgs(Collection<Model.ArgSpec> inheritedRequired, List<Model.ArgSpec> required) {
            for (Model.ArgSpec argSpec : inheritedRequired) {
                Model.ArgSpec argSpec2;
                if (argSpec.isOption()) {
                    argSpec2 = CommandLine.this.commandSpec.findOption(((Model.OptionSpec)argSpec).longestName());
                    Assert.notNull(argSpec2, "inherited option " + argSpec);
                    required.add(argSpec2);
                    continue;
                }
                argSpec2 = (Model.PositionalParamSpec)argSpec;
                for (Model.PositionalParamSpec positionalParamSpec : CommandLine.this.commandSpec.positionalParameters()) {
                    if (!positionalParamSpec.inherited() || !positionalParamSpec.index().equals(((Model.PositionalParamSpec)argSpec2).index()) || !positionalParamSpec.arity().equals(argSpec2.arity()) || !positionalParamSpec.typeInfo().equals(argSpec2.typeInfo()) || !Assert.equals(positionalParamSpec.paramLabel(), argSpec2.paramLabel()) || !Assert.equals(positionalParamSpec.hideParamSyntax(), argSpec2.hideParamSyntax()) || !Assert.equals(positionalParamSpec.required(), argSpec2.required()) || !Assert.equals(positionalParamSpec.splitRegex(), argSpec2.splitRegex()) || !Arrays.equals(positionalParamSpec.description(), argSpec2.description()) || !Assert.equals(positionalParamSpec.descriptionKey(), argSpec2.descriptionKey()) || !Assert.equals(positionalParamSpec.parameterConsumer(), argSpec2.parameterConsumer())) continue;
                    required.add(positionalParamSpec);
                }
            }
        }

        private void validateConstraints(Stack<String> argumentStack, List<Model.ArgSpec> required, Set<Model.ArgSpec> matched) {
            String[] stringArray;
            if (!required.isEmpty()) {
                for (Model.ArgSpec object : required) {
                    Assert.assertTrue(object.group() == null, "Arguments in a group are not necessarily required for the command");
                    if (object.isOption()) {
                        Interpreter interpreter = this;
                        interpreter.maybeThrow(MissingParameterException.create(interpreter.CommandLine.this, required, this.config().separator()));
                        continue;
                    }
                    Model.ArgSpec argSpec = object;
                    this.assertNoMissingParameters(argSpec, argSpec.arity(), argumentStack);
                }
            }
            if (!this.parseResultBuilder.unmatched.isEmpty()) {
                stringArray = this.parseResultBuilder.unmatched.toArray(new String[0]);
                for (Model.UnmatchedArgsBinding unmatchedArgsBinding : CommandLine.this.getCommandSpec().unmatchedArgsBindings()) {
                    unmatchedArgsBinding.addAll((String[])stringArray.clone());
                }
                if (!CommandLine.this.isUnmatchedArgumentsAllowed()) {
                    this.maybeThrow(new UnmatchedArgumentException(CommandLine.this, Collections.unmodifiableList(this.parseResultBuilder.unmatched)));
                }
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Unmatched arguments: %s%n", this.parseResultBuilder.unmatched);
                }
            }
            stringArray = this.parseResultBuilder.build();
            stringArray.validateGroups();
        }

        private void applyDefaultValues(List<Model.ArgSpec> required, Set<Model.ArgSpec> initialized) throws Exception {
            this.parseResultBuilder.isInitializingDefaultValues = true;
            CommandLine.this.tracer.debug("Applying default values for command '%s'%n", CommandLine.this.commandSpec.qualifiedName());
            for (Model.ArgSpec object : CommandLine.this.commandSpec.args()) {
                if (object.group() != null || initialized.contains(object)) continue;
                if (object.inherited()) {
                    CommandLine.this.tracer.debug("Not applying default value for inherited %s%n", CommandLine.optionDescription("", object, -1));
                    continue;
                }
                Interpreter interpreter = this;
                if (!interpreter.applyDefault(interpreter.CommandLine.this.commandSpec.defaultValueProvider(), object)) continue;
                required.remove(object);
            }
            for (Model.ArgGroupSpec argGroupSpec : CommandLine.this.commandSpec.argGroups()) {
                Interpreter interpreter = this;
                interpreter.applyGroupDefaults(interpreter.CommandLine.this.commandSpec.defaultValueProvider(), argGroupSpec, required, initialized);
            }
            this.parseResultBuilder.isInitializingDefaultValues = false;
        }

        private void applyGroupDefaults(IDefaultValueProvider defaultValueProvider, Model.ArgGroupSpec group, List<Model.ArgSpec> required, Set<Model.ArgSpec> initialized) throws Exception {
            CommandLine.this.tracer.debug("Applying default values for group '%s'%n", group.synopsis());
            for (Model.ArgSpec object : group.args()) {
                if (object.scope().get() == null || initialized.contains(object)) continue;
                if (object.inherited()) {
                    CommandLine.this.tracer.debug("Not applying default value for inherited %s%n", CommandLine.optionDescription("", object, -1));
                    continue;
                }
                if (!this.applyDefault(defaultValueProvider, object)) continue;
                required.remove(object);
            }
            for (Model.ArgGroupSpec argGroupSpec : group.subgroups()) {
                this.applyGroupDefaults(defaultValueProvider, argGroupSpec, required, initialized);
            }
        }

        private boolean applyDefault(IDefaultValueProvider defaultValueProvider, Model.ArgSpec arg) throws Exception {
            String string = defaultValueProvider == null ? null : defaultValueProvider.defaultValue(arg);
            String string2 = string == null ? arg.defaultValue() : string;
            if (string2 != null) {
                String string3;
                String string4 = string3 = defaultValueProvider == null ? "" : " from " + defaultValueProvider.toString();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Applying defaultValue (%s)%s to %s on %s%n", string2, string3, arg, arg.scopeString());
                }
                Range range = arg.arity().min(Math.max(1, arg.arity().min));
                this.applyOption(arg, false, LookBehind.SEPARATE, false, range, this.stack(string2), new HashSet<Model.ArgSpec>(), arg.toString);
            } else {
                CommandLine.this.tracer.debug("defaultValue not defined for %s%n", arg);
            }
            return string2 != null;
        }

        private Stack<String> stack(String value) {
            Stack<String> stack = new Stack<String>();
            stack.push(value);
            return stack;
        }

        private void processArguments(List<CommandLine> parsedCommands, Stack<String> args, Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String[] originalArgs, List<Object> nowProcessing) throws Exception {
            ArrayList<String> arrayList = new ArrayList<String>(args);
            Collections.reverse(arrayList);
            this.parseResultBuilder.expandedArgs(arrayList);
            this.parseResultBuilder.originalArgs(originalArgs);
            this.parseResultBuilder.nowProcessing = nowProcessing;
            String string = this.config().separator();
            while (!args.isEmpty()) {
                Object object;
                String string2;
                boolean bl;
                if (this.endOfOptions) {
                    this.processRemainderAsPositionalParameters(required, initialized, args);
                    return;
                }
                String string3 = args.pop();
                boolean bl2 = bl = !string3.equals(string2 = CommandLine.this.smartUnquoteIfEnabled(string3));
                if (CommandLine.this.tracer.isDebug()) {
                    int n2 = originalArgs.length - (args.size() + 1);
                    if (bl) {
                        CommandLine.this.tracer.debug("[%d] Processing argument '%s' (trimmed from '%s'). Remainder=%s%n", n2, string2, string3, CommandLine.reverse(CommandLine.copy(args)));
                    } else {
                        CommandLine.this.tracer.debug("[%d] Processing argument '%s'. Remainder=%s%n", n2, string2, CommandLine.reverse(CommandLine.copy(args)));
                    }
                }
                if (CommandLine.this.commandSpec.parser.endOfOptionsDelimiter().equals(string2)) {
                    CommandLine.this.tracer.info("Found end-of-options delimiter '%s'. Treating remainder as positional parameters.%n", CommandLine.this.commandSpec.parser.endOfOptionsDelimiter());
                    this.endOfOptions = true;
                    this.processRemainderAsPositionalParameters(required, initialized, args);
                    return;
                }
                if (CommandLine.this.commandSpec.parser().abbreviatedSubcommandsAllowed()) {
                    try {
                        string2 = AbbreviationMatcher.match(CommandLine.this.commandSpec.subcommands().keySet(), string2, CommandLine.this.commandSpec.subcommandsCaseInsensitive());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterException(CommandLine.this, "Error: " + illegalArgumentException.getMessage());
                    }
                }
                if (CommandLine.this.commandSpec.subcommands().containsKey(string2)) {
                    CommandLine commandLine = CommandLine.this.commandSpec.subcommands().get(string2);
                    this.processSubcommand(commandLine, this.parseResultBuilder, parsedCommands, args, required, originalArgs, nowProcessing, string, string2);
                    return;
                }
                if (CommandLine.this.commandSpec.parent() != null && CommandLine.this.commandSpec.parent().subcommandsRepeatable() && CommandLine.this.commandSpec.parent().subcommands().containsKey(string2)) {
                    CommandLine.this.tracer.debug("'%s' is a repeatable subcommand of %s%n", string2, CommandLine.this.commandSpec.parent().qualifiedName());
                    object = CommandLine.this.commandSpec.parent().subcommands().get(string2);
                    if (((CommandLine)object).interpreter.parseResultBuilder != null) {
                        CommandLine.this.tracer.debug("Subcommand '%s' has been matched before. Making a copy...%n", ((CommandLine)object).getCommandName());
                        object = ((CommandLine)object).copy();
                        ((CommandLine)object).getCommandSpec().parent(CommandLine.this.commandSpec.parent());
                    }
                    this.processSubcommand((CommandLine)object, ((CommandLine)CommandLine.this.getParent()).interpreter.parseResultBuilder, parsedCommands, args, required, originalArgs, nowProcessing, string, string2);
                    continue;
                }
                if (CommandLine.this.commandSpec.parser().abbreviatedOptionsAllowed()) {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                    linkedHashSet.addAll(CommandLine.this.commandSpec.optionsMap().keySet());
                    linkedHashSet.addAll(CommandLine.this.commandSpec.negatedOptionsMap().keySet());
                    linkedHashSet.iterator();
                    try {
                        string2 = AbbreviationMatcher.match(linkedHashSet, string2, CommandLine.this.commandSpec.optionsCaseInsensitive());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterException(CommandLine.this, "Error: " + illegalArgumentException.getMessage());
                    }
                }
                object = LookBehind.SEPARATE;
                int n3 = string2.indexOf(string);
                if (n3 > 0) {
                    String string4 = string2.substring(0, n3);
                    if (this.isStandaloneOption(string4) && this.isStandaloneOption(string2)) {
                        CommandLine.this.tracer.warn("Both '%s' and '%s' are valid option names in %s. Using '%s'...%n", string2, string4, CommandLine.this.getCommandName(), string2);
                    } else if (this.isStandaloneOption(string4)) {
                        object = LookBehind.ATTACHED_WITH_SEPARATOR;
                        String string5 = string2.substring(n3 + string.length());
                        args.push(string5);
                        string2 = string4;
                        if (CommandLine.this.tracer.isDebug()) {
                            CommandLine.this.tracer.debug("Separated '%s' option from '%s' option parameter%n", string4, string5);
                        }
                    } else if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("'%s' contains separator '%s' but '%s' is not a known option%n", string2, string, string4);
                    }
                } else if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("'%s' cannot be separated into <option>%s<option-parameter>%n", string2, string);
                }
                if (this.isStandaloneOption(string2)) {
                    this.processStandaloneOption(required, initialized, string2, bl, args, (LookBehind)((Object)object));
                    continue;
                }
                if (this.config().posixClusteredShortOptionsAllowed() && string2.length() > 2 && string2.startsWith("-")) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Trying to process '%s' as clustered short options%n", string2, args);
                    }
                    this.processClusteredShortOptions(required, initialized, string2, bl, args);
                    continue;
                }
                args.push(string2);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Could not find option '%s', deciding whether to treat as unmatched option or positional parameter...%n", string2);
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option named '%s' found. Processing as positional parameter%n", string2);
                }
                this.processPositionalParameter(required, initialized, bl, args);
            }
        }

        private void processSubcommand(CommandLine subcommand, ParseResult.Builder builder, List<CommandLine> parsedCommands, Stack<String> args, Collection<Model.ArgSpec> required, String[] originalArgs, List<Object> nowProcessing, String separator, String arg) {
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Found subcommand '%s' (%s)%n", arg, subcommand.commandSpec.toString());
            }
            nowProcessing.add(subcommand.commandSpec);
            this.updateHelpRequested(subcommand.commandSpec);
            ArrayList<Model.ArgSpec> arrayList = new ArrayList<Model.ArgSpec>();
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Checking required args for parent %s...%n", subcommand.commandSpec.parent());
            }
            Iterator<Model.ArgSpec> iterator = required.iterator();
            while (iterator.hasNext()) {
                Model.ArgSpec argSpec = iterator.next();
                if (argSpec.scopeType() != ScopeType.INHERIT && !argSpec.inherited()) continue;
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Postponing validation for required %s: scopeType=%s, inherited=%s%n", new Object[]{CommandLine.optionDescription("", argSpec, -1), argSpec.scopeType(), argSpec.inherited()});
                }
                if (!arrayList.contains(argSpec)) {
                    arrayList.add(argSpec);
                }
                iterator.remove();
            }
            if (!this.isAnyHelpRequested() && !required.isEmpty()) {
                throw MissingParameterException.create(CommandLine.this, required, separator);
            }
            subcommand.interpreter.parse(parsedCommands, args, originalArgs, nowProcessing, arrayList);
            builder.subcommand(((CommandLine)subcommand).interpreter.parseResultBuilder.build());
        }

        private boolean isStandaloneOption(String arg) {
            return CommandLine.this.commandSpec.optionsMap().containsKey(arg) || CommandLine.this.commandSpec.negatedOptionsMap().containsKey(arg);
        }

        private void handleUnmatchedArgument(Stack<String> args) throws Exception {
            if (!args.isEmpty()) {
                this.handleUnmatchedArgument(args.pop());
            }
            if (this.config().stopAtUnmatched()) {
                while (!args.isEmpty()) {
                    this.handleUnmatchedArgument(args.pop());
                }
            }
        }

        private void handleUnmatchedArgument(String arg) {
            this.parseResultBuilder.unmatched.add(arg);
        }

        private void processRemainderAsPositionalParameters(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, Stack<String> args) throws Exception {
            while (!args.empty()) {
                this.processPositionalParameter(required, initialized, false, args);
            }
        }

        private void processPositionalParameter(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, boolean alreadyUnquoted, Stack<String> args) throws Exception {
            int n2;
            String string = args.peek();
            if (!this.endOfOptions && CommandLine.this.commandSpec.resemblesOption(string, CommandLine.this.tracer)) {
                if (!CommandLine.this.commandSpec.parser().unmatchedOptionsArePositionalParams()) {
                    this.handleUnmatchedArgument(args);
                    return;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Parser is configured to treat all unmatched options as positional parameter%n", string);
                }
            }
            int n3 = this.parseResultBuilder.originalArgList.size() - args.size();
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("[%d] Processing next arg as a positional parameter. Command-local position=%d. Remainder=%s%n", n3, this.position, CommandLine.reverse(CommandLine.copy(args)));
            }
            if (this.config().stopAtPositional()) {
                if (!this.endOfOptions && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Parser was configured with stopAtPositional=true, treating remaining arguments as positional parameters.%n", new Object[0]);
                }
                this.endOfOptions = true;
            }
            int n4 = this.interactiveCount;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.parseResultBuilder.nowProcessing.size();
            ArrayList<1> arrayList = new ArrayList<1>();
            for (n2 = 0; n2 < CommandLine.this.commandSpec.positionalParameters().size(); ++n2) {
                Object object;
                Model.PositionalParamSpec positionalParamSpec = CommandLine.this.commandSpec.positionalParameters().get(n2);
                Range object2 = positionalParamSpec.index();
                int n9 = this.getPosition(positionalParamSpec);
                if (!(positionalParamSpec.group() != null ? ((ParseResult.GroupMatchContainer)(object = this.parseResultBuilder.groupMatchContainer.findOrCreateMatchingGroup(positionalParamSpec, CommandLine.this.commandSpec.commandLine()))).canMatchPositionalParam(positionalParamSpec) : object2.contains(n9) && positionalParamSpec.typedValueAtPosition.get(n9) == null)) continue;
                object = CommandLine.copy(args);
                Range range = positionalParamSpec.arity();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Position %s is in index range %s. Trying to assign args to %s, arity=%s%n", this.positionDesc(positionalParamSpec), object2.internalToString(), positionalParamSpec, range);
                }
                if (!this.assertNoMissingParameters(positionalParamSpec, range, (Stack<String>)object)) break;
                int n10 = ((Vector)object).size();
                int n11 = this.applyOption(positionalParamSpec, false, LookBehind.SEPARATE, alreadyUnquoted, range, (Stack<String>)object, initialized, "args[" + object2.internalToString() + "] at position " + n9);
                int n12 = n10 - ((Vector)object).size();
                if (n12 > 0 || n11 > 0) {
                    required.remove(positionalParamSpec);
                    n7 = this.interactiveCount - n4;
                }
                if (positionalParamSpec.group() == null) {
                    n6 = Math.max(n6, n12);
                } else {
                    final int n13 = n9 + n12;
                    final ParseResult.GroupMatchContainer groupMatchContainer = this.parseResultBuilder.groupMatchContainer.findOrCreateMatchingGroup(positionalParamSpec, CommandLine.this.commandSpec.commandLine());
                    arrayList.add(new Runnable(){

                        public void run() {
                            if (groupMatchContainer != null) {
                                groupMatchContainer.lastMatch().position = n13;
                                if (CommandLine.this.tracer.isDebug()) {
                                    CommandLine.this.tracer.debug("Updated group position to %s for group %s.%n", groupMatchContainer.lastMatch().position, groupMatchContainer);
                                }
                            }
                        }
                    });
                    n5 = Math.max(n5, n12);
                }
                while (this.parseResultBuilder.nowProcessing.size() > n8 + n12) {
                    this.parseResultBuilder.nowProcessing.remove(this.parseResultBuilder.nowProcessing.size() - 1);
                }
            }
            n2 = Math.max(n5, n6);
            for (int i2 = 0; i2 < n2; ++i2) {
                args.pop();
            }
            this.position += n6 + n7;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Consumed %d arguments and %d interactive values, moving command-local position to index %d.%n", n6, n7, this.position);
            }
            for (Runnable runnable : arrayList) {
                runnable.run();
            }
            if (n5 == 0 && n6 == 0 && n7 == 0 && !args.isEmpty()) {
                this.handleUnmatchedArgument(args);
            }
        }

        private void processStandaloneOption(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String arg, boolean alreadyUnquoted, Stack<String> args, LookBehind lookBehind) throws Exception {
            Model.ArgSpec argSpec = CommandLine.this.commandSpec.optionsMap().get(arg);
            boolean bl = argSpec == null;
            if (bl) {
                argSpec = CommandLine.this.commandSpec.negatedOptionsMap().get(arg);
            }
            required.remove(argSpec);
            Range range = argSpec.arity();
            if (lookBehind.isAttached()) {
                range = range.min(Math.max(1, range.min));
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Found option named '%s': %s, arity=%s%n", arg, argSpec, range);
            }
            this.parseResultBuilder.nowProcessing.add(argSpec);
            this.applyOption(argSpec, bl, lookBehind, alreadyUnquoted, range, args, initialized, "option " + arg);
        }

        private void processClusteredShortOptions(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String arg, boolean alreadyUnquoted, Stack<String> args) throws Exception {
            Object object;
            String string = arg.substring(0, 1);
            String string2 = arg.substring(1);
            boolean bl = true;
            boolean bl2 = true;
            while (string2.length() > 0 && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(string2.charAt(0)))) {
                LookBehind lookBehind;
                object = CommandLine.this.commandSpec.posixOptionsMap().get(Character.valueOf(string2.charAt(0)));
                Range range = ((Model.ArgSpec)object).arity();
                String string3 = "option " + string + string2.charAt(0);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Found option '%s%s' in %s: %s, arity=%s%n", string, Character.valueOf(string2.charAt(0)), arg, object, range);
                }
                required.remove(object);
                string2 = string2.substring(1);
                bl = string2.length() > 0;
                LookBehind lookBehind2 = lookBehind = bl ? LookBehind.ATTACHED : LookBehind.SEPARATE;
                if (string2.startsWith(this.config().separator())) {
                    lookBehind = LookBehind.ATTACHED_WITH_SEPARATOR;
                    string2 = string2.substring(this.config().separator().length());
                    range = range.min(Math.max(1, range.min));
                }
                if (range.min > 0 && !CommandLine.empty(string2) && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Trying to process '%s' as option parameter%n", string2);
                }
                if (!CommandLine.empty(string2)) {
                    args.push(string2);
                }
                if (bl2) {
                    this.parseResultBuilder.nowProcessing.add(object);
                    bl2 = false;
                } else {
                    this.parseResultBuilder.nowProcessing.set(this.parseResultBuilder.nowProcessing.size() - 1, object);
                }
                int n2 = args.size();
                this.applyOption((Model.ArgSpec)object, false, lookBehind, alreadyUnquoted, range, args, initialized, string3);
                if (CommandLine.empty(string2) || args.isEmpty() || args.size() < n2) {
                    return;
                }
                string2 = args.pop();
            }
            if (string2.length() == 0) {
                return;
            }
            if (arg.endsWith(string2)) {
                args.push(bl ? string + string2 : string2);
                if (args.peek().equals(arg)) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Could not match any short options in %s, deciding whether to treat as unmatched option or positional parameter...%n", arg);
                    }
                    this.processPositionalParameter(required, initialized, alreadyUnquoted, args);
                    return;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option found for %s in %s%n", string2, arg);
                }
                object = args.pop();
                object = (String)object + " (while processing option: '" + arg + "')";
                args.push((String)object);
                this.handleUnmatchedArgument(args);
                return;
            }
            args.push(string2);
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("%s is not an option parameter for %s%n", string2, arg);
            }
            this.processPositionalParameter(required, initialized, alreadyUnquoted, args);
        }

        private int applyOption(Model.ArgSpec argSpec, boolean negated, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            this.updateHelpRequested(argSpec);
            this.parseResultBuilder.beforeMatchingGroupElement(argSpec);
            if (argSpec.parameterConsumer() != null) {
                int n2 = args.size();
                argSpec.parameterConsumer().consumeParameters(args, argSpec, CommandLine.this.commandSpec);
                return args.size() - n2;
            }
            boolean bl = CommandLine.this.commandSpec.parser().aritySatisfiedByAttachedOptionParam() && lookBehind.isAttached();
            Stack<String> stack = args;
            if (bl) {
                stack = args.isEmpty() ? args : this.stack(args.pop());
            } else if (!this.assertNoMissingParameters(argSpec, arity, args)) {
                return 0;
            }
            int n3 = argSpec.type().isArray() && (!argSpec.interactive() || argSpec.type() != char[].class) ? this.applyValuesToArrayField(argSpec, negated, lookBehind, alreadyUnquoted, arity, stack, initialized, argDescription) : (Collection.class.isAssignableFrom(argSpec.type()) ? this.applyValuesToCollectionField(argSpec, negated, lookBehind, alreadyUnquoted, arity, stack, initialized, argDescription) : (Map.class.isAssignableFrom(argSpec.type()) ? this.applyValuesToMapField(argSpec, lookBehind, alreadyUnquoted, arity, stack, initialized, argDescription) : this.applyValueToSingleValuedField(argSpec, negated, lookBehind, alreadyUnquoted, arity, stack, initialized, argDescription)));
            if (stack != args && !stack.isEmpty()) {
                args.push(stack.pop());
                Assert.assertTrue(stack.isEmpty(), "Working stack should be empty but was " + new ArrayList<String>(stack));
            }
            return n3;
        }

        private int applyValueToSingleValuedField(Model.ArgSpec argSpec, boolean negated, LookBehind lookBehind, boolean alreadyUnquoted, Range derivedArity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Object object;
            Object object2;
            int n2;
            Range range;
            boolean bl = args.isEmpty();
            String string = bl ? null : args.pop();
            String string2 = string;
            if (CommandLine.this.commandSpec.parser().trimQuotes() && !alreadyUnquoted) {
                string = CommandLine.unquote(string);
            }
            if ((range = ((Range)argSpec.arity()).isUnspecified ? derivedArity : argSpec.arity()).max == 0 && !range.isUnspecified && lookBehind == LookBehind.ATTACHED_WITH_SEPARATOR) {
                throw new MaxValuesExceededException(CommandLine.this, CommandLine.optionDescription("", argSpec, 0) + " should be specified without '" + string + "' parameter");
            }
            if (range.min > 0) {
                args.push(string2);
                n2 = this.assertNoMissingMandatoryParameter(argSpec, args, 0, range) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, args, 0, range) ? 1 : 0;
                args.pop();
                if (n2 != 0) {
                    return 0;
                }
            }
            n2 = range.min;
            String string3 = string;
            char[] cArray = null;
            Class<?> clazz = argSpec.auxiliaryTypes()[0];
            if (range.min <= 0) {
                boolean bl2 = true;
                n2 = 1;
                if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                    boolean bl3 = range.max > 0 && ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string));
                    if (!bl3 && lookBehind != LookBehind.ATTACHED_WITH_SEPARATOR) {
                        Model.ArgSpec argSpec2 = argSpec;
                        object2 = this.booleanValue(argSpec2, String.valueOf(argSpec2.calcDefaultValue(true)));
                        if (argSpec.isOption() && !CommandLine.empty(((Model.OptionSpec)argSpec).fallbackValue())) {
                            Model.ArgSpec argSpec3 = argSpec;
                            object2 = !this.booleanValue(argSpec3, ((Model.OptionSpec)argSpec3).fallbackValue());
                        }
                        if ((object = CommandLine.this.commandSpec.parser().toggleBooleanFlags() ? (Boolean)argSpec.getValue() : object2) == null) {
                            object = Boolean.FALSE;
                        }
                        string3 = String.valueOf(!((Boolean)object).booleanValue());
                        if (argSpec.isOption() && ((Model.OptionSpec)argSpec).negatable() && negated) {
                            string3 = String.valueOf(object);
                        }
                        bl2 = false;
                        n2 = 0;
                    }
                } else {
                    String string4;
                    String string5 = string4 = argSpec.isOption() ? ((Model.OptionSpec)argSpec).fallbackValue() : "";
                    if (this.isOption(string)) {
                        string3 = string4;
                        bl2 = false;
                        n2 = 0;
                    } else if (string == null) {
                        string3 = string4;
                        bl2 = false;
                        n2 = 0;
                    }
                }
                if (argSpec.interactive() && (range.max == 0 || !bl2)) {
                    cArray = this.readPassword(argSpec);
                    n2 = 0;
                }
            }
            if (n2 == 0) {
                if (string != null) {
                    args.push(string);
                }
            } else if (!lookBehind.isAttached()) {
                this.parseResultBuilder.nowProcessing(argSpec, string);
            }
            if (bl && string3 == null && cArray == null) {
                return 0;
            }
            Object object3 = cArray;
            String string6 = "Setting %s to *** (masked interactive value) for %4$s on %5$s%n";
            object2 = "Overwriting %s value with *** (masked interactive value) for %s on %5$s%n";
            if (!char[].class.equals(clazz) && !char[].class.equals(argSpec.type())) {
                if (cArray != null) {
                    string3 = new String(cArray);
                }
                object = this.getTypeConverter(clazz, argSpec, 0);
                object3 = this.tryConvert(argSpec, -1, (ITypeConverter<?>)object, string3, clazz);
                string6 = "Setting %s to '%3$s' (was '%2$s') for %4$s on %5$s%n";
                object2 = "Overwriting %s value '%s' with '%s' for %s on %s%n";
            } else if (cArray == null) {
                object3 = string3.toCharArray();
            } else {
                string3 = "***";
            }
            object = argSpec.getValue();
            Object object4 = string6;
            if (argSpec.group() == null && initialized.contains(argSpec)) {
                if (!CommandLine.this.isOverwrittenOptionsAllowed()) {
                    throw new OverwrittenOptionException(CommandLine.this, argSpec, CommandLine.optionDescription("", argSpec, 0) + " should be specified only once");
                }
                object4 = object2;
            }
            initialized.add(argSpec);
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info((String)object4, argSpec.toString(), String.valueOf(object), String.valueOf(object3), argDescription, argSpec.scopeString());
            }
            int n3 = this.getPosition(argSpec);
            argSpec.setValue(object3);
            this.parseResultBuilder.addOriginalStringValue(argSpec, string3);
            this.parseResultBuilder.addStringValue(argSpec, string3);
            this.parseResultBuilder.addTypedValues(argSpec, n3, object3);
            this.parseResultBuilder.add(argSpec, n3);
            return 1;
        }

        private int applyValuesToMapField(Model.ArgSpec argSpec, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Class<?>[] classArray = argSpec.auxiliaryTypes();
            if (classArray.length < 2) {
                throw new ParameterException(CommandLine.this, argSpec.toString() + " needs two types (one for the map key, one for the value) but only has " + classArray.length + " types configured.", argSpec, null);
            }
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(classArray[0], argSpec, 0);
            ITypeConverter<?> iTypeConverter2 = this.getTypeConverter(classArray[1], argSpec, 1);
            Map<Object, Object> map = (Map<Object, Object>)argSpec.getValue();
            if (map == null || !initialized.contains(argSpec)) {
                CommandLine.this.tracer.debug("Initializing binding for %s on %s with empty %s%n", CommandLine.optionDescription("", argSpec, 0), argSpec.scopeString(), argSpec.type().getSimpleName());
                map = this.createMap(argSpec.type());
                argSpec.setValue(map);
            }
            initialized.add(argSpec);
            int n2 = map.size();
            int n3 = this.getPosition(argSpec);
            this.consumeMapArguments(argSpec, lookBehind, alreadyUnquoted, arity, args, classArray, iTypeConverter, iTypeConverter2, map, argDescription);
            this.parseResultBuilder.add(argSpec, n3);
            argSpec.setValue(map);
            return map.size() - n2;
        }

        private void consumeMapArguments(Model.ArgSpec argSpec, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, Stack<String> args, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, String argDescription) throws Exception {
            String string;
            int n2 = this.getPosition(argSpec);
            int n3 = argSpec.stringValues().size();
            int n4 = this.consumedCountMap(0, n3, argSpec);
            int n5 = 0;
            while (n4 < arity.min && !args.isEmpty()) {
                LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
                this.parseResultBuilder.addTypedValues(argSpec, n2++, linkedHashMap);
                if (this.assertNoMissingMandatoryParameter(argSpec, args, n5, arity) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, args, n5, arity)) break;
                this.consumeOneMapArgument(argSpec, lookBehind, alreadyUnquoted, arity, n4, args.pop(), classes, keyConverter, valueConverter, linkedHashMap, n5, argDescription);
                result.putAll(linkedHashMap);
                n4 = this.consumedCountMap(n5 + 1, n3, argSpec);
                lookBehind = LookBehind.SEPARATE;
                alreadyUnquoted = false;
                ++n5;
            }
            if ((string = n4 == 0 && argSpec.isOption() && !"".equals(((Model.OptionSpec)argSpec).fallbackValue()) ? ((Model.OptionSpec)argSpec).fallbackValue() : null) != null && (args.isEmpty() || !this.varargCanConsumeNextValue(argSpec, args.peek()))) {
                args.push(string);
            }
            int n6 = n4;
            while (n4 < arity.max && !args.isEmpty() && this.varargCanConsumeNextValue(argSpec, args.peek())) {
                LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
                this.parseResultBuilder.addTypedValues(argSpec, n2++, linkedHashMap);
                if (!this.canConsumeOneMapArgument(argSpec, lookBehind, alreadyUnquoted, arity, n4, args.peek(), classes, keyConverter, valueConverter, argDescription) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, args, n6, arity)) break;
                this.consumeOneMapArgument(argSpec, lookBehind, alreadyUnquoted, arity, n4, args.pop(), classes, keyConverter, valueConverter, linkedHashMap, n6, argDescription);
                result.putAll(linkedHashMap);
                n4 = this.consumedCountMap(n6 + 1, n3, argSpec);
                lookBehind = LookBehind.SEPARATE;
                alreadyUnquoted = false;
                ++n6;
            }
        }

        private void consumeOneMapArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, int consumed, String arg, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, int index, String argDescription) throws Exception {
            String[] stringArray;
            if (!lookBehind.isAttached()) {
                this.parseResultBuilder.nowProcessing(argSpec, arg);
            }
            String[] stringArray2 = stringArray = this.unquoteAndSplit(argSpec, lookBehind, alreadyUnquoted, arity, consumed, arg);
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                String[] stringArray3 = this.splitKeyValue(argSpec, string);
                Object object = this.tryConvert(argSpec, index, keyConverter, stringArray3[0], classes[0]);
                Object object2 = this.tryConvert(argSpec, index, valueConverter, stringArray3[1], classes[1]);
                result.put(object, object2);
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Putting [%s : %s] in %s<%s, %s> %s for %s on %s%n", String.valueOf(object), String.valueOf(object2), result.getClass().getSimpleName(), classes[0].getSimpleName(), classes[1].getSimpleName(), argSpec.toString(), argDescription, argSpec.scopeString());
                }
                this.parseResultBuilder.addStringValue(argSpec, stringArray3[0]);
                this.parseResultBuilder.addStringValue(argSpec, stringArray3[1]);
            }
            this.parseResultBuilder.addOriginalStringValue(argSpec, arg);
        }

        private String[] unquoteAndSplit(Model.ArgSpec argSpec, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, int consumed, String arg) {
            String string = lookBehind.isAttached() && alreadyUnquoted ? arg : CommandLine.this.smartUnquoteIfEnabled(arg);
            return argSpec.splitValue(string, CommandLine.this.commandSpec.parser(), arity, consumed);
        }

        private boolean canConsumeOneMapArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, int consumed, String arg, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, String argDescription) {
            String[] stringArray = this.unquoteAndSplit(argSpec, lookBehind, alreadyUnquoted, arity, consumed, arg);
            try {
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = stringArray2[i2];
                    String[] stringArray3 = this.splitKeyValue(argSpec, string);
                    this.tryConvert(argSpec, -1, keyConverter, stringArray3[0], classes[0]);
                    this.tryConvert(argSpec, -1, valueConverter, stringArray3[1], classes[1]);
                }
                return true;
            }
            catch (PicocliException picocliException) {
                CommandLine.this.tracer.debug("%s cannot be assigned to %s: type conversion fails: %s.%n", arg, argDescription, picocliException.getMessage());
                return false;
            }
        }

        private String[] splitKeyValue(Model.ArgSpec argSpec, String value) {
            String[] stringArray = Model.ArgSpec.splitRespectingQuotedStrings(value, 2, this.config(), argSpec, "=");
            if (stringArray.length < 2) {
                String string = argSpec.splitRegex();
                if (string.length() == 0) {
                    throw new ParameterException(CommandLine.this, "Value for option " + CommandLine.optionDescription("", argSpec, 0) + " should be in KEY=VALUE format but was " + value, argSpec, value);
                }
                throw new ParameterException(CommandLine.this, "Value for option " + CommandLine.optionDescription("", argSpec, 0) + " should be in KEY=VALUE[" + string + "KEY=VALUE]... format but was " + value, argSpec, value);
            }
            return stringArray;
        }

        private boolean assertNoMissingMandatoryParameter(Model.ArgSpec argSpec, Stack<String> args, int i2, Range arity) {
            if (!this.varargCanConsumeNextValue(argSpec, args.peek())) {
                String string = this.createMissingParameterMessageFoundOtherOption(argSpec, args, i2, arity);
                this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, string));
                return true;
            }
            return false;
        }

        private String createMissingParameterMessageFoundOtherOption(Model.ArgSpec argSpec, Stack<String> args, int i2, Range arity) {
            String string = arity.min > 1 ? i2 + 1 + " (of " + arity.min + " mandatory parameters) " : "";
            return "Expected parameter " + string + "for " + CommandLine.optionDescription("", argSpec, -1) + " but found '" + args.peek() + "'";
        }

        private boolean isArgResemblesOptionThereforeDiscontinue(Model.ArgSpec argSpec, Stack<String> args, int i2, Range arity) throws Exception {
            boolean bl = false;
            String string = args.peek();
            if (CommandLine.this.commandSpec.resemblesOption(string, CommandLine.this.tracer)) {
                if (argSpec.isPositional() && !this.endOfOptions && !CommandLine.this.commandSpec.parser().unmatchedOptionsArePositionalParams()) {
                    this.handleUnmatchedArgument(args);
                    bl = true;
                }
                if (argSpec.isOption() && !CommandLine.this.commandSpec.parser().unmatchedOptionsAllowedAsOptionParameters()) {
                    String string2 = "Unknown option: '" + string + "'; " + this.createMissingParameterMessageFoundOtherOption(argSpec, args, i2, arity);
                    this.maybeThrow(new UnmatchedArgumentException(CommandLine.this.commandSpec.commandLine(), string2));
                    bl = true;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Parser is configured to allow unmatched option '%s' as option or positional parameter.%n", string);
                }
            }
            return bl;
        }

        private int applyValuesToArrayField(Model.ArgSpec argSpec, boolean negated, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Object t2 = argSpec.getValue();
            int n2 = t2 == null ? 0 : Array.getLength(t2);
            Class<?> clazz = argSpec.auxiliaryTypes()[0];
            int n3 = this.getPosition(argSpec);
            boolean bl = alreadyUnquoted;
            List<Object> list = this.consumeArguments(argSpec, negated, lookBehind, bl, bl, arity, args, clazz, argDescription);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (initialized.contains(argSpec)) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(Array.get(t2, i2));
                }
            }
            initialized.add(argSpec);
            for (Object object : list) {
                if (object instanceof Collection) {
                    arrayList.addAll((Collection)object);
                    continue;
                }
                arrayList.add(object);
            }
            Object object = Array.newInstance(clazz, arrayList.size());
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Array.set(object, i3, arrayList.get(i3));
            }
            argSpec.setValue(object);
            this.parseResultBuilder.add(argSpec, n3);
            return list.size();
        }

        private int applyValuesToCollectionField(Model.ArgSpec argSpec, boolean negated, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Collection<Object> collection = (Collection<Object>)argSpec.getValue();
            Class<?> clazz = argSpec.auxiliaryTypes()[0];
            int n2 = this.getPosition(argSpec);
            boolean bl = alreadyUnquoted;
            List<Object> list = this.consumeArguments(argSpec, negated, lookBehind, bl, bl, arity, args, clazz, argDescription);
            if (collection == null || !initialized.contains(argSpec)) {
                CommandLine.this.tracer.debug("Initializing binding for %s on %s with empty %s%n", CommandLine.optionDescription("", argSpec, 0), argSpec.scopeString(), argSpec.type().getSimpleName());
                collection = this.createCollection(argSpec.type(), clazz);
                argSpec.setValue(collection);
            }
            initialized.add(argSpec);
            for (Object object : list) {
                if (object instanceof Collection) {
                    collection.addAll((Collection)object);
                    continue;
                }
                collection.add(object);
            }
            this.parseResultBuilder.add(argSpec, n2);
            argSpec.setValue(collection);
            return list.size();
        }

        private List<Object> consumeArguments(Model.ArgSpec argSpec, boolean negated, LookBehind lookBehind, boolean alreadyUnquoted, boolean unquoted, Range arity, Stack<String> args, Class<?> type, String argDescription) throws Exception {
            String string;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = this.getPosition(argSpec);
            int n3 = argSpec.stringValues().size();
            int n4 = this.consumedCount(0, n3, argSpec);
            int n5 = 0;
            while (n4 < arity.min && !args.isEmpty()) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                this.parseResultBuilder.addTypedValues(argSpec, n2++, arrayList2);
                if (this.assertNoMissingMandatoryParameter(argSpec, args, n5, arity) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, args, n5, arity)) break;
                this.consumeOneArgument(argSpec, lookBehind, alreadyUnquoted, arity, n4, args.pop(), type, arrayList2, n5, argDescription);
                arrayList.addAll(arrayList2);
                n4 = this.consumedCount(n5 + 1, n3, argSpec);
                lookBehind = LookBehind.SEPARATE;
                alreadyUnquoted = false;
                ++n5;
            }
            if (argSpec.interactive() && argSpec.arity().max == 0) {
                n4 = this.addPasswordToList(argSpec, type, arrayList, n4, argDescription);
            }
            if ((string = n4 == 0 && argSpec.isOption() && !"".equals(((Model.OptionSpec)argSpec).fallbackValue()) ? ((Model.OptionSpec)argSpec).fallbackValue() : null) != null && (args.isEmpty() || !this.varargCanConsumeNextValue(argSpec, args.peek()))) {
                args.push(string);
            }
            int n6 = n4;
            while (n4 < arity.max && !args.isEmpty()) {
                if (argSpec.interactive() && argSpec.arity().max == 1 && !this.varargCanConsumeNextValue(argSpec, args.peek())) {
                    n4 = this.addPasswordToList(argSpec, type, arrayList, n4, argDescription);
                } else {
                    if (!this.varargCanConsumeNextValue(argSpec, args.peek())) break;
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    this.parseResultBuilder.addTypedValues(argSpec, n2++, arrayList3);
                    if (!this.canConsumeOneArgument(argSpec, lookBehind, alreadyUnquoted, arity, n4, args.peek(), type, argDescription) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, args, n6, arity)) break;
                    this.consumeOneArgument(argSpec, lookBehind, alreadyUnquoted, arity, n4, args.pop(), type, arrayList3, n6, argDescription);
                    arrayList.addAll(arrayList3);
                    n4 = this.consumedCount(n6 + 1, n3, argSpec);
                    lookBehind = LookBehind.SEPARATE;
                    alreadyUnquoted = false;
                }
                ++n6;
            }
            if (arrayList.isEmpty() && arity.min == 0 && arity.max <= 1 && CommandLine.isBoolean(type)) {
                if (argSpec.isOption() && ((Model.OptionSpec)argSpec).negatable()) {
                    Object object = argSpec.calcDefaultValue(true);
                    boolean bl = false;
                    if (object instanceof String) {
                        bl = Boolean.parseBoolean(String.valueOf(object));
                    }
                    if (negated) {
                        return Collections.singletonList(bl);
                    }
                    return Collections.singletonList(!bl);
                }
                return Collections.singletonList(Boolean.TRUE);
            }
            return arrayList;
        }

        private int consumedCount(int i2, int initialSize, Model.ArgSpec arg) {
            if (CommandLine.this.commandSpec.parser().splitFirst()) {
                return arg.stringValues().size() - initialSize;
            }
            return i2;
        }

        private int consumedCountMap(int i2, int initialSize, Model.ArgSpec arg) {
            if (CommandLine.this.commandSpec.parser().splitFirst()) {
                return (arg.stringValues().size() - initialSize) / 2;
            }
            return i2;
        }

        private int addPasswordToList(Model.ArgSpec argSpec, Class<?> type, List<Object> result, int consumed, String argDescription) {
            char[] cArray = this.readPassword(argSpec);
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Adding *** (masked interactive value) to %s for %s on %s%n", argSpec.toString(), argDescription, argSpec.scopeString());
            }
            this.parseResultBuilder.addStringValue(argSpec, "***");
            this.parseResultBuilder.addOriginalStringValue(argSpec, "***");
            if (!char[].class.equals(argSpec.auxiliaryTypes()[0]) && !char[].class.equals(argSpec.type())) {
                Object object = this.tryConvert(argSpec, consumed, this.getTypeConverter(type, argSpec, consumed), new String(cArray), type);
                result.add(object);
            } else {
                result.add(cArray);
            }
            return ++consumed;
        }

        private int consumeOneArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, int consumed, String arg, Class<?> type, List<Object> result, int index, String argDescription) {
            if (!lookBehind.isAttached()) {
                this.parseResultBuilder.nowProcessing(argSpec, arg);
            }
            String[] stringArray = this.unquoteAndSplit(argSpec, lookBehind, alreadyUnquoted, arity, consumed, arg);
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(type, argSpec, 0);
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                Object object = this.tryConvert(argSpec, index, iTypeConverter, string, type);
                result.add(object);
                if (CommandLine.this.tracer.isInfo()) {
                    Object[] objectArray = new Object[4];
                    List<Object> list = result;
                    objectArray[0] = String.valueOf(list.get(list.size() - 1));
                    objectArray[1] = argSpec.toString();
                    objectArray[2] = argDescription;
                    objectArray[3] = argSpec.scopeString();
                    CommandLine.this.tracer.info("Adding [%s] to %s for %s on %s%n", objectArray);
                }
                this.parseResultBuilder.addStringValue(argSpec, string);
            }
            this.parseResultBuilder.addOriginalStringValue(argSpec, arg);
            return ++index;
        }

        private boolean canConsumeOneArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean alreadyUnquoted, Range arity, int consumed, String arg, Class<?> type, String argDescription) {
            if (char[].class.equals(argSpec.auxiliaryTypes()[0]) || char[].class.equals(argSpec.type())) {
                return true;
            }
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(type, argSpec, 0);
            try {
                String[] stringArray;
                String[] stringArray2 = stringArray = this.unquoteAndSplit(argSpec, lookBehind, alreadyUnquoted, arity, consumed, arg);
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = stringArray2[i2];
                    this.tryConvert(argSpec, -1, iTypeConverter, string, type);
                }
                return true;
            }
            catch (PicocliException picocliException) {
                CommandLine.this.tracer.debug("%s cannot be assigned to %s: type conversion fails: %s.%n", arg, argDescription, picocliException.getMessage());
                return false;
            }
        }

        private boolean varargCanConsumeNextValue(Model.ArgSpec argSpec, String nextValue) {
            if (this.endOfOptions && argSpec.isPositional()) {
                return true;
            }
            boolean bl = CommandLine.this.commandSpec.subcommands().containsKey(nextValue);
            return !bl && !this.isOption(nextValue);
        }

        private boolean isOption(String arg) {
            if (arg == null) {
                return false;
            }
            if (CommandLine.this.commandSpec.parser().endOfOptionsDelimiter().equals(arg)) {
                return true;
            }
            if (CommandLine.this.commandSpec.optionsMap().containsKey(arg)) {
                return true;
            }
            if (CommandLine.this.commandSpec.subcommands().containsKey(arg)) {
                return true;
            }
            if (CommandLine.this.commandSpec.parent() != null && CommandLine.this.commandSpec.parent().subcommandsRepeatable() && CommandLine.this.commandSpec.parent().subcommands().containsKey(arg)) {
                return true;
            }
            int n2 = arg.indexOf(this.config().separator());
            if (n2 > 0 && CommandLine.this.commandSpec.optionsMap().containsKey(arg.substring(0, n2))) {
                return true;
            }
            return arg.length() > 2 && arg.startsWith("-") && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(arg.charAt(1)));
        }

        private Object tryConvert(Model.ArgSpec argSpec, int index, ITypeConverter<?> converter, String value, Class<?> type) throws ParameterException {
            try {
                return converter.convert(value);
            }
            catch (TypeConversionException typeConversionException) {
                String string = String.format("Invalid value for %s: %s", CommandLine.optionDescription("", argSpec, index), typeConversionException.getMessage());
                throw new ParameterException(CommandLine.this, string, typeConversionException, argSpec, value);
            }
            catch (Exception exception) {
                String string = CommandLine.optionDescription("", argSpec, index);
                String string2 = String.format("Invalid value for %s: cannot convert '%s' to %s (%s)", string, value, type.getSimpleName(), exception);
                throw new ParameterException(CommandLine.this, string2, exception, argSpec, value);
            }
        }

        private boolean isAnyHelpRequested() {
            return this.isHelpRequested || this.parseResultBuilder.versionHelpRequested || this.parseResultBuilder.usageHelpRequested;
        }

        private void updateHelpRequested(Model.CommandSpec command) {
            this.isHelpRequested |= command.helpCommand();
        }

        private void updateHelpRequested(Model.ArgSpec argSpec) {
            if (!this.parseResultBuilder.isInitializingDefaultValues && argSpec.isOption()) {
                Model.OptionSpec optionSpec = (Model.OptionSpec)argSpec;
                this.isHelpRequested |= this.is(argSpec, "help", optionSpec.help());
                ParseResult.Builder builder = this.parseResultBuilder;
                builder.versionHelpRequested = builder.versionHelpRequested | this.is(argSpec, "versionHelp", optionSpec.versionHelp());
                builder = this.parseResultBuilder;
                builder.usageHelpRequested = builder.usageHelpRequested | this.is(argSpec, "usageHelp", optionSpec.usageHelp());
            }
        }

        private boolean is(Model.ArgSpec p2, String attribute, boolean value) {
            if (value && CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("%s has '%s' annotation: not validating required fields%n", p2.toString(), attribute);
            }
            return value;
        }

        private Collection<Object> createCollection(Class<?> collectionClass, Class<?> elementType) throws Exception {
            if (EnumSet.class.isAssignableFrom(collectionClass) && Enum.class.isAssignableFrom(elementType)) {
                EnumSet<?> enumSet = EnumSet.noneOf(elementType);
                return enumSet;
            }
            return (Collection)CommandLine.this.factory.create(collectionClass);
        }

        private Map<Object, Object> createMap(Class<?> mapClass) throws Exception {
            return (Map)CommandLine.this.factory.create(mapClass);
        }

        private ITypeConverter<?> getTypeConverter(final Class<?> type, Model.ArgSpec argSpec, int index) {
            if (argSpec.converters().length > index) {
                return argSpec.converters()[index];
            }
            if (char[].class.equals(argSpec.type()) && argSpec.interactive()) {
                return this.converterRegistry.get(char[].class);
            }
            if (this.converterRegistry.containsKey(type)) {
                return this.converterRegistry.get(type);
            }
            if (type.isEnum()) {
                return new ITypeConverter<Object>(){

                    @Override
                    public Object convert(String value) throws Exception {
                        try {
                            return Enum.valueOf(type, value);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            boolean bl = CommandLine.this.commandSpec.parser().caseInsensitiveEnumValuesAllowed();
                            for (Enum enum_ : (Enum[])type.getEnumConstants()) {
                                String string = enum_.toString();
                                String string2 = enum_.name();
                                if (!value.equals(string) && !value.equals(string2) && (!bl || !value.equalsIgnoreCase(string) && !value.equalsIgnoreCase(string2))) continue;
                                return enum_;
                            }
                            String string = bl ? "case-insensitive" : "case-sensitive";
                            Enum[] enumArray = (Enum[])type.getEnumConstants();
                            ArrayList<String> arrayList = new ArrayList<String>();
                            Enum[] enumArray2 = enumArray;
                            int n2 = enumArray.length;
                            for (int i2 = 0; i2 < n2; ++i2) {
                                Enum enum_ = enumArray2[i2];
                                arrayList.add(enum_.name());
                                if (arrayList.contains(enum_.toString()) || bl && enum_.name().equalsIgnoreCase(enum_.toString())) continue;
                                arrayList.add(enum_.toString());
                            }
                            throw new TypeConversionException(CommandLine.format("expected one of %s (%s) but was '%s'", new Object[]{arrayList, string, value}));
                        }
                    }
                };
            }
            throw new MissingTypeConverterException(CommandLine.this, "No TypeConverter registered for " + type.getName() + " of " + argSpec);
        }

        private boolean booleanValue(Model.ArgSpec argSpec, String value) {
            if (CommandLine.empty(value) || "null".equals(value)) {
                return false;
            }
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(Boolean.class, argSpec, 0);
            try {
                return (Boolean)iTypeConverter.convert(value);
            }
            catch (TypeConversionException typeConversionException) {
                TypeConversionException typeConversionException2 = typeConversionException;
                throw typeConversionException;
            }
            catch (Exception exception) {
                throw new TypeConversionException("Could not convert '" + value + "' to a boolean: " + exception.getMessage());
            }
        }

        private boolean assertNoMissingParameters(Model.ArgSpec argSpec, Range arity, Stack<String> args) {
            if (argSpec.interactive()) {
                return true;
            }
            int n2 = args.size();
            if (n2 > 0 && CommandLine.this.commandSpec.parser().splitFirst() && argSpec.splitRegex().length() > 0) {
                n2 += argSpec.splitValue(args.peek(), CommandLine.this.commandSpec.parser(), arity, 0).length - 1;
            }
            if (arity.min > n2) {
                List<Object> list = Collections.emptyList();
                List<Model.PositionalParamSpec> list2 = CommandLine.this.commandSpec.positionalParameters();
                if (argSpec.isPositional() && list2.contains(argSpec)) {
                    List<Model.PositionalParamSpec> list3 = list2;
                    list = list3.subList(list3.indexOf(argSpec), list2.size());
                }
                String string = CommandLine.createMissingParameterMessage(argSpec, arity, list, args, n2);
                this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, string));
                return false;
            }
            return true;
        }

        char[] readPassword(Model.ArgSpec argSpec) {
            String string = argSpec.isOption() ? ((Model.OptionSpec)argSpec).longestName() : "position " + this.position;
            String string2 = String.format("Enter value for %s (%s): ", string, CommandLine.str(argSpec.description(), 0));
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Reading value for %s from console...%n", string);
            }
            char[] cArray = this.readPassword(string2);
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("User entered %d characters for %s.%n", cArray.length, string);
            }
            return cArray;
        }

        char[] readPassword(String prompt) {
            try {
                Object object = System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]);
                Method method = Class.forName("java.io.Console").getDeclaredMethod("readPassword", String.class, Object[].class);
                char[] cArray = (char[])method.invoke(object, prompt, new Object[0]);
                return cArray;
            }
            catch (Exception exception) {
                System.out.print(prompt);
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string = bufferedReader.readLine();
                    char[] cArray = string == null ? new char[]{} : string.toCharArray();
                    return cArray;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException);
                }
            }
            finally {
                ++this.interactiveCount;
            }
        }

        int getPosition(Model.ArgSpec arg) {
            if (arg.group() == null) {
                return this.position;
            }
            ParseResult.GroupMatchContainer groupMatchContainer = this.parseResultBuilder.groupMatchContainer.findLastMatchContainer(arg.group());
            if (groupMatchContainer == null) {
                return 0;
            }
            return groupMatchContainer.lastMatch().position;
        }

        String positionDesc(Model.ArgSpec arg) {
            int n2 = this.getPosition(arg);
            if (arg.group() == null) {
                return n2 + " (command-local)";
            }
            return n2 + " (in group " + arg.group().synopsis() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LookBehind {
        SEPARATE,
        ATTACHED,
        ATTACHED_WITH_SEPARATOR;


        public final boolean isAttached() {
            return this != SEPARATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult {
        private final Model.CommandSpec commandSpec;
        private final Set<Model.OptionSpec> matchedUniqueOptions;
        private final Set<Model.PositionalParamSpec> matchedUniquePositionals;
        private final List<Model.ArgSpec> matchedArgs;
        private final List<Model.OptionSpec> matchedOptions;
        private final List<Model.PositionalParamSpec> matchedPositionals;
        private final List<String> originalArgs;
        private final List<String> expandedArgs;
        private final List<String> unmatched;
        private final List<List<Model.PositionalParamSpec>> matchedPositionalParams;
        private final List<Exception> errors;
        private final GroupMatchContainer groupMatchContainer;
        private final List<ParseResult> subcommands;
        final List<Object> tentativeMatch;
        private final boolean usageHelpRequested;
        private final boolean versionHelpRequested;

        private ParseResult(Builder builder) {
            this.commandSpec = builder.commandSpec;
            this.subcommands = builder.subcommands;
            this.matchedOptions = new ArrayList<Model.OptionSpec>(builder.matchedOptionsList);
            this.matchedUniqueOptions = new LinkedHashSet<Model.OptionSpec>(builder.options);
            this.unmatched = new ArrayList<String>(builder.unmatched);
            this.originalArgs = new ArrayList<String>(builder.originalArgList);
            this.expandedArgs = new ArrayList<String>(builder.expandedArgList);
            this.matchedArgs = new ArrayList<Model.ArgSpec>(builder.matchedArgsList);
            this.matchedUniquePositionals = new LinkedHashSet<Model.PositionalParamSpec>(builder.positionals);
            this.matchedPositionals = new ArrayList<Model.PositionalParamSpec>(builder.matchedPositionalsList);
            this.matchedPositionalParams = new ArrayList<List<Model.PositionalParamSpec>>(builder.positionalParams);
            this.errors = new ArrayList<Exception>(builder.errors);
            this.usageHelpRequested = builder.usageHelpRequested;
            this.versionHelpRequested = builder.versionHelpRequested;
            this.tentativeMatch = builder.nowProcessing;
            this.groupMatchContainer = builder.groupMatchContainer.trim();
        }

        public static Builder builder(Model.CommandSpec commandSpec) {
            return new Builder(commandSpec);
        }

        public List<GroupMatchContainer> findMatches(Model.ArgGroupSpec group) {
            return this.groupMatchContainer.findMatchContainers(group, new ArrayList<GroupMatchContainer>());
        }

        public List<GroupMatch> getGroupMatches() {
            return this.groupMatchContainer.matches();
        }

        public Model.OptionSpec matchedOption(char shortName) {
            return Model.CommandSpec.findOption(shortName, this.matchedOptions);
        }

        public Model.OptionSpec matchedOption(String name) {
            return Model.CommandSpec.findOption(name, this.matchedOptions);
        }

        public Model.PositionalParamSpec matchedPositional(int position) {
            if (this.matchedPositionalParams.size() <= position || this.matchedPositionalParams.get(position).isEmpty()) {
                return null;
            }
            return this.matchedPositionalParams.get(position).get(0);
        }

        public List<Model.PositionalParamSpec> matchedPositionals(int position) {
            if (this.matchedPositionalParams.size() <= position) {
                return Collections.emptyList();
            }
            if (this.matchedPositionalParams.get(position) == null) {
                return Collections.emptyList();
            }
            return this.matchedPositionalParams.get(position);
        }

        public Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public boolean hasMatchedOption(char shortName) {
            return this.matchedOption(shortName) != null;
        }

        public boolean hasMatchedOption(String name) {
            return this.matchedOption(name) != null;
        }

        public boolean hasMatchedOption(Model.OptionSpec option) {
            return this.matchedOptions.contains(option);
        }

        public boolean hasMatchedPositional(int position) {
            return this.matchedPositional(position) != null;
        }

        public boolean hasMatchedPositional(Model.PositionalParamSpec positional) {
            return this.matchedUniquePositionals.contains(positional);
        }

        public Set<Model.OptionSpec> matchedOptionsSet() {
            return Collections.unmodifiableSet(this.matchedUniqueOptions);
        }

        public List<Model.OptionSpec> matchedOptions() {
            return Collections.unmodifiableList(this.matchedOptions);
        }

        public Set<Model.PositionalParamSpec> matchedPositionalsSet() {
            return Collections.unmodifiableSet(this.matchedUniquePositionals);
        }

        public List<Model.PositionalParamSpec> matchedPositionals() {
            return Collections.unmodifiableList(this.matchedPositionals);
        }

        public List<Model.ArgSpec> matchedArgs() {
            return Collections.unmodifiableList(this.matchedArgs);
        }

        public List<String> unmatched() {
            return Collections.unmodifiableList(this.unmatched);
        }

        public List<String> originalArgs() {
            return Collections.unmodifiableList(this.originalArgs);
        }

        public List<String> expandedArgs() {
            return Collections.unmodifiableList(this.expandedArgs);
        }

        public List<Exception> errors() {
            return Collections.unmodifiableList(this.errors);
        }

        public <T> T matchedOptionValue(char shortName, T defaultValue) {
            ParseResult parseResult = this;
            return parseResult.matchedOptionValue(parseResult.matchedOption(shortName), defaultValue);
        }

        public <T> T matchedOptionValue(String name, T defaultValue) {
            ParseResult parseResult = this;
            return parseResult.matchedOptionValue(parseResult.matchedOption(name), defaultValue);
        }

        private <T> T matchedOptionValue(Model.OptionSpec option, T defaultValue) {
            if (option == null) {
                return defaultValue;
            }
            return option.getValue();
        }

        public <T> T matchedPositionalValue(int position, T defaultValue) {
            ParseResult parseResult = this;
            return parseResult.matchedPositionalValue(parseResult.matchedPositional(position), defaultValue);
        }

        private <T> T matchedPositionalValue(Model.PositionalParamSpec positional, T defaultValue) {
            if (positional == null) {
                return defaultValue;
            }
            return positional.getValue();
        }

        public boolean hasSubcommand() {
            return !this.subcommands.isEmpty();
        }

        public ParseResult subcommand() {
            if (!this.hasSubcommand()) {
                return null;
            }
            return this.subcommands.get(this.subcommands.size() - 1);
        }

        public List<ParseResult> subcommands() {
            return Collections.unmodifiableList(this.subcommands);
        }

        public boolean isUsageHelpRequested() {
            return this.usageHelpRequested;
        }

        public boolean isVersionHelpRequested() {
            return this.versionHelpRequested;
        }

        public List<CommandLine> asCommandLineList() {
            return this.recursivelyAddCommandLineTo(new ArrayList<CommandLine>());
        }

        private List<CommandLine> recursivelyAddCommandLineTo(List<CommandLine> result) {
            result.add(this.commandSpec().commandLine());
            for (ParseResult parseResult : this.subcommands()) {
                parseResult.recursivelyAddCommandLineTo(result);
            }
            return result;
        }

        void validateGroups() {
            for (Model.ArgGroupSpec argGroupSpec : this.commandSpec.argGroups()) {
                this.groupMatchContainer.updateUnmatchedGroups(argGroupSpec);
            }
            this.groupMatchContainer.validate(this.commandSpec.commandLine());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class GroupMatch {
            int position;
            final int startPosition;
            final GroupMatchContainer container;
            Map<Model.ArgGroupSpec, GroupMatchContainer> matchedSubgroups = new LinkedHashMap<Model.ArgGroupSpec, GroupMatchContainer>(2);
            Map<Model.ArgSpec, List<Object>> matchedValues = new IdentityHashMap<Model.ArgSpec, List<Object>>();
            Map<Model.ArgSpec, List<String>> originalStringValues = new LinkedHashMap<Model.ArgSpec, List<String>>();
            Map<Model.ArgSpec, Map<Integer, List<Object>>> matchedValuesAtPosition = new IdentityHashMap<Model.ArgSpec, Map<Integer, List<Object>>>();
            private GroupValidationResult validationResult;

            GroupMatch(GroupMatchContainer container) {
                this.container = container;
                if (!container.matches().isEmpty()) {
                    this.position = container.matches().get((int)(container.matches().size() - 1)).position;
                }
                this.startPosition = this.position;
            }

            public boolean isEmpty() {
                return this.originalStringValues.isEmpty() && this.matchedSubgroups.isEmpty();
            }

            public Model.ArgGroupSpec group() {
                return this.container.group;
            }

            public GroupMatchContainer container() {
                return this.container;
            }

            public Map<Model.ArgGroupSpec, GroupMatchContainer> matchedSubgroups() {
                return Collections.unmodifiableMap(this.matchedSubgroups);
            }

            int matchCount(Model.ArgSpec argSpec) {
                if (this.matchedValues.get(argSpec) == null) {
                    return 0;
                }
                return this.matchedValues.get(argSpec).size();
            }

            public List<Object> matchedValues(Model.ArgSpec argSpec) {
                if (this.matchedValues.get(argSpec) == null) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(this.matchedValues.get(argSpec));
            }

            void addOriginalStringValue(Model.ArgSpec argSpec, String value) {
                CommandLine.addValueToListInMap(this.originalStringValues, argSpec, value);
            }

            void addMatchedValue(Model.ArgSpec argSpec, int matchPosition, Object stronglyTypedValue, Tracer tracer) {
                CommandLine.addValueToListInMap(this.matchedValues, argSpec, stronglyTypedValue);
                Map<Integer, List<Object>> map = this.matchedValuesAtPosition.get(argSpec);
                if (map == null) {
                    map = new TreeMap<Integer, List<Object>>();
                    this.matchedValuesAtPosition.put(argSpec, map);
                }
                CommandLine.addValueToListInMap(map, matchPosition, stronglyTypedValue);
            }

            boolean hasMatchedValueAtPosition(Model.ArgSpec arg, int position) {
                Map<Integer, List<Object>> map = this.matchedValuesAtPosition.get(arg);
                return map != null && map.containsKey(position);
            }

            boolean matchedMinElements() {
                return this.matchedFully(false);
            }

            boolean matchedMaxElements() {
                return this.matchedFully(true);
            }

            private boolean matchedFully(boolean allRequired) {
                if (this.group().exclusive()) {
                    return !this.matchedValues.isEmpty() || this.hasFullyMatchedSubgroup(allRequired);
                }
                for (Model.ArgSpec object : this.group().args()) {
                    if (this.matchedValues.get(object) != null || !object.required() && !allRequired) continue;
                    return false;
                }
                for (Model.ArgGroupSpec argGroupSpec : this.group().subgroups()) {
                    GroupMatchContainer groupMatchContainer = this.matchedSubgroups.get(argGroupSpec);
                    if (!(groupMatchContainer != null ? !groupMatchContainer.matchedFully(allRequired) : allRequired || argGroupSpec.multiplicity().min > 0)) continue;
                    return false;
                }
                return true;
            }

            private boolean hasFullyMatchedSubgroup(boolean allRequired) {
                for (GroupMatchContainer groupMatchContainer : this.matchedSubgroups.values()) {
                    if (!groupMatchContainer.matchedFully(allRequired)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            private StringBuilder toString(StringBuilder result) {
                int n2 = result.length();
                for (Model.ArgSpec object : this.originalStringValues.keySet()) {
                    List<String> list = this.originalStringValues.get(object);
                    for (String string : list) {
                        if (result.length() != n2) {
                            result.append(" ");
                        }
                        result.append(Model.ArgSpec.describe(object, "=", string));
                    }
                }
                for (GroupMatchContainer groupMatchContainer : this.matchedSubgroups.values()) {
                    if (result.length() != n2) {
                        result.append(" ");
                    }
                    if (n2 == 0) {
                        result.append(groupMatchContainer.toString());
                        continue;
                    }
                    groupMatchContainer.toString(result);
                }
                return result;
            }

            void validate(CommandLine commandLine) {
                this.validationResult = GroupValidationResult.SUCCESS_PRESENT;
                if (this.group() != null && !this.group().validate()) {
                    return;
                }
                for (GroupMatchContainer object : this.matchedSubgroups.values()) {
                    object.validate(commandLine);
                    if (!object.validationResult.blockingFailure()) continue;
                    this.validationResult = object.validationResult;
                    return;
                }
                if (this.group() != null) {
                    this.validationResult = this.group().validateArgs(commandLine, this.matchedValues.keySet());
                    if (this.validationResult.blockingFailure()) {
                        return;
                    }
                    LinkedHashSet<Model.ArgSpec> linkedHashSet = new LinkedHashSet<Model.ArgSpec>(this.group().args());
                    LinkedHashSet<Model.ArgSpec> linkedHashSet2 = new LinkedHashSet<Model.ArgSpec>(this.group().requiredArgs());
                    LinkedHashSet<Model.ArgSpec> linkedHashSet3 = new LinkedHashSet<Model.ArgSpec>(this.matchedValues.keySet());
                    linkedHashSet2.removeAll(this.matchedValues.keySet());
                    linkedHashSet.retainAll(linkedHashSet3);
                    String string = Model.ArgSpec.describe(linkedHashSet);
                    String string2 = Model.ArgSpec.describe(this.group().requiredArgs());
                    String string3 = Model.ArgSpec.describe(linkedHashSet2);
                    LinkedHashSet<Model.ArgGroupSpec> linkedHashSet4 = new LinkedHashSet<Model.ArgGroupSpec>(this.group().subgroups());
                    linkedHashSet4.removeAll(this.matchedSubgroups.keySet());
                    int n2 = 0;
                    for (Model.ArgGroupSpec bl : linkedHashSet4) {
                        if (bl.multiplicity().min() <= 0) continue;
                        ++n2;
                        if (string3.length() > 0) {
                            string3 = string3 + " and ";
                        }
                        string3 = string3 + bl.synopsisUnit();
                    }
                    for (Model.ArgGroupSpec bl : this.group().subgroups()) {
                        if (string.length() > 0) {
                            string = string + " and ";
                        }
                        string = string + bl.synopsisUnit();
                        if (bl.multiplicity().min <= 0) continue;
                        if (string2.length() > 0) {
                            string2 = string2 + " and ";
                        }
                        string2 = string2 + bl.synopsisUnit();
                    }
                    int n3 = this.matchedValues.size() + this.matchedSubgroups.size();
                    boolean bl = !linkedHashSet2.isEmpty() || n2 > 0;
                    this.validationResult = this.group().validate(commandLine, n3, bl, n3 > 0 && bl, string, string2, string3);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class GroupMatchContainer {
            private final Model.ArgGroupSpec group;
            private GroupMatchContainer parentContainer;
            private final List<Model.ArgGroupSpec> unmatchedSubgroups = new ArrayList<Model.ArgGroupSpec>();
            private final List<GroupMatch> matches = new ArrayList<GroupMatch>();
            private GroupValidationResult validationResult;

            GroupMatchContainer(Model.ArgGroupSpec group, CommandLine cmd) {
                this.group = group;
                this.addMatch(cmd);
            }

            public Model.ArgGroupSpec group() {
                return this.group;
            }

            public List<GroupMatch> matches() {
                return Collections.unmodifiableList(this.matches);
            }

            void addMatch(CommandLine commandLine) {
                Tracer tracer;
                Tracer tracer2 = tracer = commandLine == null ? new Tracer() : commandLine.tracer;
                if (this.group != null && this.isMaxMultiplicityReached()) {
                    tracer.info("Completing GroupMatchContainer %s: max multiplicity is reached.%n", this);
                    this.complete(commandLine);
                } else {
                    if (this.group != null) {
                        tracer.info("Adding match to GroupMatchContainer %s (group=%s %s).%n", this, this.group.id(), this.group.synopsisUnit());
                    }
                    this.matches.add(new GroupMatch(this));
                    if (this.group == null) {
                        return;
                    }
                }
                this.group.initUserObject(commandLine);
            }

            void complete(CommandLine commandLine) {
                if (this.parentContainer == null) {
                    this.addMatch(commandLine);
                    return;
                }
                this.parentContainer.addMatch(commandLine);
            }

            GroupMatch lastMatch() {
                return this.matches.get(this.matches.size() - 1);
            }

            boolean isMaxMultiplicityReached() {
                return this.matches.size() >= ((Model.ArgGroupSpec)this.group).multiplicity.max;
            }

            boolean isMinMultiplicityReached() {
                return this.matches.size() >= ((Model.ArgGroupSpec)this.group).multiplicity.min;
            }

            boolean matchedMinElements() {
                return this.matchedFully(false);
            }

            boolean matchedMaxElements() {
                return this.matchedFully(true);
            }

            private boolean matchedFully(boolean allRequired) {
                for (GroupMatch groupMatch : this.matches) {
                    boolean bl;
                    if (groupMatch.matchedFully(bl = allRequired && groupMatch == this.lastMatch())) continue;
                    return false;
                }
                if (allRequired) {
                    return this.isMaxMultiplicityReached();
                }
                return this.isMinMultiplicityReached();
            }

            private GroupMatchContainer findOrCreateMatchingGroup(Model.ArgSpec argSpec, CommandLine commandLine) {
                GroupMatchContainer groupMatchContainer;
                Model.ArgGroupSpec argGroupSpec = Assert.notNull(argSpec.group(), "group for " + argSpec);
                if (argGroupSpec == (groupMatchContainer = this).group()) {
                    return groupMatchContainer;
                }
                ArrayList<Model.ArgGroupSpec> arrayList = new ArrayList<Model.ArgGroupSpec>();
                while (argGroupSpec != null) {
                    arrayList.add(argGroupSpec);
                    argGroupSpec = argGroupSpec.parentGroup();
                }
                Collections.reverse(arrayList);
                for (Model.ArgGroupSpec argGroupSpec2 : arrayList) {
                    GroupMatchContainer groupMatchContainer2 = groupMatchContainer.lastMatch().matchedSubgroups().get(argGroupSpec2);
                    if (groupMatchContainer2 == null) {
                        groupMatchContainer2 = this.createGroupMatchContainer(argGroupSpec2, groupMatchContainer, commandLine);
                    }
                    groupMatchContainer = groupMatchContainer2;
                }
                return groupMatchContainer;
            }

            private GroupMatchContainer createGroupMatchContainer(Model.ArgGroupSpec group, GroupMatchContainer parent, CommandLine commandLine) {
                GroupMatchContainer groupMatchContainer = new GroupMatchContainer(group, commandLine);
                new GroupMatchContainer(group, commandLine).parentContainer = parent;
                parent.lastMatch().matchedSubgroups.put(group, groupMatchContainer);
                return groupMatchContainer;
            }

            GroupMatchContainer trim() {
                Iterator<GroupMatch> iterator = this.matches.iterator();
                while (iterator.hasNext()) {
                    GroupMatch groupMatch = iterator.next();
                    if (groupMatch.isEmpty()) {
                        iterator.remove();
                    }
                    for (GroupMatchContainer groupMatchContainer : groupMatch.matchedSubgroups.values()) {
                        groupMatchContainer.trim();
                    }
                }
                return this;
            }

            List<GroupMatchContainer> findMatchContainers(Model.ArgGroupSpec group, List<GroupMatchContainer> result) {
                if (this.group == group) {
                    result.add(this);
                    return result;
                }
                for (GroupMatch groupMatch : this.matches()) {
                    for (GroupMatchContainer groupMatchContainer : groupMatch.matchedSubgroups.values()) {
                        groupMatchContainer.findMatchContainers(group, result);
                    }
                }
                return result;
            }

            GroupMatchContainer findLastMatchContainer(Model.ArgGroupSpec group) {
                List<GroupMatchContainer> list = this.findMatchContainers(group, new ArrayList<GroupMatchContainer>());
                if (list.isEmpty()) {
                    return null;
                }
                List<GroupMatchContainer> list2 = list;
                return list2.get(list2.size() - 1);
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            private StringBuilder toString(StringBuilder result) {
                String string;
                String string2 = result.length() == 0 ? "={" : "";
                String string3 = string = result.length() == 0 ? "}" : "";
                if (this.group != null && result.length() == 0) {
                    result.append(this.group.synopsis());
                }
                result.append(string2);
                String string4 = "";
                for (GroupMatch groupMatch : this.matches) {
                    result.append(string4);
                    groupMatch.toString(result);
                    string4 = " ";
                }
                return result.append(string);
            }

            void updateUnmatchedGroups(final Model.ArgGroupSpec group) {
                Assert.assertTrue(Assert.equals(this.group(), group.parentGroup()), new IHelpSectionRenderer(){

                    public String render(Help h2) {
                        return "Internal error: expected " + group.parentGroup() + " (the parent of " + group + "), but was " + GroupMatchContainer.this.group();
                    }
                });
                List<GroupMatchContainer> list = this.findMatchContainers(group, new ArrayList<GroupMatchContainer>());
                if (list.isEmpty()) {
                    this.unmatchedSubgroups.add(group);
                }
                for (GroupMatchContainer groupMatchContainer : list) {
                    for (Model.ArgGroupSpec argGroupSpec : group.subgroups()) {
                        groupMatchContainer.updateUnmatchedGroups(argGroupSpec);
                    }
                }
            }

            void validate(CommandLine commandLine) {
                if (this.group() == null && this.matches.size() > 1) {
                    GroupMatchContainer groupMatchContainer = this;
                    groupMatchContainer.failGroupMultiplicityExceeded(groupMatchContainer.matches, commandLine);
                }
                this.validationResult = this.matches.isEmpty() ? GroupValidationResult.SUCCESS_ABSENT : GroupValidationResult.SUCCESS_PRESENT;
                for (Model.ArgGroupSpec object : this.unmatchedSubgroups) {
                    String string;
                    if (!object.validate() || object.multiplicity().min <= 0) continue;
                    String string2 = object.synopsisUnit();
                    String string3 = string = object.synopsisUnit();
                    this.validationResult = object.validate(commandLine, 0, true, false, string2, string3, string3);
                }
                this.validateGroupMultiplicity(commandLine);
                if (this.validationResult.blockingFailure()) {
                    commandLine.interpreter.maybeThrow(this.validationResult.exception);
                }
                for (GroupMatch groupMatch : this.matches()) {
                    groupMatch.validate(commandLine);
                    if (!groupMatch.validationResult.blockingFailure()) continue;
                    this.validationResult = groupMatch.validationResult;
                    break;
                }
                if (this.validationResult.blockingFailure()) {
                    commandLine.interpreter.maybeThrow(this.validationResult.exception);
                }
                if (this.group() == null && !this.validationResult.success()) {
                    commandLine.interpreter.maybeThrow(this.validationResult.exception);
                }
            }

            private void failGroupMultiplicityExceeded(List<GroupMatch> groupMatches, CommandLine commandLine) {
                LinkedHashMap<Model.ArgGroupSpec, List<List<GroupMatch>>> linkedHashMap = new LinkedHashMap<Model.ArgGroupSpec, List<List<GroupMatch>>>();
                String string = "";
                for (GroupMatch groupMatch : groupMatches) {
                    if (string.length() > 0) {
                        string = string + " and ";
                    }
                    string = string + groupMatch;
                    Map<Model.ArgGroupSpec, GroupMatchContainer> map = groupMatch.matchedSubgroups();
                    for (Model.ArgGroupSpec argGroupSpec : map.keySet()) {
                        if (!argGroupSpec.validate()) continue;
                        CommandLine.addValueToListInMap(linkedHashMap, argGroupSpec, map.get(argGroupSpec).matches());
                    }
                }
                if (!linkedHashMap.isEmpty() && !this.simplifyErrorMessageForSingleGroup(linkedHashMap, commandLine)) {
                    commandLine.interpreter.maybeThrow(new MaxValuesExceededException(commandLine, "Error: expected only one match but got " + string));
                }
            }

            private boolean simplifyErrorMessageForSingleGroup(Map<Model.ArgGroupSpec, List<List<GroupMatch>>> matchesPerGroup, CommandLine commandLine) {
                for (Model.ArgGroupSpec argGroupSpec : matchesPerGroup.keySet()) {
                    List<GroupMatch> list = CommandLine.flatList((Collection)matchesPerGroup.get(argGroupSpec));
                    LinkedHashSet<Model.ArgSpec> linkedHashSet = new LinkedHashSet<Model.ArgSpec>();
                    for (GroupMatch groupMatch : list) {
                        if (!groupMatch.matchedSubgroups().isEmpty()) {
                            return false;
                        }
                        linkedHashSet.addAll(groupMatch.matchedValues.keySet());
                    }
                    GroupValidationResult groupValidationResult = argGroupSpec.validateArgs(commandLine, linkedHashSet);
                    if (groupValidationResult.exception == null) continue;
                    commandLine.interpreter.maybeThrow(groupValidationResult.exception);
                    return true;
                }
                return false;
            }

            private void validateGroupMultiplicity(CommandLine commandLine) {
                if (this.group == null || !this.group.validate()) {
                    return;
                }
                int n2 = this.matches().size();
                boolean bl = n2 > 0 || !this.group.args().isEmpty();
                if (bl && n2 < this.group.multiplicity().min) {
                    if (this.validationResult.success()) {
                        this.validationResult = new GroupValidationResult(n2 == 0 ? GroupValidationResult.Type.FAILURE_ABSENT : GroupValidationResult.Type.FAILURE_PARTIAL, new MissingParameterException(commandLine, this.group.args(), "Error: Group: " + this.group.synopsisUnit() + " must be specified " + this.group.multiplicity().min + " times but was matched " + n2 + " times"));
                        return;
                    }
                } else if (n2 > this.group.multiplicity().max && !this.validationResult.blockingFailure()) {
                    this.validationResult = new GroupValidationResult(GroupValidationResult.Type.FAILURE_PRESENT, new MaxValuesExceededException(commandLine, "Error: Group: " + this.group.synopsisUnit() + " can only be specified " + this.group.multiplicity().max + " times but was matched " + n2 + " times."));
                }
            }

            boolean canMatchPositionalParam(Model.PositionalParamSpec positionalParam) {
                boolean bl = !this.matches.isEmpty() && this.lastMatch().matchedMinElements();
                boolean bl2 = !this.matches.isEmpty() && this.lastMatch().matchedMaxElements();
                if (bl2 && this.isMaxMultiplicityReached()) {
                    return false;
                }
                int n2 = this.matches.isEmpty() ? 0 : this.lastMatch().startPosition;
                int n3 = this.matches.isEmpty() ? 0 : this.lastMatch().position;
                int n4 = n3 - n2;
                if (bl) {
                    int n5 = positionalParam.group().localPositionalParamCount();
                    n4 %= n5;
                }
                return positionalParam.index().contains(n4) && !this.lastMatch().hasMatchedValueAtPosition(positionalParam, n3);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class GroupValidationResult {
            static final GroupValidationResult SUCCESS_PRESENT = new GroupValidationResult(Type.SUCCESS_PRESENT);
            static final GroupValidationResult SUCCESS_ABSENT = new GroupValidationResult(Type.SUCCESS_ABSENT);
            Type type;
            ParameterException exception;

            GroupValidationResult(Type type) {
                this.type = type;
            }

            GroupValidationResult(Type type, ParameterException exception) {
                this.type = type;
                this.exception = exception;
            }

            static GroupValidationResult extractBlockingFailure(List<GroupValidationResult> set) {
                for (GroupValidationResult groupValidationResult : set) {
                    if (!groupValidationResult.blockingFailure()) continue;
                    return groupValidationResult;
                }
                return null;
            }

            boolean blockingFailure() {
                return this.type == Type.FAILURE_PRESENT || this.type == Type.FAILURE_PARTIAL;
            }

            boolean present() {
                return this.type == Type.SUCCESS_PRESENT;
            }

            boolean success() {
                return this.type == Type.SUCCESS_ABSENT || this.type == Type.SUCCESS_PRESENT;
            }

            public String toString() {
                return (Object)((Object)this.type) + (this.exception == null ? "" : ": " + this.exception.getMessage());
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum Type {
                SUCCESS_PRESENT,
                SUCCESS_ABSENT,
                FAILURE_PRESENT,
                FAILURE_ABSENT,
                FAILURE_PARTIAL;

            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Builder {
            private final Model.CommandSpec commandSpec;
            private final List<Model.ArgSpec> matchedArgsList = new ArrayList<Model.ArgSpec>();
            private final List<Model.OptionSpec> matchedOptionsList = new ArrayList<Model.OptionSpec>();
            private final List<Model.PositionalParamSpec> matchedPositionalsList = new ArrayList<Model.PositionalParamSpec>();
            private final Set<Model.OptionSpec> options = new LinkedHashSet<Model.OptionSpec>();
            private final Set<Model.PositionalParamSpec> positionals = new LinkedHashSet<Model.PositionalParamSpec>();
            private final List<String> unmatched = new ArrayList<String>();
            private final List<String> originalArgList = new ArrayList<String>();
            private final List<String> expandedArgList = new ArrayList<String>();
            private final List<List<Model.PositionalParamSpec>> positionalParams = new ArrayList<List<Model.PositionalParamSpec>>();
            private final List<ParseResult> subcommands = new ArrayList<ParseResult>();
            private boolean usageHelpRequested;
            private boolean versionHelpRequested;
            boolean isInitializingDefaultValues;
            private final List<Exception> errors = new ArrayList<Exception>(1);
            private List<Object> nowProcessing;
            private final GroupMatchContainer groupMatchContainer = new GroupMatchContainer(null, null);

            private Builder(Model.CommandSpec spec) {
                this.commandSpec = Assert.notNull(spec, "commandSpec");
            }

            public ParseResult build() {
                return new ParseResult(this);
            }

            private void nowProcessing(Model.ArgSpec spec, Object value) {
                if (this.nowProcessing != null && !this.isInitializingDefaultValues) {
                    this.nowProcessing.add(spec.isPositional() ? spec : value);
                }
            }

            public Builder add(Model.ArgSpec arg, int position) {
                if (arg.isOption()) {
                    this.addOption((Model.OptionSpec)arg);
                } else {
                    this.addPositionalParam((Model.PositionalParamSpec)arg, position);
                }
                return this;
            }

            public Builder addOption(Model.OptionSpec option) {
                if (!this.isInitializingDefaultValues) {
                    this.options.add(option);
                    this.matchedOptionsList.add(option);
                    this.matchedArgsList.add(option);
                }
                return this;
            }

            public Builder addPositionalParam(Model.PositionalParamSpec positionalParam, int position) {
                if (this.isInitializingDefaultValues) {
                    return this;
                }
                this.positionals.add(positionalParam);
                this.matchedPositionalsList.add(positionalParam);
                this.matchedArgsList.add(positionalParam);
                while (this.positionalParams.size() <= position) {
                    this.positionalParams.add(new ArrayList());
                }
                this.positionalParams.get(position).add(positionalParam);
                return this;
            }

            public Builder addUnmatched(String arg) {
                this.unmatched.add(arg);
                return this;
            }

            public Builder addUnmatched(Stack<String> args) {
                while (!args.isEmpty()) {
                    this.addUnmatched(args.pop());
                }
                return this;
            }

            public Builder subcommand(ParseResult subcommand) {
                this.subcommands.add(0, subcommand);
                return this;
            }

            public Builder originalArgs(String[] originalArgs) {
                this.originalArgList.addAll(Arrays.asList(originalArgs));
                return this;
            }

            public Builder expandedArgs(Collection<String> expandedArgs) {
                this.expandedArgList.addAll(expandedArgs);
                return this;
            }

            void addStringValue(Model.ArgSpec argSpec, String value) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.stringValues.add(value);
                }
            }

            void addOriginalStringValue(Model.ArgSpec argSpec, String value) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.originalStringValues.add(value);
                    if (argSpec.group() != null) {
                        GroupMatchContainer groupMatchContainer = this.groupMatchContainer.findLastMatchContainer(argSpec.group());
                        groupMatchContainer.lastMatch().addOriginalStringValue(argSpec, value);
                    }
                }
            }

            void addTypedValues(Model.ArgSpec argSpec, int position, Object typedValue) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.typedValues.add(typedValue);
                    if (argSpec.group() == null) {
                        argSpec.typedValueAtPosition.put(position, typedValue);
                        return;
                    }
                    GroupMatchContainer groupMatchContainer = this.groupMatchContainer.findLastMatchContainer(argSpec.group());
                    groupMatchContainer.lastMatch().addMatchedValue(argSpec, position, typedValue, this.commandSpec.commandLine.tracer);
                }
            }

            public void addError(PicocliException ex) {
                this.errors.add(Assert.notNull(ex, "exception"));
            }

            void beforeMatchingGroupElement(Model.ArgSpec argSpec) throws Exception {
                Model.ArgGroupSpec argGroupSpec = argSpec.group();
                if (argGroupSpec == null || this.isInitializingDefaultValues) {
                    return;
                }
                Tracer tracer = this.commandSpec.commandLine.tracer;
                GroupMatchContainer groupMatchContainer = this.groupMatchContainer.findOrCreateMatchingGroup(argSpec, this.commandSpec.commandLine);
                GroupMatch groupMatch = groupMatchContainer.lastMatch();
                boolean bl = argSpec.isMultiValue();
                String string = Model.ArgSpec.describe(argSpec, "=");
                if (groupMatch.matchedMinElements() && (argSpec.required() || groupMatch.matchCount(argSpec) > 0) && !bl) {
                    String string2 = argSpec.required() ? "is required" : "has already been matched";
                    tracer.info("GroupMatch %s is complete: its mandatory elements are all matched. (User object: %s.) %s %s in the group, so it starts a new GroupMatch.%n", groupMatchContainer.lastMatch(), groupMatchContainer.group.userObject(), string, string2);
                    groupMatchContainer.addMatch(this.commandSpec.commandLine);
                    this.groupMatchContainer.findOrCreateMatchingGroup(argSpec, this.commandSpec.commandLine);
                    return;
                }
                if (groupMatch.matchCount(argSpec) > 0 && !bl) {
                    tracer.info("GroupMatch %s is incomplete: its mandatory elements are not all matched. (User object: %s.) However, %s has already been matched in the group, so it starts a new GroupMatch.%n", groupMatchContainer.lastMatch(), groupMatchContainer.group.userObject(), string);
                    groupMatchContainer.addMatch(this.commandSpec.commandLine);
                    this.groupMatchContainer.findOrCreateMatchingGroup(argSpec, this.commandSpec.commandLine);
                }
            }
        }
    }

    public static final class Model {
        private Model() {
        }

        private static boolean initializable(Object current, Object candidate, Object defaultValue) {
            return current == null && Model.isNonDefault(candidate, defaultValue);
        }

        private static boolean initializable(Object current, Object[] candidate, Object[] defaultValue) {
            return current == null && Model.isNonDefault(candidate, defaultValue);
        }

        private static boolean isNonDefault(Object candidate, Object defaultValue) {
            return !Assert.notNull(defaultValue, "defaultValue").equals(candidate);
        }

        private static boolean isNonDefault(Object[] candidate, Object[] defaultValue) {
            return !Arrays.equals(Assert.notNull(defaultValue, "defaultValue"), candidate);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Interpolator {
            private final CommandSpec commandSpec;
            private final Map<String, ILookup> lookups = new LinkedHashMap<String, ILookup>();

            public Interpolator(final CommandSpec commandSpec) {
                this.commandSpec = commandSpec;
                this.lookups.put("sys:", new ILookup(){

                    public String get(String key) {
                        return System.getProperty(key);
                    }
                });
                this.lookups.put("env:", new ILookup(){

                    public String get(String key) {
                        return System.getenv(key);
                    }
                });
                this.lookups.put("bundle:", new ILookup(){

                    public String get(String key) {
                        return Interpolator.bundleValue(commandSpec.resourceBundle(), key);
                    }
                });
                this.lookups.put("", new ILookup(){

                    public String get(String key) {
                        String string;
                        if (("COMMAND-NAME".equals(key) ? commandSpec.name() : ("COMMAND-FULL-NAME".equals(key) ? commandSpec.qualifiedName() : ("PARENT-COMMAND-NAME".equals(key) && commandSpec.parent() != null ? commandSpec.parent().name() : ("PARENT-COMMAND-FULL-NAME".equals(key) && commandSpec.parent() != null ? commandSpec.parent().qualifiedName() : (string = "ROOT-COMMAND-NAME".equals(key) ? commandSpec.root().name() : null))))) == null) {
                            string = System.getProperty(key);
                        }
                        if (string == null) {
                            string = System.getenv(key);
                        }
                        if (string == null) {
                            string = Interpolator.bundleValue(commandSpec.resourceBundle(), key);
                        }
                        return string;
                    }
                });
            }

            private static String bundleValue(ResourceBundle rb, String key) {
                if (rb != null) {
                    try {
                        return rb.getString(key);
                    }
                    catch (MissingResourceException missingResourceException) {
                        return null;
                    }
                }
                return null;
            }

            public String[] interpolate(String[] values) {
                if (values == null || values.length == 0) {
                    return values;
                }
                String[] stringArray = new String[values.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = this.interpolate(values[i2]);
                }
                return stringArray;
            }

            public String interpolate(String original) {
                if (original == null || !this.commandSpec.interpolateVariables()) {
                    return original;
                }
                return this.resolveLookups(original, new HashSet<String>(), new HashMap<String, String>());
            }

            public String interpolateCommandName(String original) {
                if (original == null || !this.commandSpec.interpolateVariables()) {
                    return original;
                }
                return this.resolveLookups(original, new HashSet<String>(), new HashMap<String, String>());
            }

            private String resolveLookups(String text, Set<String> visited, Map<String, String> resolved) {
                if (text == null) {
                    return null;
                }
                for (String string : this.lookups.keySet()) {
                    ILookup iLookup = this.lookups.get(string);
                    String string2 = "${" + string;
                    int n2 = 0;
                    while ((n2 = this.findOpeningDollar(text, string2, n2)) >= 0) {
                        String string3;
                        String string4;
                        int n3 = this.findClosingBrace(text, n2 + string2.length());
                        if (n3 < 0) {
                            n3 = text.length() - 1;
                        }
                        String string5 = string4 = text.substring(n2 + string2.length(), n3);
                        int n4 = string4.indexOf(":-");
                        if (n4 >= 0) {
                            string5 = string4.substring(0, n4);
                        }
                        String string6 = string3 = resolved.containsKey(string2 + string5) ? resolved.get(string2 + string5) : iLookup.get(string5);
                        if (visited.contains(string2 + string5) && !resolved.containsKey(string2 + string5)) {
                            throw new InitializationException("Lookup '" + string2 + string5 + "' has a circular reference.");
                        }
                        visited.add(string2 + string5);
                        if (string3 == null && n4 >= 0) {
                            String string7 = string4.substring(n4 + 2);
                            string3 = this.resolveLookups(string7, visited, resolved);
                        }
                        resolved.put(string2 + string5, string3);
                        if (string3 == null && n2 == 0 && n3 == text.length() - 1) {
                            return null;
                        }
                        text = text.substring(0, n2) + string3 + text.substring(n3 + 1);
                        n2 += string3 == null ? 4 : string3.length();
                    }
                }
                return text.replace("$$", "$");
            }

            private int findOpeningDollar(String text, String prefix, int start) {
                int n2;
                int n3 = -1;
                boolean bl = false;
                for (int i2 = start; i2 < text.length(); i2 += Character.charCount(n2)) {
                    n2 = text.codePointAt(i2);
                    if (n2 == 36) {
                        n3 = bl ? -1 : i2;
                        bl = !bl;
                    } else {
                        bl = false;
                    }
                    if (n3 != -1 && n2 != prefix.codePointAt(i2 - n3)) {
                        n3 = -1;
                    }
                    if (n3 == -1 || i2 - n3 != prefix.length() - 1) continue;
                    return n3;
                }
                return -1;
            }

            private int findClosingBrace(String text, int start) {
                int n2;
                int n3 = 1;
                boolean bl = false;
                block5: for (int i2 = start; i2 < text.length(); i2 += Character.charCount(n2)) {
                    n2 = text.codePointAt(i2);
                    switch (n2) {
                        case 92: {
                            bl = !bl;
                            continue block5;
                        }
                        case 125: {
                            if (!bl) {
                                --n3;
                            }
                            if (n3 == 0) {
                                return i2;
                            }
                            bl = false;
                            continue block5;
                        }
                        case 123: {
                            if (!bl) {
                                ++n3;
                            }
                            bl = false;
                            continue block5;
                        }
                        default: {
                            bl = false;
                        }
                    }
                }
                return -1;
            }

            static interface ILookup {
                public String get(String var1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CommandUserObject
        implements IScope {
            private final IFactory factory;
            private Object instance;
            private Class<?> type;
            private CommandSpec commandSpec;

            private CommandUserObject(Object objectOrClass, IFactory factory) {
                this.factory = Assert.notNull(factory, "factory");
                this.type = objectOrClass == null ? null : objectOrClass.getClass();
                this.instance = objectOrClass;
                if (objectOrClass instanceof Class) {
                    this.type = (Class)objectOrClass;
                    this.instance = null;
                    return;
                }
                if (objectOrClass instanceof Method) {
                    this.type = null;
                }
            }

            public String toString() {
                if (this.type == null && this.instance == null) {
                    return "null";
                }
                if (this.type == null) {
                    return String.valueOf(this.instance);
                }
                if (this.instance == null) {
                    return String.valueOf(this.type);
                }
                return this.type.getName() + "@" + Integer.toHexString(System.identityHashCode(this.instance));
            }

            public CommandUserObject copy() {
                return new CommandUserObject(this.type == null ? this.instance : this.type, this.factory);
            }

            public static CommandUserObject create(Object userObject, IFactory factory) {
                if (userObject instanceof CommandUserObject) {
                    return (CommandUserObject)userObject;
                }
                return new CommandUserObject(userObject, factory);
            }

            public Object getInstance() {
                if (this.instance == null) {
                    Tracer tracer = new Tracer();
                    if (this.type == null) {
                        tracer.debug("Returning a null user object instance%n", new Object[0]);
                        return null;
                    }
                    try {
                        tracer.debug("Getting a %s instance from factory %s%n", this.type.getName(), this.factory);
                        this.instance = DefaultFactory.create(this.factory, this.type);
                        this.type = this.instance.getClass();
                        tracer.debug("Factory returned a %s instance (%s)%n", this.type.getName(), Integer.toHexString(System.identityHashCode(this.instance)));
                    }
                    catch (InitializationException initializationException) {
                        if (this.type.isInterface()) {
                            tracer.debug("%s. Creating Proxy for interface %s%n", initializationException.getCause(), this.type.getName());
                            this.instance = Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, (InvocationHandler)new PicocliInvocationHandler());
                            tracer.debug("Created Proxy instance (%s)%n", Integer.toHexString(System.identityHashCode(this.instance)));
                        }
                        throw initializationException;
                    }
                    if (this.commandSpec != null) {
                        for (ArgSpec argSpec : this.commandSpec.args()) {
                            if (argSpec.group() != null || argSpec.hasInitialValue()) continue;
                            argSpec.initialValue();
                        }
                    }
                }
                return this.instance;
            }

            public Class<?> getType() {
                return this.type;
            }

            public boolean isMethod() {
                return this.instance instanceof Method;
            }

            @Override
            public <T> T get() {
                return (T)this.getInstance();
            }

            @Override
            public <T> T set(T value) {
                throw new UnsupportedOperationException();
            }

            public boolean isProxyClass() {
                if (this.type == null || !this.type.isInterface()) {
                    return false;
                }
                return Proxy.isProxyClass(this.getInstance().getClass());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ObjectScope
        implements IScope {
            private Object value;

            public ObjectScope(Object value) {
                this.value = value;
            }

            public static boolean isProxyClass(IScope scope) {
                if (scope instanceof CommandUserObject) {
                    return ((CommandUserObject)scope).isProxyClass();
                }
                Object object = ObjectScope.tryGet(scope);
                return object != null && Proxy.isProxyClass(object.getClass());
            }

            public static boolean hasInstance(IScope scope) {
                if (scope instanceof CommandUserObject) {
                    return ((CommandUserObject)scope).instance != null;
                }
                return ObjectScope.tryGet(scope) != null;
            }

            @Override
            public <T> T get() {
                return (T)this.value;
            }

            @Override
            public <T> T set(T value) {
                Object object = this.value;
                this.value = value;
                return (T)object;
            }

            public static Object tryGet(IScope scope) {
                try {
                    return scope.get();
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not get scope value", exception);
                }
            }

            static IScope asScope(Object scope) {
                if (scope instanceof IScope) {
                    return (IScope)scope;
                }
                return new ObjectScope(scope);
            }

            public String toString() {
                return String.format("Scope(value=%s)", this.value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ObjectBinding
        implements IGetter,
        ISetter {
            private Object value;

            private ObjectBinding() {
            }

            @Override
            public <T> T get() {
                return (T)this.value;
            }

            @Override
            public <T> T set(T value) {
                T t2 = value;
                this.value = value;
                return t2;
            }

            public String toString() {
                return String.format("%s(value=%s)", this.getClass().getSimpleName(), this.value);
            }
        }

        private static class PicocliInvocationHandler
        implements InvocationHandler {
            final Map<String, Object> map = new HashMap<String, Object>();

            private PicocliInvocationHandler() {
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return this.map.get(method.getName());
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ProxyBinding
            implements IGetter,
            ISetter {
                private final Method method;

                ProxyBinding(Method method) {
                    this.method = Assert.notNull(method, "method");
                }

                @Override
                public <T> T get() {
                    return (T)PicocliInvocationHandler.this.map.get(this.method.getName());
                }

                @Override
                public <T> T set(T value) {
                    T t2 = this.get();
                    PicocliInvocationHandler.this.map.put(this.method.getName(), value);
                    return t2;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MethodBinding
        implements IGetter,
        ISetter {
            private final IScope scope;
            private final Method method;
            private final CommandSpec spec;
            private Object currentValue;

            MethodBinding(IScope scope, Method method, CommandSpec spec) {
                this.scope = scope;
                this.method = method;
                this.spec = spec;
            }

            @Override
            public <T> T get() {
                return (T)this.currentValue;
            }

            @Override
            public <T> T set(T value) throws PicocliException {
                Object t2;
                try {
                    t2 = this.scope.get();
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get scope for method " + this.method, exception);
                }
                try {
                    Object object = this.currentValue;
                    this.method.invoke(t2, value);
                    this.currentValue = value;
                    return (T)object;
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    if (invocationTargetException.getTargetException() instanceof PicocliException) {
                        throw (PicocliException)invocationTargetException2.getTargetException();
                    }
                    throw this.createParameterException(value, invocationTargetException2.getTargetException());
                }
                catch (Exception exception) {
                    throw this.createParameterException(value, exception);
                }
            }

            private ParameterException createParameterException(Object value, Throwable t2) {
                CommandLine commandLine = this.spec.commandLine() == null ? new CommandLine(this.spec) : this.spec.commandLine();
                return new ParameterException(commandLine, "Could not invoke " + this.method + " with " + value + " (" + t2 + ")", t2);
            }

            public String toString() {
                return String.format("%s(%s)", this.getClass().getSimpleName(), this.method);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FieldBinding
        implements IGetter,
        ISetter {
            private final IScope scope;
            private final Field field;

            FieldBinding(Object scope, Field field) {
                this(ObjectScope.asScope(scope), field);
            }

            FieldBinding(IScope scope, Field field) {
                this.scope = scope;
                this.field = field;
            }

            @Override
            public <T> T get() throws PicocliException {
                Object t2;
                try {
                    t2 = this.scope.get();
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get scope for field " + this.field, exception);
                }
                try {
                    Object object = this.field.get(t2);
                    return (T)object;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get value for field " + this.field, exception);
                }
            }

            @Override
            public <T> T set(T value) throws PicocliException {
                Object t2;
                try {
                    t2 = this.scope.get();
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get scope for field " + this.field, exception);
                }
                try {
                    Object object = this.field.get(t2);
                    this.field.set(t2, value);
                    return (T)object;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not set value for field " + this.field + " to " + value, exception);
                }
            }

            public String toString() {
                return String.format("%s(%s %s.%s)", this.getClass().getSimpleName(), this.field.getType().getName(), this.field.getDeclaringClass().getName(), this.field.getName());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CommandReflection {
            private CommandReflection() {
            }

            static ArgGroupSpec extractArgGroupSpec(IAnnotatedElement member, IFactory factory, CommandSpec commandSpec, boolean annotationsAreMandatory) throws Exception {
                Class<Object> clazz;
                Object object = null;
                try {
                    object = member.getter().get();
                }
                catch (Exception exception) {}
                Class<Object> clazz2 = clazz = object == null ? member.getTypeInfo().getType() : object.getClass();
                if (member.isMultiValue()) {
                    clazz = member.getTypeInfo().getAuxiliaryTypes()[0];
                }
                ObjectScope objectScope = new ObjectScope(object);
                ArgGroupSpec.Builder builder = ArgGroupSpec.builder(member);
                builder.updateArgGroupAttributes(member.getAnnotation(ArgGroup.class));
                if (member.isOption() || member.isParameter()) {
                    if (member instanceof TypedMember) {
                        CommandReflection.validateArgSpecMember((TypedMember)member);
                    }
                    builder.addArg(CommandReflection.buildArgForMember(member, factory));
                }
                Stack<Class> stack = new Stack<Class>();
                while (clazz != null) {
                    stack.add(clazz);
                    clazz = clazz.getSuperclass();
                }
                boolean bl = false;
                while (!stack.isEmpty()) {
                    clazz = (Class<Object>)stack.pop();
                    bl |= CommandReflection.initFromAnnotatedFields(objectScope, clazz, commandSpec, builder, factory, null);
                }
                ArgGroupSpec argGroupSpec = builder.build();
                if (annotationsAreMandatory) {
                    CommandReflection.validateArgGroupSpec(argGroupSpec, bl, clazz.getName());
                }
                return argGroupSpec;
            }

            static CommandSpec extractCommandSpec(Object command, IFactory factory, boolean annotationsAreMandatory) {
                Assert.notNull(command, "command user object");
                Tracer tracer = new Tracer();
                if (command instanceof CommandSpec) {
                    tracer.debug("extractCommandSpec returning existing CommandSpec instance %s%n", command);
                    return (CommandSpec)command;
                }
                CommandUserObject commandUserObject = CommandUserObject.create(command, factory);
                tracer.debug("Creating CommandSpec for %s with factory %s%n", commandUserObject, factory.getClass().getName());
                CommandSpec commandSpec = CommandSpec.wrapWithoutInspection(commandUserObject);
                boolean bl = false;
                if (commandUserObject.isMethod()) {
                    Method method = (Method)command;
                    tracer.debug("Using method %s as command %n", method);
                    method.setAccessible(true);
                    Command command2 = method.getAnnotation(Command.class);
                    commandSpec.updateCommandAttributes(command2, factory);
                    CommandReflection.injectSpecIntoVersionProvider(commandSpec, command2, factory);
                    commandSpec.setAddMethodSubcommands(Boolean.FALSE);
                    CommandReflection.initSubcommands(command2, null, commandSpec, factory, new Stack());
                    bl = true;
                    commandSpec.mixinStandardHelpOptions(method.getAnnotation(Command.class).mixinStandardHelpOptions());
                    CommandReflection.initFromMethodParameters(commandUserObject, method, commandSpec, null, factory);
                    commandSpec.initName(((Method)command).getName());
                } else {
                    Class clazz;
                    Stack<Class> stack = new Stack<Class>();
                    for (clazz = commandUserObject.getType(); clazz != null; clazz = clazz.getSuperclass()) {
                        stack.add(clazz);
                    }
                    Stack stack2 = (Stack)stack.clone();
                    boolean bl2 = false;
                    while (!stack.isEmpty()) {
                        clazz = (Class)stack.pop();
                        Command command3 = clazz.getAnnotation(Command.class);
                        if (command3 != null) {
                            commandSpec.updateCommandAttributes(command3, factory);
                            CommandReflection.injectSpecIntoVersionProvider(commandSpec, command3, factory);
                            CommandReflection.initSubcommands(command3, clazz, commandSpec, factory, stack2);
                            bl = true;
                        }
                        CommandReflection.initMethodSubcommands(clazz, commandSpec, factory);
                        bl |= CommandReflection.initFromAnnotatedFields(commandUserObject, clazz, commandSpec, null, factory, null);
                        if (!clazz.isAnnotationPresent(Command.class)) continue;
                        bl2 |= clazz.getAnnotation(Command.class).mixinStandardHelpOptions();
                    }
                    commandSpec.mixinStandardHelpOptions(bl2);
                }
                commandSpec.updateArgSpecMessages();
                if (annotationsAreMandatory) {
                    CommandReflection.validateCommandSpec(commandSpec, bl, commandUserObject.toString());
                }
                commandSpec.validate();
                return commandSpec;
            }

            private static void injectSpecIntoVersionProvider(CommandSpec result, Command cmd, IFactory factory) {
                if (result.versionProvider() == null) {
                    return;
                }
                CommandReflection.initFromAnnotatedFields(new ObjectScope(result.versionProvider()), cmd.versionProvider(), result, null, factory, new Predicate<TypedMember>(){

                    @Override
                    public final boolean test(TypedMember tm) {
                        return tm.isSpec() && !tm.isArgGroup() && !tm.isUnmatched() && !tm.isMixin() && !tm.isOption() && !tm.isParameter() && !tm.isParentCommand();
                    }
                });
            }

            private static void initSubcommands(Command cmd, Class<?> cls, CommandSpec parent, IFactory factory, Stack<Class<?>> hierarchy) {
                for (Class<?> clazz : cmd.subcommands()) {
                    Object object;
                    if (clazz.equals(cls)) {
                        throw new InitializationException(cmd.name() + " (" + cls.getName() + ") cannot be a subcommand of itself");
                    }
                    if (hierarchy.contains(clazz)) {
                        throw new InitializationException(cmd.name() + " (" + cls.getName() + ") has a subcommand (" + clazz.getName() + ") that is a subclass of itself");
                    }
                    try {
                        if (Help.class == clazz) {
                            throw new InitializationException(Help.class.getName() + " is not a valid subcommand. Did you mean " + HelpCommand.class.getName() + "?");
                        }
                        object = CommandLine.toCommandLine(clazz, factory);
                        parent.addSubcommand(CommandReflection.subcommandName(clazz), (CommandLine)object);
                        ((CommandLine)object).getCommandSpec().injectParentCommand(parent.userObject);
                        for (CommandSpec commandSpec : ((CommandLine)object).getCommandSpec().mixins().values()) {
                            commandSpec.injectParentCommand(parent.userObject);
                        }
                    }
                    catch (InitializationException initializationException) {
                        object = initializationException;
                        throw initializationException;
                    }
                    catch (Exception exception) {
                        throw new InitializationException("Could not instantiate and add subcommand " + clazz.getName() + ": " + exception, exception);
                    }
                }
            }

            private static void initMethodSubcommands(Class<?> cls, CommandSpec parent, IFactory factory) {
                if (parent.isAddMethodSubcommands() && cls != null) {
                    for (CommandLine commandLine : CommandSpec.createMethodSubcommands(cls, factory, false)) {
                        parent.addSubcommand(commandLine.getCommandName(), commandLine);
                        for (CommandSpec commandSpec : commandLine.getCommandSpec().mixins().values()) {
                            commandSpec.injectParentCommand(parent.userObject);
                        }
                    }
                }
            }

            private static String subcommandName(Class<?> sub) {
                Command command = sub.getAnnotation(Command.class);
                if (command == null || "<main class>".equals(command.name())) {
                    throw new InitializationException("Subcommand " + sub.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                }
                return command.name();
            }

            private static boolean initFromAnnotatedFields(IScope scope, Class<?> cls, CommandSpec receiver, ArgGroupSpec.Builder groupBuilder, IFactory factory, Predicate<TypedMember> predicate) {
                boolean bl = false;
                for (Field accessibleObject : cls.getDeclaredFields()) {
                    bl |= CommandReflection.initFromAnnotatedTypedMembers(TypedMember.createIfAnnotated(accessibleObject, scope), predicate, receiver, groupBuilder, factory);
                }
                for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                    bl |= CommandReflection.initFromAnnotatedTypedMembers(TypedMember.createIfAnnotated((Method)accessibleObject, scope, receiver), predicate, receiver, groupBuilder, factory);
                }
                return bl;
            }

            private static boolean initFromAnnotatedTypedMembers(TypedMember member, Predicate<TypedMember> predicate, CommandSpec commandSpec, ArgGroupSpec.Builder groupBuilder, IFactory factory) {
                if (member == null || predicate != null && !predicate.test(member)) {
                    return false;
                }
                boolean bl = false;
                if (member.isMixin()) {
                    CommandReflection.assertNoDuplicateAnnotations(member, Mixin.class, Option.class, Parameters.class, Unmatched.class, Spec.class, ArgGroup.class);
                    if (groupBuilder != null) {
                        throw new InitializationException("@Mixins are not supported on @ArgGroups");
                    }
                    CommandSpec commandSpec2 = CommandReflection.buildMixinForMember(member, factory);
                    commandSpec.addMixin(member.getMixinName(), commandSpec2, member);
                    for (IAnnotatedElement iAnnotatedElement : commandSpec2.specElements) {
                        if (iAnnotatedElement.getAnnotation(Spec.class).value() != Spec.Target.MIXEE) continue;
                        try {
                            iAnnotatedElement.setter().set(commandSpec);
                        }
                        catch (Exception exception) {
                            throw new InitializationException("Could not inject MIXEE spec", exception);
                        }
                    }
                    bl = true;
                }
                if (member.isArgGroup()) {
                    CommandReflection.assertNoDuplicateAnnotations(member, ArgGroup.class, Spec.class, Parameters.class, Option.class, Unmatched.class, Mixin.class);
                    if (groupBuilder != null) {
                        groupBuilder.addSubgroup(CommandReflection.buildArgGroupForMember(member, factory, commandSpec));
                    } else {
                        commandSpec.addArgGroup(CommandReflection.buildArgGroupForMember(member, factory, commandSpec));
                    }
                    return true;
                }
                if (member.isUnmatched()) {
                    CommandReflection.assertNoDuplicateAnnotations(member, Unmatched.class, Mixin.class, Option.class, Parameters.class, Spec.class, ArgGroup.class);
                    if (groupBuilder != null) {
                        throw new InitializationException("@Unmatched are not supported on @ArgGroups");
                    }
                    commandSpec.addUnmatchedArgsBinding(CommandReflection.buildUnmatchedForMember(member));
                }
                if (member.isArgSpec()) {
                    CommandReflection.validateArgSpecMember(member);
                    if (groupBuilder != null) {
                        groupBuilder.addArg(CommandReflection.buildArgForMember(member, factory));
                    } else {
                        commandSpec.add(CommandReflection.buildArgForMember(member, factory));
                    }
                    bl = true;
                }
                if (member.isSpec()) {
                    CommandReflection.validateInjectSpec(member);
                    commandSpec.addSpecElement(member);
                    if (member.getAnnotation(Spec.class).value() == Spec.Target.SELF) {
                        try {
                            member.setter().set(commandSpec);
                        }
                        catch (Exception exception) {
                            throw new InitializationException("Could not inject spec", exception);
                        }
                    }
                }
                if (member.isParentCommand()) {
                    commandSpec.addParentCommandElement(member);
                }
                return bl;
            }

            private static boolean initFromMethodParameters(IScope scope, Method method, CommandSpec receiver, ArgGroupSpec.Builder groupBuilder, IFactory factory) {
                boolean bl = false;
                int n2 = 0;
                TypedMember[] typedMemberArray = new TypedMember[method.getParameterTypes().length];
                int n3 = typedMemberArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    MethodParam methodParam = new MethodParam(method, i2);
                    if (methodParam.isAnnotationPresent(Option.class) || methodParam.isAnnotationPresent(Mixin.class) || methodParam.isAnnotationPresent(ArgGroup.class)) {
                        ++n2;
                    } else {
                        methodParam.position = i2 - n2;
                    }
                    typedMemberArray[i2] = new TypedMember(methodParam, scope);
                    bl |= CommandReflection.initFromAnnotatedTypedMembers(typedMemberArray[i2], null, receiver, groupBuilder, factory);
                }
                CommandSpec.access$14502(receiver, typedMemberArray);
                return bl;
            }

            private static void validateArgSpecMember(TypedMember member) {
                if (!member.isArgSpec()) {
                    throw new IllegalStateException("Bug: validateArgSpecMember() should only be called with an @Option or @Parameters member");
                }
                if (member.isOption()) {
                    CommandReflection.assertNoDuplicateAnnotations(member, Option.class, Unmatched.class, Mixin.class, Parameters.class, Spec.class, ArgGroup.class);
                } else {
                    CommandReflection.assertNoDuplicateAnnotations(member, Parameters.class, Option.class, Unmatched.class, Mixin.class, Spec.class, ArgGroup.class);
                }
                if (!(member.accessible instanceof Field)) {
                    return;
                }
                Field field = (Field)member.accessible;
                if (Modifier.isFinal(field.getModifiers()) && (field.getType().isPrimitive() || String.class.isAssignableFrom(field.getType()))) {
                    throw new InitializationException("Constant (final) primitive and String fields like " + field + " cannot be used as " + (member.isOption() ? "an @Option" : "a @Parameter") + ": compile-time constant inlining may hide new values written to it.");
                }
            }

            private static void validateCommandSpec(CommandSpec result, boolean hasCommandAnnotation, String commandClassName) {
                if (!hasCommandAnnotation && result.positionalParameters.isEmpty() && result.optionsByNameMap.isEmpty() && result.unmatchedArgs.isEmpty()) {
                    throw new InitializationException(commandClassName + " is not a command: it has no @Command, @Option, @Parameters or @Unmatched annotations");
                }
            }

            private static void validateArgGroupSpec(ArgGroupSpec result, boolean hasArgAnnotation, String className) {
                if (!hasArgAnnotation && result.args().isEmpty()) {
                    throw new InitializationException(className + " is not a group: it has no @Option or @Parameters annotations");
                }
            }

            private static void validateInjectSpec(TypedMember member) {
                if (!member.isSpec()) {
                    throw new IllegalStateException("Bug: validateInjectSpec() should only be called with @Spec members");
                }
                CommandReflection.assertNoDuplicateAnnotations(member, Spec.class, Parameters.class, Option.class, Unmatched.class, Mixin.class, ArgGroup.class);
                if (!CommandSpec.class.getName().equals(member.getTypeInfo().getClassName())) {
                    throw new InitializationException("@picocli.CommandLine.Spec annotation is only supported on fields of type " + CommandSpec.class.getName());
                }
            }

            private static void assertNoDuplicateAnnotations(TypedMember member, Class<? extends Annotation> myAnnotation, Class<? extends Annotation> ... forbidden) {
                Class<? extends Annotation>[] classArray = forbidden;
                int n2 = forbidden.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Class<? extends Annotation> clazz = classArray[i2];
                    if (!member.isAnnotationPresent(clazz)) continue;
                    throw new DuplicateOptionAnnotationsException("A member cannot have both @" + myAnnotation.getSimpleName() + " and @" + clazz.getSimpleName() + " annotations, but '" + member + "' has both.");
                }
            }

            private static CommandSpec buildMixinForMember(IAnnotatedElement member, IFactory factory) {
                try {
                    Object object = member.getter().get();
                    if (object == null) {
                        object = factory.create(member.getTypeInfo().getType());
                        member.setter().set(object);
                    }
                    CommandSpec commandSpec = CommandSpec.forAnnotatedObject(object, factory);
                    return commandSpec.withToString(member.getToString());
                }
                catch (InitializationException initializationException) {
                    InitializationException initializationException2 = initializationException;
                    throw initializationException;
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not access or modify mixin member " + member + ": " + exception, exception);
                }
            }

            private static ArgSpec buildArgForMember(IAnnotatedElement member, IFactory factory) {
                if (member.isOption()) {
                    return OptionSpec.builder(member, factory).build();
                }
                if (member.isParameter()) {
                    return PositionalParamSpec.builder(member, factory).build();
                }
                return PositionalParamSpec.builder(member, factory).build();
            }

            private static ArgGroupSpec buildArgGroupForMember(IAnnotatedElement member, IFactory factory, CommandSpec commandSpec) {
                try {
                    return CommandReflection.extractArgGroupSpec(member, factory, commandSpec, true);
                }
                catch (InitializationException initializationException) {
                    InitializationException initializationException2 = initializationException;
                    throw initializationException;
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not access or modify ArgGroup member " + member + ": " + exception, exception);
                }
            }

            private static UnmatchedArgsBinding buildUnmatchedForMember(IAnnotatedElement member) {
                ITypeInfo iTypeInfo = member.getTypeInfo();
                if (!(iTypeInfo.getClassName().equals(String[].class.getName()) || iTypeInfo.isCollection() && iTypeInfo.getActualGenericTypeArguments().equals(Collections.singletonList(String.class.getName())))) {
                    throw new InitializationException("Invalid type for " + member + ": must be either String[] or List<String>");
                }
                if (iTypeInfo.getClassName().equals(String[].class.getName())) {
                    return UnmatchedArgsBinding.forStringArrayConsumer(member.setter());
                }
                return UnmatchedArgsBinding.forStringCollectionSupplier(member.getter());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static interface Predicate<T> {
            public boolean test(T var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Messages {
            private final CommandSpec spec;
            private final String bundleBaseName;
            private final ResourceBundle rb;
            private final Set<String> keys;

            public Messages(CommandSpec spec, String baseName) {
                String string = baseName;
                this(spec, string, Messages.createBundle(string));
            }

            public Messages(CommandSpec spec, ResourceBundle rb) {
                this(spec, Messages.extractName(rb), rb);
            }

            public Messages(CommandSpec spec, String baseName, ResourceBundle rb) {
                this.spec = Assert.notNull(spec, "CommandSpec");
                this.bundleBaseName = baseName;
                this.rb = rb;
                this.keys = Messages.keys(rb);
                if (rb != null) {
                    new Tracer().debug("Created Messages from resourceBundle[base=%s] for command '%s' (%s)%n", baseName, spec.name(), spec);
                }
            }

            private static ResourceBundle createBundle(String baseName) {
                return ResourceBundle.getBundle(baseName);
            }

            private static String extractName(ResourceBundle rb) {
                try {
                    return (String)ResourceBundle.class.getDeclaredMethod("getBaseBundleName", new Class[0]).invoke((Object)rb, new Object[0]);
                }
                catch (Exception exception) {
                    return "?";
                }
            }

            private static Set<String> keys(ResourceBundle rb) {
                if (rb == null) {
                    return Collections.emptySet();
                }
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                Enumeration<String> enumeration = rb.getKeys();
                while (enumeration.hasMoreElements()) {
                    linkedHashSet.add(enumeration.nextElement());
                }
                return linkedHashSet;
            }

            public static Messages copy(CommandSpec spec, Messages original) {
                if (original == null) {
                    return null;
                }
                return new Messages(spec, original.bundleBaseName, original.rb);
            }

            public static boolean empty(Messages messages) {
                return messages == null || messages.rb == null;
            }

            public String getString(String key, String defaultValue) {
                if (this.isEmpty()) {
                    return defaultValue;
                }
                String string = this.spec.qualifiedName(".");
                if (this.keys.contains(string + "." + key)) {
                    return this.rb.getString(string + "." + key);
                }
                if (this.keys.contains(key)) {
                    return this.rb.getString(key);
                }
                return defaultValue;
            }

            boolean isEmpty() {
                return this.rb == null || this.keys.isEmpty();
            }

            public String[] getStringArray(String key, String[] defaultValues) {
                if (this.isEmpty()) {
                    return defaultValues;
                }
                String string = this.spec.qualifiedName(".");
                List<String> list = Messages.addAllWithPrefix(this.rb, string + "." + key, this.keys, new ArrayList<String>());
                if (!list.isEmpty()) {
                    return list.toArray(new String[0]);
                }
                Messages.addAllWithPrefix(this.rb, key, this.keys, list);
                if (list.isEmpty()) {
                    return defaultValues;
                }
                return list.toArray(new String[0]);
            }

            private static List<String> addAllWithPrefix(ResourceBundle rb, String key, Set<String> keys, List<String> result) {
                if (keys.contains(key)) {
                    result.add(rb.getString(key));
                }
                int n2 = 0;
                String string;
                while (keys.contains(string = key + "." + n2)) {
                    result.add(rb.getString(string));
                    ++n2;
                }
                return result;
            }

            public static String resourceBundleBaseName(Messages messages) {
                if (messages == null) {
                    return null;
                }
                return messages.resourceBundleBaseName();
            }

            public static ResourceBundle resourceBundle(Messages messages) {
                if (messages == null) {
                    return null;
                }
                return messages.resourceBundle();
            }

            public String resourceBundleBaseName() {
                return this.bundleBaseName;
            }

            public ResourceBundle resourceBundle() {
                return this.rb;
            }

            public CommandSpec commandSpec() {
                return this.spec;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TypedMember
        implements IAnnotatedElement,
        IExtensible {
            final AccessibleObject accessible;
            final String name;
            final ITypeInfo typeInfo;
            private final InitialValueState initialValueState;
            private IScope scope;
            private IGetter getter;
            private ISetter setter;

            static TypedMember createIfAnnotated(Field field, IScope scope) {
                if (TypedMember.isAnnotated(field)) {
                    return new TypedMember(field, scope);
                }
                return null;
            }

            static boolean isAnnotated(AnnotatedElement e2) {
                return e2.isAnnotationPresent(Option.class) || e2.isAnnotationPresent(Parameters.class) || e2.isAnnotationPresent(ArgGroup.class) || e2.isAnnotationPresent(Unmatched.class) || e2.isAnnotationPresent(Mixin.class) || e2.isAnnotationPresent(Spec.class) || e2.isAnnotationPresent(ParentCommand.class);
            }

            TypedMember(Field field) {
                this.accessible = Assert.notNull(field, "field");
                this.accessible.setAccessible(true);
                this.name = field.getName();
                this.typeInfo = this.createTypeInfo(field.getType(), field.getGenericType());
                this.initialValueState = InitialValueState.POSTPONED;
            }

            private TypedMember(Field field, IScope scope) {
                this(field);
                if (ObjectScope.isProxyClass(scope)) {
                    throw new InitializationException("Invalid picocli annotation on interface field");
                }
                FieldBinding fieldBinding = new FieldBinding(scope, field);
                this.getter = fieldBinding;
                this.setter = fieldBinding;
                this.scope = scope;
            }

            static TypedMember createIfAnnotated(Method method, IScope scope, CommandSpec spec) {
                if (TypedMember.isAnnotated(method)) {
                    return new TypedMember(method, scope, spec);
                }
                return null;
            }

            private TypedMember(Method method, IScope scope, CommandSpec spec) {
                this.scope = scope;
                this.accessible = Assert.notNull(method, "method");
                this.accessible.setAccessible(true);
                this.name = TypedMember.propertyName(method.getName());
                Class<?>[] classArray = method.getParameterTypes();
                boolean bl = classArray.length == 0 && method.getReturnType() != Void.TYPE && method.getReturnType() != Void.class;
                boolean bl2 = classArray.length > 0;
                if (bl2 == bl) {
                    throw new InitializationException("Invalid method, must be either getter or setter: " + method);
                }
                if (bl) {
                    this.typeInfo = this.createTypeInfo(method.getReturnType(), method.getGenericReturnType());
                    if (ObjectScope.isProxyClass(scope)) {
                        PicocliInvocationHandler picocliInvocationHandler;
                        Object object = ObjectScope.tryGet(scope);
                        PicocliInvocationHandler picocliInvocationHandler2 = picocliInvocationHandler = (PicocliInvocationHandler)Proxy.getInvocationHandler(object);
                        picocliInvocationHandler2.getClass();
                        PicocliInvocationHandler.ProxyBinding proxyBinding = picocliInvocationHandler2.new PicocliInvocationHandler.ProxyBinding(method);
                        this.getter = proxyBinding;
                        this.setter = proxyBinding;
                        this.initializeInitialValue(method);
                    } else {
                        MethodBinding methodBinding = new MethodBinding(scope, method, spec);
                        this.getter = methodBinding;
                        this.setter = methodBinding;
                    }
                    this.initialValueState = InitialValueState.POSTPONED;
                    return;
                }
                this.typeInfo = this.createTypeInfo(classArray[0], method.getGenericParameterTypes()[0]);
                MethodBinding methodBinding = new MethodBinding(scope, method, spec);
                this.getter = methodBinding;
                this.setter = methodBinding;
                this.initialValueState = InitialValueState.UNAVAILABLE;
            }

            TypedMember(MethodParam param, IScope scope) {
                this.scope = scope;
                this.accessible = Assert.notNull(param, "command method parameter");
                this.accessible.setAccessible(true);
                this.name = param.getName();
                this.typeInfo = this.createTypeInfo(param.getType(), param.getParameterizedType());
                ObjectBinding objectBinding = new ObjectBinding();
                this.getter = objectBinding;
                this.setter = objectBinding;
                this.initializeInitialValue(param);
                this.initialValueState = InitialValueState.POSTPONED;
            }

            private ITypeInfo createTypeInfo(Class<?> type, Type genericType) {
                Range range = null;
                if (this.isOption()) {
                    range = Range.valueOf(this.getAnnotation(Option.class).arity());
                }
                if (this.isParameter()) {
                    range = Range.valueOf(this.getAnnotation(Parameters.class).arity());
                }
                if (range == null || range.isUnspecified) {
                    range = this.isOption() ? (type == null || CommandLine.isBoolean(type) ? Range.valueOf("0") : Range.valueOf("1")) : Range.valueOf("1");
                    range = range.unspecified(true);
                }
                return RuntimeTypeInfo.create(type, this.annotationTypes(), genericType, range, this.isOption() ? Boolean.TYPE : String.class, this.isInteractive());
            }

            private void initializeInitialValue(Object arg) {
                block10: {
                    Class<?> clazz = this.typeInfo.getType();
                    try {
                        if (clazz == Boolean.TYPE) {
                            this.setter.set(Boolean.FALSE);
                            break block10;
                        }
                        if (clazz == Byte.TYPE) {
                            this.setter.set((byte)0);
                            break block10;
                        }
                        if (clazz == Character.TYPE) {
                            this.setter.set(Character.valueOf('\u0000'));
                            break block10;
                        }
                        if (clazz == Short.TYPE) {
                            this.setter.set((short)0);
                            break block10;
                        }
                        if (clazz == Integer.TYPE) {
                            this.setter.set(0);
                            break block10;
                        }
                        if (clazz == Long.TYPE) {
                            this.setter.set(0L);
                            break block10;
                        }
                        if (clazz == Float.TYPE) {
                            this.setter.set(Float.valueOf(0.0f));
                            break block10;
                        }
                        if (clazz == Double.TYPE) {
                            this.setter.set(0.0);
                            break block10;
                        }
                        this.setter.set(null);
                        return;
                    }
                    catch (Exception exception) {
                        throw new InitializationException("Could not set initial value for " + arg + ": " + exception.toString(), exception);
                    }
                }
            }

            @Override
            public Object userObject() {
                return this.accessible;
            }

            @Override
            public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                return this.accessible.isAnnotationPresent(annotationClass);
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return this.accessible.getAnnotation(annotationClass);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isArgSpec() {
                return this.isOption() || this.isParameter() || this.isMethodParameter() && !this.isMixin();
            }

            @Override
            public boolean isOption() {
                return this.isAnnotationPresent(Option.class);
            }

            @Override
            public boolean isParameter() {
                return this.isAnnotationPresent(Parameters.class);
            }

            @Override
            public boolean isArgGroup() {
                return this.isAnnotationPresent(ArgGroup.class);
            }

            @Override
            public boolean isMixin() {
                return this.isAnnotationPresent(Mixin.class);
            }

            @Override
            public boolean isUnmatched() {
                return this.isAnnotationPresent(Unmatched.class);
            }

            @Override
            public boolean isSpec() {
                return this.isAnnotationPresent(Spec.class);
            }

            @Override
            public boolean isParentCommand() {
                return this.isAnnotationPresent(ParentCommand.class);
            }

            @Override
            public boolean isMultiValue() {
                return CommandLine.isMultiValue(this.getType());
            }

            @Override
            public boolean isInteractive() {
                return this.isOption() && this.getAnnotation(Option.class).interactive() || this.isParameter() && this.getAnnotation(Parameters.class).interactive();
            }

            @Override
            public IScope scope() {
                return this.scope;
            }

            @Override
            public IGetter getter() {
                return this.getter;
            }

            @Override
            public ISetter setter() {
                return this.setter;
            }

            @Override
            public ITypeInfo getTypeInfo() {
                return this.typeInfo;
            }

            public Class<?> getType() {
                return this.typeInfo.getType();
            }

            public Class<?>[] getAuxiliaryTypes() {
                return this.typeInfo.getAuxiliaryTypes();
            }

            private Class<?>[] annotationTypes() {
                if (this.isOption()) {
                    return this.getAnnotation(Option.class).type();
                }
                if (this.isParameter()) {
                    return this.getAnnotation(Parameters.class).type();
                }
                return new Class[0];
            }

            public String toString() {
                return this.accessible.toString();
            }

            @Override
            public String getToString() {
                if (this.isMixin()) {
                    return TypedMember.abbreviate("mixin from member " + this.toGenericString());
                }
                return (this.accessible instanceof Field ? "field " : (this.accessible instanceof Method ? "method " : this.accessible.getClass().getSimpleName() + " ")) + TypedMember.abbreviate(this.toGenericString());
            }

            public String toGenericString() {
                if (this.accessible instanceof Field) {
                    return ((Field)this.accessible).toGenericString();
                }
                if (this.accessible instanceof Method) {
                    return ((Method)this.accessible).toGenericString();
                }
                return this.accessible.toString();
            }

            @Override
            public boolean hasInitialValue() {
                return this.initialValueState == InitialValueState.CACHED || this.initialValueState == InitialValueState.POSTPONED;
            }

            @Override
            public boolean isMethodParameter() {
                return this.accessible instanceof MethodParam;
            }

            @Override
            public int getMethodParamPosition() {
                if (this.isMethodParameter()) {
                    return ((MethodParam)this.accessible).position;
                }
                return -1;
            }

            @Override
            public String getMixinName() {
                String string = this.getAnnotation(Mixin.class).name();
                if (CommandLine.empty(string)) {
                    return this.getName();
                }
                return string;
            }

            static String propertyName(String methodName) {
                if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
                    return TypedMember.decapitalize(methodName.substring(3));
                }
                return TypedMember.decapitalize(methodName);
            }

            private static String decapitalize(String name) {
                if (name == null || name.length() == 0) {
                    return name;
                }
                char[] cArray = name.toCharArray();
                char[] cArray2 = cArray;
                cArray[0] = Character.toLowerCase(cArray2[0]);
                return new String(cArray2);
            }

            static String abbreviate(String text) {
                return text.replace("private ", "").replace("protected ", "").replace("public ", "").replace("java.lang.", "");
            }

            @Override
            public <T> T getExtension(Class<T> cls) {
                if (cls == InitialValueState.class) {
                    return cls.cast((Object)this.initialValueState);
                }
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IExtensible {
            public <T> T getExtension(Class<T> var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IAnnotatedElement {
            public Object userObject();

            public boolean isAnnotationPresent(Class<? extends Annotation> var1);

            public <T extends Annotation> T getAnnotation(Class<T> var1);

            public String getName();

            public String getMixinName();

            public boolean isArgSpec();

            public boolean isOption();

            public boolean isParameter();

            public boolean isArgGroup();

            public boolean isMixin();

            public boolean isUnmatched();

            public boolean isSpec();

            public boolean isParentCommand();

            public boolean isMultiValue();

            public boolean isInteractive();

            public boolean hasInitialValue();

            public boolean isMethodParameter();

            public int getMethodParamPosition();

            public IScope scope();

            public IGetter getter();

            public ISetter setter();

            public ITypeInfo getTypeInfo();

            public String getToString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class RuntimeTypeInfo
        implements ITypeInfo {
            private final Class<?> type;
            private final Class<?>[] auxiliaryTypes;
            private final List<String> actualGenericTypeArguments;

            RuntimeTypeInfo(Class<?> type, Class<?>[] auxiliaryTypes, List<String> actualGenericTypeArguments) {
                this.type = Assert.notNull(type, "type");
                this.auxiliaryTypes = (Class[])Assert.notNull(auxiliaryTypes, "auxiliaryTypes").clone();
                this.actualGenericTypeArguments = actualGenericTypeArguments == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(actualGenericTypeArguments));
            }

            static ITypeInfo createForAuxType(Class<?> type) {
                return RuntimeTypeInfo.create(type, new Class[0], null, Range.valueOf("1"), String.class, false);
            }

            public static ITypeInfo create(Class<?> type, Class<?>[] annotationTypes, Type genericType, Range arity, Class<?> defaultType, boolean interactive) {
                Class<?>[] classArray = RuntimeTypeInfo.inferTypes(type, annotationTypes, genericType);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (genericType instanceof ParameterizedType) {
                    Class<?>[] classArray2;
                    Class<?>[] classArray3 = classArray2 = RuntimeTypeInfo.extractTypeParameters((ParameterizedType)genericType);
                    int n2 = classArray2.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Class<?> clazz = classArray3[i2];
                        arrayList.add(clazz.getName());
                    }
                }
                return RuntimeTypeInfo.create(type, classArray, arrayList, arity, defaultType, interactive);
            }

            public static ITypeInfo create(Class<?> type, Class<?>[] auxiliaryTypes, List<String> actualGenericTypeArguments, Range arity, Class<?> defaultType, boolean interactive) {
                if (type == null) {
                    type = auxiliaryTypes == null || auxiliaryTypes.length == 0 ? (interactive ? char[].class : (arity.isVariable || arity.max > 1 ? String[].class : (arity.max == 1 ? String.class : defaultType))) : auxiliaryTypes[0];
                }
                if (auxiliaryTypes == null || auxiliaryTypes.length == 0) {
                    auxiliaryTypes = type.isArray() ? (interactive && type.equals(char[].class) ? new Class[]{char[].class} : new Class[]{type.getComponentType()}) : (Collection.class.isAssignableFrom(type) ? new Class[]{interactive ? char[].class : String.class} : (Map.class.isAssignableFrom(type) ? new Class[]{String.class, String.class} : new Class[]{type}));
                }
                return new RuntimeTypeInfo(type, auxiliaryTypes, actualGenericTypeArguments);
            }

            static Class<?>[] inferTypes(Class<?> propertyType, Class<?>[] annotationTypes, Type genericType) {
                if (annotationTypes != null && annotationTypes.length > 0) {
                    return annotationTypes;
                }
                if (propertyType.isArray()) {
                    return new Class[]{propertyType.getComponentType()};
                }
                if (CommandLine.isMultiValue(propertyType)) {
                    if (genericType instanceof ParameterizedType) {
                        return RuntimeTypeInfo.extractTypeParameters((ParameterizedType)genericType);
                    }
                    return new Class[]{String.class, String.class};
                }
                return new Class[]{propertyType};
            }

            static Class<?>[] extractTypeParameters(ParameterizedType genericType) {
                Type[] typeArray = genericType.getActualTypeArguments();
                Object[] objectArray = new Class[typeArray.length];
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    Type type;
                    if (typeArray[i2] instanceof Class) {
                        objectArray[i2] = (Class)typeArray[i2];
                        continue;
                    }
                    if (typeArray[i2] instanceof WildcardType) {
                        type = (WildcardType)typeArray[i2];
                        Type[] typeArray2 = type.getLowerBounds();
                        if (typeArray2.length > 0 && typeArray2[0] instanceof Class) {
                            objectArray[i2] = (Class)typeArray2[0];
                            continue;
                        }
                        Type[] typeArray3 = type.getUpperBounds();
                        if (typeArray3.length > 0 && typeArray3[0] instanceof Class) {
                            objectArray[i2] = (Class)typeArray3[0];
                            continue;
                        }
                    } else if (typeArray[i2] instanceof GenericArrayType && Character.TYPE.equals((type = (GenericArrayType)typeArray[i2]).getGenericComponentType())) {
                        objectArray[i2] = char[].class;
                        continue;
                    }
                    Arrays.fill(objectArray, String.class);
                    return objectArray;
                }
                return objectArray;
            }

            @Override
            public boolean isBoolean() {
                return this.auxiliaryTypes[0] == Boolean.TYPE || this.auxiliaryTypes[0] == Boolean.class;
            }

            @Override
            public boolean isMultiValue() {
                return CommandLine.isMultiValue(this.type);
            }

            @Override
            public boolean isArray() {
                return this.type.isArray();
            }

            @Override
            public boolean isCollection() {
                return Collection.class.isAssignableFrom(this.type);
            }

            @Override
            public boolean isMap() {
                return Map.class.isAssignableFrom(this.type);
            }

            @Override
            public boolean isEnum() {
                return this.auxiliaryTypes[0].isEnum();
            }

            @Override
            public String getClassName() {
                return this.type.getName();
            }

            @Override
            public String getClassSimpleName() {
                return this.type.getSimpleName();
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public Class<?>[] getAuxiliaryTypes() {
                return this.auxiliaryTypes;
            }

            @Override
            public List<String> getActualGenericTypeArguments() {
                return this.actualGenericTypeArguments;
            }

            @Override
            public List<ITypeInfo> getAuxiliaryTypeInfos() {
                ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
                Class<?>[] classArray = this.auxiliaryTypes;
                int n2 = this.auxiliaryTypes.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Class<?> clazz = classArray[i2];
                    arrayList.add(RuntimeTypeInfo.createForAuxType(clazz));
                }
                return arrayList;
            }

            @Override
            public List<String> getEnumConstantNames() {
                if (!this.isEnum()) {
                    return Collections.emptyList();
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object obj : this.auxiliaryTypes[0].getEnumConstants()) {
                    arrayList.add(obj.toString());
                }
                return arrayList;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof RuntimeTypeInfo)) {
                    return false;
                }
                RuntimeTypeInfo runtimeTypeInfo = (RuntimeTypeInfo)obj;
                return Arrays.equals(runtimeTypeInfo.auxiliaryTypes, this.auxiliaryTypes) && this.type.equals(runtimeTypeInfo.type);
            }

            public int hashCode() {
                return Arrays.hashCode(this.auxiliaryTypes) + 37 * Assert.hashCode(this.type);
            }

            public String toString() {
                return String.format("RuntimeTypeInfo(%s, aux=%s, collection=%s, map=%s)", this.type.getCanonicalName(), Arrays.toString(this.auxiliaryTypes), this.isCollection(), this.isMap());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ITypeInfo {
            public boolean isBoolean();

            public boolean isMultiValue();

            public boolean isArray();

            public boolean isCollection();

            public boolean isMap();

            public boolean isEnum();

            public List<String> getEnumConstantNames();

            public String getClassName();

            public String getClassSimpleName();

            public List<ITypeInfo> getAuxiliaryTypeInfos();

            public List<String> getActualGenericTypeArguments();

            public Class<?> getType();

            public Class<?>[] getAuxiliaryTypes();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class MethodParam
        extends AccessibleObject {
            final Method method;
            final int paramIndex;
            final String name;
            int position;

            public MethodParam(Method method, int paramIndex) {
                this.method = method;
                this.paramIndex = paramIndex;
                String string = "arg" + paramIndex;
                try {
                    Method method2 = Method.class.getMethod("getParameters", new Class[0]);
                    Object object = method2.invoke((Object)method, new Object[0]);
                    Object object2 = Array.get(object, paramIndex);
                    string = (String)Class.forName("java.lang.reflect.Parameter").getDeclaredMethod("getName", new Class[0]).invoke(object2, new Object[0]);
                }
                catch (Exception exception) {}
                this.name = string;
            }

            public Type getParameterizedType() {
                return this.method.getGenericParameterTypes()[this.paramIndex];
            }

            public String getName() {
                return this.name;
            }

            public Class<?> getType() {
                return this.method.getParameterTypes()[this.paramIndex];
            }

            public Method getDeclaringExecutable() {
                return this.method;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                for (Annotation annotation : this.getDeclaredAnnotations()) {
                    if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                    return (T)((Annotation)annotationClass.cast(annotation));
                }
                return null;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.method.getParameterAnnotations()[this.paramIndex];
            }

            @Override
            public void setAccessible(boolean flag) throws SecurityException {
                this.method.setAccessible(flag);
            }

            @Override
            public boolean isAccessible() throws SecurityException {
                return this.method.isAccessible();
            }

            public String toString() {
                return this.method.toString() + ":" + this.getName();
            }
        }

        public static class UnmatchedArgsBinding {
            private final IGetter getter;
            private final ISetter setter;
            private Object initialValue;

            public static UnmatchedArgsBinding forStringArrayConsumer(ISetter setter) {
                return new UnmatchedArgsBinding(null, setter);
            }

            public static UnmatchedArgsBinding forStringCollectionSupplier(IGetter getter) {
                return new UnmatchedArgsBinding(getter, null);
            }

            private UnmatchedArgsBinding(IGetter getter, ISetter setter) {
                if (getter == null && setter == null) {
                    throw new IllegalArgumentException("Getter and setter cannot both be null");
                }
                this.setter = setter;
                this.getter = getter;
                IGetter iGetter = setter instanceof IGetter ? (IGetter)((Object)setter) : getter;
                try {
                    this.initialValue = iGetter.get();
                    return;
                }
                catch (Exception exception) {
                    new Tracer().debug("Could not obtain initial value for unmatched from %s%n", iGetter);
                    return;
                }
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            void addAll(String[] unmatched) {
                if (this.setter != null) {
                    try {
                        this.setter.set(unmatched);
                        return;
                    }
                    catch (Exception exception) {
                        throw new PicocliException(String.format("Could not invoke setter (%s) with unmatched argument array '%s': %s", this.setter, Arrays.toString(unmatched), exception), exception);
                    }
                }
                try {
                    ArrayList<String> arrayList = (ArrayList<String>)this.getter.get();
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        ((ISetter)((Object)this.getter)).set(arrayList);
                    }
                    arrayList.addAll(Arrays.asList(unmatched));
                    return;
                }
                catch (Exception exception) {
                    throw new PicocliException(String.format("Could not add unmatched argument array '%s' to collection returned by getter (%s): %s", Arrays.toString(unmatched), this.getter, exception), exception);
                }
            }

            void clear() {
                ISetter iSetter = this.setter;
                if (iSetter == null) {
                    if (this.getter instanceof ISetter) {
                        iSetter = (ISetter)((Object)this.getter);
                    } else {
                        new Tracer().warn("Unable to clear %s: it does not implement ISetter", this.getter);
                        return;
                    }
                }
                try {
                    iSetter.set(this.initialValue);
                    return;
                }
                catch (Exception exception) {
                    throw new PicocliException(String.format("Could not invoke setter (%s) with initial value: %s", iSetter, exception), exception);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ArgGroupSpec
        implements IOrdered {
            static final int DEFAULT_ORDER = -1;
            private static final String NO_HEADING = "__no_heading__";
            private static final String NO_HEADING_KEY = "__no_heading_key__";
            private final String heading;
            private final String headingKey;
            private final boolean exclusive;
            private final Range multiplicity;
            private final boolean validate;
            private final int order;
            private final IGetter getter;
            private final ISetter setter;
            private final IScope scope;
            private final ITypeInfo typeInfo;
            private final List<ArgGroupSpec> subgroups;
            private final Set<ArgSpec> args;
            private Messages messages;
            private ArgGroupSpec parentGroup;
            private String id = "1";

            /*
             * WARNING - void declaration
             */
            ArgGroupSpec(Builder builder) {
                this.heading = NO_HEADING.equals(builder.heading) ? null : builder.heading;
                this.headingKey = NO_HEADING_KEY.equals(builder.headingKey) ? null : builder.headingKey;
                this.exclusive = builder.exclusive && builder.validate;
                this.multiplicity = builder.multiplicity;
                this.validate = builder.validate;
                this.order = builder.order;
                this.typeInfo = builder.typeInfo;
                this.getter = builder.getter;
                this.setter = builder.setter;
                this.scope = builder.scope;
                this.args = Collections.unmodifiableSet(new LinkedHashSet<ArgSpec>(builder.args()));
                this.subgroups = Collections.unmodifiableList(new ArrayList<ArgGroupSpec>(builder.subgroups()));
                if (this.args.isEmpty() && this.subgroups.isEmpty()) {
                    throw new InitializationException("ArgGroup has no options or positional parameters, and no subgroups: " + (this.getter == null ? this.setter : this.getter) + " in " + this.scope);
                }
                int n2 = 1;
                for (ArgGroupSpec object : this.subgroups) {
                    object2.next().parentGroup = this;
                    object.id = this.id + "." + n2++;
                }
                for (ArgSpec argSpec : this.args) {
                    argSpec.group = this;
                }
                if (!this.validate && builder.exclusive) {
                    new Tracer().info("Setting exclusive=%s because %s is a non-validating group.%n", this.exclusive, this.synopsisUnit());
                }
                if (this.exclusive) {
                    Object object2 = "";
                    String string = "";
                    for (ArgSpec argSpec : this.args) {
                        void var4_8;
                        if (argSpec.required()) continue;
                        object2 = (String)object2 + (String)var4_8 + (argSpec.isOption() ? ((OptionSpec)argSpec).longestName() : argSpec.paramLabel() + "[" + ((PositionalParamSpec)argSpec).index() + "]");
                        String string2 = ",";
                        argSpec.required = true;
                    }
                    if (((String)object2).length() > 0) {
                        new Tracer().info("Made %s required in the group because %s is an exclusive group.%n", object2, this.synopsisUnit());
                    }
                }
            }

            public static Builder builder() {
                return new Builder();
            }

            public static Builder builder(IAnnotatedElement annotatedElement) {
                return new Builder(Assert.notNull(annotatedElement, "annotatedElement"));
            }

            public boolean exclusive() {
                return this.exclusive;
            }

            public Range multiplicity() {
                return this.multiplicity;
            }

            public boolean validate() {
                return this.validate;
            }

            @Override
            public int order() {
                return this.order;
            }

            public String heading() {
                if (this.messages() == null) {
                    return this.heading;
                }
                String string = this.messages().getString(this.headingKey(), null);
                if (string != null) {
                    return string;
                }
                return this.heading;
            }

            public String headingKey() {
                return this.headingKey;
            }

            public ArgGroupSpec parentGroup() {
                return this.parentGroup;
            }

            public List<ArgGroupSpec> subgroups() {
                return this.subgroups;
            }

            public boolean isSubgroupOf(ArgGroupSpec group) {
                for (ArgGroupSpec argGroupSpec : group.subgroups) {
                    if (this == argGroupSpec) {
                        return true;
                    }
                    if (!this.isSubgroupOf(argGroupSpec)) continue;
                    return true;
                }
                return false;
            }

            public ITypeInfo typeInfo() {
                return this.typeInfo;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            public IScope scope() {
                return this.scope;
            }

            Object userObject() {
                try {
                    return this.getter.get();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    return exception.toString();
                }
            }

            Object userObjectOr(Object defaultValue) {
                try {
                    return this.getter.get();
                }
                catch (Exception exception) {
                    return defaultValue;
                }
            }

            String id() {
                return this.id;
            }

            int argCount() {
                int n2 = this.args.size();
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    n2 += argGroupSpec.argCount();
                }
                return n2;
            }

            int localPositionalParamCount() {
                int n2 = 0;
                for (ArgSpec argSpec : this.args) {
                    if (!argSpec.isPositional()) continue;
                    n2 += ((PositionalParamSpec)argSpec).capacity().min();
                }
                return n2;
            }

            public Set<ArgSpec> args() {
                return this.args;
            }

            public Set<ArgSpec> requiredArgs() {
                LinkedHashSet<ArgSpec> linkedHashSet = new LinkedHashSet<ArgSpec>(this.args);
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    if (((ArgSpec)iterator.next()).required()) continue;
                    iterator.remove();
                }
                return Collections.unmodifiableSet(linkedHashSet);
            }

            public List<PositionalParamSpec> positionalParameters() {
                ArrayList<PositionalParamSpec> arrayList = new ArrayList<PositionalParamSpec>();
                for (ArgSpec argSpec : this.args()) {
                    if (!(argSpec instanceof PositionalParamSpec)) continue;
                    arrayList.add((PositionalParamSpec)argSpec);
                }
                return Collections.unmodifiableList(arrayList);
            }

            public List<OptionSpec> options() {
                ArrayList<OptionSpec> arrayList = new ArrayList<OptionSpec>();
                for (ArgSpec argSpec : this.args()) {
                    if (!(argSpec instanceof OptionSpec)) continue;
                    arrayList.add((OptionSpec)argSpec);
                }
                return Collections.unmodifiableList(arrayList);
            }

            public List<OptionSpec> allOptionsNested() {
                return this.addGroupOptionsToListRecursively(new ArrayList<OptionSpec>());
            }

            private List<OptionSpec> addGroupOptionsToListRecursively(List<OptionSpec> result) {
                result.addAll(this.options());
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    argGroupSpec.addGroupOptionsToListRecursively(result);
                }
                return result;
            }

            public List<PositionalParamSpec> allPositionalParametersNested() {
                return this.addGroupPositionalsToListRecursively(new ArrayList<PositionalParamSpec>());
            }

            private List<PositionalParamSpec> addGroupPositionalsToListRecursively(List<PositionalParamSpec> result) {
                result.addAll(this.positionalParameters());
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    argGroupSpec.addGroupPositionalsToListRecursively(result);
                }
                return result;
            }

            public String synopsis() {
                return this.synopsisText(new Help.ColorScheme.Builder(Help.Ansi.OFF).build(), new HashSet<ArgSpec>()).toString();
            }

            String synopsisUnit() {
                Help.ColorScheme colorScheme = new Help.ColorScheme.Builder(Help.Ansi.OFF).build();
                return this.synopsisUnitText(colorScheme, this.rawSynopsisUnitText(colorScheme, new HashSet<ArgSpec>())).toString();
            }

            public Help.Ansi.Text synopsisText(Help.ColorScheme colorScheme, Set<ArgSpec> outparam_groupArgs) {
                int n2;
                Help.Ansi.Text text = this.rawSynopsisUnitText(colorScheme, outparam_groupArgs);
                Help.Ansi.Text text2 = this.synopsisUnitText(colorScheme, text);
                for (n2 = 1; n2 < this.multiplicity.min(); ++n2) {
                    text2 = text2.concat(" (").concat(text).concat(")");
                }
                if (this.multiplicity().isVariable()) {
                    text2 = text2.concat("...");
                } else {
                    while (n2 < this.multiplicity.max()) {
                        text2 = text2.concat(" [").concat(text).concat("]");
                        ++n2;
                    }
                }
                return text2;
            }

            private Help.Ansi.Text synopsisUnitText(Help.ColorScheme colorScheme, Help.Ansi.Text synopsis) {
                String string = this.multiplicity().min() > 0 ? "(" : "[";
                String string2 = this.multiplicity().min() > 0 ? ")" : "]";
                return colorScheme.text(string).concat(synopsis).concat(string2);
            }

            private Help.Ansi.Text rawSynopsisUnitText(Help.ColorScheme colorScheme, Set<ArgSpec> outparam_groupArgs) {
                String string = this.exclusive() ? " | " : " ";
                Help.Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                Help.Ansi.Text text = ansi.new Help.Ansi.Text(0);
                for (ArgSpec object : this.args()) {
                    String string2 = text.length > 0 ? string : "";
                    text = object instanceof OptionSpec ? this.concatOptionText(string2, text, colorScheme, (OptionSpec)object) : this.concatPositionalText(string2, text, colorScheme, (PositionalParamSpec)object);
                    outparam_groupArgs.add(object);
                }
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    if (text.length > 0) {
                        text = text.concat(string);
                    }
                    text = text.concat(argGroupSpec.synopsisText(colorScheme, outparam_groupArgs));
                }
                return text;
            }

            private Help.Ansi.Text concatOptionText(String prefix, Help.Ansi.Text text, Help.ColorScheme colorScheme, OptionSpec option) {
                return Help.concatOptionText(prefix, text, colorScheme, option, this.createLabelRenderer(option.commandSpec));
            }

            private Help.Ansi.Text concatPositionalText(String prefix, Help.Ansi.Text text, Help.ColorScheme colorScheme, PositionalParamSpec positionalParam) {
                return Help.concatPositionalText(prefix, text, colorScheme, positionalParam, this.createLabelRenderer(positionalParam.commandSpec));
            }

            public Help.IParamLabelRenderer createLabelRenderer(CommandSpec commandSpec) {
                return new Help.DefaultParamLabelRenderer(commandSpec == null ? CommandSpec.create() : commandSpec);
            }

            public Messages messages() {
                return this.messages;
            }

            public ArgGroupSpec messages(Messages msgs) {
                this.messages = msgs;
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    argGroupSpec.messages(msgs);
                }
                return this;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof ArgGroupSpec)) {
                    return false;
                }
                ArgGroupSpec argGroupSpec = (ArgGroupSpec)obj;
                return this.exclusive == argGroupSpec.exclusive && Assert.equals(this.multiplicity, argGroupSpec.multiplicity) && this.validate == argGroupSpec.validate && this.order == argGroupSpec.order && Assert.equals(this.heading, argGroupSpec.heading) && Assert.equals(this.headingKey, argGroupSpec.headingKey) && Assert.equals(this.subgroups, argGroupSpec.subgroups) && Assert.equals(this.args, argGroupSpec.args);
            }

            public int hashCode() {
                int n2 = 17 + (629 + Assert.hashCode(this.exclusive));
                n2 += n2 * 37 + Assert.hashCode(this.multiplicity);
                n2 += n2 * 37 + Assert.hashCode(this.validate);
                n2 += n2 * 37 + this.order;
                n2 += n2 * 37 + Assert.hashCode(this.heading);
                n2 += n2 * 37 + Assert.hashCode(this.headingKey);
                n2 += n2 * 37 + Assert.hashCode(this.subgroups);
                n2 += n2 * 37 + Assert.hashCode(this.args);
                return n2;
            }

            public String toString() {
                return "ArgGroup[exclusive=" + this.exclusive + ", multiplicity=" + this.multiplicity + ", validate=" + this.validate + ", order=" + this.order + ", args=[" + ArgSpec.describe(this.args()) + "], headingKey=" + ArgGroupSpec.quote(this.headingKey) + ", heading=" + ArgGroupSpec.quote(this.heading) + ", subgroups=" + this.subgroups + "]";
            }

            private static String quote(String s2) {
                if (s2 == null) {
                    return "null";
                }
                return "'" + s2 + "'";
            }

            void initUserObject(CommandLine commandLine) {
                if (commandLine == null) {
                    new Tracer().debug("Could not create user object for %s with null CommandLine%n.", this);
                    return;
                }
                try {
                    this.tryInitUserObject(commandLine);
                    return;
                }
                catch (PicocliException picocliException) {
                    PicocliException picocliException2 = picocliException;
                    throw picocliException;
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not create user object for " + this, exception);
                }
            }

            void tryInitUserObject(CommandLine commandLine) throws Exception {
                Tracer tracer = commandLine.tracer;
                if (this.typeInfo() != null) {
                    tracer.debug("Creating new user object of type %s for group %s%n", this.typeInfo().getAuxiliaryTypes()[0], this.synopsis());
                    Object obj = DefaultFactory.create(commandLine.factory, this.typeInfo().getAuxiliaryTypes()[0]);
                    tracer.debug("Created %s, invoking setter %s with scope %s%n", obj, this.setter(), this.scope());
                    this.setUserObject(obj, commandLine.factory);
                    for (ArgSpec object : this.args()) {
                        tracer.debug("Initializing %s in group %s: setting scope to user object %s and initializing initial and default values%n", ArgSpec.describe(object, "="), this.synopsis(), obj);
                        object.scope().set(obj);
                        ((Interpreter)((CommandLine)commandLine).interpreter).parseResultBuilder.isInitializingDefaultValues = true;
                        object.applyInitialValue(tracer);
                        commandLine.interpreter.applyDefault(commandLine.getCommandSpec().defaultValueProvider(), object);
                        ((Interpreter)((CommandLine)commandLine).interpreter).parseResultBuilder.isInitializingDefaultValues = false;
                    }
                    for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                        tracer.debug("Setting scope for subgroup %s with setter=%s in group %s to user object %s%n", argGroupSpec.synopsis(), argGroupSpec.setter(), this.synopsis(), obj);
                        argGroupSpec.scope().set(obj);
                    }
                } else {
                    tracer.debug("No type information available for group %s: cannot create new user object. Scope for arg setters is not changed.%n", this.synopsis());
                }
                tracer.debug("Initialization complete for group %s%n", this.synopsis());
            }

            void setUserObject(Object userObject, IFactory factory) throws Exception {
                if (this.typeInfo().isCollection()) {
                    Collection collection = (Collection)this.getter().get();
                    if (collection == null) {
                        Collection collection2;
                        collection = collection2 = (Collection)DefaultFactory.create(factory, this.typeInfo.getType());
                        this.setter().set(collection);
                    }
                    collection.add(userObject);
                    return;
                }
                if (this.typeInfo().isArray()) {
                    Object t2 = this.getter().get();
                    int n2 = t2 == null ? 0 : Array.getLength(t2);
                    Object object = Array.newInstance(this.typeInfo().getAuxiliaryTypes()[0], n2 + 1);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Array.set(object, i2, Array.get(t2, i2));
                    }
                    Array.set(object, n2, userObject);
                    this.setter().set(object);
                    return;
                }
                this.setter().set(userObject);
            }

            ParseResult.GroupValidationResult validateArgs(CommandLine commandLine, Collection<ArgSpec> matchedArgs) {
                LinkedHashSet<ArgSpec> linkedHashSet = new LinkedHashSet<ArgSpec>(this.args());
                LinkedHashSet<ArgSpec> linkedHashSet2 = new LinkedHashSet<ArgSpec>(this.requiredArgs());
                LinkedHashSet<ArgSpec> linkedHashSet3 = new LinkedHashSet<ArgSpec>(matchedArgs);
                linkedHashSet2.removeAll(matchedArgs);
                linkedHashSet.retainAll(linkedHashSet3);
                int n2 = linkedHashSet.size();
                boolean bl = !linkedHashSet2.isEmpty() && !this.exclusive();
                boolean bl2 = bl && !linkedHashSet.isEmpty();
                String string = ArgSpec.describe(linkedHashSet);
                String string2 = ArgSpec.describe(this.requiredArgs());
                String string3 = ArgSpec.describe(linkedHashSet2);
                return this.validate(commandLine, n2, bl, bl2, string, string2, string3);
            }

            private ParseResult.GroupValidationResult validate(CommandLine commandLine, int presentCount, boolean haveMissing, boolean someButNotAllSpecified, String exclusiveElements, String requiredElements, String missingElements) {
                if (this.exclusive()) {
                    if (presentCount > 1) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_PRESENT, new MutuallyExclusiveArgsException(commandLine, "Error: " + exclusiveElements + " are mutually exclusive (specify only one)"));
                    }
                    if (this.multiplicity().min > 0 && haveMissing) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_ABSENT, new MissingParameterException(commandLine, this.args(), "Error: Missing required argument (specify one of these): " + requiredElements));
                    }
                } else {
                    if (someButNotAllSpecified) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_PARTIAL, new MissingParameterException(commandLine, this.args(), "Error: Missing required argument(s): " + missingElements));
                    }
                    if (this.multiplicity().min > 0 && haveMissing) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_ABSENT, new MissingParameterException(commandLine, this.args(), "Error: Missing required argument(s): " + missingElements));
                    }
                }
                if (presentCount > 0) {
                    return ParseResult.GroupValidationResult.SUCCESS_PRESENT;
                }
                return ParseResult.GroupValidationResult.SUCCESS_ABSENT;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder {
                private IGetter getter;
                private ISetter setter;
                private IScope scope;
                private ITypeInfo typeInfo;
                private String heading;
                private String headingKey;
                private boolean exclusive = true;
                private Range multiplicity = Range.valueOf("0..1");
                private boolean validate = true;
                private int order = -1;
                private final List<ArgSpec> args = new ArrayList<ArgSpec>();
                private final List<ArgGroupSpec> subgroups = new ArrayList<ArgGroupSpec>();
                private Boolean topologicalSortDone;
                private final List<Builder> compositesReferencingMe = new ArrayList<Builder>();

                Builder() {
                }

                Builder(IAnnotatedElement source) {
                    this.typeInfo = source.getTypeInfo();
                    this.getter = source.getter();
                    this.setter = source.setter();
                    this.scope = source.scope();
                }

                public Builder updateArgGroupAttributes(ArgGroup group) {
                    return this.heading(group.heading()).headingKey(group.headingKey()).exclusive(group.exclusive()).multiplicity(group.multiplicity()).validate(group.validate()).order(group.order());
                }

                public ArgGroupSpec build() {
                    return new ArgGroupSpec(this);
                }

                public boolean exclusive() {
                    return this.exclusive;
                }

                public Builder exclusive(boolean newValue) {
                    this.exclusive = newValue;
                    return this;
                }

                public Range multiplicity() {
                    return this.multiplicity;
                }

                public Builder multiplicity(String newValue) {
                    return this.multiplicity(Range.valueOf(newValue));
                }

                public Builder multiplicity(Range newValue) {
                    this.multiplicity = newValue;
                    return this;
                }

                public boolean validate() {
                    return this.validate;
                }

                public Builder validate(boolean newValue) {
                    this.validate = newValue;
                    return this;
                }

                public int order() {
                    return this.order;
                }

                public Builder order(int order) {
                    this.order = order;
                    return this;
                }

                public String heading() {
                    return this.heading;
                }

                public Builder heading(String newValue) {
                    this.heading = newValue;
                    return this;
                }

                public String headingKey() {
                    return this.headingKey;
                }

                public Builder headingKey(String newValue) {
                    this.headingKey = newValue;
                    return this;
                }

                public ITypeInfo typeInfo() {
                    return this.typeInfo;
                }

                public Builder typeInfo(ITypeInfo newValue) {
                    this.typeInfo = newValue;
                    return this;
                }

                public IGetter getter() {
                    return this.getter;
                }

                public Builder getter(IGetter getter) {
                    this.getter = getter;
                    return this;
                }

                public ISetter setter() {
                    return this.setter;
                }

                public Builder setter(ISetter setter) {
                    this.setter = setter;
                    return this;
                }

                public IScope scope() {
                    return this.scope;
                }

                public Builder scope(IScope scope) {
                    this.scope = scope;
                    return this;
                }

                public Builder addArg(ArgSpec arg) {
                    this.args.add(arg);
                    return this;
                }

                public List<ArgSpec> args() {
                    return this.args;
                }

                public Builder addSubgroup(ArgGroupSpec group) {
                    this.subgroups.add(group);
                    return this;
                }

                public List<ArgGroupSpec> subgroups() {
                    return this.subgroups;
                }
            }
        }

        public static interface IOrdered {
            public int order();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class PositionalParamSpec
        extends ArgSpec {
            private Range index;
            private Range capacity;
            private final Range builderCapacity;

            private PositionalParamSpec(Builder builder) {
                super(builder);
                this.index = builder.index == null ? Range.defaultParameterIndex(this.typeInfo) : builder.index;
                this.builderCapacity = builder.capacity;
                this.initCapacity();
                if (this.toString == null) {
                    this.toString = "positional parameter[" + this.index() + "]";
                }
            }

            private void initCapacity() {
                this.capacity = this.builderCapacity == null ? Range.parameterCapacity(this.arity(), this.index) : this.builderCapacity;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static Builder builder(PositionalParamSpec original) {
                return new Builder(original);
            }

            public static Builder builder(IAnnotatedElement source, IFactory factory) {
                return new Builder(source, factory);
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            @Override
            public boolean isOption() {
                return false;
            }

            @Override
            public boolean isPositional() {
                return true;
            }

            @Override
            protected Collection<String> getAdditionalDescriptionKeys() {
                return Collections.singletonList(this.paramLabel() + "[" + this.index() + "]");
            }

            public Range index() {
                return this.index;
            }

            private Range capacity() {
                return this.capacity;
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.capacity) + 37 * Assert.hashCode(this.index);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof PositionalParamSpec)) {
                    return false;
                }
                PositionalParamSpec positionalParamSpec = (PositionalParamSpec)obj;
                return super.equalsImpl(positionalParamSpec) && Assert.equals(this.capacity, positionalParamSpec.capacity) && Assert.equals(this.index, positionalParamSpec.index);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private Range capacity;
                private Range index;

                private Builder() {
                }

                private Builder(PositionalParamSpec original) {
                    super(original);
                    this.index = original.index;
                    this.capacity = original.capacity;
                }

                private Builder(IAnnotatedElement member, IFactory factory) {
                    super(member.getAnnotation(Parameters.class), member, factory);
                    this.index = Range.parameterIndex(member);
                    this.capacity = Range.parameterCapacity(member);
                }

                @Override
                public PositionalParamSpec build() {
                    return new PositionalParamSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public Range index() {
                    return this.index;
                }

                public Builder index(String range) {
                    return this.index(Range.valueOf(range));
                }

                public Builder index(Range index) {
                    this.index = index;
                    return this.self();
                }

                Range capacity() {
                    return this.capacity;
                }

                Builder capacity(Range capacity) {
                    this.capacity = capacity;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class OptionSpec
        extends ArgSpec
        implements IOrdered {
            public static final String DEFAULT_FALLBACK_VALUE = "";
            static final int DEFAULT_ORDER = -1;
            private final String[] names;
            private final boolean help;
            private final boolean usageHelp;
            private final boolean versionHelp;
            private final boolean negatable;
            private final String fallbackValue;
            private final int order;

            public static Builder builder(String name, String ... names) {
                String[] stringArray = new String[Assert.notNull(names, "names").length + 1];
                String[] stringArray2 = stringArray;
                stringArray[0] = Assert.notNull(name, "name");
                System.arraycopy(names, 0, stringArray2, 1, names.length);
                return new Builder(stringArray2);
            }

            public static Builder builder(String[] names) {
                return new Builder(names);
            }

            public static Builder builder(IAnnotatedElement source, IFactory factory) {
                return new Builder(source, factory);
            }

            public static Builder builder(OptionSpec original) {
                return new Builder(original);
            }

            private OptionSpec(Builder builder) {
                super(builder);
                if (builder.names == null) {
                    throw new InitializationException("OptionSpec names cannot be null. Specify at least one option name.");
                }
                this.names = (String[])builder.names.clone();
                this.help = builder.help;
                this.usageHelp = builder.usageHelp;
                this.versionHelp = builder.versionHelp;
                this.order = builder.order;
                this.negatable = builder.negatable;
                this.fallbackValue = builder.fallbackValue;
                if (this.names.length == 0 || Arrays.asList(this.names).contains(DEFAULT_FALLBACK_VALUE)) {
                    throw new InitializationException("Invalid names: " + Arrays.toString(this.names));
                }
                if (this.toString == null) {
                    this.toString = "option " + this.longestName();
                }
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            @Override
            public boolean isOption() {
                return true;
            }

            @Override
            public boolean isPositional() {
                return false;
            }

            @Override
            protected boolean internalShowDefaultValue(boolean usageMessageShowDefaults) {
                return super.internalShowDefaultValue(usageMessageShowDefaults) && !this.help() && !this.versionHelp() && !this.usageHelp();
            }

            @Override
            protected Collection<String> getAdditionalDescriptionKeys() {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                for (String string : this.names()) {
                    linkedHashSet.add(CommandSpec.stripPrefix(string));
                }
                return linkedHashSet;
            }

            public String[] names() {
                OptionSpec optionSpec = this;
                return optionSpec.interpolate((String[])optionSpec.names.clone());
            }

            public String longestName() {
                return Help.ShortestFirst.longestFirst(this.names())[0];
            }

            public String shortestName() {
                return Help.ShortestFirst.sort(this.names())[0];
            }

            @Override
            public int order() {
                return this.order;
            }

            @Deprecated
            public boolean help() {
                return this.help;
            }

            public boolean usageHelp() {
                return this.usageHelp;
            }

            public boolean versionHelp() {
                return this.versionHelp;
            }

            public boolean negatable() {
                return this.negatable;
            }

            public String fallbackValue() {
                OptionSpec optionSpec = this;
                return optionSpec.interpolate(optionSpec.fallbackValue);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof OptionSpec)) {
                    return false;
                }
                OptionSpec optionSpec = (OptionSpec)obj;
                return super.equalsImpl(optionSpec) && this.help == optionSpec.help && this.usageHelp == optionSpec.usageHelp && this.versionHelp == optionSpec.versionHelp && this.order == optionSpec.order && this.negatable == optionSpec.negatable && Assert.equals(this.fallbackValue, optionSpec.fallbackValue) && new HashSet<String>(Arrays.asList(this.names)).equals(new HashSet<String>(Arrays.asList(optionSpec.names)));
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.help) + 37 * Assert.hashCode(this.usageHelp) + 37 * Assert.hashCode(this.versionHelp) + 37 * Arrays.hashCode(this.names) + 37 * Assert.hashCode(this.negatable) + 37 * Assert.hashCode(this.fallbackValue) + 37 * this.order;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private String[] names;
                private boolean help;
                private boolean usageHelp;
                private boolean versionHelp;
                private boolean negatable;
                private String fallbackValue = "";
                private int order = -1;

                private Builder(String[] names) {
                    this.names = names;
                }

                private Builder(OptionSpec original) {
                    super(original);
                    this.names = original.names;
                    this.help = original.help;
                    this.usageHelp = original.usageHelp;
                    this.versionHelp = original.versionHelp;
                    this.negatable = original.negatable;
                    this.fallbackValue = original.fallbackValue;
                    this.order = original.order;
                }

                private Builder(IAnnotatedElement member, IFactory factory) {
                    super(member.getAnnotation(Option.class), member, factory);
                    Option option = member.getAnnotation(Option.class);
                    this.names = option.names();
                    this.help = option.help();
                    this.usageHelp = option.usageHelp();
                    this.versionHelp = option.versionHelp();
                    this.negatable = option.negatable();
                    this.fallbackValue = option.fallbackValue();
                    this.order = option.order();
                }

                @Override
                public OptionSpec build() {
                    return new OptionSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public String[] names() {
                    return (String[])this.names.clone();
                }

                @Deprecated
                public boolean help() {
                    return this.help;
                }

                public boolean usageHelp() {
                    return this.usageHelp;
                }

                public boolean versionHelp() {
                    return this.versionHelp;
                }

                public boolean negatable() {
                    return this.negatable;
                }

                public String fallbackValue() {
                    return this.fallbackValue;
                }

                public int order() {
                    return this.order;
                }

                public Builder names(String ... names) {
                    this.names = (String[])Assert.notNull(names, "names").clone();
                    return this.self();
                }

                public Builder help(boolean help) {
                    this.help = help;
                    return this.self();
                }

                public Builder usageHelp(boolean usageHelp) {
                    this.usageHelp = usageHelp;
                    return this.self();
                }

                public Builder versionHelp(boolean versionHelp) {
                    this.versionHelp = versionHelp;
                    return this.self();
                }

                public Builder negatable(boolean negatable) {
                    this.negatable = negatable;
                    return this.self();
                }

                public Builder fallbackValue(String fallbackValue) {
                    this.fallbackValue = fallbackValue;
                    return this.self();
                }

                public Builder order(int order) {
                    this.order = order;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class ArgSpec {
            static final String DESCRIPTION_VARIABLE_DEFAULT_VALUE = "${DEFAULT-VALUE}";
            static final String DESCRIPTION_VARIABLE_FALLBACK_VALUE = "${FALLBACK-VALUE}";
            static final String DESCRIPTION_VARIABLE_COMPLETION_CANDIDATES = "${COMPLETION-CANDIDATES}";
            private static final String NO_DEFAULT_VALUE = "__no_default_value__";
            private final boolean inherited;
            private final boolean hidden;
            private final String paramLabel;
            private final boolean hideParamSyntax;
            private final String[] description;
            private final String descriptionKey;
            private final Help.Visibility showDefaultValue;
            private Messages messages;
            CommandSpec commandSpec;
            private ArgGroupSpec group;
            private final Object userObject;
            private boolean required;
            private final boolean interactive;
            private final String splitRegex;
            private final String splitRegexSynopsisLabel;
            protected final ITypeInfo typeInfo;
            private final ITypeConverter<?>[] converters;
            private final Iterable<String> completionCandidates;
            private final IParameterConsumer parameterConsumer;
            private final String defaultValue;
            private Object initialValue;
            private final boolean hasInitialValue;
            private InitialValueState initialValueState;
            protected final IAnnotatedElement annotatedElement;
            private final IGetter getter;
            private final ISetter setter;
            private final IScope scope;
            private final ScopeType scopeType;
            private Range arity;
            private List<String> stringValues = new ArrayList<String>();
            private List<String> originalStringValues = new ArrayList<String>();
            protected String toString;
            private final List<Object> typedValues = new ArrayList<Object>();
            Map<Integer, Object> typedValueAtPosition = new TreeMap<Integer, Object>();

            private <T extends Builder<T>> ArgSpec(Builder<T> builder) {
                this.userObject = ((Builder)builder).userObject;
                this.description = ((Builder)builder).description == null ? new String[]{} : ((Builder)builder).description;
                this.descriptionKey = ((Builder)builder).descriptionKey;
                this.splitRegex = ((Builder)builder).splitRegex == null ? "" : ((Builder)builder).splitRegex;
                this.splitRegexSynopsisLabel = ((Builder)builder).splitRegexSynopsisLabel == null ? "" : ((Builder)builder).splitRegexSynopsisLabel;
                this.paramLabel = CommandLine.empty(((Builder)builder).paramLabel) ? "PARAM" : ((Builder)builder).paramLabel;
                this.hideParamSyntax = ((Builder)builder).hideParamSyntax;
                this.converters = ((Builder)builder).converters == null ? new ITypeConverter[]{} : ((Builder)builder).converters;
                this.parameterConsumer = ((Builder)builder).parameterConsumer;
                this.showDefaultValue = ((Builder)builder).showDefaultValue == null ? Help.Visibility.ON_DEMAND : ((Builder)builder).showDefaultValue;
                this.hidden = ((Builder)builder).hidden;
                this.inherited = ((Builder)builder).inherited;
                this.interactive = ((Builder)builder).interactive;
                this.initialValue = ((Builder)builder).initialValue;
                this.hasInitialValue = ((Builder)builder).hasInitialValue;
                this.initialValueState = ((Builder)builder).initialValueState;
                this.annotatedElement = ((Builder)builder).annotatedElement;
                this.defaultValue = NO_DEFAULT_VALUE.equals(((Builder)builder).defaultValue) ? null : ((Builder)builder).defaultValue;
                this.required = ((Builder)builder).required;
                this.toString = ((Builder)builder).toString;
                this.getter = ((Builder)builder).getter;
                this.setter = ((Builder)builder).setter;
                this.scope = ((Builder)builder).scope;
                this.scopeType = ((Builder)builder).scopeType;
                Range range = ((Builder)builder).arity;
                if (range == null) {
                    range = this.interactive ? Range.valueOf("0") : (this.isOption() ? (((Builder)builder).type == null || CommandLine.isBoolean(((Builder)builder).type) ? Range.valueOf("0") : Range.valueOf("1")) : Range.valueOf("1"));
                    range = range.unspecified(true);
                }
                this.arity = range;
                this.typeInfo = ((Builder)builder).typeInfo == null ? RuntimeTypeInfo.create(((Builder)builder).type, ((Builder)builder).auxiliaryTypes, Collections.<String>emptyList(), this.arity, this.isOption() ? Boolean.TYPE : String.class, this.interactive) : ((Builder)builder).typeInfo;
                if (((Builder)builder).completionCandidates == null && this.typeInfo.isEnum()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string : this.typeInfo.getEnumConstantNames()) {
                        arrayList.add(string.toString());
                    }
                    this.completionCandidates = Collections.unmodifiableList(arrayList);
                } else {
                    this.completionCandidates = ((Builder)builder).completionCandidates;
                }
                if (this.interactive && !this.arity.isValidForInteractiveArgs()) {
                    throw new InitializationException("Interactive options and positional parameters are only supported for arity=0 and arity=0..1; not for arity=" + this.arity);
                }
                if (!CommandLine.empty(this.splitRegex) && !this.typeInfo.isMultiValue() && System.getProperty("picocli.ignore.invalid.split") == null) {
                    throw new InitializationException("Only multi-value options and positional parameters should have a split regex (this check can be disabled by setting system property 'picocli.ignore.invalid.split')");
                }
            }

            void applyInitialValue(Tracer tracer) {
                if (this.hasInitialValue()) {
                    try {
                        this.setter().set(this.initialValue());
                        tracer.debug("Set initial value for %s of type %s to %s.%n", this, this.type(), String.valueOf(this.initialValue()));
                        return;
                    }
                    catch (Exception exception) {
                        tracer.warn("Could not set initial value for %s of type %s to %s: %s%n", this, this.type(), String.valueOf(this.initialValue()), exception);
                        return;
                    }
                }
                tracer.debug("Initial value not available for %s%n", this);
            }

            public boolean required() {
                return this.required && this.defaultValue() == null && this.defaultValueFromProvider() == null;
            }

            public boolean interactive() {
                return this.interactive;
            }

            public String[] description() {
                String[] stringArray = (String[])this.description.clone();
                if (this.messages() != null) {
                    String[] stringArray2 = this.messages().getStringArray(this.descriptionKey(), null);
                    if (stringArray2 == null) {
                        for (String string : this.getAdditionalDescriptionKeys()) {
                            stringArray2 = this.messages().getStringArray(string, null);
                            if (stringArray2 == null) continue;
                            stringArray = stringArray2;
                            break;
                        }
                    } else {
                        stringArray = stringArray2;
                    }
                }
                if (this.commandSpec == null || this.commandSpec.interpolateVariables()) {
                    stringArray = this.expandVariables(stringArray);
                }
                return stringArray;
            }

            protected abstract Collection<String> getAdditionalDescriptionKeys();

            public String descriptionKey() {
                ArgSpec argSpec = this;
                return argSpec.interpolate(argSpec.descriptionKey);
            }

            private String[] expandVariables(String[] desc) {
                String string2;
                if (desc.length == 0) {
                    return desc;
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (this.completionCandidates() != null) {
                    for (String string2 : this.completionCandidates()) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(string2);
                    }
                }
                String string3 = this.defaultValueString(false);
                string2 = this.isOption() ? ((OptionSpec)this).fallbackValue : "";
                String[] stringArray = new String[desc.length];
                for (int i2 = 0; i2 < desc.length; ++i2) {
                    stringArray[i2] = CommandLine.format(desc[i2].replace(DESCRIPTION_VARIABLE_DEFAULT_VALUE, string3.replace("%", "%%")).replace(DESCRIPTION_VARIABLE_FALLBACK_VALUE, string2.replace("%", "%%")).replace(DESCRIPTION_VARIABLE_COMPLETION_CANDIDATES, stringBuilder.toString()), new Object[0]);
                }
                return this.interpolate(stringArray);
            }

            @Deprecated
            public String[] renderedDescription() {
                return this.description();
            }

            public Range arity() {
                return this.arity;
            }

            public String paramLabel() {
                ArgSpec argSpec = this;
                return argSpec.interpolate(argSpec.paramLabel);
            }

            public boolean hideParamSyntax() {
                return this.hideParamSyntax;
            }

            public Class<?>[] auxiliaryTypes() {
                return this.typeInfo.getAuxiliaryTypes();
            }

            public ITypeConverter<?>[] converters() {
                return (ITypeConverter[])this.converters.clone();
            }

            public String splitRegex() {
                ArgSpec argSpec = this;
                return argSpec.interpolate(argSpec.splitRegex);
            }

            public String splitRegexSynopsisLabel() {
                ArgSpec argSpec = this;
                return argSpec.interpolate(argSpec.splitRegexSynopsisLabel);
            }

            public boolean hidden() {
                return this.hidden;
            }

            public boolean inherited() {
                return this.inherited;
            }

            public Class<?> type() {
                return this.typeInfo.getType();
            }

            public ITypeInfo typeInfo() {
                return this.typeInfo;
            }

            public Object userObject() {
                return this.userObject;
            }

            public String defaultValue() {
                ArgSpec argSpec = this;
                return argSpec.interpolate(argSpec.defaultValue);
            }

            public Object initialValue() {
                if (this.initialValueState == InitialValueState.POSTPONED && this.annotatedElement != null) {
                    try {
                        this.initialValue = this.annotatedElement.getter().get();
                    }
                    catch (Exception exception) {}
                    this.initialValueState = InitialValueState.CACHED;
                }
                return this.initialValue;
            }

            public boolean hasInitialValue() {
                return this.hasInitialValue || this.initialValueState == InitialValueState.CACHED || this.initialValueState == InitialValueState.POSTPONED;
            }

            public Help.Visibility showDefaultValue() {
                return this.showDefaultValue;
            }

            public String defaultValueString() {
                return this.defaultValueString(false);
            }

            public String defaultValueString(boolean interpolateVariables) {
                Object object = this.calcDefaultValue(interpolateVariables);
                if (object != null && object.getClass().isArray()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i2 = 0; i2 < Array.getLength(object); ++i2) {
                        stringBuilder.append(i2 > 0 ? ", " : "").append(Array.get(object, i2));
                    }
                    return stringBuilder.insert(0, "[").append("]").toString();
                }
                return String.valueOf(object);
            }

            private Object calcDefaultValue(boolean interpolate) {
                String string = this.defaultValueFromProvider();
                if (string == null) {
                    String string2 = string = interpolate ? this.defaultValue() : this.defaultValue;
                }
                if (string == null) {
                    return this.initialValue();
                }
                return string;
            }

            private String defaultValueFromProvider() {
                if (this.commandSpec == null) {
                    return null;
                }
                String string = null;
                IDefaultValueProvider iDefaultValueProvider = null;
                try {
                    iDefaultValueProvider = this.commandSpec.defaultValueProvider();
                    string = iDefaultValueProvider == null ? null : iDefaultValueProvider.defaultValue(this);
                }
                catch (Exception exception) {
                    new Tracer().info("Error getting default value for %s from %s: %s%n", this, iDefaultValueProvider, exception);
                }
                return string;
            }

            public Iterable<String> completionCandidates() {
                return this.completionCandidates;
            }

            public IParameterConsumer parameterConsumer() {
                return this.parameterConsumer;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            public IScope scope() {
                return this.scope;
            }

            public ScopeType scopeType() {
                return this.scopeType;
            }

            public <T> T getValue() throws PicocliException {
                try {
                    return this.getter.get();
                }
                catch (PicocliException picocliException) {
                    PicocliException picocliException2 = picocliException;
                    throw picocliException;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get value for " + this + ": " + exception, exception);
                }
            }

            public <T> T setValue(T newValue) throws PicocliException {
                try {
                    return this.setter.set(newValue);
                }
                catch (PicocliException picocliException) {
                    PicocliException picocliException2 = picocliException;
                    throw picocliException;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not set value (" + newValue + ") for " + this + ": " + exception, exception);
                }
            }

            @Deprecated
            public <T> T setValue(T newValue, CommandLine commandLine) throws PicocliException {
                return this.setValue(newValue);
            }

            public boolean isMultiValue() {
                return this.typeInfo.isMultiValue();
            }

            public abstract boolean isOption();

            public abstract boolean isPositional();

            public ArgGroupSpec group() {
                return this.group;
            }

            public CommandSpec command() {
                return this.commandSpec;
            }

            public List<String> stringValues() {
                return Collections.unmodifiableList(this.stringValues);
            }

            public List<Object> typedValues() {
                return Collections.unmodifiableList(this.typedValues);
            }

            protected void resetStringValues() {
                this.stringValues = new ArrayList<String>();
            }

            public List<String> originalStringValues() {
                return Collections.unmodifiableList(this.originalStringValues);
            }

            protected void resetOriginalStringValues() {
                this.originalStringValues = new ArrayList<String>();
            }

            protected boolean internalShowDefaultValue(boolean usageHelpShowDefaults) {
                if (this.showDefaultValue() == Help.Visibility.ALWAYS) {
                    return true;
                }
                if (this.showDefaultValue() == Help.Visibility.NEVER) {
                    return false;
                }
                if (this.initialValue() == null && this.defaultValue() == null && this.defaultValueFromProvider() == null) {
                    return false;
                }
                return usageHelpShowDefaults && !CommandLine.isBoolean(this.type());
            }

            public Messages messages() {
                return this.messages;
            }

            public ArgSpec messages(Messages msgs) {
                this.messages = msgs;
                return this;
            }

            public String toString() {
                return this.toString;
            }

            private String scopeString() {
                try {
                    Object t2 = this.scope.get();
                    if (t2 == null) {
                        return "<no user object>";
                    }
                    return t2.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(t2));
                }
                catch (Exception exception) {
                    return "?: " + exception.toString();
                }
            }

            String[] splitValue(String value, ParserSpec parser, Range arity, int consumed) {
                int n2;
                if (this.splitRegex().length() == 0) {
                    return new String[]{value};
                }
                int n3 = n2 = parser.limitSplit() ? Math.max(arity.max - consumed, 0) : 0;
                if (parser.splitQuotedStrings()) {
                    return this.debug(value.split(this.splitRegex(), n2), "Split (ignoring quotes)", value);
                }
                ArgSpec argSpec = this;
                return this.debug(ArgSpec.splitRespectingQuotedStrings(value, n2, parser, argSpec, argSpec.splitRegex()), "Split", value);
            }

            private String[] debug(String[] result, String msg, String value) {
                Tracer tracer = new Tracer();
                if (tracer.isDebug()) {
                    tracer.debug("%s with regex '%s' resulted in %s parts: %s%n", msg, this.splitRegex(), result.length, Arrays.asList(result));
                }
                return result;
            }

            private static String[] splitRespectingQuotedStrings(String value, int limit, ParserSpec parser, ArgSpec argSpec, String splitRegex) {
                int n2;
                int n3;
                LinkedList<String> linkedList = new LinkedList<String>();
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                StringBuilder stringBuilder3 = stringBuilder;
                boolean bl = false;
                boolean bl2 = false;
                block4: for (n2 = 0; n2 < value.length(); n2 += Character.charCount(n3)) {
                    n3 = value.codePointAt(n2);
                    switch (n3) {
                        case 92: {
                            bl = !bl;
                            break;
                        }
                        case 34: {
                            if (!bl) {
                                bl2 = !bl2;
                                StringBuilder stringBuilder4 = stringBuilder3 = bl2 ? stringBuilder2 : stringBuilder;
                                if (bl2) {
                                    stringBuilder.appendCodePoint(n3);
                                    continue block4;
                                }
                                linkedList.add(stringBuilder2.toString());
                                stringBuilder2.setLength(0);
                            }
                            bl = false;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    stringBuilder3.appendCodePoint(n3);
                }
                if (stringBuilder2.length() > 0) {
                    new Tracer().warn("Unbalanced quotes in [%s] for %s (value=%s)%n", stringBuilder2, argSpec, value);
                    linkedList.add(stringBuilder2.toString());
                    stringBuilder2.setLength(0);
                }
                String[] stringArray = stringBuilder.toString().split(splitRegex, limit);
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray[n2] = ArgSpec.restoreQuotedValues(stringArray[n2], linkedList, parser);
                }
                if (!linkedList.isEmpty()) {
                    new Tracer().warn("Unable to respect quotes while splitting value %s for %s (unprocessed remainder: %s)%n", value, argSpec, linkedList);
                    return value.split(splitRegex, limit);
                }
                return stringArray;
            }

            private static String restoreQuotedValues(String part, Queue<String> quotedValues, ParserSpec parser) {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                boolean bl2 = false;
                for (int i2 = 0; i2 < part.length(); i2 += Character.charCount(n2)) {
                    n2 = part.codePointAt(i2);
                    switch (n2) {
                        case 92: {
                            bl = !bl;
                            break;
                        }
                        case 34: {
                            if (bl || (bl2 = !bl2)) break;
                            stringBuilder.append(quotedValues.remove());
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    stringBuilder.appendCodePoint(n2);
                }
                if (parser.trimQuotes()) {
                    return CommandLine.smartUnquote(stringBuilder.toString());
                }
                return stringBuilder.toString();
            }

            protected boolean equalsImpl(ArgSpec other) {
                return Assert.equals(this.defaultValue, other.defaultValue) && Assert.equals(this.arity, other.arity) && Assert.equals(this.hidden, other.hidden) && Assert.equals(this.inherited, other.inherited) && Assert.equals(this.paramLabel, other.paramLabel) && Assert.equals(this.hideParamSyntax, other.hideParamSyntax) && Assert.equals(this.required, other.required) && Assert.equals(this.splitRegex, other.splitRegex) && Assert.equals(this.splitRegexSynopsisLabel, other.splitRegexSynopsisLabel) && Arrays.equals(this.description, other.description) && Assert.equals(this.descriptionKey, other.descriptionKey) && Assert.equals(this.parameterConsumer, other.parameterConsumer) && this.typeInfo.equals(other.typeInfo) && this.scopeType.equals((Object)other.scopeType);
            }

            protected int hashCodeImpl() {
                return 17 + 37 * Assert.hashCode(this.defaultValue) + 37 * Assert.hashCode(this.arity) + 37 * Assert.hashCode(this.hidden) + 37 * Assert.hashCode(this.inherited) + 37 * Assert.hashCode(this.paramLabel) + 37 * Assert.hashCode(this.hideParamSyntax) + 37 * Assert.hashCode(this.required) + 37 * Assert.hashCode(this.splitRegex) + 37 * Assert.hashCode(this.splitRegexSynopsisLabel) + 37 * Arrays.hashCode(this.description) + 37 * Assert.hashCode(this.descriptionKey) + 37 * Assert.hashCode(this.parameterConsumer) + 37 * this.typeInfo.hashCode() + 37 * this.scopeType.hashCode();
            }

            private static String describeTypes(Collection<ArgSpec> args) {
                if (args.isEmpty()) {
                    return "";
                }
                int n2 = 0;
                int n3 = 0;
                for (ArgSpec argSpec : args) {
                    if (argSpec.isOption()) {
                        ++n2;
                        continue;
                    }
                    ++n3;
                }
                if (n2 == 0) {
                    if (n3 == 1) {
                        return "parameter";
                    }
                    return "parameters";
                }
                if (n3 == 0) {
                    if (n2 == 1) {
                        return "option";
                    }
                    return "options";
                }
                return "options and parameters";
            }

            private static String describe(Collection<ArgSpec> args) {
                return ArgSpec.describe(args, ", ", "=", "", "");
            }

            private static String describe(Collection<ArgSpec> args, String separator, String optionParamSeparator, String openingQuote, String closingQuote) {
                StringBuilder stringBuilder = new StringBuilder();
                for (ArgSpec argSpec : args) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(separator);
                    }
                    if (argSpec.isPositional()) {
                        stringBuilder.append(openingQuote).append(argSpec.paramLabel()).append(closingQuote);
                        continue;
                    }
                    stringBuilder.append(openingQuote).append(((OptionSpec)argSpec).longestName());
                    if (argSpec.arity().min() > 0) {
                        stringBuilder.append(optionParamSeparator).append(argSpec.paramLabel());
                    }
                    stringBuilder.append(closingQuote);
                }
                return stringBuilder.toString();
            }

            private static String describe(ArgSpec argSpec, String separator) {
                return ArgSpec.describe(argSpec, separator, argSpec.paramLabel());
            }

            private static String describe(ArgSpec argSpec, String separator, String value) {
                String string;
                String string2 = string = argSpec.isOption() ? ((OptionSpec)argSpec).longestName() : "params[" + ((PositionalParamSpec)argSpec).index() + "]";
                if (argSpec.arity().min > 0) {
                    return string + separator + value;
                }
                return string;
            }

            String interpolate(String value) {
                if (this.commandSpec == null) {
                    return value;
                }
                return this.commandSpec.interpolator.interpolate(value);
            }

            String[] interpolate(String[] values) {
                if (this.commandSpec == null) {
                    return values;
                }
                return this.commandSpec.interpolator.interpolate(values);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static abstract class Builder<T extends Builder<T>> {
                private Object userObject;
                private Range arity;
                private String[] description;
                private String descriptionKey;
                private boolean required;
                private boolean interactive;
                private String paramLabel;
                private boolean hideParamSyntax;
                private String splitRegex;
                private String splitRegexSynopsisLabel;
                private boolean hidden;
                private boolean inherited;
                private Class<?> type;
                private Class<?>[] auxiliaryTypes;
                private ITypeInfo typeInfo;
                private ITypeConverter<?>[] converters;
                private String defaultValue;
                private Object initialValue;
                private boolean hasInitialValue = true;
                private InitialValueState initialValueState = InitialValueState.UNAVAILABLE;
                private Help.Visibility showDefaultValue;
                private Iterable<String> completionCandidates;
                private IParameterConsumer parameterConsumer;
                private String toString;
                private IGetter getter = new ObjectBinding();
                private ISetter setter = (ISetter)((Object)this.getter);
                private IScope scope = new ObjectScope(null);
                private ScopeType scopeType = ScopeType.LOCAL;
                private IAnnotatedElement annotatedElement;

                Builder() {
                }

                Builder(ArgSpec original) {
                    this.userObject = original.userObject;
                    this.arity = original.arity;
                    this.description = original.description;
                    this.descriptionKey = original.descriptionKey;
                    this.required = original.required;
                    this.interactive = original.interactive;
                    this.paramLabel = original.paramLabel;
                    this.hideParamSyntax = original.hideParamSyntax;
                    this.splitRegex = original.splitRegex;
                    this.splitRegexSynopsisLabel = original.splitRegexSynopsisLabel;
                    this.hidden = original.hidden;
                    this.inherited = original.inherited;
                    this.setTypeInfo(original.typeInfo);
                    this.converters = original.converters;
                    this.defaultValue = original.defaultValue;
                    this.annotatedElement = original.annotatedElement;
                    this.initialValue = original.initialValue;
                    this.initialValueState = original.initialValueState;
                    this.hasInitialValue = original.hasInitialValue;
                    this.showDefaultValue = original.showDefaultValue;
                    this.completionCandidates = original.completionCandidates;
                    this.parameterConsumer = original.parameterConsumer;
                    this.toString = original.toString;
                    this.getter = original.getter;
                    this.setter = original.setter;
                    this.scope = original.scope;
                    this.scopeType = original.scopeType;
                }

                Builder(IAnnotatedElement annotatedElement) {
                    this.annotatedElement = annotatedElement;
                    this.userObject = annotatedElement.userObject();
                    this.setTypeInfo(annotatedElement.getTypeInfo());
                    this.toString = annotatedElement.getToString();
                    this.getter = annotatedElement.getter();
                    this.setter = annotatedElement.setter();
                    this.scope = annotatedElement.scope();
                    this.hasInitialValue = annotatedElement.hasInitialValue();
                    if (annotatedElement instanceof IExtensible) {
                        this.initialValueState = ((IExtensible)((Object)annotatedElement)).getExtension(InitialValueState.class);
                    }
                }

                Builder(Option option, IAnnotatedElement annotatedElement, IFactory factory) {
                    this(annotatedElement);
                    this.arity = Range.optionArity(annotatedElement);
                    this.required = option.required();
                    this.paramLabel = Builder.inferLabel(option.paramLabel(), annotatedElement.getName(), annotatedElement.getTypeInfo());
                    this.hideParamSyntax = option.hideParamSyntax();
                    this.interactive = option.interactive();
                    this.description = option.description();
                    this.descriptionKey = option.descriptionKey();
                    this.splitRegex = option.split();
                    this.splitRegexSynopsisLabel = option.splitSynopsisLabel();
                    this.hidden = option.hidden();
                    this.defaultValue = option.defaultValue();
                    this.showDefaultValue = option.showDefaultValue();
                    this.scopeType = option.scope();
                    this.inherited = false;
                    if (factory != null) {
                        this.converters = DefaultFactory.createConverter(factory, option.converter());
                        if (!NoCompletionCandidates.class.equals(option.completionCandidates())) {
                            this.completionCandidates = DefaultFactory.createCompletionCandidates(factory, option.completionCandidates());
                        }
                        if (!NullParameterConsumer.class.equals(option.parameterConsumer())) {
                            this.parameterConsumer = DefaultFactory.createParameterConsumer(factory, option.parameterConsumer());
                        }
                    }
                }

                Builder(Parameters parameters, IAnnotatedElement annotatedElement, IFactory factory) {
                    this(annotatedElement);
                    this.arity = Range.parameterArity(annotatedElement);
                    boolean bl = this.required = this.arity.min > 0;
                    if (parameters == null) {
                        this.paramLabel = Builder.inferLabel(null, annotatedElement.getName(), annotatedElement.getTypeInfo());
                        return;
                    }
                    this.paramLabel = Builder.inferLabel(parameters.paramLabel(), annotatedElement.getName(), annotatedElement.getTypeInfo());
                    this.hideParamSyntax = parameters.hideParamSyntax();
                    this.interactive = parameters.interactive();
                    this.description = parameters.description();
                    this.descriptionKey = parameters.descriptionKey();
                    this.splitRegex = parameters.split();
                    this.splitRegexSynopsisLabel = parameters.splitSynopsisLabel();
                    this.hidden = parameters.hidden();
                    this.defaultValue = parameters.defaultValue();
                    this.showDefaultValue = parameters.showDefaultValue();
                    this.scopeType = parameters.scope();
                    this.inherited = false;
                    if (factory != null) {
                        this.converters = DefaultFactory.createConverter(factory, parameters.converter());
                        if (!NoCompletionCandidates.class.equals(parameters.completionCandidates())) {
                            this.completionCandidates = DefaultFactory.createCompletionCandidates(factory, parameters.completionCandidates());
                        }
                        if (!NullParameterConsumer.class.equals(parameters.parameterConsumer())) {
                            this.parameterConsumer = DefaultFactory.createParameterConsumer(factory, parameters.parameterConsumer());
                        }
                    }
                }

                private static String inferLabel(String label, String fieldName, ITypeInfo typeInfo) {
                    if (!CommandLine.empty(label)) {
                        return label.trim();
                    }
                    String string = fieldName;
                    if (typeInfo.isMap()) {
                        List<ITypeInfo> list = typeInfo.getAuxiliaryTypeInfos();
                        string = list.size() < 2 || list.get(0) == null || list.get(1) == null ? "String=String" : list.get(0).getClassSimpleName() + "=" + list.get(1).getClassSimpleName();
                    }
                    return "<" + string + ">";
                }

                public abstract ArgSpec build();

                protected abstract T self();

                public boolean required() {
                    return this.required;
                }

                public boolean interactive() {
                    return this.interactive;
                }

                public String[] description() {
                    return this.description;
                }

                public String descriptionKey() {
                    return this.descriptionKey;
                }

                public Range arity() {
                    return this.arity;
                }

                public String paramLabel() {
                    return this.paramLabel;
                }

                public boolean hideParamSyntax() {
                    return this.hideParamSyntax;
                }

                public Class<?>[] auxiliaryTypes() {
                    return this.auxiliaryTypes;
                }

                public ITypeConverter<?>[] converters() {
                    return this.converters;
                }

                public String splitRegex() {
                    return this.splitRegex;
                }

                public String splitRegexSynopsisLabel() {
                    return this.splitRegexSynopsisLabel;
                }

                public boolean hidden() {
                    return this.hidden;
                }

                public boolean inherited() {
                    return this.inherited;
                }

                public Class<?> type() {
                    return this.type;
                }

                public ITypeInfo typeInfo() {
                    return this.typeInfo;
                }

                public Object userObject() {
                    return this.userObject;
                }

                public String defaultValue() {
                    return this.defaultValue;
                }

                public Object initialValue() {
                    return this.initialValue;
                }

                public boolean hasInitialValue() {
                    return this.hasInitialValue;
                }

                public Help.Visibility showDefaultValue() {
                    return this.showDefaultValue;
                }

                public Iterable<String> completionCandidates() {
                    return this.completionCandidates;
                }

                public IParameterConsumer parameterConsumer() {
                    return this.parameterConsumer;
                }

                public IGetter getter() {
                    return this.getter;
                }

                public ISetter setter() {
                    return this.setter;
                }

                public IScope scope() {
                    return this.scope;
                }

                public ScopeType scopeType() {
                    return this.scopeType;
                }

                public String toString() {
                    return this.toString;
                }

                public T required(boolean required) {
                    this.required = required;
                    return this.self();
                }

                public T interactive(boolean interactive) {
                    this.interactive = interactive;
                    return this.self();
                }

                public T description(String ... description) {
                    this.description = (String[])Assert.notNull(description, "description").clone();
                    return this.self();
                }

                public T descriptionKey(String descriptionKey) {
                    this.descriptionKey = descriptionKey;
                    return this.self();
                }

                public T arity(String range) {
                    return this.arity(Range.valueOf(range));
                }

                public T arity(Range arity) {
                    this.arity = Assert.notNull(arity, "arity");
                    return this.self();
                }

                public T paramLabel(String paramLabel) {
                    this.paramLabel = Assert.notNull(paramLabel, "paramLabel");
                    return this.self();
                }

                public T hideParamSyntax(boolean hideParamSyntax) {
                    this.hideParamSyntax = hideParamSyntax;
                    return this.self();
                }

                public T auxiliaryTypes(Class<?> ... types) {
                    this.auxiliaryTypes = (Class[])Assert.notNull(types, "types").clone();
                    return this.self();
                }

                public T converters(ITypeConverter<?> ... cs) {
                    this.converters = (ITypeConverter[])Assert.notNull(cs, "type converters").clone();
                    return this.self();
                }

                public T splitRegex(String splitRegex) {
                    this.splitRegex = Assert.notNull(splitRegex, "splitRegex");
                    return this.self();
                }

                public T splitRegexSynopsisLabel(String splitRegexSynopsisLabel) {
                    this.splitRegexSynopsisLabel = Assert.notNull(splitRegexSynopsisLabel, "splitRegexSynopsisLabel");
                    return this.self();
                }

                public T showDefaultValue(Help.Visibility visibility) {
                    this.showDefaultValue = Assert.notNull(visibility, "visibility");
                    return this.self();
                }

                public T completionCandidates(Iterable<String> completionCandidates) {
                    this.completionCandidates = completionCandidates;
                    return this.self();
                }

                public T parameterConsumer(IParameterConsumer parameterConsumer) {
                    this.parameterConsumer = parameterConsumer;
                    return this.self();
                }

                public T hidden(boolean hidden) {
                    this.hidden = hidden;
                    return this.self();
                }

                public T inherited(boolean inherited) {
                    this.inherited = inherited;
                    return this.self();
                }

                public T type(Class<?> propertyType) {
                    this.type = Assert.notNull(propertyType, "type");
                    return this.self();
                }

                public T typeInfo(ITypeInfo typeInfo) {
                    this.setTypeInfo(Assert.notNull(typeInfo, "typeInfo"));
                    return this.self();
                }

                private void setTypeInfo(ITypeInfo newValue) {
                    this.typeInfo = newValue;
                    if (this.typeInfo != null) {
                        this.type = this.typeInfo.getType();
                        this.auxiliaryTypes = this.typeInfo.getAuxiliaryTypes();
                    }
                }

                public T userObject(Object userObject) {
                    this.userObject = Assert.notNull(userObject, "userObject");
                    return this.self();
                }

                public T defaultValue(String defaultValue) {
                    this.defaultValue = defaultValue;
                    return this.self();
                }

                public T initialValue(Object initialValue) {
                    this.initialValue = initialValue;
                    return this.self();
                }

                public T hasInitialValue(boolean hasInitialValue) {
                    this.hasInitialValue = hasInitialValue;
                    return this.self();
                }

                public T getter(IGetter getter) {
                    this.getter = getter;
                    return this.self();
                }

                public T setter(ISetter setter) {
                    this.setter = setter;
                    return this.self();
                }

                public T scope(IScope scope) {
                    this.scope = scope;
                    return this.self();
                }

                public T scopeType(ScopeType scopeType) {
                    this.scopeType = scopeType;
                    return this.self();
                }

                public T withToString(String toString) {
                    this.toString = toString;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum InitialValueState {
            CACHED,
            POSTPONED,
            UNAVAILABLE;

        }

        public static class ParserSpec {
            static final String DEFAULT_SEPARATOR = "=";
            static final String DEFAULT_END_OF_OPTIONS_DELIMITER = "--";
            private boolean abbreviatedOptionsAllowed = false;
            private boolean abbreviatedSubcommandsAllowed = false;
            private boolean aritySatisfiedByAttachedOptionParam = false;
            private Character atFileCommentChar = Character.valueOf('#');
            private boolean caseInsensitiveEnumValuesAllowed = false;
            private boolean collectErrors = false;
            private String endOfOptionsDelimiter = "--";
            private boolean expandAtFiles = true;
            private boolean limitSplit = false;
            private boolean overwrittenOptionsAllowed = false;
            private boolean posixClusteredShortOptionsAllowed = true;
            private String separator;
            private boolean splitQuotedStrings = false;
            private boolean stopAtPositional = false;
            private boolean stopAtUnmatched = false;
            private boolean toggleBooleanFlags = false;
            private boolean trimQuotes = this.shouldTrimQuotes();
            private boolean unmatchedArgumentsAllowed = false;
            private boolean unmatchedOptionsAllowedAsOptionParameters = true;
            private boolean unmatchedOptionsArePositionalParams = false;
            private boolean useSimplifiedAtFiles = false;

            public String separator() {
                if (this.separator == null) {
                    return DEFAULT_SEPARATOR;
                }
                return this.separator;
            }

            public boolean stopAtUnmatched() {
                return this.stopAtUnmatched;
            }

            public boolean stopAtPositional() {
                return this.stopAtPositional;
            }

            public String endOfOptionsDelimiter() {
                return this.endOfOptionsDelimiter;
            }

            public boolean toggleBooleanFlags() {
                return this.toggleBooleanFlags;
            }

            public boolean overwrittenOptionsAllowed() {
                return this.overwrittenOptionsAllowed;
            }

            public boolean unmatchedArgumentsAllowed() {
                return this.unmatchedArgumentsAllowed;
            }

            public boolean abbreviatedSubcommandsAllowed() {
                return this.abbreviatedSubcommandsAllowed;
            }

            public boolean abbreviatedOptionsAllowed() {
                return this.abbreviatedOptionsAllowed;
            }

            public boolean expandAtFiles() {
                return this.expandAtFiles;
            }

            public Character atFileCommentChar() {
                return this.atFileCommentChar;
            }

            public boolean useSimplifiedAtFiles() {
                String string = System.getProperty("picocli.useSimplifiedAtFiles");
                if (string != null) {
                    return "".equals(string) || Boolean.parseBoolean(string);
                }
                return this.useSimplifiedAtFiles;
            }

            public boolean posixClusteredShortOptionsAllowed() {
                return this.posixClusteredShortOptionsAllowed;
            }

            public boolean caseInsensitiveEnumValuesAllowed() {
                return this.caseInsensitiveEnumValuesAllowed;
            }

            public boolean trimQuotes() {
                return this.trimQuotes;
            }

            public boolean splitQuotedStrings() {
                return this.splitQuotedStrings;
            }

            public boolean unmatchedOptionsArePositionalParams() {
                return this.unmatchedOptionsArePositionalParams;
            }

            public boolean unmatchedOptionsAllowedAsOptionParameters() {
                return this.unmatchedOptionsAllowedAsOptionParameters;
            }

            private boolean splitFirst() {
                return this.limitSplit();
            }

            public boolean limitSplit() {
                return this.limitSplit;
            }

            public boolean aritySatisfiedByAttachedOptionParam() {
                return this.aritySatisfiedByAttachedOptionParam;
            }

            public boolean collectErrors() {
                return this.collectErrors;
            }

            public ParserSpec separator(String separator) {
                this.separator = separator;
                return this;
            }

            public ParserSpec stopAtUnmatched(boolean stopAtUnmatched) {
                this.stopAtUnmatched = stopAtUnmatched;
                return this;
            }

            public ParserSpec stopAtPositional(boolean stopAtPositional) {
                this.stopAtPositional = stopAtPositional;
                return this;
            }

            public ParserSpec endOfOptionsDelimiter(String delimiter) {
                this.endOfOptionsDelimiter = Assert.notNull(delimiter, "end-of-options delimiter");
                return this;
            }

            public ParserSpec toggleBooleanFlags(boolean toggleBooleanFlags) {
                this.toggleBooleanFlags = toggleBooleanFlags;
                return this;
            }

            public ParserSpec overwrittenOptionsAllowed(boolean overwrittenOptionsAllowed) {
                this.overwrittenOptionsAllowed = overwrittenOptionsAllowed;
                return this;
            }

            public ParserSpec unmatchedArgumentsAllowed(boolean unmatchedArgumentsAllowed) {
                this.unmatchedArgumentsAllowed = unmatchedArgumentsAllowed;
                return this;
            }

            public ParserSpec abbreviatedSubcommandsAllowed(boolean abbreviatedSubcommandsAllowed) {
                this.abbreviatedSubcommandsAllowed = abbreviatedSubcommandsAllowed;
                return this;
            }

            public ParserSpec abbreviatedOptionsAllowed(boolean abbreviatedOptionsAllowed) {
                this.abbreviatedOptionsAllowed = abbreviatedOptionsAllowed;
                return this;
            }

            public ParserSpec expandAtFiles(boolean expandAtFiles) {
                this.expandAtFiles = expandAtFiles;
                return this;
            }

            public ParserSpec atFileCommentChar(Character atFileCommentChar) {
                this.atFileCommentChar = atFileCommentChar;
                return this;
            }

            public ParserSpec useSimplifiedAtFiles(boolean useSimplifiedAtFiles) {
                this.useSimplifiedAtFiles = useSimplifiedAtFiles;
                return this;
            }

            public ParserSpec posixClusteredShortOptionsAllowed(boolean posixClusteredShortOptionsAllowed) {
                this.posixClusteredShortOptionsAllowed = posixClusteredShortOptionsAllowed;
                return this;
            }

            public ParserSpec caseInsensitiveEnumValuesAllowed(boolean caseInsensitiveEnumValuesAllowed) {
                this.caseInsensitiveEnumValuesAllowed = caseInsensitiveEnumValuesAllowed;
                return this;
            }

            public ParserSpec trimQuotes(boolean trimQuotes) {
                this.trimQuotes = trimQuotes;
                return this;
            }

            public ParserSpec splitQuotedStrings(boolean splitQuotedStrings) {
                this.splitQuotedStrings = splitQuotedStrings;
                return this;
            }

            public ParserSpec unmatchedOptionsAllowedAsOptionParameters(boolean unmatchedOptionsAllowedAsOptionParameters) {
                this.unmatchedOptionsAllowedAsOptionParameters = unmatchedOptionsAllowedAsOptionParameters;
                return this;
            }

            public ParserSpec unmatchedOptionsArePositionalParams(boolean unmatchedOptionsArePositionalParams) {
                this.unmatchedOptionsArePositionalParams = unmatchedOptionsArePositionalParams;
                return this;
            }

            public ParserSpec collectErrors(boolean collectErrors) {
                this.collectErrors = collectErrors;
                return this;
            }

            public ParserSpec aritySatisfiedByAttachedOptionParam(boolean newValue) {
                this.aritySatisfiedByAttachedOptionParam = newValue;
                return this;
            }

            public ParserSpec limitSplit(boolean limitSplit) {
                this.limitSplit = limitSplit;
                return this;
            }

            private boolean shouldTrimQuotes() {
                String string = System.getProperty("picocli.trimQuotes");
                if ("".equals(string)) {
                    string = "true";
                }
                return Boolean.parseBoolean(string);
            }

            void initSeparator(String value) {
                if (Model.initializable(this.separator, value, DEFAULT_SEPARATOR)) {
                    this.separator = value;
                }
            }

            void updateSeparator(String value) {
                if (Model.isNonDefault(value, DEFAULT_SEPARATOR)) {
                    this.separator = value;
                }
            }

            public String toString() {
                return String.format("abbreviatedOptionsAllowed=%s, abbreviatedSubcommandsAllowed=%s, aritySatisfiedByAttachedOptionParam=%s, atFileCommentChar=%s, caseInsensitiveEnumValuesAllowed=%s, collectErrors=%s, endOfOptionsDelimiter=%s, expandAtFiles=%s, limitSplit=%s, overwrittenOptionsAllowed=%s, posixClusteredShortOptionsAllowed=%s, separator=%s, splitQuotedStrings=%s, stopAtPositional=%s, stopAtUnmatched=%s, toggleBooleanFlags=%s, trimQuotes=%s, unmatchedArgumentsAllowed=%s, unmatchedOptionsAllowedAsOptionParameters=%s, unmatchedOptionsArePositionalParams=%s, useSimplifiedAtFiles=%s", this.abbreviatedOptionsAllowed, this.abbreviatedSubcommandsAllowed, this.aritySatisfiedByAttachedOptionParam, this.atFileCommentChar, this.caseInsensitiveEnumValuesAllowed, this.collectErrors, this.endOfOptionsDelimiter, this.expandAtFiles, this.limitSplit, this.overwrittenOptionsAllowed, this.posixClusteredShortOptionsAllowed, this.separator, this.splitQuotedStrings, this.stopAtPositional, this.stopAtUnmatched, this.toggleBooleanFlags, this.trimQuotes, this.unmatchedArgumentsAllowed, this.unmatchedOptionsAllowedAsOptionParameters, this.unmatchedOptionsArePositionalParams, this.useSimplifiedAtFiles);
            }

            void initFrom(ParserSpec settings) {
                this.abbreviatedOptionsAllowed = settings.abbreviatedOptionsAllowed;
                this.abbreviatedSubcommandsAllowed = settings.abbreviatedSubcommandsAllowed;
                this.aritySatisfiedByAttachedOptionParam = settings.aritySatisfiedByAttachedOptionParam;
                this.atFileCommentChar = settings.atFileCommentChar;
                this.caseInsensitiveEnumValuesAllowed = settings.caseInsensitiveEnumValuesAllowed;
                this.collectErrors = settings.collectErrors;
                this.endOfOptionsDelimiter = settings.endOfOptionsDelimiter;
                this.expandAtFiles = settings.expandAtFiles;
                this.limitSplit = settings.limitSplit;
                this.overwrittenOptionsAllowed = settings.overwrittenOptionsAllowed;
                this.posixClusteredShortOptionsAllowed = settings.posixClusteredShortOptionsAllowed;
                this.separator = settings.separator;
                this.splitQuotedStrings = settings.splitQuotedStrings;
                this.stopAtPositional = settings.stopAtPositional;
                this.stopAtUnmatched = settings.stopAtUnmatched;
                this.toggleBooleanFlags = settings.toggleBooleanFlags;
                this.trimQuotes = settings.trimQuotes;
                this.unmatchedArgumentsAllowed = settings.unmatchedArgumentsAllowed;
                this.unmatchedOptionsAllowedAsOptionParameters = settings.unmatchedOptionsAllowedAsOptionParameters;
                this.unmatchedOptionsArePositionalParams = settings.unmatchedOptionsArePositionalParams;
                this.useSimplifiedAtFiles = settings.useSimplifiedAtFiles;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class UsageMessageSpec {
            public static final String SECTION_KEY_HEADER_HEADING = "headerHeading";
            public static final String SECTION_KEY_HEADER = "header";
            public static final String SECTION_KEY_SYNOPSIS_HEADING = "synopsisHeading";
            public static final String SECTION_KEY_SYNOPSIS = "synopsis";
            public static final String SECTION_KEY_DESCRIPTION_HEADING = "descriptionHeading";
            public static final String SECTION_KEY_DESCRIPTION = "description";
            public static final String SECTION_KEY_PARAMETER_LIST_HEADING = "parameterListHeading";
            public static final String SECTION_KEY_AT_FILE_PARAMETER = "atFileParameterList";
            public static final String SECTION_KEY_PARAMETER_LIST = "parameterList";
            public static final String SECTION_KEY_OPTION_LIST_HEADING = "optionListHeading";
            public static final String SECTION_KEY_OPTION_LIST = "optionList";
            public static final String SECTION_KEY_END_OF_OPTIONS = "endOfOptionsList";
            public static final String SECTION_KEY_COMMAND_LIST_HEADING = "commandListHeading";
            public static final String SECTION_KEY_COMMAND_LIST = "commandList";
            public static final String SECTION_KEY_EXIT_CODE_LIST_HEADING = "exitCodeListHeading";
            public static final String SECTION_KEY_EXIT_CODE_LIST = "exitCodeList";
            public static final String SECTION_KEY_FOOTER_HEADING = "footerHeading";
            public static final String SECTION_KEY_FOOTER = "footer";
            public static final int DEFAULT_USAGE_WIDTH = 80;
            private static final int MINIMUM_USAGE_WIDTH = 55;
            static final int DEFAULT_USAGE_LONG_OPTIONS_WIDTH = 20;
            private static final int DEFAULT_SYNOPSIS_INDENT = -1;
            private static final double DEFAULT_SYNOPSIS_AUTO_INDENT_THRESHOLD = 0.5;
            private static final double MAX_SYNOPSIS_AUTO_INDENT_THRESHOLD = 0.9;
            static final Boolean DEFAULT_USAGE_AUTO_WIDTH = Boolean.FALSE;
            static final String DEFAULT_SYNOPSIS_HEADING = "Usage: ";
            static final String DEFAULT_SYNOPSIS_SUBCOMMANDS = "[COMMAND]";
            static final String DEFAULT_COMMAND_LIST_HEADING = "Commands:%n";
            static final char DEFAULT_REQUIRED_OPTION_MARKER = ' ';
            static final Boolean DEFAULT_ABBREVIATE_SYNOPSIS = Boolean.FALSE;
            static final Boolean DEFAULT_SORT_OPTIONS = Boolean.TRUE;
            static final Boolean DEFAULT_SHOW_AT_FILE = Boolean.FALSE;
            static final Boolean DEFAULT_SHOW_END_OF_OPTIONS = Boolean.FALSE;
            static final Boolean DEFAULT_SHOW_DEFAULT_VALUES = Boolean.FALSE;
            static final Boolean DEFAULT_HIDDEN = Boolean.FALSE;
            static final Boolean DEFAULT_ADJUST_CJK = Boolean.TRUE;
            static final String DEFAULT_SINGLE_VALUE = "";
            static final String[] DEFAULT_MULTI_LINE = new String[0];
            private IHelpFactory helpFactory;
            private List<String> sectionKeys = Collections.unmodifiableList(Arrays.asList("headerHeading", "header", "synopsisHeading", "synopsis", "descriptionHeading", "description", "parameterListHeading", "atFileParameterList", "parameterList", "optionListHeading", "optionList", "endOfOptionsList", "commandListHeading", "commandList", "exitCodeListHeading", "exitCodeList", "footerHeading", "footer"));
            private Map<String, IHelpSectionRenderer> helpSectionRendererMap = this.createHelpSectionRendererMap();
            private String[] description;
            private String[] customSynopsis;
            private String[] header;
            private String[] footer;
            private Boolean abbreviateSynopsis;
            private Boolean sortOptions;
            private Boolean showDefaultValues;
            private Boolean showAtFileInUsageHelp;
            private Boolean showEndOfOptionsDelimiterInUsageHelp;
            private Boolean hidden;
            private Boolean autoWidth;
            private Character requiredOptionMarker;
            private String headerHeading;
            private String synopsisHeading;
            private String synopsisSubcommandLabel;
            private Double synopsisAutoIndentThreshold;
            private Integer synopsisIndent;
            private String descriptionHeading;
            private String parameterListHeading;
            private String optionListHeading;
            private String commandListHeading;
            private String footerHeading;
            private String exitCodeListHeading;
            private String[] exitCodeListStrings;
            private Map<String, String> exitCodeList;
            private Integer width;
            private Integer longOptionsMaxWidth;
            private Integer cachedTerminalWidth;
            private final Interpolator interpolator;
            private Messages messages;
            private Boolean adjustLineBreaksForWideCJKCharacters;

            public UsageMessageSpec() {
                this(null);
            }

            UsageMessageSpec(Interpolator interpolator) {
                this.interpolator = interpolator;
            }

            public UsageMessageSpec width(int newValue) {
                if (newValue < 55) {
                    throw new InitializationException("Invalid usage message width " + newValue + ". Minimum value is 55");
                }
                this.width = newValue;
                return this;
            }

            public UsageMessageSpec longOptionsMaxWidth(int newValue) {
                if (newValue < 20) {
                    throw new InitializationException("Invalid usage long options max width " + newValue + ". Minimum value is 20");
                }
                if (newValue > this.width() - 20) {
                    throw new InitializationException("Invalid usage long options max width " + newValue + ". Value must not exceed width(" + this.width() + ") - 20");
                }
                this.longOptionsMaxWidth = newValue;
                return this;
            }

            private int getSysPropertyWidthOrDefault(int defaultWidth, boolean detectTerminalSize) {
                if (detectTerminalSize) {
                    if (this.cachedTerminalWidth == null) {
                        this.cachedTerminalWidth = UsageMessageSpec.getTerminalWidth();
                    }
                    if (this.cachedTerminalWidth < 0) {
                        return defaultWidth;
                    }
                    return Math.max(this.cachedTerminalWidth, 55);
                }
                String string = System.getProperty("picocli.usage.width");
                if (string == null) {
                    return defaultWidth;
                }
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < 55) {
                        new Tracer().warn("Invalid picocli.usage.width value %d. Using minimum usage width %d.%n", n2, 55);
                        return 55;
                    }
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    new Tracer().warn("Invalid picocli.usage.width value '%s'. Using usage width %d.%n", string, defaultWidth);
                    return defaultWidth;
                }
            }

            private static boolean shouldDetectTerminalSize(boolean autoWidthEnabledInApplication) {
                String string = System.getProperty("picocli.usage.width");
                boolean bl = Arrays.asList("AUTO", "TERM", "TERMINAL").contains(String.valueOf(string).toUpperCase(Locale.ENGLISH));
                return bl || autoWidthEnabledInApplication && !UsageMessageSpec.isNumeric(string);
            }

            private static boolean isNumeric(String userValue) {
                try {
                    Integer.parseInt(userValue);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            private static int getTerminalWidth() {
                if (Help.Ansi.isTTY() || Help.Ansi.isPseudoTTY()) {
                    return UsageMessageSpec.detectTerminalWidth();
                }
                return -1;
            }

            private static int detectTerminalWidth() {
                String[] stringArray;
                long l2 = System.nanoTime();
                final Tracer tracer = new Tracer();
                final AtomicInteger atomicInteger = new AtomicInteger(-1);
                if (Help.Ansi.isWindows() && !Help.Ansi.isPseudoTTY()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "cmd.exe";
                    stringArray2[1] = "/c";
                    stringArray = stringArray2;
                    stringArray2[2] = "mode con";
                } else if (Help.Ansi.isMac()) {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "tput";
                    stringArray = stringArray3;
                    stringArray3[1] = "cols";
                } else {
                    String[] stringArray4 = new String[4];
                    stringArray4[0] = "stty";
                    stringArray4[1] = "-a";
                    stringArray4[2] = "-F";
                    stringArray = stringArray4;
                    stringArray4[3] = "/dev/tty";
                }
                final String[] stringArray5 = stringArray;
                Thread thread = new Thread(new Runnable(){

                    public final void run() {
                        BufferedReader bufferedReader;
                        block8: {
                            Process process = null;
                            bufferedReader = null;
                            try {
                                String string;
                                ProcessBuilder processBuilder = new ProcessBuilder(stringArray5);
                                tracer.debug("getTerminalWidth() executing command %s%n", processBuilder.command());
                                Class<?> clazz = Class.forName("java.lang.ProcessBuilder$Redirect");
                                Object object = clazz.getField("INHERIT").get(null);
                                Method method = ProcessBuilder.class.getDeclaredMethod("redirectError", clazz);
                                method.invoke((Object)processBuilder, object);
                                process = processBuilder.start();
                                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                String string2 = UsageMessageSpec.DEFAULT_SINGLE_VALUE;
                                while ((string = bufferedReader.readLine()) != null) {
                                    string2 = string2 + " " + string;
                                }
                                tracer.debug("getTerminalWidth() parsing output: %s%n", string2);
                                Pattern pattern = Help.Ansi.isWindows() && !Help.Ansi.isPseudoTTY() ? Pattern.compile(".*?:\\s*(\\d+)\\D.*?:\\s*(\\d+)\\D.*", 32) : (Help.Ansi.isMac() ? Pattern.compile("(\\s*)(\\d+)\\s*") : Pattern.compile(".*olumns(:)?\\s+(\\d+)\\D.*", 32));
                                Matcher matcher = pattern.matcher(string2);
                                if (matcher.matches()) {
                                    atomicInteger.set(Integer.parseInt(matcher.group(2)));
                                }
                                if (process == null) break block8;
                                process.destroy();
                            }
                            catch (Exception exception) {
                                tracer.debug("getTerminalWidth() ERROR: %s%n", exception);
                                return;
                            }
                            finally {
                                if (process != null) {
                                    process.destroy();
                                }
                                CommandLine.close(bufferedReader);
                            }
                        }
                        CommandLine.close(bufferedReader);
                        return;
                    }
                });
                thread.start();
                long l3 = System.currentTimeMillis();
                while (atomicInteger.intValue() < 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (System.currentTimeMillis() < l3 + 2000L && thread.isAlive()) continue;
                }
                double d2 = (double)(System.nanoTime() - l2) / 1000000.0;
                tracer.debug("getTerminalWidth() returning: %s in %,.1fms%n", atomicInteger, d2);
                return atomicInteger.intValue();
            }

            public int width() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.getSysPropertyWidthOrDefault(usageMessageSpec.width == null ? 80 : this.width, this.autoWidth());
            }

            public int longOptionsMaxWidth() {
                if (this.longOptionsMaxWidth == null) {
                    return 20;
                }
                return this.longOptionsMaxWidth;
            }

            public boolean autoWidth() {
                return UsageMessageSpec.shouldDetectTerminalSize(this.autoWidth == null ? DEFAULT_USAGE_AUTO_WIDTH : this.autoWidth);
            }

            public UsageMessageSpec autoWidth(boolean detectTerminalSize) {
                this.autoWidth = detectTerminalSize;
                return this;
            }

            static boolean isCharCJK(char c2) {
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
                return c2 == '\u00b1' || unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS && c2 < '\uff61';
            }

            private Map<String, IHelpSectionRenderer> createHelpSectionRendererMap() {
                HashMap<String, IHelpSectionRenderer> hashMap = new HashMap<String, IHelpSectionRenderer>();
                hashMap.put(SECTION_KEY_HEADER_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.headerHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_HEADER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.header(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_SYNOPSIS_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.synopsisHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_SYNOPSIS, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        Help help2 = help;
                        return help2.synopsis(help2.synopsisHeadingLength());
                    }
                });
                hashMap.put(SECTION_KEY_DESCRIPTION_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.descriptionHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_DESCRIPTION, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.description(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_PARAMETER_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.parameterListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_AT_FILE_PARAMETER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.atFileParameterList();
                    }
                });
                hashMap.put(SECTION_KEY_PARAMETER_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.parameterList();
                    }
                });
                hashMap.put(SECTION_KEY_OPTION_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.optionListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_OPTION_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.optionList();
                    }
                });
                hashMap.put(SECTION_KEY_END_OF_OPTIONS, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.endOfOptionsList();
                    }
                });
                hashMap.put(SECTION_KEY_COMMAND_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.commandListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_COMMAND_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.commandList();
                    }
                });
                hashMap.put(SECTION_KEY_EXIT_CODE_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.exitCodeListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_EXIT_CODE_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.exitCodeList();
                    }
                });
                hashMap.put(SECTION_KEY_FOOTER_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.footerHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_FOOTER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.footer(new Object[0]);
                    }
                });
                return hashMap;
            }

            public List<String> sectionKeys() {
                return this.sectionKeys;
            }

            public UsageMessageSpec sectionKeys(List<String> keys) {
                this.sectionKeys = Collections.unmodifiableList(new ArrayList<String>(keys));
                return this;
            }

            public Map<String, IHelpSectionRenderer> sectionMap() {
                return this.helpSectionRendererMap;
            }

            public UsageMessageSpec sectionMap(Map<String, IHelpSectionRenderer> map) {
                this.helpSectionRendererMap = new LinkedHashMap<String, IHelpSectionRenderer>(map);
                return this;
            }

            public IHelpFactory helpFactory() {
                if (this.helpFactory == null) {
                    this.helpFactory = new DefaultHelpFactory();
                }
                return this.helpFactory;
            }

            public UsageMessageSpec helpFactory(IHelpFactory helpFactory) {
                this.helpFactory = Assert.notNull(helpFactory, "helpFactory");
                return this;
            }

            private String interpolate(String value) {
                if (this.interpolator == null) {
                    return value;
                }
                return this.interpolator.interpolate(value);
            }

            private String[] interpolate(String[] values) {
                if (this.interpolator == null) {
                    return values;
                }
                return this.interpolator.interpolate(values);
            }

            private String str(String localized, String value, String defaultValue) {
                return this.interpolate(localized != null ? localized : (value != null ? value : defaultValue));
            }

            private String[] arr(String[] localized, String[] value, String[] defaultValue) {
                return this.interpolate(localized != null ? localized : (value != null ? (String[])value.clone() : defaultValue));
            }

            private String resourceStr(String key) {
                if (this.messages == null) {
                    return null;
                }
                return this.messages.getString(key, null);
            }

            private String[] resourceArr(String key) {
                if (this.messages == null) {
                    return null;
                }
                return this.messages.getStringArray(key, null);
            }

            public String headerHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.headerHeading"), this.headerHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] header() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.arr(usageMessageSpec.resourceArr("usage.header"), this.header, DEFAULT_MULTI_LINE);
            }

            public String synopsisHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.synopsisHeading"), this.synopsisHeading, DEFAULT_SYNOPSIS_HEADING);
            }

            public String synopsisSubcommandLabel() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.synopsisSubcommandLabel"), this.synopsisSubcommandLabel, DEFAULT_SYNOPSIS_SUBCOMMANDS);
            }

            public double synopsisAutoIndentThreshold() {
                if (this.synopsisAutoIndentThreshold == null) {
                    return 0.5;
                }
                return this.synopsisAutoIndentThreshold;
            }

            public int synopsisIndent() {
                if (this.synopsisIndent == null) {
                    return -1;
                }
                return this.synopsisIndent;
            }

            public boolean abbreviateSynopsis() {
                return this.abbreviateSynopsis == null ? DEFAULT_ABBREVIATE_SYNOPSIS : this.abbreviateSynopsis;
            }

            public String[] customSynopsis() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.arr(usageMessageSpec.resourceArr("usage.customSynopsis"), this.customSynopsis, DEFAULT_MULTI_LINE);
            }

            public String descriptionHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.descriptionHeading"), this.descriptionHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] description() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.arr(usageMessageSpec.resourceArr("usage.description"), this.description, DEFAULT_MULTI_LINE);
            }

            public String parameterListHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.parameterListHeading"), this.parameterListHeading, DEFAULT_SINGLE_VALUE);
            }

            public String optionListHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.optionListHeading"), this.optionListHeading, DEFAULT_SINGLE_VALUE);
            }

            public boolean sortOptions() {
                return this.sortOptions == null ? DEFAULT_SORT_OPTIONS : this.sortOptions;
            }

            public char requiredOptionMarker() {
                if (this.requiredOptionMarker == null) {
                    return ' ';
                }
                return this.requiredOptionMarker.charValue();
            }

            public boolean showDefaultValues() {
                return this.showDefaultValues == null ? DEFAULT_SHOW_DEFAULT_VALUES : this.showDefaultValues;
            }

            public boolean showAtFileInUsageHelp() {
                return this.showAtFileInUsageHelp == null ? DEFAULT_SHOW_AT_FILE : this.showAtFileInUsageHelp;
            }

            public boolean showEndOfOptionsDelimiterInUsageHelp() {
                return this.showEndOfOptionsDelimiterInUsageHelp == null ? DEFAULT_SHOW_END_OF_OPTIONS : this.showEndOfOptionsDelimiterInUsageHelp;
            }

            public boolean hidden() {
                return this.hidden == null ? DEFAULT_HIDDEN : this.hidden;
            }

            public String commandListHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.commandListHeading"), this.commandListHeading, DEFAULT_COMMAND_LIST_HEADING);
            }

            public String exitCodeListHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.exitCodeListHeading"), this.exitCodeListHeading, DEFAULT_SINGLE_VALUE);
            }

            public Map<String, String> exitCodeList() {
                String[] stringArray = this.resourceArr("usage.exitCodeList");
                if (stringArray == null && this.exitCodeList != null) {
                    return this.exitCodeList;
                }
                Map<String, String> map = UsageMessageSpec.keyValuesMap(this.arr(stringArray, this.exitCodeListStrings, DEFAULT_MULTI_LINE));
                return Collections.unmodifiableMap(map);
            }

            public static Map<String, String> keyValuesMap(String ... entries) {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                if (entries == null) {
                    return linkedHashMap;
                }
                for (int i2 = 0; i2 < entries.length; ++i2) {
                    int n2 = entries[i2].indexOf(58);
                    if (n2 >= 0) {
                        linkedHashMap.put(entries[i2].substring(0, n2), entries[i2].substring(n2 + 1));
                        continue;
                    }
                    new Tracer().info("Ignoring line at index %d: cannot split '%s' into 'key:value'%n", i2, entries[i2]);
                }
                return linkedHashMap;
            }

            public String footerHeading() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.str(usageMessageSpec.resourceStr("usage.footerHeading"), this.footerHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] footer() {
                UsageMessageSpec usageMessageSpec = this;
                return usageMessageSpec.arr(usageMessageSpec.resourceArr("usage.footer"), this.footer, DEFAULT_MULTI_LINE);
            }

            public UsageMessageSpec headerHeading(String headerHeading) {
                this.headerHeading = headerHeading;
                return this;
            }

            public UsageMessageSpec header(String ... header) {
                this.header = header;
                return this;
            }

            public UsageMessageSpec synopsisHeading(String newValue) {
                this.synopsisHeading = newValue;
                return this;
            }

            public UsageMessageSpec synopsisSubcommandLabel(String newValue) {
                this.synopsisSubcommandLabel = newValue;
                return this;
            }

            public UsageMessageSpec synopsisAutoIndentThreshold(double newValue) {
                if (newValue < 0.0 || newValue > 0.9) {
                    throw new IllegalArgumentException("synopsisAutoIndentThreshold must be between 0.0 and 0.9 (inclusive), but was " + newValue);
                }
                this.synopsisAutoIndentThreshold = newValue;
                return this;
            }

            public UsageMessageSpec synopsisIndent(int newValue) {
                this.synopsisIndent = newValue;
                return this;
            }

            public UsageMessageSpec abbreviateSynopsis(boolean newValue) {
                this.abbreviateSynopsis = newValue;
                return this;
            }

            public UsageMessageSpec customSynopsis(String ... customSynopsis) {
                this.customSynopsis = customSynopsis;
                return this;
            }

            public UsageMessageSpec descriptionHeading(String newValue) {
                this.descriptionHeading = newValue;
                return this;
            }

            public UsageMessageSpec description(String ... description) {
                this.description = description;
                return this;
            }

            public UsageMessageSpec parameterListHeading(String newValue) {
                this.parameterListHeading = newValue;
                return this;
            }

            public UsageMessageSpec optionListHeading(String newValue) {
                this.optionListHeading = newValue;
                return this;
            }

            public UsageMessageSpec sortOptions(boolean newValue) {
                this.sortOptions = newValue;
                return this;
            }

            public UsageMessageSpec requiredOptionMarker(char newValue) {
                this.requiredOptionMarker = Character.valueOf(newValue);
                return this;
            }

            public UsageMessageSpec showDefaultValues(boolean newValue) {
                this.showDefaultValues = newValue;
                return this;
            }

            public UsageMessageSpec showAtFileInUsageHelp(boolean newValue) {
                this.showAtFileInUsageHelp = newValue;
                return this;
            }

            public UsageMessageSpec showEndOfOptionsDelimiterInUsageHelp(boolean newValue) {
                this.showEndOfOptionsDelimiterInUsageHelp = newValue;
                return this;
            }

            public UsageMessageSpec hidden(boolean value) {
                this.hidden = value;
                return this;
            }

            public UsageMessageSpec commandListHeading(String newValue) {
                this.commandListHeading = newValue;
                return this;
            }

            public UsageMessageSpec exitCodeListHeading(String newValue) {
                this.exitCodeListHeading = newValue;
                return this;
            }

            public UsageMessageSpec exitCodeList(Map<String, String> newValue) {
                this.exitCodeList = newValue == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(newValue));
                return this;
            }

            public UsageMessageSpec footerHeading(String newValue) {
                this.footerHeading = newValue;
                return this;
            }

            public UsageMessageSpec footer(String ... footer) {
                this.footer = footer;
                return this;
            }

            public Messages messages() {
                return this.messages;
            }

            public UsageMessageSpec messages(Messages msgs) {
                this.messages = msgs;
                return this;
            }

            public boolean adjustLineBreaksForWideCJKCharacters() {
                return this.adjustLineBreaksForWideCJKCharacters == null ? DEFAULT_ADJUST_CJK : this.adjustLineBreaksForWideCJKCharacters;
            }

            public UsageMessageSpec adjustLineBreaksForWideCJKCharacters(boolean adjustForWideChars) {
                this.adjustLineBreaksForWideCJKCharacters = adjustForWideChars;
                return this;
            }

            void updateFromCommand(Command cmd, CommandSpec commandSpec, boolean loadResourceBundle) {
                if (!CommandLine.empty(cmd.resourceBundle())) {
                    if (loadResourceBundle) {
                        this.messages(new Messages(commandSpec, cmd.resourceBundle()));
                    } else {
                        ResourceBundle resourceBundle = null;
                        try {
                            resourceBundle = ResourceBundle.getBundle(cmd.resourceBundle());
                        }
                        catch (MissingResourceException missingResourceException) {}
                        this.messages(new Messages(commandSpec, cmd.resourceBundle(), resourceBundle));
                    }
                }
                if (Model.isNonDefault(cmd.abbreviateSynopsis(), UsageMessageSpec.DEFAULT_ABBREVIATE_SYNOPSIS)) {
                    this.abbreviateSynopsis = cmd.abbreviateSynopsis();
                }
                if (Model.isNonDefault(cmd.usageHelpAutoWidth(), UsageMessageSpec.DEFAULT_USAGE_AUTO_WIDTH)) {
                    this.autoWidth = cmd.usageHelpAutoWidth();
                }
                if (Model.isNonDefault(cmd.commandListHeading(), DEFAULT_COMMAND_LIST_HEADING)) {
                    this.commandListHeading = cmd.commandListHeading();
                }
                if (Model.isNonDefault(cmd.customSynopsis(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.customSynopsis = (String[])cmd.customSynopsis().clone();
                }
                if (Model.isNonDefault(cmd.description(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.description = (String[])cmd.description().clone();
                }
                if (Model.isNonDefault(cmd.descriptionHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.descriptionHeading = cmd.descriptionHeading();
                }
                if (Model.isNonDefault(cmd.exitCodeList(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.exitCodeListStrings = (String[])cmd.exitCodeList().clone();
                }
                if (Model.isNonDefault(cmd.exitCodeListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.exitCodeListHeading = cmd.exitCodeListHeading();
                }
                if (Model.isNonDefault(cmd.footer(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.footer = (String[])cmd.footer().clone();
                }
                if (Model.isNonDefault(cmd.footerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.footerHeading = cmd.footerHeading();
                }
                if (Model.isNonDefault(cmd.header(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.header = (String[])cmd.header().clone();
                }
                if (Model.isNonDefault(cmd.headerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.headerHeading = cmd.headerHeading();
                }
                if (Model.isNonDefault(cmd.hidden(), UsageMessageSpec.DEFAULT_HIDDEN)) {
                    this.hidden = cmd.hidden();
                }
                if (Model.isNonDefault(cmd.optionListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.optionListHeading = cmd.optionListHeading();
                }
                if (Model.isNonDefault(cmd.parameterListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.parameterListHeading = cmd.parameterListHeading();
                }
                if (Model.isNonDefault(Character.valueOf(cmd.requiredOptionMarker()), Character.valueOf(' '))) {
                    this.requiredOptionMarker = Character.valueOf(cmd.requiredOptionMarker());
                }
                if (Model.isNonDefault(cmd.showAtFileInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_AT_FILE)) {
                    this.showAtFileInUsageHelp = cmd.showAtFileInUsageHelp();
                }
                if (Model.isNonDefault(cmd.showDefaultValues(), UsageMessageSpec.DEFAULT_SHOW_DEFAULT_VALUES)) {
                    this.showDefaultValues = cmd.showDefaultValues();
                }
                if (Model.isNonDefault(cmd.showEndOfOptionsDelimiterInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_END_OF_OPTIONS)) {
                    this.showEndOfOptionsDelimiterInUsageHelp = cmd.showEndOfOptionsDelimiterInUsageHelp();
                }
                if (Model.isNonDefault(cmd.sortOptions(), UsageMessageSpec.DEFAULT_SORT_OPTIONS)) {
                    this.sortOptions = cmd.sortOptions();
                }
                if (Model.isNonDefault(cmd.synopsisHeading(), DEFAULT_SYNOPSIS_HEADING)) {
                    this.synopsisHeading = cmd.synopsisHeading();
                }
                if (Model.isNonDefault(cmd.synopsisSubcommandLabel(), DEFAULT_SYNOPSIS_SUBCOMMANDS)) {
                    this.synopsisSubcommandLabel = cmd.synopsisSubcommandLabel();
                }
                if (Model.isNonDefault(cmd.usageHelpWidth(), 80)) {
                    this.width(cmd.usageHelpWidth());
                }
            }

            void initFromMixin(UsageMessageSpec mixin, CommandSpec commandSpec) {
                if (Model.initializable(this.abbreviateSynopsis, mixin.abbreviateSynopsis(), UsageMessageSpec.DEFAULT_ABBREVIATE_SYNOPSIS)) {
                    this.abbreviateSynopsis = mixin.abbreviateSynopsis();
                }
                if (Model.initializable(this.adjustLineBreaksForWideCJKCharacters, mixin.adjustLineBreaksForWideCJKCharacters(), UsageMessageSpec.DEFAULT_ADJUST_CJK)) {
                    this.adjustLineBreaksForWideCJKCharacters = mixin.adjustLineBreaksForWideCJKCharacters();
                }
                if (Model.initializable(this.autoWidth, mixin.autoWidth(), UsageMessageSpec.DEFAULT_USAGE_AUTO_WIDTH)) {
                    this.autoWidth = mixin.autoWidth();
                }
                if (Model.initializable(this.commandListHeading, mixin.commandListHeading(), DEFAULT_COMMAND_LIST_HEADING)) {
                    this.commandListHeading = mixin.commandListHeading();
                }
                if (Model.initializable(this.customSynopsis, mixin.customSynopsis(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.customSynopsis = (String[])mixin.customSynopsis().clone();
                }
                if (Model.initializable(this.description, mixin.description(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.description = (String[])mixin.description().clone();
                }
                if (Model.initializable(this.descriptionHeading, mixin.descriptionHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.descriptionHeading = mixin.descriptionHeading();
                }
                if (Model.initializable(this.exitCodeList, mixin.exitCodeList(), Collections.emptyMap()) && this.exitCodeListStrings == null) {
                    this.exitCodeList = Collections.unmodifiableMap(new LinkedHashMap<String, String>(mixin.exitCodeList()));
                }
                if (Model.initializable(this.exitCodeListHeading, mixin.exitCodeListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.exitCodeListHeading = mixin.exitCodeListHeading();
                }
                if (Model.initializable(this.footer, mixin.footer(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.footer = (String[])mixin.footer().clone();
                }
                if (Model.initializable(this.footerHeading, mixin.footerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.footerHeading = mixin.footerHeading();
                }
                if (Model.initializable(this.header, mixin.header(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.header = (String[])mixin.header().clone();
                }
                if (Model.initializable(this.headerHeading, mixin.headerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.headerHeading = mixin.headerHeading();
                }
                if (Model.initializable(this.hidden, mixin.hidden(), UsageMessageSpec.DEFAULT_HIDDEN)) {
                    this.hidden = mixin.hidden();
                }
                if (Model.initializable(this.longOptionsMaxWidth, mixin.longOptionsMaxWidth(), 20)) {
                    this.longOptionsMaxWidth = mixin.longOptionsMaxWidth();
                }
                if (Messages.empty(this.messages) && Messages.resourceBundleBaseName(this.messages) == null) {
                    this.messages(Messages.copy(commandSpec, mixin.messages()));
                }
                if (Model.initializable(this.optionListHeading, mixin.optionListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.optionListHeading = mixin.optionListHeading();
                }
                if (Model.initializable(this.parameterListHeading, mixin.parameterListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.parameterListHeading = mixin.parameterListHeading();
                }
                if (Model.initializable(this.requiredOptionMarker, Character.valueOf(mixin.requiredOptionMarker()), Character.valueOf(' '))) {
                    this.requiredOptionMarker = Character.valueOf(mixin.requiredOptionMarker());
                }
                if (Model.initializable(this.showAtFileInUsageHelp, mixin.showAtFileInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_AT_FILE)) {
                    this.showAtFileInUsageHelp = mixin.showAtFileInUsageHelp();
                }
                if (Model.initializable(this.showDefaultValues, mixin.showDefaultValues(), UsageMessageSpec.DEFAULT_SHOW_DEFAULT_VALUES)) {
                    this.showDefaultValues = mixin.showDefaultValues();
                }
                if (Model.initializable(this.showEndOfOptionsDelimiterInUsageHelp, mixin.showEndOfOptionsDelimiterInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_END_OF_OPTIONS)) {
                    this.showEndOfOptionsDelimiterInUsageHelp = mixin.showEndOfOptionsDelimiterInUsageHelp();
                }
                if (Model.initializable(this.sortOptions, mixin.sortOptions(), UsageMessageSpec.DEFAULT_SORT_OPTIONS)) {
                    this.sortOptions = mixin.sortOptions();
                }
                if (Model.initializable(this.synopsisHeading, mixin.synopsisHeading(), DEFAULT_SYNOPSIS_HEADING)) {
                    this.synopsisHeading = mixin.synopsisHeading();
                }
                if (Model.initializable(this.synopsisSubcommandLabel, mixin.synopsisSubcommandLabel(), DEFAULT_SYNOPSIS_SUBCOMMANDS)) {
                    this.synopsisHeading = mixin.synopsisHeading();
                }
                if (Model.initializable(this.width, mixin.width(), 80)) {
                    this.width = mixin.width();
                }
            }

            void initFrom(UsageMessageSpec settings, CommandSpec commandSpec) {
                this.abbreviateSynopsis = settings.abbreviateSynopsis;
                this.adjustLineBreaksForWideCJKCharacters = settings.adjustLineBreaksForWideCJKCharacters;
                this.autoWidth = settings.autoWidth;
                this.commandListHeading = settings.commandListHeading;
                this.customSynopsis = settings.customSynopsis;
                this.description = settings.description;
                this.descriptionHeading = settings.descriptionHeading;
                this.exitCodeList = settings.exitCodeList;
                this.exitCodeListHeading = settings.exitCodeListHeading;
                this.exitCodeListStrings = settings.exitCodeListStrings;
                this.footer = settings.footer;
                this.footerHeading = settings.footerHeading;
                this.header = settings.header;
                this.headerHeading = settings.headerHeading;
                this.helpFactory = settings.helpFactory;
                this.helpSectionRendererMap = settings.helpSectionRendererMap;
                this.hidden = settings.hidden;
                this.longOptionsMaxWidth = settings.longOptionsMaxWidth;
                this.messages = Messages.copy(commandSpec, settings.messages());
                this.optionListHeading = settings.optionListHeading;
                this.parameterListHeading = settings.parameterListHeading;
                this.requiredOptionMarker = settings.requiredOptionMarker;
                this.sectionKeys = settings.sectionKeys;
                this.showAtFileInUsageHelp = settings.showAtFileInUsageHelp;
                this.showDefaultValues = settings.showDefaultValues;
                this.showEndOfOptionsDelimiterInUsageHelp = settings.showEndOfOptionsDelimiterInUsageHelp;
                this.sortOptions = settings.sortOptions;
                this.synopsisAutoIndentThreshold = settings.synopsisAutoIndentThreshold;
                this.synopsisHeading = settings.synopsisHeading;
                this.synopsisIndent = settings.synopsisIndent;
                this.synopsisSubcommandLabel = settings.synopsisSubcommandLabel;
                this.width = settings.width;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class CommandSpec {
            public static final String DEFAULT_COMMAND_NAME = "<main class>";
            static final Boolean DEFAULT_IS_HELP_COMMAND = Boolean.FALSE;
            static final Boolean DEFAULT_IS_ADD_METHOD_SUBCOMMANDS = Boolean.TRUE;
            static final Boolean DEFAULT_INTERPOLATE_VARIABLES = Boolean.TRUE;
            static final Boolean DEFAULT_SUBCOMMANDS_REPEATABLE = Boolean.FALSE;
            private final CaseAwareLinkedMap<String, CommandLine> commands = new CaseAwareLinkedMap();
            private final CaseAwareLinkedMap<String, OptionSpec> optionsByNameMap = new CaseAwareLinkedMap();
            private final CaseAwareLinkedMap<String, OptionSpec> negatedOptionsByNameMap = new CaseAwareLinkedMap();
            private final CaseAwareLinkedMap<Character, OptionSpec> posixOptionsByKeyMap = new CaseAwareLinkedMap();
            private final Map<String, CommandSpec> mixins = new LinkedHashMap<String, CommandSpec>();
            private final Map<String, IAnnotatedElement> mixinAnnotatedElements = new LinkedHashMap<String, IAnnotatedElement>();
            private final List<ArgSpec> requiredArgs = new ArrayList<ArgSpec>();
            private final List<ArgSpec> args = new ArrayList<ArgSpec>();
            private final List<OptionSpec> options = new ArrayList<OptionSpec>();
            private final List<PositionalParamSpec> positionalParameters = new ArrayList<PositionalParamSpec>();
            private final List<UnmatchedArgsBinding> unmatchedArgs = new ArrayList<UnmatchedArgsBinding>();
            private final List<IAnnotatedElement> specElements = new ArrayList<IAnnotatedElement>();
            private final List<IAnnotatedElement> parentCommandElements = new ArrayList<IAnnotatedElement>();
            private final List<ArgGroupSpec> groups = new ArrayList<ArgGroupSpec>();
            private final ParserSpec parser = new ParserSpec();
            private final Interpolator interpolator = new Interpolator(this);
            private final UsageMessageSpec usageMessage = new UsageMessageSpec(this.interpolator);
            private TypedMember[] methodParams;
            private final CommandUserObject userObject;
            private CommandLine commandLine;
            private CommandSpec parent;
            private Boolean isAddMethodSubcommands;
            private Boolean interpolateVariables;
            private String name;
            private Set<String> aliases = new LinkedHashSet<String>();
            private Boolean isHelpCommand;
            private IVersionProvider versionProvider;
            private IDefaultValueProvider defaultValueProvider;
            private INegatableOptionTransformer negatableOptionTransformer = RegexTransformer.createDefault();
            private Boolean subcommandsRepeatable;
            private String[] version;
            private String toString;
            private Integer exitCodeOnSuccess;
            private Integer exitCodeOnUsageHelp;
            private Integer exitCodeOnVersionHelp;
            private Integer exitCodeOnInvalidInput;
            private Integer exitCodeOnExecutionException;

            private CommandSpec(CommandUserObject userObject) {
                this.userObject = userObject;
                this.userObject.commandSpec = this;
            }

            private CommandSpec copy() {
                Object object = this.userObject.type == null ? this.userObject.instance : this.userObject.type;
                CommandSpec commandSpec = object == null ? CommandSpec.create() : CommandSpec.forAnnotatedObject(object, this.userObject.factory);
                (object == null ? CommandSpec.create() : CommandSpec.forAnnotatedObject(object, this.userObject.factory)).commandLine = this.commandLine;
                commandSpec.parent = this.parent;
                commandSpec.methodParams = this.methodParams;
                commandSpec.isAddMethodSubcommands = this.isAddMethodSubcommands;
                commandSpec.interpolateVariables = this.interpolateVariables;
                commandSpec.name = this.name;
                commandSpec.aliases = this.aliases;
                commandSpec.isHelpCommand = this.isHelpCommand;
                commandSpec.versionProvider = this.versionProvider;
                commandSpec.defaultValueProvider = this.defaultValueProvider;
                commandSpec.negatableOptionTransformer = this.negatableOptionTransformer;
                commandSpec.subcommandsRepeatable = this.subcommandsRepeatable;
                commandSpec.version = this.version;
                commandSpec.toString = this.toString;
                commandSpec.exitCodeOnSuccess = this.exitCodeOnSuccess;
                commandSpec.exitCodeOnUsageHelp = this.exitCodeOnUsageHelp;
                commandSpec.exitCodeOnVersionHelp = this.exitCodeOnVersionHelp;
                commandSpec.exitCodeOnInvalidInput = this.exitCodeOnInvalidInput;
                commandSpec.exitCodeOnExecutionException = this.exitCodeOnExecutionException;
                commandSpec.usageMessage.initFrom(this.usageMessage, this);
                commandSpec.parser(this.parser);
                return commandSpec;
            }

            public static CommandSpec create() {
                return CommandSpec.wrapWithoutInspection(null);
            }

            public static CommandSpec wrapWithoutInspection(Object userObject) {
                return new CommandSpec(CommandUserObject.create(userObject, CommandLine.defaultFactory()));
            }

            public static CommandSpec wrapWithoutInspection(Object userObject, IFactory factory) {
                return new CommandSpec(CommandUserObject.create(userObject, factory));
            }

            public static CommandSpec forAnnotatedObject(Object userObject) {
                return CommandSpec.forAnnotatedObject(userObject, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObject(Object userObject, IFactory factory) {
                return CommandReflection.extractCommandSpec(userObject, factory, true);
            }

            public static CommandSpec forAnnotatedObjectLenient(Object userObject) {
                return CommandSpec.forAnnotatedObjectLenient(userObject, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObjectLenient(Object userObject, IFactory factory) {
                return CommandReflection.extractCommandSpec(userObject, factory, false);
            }

            void validate() {
                Collections.sort(this.positionalParameters, new PositionalParametersSorter());
                CommandLine.validatePositionalParameters(this.positionalParameters);
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (OptionSpec object2 : this.options()) {
                    if (object2.usageHelp()) {
                        arrayList3.add(object2.longestName());
                        if (!CommandLine.isBoolean(object2.type())) {
                            arrayList.add(object2.longestName());
                        }
                    }
                    if (!object2.versionHelp()) continue;
                    arrayList4.add(object2.longestName());
                    if (CommandLine.isBoolean(object2.type())) continue;
                    arrayList2.add(object2.longestName());
                }
                String string = "Non-boolean options like %s should not be marked as '%s=true'. Usually a command has one %s boolean flag that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.";
                String string2 = "Multiple options %s are marked as '%s=true'. Usually a command has only one %s option that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.%n";
                if (!arrayList.isEmpty()) {
                    throw new InitializationException(String.format(string, arrayList, "usageHelp", "--help", "usage help message"));
                }
                if (!arrayList2.isEmpty()) {
                    throw new InitializationException(String.format(string, arrayList2, "versionHelp", "--version", "version information"));
                }
                if (arrayList3.size() > 1) {
                    new Tracer().warn(string2, arrayList3, "usageHelp", "--help", "usage help message");
                }
                if (arrayList4.size() > 1) {
                    new Tracer().warn(string2, arrayList4, "versionHelp", "--version", "version information");
                }
            }

            public Object userObject() {
                return this.userObject.getInstance();
            }

            public CommandLine commandLine() {
                return this.commandLine;
            }

            protected CommandSpec commandLine(CommandLine commandLine) {
                this.commandLine = commandLine;
                for (CommandSpec object : this.mixins.values()) {
                    object.commandLine(commandLine);
                }
                for (CommandLine commandLine2 : this.commands.values()) {
                    commandLine2.getCommandSpec().parent(this);
                }
                return this;
            }

            public ParserSpec parser() {
                return this.parser;
            }

            public CommandSpec parser(ParserSpec settings) {
                this.parser.initFrom(settings);
                return this;
            }

            public UsageMessageSpec usageMessage() {
                return this.usageMessage;
            }

            public CommandSpec usageMessage(UsageMessageSpec settings) {
                this.usageMessage.initFrom(settings, this);
                return this;
            }

            public boolean subcommandsCaseInsensitive() {
                return this.commands.isCaseInsensitive();
            }

            public CommandSpec subcommandsCaseInsensitive(boolean caseInsensitiveSubcommands) {
                if (this.subcommandsCaseInsensitive() == caseInsensitiveSubcommands) {
                    return this;
                }
                new Tracer().debug("Changing subcommandsCaseInsensitive to %s%n", caseInsensitiveSubcommands);
                this.commands.setCaseInsensitive(caseInsensitiveSubcommands);
                return this;
            }

            public boolean optionsCaseInsensitive() {
                return this.optionsByNameMap.isCaseInsensitive();
            }

            public CommandSpec optionsCaseInsensitive(boolean caseInsensitiveOptions) {
                if (this.optionsCaseInsensitive() == caseInsensitiveOptions) {
                    return this;
                }
                new Tracer().debug("Changing optionsCaseInsensitive to %s%n", caseInsensitiveOptions);
                this.optionsByNameMap.setCaseInsensitive(caseInsensitiveOptions);
                this.negatedOptionsByNameMap.setCaseInsensitive(caseInsensitiveOptions);
                this.posixOptionsByKeyMap.setCaseInsensitive(caseInsensitiveOptions);
                RegexTransformer regexTransformer = caseInsensitiveOptions ? RegexTransformer.createCaseInsensitive() : RegexTransformer.createDefault();
                this.negatableOptionTransformer(regexTransformer);
                return this;
            }

            public String resourceBundleBaseName() {
                return Messages.resourceBundleBaseName(this.usageMessage.messages());
            }

            public CommandSpec resourceBundleBaseName(String resourceBundleBaseName) {
                ResourceBundle resourceBundle = CommandLine.empty(resourceBundleBaseName) ? null : ResourceBundle.getBundle(resourceBundleBaseName);
                this.setBundle(resourceBundleBaseName, resourceBundle);
                return this;
            }

            public ResourceBundle resourceBundle() {
                return Messages.resourceBundle(this.usageMessage.messages());
            }

            public CommandSpec resourceBundle(ResourceBundle bundle) {
                this.setBundle(Messages.extractName(bundle), bundle);
                return this;
            }

            private void setBundle(String bundleBaseName, ResourceBundle bundle) {
                this.usageMessage().messages(new Messages(this, bundleBaseName, bundle));
                this.updateArgSpecMessages();
            }

            private void updateArgSpecMessages() {
                for (OptionSpec object : this.options()) {
                    object.messages(this.usageMessage().messages());
                }
                for (PositionalParamSpec positionalParamSpec : this.positionalParameters()) {
                    positionalParamSpec.messages(this.usageMessage().messages());
                }
                for (ArgGroupSpec argGroupSpec : this.argGroups()) {
                    argGroupSpec.messages(this.usageMessage().messages());
                }
            }

            public Map<String, CommandLine> subcommands() {
                return Collections.unmodifiableMap(this.commands);
            }

            public CommandSpec addSubcommand(String name, CommandSpec subcommand) {
                return this.addSubcommand(name, new CommandLine(subcommand));
            }

            public CommandSpec addSubcommand(String name, CommandLine subCommandLine) {
                CommandSpec commandSpec = subCommandLine.getCommandSpec();
                String string = this.validateSubcommandName(name, commandSpec);
                Tracer tracer = new Tracer();
                if (tracer.isDebug()) {
                    tracer.debug("Adding subcommand '%s' to '%s'%n", string, this.qualifiedName());
                }
                String string2 = this.commands.getCaseSensitiveKey(string);
                CommandLine commandLine = this.commands.put(string, subCommandLine);
                if (commandLine != null && commandLine != subCommandLine) {
                    throw new DuplicateNameException("Another subcommand named '" + string2 + "' already exists for command '" + this.name() + "'");
                }
                if (commandSpec.name == null) {
                    commandSpec.name(string);
                }
                commandSpec.parent(this);
                for (String string3 : commandSpec.aliases()) {
                    if (tracer.isDebug()) {
                        tracer.debug("Adding alias '%s' for '%s'%n", (this.parent == null ? "" : this.parent.qualifiedName() + " ") + string3, this.qualifiedName());
                    }
                    if ((commandLine = this.commands.put(string3, subCommandLine)) == null || commandLine == subCommandLine) continue;
                    throw new DuplicateNameException("Alias '" + string3 + "' for subcommand '" + string + "' is already used by another subcommand of '" + this.name() + "'");
                }
                commandSpec.initCommandHierarchyWithResourceBundle(this.resourceBundleBaseName(), this.resourceBundle());
                for (ArgSpec argSpec : this.args()) {
                    if (argSpec.scopeType() != ScopeType.INHERIT) continue;
                    commandSpec.add(argSpec.isOption() ? ((OptionSpec.Builder)OptionSpec.builder((OptionSpec)argSpec).inherited(true)).build() : ((PositionalParamSpec.Builder)PositionalParamSpec.builder((PositionalParamSpec)argSpec).inherited(true)).build());
                }
                return this;
            }

            private String validateSubcommandName(String name, CommandSpec subSpec) {
                String string = name == null ? subSpec.name : name;
                if (string == null && !subSpec.aliases.isEmpty()) {
                    Iterator<String> iterator = subSpec.aliases.iterator();
                    string = iterator.next();
                    iterator.remove();
                }
                if (string == null) {
                    throw new InitializationException("Cannot add subcommand with null name to " + this.qualifiedName());
                }
                return string;
            }

            private void initCommandHierarchyWithResourceBundle(String bundleBaseName, ResourceBundle rb) {
                if (this.resourceBundle() == null && this.resourceBundleBaseName() == null) {
                    this.setBundle(bundleBaseName, rb);
                }
                for (CommandLine commandLine : this.commands.values()) {
                    commandLine.getCommandSpec().initCommandHierarchyWithResourceBundle(bundleBaseName, rb);
                }
            }

            public boolean isAddMethodSubcommands() {
                return this.isAddMethodSubcommands == null ? DEFAULT_IS_ADD_METHOD_SUBCOMMANDS : this.isAddMethodSubcommands;
            }

            public CommandSpec setAddMethodSubcommands(Boolean addMethodSubcommands) {
                this.isAddMethodSubcommands = addMethodSubcommands;
                return this;
            }

            public boolean interpolateVariables() {
                return this.interpolateVariables == null ? DEFAULT_INTERPOLATE_VARIABLES : this.interpolateVariables;
            }

            public CommandSpec interpolateVariables(Boolean interpolate) {
                this.interpolateVariables = interpolate;
                return this;
            }

            public CommandSpec addMethodSubcommands() {
                return this.addMethodSubcommands(new DefaultFactory());
            }

            public CommandSpec addMethodSubcommands(IFactory factory) {
                if (this.userObject.isMethod()) {
                    throw new InitializationException("Cannot discover subcommand methods of this Command Method: " + this.userObject);
                }
                for (CommandLine commandLine : CommandSpec.createMethodSubcommands(this.userObject.getType(), factory, true)) {
                    this.addSubcommand(commandLine.getCommandName(), commandLine);
                }
                this.isAddMethodSubcommands = Boolean.TRUE;
                return this;
            }

            static List<CommandLine> createMethodSubcommands(Class<?> cls, IFactory factory, boolean includeInherited) {
                ArrayList<CommandLine> arrayList = new ArrayList<CommandLine>();
                for (Method method : CommandLine.getCommandMethods(cls, null, includeInherited)) {
                    arrayList.add(new CommandLine(method, factory));
                }
                return arrayList;
            }

            public CommandSpec parent() {
                return this.parent;
            }

            public CommandSpec root() {
                CommandSpec commandSpec = this;
                while (commandSpec.parent != null) {
                    commandSpec = commandSpec.parent;
                }
                return commandSpec;
            }

            public CommandSpec parent(CommandSpec parent) {
                this.parent = parent;
                this.injectParentCommand(parent.userObject);
                return this;
            }

            public CommandSpec add(ArgSpec arg) {
                if (arg.isOption()) {
                    return this.addOption((OptionSpec)arg);
                }
                return this.addPositional((PositionalParamSpec)arg);
            }

            public CommandSpec addOption(OptionSpec option) {
                Tracer tracer = new Tracer();
                for (String string : this.interpolator.interpolate(option.names())) {
                    String string2 = this.optionsByNameMap.getCaseSensitiveKey(string);
                    OptionSpec optionSpec = this.optionsByNameMap.put(string, option);
                    if (optionSpec != null) {
                        throw DuplicateOptionAnnotationsException.create(string2, option, optionSpec);
                    }
                    String string3 = this.negatedOptionsByNameMap.getCaseSensitiveKey(string);
                    OptionSpec optionSpec2 = this.negatedOptionsByNameMap.get(string);
                    if (optionSpec2 != null && optionSpec2 != option) {
                        throw DuplicateOptionAnnotationsException.create(string3, option, optionSpec2);
                    }
                    if (string.length() != 2 || !string.startsWith("-")) continue;
                    this.posixOptionsByKeyMap.put(Character.valueOf(string.charAt(1)), option);
                }
                this.options.add(option);
                this.addOptionNegative(option, tracer);
                if (option.scopeType() == ScopeType.INHERIT) {
                    HashSet hashSet = new HashSet();
                    for (CommandLine commandLine : this.subcommands().values()) {
                        if (hashSet.contains(commandLine)) continue;
                        commandLine.getCommandSpec().addOption(((OptionSpec.Builder)OptionSpec.builder(option).inherited(true)).build());
                        hashSet.add(commandLine);
                    }
                }
                return this.addArg(option);
            }

            private void addOptionNegative(OptionSpec option, Tracer tracer) {
                if (option.negatable()) {
                    if (!option.typeInfo().isBoolean()) {
                        throw new InitializationException("Only boolean options can be negatable, but " + option + " is of type " + option.typeInfo().getClassName());
                    }
                    for (String string : this.interpolator.interpolate(option.names())) {
                        String string2 = this.negatableOptionTransformer().makeNegative(string, this);
                        if (string.equals(string2)) {
                            tracer.debug("Option %s is negatable, but has no negative form.%n", string);
                            continue;
                        }
                        tracer.debug("Option %s is negatable, registering negative name %s.%n", string, string2);
                        String string3 = this.negatedOptionsByNameMap.getCaseSensitiveKey(string2);
                        OptionSpec optionSpec = this.negatedOptionsByNameMap.put(string2, option);
                        if (optionSpec == null) {
                            string3 = this.optionsByNameMap.getCaseSensitiveKey(string2);
                            optionSpec = this.optionsByNameMap.get(string2);
                        }
                        if (optionSpec == null) continue;
                        throw DuplicateOptionAnnotationsException.create(string3, option, optionSpec);
                    }
                }
            }

            private void resetNegativeOptionNames() {
                Tracer tracer = new Tracer();
                tracer.debug("Clearing negatedOptionsByNameMap...%n", new Object[0]);
                this.negatedOptionsByNameMap.clear();
                for (OptionSpec optionSpec : this.options) {
                    this.addOptionNegative(optionSpec, tracer);
                }
            }

            public CommandSpec addPositional(PositionalParamSpec positional) {
                this.positionalParameters.add(positional);
                this.addArg(positional);
                if (positional.index().isUnresolved()) {
                    positional.index = Range.valueOf(this.interpolator.interpolate(positional.index().originalValue));
                    positional.initCapacity();
                }
                this.adjustRelativeIndices(positional);
                if (positional.scopeType() == ScopeType.INHERIT) {
                    HashSet<CommandLine> hashSet = new HashSet<CommandLine>(this.subcommands().values());
                    for (CommandLine commandLine : hashSet) {
                        commandLine.getCommandSpec().addPositional(((PositionalParamSpec.Builder)PositionalParamSpec.builder(positional).inherited(true)).build());
                    }
                }
                return this;
            }

            private void adjustRelativeIndices(PositionalParamSpec newlyAdded) {
                Collections.sort(this.positionalParameters, new PositionalParametersSorter());
                for (int i2 = this.positionalParameters.indexOf(newlyAdded); i2 < this.positionalParameters.size(); ++i2) {
                    int n2;
                    PositionalParamSpec positionalParamSpec = this.positionalParameters.get(i2);
                    Range range = positionalParamSpec.index();
                    if (!range.isRelative()) continue;
                    int n3 = n2 = i2 == 0 ? -1 : this.positionalParameters.get(i2 - 1).index().max();
                    int n4 = i2 == 0 ? 0 : (n2 == Integer.MAX_VALUE ? n2 : n2 + 1);
                    int n5 = n4 = range.isRelativeToAnchor() ? Math.max(n4, range.anchor()) : n4;
                    positionalParamSpec.index = new Range(n5, n5, range.isVariable(), range.isUnspecified, range.originalValue);
                    positionalParamSpec.initCapacity();
                }
            }

            private CommandSpec addArg(ArgSpec arg) {
                this.args.add(arg);
                arg.messages(this.usageMessage().messages());
                arg.commandSpec = this;
                if (arg.arity().isUnresolved()) {
                    arg.arity = Range.valueOf(this.interpolator.interpolate(arg.arity().originalValue));
                }
                if (arg.required() && arg.group() == null && !arg.inherited()) {
                    this.requiredArgs.add(arg);
                }
                return this;
            }

            public CommandSpec remove(ArgSpec arg) {
                if (arg.group() != null) {
                    throw new UnsupportedOperationException("Cannot remove ArgSpec that is part of an ArgGroup");
                }
                int n2 = CommandSpec.remove(arg, this.optionsByNameMap);
                n2 += CommandSpec.remove(arg, this.posixOptionsByKeyMap);
                n2 += CommandSpec.remove(arg, this.negatedOptionsByNameMap);
                this.requiredArgs.remove(arg);
                this.options.remove(arg);
                if (this.positionalParameters.remove(arg)) {
                    ++n2;
                }
                if (n2 == 0) {
                    throw new NoSuchElementException(String.valueOf(arg));
                }
                arg.commandSpec = null;
                arg.messages(null);
                return this;
            }

            private static <T> int remove(ArgSpec arg, Map<T, OptionSpec> map) {
                int n2 = 0;
                Iterator<Map.Entry<T, OptionSpec>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<T, OptionSpec> entry = iterator.next();
                    if (entry.getValue() != arg) continue;
                    iterator.remove();
                    ++n2;
                }
                return n2;
            }

            public CommandSpec addArgGroup(ArgGroupSpec group) {
                return this.addArgGroup(group, new HashSet<OptionSpec>(), new HashSet<PositionalParamSpec>());
            }

            private CommandSpec addArgGroup(ArgGroupSpec group, Set<OptionSpec> groupOptions, Set<PositionalParamSpec> groupPositionals) {
                Assert.notNull(group, "group");
                if (group.parentGroup() != null) {
                    throw new InitializationException("Groups that are part of another group should not be added to a command. Add only the top-level group.");
                }
                CommandSpec commandSpec = this;
                this.check(group, commandSpec.flatten(commandSpec.groups, new HashSet<ArgGroupSpec>()));
                this.groups.add(group);
                this.addGroupArgsToCommand(group, new HashMap<String, ArgGroupSpec>(), groupOptions, groupPositionals);
                return this;
            }

            private void addGroupArgsToCommand(ArgGroupSpec group, Map<String, ArgGroupSpec> added, Set<OptionSpec> groupOptions, Set<PositionalParamSpec> groupPositionals) {
                HashMap<String, OptionSpec> hashMap = new HashMap<String, OptionSpec>();
                for (ArgSpec object : group.args()) {
                    if (object.isOption()) {
                        String string;
                        int n2;
                        String[] stringArray;
                        String[] stringArray2 = stringArray = this.interpolator.interpolate(((OptionSpec)object).names());
                        int n3 = stringArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            string = stringArray2[n2];
                            ArgGroupSpec argGroupSpec = added.get(string);
                            if (argGroupSpec == null) continue;
                            if (argGroupSpec == group) {
                                throw DuplicateOptionAnnotationsException.create(string, object, (ArgSpec)hashMap.get(string));
                            }
                            throw new DuplicateNameException("An option cannot be in multiple groups but " + string + " is in " + group.synopsisUnit() + " and " + added.get(string).synopsisUnit() + ". Refactor to avoid this. For example, (-a | (-a -b)) can be rewritten as (-a [-b]), and (-a -b | -a -c) can be rewritten as (-a (-b | -c)).");
                        }
                        stringArray2 = stringArray;
                        n3 = stringArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            string = stringArray2[n2];
                            added.put(string, group);
                        }
                        stringArray2 = stringArray;
                        n3 = stringArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            string = stringArray2[n2];
                            hashMap.put(string, (OptionSpec)object);
                        }
                        groupOptions.add((OptionSpec)object);
                    } else {
                        groupPositionals.add((PositionalParamSpec)object);
                    }
                    this.add(object);
                }
                for (ArgGroupSpec argGroupSpec : group.subgroups()) {
                    this.addGroupArgsToCommand(argGroupSpec, added, groupOptions, groupPositionals);
                }
            }

            private Set<ArgGroupSpec> flatten(Collection<ArgGroupSpec> groups, Set<ArgGroupSpec> result) {
                for (ArgGroupSpec argGroupSpec : groups) {
                    this.flatten(argGroupSpec, result);
                }
                return result;
            }

            private Set<ArgGroupSpec> flatten(ArgGroupSpec group, Set<ArgGroupSpec> result) {
                result.add(group);
                for (ArgGroupSpec argGroupSpec : group.subgroups()) {
                    this.flatten(argGroupSpec, result);
                }
                return result;
            }

            private void check(ArgGroupSpec group, Set<ArgGroupSpec> existing) {
                if (existing.contains(group)) {
                    throw new InitializationException("The specified group " + group.synopsisUnit() + " has already been added to the " + this.qualifiedName() + " command.");
                }
                for (ArgGroupSpec argGroupSpec : group.subgroups()) {
                    this.check(argGroupSpec, existing);
                }
            }

            public CommandSpec addMixin(String name, CommandSpec mixin, IAnnotatedElement annotatedElement) {
                CommandSpec commandSpec = this.addMixin(name, mixin);
                this.mixinAnnotatedElements.put(this.interpolator.interpolate(name), annotatedElement);
                return commandSpec;
            }

            public CommandSpec addMixin(String name, CommandSpec mixin) {
                this.mixins.put(this.interpolator.interpolate(name), mixin);
                this.initExitCodeOnSuccess(mixin.exitCodeOnSuccess());
                this.initExitCodeOnUsageHelp(mixin.exitCodeOnUsageHelp());
                this.initExitCodeOnVersionHelp(mixin.exitCodeOnVersionHelp());
                this.initExitCodeOnInvalidInput(mixin.exitCodeOnInvalidInput());
                this.initExitCodeOnExecutionException(mixin.exitCodeOnExecutionException());
                this.parser.initSeparator(mixin.parser.separator());
                CommandSpec commandSpec = this;
                commandSpec.initName(commandSpec.interpolator.interpolateCommandName(mixin.name()));
                this.initVersion(mixin.version());
                this.initHelpCommand(mixin.helpCommand());
                this.initVersionProvider(mixin.versionProvider());
                this.initDefaultValueProvider(mixin.defaultValueProvider());
                this.usageMessage.initFromMixin(mixin.usageMessage, this);
                this.initSubcommandsRepeatable(mixin.subcommandsRepeatable());
                for (Map.Entry<String, CommandLine> object22 : mixin.subcommands().entrySet()) {
                    this.addSubcommand(object22.getKey(), object22.getValue());
                }
                LinkedHashSet<OptionSpec> linkedHashSet = new LinkedHashSet<OptionSpec>(mixin.options());
                LinkedHashSet<PositionalParamSpec> linkedHashSet2 = new LinkedHashSet<PositionalParamSpec>(mixin.positionalParameters());
                for (ArgGroupSpec argGroupSpec : mixin.argGroups()) {
                    HashSet<OptionSpec> hashSet = new HashSet<OptionSpec>();
                    HashSet<PositionalParamSpec> hashSet2 = new HashSet<PositionalParamSpec>();
                    this.addArgGroup(argGroupSpec, hashSet, hashSet2);
                    linkedHashSet.removeAll(hashSet);
                    linkedHashSet2.removeAll(hashSet2);
                }
                Iterator<ArgGroupSpec> iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    OptionSpec optionSpec = (OptionSpec)((Object)iterator.next());
                    this.addOption(optionSpec);
                }
                for (PositionalParamSpec positionalParamSpec : linkedHashSet2) {
                    this.addPositional(positionalParamSpec);
                }
                return this;
            }

            public CommandSpec addUnmatchedArgsBinding(UnmatchedArgsBinding spec) {
                this.unmatchedArgs.add(spec);
                this.parser().unmatchedArgumentsAllowed(true);
                return this;
            }

            public CommandSpec addSpecElement(IAnnotatedElement spec) {
                this.specElements.add(spec);
                return this;
            }

            public CommandSpec addParentCommandElement(IAnnotatedElement spec) {
                this.parentCommandElements.add(spec);
                return this;
            }

            void injectParentCommand(CommandUserObject commandUserObject) {
                try {
                    for (IAnnotatedElement iAnnotatedElement : this.parentCommandElements()) {
                        iAnnotatedElement.setter().set(commandUserObject.getInstance());
                    }
                    return;
                }
                catch (Exception exception) {
                    throw new InitializationException("Unable to initialize @ParentCommand field: " + exception, exception);
                }
            }

            public Map<String, CommandSpec> mixins() {
                return Collections.unmodifiableMap(this.mixins);
            }

            public Map<String, IAnnotatedElement> mixinAnnotatedElements() {
                return Collections.unmodifiableMap(this.mixinAnnotatedElements);
            }

            public List<OptionSpec> options() {
                return Collections.unmodifiableList(this.options);
            }

            public List<PositionalParamSpec> positionalParameters() {
                return Collections.unmodifiableList(this.positionalParameters);
            }

            public List<ArgGroupSpec> argGroups() {
                return Collections.unmodifiableList(this.groups);
            }

            public Map<String, OptionSpec> optionsMap() {
                return Collections.unmodifiableMap(this.optionsByNameMap);
            }

            public Map<String, OptionSpec> negatedOptionsMap() {
                return Collections.unmodifiableMap(this.negatedOptionsByNameMap);
            }

            public Map<Character, OptionSpec> posixOptionsMap() {
                return Collections.unmodifiableMap(this.posixOptionsByKeyMap);
            }

            public List<ArgSpec> requiredArgs() {
                return Collections.unmodifiableList(this.requiredArgs);
            }

            public List<UnmatchedArgsBinding> unmatchedArgsBindings() {
                return Collections.unmodifiableList(this.unmatchedArgs);
            }

            public List<IAnnotatedElement> specElements() {
                return Collections.unmodifiableList(this.specElements);
            }

            public List<IAnnotatedElement> parentCommandElements() {
                return Collections.unmodifiableList(this.parentCommandElements);
            }

            public String name() {
                return this.interpolator.interpolateCommandName(this.name == null ? DEFAULT_COMMAND_NAME : this.name);
            }

            public String[] aliases() {
                return this.interpolator.interpolate(this.aliases.toArray(new String[0]));
            }

            public Set<String> names() {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add(this.name());
                linkedHashSet.addAll(Arrays.asList(this.aliases()));
                return linkedHashSet;
            }

            public List<ArgSpec> args() {
                return Collections.unmodifiableList(this.args);
            }

            Object[] commandMethodParamValues() {
                Object[] objectArray = new Object[this.methodParams.length];
                int n2 = this.mixins.containsKey("mixinStandardHelpOptions") ? 2 : 0;
                block0: for (int i2 = 0; i2 < this.methodParams.length; ++i2) {
                    if (this.methodParams[i2].isAnnotationPresent(Mixin.class)) {
                        String string = this.methodParams[i2].getAnnotation(Mixin.class).name();
                        CommandSpec commandSpec = this.mixins.get(CommandLine.empty(string) ? this.methodParams[i2].name : string);
                        objectArray[i2] = commandSpec.userObject.getInstance();
                        n2 += commandSpec.args.size();
                        continue;
                    }
                    if (this.methodParams[i2].isAnnotationPresent(ArgGroup.class)) {
                        objectArray[i2] = null;
                        for (ArgGroupSpec argGroupSpec : this.groups) {
                            if (!argGroupSpec.typeInfo.equals(this.methodParams[i2].typeInfo)) continue;
                            objectArray[i2] = argGroupSpec.userObjectOr(null);
                            n2 += argGroupSpec.argCount();
                            continue block0;
                        }
                        continue;
                    }
                    objectArray[i2] = this.args.get(n2++).getValue();
                }
                return objectArray;
            }

            public String qualifiedName() {
                return this.qualifiedName(" ");
            }

            public String qualifiedName(String separator) {
                String string = this.name();
                if (this.parent() != null) {
                    string = this.parent().qualifiedName(separator) + separator + string;
                }
                return string;
            }

            public String[] version() {
                if (this.versionProvider != null) {
                    try {
                        return this.interpolator.interpolate(this.versionProvider.getVersion());
                    }
                    catch (Exception exception) {
                        String string = "Could not get version info from " + this.versionProvider + ": " + exception;
                        throw new ExecutionException(this.commandLine, string, exception);
                    }
                }
                return this.interpolator.interpolate(this.version == null ? UsageMessageSpec.DEFAULT_MULTI_LINE : this.version);
            }

            public IVersionProvider versionProvider() {
                return this.versionProvider;
            }

            public boolean helpCommand() {
                return this.isHelpCommand == null ? DEFAULT_IS_HELP_COMMAND : this.isHelpCommand;
            }

            public int exitCodeOnSuccess() {
                if (this.exitCodeOnSuccess == null) {
                    return 0;
                }
                return this.exitCodeOnSuccess;
            }

            public int exitCodeOnUsageHelp() {
                if (this.exitCodeOnUsageHelp == null) {
                    return 0;
                }
                return this.exitCodeOnUsageHelp;
            }

            public int exitCodeOnVersionHelp() {
                if (this.exitCodeOnVersionHelp == null) {
                    return 0;
                }
                return this.exitCodeOnVersionHelp;
            }

            public int exitCodeOnInvalidInput() {
                if (this.exitCodeOnInvalidInput == null) {
                    return 2;
                }
                return this.exitCodeOnInvalidInput;
            }

            public int exitCodeOnExecutionException() {
                if (this.exitCodeOnExecutionException == null) {
                    return 1;
                }
                return this.exitCodeOnExecutionException;
            }

            public INegatableOptionTransformer negatableOptionTransformer() {
                return this.negatableOptionTransformer;
            }

            public boolean mixinStandardHelpOptions() {
                return this.mixins.containsKey("mixinStandardHelpOptions");
            }

            public boolean subcommandsRepeatable() {
                return this.subcommandsRepeatable == null ? DEFAULT_SUBCOMMANDS_REPEATABLE : this.subcommandsRepeatable;
            }

            public String toString() {
                if (this.toString == null) {
                    return "command '" + this.name + "' (user object: " + this.userObject + ")";
                }
                return this.toString;
            }

            public CommandSpec name(String name) {
                this.name = name;
                return this;
            }

            public CommandSpec aliases(String ... aliases) {
                this.aliases = new LinkedHashSet<String>(Arrays.asList(aliases == null ? new String[]{} : aliases));
                return this;
            }

            public IDefaultValueProvider defaultValueProvider() {
                return this.defaultValueProvider;
            }

            public CommandSpec defaultValueProvider(IDefaultValueProvider defaultValueProvider) {
                this.defaultValueProvider = defaultValueProvider;
                return this;
            }

            public CommandSpec version(String ... version) {
                this.version = version;
                return this;
            }

            public CommandSpec versionProvider(IVersionProvider versionProvider) {
                this.versionProvider = versionProvider;
                return this;
            }

            public CommandSpec helpCommand(boolean newValue) {
                this.isHelpCommand = newValue;
                return this;
            }

            public CommandSpec exitCodeOnSuccess(int newValue) {
                this.exitCodeOnSuccess = newValue;
                return this;
            }

            public CommandSpec exitCodeOnUsageHelp(int newValue) {
                this.exitCodeOnUsageHelp = newValue;
                return this;
            }

            public CommandSpec exitCodeOnVersionHelp(int newValue) {
                this.exitCodeOnVersionHelp = newValue;
                return this;
            }

            public CommandSpec exitCodeOnInvalidInput(int newValue) {
                this.exitCodeOnInvalidInput = newValue;
                return this;
            }

            public CommandSpec exitCodeOnExecutionException(int newValue) {
                this.exitCodeOnExecutionException = newValue;
                return this;
            }

            public CommandSpec negatableOptionTransformer(INegatableOptionTransformer newValue) {
                Tracer tracer = new Tracer();
                tracer.debug("Replacing negatableOptionTransformer %s with %s%n", this.negatableOptionTransformer, newValue);
                this.negatableOptionTransformer = newValue;
                this.resetNegativeOptionNames();
                return this;
            }

            public CommandSpec mixinStandardHelpOptions(boolean newValue) {
                if (newValue) {
                    CommandSpec commandSpec = CommandSpec.forAnnotatedObject(new AutoHelpMixin(), new DefaultFactory());
                    this.addMixin("mixinStandardHelpOptions", commandSpec);
                } else {
                    CommandSpec commandSpec = this.mixins.remove("mixinStandardHelpOptions");
                    if (commandSpec != null) {
                        this.options.removeAll(commandSpec.options);
                        for (OptionSpec optionSpec : commandSpec.options()) {
                            for (String string : this.interpolator.interpolate(optionSpec.names())) {
                                this.optionsByNameMap.remove(string);
                                if (string.length() != 2 || !string.startsWith("-")) continue;
                                this.posixOptionsByKeyMap.remove(Character.valueOf(string.charAt(1)));
                            }
                        }
                    }
                }
                return this;
            }

            public CommandSpec subcommandsRepeatable(boolean subcommandsRepeatable) {
                this.subcommandsRepeatable = subcommandsRepeatable;
                return this;
            }

            public CommandSpec withToString(String newValue) {
                this.toString = newValue;
                return this;
            }

            public void updateCommandAttributes(Command cmd, IFactory factory) {
                this.parser().updateSeparator(this.interpolator.interpolate(cmd.separator()));
                this.updateExitCodeOnSuccess(cmd.exitCodeOnSuccess());
                this.updateExitCodeOnUsageHelp(cmd.exitCodeOnUsageHelp());
                this.updateExitCodeOnVersionHelp(cmd.exitCodeOnVersionHelp());
                this.updateExitCodeOnInvalidInput(cmd.exitCodeOnInvalidInput());
                this.updateExitCodeOnExecutionException(cmd.exitCodeOnExecutionException());
                this.aliases(cmd.aliases());
                this.updateName(cmd.name());
                this.updateVersion(cmd.version());
                this.updateHelpCommand(cmd.helpCommand());
                this.updateSubcommandsRepeatable(cmd.subcommandsRepeatable());
                this.updateAddMethodSubcommands(cmd.addMethodSubcommands());
                this.usageMessage().updateFromCommand(cmd, this, factory != null);
                if (factory != null) {
                    this.updateVersionProvider(cmd.versionProvider(), factory);
                    this.initDefaultValueProvider(cmd.defaultValueProvider(), factory);
                }
            }

            void initName(String value) {
                if (Model.initializable(this.name, value, DEFAULT_COMMAND_NAME)) {
                    this.name = value;
                }
            }

            void initHelpCommand(boolean value) {
                if (Model.initializable(this.isHelpCommand, value, CommandSpec.DEFAULT_IS_HELP_COMMAND)) {
                    this.isHelpCommand = value;
                }
            }

            void initVersion(String[] value) {
                if (Model.initializable(this.version, value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.version = (String[])value.clone();
                }
            }

            void initVersionProvider(IVersionProvider value) {
                if (this.versionProvider == null) {
                    this.versionProvider = value;
                }
            }

            void initDefaultValueProvider(IDefaultValueProvider value) {
                if (this.defaultValueProvider == null) {
                    this.defaultValueProvider = value;
                }
            }

            void initDefaultValueProvider(Class<? extends IDefaultValueProvider> value, IFactory factory) {
                if (Model.initializable(this.defaultValueProvider, value, NoDefaultProvider.class)) {
                    this.defaultValueProvider = DefaultFactory.createDefaultValueProvider(factory, value);
                }
            }

            void initSubcommandsRepeatable(boolean value) {
                if (Model.initializable(this.subcommandsRepeatable, value, CommandSpec.DEFAULT_SUBCOMMANDS_REPEATABLE)) {
                    this.subcommandsRepeatable = value;
                }
            }

            void initExitCodeOnSuccess(int exitCode) {
                if (Model.initializable(this.exitCodeOnSuccess, exitCode, 0)) {
                    this.exitCodeOnSuccess = exitCode;
                }
            }

            void initExitCodeOnUsageHelp(int exitCode) {
                if (Model.initializable(this.exitCodeOnUsageHelp, exitCode, 0)) {
                    this.exitCodeOnUsageHelp = exitCode;
                }
            }

            void initExitCodeOnVersionHelp(int exitCode) {
                if (Model.initializable(this.exitCodeOnVersionHelp, exitCode, 0)) {
                    this.exitCodeOnVersionHelp = exitCode;
                }
            }

            void initExitCodeOnInvalidInput(int exitCode) {
                if (Model.initializable(this.exitCodeOnInvalidInput, exitCode, 2)) {
                    this.exitCodeOnInvalidInput = exitCode;
                }
            }

            void initExitCodeOnExecutionException(int exitCode) {
                if (Model.initializable(this.exitCodeOnExecutionException, exitCode, 1)) {
                    this.exitCodeOnExecutionException = exitCode;
                }
            }

            void updateName(String value) {
                if (Model.isNonDefault(value, DEFAULT_COMMAND_NAME)) {
                    this.name = value;
                }
            }

            void updateHelpCommand(boolean value) {
                if (Model.isNonDefault(value, CommandSpec.DEFAULT_IS_HELP_COMMAND)) {
                    this.isHelpCommand = value;
                }
            }

            void updateSubcommandsRepeatable(boolean value) {
                if (Model.isNonDefault(value, CommandSpec.DEFAULT_SUBCOMMANDS_REPEATABLE)) {
                    this.subcommandsRepeatable = value;
                }
            }

            void updateAddMethodSubcommands(boolean value) {
                if (Model.isNonDefault(value, CommandSpec.DEFAULT_IS_ADD_METHOD_SUBCOMMANDS)) {
                    this.isAddMethodSubcommands = value;
                }
            }

            void updateVersion(String[] value) {
                if (Model.isNonDefault(value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.version = (String[])value.clone();
                }
            }

            void updateVersionProvider(Class<? extends IVersionProvider> value, IFactory factory) {
                if (Model.isNonDefault(value, NoVersionProvider.class)) {
                    this.versionProvider = DefaultFactory.createVersionProvider(factory, value);
                }
            }

            void updateExitCodeOnSuccess(int exitCode) {
                if (Model.isNonDefault(exitCode, 0)) {
                    this.exitCodeOnSuccess = exitCode;
                }
            }

            void updateExitCodeOnUsageHelp(int exitCode) {
                if (Model.isNonDefault(exitCode, 0)) {
                    this.exitCodeOnUsageHelp = exitCode;
                }
            }

            void updateExitCodeOnVersionHelp(int exitCode) {
                if (Model.isNonDefault(exitCode, 0)) {
                    this.exitCodeOnVersionHelp = exitCode;
                }
            }

            void updateExitCodeOnInvalidInput(int exitCode) {
                if (Model.isNonDefault(exitCode, 2)) {
                    this.exitCodeOnInvalidInput = exitCode;
                }
            }

            void updateExitCodeOnExecutionException(int exitCode) {
                if (Model.isNonDefault(exitCode, 1)) {
                    this.exitCodeOnExecutionException = exitCode;
                }
            }

            public OptionSpec findOption(char shortName) {
                return CommandSpec.findOption(shortName, this.options());
            }

            public OptionSpec findOption(String name) {
                return CommandSpec.findOption(name, this.options());
            }

            static OptionSpec findOption(char shortName, Iterable<OptionSpec> options) {
                for (OptionSpec optionSpec : options) {
                    for (String string : optionSpec.names()) {
                        if (string.length() == 2 && string.charAt(0) == '-' && string.charAt(1) == shortName) {
                            return optionSpec;
                        }
                        if (string.length() != 1 || string.charAt(0) != shortName) continue;
                        return optionSpec;
                    }
                }
                return null;
            }

            static OptionSpec findOption(String name, List<OptionSpec> options) {
                for (OptionSpec optionSpec : options) {
                    for (String string : optionSpec.names()) {
                        if (!string.equals(name) && !CommandSpec.stripPrefix(string).equals(name)) continue;
                        return optionSpec;
                    }
                }
                return null;
            }

            static String stripPrefix(String prefixed) {
                for (int i2 = 0; i2 < prefixed.length(); ++i2) {
                    if (!Character.isJavaIdentifierPart(prefixed.charAt(i2))) continue;
                    return prefixed.substring(i2);
                }
                return prefixed;
            }

            List<String> findVisibleOptionNamesWithPrefix(String prefix) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (OptionSpec optionSpec : this.options()) {
                    for (String string : optionSpec.names()) {
                        if (optionSpec.hidden() || !CommandSpec.stripPrefix(string).startsWith(prefix)) continue;
                        arrayList.add(string);
                    }
                }
                return arrayList;
            }

            boolean resemblesOption(String arg, Tracer tracer) {
                boolean bl;
                int n2;
                if (arg == null) {
                    return false;
                }
                if (arg.length() == 1) {
                    if (tracer != null && tracer.isDebug()) {
                        tracer.debug("Single-character arguments that don't match known options are considered positional parameters%n", arg);
                    }
                    return false;
                }
                try {
                    Long.decode(arg);
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Double.parseDouble(arg);
                        return false;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (this.options().isEmpty()) {
                            boolean bl2 = arg.startsWith("-");
                            if (tracer != null && tracer.isDebug()) {
                                tracer.debug("'%s' %s an option%n", arg, bl2 ? "resembles" : "doesn't resemble");
                            }
                            return bl2;
                        }
                        n2 = 0;
                        for (String string : this.optionsMap().keySet()) {
                            for (int i2 = 0; i2 < arg.length() && string.length() > i2 && arg.charAt(i2) == string.charAt(i2); ++i2) {
                                ++n2;
                            }
                        }
                    }
                }
                boolean bl3 = bl = n2 > 0 && n2 * 10 >= this.optionsMap().size() * 9;
                if (tracer != null && tracer.isDebug()) {
                    tracer.debug("'%s' %s an option: %d matching prefix chars out of %d option names%n", arg, bl ? "resembles" : "doesn't resemble", n2, this.optionsMap().size());
                }
                return bl;
            }

            static /* synthetic */ TypedMember[] access$14502(CommandSpec x0, TypedMember[] x1) {
                x0.methodParams = x1;
                return x1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CaseAwareLinkedMap<K, V>
        extends AbstractMap<K, V> {
            private final LinkedHashMap<K, V> targetMap = new LinkedHashMap();
            private final HashMap<K, K> keyMap = new HashMap();
            private final Locale locale;
            private final Set<K> keySet;
            private boolean caseInsensitive = false;

            public CaseAwareLinkedMap() {
                this(Locale.ENGLISH);
            }

            public CaseAwareLinkedMap(Locale locale) {
                this.locale = locale;
                this.keySet = new CaseAwareKeySet();
            }

            static boolean isCaseConvertible(Class<?> clazz) {
                return clazz == String.class || clazz == Character.class;
            }

            private K toLowerCase(Object caseSensitiveKey) {
                if (caseSensitiveKey.getClass() == String.class) {
                    return (K)((String)caseSensitiveKey).toLowerCase(this.locale);
                }
                if (caseSensitiveKey.getClass() == Character.class) {
                    return (K)Character.valueOf(Character.toLowerCase(((Character)caseSensitiveKey).charValue()));
                }
                throw new UnsupportedOperationException("Unsupported case-conversion for key " + caseSensitiveKey.getClass());
            }

            public boolean isCaseInsensitive() {
                return this.caseInsensitive;
            }

            public void setCaseInsensitive(boolean caseInsensitive) {
                if (!this.isCaseInsensitive() && caseInsensitive) {
                    for (K k2 : this.targetMap.keySet()) {
                        K k3 = this.keyMap.put(k2 != null ? (Object)this.toLowerCase(k2) : null, k2);
                        if (k3 == null) continue;
                        throw new DuplicateNameException("Duplicated keys: " + k3 + " and " + k2);
                    }
                } else if (this.isCaseInsensitive()) {
                    this.keyMap.clear();
                }
                this.caseInsensitive = caseInsensitive;
            }

            public K getCaseSensitiveKey(K caseInsensitiveKey) {
                if (caseInsensitiveKey != null && this.caseInsensitive) {
                    return this.keyMap.get(this.toLowerCase(caseInsensitiveKey));
                }
                return caseInsensitiveKey;
            }

            @Override
            public int size() {
                return this.targetMap.size();
            }

            @Override
            public boolean containsKey(Object key) {
                if (key != null && this.caseInsensitive) {
                    if (!CaseAwareLinkedMap.isCaseConvertible(key.getClass())) {
                        return false;
                    }
                    return this.keyMap.containsKey(this.toLowerCase(key));
                }
                return this.targetMap.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.targetMap.containsValue(value);
            }

            @Override
            public V get(Object key) {
                if (key != null && CaseAwareLinkedMap.isCaseConvertible(key.getClass()) && this.caseInsensitive) {
                    K k2 = this.keyMap.get(this.toLowerCase(key));
                    if (k2 == null) {
                        return null;
                    }
                    return this.targetMap.get(k2);
                }
                return this.targetMap.get(key);
            }

            @Override
            public V put(K key, V value) {
                K k2;
                if (key != null && this.caseInsensitive && (k2 = this.keyMap.put(this.toLowerCase(key), key)) != null) {
                    Object v2 = this.targetMap.remove(k2);
                    this.targetMap.put(key, value);
                    return v2;
                }
                return this.targetMap.put(key, value);
            }

            @Override
            public V remove(Object key) {
                if (key != null && this.caseInsensitive) {
                    K k2 = this.keyMap.remove(this.toLowerCase(key));
                    if (k2 == null) {
                        return null;
                    }
                    return this.targetMap.remove(k2);
                }
                return this.targetMap.remove(key);
            }

            @Override
            public void clear() {
                this.targetMap.clear();
                this.keyMap.clear();
            }

            @Override
            public Set<K> keySet() {
                return this.keySet;
            }

            @Override
            public Collection<V> values() {
                return this.targetMap.values();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return this.targetMap.entrySet();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CaseAwareKeySet
            extends AbstractSet<K> {
                CaseAwareKeySet() {
                }

                @Override
                public boolean contains(Object o2) {
                    return CaseAwareLinkedMap.this.containsKey(o2);
                }

                @Override
                public Iterator<K> iterator() {
                    return CaseAwareLinkedMap.this.targetMap.keySet().iterator();
                }

                @Override
                public int size() {
                    return CaseAwareLinkedMap.this.targetMap.keySet().size();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ISetter {
            public <T> T set(T var1) throws Exception;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IGetter {
            public <T> T get() throws Exception;
        }

        public static interface IScope
        extends IGetter,
        ISetter {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Range
    implements Comparable<Range> {
        @Deprecated
        public final int min;
        @Deprecated
        public final int max;
        @Deprecated
        public final boolean isVariable;
        private final boolean isUnspecified;
        private final String originalValue;
        private final boolean relative;
        private final int anchor;

        public Range(int min, int max, boolean variable, boolean unspecified, String originalValue) {
            if (min < 0 || max < 0) {
                throw new InitializationException("Invalid negative range (min=" + min + ", max=" + max + ")");
            }
            if (min > max) {
                throw new InitializationException("Invalid range (min=" + min + ", max=" + max + ")");
            }
            this.min = min;
            this.max = max;
            this.isVariable = variable;
            this.isUnspecified = unspecified;
            this.originalValue = originalValue;
            boolean bl = this.relative = originalValue != null && originalValue.contains("+");
            if (this.relative) {
                this.anchor = "+".equals(originalValue) ? Integer.MAX_VALUE : Range.parseInt(originalValue, Integer.MAX_VALUE);
                return;
            }
            this.anchor = min;
        }

        public static Range optionArity(Field field) {
            return Range.optionArity(new Model.TypedMember(field));
        }

        private static Range optionArity(Model.IAnnotatedElement member) {
            if (member.isAnnotationPresent(Option.class)) {
                return Range.adjustForType(Range.valueOf(member.getAnnotation(Option.class).arity()), member);
            }
            return new Range(0, 0, false, true, "0");
        }

        public static Range parameterArity(Field field) {
            return Range.parameterArity(new Model.TypedMember(field));
        }

        private static Range parameterArity(Model.IAnnotatedElement member) {
            if (member.isAnnotationPresent(Parameters.class)) {
                return Range.adjustForType(Range.valueOf(member.getAnnotation(Parameters.class).arity()), member);
            }
            if (member.isMethodParameter()) {
                return Range.adjustForType(Range.valueOf(""), member);
            }
            return new Range(0, 0, false, true, "0");
        }

        public static Range parameterIndex(Field field) {
            return Range.parameterIndex(new Model.TypedMember(field));
        }

        private static Range parameterIndex(Model.IAnnotatedElement member) {
            if (member.isAnnotationPresent(Parameters.class)) {
                Range range = Range.valueOf(member.getAnnotation(Parameters.class).index());
                if (!range.isUnspecified) {
                    return range;
                }
            }
            if (member.isMethodParameter()) {
                int n2 = member.getMethodParamPosition();
                int n3 = member.isMultiValue() ? Integer.MAX_VALUE : n2;
                return new Range(n2, n3, member.isMultiValue(), false, null);
            }
            return Range.defaultParameterIndex(member.getTypeInfo());
        }

        private static Range defaultParameterIndex(Model.ITypeInfo typeInfo) {
            return Range.valueOf(typeInfo.isMultiValue() ? "*" : "0+");
        }

        static Range adjustForType(Range result, Model.IAnnotatedElement member) {
            if (result.isUnspecified) {
                return Range.defaultArity(member);
            }
            return result;
        }

        public static Range defaultArity(Field field) {
            return Range.defaultArity(new Model.TypedMember(field));
        }

        private static Range defaultArity(Model.IAnnotatedElement member) {
            if (member.isInteractive()) {
                return Range.valueOf("0").unspecified(true);
            }
            Model.ITypeInfo iTypeInfo = member.getTypeInfo();
            if (member.isAnnotationPresent(Option.class)) {
                boolean bl = iTypeInfo.isBoolean() || iTypeInfo.isMultiValue() && iTypeInfo.getAuxiliaryTypeInfos().get(0).isBoolean();
                if (bl) {
                    return Range.valueOf("0").unspecified(true);
                }
                return Range.valueOf("1").unspecified(true);
            }
            if (iTypeInfo.isMultiValue()) {
                return Range.valueOf("0..1").unspecified(true);
            }
            return Range.valueOf("1").unspecified(true);
        }

        @Deprecated
        public static Range defaultArity(Class<?> type) {
            if (CommandLine.isBoolean(type)) {
                return Range.valueOf("0").unspecified(true);
            }
            return Range.valueOf("1").unspecified(true);
        }

        private int size() {
            if (this.isRelative()) {
                return 1;
            }
            return 1 + this.max - this.min;
        }

        static Range parameterCapacity(Model.IAnnotatedElement member) {
            Range range = Range.parameterArity(member);
            if (!member.isMultiValue()) {
                return range;
            }
            Range range2 = Range.parameterIndex(member);
            return Range.parameterCapacity(range, range2);
        }

        private static Range parameterCapacity(Range arity, Range index) {
            if (arity.max == 0) {
                return arity;
            }
            if (index.size() == 1) {
                return arity;
            }
            if (index.isVariable) {
                return Range.valueOf(arity.min + "..*");
            }
            if (arity.size() == 1) {
                return Range.valueOf("" + arity.min * index.size());
            }
            if (arity.isVariable) {
                return Range.valueOf(arity.min * index.size() + "..*");
            }
            return Range.valueOf(arity.min * index.size() + ".." + arity.max * index.size());
        }

        public static Range valueOf(String range) {
            boolean bl;
            int n2;
            int n3;
            if (range.contains("${")) {
                return new Range(0, 0, false, false, range);
            }
            boolean bl2 = (range = range.trim()).length() == 0 || range.startsWith("..");
            int n4 = range.indexOf("..");
            if (n4 >= 0) {
                n3 = Range.parseInt(range.substring(0, n4), 0);
                n2 = Range.parseInt(range.substring(n4 + 2), Integer.MAX_VALUE);
                bl = n2 == Integer.MAX_VALUE;
            } else {
                n2 = Range.parseInt(range, Integer.MAX_VALUE);
                bl = !range.contains("+") && n2 == Integer.MAX_VALUE;
                n3 = bl ? 0 : n2;
            }
            boolean bl3 = bl2;
            return new Range(n3, n2, bl, bl3, bl3 ? null : range);
        }

        private static int parseInt(String str, int defaultValue) {
            try {
                int n2 = str.indexOf(43);
                return Integer.parseInt(n2 < 0 ? str : str.substring(0, str.indexOf(43)));
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public Range min(int newMin) {
            int n2 = newMin;
            return new Range(n2, Math.max(n2, this.max), this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range max(int newMax) {
            return new Range(Math.min(this.min, newMax), newMax, this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range unspecified(boolean unspecified) {
            return new Range(this.min, this.max, this.isVariable, unspecified, this.originalValue);
        }

        public boolean isUnspecified() {
            return this.isUnspecified;
        }

        public boolean isUnresolved() {
            return this.originalValue != null && this.originalValue.contains("${");
        }

        public boolean isRelative() {
            return this.relative;
        }

        int anchor() {
            return this.anchor;
        }

        boolean isRelativeToAnchor() {
            return this.anchor != Integer.MAX_VALUE && this.isRelative();
        }

        public String originalValue() {
            return this.originalValue;
        }

        public int min() {
            return this.min;
        }

        public int max() {
            return this.max;
        }

        public boolean isVariable() {
            return this.isVariable;
        }

        public boolean contains(int value) {
            return this.min <= value && this.max >= value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range range = (Range)object;
            return range.max == this.max && range.min == this.min && range.isVariable == this.isVariable;
        }

        public int hashCode() {
            return ((629 + this.max) * 37 + this.min) * 37 + (this.isVariable ? 1 : 0);
        }

        public String toString() {
            if (this.isUnresolved()) {
                return this.originalValue;
            }
            if (this.min == this.max) {
                if (this.relative && this.min == Integer.MAX_VALUE) {
                    return "+";
                }
                return String.valueOf(this.min);
            }
            return this.min + ".." + (this.isVariable ? "*" : Integer.valueOf(this.max));
        }

        String internalToString() {
            if (this.isUnresolved()) {
                return this.originalValue;
            }
            if (this.isRelative()) {
                return this.originalValue + " (" + this.toString() + ")";
            }
            return this.toString();
        }

        @Override
        public int compareTo(Range other) {
            int n2;
            if (this.originalValue != null && other.originalValue != null && this.originalValue.equals(other.originalValue)) {
                return 0;
            }
            if ((this.anchor() < other.anchor() ? -1 : (n2 = this.anchor() == other.anchor() ? 0 : 1)) == 0) {
                int n3 = this.max < other.max ? -1 : (n2 = this.max == other.max ? 0 : 1);
            }
            if (n2 == 0 && this.isRelative() != other.isRelative()) {
                n2 = this.isRelative() ? 1 : -1;
            }
            return n2;
        }

        boolean isValidForInteractiveArgs() {
            return this.min == 0 && (this.max == 0 || this.max == 1);
        }

        boolean overlaps(Range index) {
            return this.contains(index.min) || this.contains(index.max) || index.contains(this.min) || index.contains(this.max);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFactory
    implements IFactory {
        private DefaultFactory() {
        }

        public <T> T create(Class<T> cls) throws Exception {
            if (cls.isInterface() && Collection.class.isAssignableFrom(cls)) {
                if (List.class.isAssignableFrom(cls)) {
                    return cls.cast(new ArrayList());
                }
                if (SortedSet.class.isAssignableFrom(cls)) {
                    return cls.cast(new TreeSet());
                }
                if (Set.class.isAssignableFrom(cls)) {
                    return cls.cast(new LinkedHashSet());
                }
                if (Queue.class.isAssignableFrom(cls)) {
                    return cls.cast(new LinkedList());
                }
                return cls.cast(new ArrayList());
            }
            if (Map.class.isAssignableFrom(cls)) {
                try {
                    Class<T> clazz = cls;
                    return clazz.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception exception) {
                    return cls.cast(new LinkedHashMap());
                }
            }
            try {
                T t2 = cls.newInstance();
                return t2;
            }
            catch (Exception exception) {
                Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
        }

        private static ITypeConverter<?>[] createConverter(IFactory factory, Class<? extends ITypeConverter<?>>[] classes) {
            ITypeConverter[] iTypeConverterArray = new ITypeConverter[classes.length];
            for (int i2 = 0; i2 < classes.length; ++i2) {
                iTypeConverterArray[i2] = DefaultFactory.create(factory, classes[i2]);
            }
            return iTypeConverterArray;
        }

        static IVersionProvider createVersionProvider(IFactory factory, Class<? extends IVersionProvider> cls) {
            return DefaultFactory.create(factory, cls);
        }

        static IDefaultValueProvider createDefaultValueProvider(IFactory factory, Class<? extends IDefaultValueProvider> cls) {
            return DefaultFactory.create(factory, cls);
        }

        static Iterable<String> createCompletionCandidates(IFactory factory, Class<? extends Iterable<String>> cls) {
            return DefaultFactory.create(factory, cls);
        }

        static IParameterConsumer createParameterConsumer(IFactory factory, Class<? extends IParameterConsumer> cls) {
            return DefaultFactory.create(factory, cls);
        }

        static <T> T create(IFactory factory, Class<T> cls) {
            try {
                return factory.create(cls);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InitializationException("Cannot instantiate " + cls.getName() + ": the class has no constructor", noSuchMethodException);
            }
            catch (InitializationException initializationException) {
                InitializationException initializationException2 = initializationException;
                throw initializationException;
            }
            catch (Exception exception) {
                throw new InitializationException("Could not instantiate " + cls + ": " + exception, exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFactory {
        public <K> K create(Class<K> var1) throws Exception;
    }

    private static class DefaultHelpFactory
    implements IHelpFactory {
        private DefaultHelpFactory() {
        }

        public Help create(Model.CommandSpec commandSpec, Help.ColorScheme colorScheme) {
            return new Help(commandSpec, colorScheme);
        }
    }

    public static interface IHelpFactory {
        public Help create(Model.CommandSpec var1, Help.ColorScheme var2);
    }

    public static class RegexTransformer
    implements INegatableOptionTransformer {
        final Map<Pattern, String> replacements;
        final Map<Pattern, String> synopsis;

        RegexTransformer(Builder builder) {
            this.replacements = Collections.unmodifiableMap(new LinkedHashMap<Pattern, String>(builder.replacements));
            this.synopsis = Collections.unmodifiableMap(new LinkedHashMap<Pattern, String>(builder.synopsis));
        }

        public static RegexTransformer createDefault() {
            RegexTransformer regexTransformer = new Builder().addPattern("^--no-(\\w(-|\\w)*)$", "--$1", "--[no-]$1").addPattern("^--(\\w(-|\\w)*)$", "--no-$1", "--[no-]$1").addPattern("^(-|--)(\\w*:)\\+(\\w(-|\\w)*)$", "$1$2-$3", "$1$2(+|-)$3").addPattern("^(-|--)(\\w*:)\\-(\\w(-|\\w)*)$", "$1$2+$3", "$1$2(+|-)$3").build();
            return regexTransformer;
        }

        public static RegexTransformer createCaseInsensitive() {
            RegexTransformer regexTransformer = new Builder().addPattern("^--((?i)no)-(\\w(-|\\w)*)$", "--$2", "--[$1-]$2").addPattern("^--(\\w(-|\\w)*)$", "--no-$1", "--[no-]$1").addPattern("^(-|--)(\\w*:)\\+(\\w(-|\\w)*)$", "$1$2-$3", "$1$2(+|-)$3").addPattern("^(-|--)(\\w*:)\\-(\\w(-|\\w)*)$", "$1$2+$3", "$1$2(+|-)$3").build();
            return regexTransformer;
        }

        public String makeNegative(String optionName, Model.CommandSpec cmd) {
            for (Map.Entry<Pattern, String> entry : this.replacements.entrySet()) {
                Matcher matcher = entry.getKey().matcher(optionName);
                if (!matcher.find()) continue;
                return matcher.replaceAll(entry.getValue());
            }
            return optionName;
        }

        public String makeSynopsis(String optionName, Model.CommandSpec cmd) {
            for (Map.Entry<Pattern, String> entry : this.synopsis.entrySet()) {
                Matcher matcher = entry.getKey().matcher(optionName);
                if (!matcher.find()) continue;
                return matcher.replaceAll(entry.getValue());
            }
            return optionName;
        }

        public String toString() {
            return this.getClass().getName() + "[replacements=" + this.replacements + ", synopsis=" + this.synopsis + "]@" + System.identityHashCode(this);
        }

        public static class Builder {
            Map<Pattern, String> replacements = new LinkedHashMap<Pattern, String>();
            Map<Pattern, String> synopsis = new LinkedHashMap<Pattern, String>();

            public Builder() {
            }

            public Builder(RegexTransformer old) {
                this.replacements.putAll(old.replacements);
                this.synopsis.putAll(old.synopsis);
            }

            public Builder addPattern(String regex, String negativeReplacement, String synopsisReplacement) {
                Pattern pattern = Pattern.compile(regex);
                this.replacements.put(pattern, negativeReplacement);
                this.synopsis.put(pattern, synopsisReplacement);
                return this;
            }

            public Builder removePattern(String regex) {
                Iterator<Pattern> iterator = this.replacements.keySet().iterator();
                while (iterator.hasNext()) {
                    Pattern pattern = iterator.next();
                    if (!pattern.toString().equals(regex)) continue;
                    iterator.remove();
                    this.synopsis.remove(pattern);
                }
                return this;
            }

            public RegexTransformer build() {
                return new RegexTransformer(this);
            }
        }
    }

    public static interface INegatableOptionTransformer {
        public String makeNegative(String var1, Model.CommandSpec var2);

        public String makeSynopsis(String var1, Model.CommandSpec var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullParameterConsumer
    implements IParameterConsumer {
        private NullParameterConsumer() {
        }

        @Override
        public void consumeParameters(Stack<String> args, Model.ArgSpec argSpec, Model.CommandSpec commandSpec) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IParameterConsumer {
        public void consumeParameters(Stack<String> var1, Model.ArgSpec var2, Model.CommandSpec var3);
    }

    private static class NoDefaultProvider
    implements IDefaultValueProvider {
        private NoDefaultProvider() {
        }

        public String defaultValue(Model.ArgSpec argSpec) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface IDefaultValueProvider {
        public String defaultValue(Model.ArgSpec var1) throws Exception;
    }

    private static class NoVersionProvider
    implements IVersionProvider {
        private NoVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    public static interface IVersionProvider {
        public String[] getVersion() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITypeConverter<K> {
        public K convert(String var1) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface ArgGroup {
        public String heading() default "__no_heading__";

        public String headingKey() default "__no_heading_key__";

        public boolean exclusive() default true;

        public String multiplicity() default "0..1";

        public boolean validate() default true;

        public int order() default -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.LOCAL_VARIABLE, ElementType.FIELD, ElementType.PACKAGE, ElementType.METHOD})
    public static @interface Command {
        public String name() default "<main class>";

        public String[] aliases() default {};

        public Class<?>[] subcommands() default {};

        public boolean subcommandsRepeatable() default false;

        public boolean addMethodSubcommands() default true;

        public String separator() default "=";

        public String[] version() default {};

        public Class<? extends IVersionProvider> versionProvider() default NoVersionProvider.class;

        public boolean mixinStandardHelpOptions() default false;

        public boolean helpCommand() default false;

        public String headerHeading() default "";

        public String[] header() default {};

        public String synopsisHeading() default "Usage: ";

        public boolean abbreviateSynopsis() default false;

        public String[] customSynopsis() default {};

        public String synopsisSubcommandLabel() default "[COMMAND]";

        public String descriptionHeading() default "";

        public String[] description() default {};

        public String parameterListHeading() default "";

        public String optionListHeading() default "";

        public boolean sortOptions() default true;

        public char requiredOptionMarker() default 32;

        public Class<? extends IDefaultValueProvider> defaultValueProvider() default NoDefaultProvider.class;

        public boolean showDefaultValues() default false;

        public boolean showAtFileInUsageHelp() default false;

        public boolean showEndOfOptionsDelimiterInUsageHelp() default false;

        public String commandListHeading() default "Commands:%n";

        public String footerHeading() default "";

        public String[] footer() default {};

        public boolean hidden() default false;

        public String resourceBundle() default "";

        public int usageHelpWidth() default 80;

        public boolean usageHelpAutoWidth() default false;

        public int exitCodeOnSuccess() default 0;

        public int exitCodeOnUsageHelp() default 0;

        public int exitCodeOnVersionHelp() default 0;

        public int exitCodeOnInvalidInput() default 2;

        public int exitCodeOnExecutionException() default 1;

        public String exitCodeListHeading() default "";

        public String[] exitCodeList() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @java.lang.annotation.Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Spec {
        public Target value() default Target.SELF;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Target {
            SELF,
            MIXEE;

        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    public static @interface Mixin {
        public String name() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Unmatched {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ParentCommand {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Parameters {
        public String index() default "";

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public boolean hideParamSyntax() default false;

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public String splitSynopsisLabel() default "";

        public boolean hidden() default false;

        public String defaultValue() default "__no_default_value__";

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;

        public Class<? extends Iterable<String>> completionCandidates() default NoCompletionCandidates.class;

        public boolean interactive() default false;

        public String descriptionKey() default "";

        public ScopeType scope() default ScopeType.LOCAL;

        public Class<? extends IParameterConsumer> parameterConsumer() default NullParameterConsumer.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Option {
        public String[] names();

        public boolean required() default false;

        @Deprecated
        public boolean help() default false;

        public boolean usageHelp() default false;

        public boolean versionHelp() default false;

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public boolean hideParamSyntax() default false;

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public String splitSynopsisLabel() default "";

        public boolean hidden() default false;

        public String defaultValue() default "__no_default_value__";

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;

        public Class<? extends Iterable<String>> completionCandidates() default NoCompletionCandidates.class;

        public boolean interactive() default false;

        public String descriptionKey() default "";

        public int order() default -1;

        public boolean negatable() default false;

        public ScopeType scope() default ScopeType.LOCAL;

        public String fallbackValue() default "";

        public Class<? extends IParameterConsumer> parameterConsumer() default NullParameterConsumer.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScopeType {
        LOCAL,
        INHERIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoCompletionCandidates
    implements Iterable<String> {
        private NoCompletionCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAll
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            ArrayList arrayList = new ArrayList();
            for (CommandLine commandLine : parsedCommands) {
                CommandLine.executeUserObject(commandLine, arrayList);
            }
            return this.returnResultOrExit(arrayList);
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            RunAll runAll = this;
            return runAll.returnResultOrExit(runAll.recursivelyExecuteUserObject(parseResult, new ArrayList<Object>()));
        }

        private List<Object> recursivelyExecuteUserObject(ParseResult parseResult, List<Object> result) throws ExecutionException {
            CommandLine.executeUserObject(parseResult.commandSpec().commandLine(), result);
            for (ParseResult parseResult2 : parseResult.subcommands()) {
                this.recursivelyExecuteUserObject(parseResult2, result);
            }
            return result;
        }

        @Override
        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            return this.recursivelyExtractExitCodeGenerators(parseResult, new ArrayList<IExitCodeGenerator>());
        }

        private List<IExitCodeGenerator> recursivelyExtractExitCodeGenerators(ParseResult parseResult, List<IExitCodeGenerator> result) throws ExecutionException {
            if (parseResult.commandSpec().userObject() instanceof IExitCodeGenerator) {
                result.add((IExitCodeGenerator)parseResult.commandSpec().userObject());
            }
            for (ParseResult parseResult2 : parseResult.subcommands()) {
                this.recursivelyExtractExitCodeGenerators(parseResult2, result);
            }
            return result;
        }

        @Override
        protected RunAll self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunLast
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(RunLast.executeUserObjectOfLastSubcommandWithSameParent(parsedCommands));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            return RunLast.executeUserObjectOfLastSubcommandWithSameParent(parseResult.asCommandLineList());
        }

        private static List<Object> executeUserObjectOfLastSubcommandWithSameParent(List<CommandLine> parsedCommands) {
            int n2 = RunLast.indexOfLastSubcommandWithSameParent(parsedCommands);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = n2; i2 < parsedCommands.size(); ++i2) {
                CommandLine.executeUserObject(parsedCommands.get(i2), arrayList);
            }
            return arrayList;
        }

        private static int indexOfLastSubcommandWithSameParent(List<CommandLine> parsedCommands) {
            int n2 = parsedCommands.size() - 1;
            int n3 = parsedCommands.size() - 2;
            while (n3 >= 0 && parsedCommands.get(n3).getParent() == parsedCommands.get(n3 + 1).getParent()) {
                n2 = n3--;
            }
            return n2;
        }

        @Override
        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            List<CommandLine> list = parseResult.asCommandLineList();
            int n2 = RunLast.indexOfLastSubcommandWithSameParent(list);
            ArrayList<IExitCodeGenerator> arrayList = new ArrayList<IExitCodeGenerator>();
            for (int i2 = n2; i2 < list.size(); ++i2) {
                Object object = list.get(i2).getCommandSpec().userObject();
                if (!(object instanceof IExitCodeGenerator)) continue;
                arrayList.add((IExitCodeGenerator)object);
            }
            return arrayList;
        }

        @Override
        protected RunLast self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunFirst
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(CommandLine.executeUserObject(parsedCommands.get(0), new ArrayList()));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            return CommandLine.executeUserObject(parseResult.commandSpec().commandLine(), new ArrayList());
        }

        @Override
        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            if (parseResult.commandSpec().userObject() instanceof IExitCodeGenerator) {
                return Collections.singletonList((IExitCodeGenerator)parseResult.commandSpec().userObject());
            }
            return Collections.emptyList();
        }

        @Override
        protected RunFirst self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class AbstractParseResultHandler<R>
    extends AbstractHandler<R, AbstractParseResultHandler<R>>
    implements IExecutionStrategy,
    IParseResultHandler2<R> {
        @Override
        public R handleParseResult(ParseResult parseResult) throws ExecutionException {
            if (CommandLine.printHelpIfRequested(parseResult.asCommandLineList(), this.out(), this.err(), this.colorScheme())) {
                return this.returnResultOrExit(null);
            }
            AbstractParseResultHandler abstractParseResultHandler = this;
            return abstractParseResultHandler.returnResultOrExit(abstractParseResultHandler.handle(parseResult));
        }

        @Override
        public int execute(ParseResult parseResult) throws ExecutionException {
            Integer n2 = CommandLine.executeHelpRequest(parseResult);
            if (n2 != null) {
                return n2;
            }
            R r2 = this.handle(parseResult);
            List<IExitCodeGenerator> list = this.extractExitCodeGenerators(parseResult);
            return this.resolveExitCode(parseResult.commandSpec().exitCodeOnSuccess(), r2, list);
        }

        private int resolveExitCode(int exitCodeOnSuccess, R executionResult, List<IExitCodeGenerator> exitCodeGenerators) {
            int n2 = 0;
            for (IExitCodeGenerator object : exitCodeGenerators) {
                try {
                    int exception = object.getExitCode();
                    if ((exception <= 0 || exception <= n2) && (exception >= n2 || n2 > 0)) continue;
                    n2 = exception;
                }
                catch (Exception e2) {
                    n2 = n2 == 0 ? 1 : n2;
                    e2.printStackTrace();
                }
            }
            if (executionResult instanceof List) {
                List list = (List)executionResult;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int n3;
                    Object e2 = iterator.next();
                    if (!(e2 instanceof Integer) || ((n3 = ((Integer)e2).intValue()) <= 0 || n3 <= n2) && (n3 >= n2 || n2 > 0)) continue;
                    n2 = n3;
                }
            }
            if (n2 == 0) {
                return exitCodeOnSuccess;
            }
            return n2;
        }

        protected abstract R handle(ParseResult var1) throws ExecutionException;

        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            return Collections.emptyList();
        }
    }

    static class ColoredStackTraceWriter
    extends StringWriter {
        Help.ColorScheme colorScheme;

        public ColoredStackTraceWriter(Help.ColorScheme colorScheme) {
            this.colorScheme = colorScheme;
        }

        public void write(String str, int off, int len) {
            List<Help.Ansi.IStyle> list = str.startsWith("\t") ? this.colorScheme.stackTraceStyles() : this.colorScheme.errorStyles();
            ColoredStackTraceWriter coloredStackTraceWriter = this;
            super.write(coloredStackTraceWriter.colorScheme.apply(str.substring(off, len), list).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class DefaultExceptionHandler<R>
    extends AbstractHandler<R, DefaultExceptionHandler<R>>
    implements IExceptionHandler,
    IExceptionHandler2<R> {
        @Override
        public List<Object> handleException(ParameterException ex, PrintStream out, Help.Ansi ansi, String ... args) {
            DefaultExceptionHandler.internalHandleParseException(ex, new PrintWriter(out, true), Help.defaultColorScheme(ansi));
            return Collections.emptyList();
        }

        @Override
        public R handleParseException(ParameterException ex, String[] args) {
            DefaultExceptionHandler.internalHandleParseException(ex, new PrintWriter(this.err(), true), this.colorScheme());
            return this.returnResultOrExit(null);
        }

        static void internalHandleParseException(ParameterException ex, PrintWriter writer, Help.ColorScheme colorScheme) {
            Tracer tracer;
            writer.println(colorScheme.errorText(ex.getMessage()));
            if (!UnmatchedArgumentException.printSuggestions(ex, writer)) {
                ex.getCommandLine().usage(writer, colorScheme);
            }
            if ((tracer = new Tracer()).isDebug()) {
                ex.printStackTrace(tracer.stream);
            }
        }

        @Override
        public R handleExecutionException(ExecutionException ex, ParseResult parseResult) {
            return this.throwOrExit(ex);
        }

        @Override
        protected DefaultExceptionHandler<R> self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class AbstractHandler<R, T extends AbstractHandler<R, T>> {
        private Help.ColorScheme colorScheme = Help.defaultColorScheme(Help.Ansi.AUTO);
        private Integer exitCode;
        private PrintStream out = System.out;
        private PrintStream err = System.err;

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }

        @Deprecated
        public Help.Ansi ansi() {
            return this.colorScheme.ansi();
        }

        public Help.ColorScheme colorScheme() {
            return this.colorScheme;
        }

        public Integer exitCode() {
            return this.exitCode;
        }

        public boolean hasExitCode() {
            return this.exitCode != null;
        }

        protected R returnResultOrExit(R result) {
            if (this.hasExitCode()) {
                AbstractHandler abstractHandler = this;
                abstractHandler.exit(abstractHandler.exitCode());
            }
            return result;
        }

        protected R throwOrExit(ExecutionException ex) {
            if (this.hasExitCode()) {
                ex.printStackTrace(this.err());
                AbstractHandler abstractHandler = this;
                abstractHandler.exit(abstractHandler.exitCode());
                return null;
            }
            throw ex;
        }

        protected void exit(int exitCode) {
            System.exit(exitCode);
        }

        protected abstract T self();

        @Deprecated
        public T useOut(PrintStream out) {
            this.out = Assert.notNull(out, "out");
            return this.self();
        }

        @Deprecated
        public T useErr(PrintStream err) {
            this.err = Assert.notNull(err, "err");
            return this.self();
        }

        @Deprecated
        public T useAnsi(Help.Ansi ansi) {
            this.colorScheme = Help.defaultColorScheme(Assert.notNull(ansi, "ansi"));
            return this.self();
        }

        @Deprecated
        public T andExit(int exitCode) {
            this.exitCode = exitCode;
            return this.self();
        }
    }

    public static interface IExecutionExceptionHandler {
        public int handleExecutionException(Exception var1, CommandLine var2, ParseResult var3) throws Exception;
    }

    public static interface IParameterExceptionHandler {
        public int handleParseException(ParameterException var1, String[] var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IExceptionHandler2<R> {
        public R handleParseException(ParameterException var1, String[] var2);

        public R handleExecutionException(ExecutionException var1, ParseResult var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IExceptionHandler {
        public List<Object> handleException(ParameterException var1, PrintStream var2, Help.Ansi var3, String ... var4);
    }

    public static interface IExecutionStrategy {
        public int execute(ParseResult var1) throws ExecutionException, ParameterException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IParseResultHandler2<R> {
        public R handleParseResult(ParseResult var1) throws ExecutionException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IParseResultHandler {
        public List<Object> handleParseResult(List<CommandLine> var1, PrintStream var2, Help.Ansi var3) throws ExecutionException;
    }

    public static interface IExitCodeExceptionMapper {
        public int getExitCode(Throwable var1);
    }

    public static interface IExitCodeGenerator {
        public int getExitCode();
    }

    public static final class ExitCode {
        public static final int OK = 0;
        public static final int SOFTWARE = 1;
        public static final int USAGE = 2;

        private ExitCode() {
        }
    }
}

