/*
 * Decompiled with CFR 0.152.
 */
package water.genmodel;

import java.lang.reflect.Constructor;

public abstract class AbstractBuildVersion {
    private static final String UNKNOWN_VERSION_MARKER = "(unknown)";
    public static final AbstractBuildVersion UNKNOWN_VERSION = new AbstractBuildVersion(){

        @Override
        public final String projectVersion() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public final String lastCommitHash() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public final String describe() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public final String compiledOn() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public final String compiledBy() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public final String branchName() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }
    };

    public abstract String branchName();

    public abstract String lastCommitHash();

    public abstract String describe();

    public abstract String projectVersion();

    public abstract String compiledOn();

    public abstract String compiledBy();

    public String toString() {
        return "H2O-GENMODEL v" + this.projectVersion() + " (" + this.branchName() + " - " + this.lastCommitHash() + ")";
    }

    public String buildNumber() {
        String string = this.projectVersion();
        if (string.equals(UNKNOWN_VERSION_MARKER)) {
            return UNKNOWN_VERSION_MARKER;
        }
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        return string2;
    }

    private String getValue(String name) {
        switch (name) {
            case "projectVersion": {
                return this.projectVersion();
            }
            case "lastCommitHash": {
                return this.lastCommitHash();
            }
            case "describe": {
                return this.describe();
            }
            case "compiledOn": {
                return this.compiledOn();
            }
            case "compiledBy": {
                return this.compiledBy();
            }
            case "branchName": {
                return this.branchName();
            }
        }
        return null;
    }

    public static AbstractBuildVersion getBuildVersion() {
        AbstractBuildVersion abstractBuildVersion = UNKNOWN_VERSION;
        try {
            Class<?> clazz = Class.forName("water.genmodel.BuildVersion");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            abstractBuildVersion = (AbstractBuildVersion)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {}
        return abstractBuildVersion;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"projectVersion"};
        }
        AbstractBuildVersion abstractBuildVersion = AbstractBuildVersion.getBuildVersion();
        System.out.print(abstractBuildVersion.getValue(args[0]));
        for (int i2 = 1; i2 < args.length; ++i2) {
            System.out.print(' ');
            System.out.print(abstractBuildVersion.getValue(args[i2]));
        }
        System.out.println();
    }
}

