/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JavaVersionUtils {
    JAVA_VERSION,
    JAVA_8(8),
    JAVA_9(9);

    public static final int UNKNOWN = -1;
    private final int majorVersion;

    private JavaVersionUtils() {
        this(System.getProperty("java.version"));
    }

    private JavaVersionUtils(String javaVersion) {
        this(JavaVersionUtils.parseMajor(javaVersion));
    }

    private JavaVersionUtils(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public final int getMajor() {
        return this.majorVersion;
    }

    public final boolean isKnown() {
        return this.majorVersion != -1;
    }

    static int parseMajor(String version) {
        Pattern pattern;
        Matcher matcher;
        if (version != null && (matcher = (pattern = Pattern.compile("1\\.([0-9]*).*|([0-9][0-9]*).*")).matcher(version)).matches()) {
            Matcher matcher2 = matcher;
            return Integer.parseInt(matcher2.group(matcher2.group(1) != null ? 1 : 2));
        }
        return -1;
    }

    public final boolean useUnifiedLogging() {
        return this.isKnown() && this.getMajor() >= 9;
    }

    public final String getVerboseGCFlag() {
        if (this.useUnifiedLogging()) {
            return "-Xlog:gc=info";
        }
        return "-verbose:gc";
    }
}

