/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.doc.generation;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.ml.param.Params;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ParametersTemplate$ {
    public static ParametersTemplate$ MODULE$;

    static {
        new ParametersTemplate$();
    }

    public String apply(Class<?> algorithm, Option<Class<?>> mojoModel) {
        Seq<Tuple2<String, String>> entities = this.getListOfAffectedEntities(algorithm);
        String caption = new StringBuilder(14).append("Parameters of ").append(algorithm.getSimpleName()).toString();
        String dashes = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(caption.toCharArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)ParametersTemplate$.$anonfun$apply$1(BoxesRunTime.unboxToChar((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())))).mkString();
        String classes = ((TraversableOnce)entities.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(6).append("- ``").append(c._2()).append("``").toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String classesCaption = entities.length() > 1 ? "Affected Classes" : "Affected Class";
        String classesCaptionUnderLine = classesCaption.replaceAll(".", "#");
        String content = this.getParametersContent(algorithm, mojoModel);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append(".. _parameters_").append(algorithm.getSimpleName()).append(":\n       |\n       |").append(caption).append("\n       |").append(dashes).append("\n       |\n       |").append(classesCaption).append("\n       |").append(classesCaptionUnderLine).append("\n       |\n       |").append(classes).append("\n       |\n       |Parameters\n       |##########\n       |\n       |- *Each parameter has also a corresponding getter and setter method.*\n       |  *(E.g.:* ``label`` *->* ``getLabel()`` *,* ``setLabel(...)`` *)*\n       |\n       |").append(content).append("\n     ").toString())).stripMargin();
    }

    private Seq<Tuple2<String, String>> getListOfAffectedEntities(Class<?> entity) {
        List list;
        List list2;
        String baseSimpleName = entity.getSimpleName();
        String baseCanonicalName = entity.getCanonicalName();
        Tuple2 tuple2 = new Tuple2((Object)baseSimpleName, (Object)baseCanonicalName);
        List base = Nil$.MODULE$.$colon$colon((Object)tuple2);
        String namespaceWithDot = baseCanonicalName.substring(0, baseCanonicalName.length() - baseSimpleName.length());
        String fullClassifierName = new StringBuilder(25).append(namespaceWithDot).append("classification.").append(baseSimpleName).append("Classifier").toString();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Class.forName(fullClassifierName));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Class classifier = (Class)success.value();
            list2 = (List)base.$colon$plus((Object)new Tuple2((Object)classifier.getSimpleName(), (Object)classifier.getCanonicalName()), List$.MODULE$.canBuildFrom());
        } else if (try_ instanceof Failure) {
            list2 = base;
        } else {
            throw new MatchError((Object)try_);
        }
        List withClassifier = list2;
        String fullRegressorName = new StringBuilder(20).append(namespaceWithDot).append("regression.").append(baseSimpleName).append("Regressor").toString();
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Class.forName(fullRegressorName));
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            Class regressor = (Class)success.value();
            list = (List)withClassifier.$colon$plus((Object)new Tuple2((Object)regressor.getSimpleName(), (Object)regressor.getCanonicalName()), List$.MODULE$.canBuildFrom());
        } else if (try_2 instanceof Failure) {
            list = withClassifier;
        } else {
            throw new MatchError((Object)try_2);
        }
        List withRegressor = list;
        return withRegressor;
    }

    private String getParametersContent(Class<?> algorithm, Option<Class<?>> mojoModel) {
        Params algorithmInstance = (Params)algorithm.newInstance();
        Option mojoModelInstanceOption = mojoModel.map((Function1 & Serializable & scala.Serializable)x$3 -> (Params)x$3.getConstructor(String.class).newInstance("uid"));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])algorithmInstance.params())).map((Function1 & Serializable & scala.Serializable)param -> {
            String defaultValue = algorithmInstance.getDefault(param).isDefined() ? algorithmInstance.getDefault(param).get() : "No default value";
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append(param.name()).append("\n           |  ").append(param.doc().replace(" \n", "").replace("\n ", "\n\n  - ")).append("\n           |\n           |  ").append(MODULE$.generateDefaultValue(defaultValue)).append("\n           |  ").append(MODULE$.generateMOJOComment(param.name(), (Option<Params>)mojoModelInstanceOption)).append("\n           |").toString())).stripMargin();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    private String generateMOJOComment(String paramName, Option<Params> mojoModelInstanceOption) {
        return (String)mojoModelInstanceOption.map((Function1 & Serializable & scala.Serializable)mojoModelInstance -> {
            if (mojoModelInstance.hasParam(paramName)) {
                return "\n  *Also available on the trained model.*";
            }
            return "";
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private String generateDefaultValue(Object value) {
        String pythonValue = this.stringifyAsPython(value);
        String scalaValue = this.stringifyAsScala(value);
        String string = pythonValue;
        String string2 = scalaValue;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new StringBuilder(21).append("*Default value:* ``").append(pythonValue).append("``").toString();
        }
        return new StringBuilder(58).append("*Scala default value:* ``").append(scalaValue).append("`` *; Python default value:* ``").append(pythonValue).append("``").toString();
    }

    private String stringifyAsPython(Object value2) {
        Object object = value2;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return new StringBuilder(2).append("[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.stringifyAsPython(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).append("]").toString();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(4).append(MODULE$.stringifyAsPython(entry._1())).append(" -> ").append(MODULE$.stringifyAsPython(entry._2())).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("{", ", ", "}");
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new StringOps(Predef$.MODULE$.augmentString(Boolean.toString(bl))).capitalize();
        }
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("\"").append(string).append("\"").toString();
        }
        if (object == null) {
            return "None";
        }
        if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            return new StringBuilder(2).append("\"").append(enum_).append("\"").toString();
        }
        return object.toString();
    }

    public String stringifyAsScala(Object value2) {
        Object object = value2;
        if (object instanceof Float) {
            Float f = (Float)object;
            return new StringBuilder(1).append(f.toString().toLowerCase()).append("f").toString();
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.toString().toLowerCase();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return new StringBuilder(1).append(l).append("L").toString();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(4).append(MODULE$.stringifyAsScala(entry._1())).append(" -> ").append(MODULE$.stringifyAsScala(entry._2())).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("Map(", ", ", ")");
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return new StringBuilder(7).append("Array(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.stringifyAsScala(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).append(")").toString();
        }
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("\"").append(string).append("\"").toString();
        }
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static final /* synthetic */ char $anonfun$apply$1(char x$1) {
        return '-';
    }

    private ParametersTemplate$() {
        MODULE$ = this;
    }
}

