/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.examples.h2o.Airlines;
import org.apache.spark.examples.h2o.AirlinesWithWeatherDemo$;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.examples.h2o.Weather;
import org.apache.spark.examples.h2o.WeatherParse$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.package;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import org.apache.spark.sql.catalyst.expressions.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import water.fvec.DataFrame;
import water.fvec.Frame;

public final class AirlinesWithWeatherDemo$ {
    public static final AirlinesWithWeatherDemo$ MODULE$;

    static {
        new AirlinesWithWeatherDemo$();
    }

    public void main(String[] args) {
        SparkConf conf = DemoUtils$.MODULE$.configure("Sparkling Water: Join of Airlines with Weather Data");
        SparkContext sc = new SparkContext(conf);
        H2OContext h2oContext = new H2OContext(sc).start();
        DemoUtils$.MODULE$.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"examples/smalldata/Chicago_Ohare_International_Airport.csv", "examples/smalldata/allyears2k_headers.csv.gz"}));
        RDD wrawdata = sc.textFile(SparkFiles$.MODULE$.get("Chicago_Ohare_International_Airport.csv"), 3).cache();
        RDD weatherTable = wrawdata.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Weather apply(String[] row) {
                return WeatherParse$.MODULE$.apply(row);
            }
        }, ClassTag$.MODULE$.apply(Weather.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Weather x$2) {
                return !x$2.isWrongRow();
            }
        });
        DataFrame airlinesData = new DataFrame(new File(SparkFiles$.MODULE$.get("allyears2k_headers.csv.gz")));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator1$1() {
            }
        }
        RDD airlinesTable = h2oContext.asRDD(airlinesData, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator1$1()), ClassTag$.MODULE$.apply(Airlines.class));
        RDD flightsToORD = airlinesTable.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Airlines f) {
                Option<String> option = f.Dest();
                Some some = new Some((Object)"ORD");
                return !(option != null ? !option.equals((Object)some) : some != null);
            }
        });
        flightsToORD.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nFlights to ORD: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)flightsToORD.count())})));
        SQLContext sqlContext = new SQLContext(sc);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator2$1() {
            }
        }
        sqlContext.createSchemaRDD(flightsToORD, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator2$1())).registerTempTable("FlightsToORD");
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Weather")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator3$1() {
            }
        }
        sqlContext.createSchemaRDD(weatherTable, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator3$1())).registerTempTable("WeatherORD");
        SchemaRDD bigTable = sqlContext.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |f.Year,f.Month,f.DayofMonth,\n        |f.CRSDepTime,f.CRSArrTime,f.CRSElapsedTime,\n        |f.UniqueCarrier,f.FlightNum,f.TailNum,\n        |f.Origin,f.Distance,\n        |w.TmaxF,w.TminF,w.TmeanF,w.PrcpIn,w.SnowIn,w.CDD,w.HDD,w.GDD,\n        |f.ArrDelay\n        |FROM FlightsToORD f\n        |JOIN WeatherORD w\n        |ON f.Year=w.Year AND f.Month=w.Month AND f.DayofMonth=w.Day")).stripMargin());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nResult of query: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)bigTable.count())})));
        Predef$.MODULE$.refArrayOps((Object[])bigTable.take(10)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Row x$3) {
                Predef$.MODULE$.println((Object)x$3);
            }
        });
        DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
        dlParams._train = h2oContext.createDataFrameKey(bigTable);
        dlParams._response_column = h2oContext.symbolToString(Symbol$.MODULE$.apply("ArrDelay"));
        dlParams._epochs = 100.0;
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel dlModel = (DeepLearningModel)dl.trainModel().get();
        DataFrame predictionH2OFrame = h2oContext.createDataFrame(dlModel.score((Frame)h2oContext.createDataFrame(bigTable))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("predict")}));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.h2o")), $m.staticModule("org.apache.spark.h2o.package")), $m.staticClass("org.apache.spark.h2o.DoubleHolder"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator4$1() {
            }
        }
        double[] predictionsFromModel = (double[])Predef$.MODULE$.refArrayOps((Object[])h2oContext.asRDD(predictionH2OFrame, ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator4$1()), ClassTag$.MODULE$.apply(package.DoubleHolder.class)).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(package.DoubleHolder x$4) {
                return BoxesRunTime.unboxToDouble((Object)x$4.result().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Double.NaN;
                    }
                }));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.doubleArrayOps(predictionsFromModel).mkString("\n===> Model predictions: ", ", ", ", ...\n"));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# R script for residual plot\n        |library(h2o)\n        |h = h2o.init()\n        |\n        |pred = h2o.getFrame(h, \"", "\")\n        |act = h2o.getFrame (h, \"", "\")\n        |\n        |predDelay = pred$predict\n        |actDelay = act$ArrDelay\n        |\n        |nrow(actDelay) == nrow(predDelay)\n        |\n        |residuals = predDelay - actDelay\n        |\n        |compare = cbind (as.data.frame(actDelay$ArrDelay), as.data.frame(residuals$predict))\n        |nrow(compare)\n        |plot( compare[,1:2] )\n        |\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{predictionH2OFrame._key, h2oContext.createDataFrame((SchemaRDD)bigTable)._key})))).stripMargin());
        Thread.sleep(3600000L);
        sc.stop();
    }

    private AirlinesWithWeatherDemo$() {
        MODULE$ = this;
    }
}

