/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.examples.h2o.Airlines;
import org.apache.spark.examples.h2o.DeepLearningDemoWithoutExtension$;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.package;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import water.fvec.DataFrame;
import water.fvec.Frame;

public final class DeepLearningDemoWithoutExtension$ {
    public static final DeepLearningDemoWithoutExtension$ MODULE$;

    static {
        new DeepLearningDemoWithoutExtension$();
    }

    public void main(String[] args) {
        SparkConf conf = DemoUtils$.MODULE$.configure("Sparkling water: DL demo without Spark modification");
        SparkContext sc = new SparkContext(conf);
        DemoUtils$.MODULE$.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"examples/smalldata/allyears2k_headers.csv.gz"}));
        H2OContext h2oContext = new H2OContext(sc).start();
        DataFrame airlinesData = new DataFrame(new File(SparkFiles$.MODULE$.get("allyears2k_headers.csv.gz")));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator1$1() {
            }
        }
        RDD airlinesTable = h2oContext.asRDD(airlinesData, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator1$1()), ClassTag$.MODULE$.apply(Airlines.class));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of all flights via RDD#count call: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)airlinesTable.count())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of all flights via H2O#Frame#count: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)airlinesData.numRows())})));
        SQLContext sqlContext = new SQLContext(sc);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator2$1() {
            }
        }
        sqlContext.createSchemaRDD(airlinesTable, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator2$1())).registerTempTable("airlinesTable");
        String query = "SELECT * FROM airlinesTable WHERE Dest LIKE 'SFO'";
        SchemaRDD result = sqlContext.sql(query);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of flights with destination in SFO: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)result.count())})));
        Predef$.MODULE$.println((Object)"\n====> Running DeepLearning on the result of SQL query\n");
        DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
        dlParams._train = h2oContext.dataFrameToKey((Frame)h2oContext.createDataFrame(result).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("Year"), Symbol$.MODULE$.apply("Month"), Symbol$.MODULE$.apply("DayofMonth"), Symbol$.MODULE$.apply("DayOfWeek"), Symbol$.MODULE$.apply("CRSDepTime"), Symbol$.MODULE$.apply("CRSArrTime"), Symbol$.MODULE$.apply("UniqueCarrier"), Symbol$.MODULE$.apply("FlightNum"), Symbol$.MODULE$.apply("TailNum"), Symbol$.MODULE$.apply("CRSElapsedTime"), Symbol$.MODULE$.apply("Origin"), Symbol$.MODULE$.apply("Dest"), Symbol$.MODULE$.apply("Distance"), Symbol$.MODULE$.apply("IsDepDelayed")})));
        dlParams._response_column = h2oContext.symbolToString(Symbol$.MODULE$.apply("IsDepDelayed"));
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel dlModel = (DeepLearningModel)dl.trainModel().get();
        Predef$.MODULE$.println((Object)"\n====> Making prediction with help of DeepLearning model\n");
        DataFrame predictionH2OFrame = h2oContext.createDataFrame(dlModel.score((Frame)h2oContext.createDataFrame(result))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("predict")}));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.h2o")), $m.staticModule("org.apache.spark.h2o.package")), $m.staticClass("org.apache.spark.h2o.DoubleHolder"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator3$1() {
            }
        }
        Object[] predictionsFromModel = (Object[])Predef$.MODULE$.refArrayOps((Object[])h2oContext.asRDD(predictionH2OFrame, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator3$1()), ClassTag$.MODULE$.apply(package.DoubleHolder.class)).take(10)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(package.DoubleHolder x$1) {
                return x$1.result().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NaN";
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.genericArrayOps((Object)predictionsFromModel).mkString("\n===> Model predictions: ", ", ", ", ...\n"));
        if (System.getProperty("spark.ext.h2o.preserve.executors") == null) {
            sc.stop();
        }
    }

    private DeepLearningDemoWithoutExtension$() {
        MODULE$ = this;
    }
}

