/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.sys.package$;
import water.H2O;
import water.H2OClientApp;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.DataFrame;
import water.fvec.Frame;
import water.parser.ValueString;

public final class DemoUtils$ {
    public static final DemoUtils$ MODULE$;

    static {
        new DemoUtils$();
    }

    public SparkContext createSparkContext(String sparkMaster, boolean registerH2OExtension) {
        String h2oWorkers = System.getProperty("spark.h2o.workers", "3");
        int h2oCloudTimeout = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.ext.h2o.cloud.timeout", "60000"))).toInt();
        SparkConf conf = new SparkConf().setAppName("H2O Integration Example");
        Object object = System.getProperty("spark.master") == null ? conf.setMaster(sparkMaster == null ? "local" : sparkMaster) : BoxedUnit.UNIT;
        conf.set("spark.ext.h2o.cluster.size", conf.get("spark.master").equals("local") || conf.get("spark.master").startsWith("local[") ? "1" : h2oWorkers);
        if (registerH2OExtension) {
            // empty if block
        }
        SparkContext sc = new SparkContext(conf);
        if (registerH2OExtension) {
            if (sc.isLocal()) {
                H2O.waitForCloudSize((int)1, (long)h2oCloudTimeout);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Waiting for ").append((Object)h2oWorkers).toString());
                H2OClientApp.start();
                H2O.waitForCloudSize((int)new StringOps(Predef$.MODULE$.augmentString(h2oWorkers)).toInt(), (long)h2oCloudTimeout);
            }
        }
        return sc;
    }

    public String createSparkContext$default$1() {
        return null;
    }

    public boolean createSparkContext$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public SparkConf configure(String appName) {
        void var2_2;
        SparkConf conf = new SparkConf().setAppName(appName);
        conf.setIfMissing("spark.master", (String)package$.MODULE$.env().getOrElse((Object)"spark.master", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "local";
            }
        }));
        return var2_2;
    }

    public String configure$default$1() {
        return "Sparkling Water Demo";
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        files.foreach((Function1)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;

            public final void apply(String f) {
                this.sc$1.addFile(f);
            }
            {
                this.sc$1 = sc$1;
            }
        });
    }

    public void printFrame(DataFrame fr) {
        new MRTask<Nothing$>(){

            public void map(Chunk[] cs) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Chunks: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])cs).mkString(",")).toString());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cs[0]._len).foreach$mVc$sp((Function1)new Serializable(this, cs){
                    public static final long serialVersionUID = 0L;
                    private final Chunk[] cs$1;

                    public final void apply(int r) {
                        this.apply$mcVI$sp(r);
                    }

                    public void apply$mcVI$sp(int r) {
                        Predef$.MODULE$.refArrayOps((Object[])this.cs$1).foreach((Function1)new Serializable(this, r){
                            public static final long serialVersionUID = 0L;
                            private final int r$1;

                            public final void apply(Chunk c) {
                                ValueString vstr = new ValueString();
                                if (c.vec().isString()) {
                                    c.atStr(vstr, this.r$1);
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)vstr.toString()).append((Object)",").toString());
                                } else if (c.vec().isEnum()) {
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)c.vec().domain()[(int)c.at8(this.r$1)]).append((Object)", ").toString());
                                } else {
                                    Predef$.MODULE$.print((Object)new StringBuilder().append(c.atd(this.r$1)).append((Object)", ").toString());
                                }
                            }
                            {
                                this.r$1 = r$1;
                            }
                        });
                        Predef$.MODULE$.println();
                    }
                    {
                        this.cs$1 = cs$1;
                    }
                });
            }
        }.doAll((Frame)fr);
    }

    public String residualPlotRCode(Frame prediction, String predCol, Frame actual, String actCol) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# R script for residual plot\n        |library(h2o)\n        |h = h2o.init()\n        |\n        |pred = h2o.getFrame(h, \"", "\")\n        |act = h2o.getFrame (h, \"", "\")\n        |\n        |predDelay = pred$", "\n        |actDelay = act$", "\n        |\n        |nrow(actDelay) == nrow(predDelay)\n        |\n        |residuals = predDelay - actDelay\n        |\n        |compare = cbind (as.data.frame(actDelay$ArrDelay), as.data.frame(residuals$predict))\n        |nrow(compare)\n        |plot( compare[,1:2] )\n        |\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prediction._key, actual._key, predCol, actCol})))).stripMargin();
    }

    private DemoUtils$() {
        MODULE$ = this;
    }
}

