/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.examples.h2o.Prostate;
import org.apache.spark.examples.h2o.ProstateDemo$;
import org.apache.spark.examples.h2o.ProstateParse$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.ScalaRunTime$;
import water.AutoBuffer;
import water.fvec.DataFrame;

public final class ProstateDemo$ {
    public static final ProstateDemo$ MODULE$;

    static {
        new ProstateDemo$();
    }

    public void main(String[] args) {
        SparkConf conf = DemoUtils$.MODULE$.configure("Sparkling Water: Prostate demo");
        SparkContext sc = new SparkContext(conf);
        DemoUtils$.MODULE$.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"examples/smalldata/prostate.csv"}));
        H2OContext h2oContext = new H2OContext(sc).start();
        ProstateParse$ parse = ProstateParse$.MODULE$;
        RDD rawdata = sc.textFile(SparkFiles$.MODULE$.get("prostate.csv"), 2);
        RDD table = rawdata.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(parse){
            public static final long serialVersionUID = 0L;
            private final ProstateParse$ parse$1;

            public final Prostate apply(String[] line) {
                return this.parse$1.apply(line);
            }
            {
                this.parse$1 = parse$1;
            }
        }, ClassTag$.MODULE$.apply(Prostate.class));
        SQLContext sqlContext = new SQLContext(sc);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_ProstateDemo$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Prostate")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_ProstateDemo$$typecreator1$1() {
            }
        }
        sqlContext.createSchemaRDD(table, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_ProstateDemo$$typecreator1$1())).registerTempTable("prostate_table");
        String query = "SELECT * FROM prostate_table WHERE CAPSULE=1";
        SchemaRDD result = sqlContext.sql(query);
        KMeansModel model = this.runKmeans(h2oContext.createDataFrame(result));
        Predef$.MODULE$.println((Object)model);
        sc.stop();
    }

    private <T> KMeansModel runKmeans(DataFrame trainDataFrame) {
        KMeansModel.KMeansParameters params = new KMeansModel.KMeansParameters();
        params._train = trainDataFrame._key;
        params._k = 3;
        KMeans job = new KMeans(params);
        KMeansModel kmm = (KMeansModel)job.trainModel().get();
        job.remove();
        Predef$.MODULE$.println((Object)new String(kmm._output.writeJSON(new AutoBuffer()).buf()));
        return kmm;
    }

    private ProstateDemo$() {
        MODULE$ = this;
    }
}

