/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Model;
import hex.ModelMetricsBinomial;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.ChicagoCrimeApp$;
import org.apache.spark.examples.h2o.Crime;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.examples.h2o.RefineDateColumn;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import water.H2O;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.fvec.Vec;

@ScalaSignature(bytes="\u0006\u0001\tUh\u0001B\u0001\u0003\u00015\u0011qb\u00115jG\u0006<wn\u0011:j[\u0016\f\u0005\u000f\u001d\u0006\u0003\u0007\u0011\t1\u0001\u001b\u001ap\u0015\t)a!\u0001\u0005fq\u0006l\u0007\u000f\\3t\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0017],\u0017\r\u001e5fe\u001aKG.\u001a\t\u0003/iq!a\u0004\r\n\u0005e\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001c9\t11\u000b\u001e:j]\u001eT!!\u0007\t\t\u0011y\u0001!\u0011!Q\u0001\nY\t!bY3ogV\u001ch)\u001b7f\u0011!\u0001\u0003A!A!\u0002\u00131\u0012AC2sS6,7OR5mK\"A!\u0005\u0001BC\u0002\u0013\u00051%A\u0006eCR,\u0007+\u0019;uKJtW#\u0001\f\t\u0011\u0015\u0002!\u0011!Q\u0001\nY\tA\u0002Z1uKB\u000bG\u000f^3s]\u0002B\u0001b\n\u0001\u0003\u0006\u0004%\taI\u0001\rI\u0006$X\rV5nKj{g.\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005-\u0005iA-\u0019;f)&lWMW8oK\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\u0003g\u000e,\u0012!\f\t\u0003]=j\u0011AB\u0005\u0003a\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001B\r\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0004g\u000e\u0004\u0003FA\u00195!\tyQ'\u0003\u00027!\tIAO]1og&,g\u000e\u001e\u0005\tq\u0001\u0011)\u0019!C\u0001s\u0005Q1/\u001d7D_:$X\r\u001f;\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\u0004\u0002\u0007M\fH.\u0003\u0002@y\tQ1+\u0015'D_:$X\r\u001f;\t\u0011\u0005\u0003!\u0011!Q\u0001\ni\n1b]9m\u0007>tG/\u001a=uA!\u0012\u0001\t\u000e\u0005\t\t\u0002\u0011)\u0019!C\u0001\u000b\u0006Q\u0001NM8D_:$X\r\u001f;\u0016\u0003\u0019\u0003\"aR%\u000e\u0003!S!a\u0001\u0004\n\u0005)C%A\u0003%3\u001f\u000e{g\u000e^3yi\"AA\n\u0001B\u0001B\u0003%a)A\u0006ie=\u001cuN\u001c;fqR\u0004\u0003FA&5\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0019a\u0014N\\5u}Q1\u0011k\u0016-Z5n#BA\u0015+V-B\u00111\u000bA\u0007\u0002\u0005!)1F\u0014a\u0001[!)\u0001H\u0014a\u0001u!)AI\u0014a\u0001\r\")QC\u0014a\u0001-!)aD\u0014a\u0001-!)\u0001E\u0014a\u0001-!9!E\u0014I\u0001\u0002\u00041\u0002bB\u0014O!\u0003\u0005\rA\u0006\u0005\u0006;\u0002!\tAX\u0001\u0006iJ\f\u0017N\u001c\u000b\u0005?J<\u0018\u0010\u0005\u0003\u0010A\nd\u0017BA1\u0011\u0005\u0019!V\u000f\u001d7feA\u00111M[\u0007\u0002I*\u0011QMZ\u0001\u0004O\nl'BA4i\u0003\u0011!(/Z3\u000b\u0003%\f1\u0001[3y\u0013\tYGM\u0001\u0005H\u00056ku\u000eZ3m!\ti\u0007/D\u0001o\u0015\ty\u0007.\u0001\u0007eK\u0016\u0004H.Z1s]&tw-\u0003\u0002r]\n\tB)Z3q\u0019\u0016\f'O\\5oO6{G-\u001a7\t\u000bMd\u0006\u0019\u0001;\u0002\u0019],\u0017\r\u001e5feR\u000b'\r\\3\u0011\u0005m*\u0018B\u0001<=\u0005%\u00196\r[3nCJ#E\tC\u0003y9\u0002\u0007A/A\u0006dK:\u001cXo\u001d+bE2,\u0007\"\u0002>]\u0001\u0004!\u0018aC2sS6,7\u000fV1cY\u0016DQ\u0001 \u0001\u0005\u0002u\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0004}\u0006\r\u0001CA\b\u0000\u0013\r\t\t\u0001\u0005\u0002\u0005+:LG\u000fC\u0003,w\u0002\u0007Q\u0006C\u0004\u0002\b\u0001!\t!!\u0003\u0002\u0011\u001d\u0013U*T8eK2$b\"a\u0003\u0002\u0010\u0005U\u0012\u0011HA\u001f\u0003\u000f\nY\u0005F\u0002c\u0003\u001bAa\u0001RA\u0003\u0001\b1\u0005bB/\u0002\u0006\u0001\u0007\u0011\u0011\u0003\t\u0005\u0003'\tyC\u0004\u0003\u0002\u0016\u0005-b\u0002BA\f\u0003SqA!!\u0007\u0002(9!\u00111DA\u0013\u001d\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\r1\u0011bAA\u0017\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0019\u0003g\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u00055\u0002\n\u0003\u0005\u00028\u0005\u0015\u0001\u0019AA\t\u0003\u0011!Xm\u001d;\t\u000f\u0005m\u0012Q\u0001a\u0001-\u0005A!/Z:q_:\u001cX\r\u0003\u0006\u0002@\u0005\u0015\u0001\u0013!a\u0001\u0003\u0003\naA\u001c;sK\u0016\u001c\bcA\b\u0002D%\u0019\u0011Q\t\t\u0003\u0007%sG\u000f\u0003\u0006\u0002J\u0005\u0015\u0001\u0013!a\u0001\u0003\u0003\nQ\u0001Z3qi\"D!\"!\u0014\u0002\u0006A\u0005\t\u0019AA(\u0003\u00191\u0017-\\5msB!\u0011\u0011KA5\u001d\u0011\t\u0019&a\u0019\u000f\t\u0005U\u0013\u0011\r\b\u0005\u0003/\nyF\u0004\u0003\u0002Z\u0005uc\u0002BA\u000f\u00037J\u0011![\u0005\u0003O\"L!!\u001a4\n\u0007\u0005\u001dA-\u0003\u0003\u0002f\u0005\u001d\u0014!D$C\u001bB\u000b'/Y7fi\u0016\u00148OC\u0002\u0002\b\u0011LA!a\u001b\u0002n\t1a)Y7jYfTA!!\u001a\u0002h!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0014a\u0002#M\u001b>$W\r\u001c\u000b\u0013\u0003k\nI(a\u001f\u0002~\u0005}\u00141QAG\u0003#\u000by\u000bF\u0002m\u0003oBa\u0001RA8\u0001\b1\u0005bB/\u0002p\u0001\u0007\u0011\u0011\u0003\u0005\t\u0003o\ty\u00071\u0001\u0002\u0012!9\u00111HA8\u0001\u00041\u0002BCAA\u0003_\u0002\n\u00111\u0001\u0002B\u00051Q\r]8dQND!\"!\"\u0002pA\u0005\t\u0019AAD\u0003\ta\u0017\u0007E\u0002\u0010\u0003\u0013K1!a#\u0011\u0005\u0019!u.\u001e2mK\"Q\u0011qRA8!\u0003\u0005\r!a\"\u0002\u00051\u0014\u0004BCAJ\u0003_\u0002\n\u00111\u0001\u0002\u0016\u0006Q\u0011m\u0019;jm\u0006$\u0018n\u001c8\u0011\t\u0005]\u0015\u0011\u0016\b\u0005\u00033\u000b\u0019K\u0004\u0003\u0002\u001c\u0006}e\u0002BA-\u0003;K!a\u001c5\n\u0007\u0005\u0005f.A\tEK\u0016\u0004H*Z1s]&tw-T8eK2LA!!*\u0002(\u00061B)Z3q\u0019\u0016\f'O\\5oOB\u000b'/Y7fi\u0016\u00148OC\u0002\u0002\":LA!a+\u0002.\nQ\u0011i\u0019;jm\u0006$\u0018n\u001c8\u000b\t\u0005\u0015\u0016q\u0015\u0005\u000b\u0003c\u000by\u0007%AA\u0002\u0005M\u0016A\u00025jI\u0012,g\u000eE\u0003\u0010\u0003k\u000b\t%C\u0002\u00028B\u0011Q!\u0011:sCfDq!a/\u0001\t\u0003\ti,A\bcS:|W.[1m\u001b\u0016$(/[2t+!\ty,!7\u0002h\u0006uH\u0003CAa\u0003\u0017\u0014IAa\u0003\u0011\r=\u0001\u00171YAb!\u0011\t)-a2\u000e\u0003!L1!!3i\u0005Qiu\u000eZ3m\u001b\u0016$(/[2t\u0005&tw.\\5bY\"A\u0011QZA]\u0001\u0004\ty-A\u0003n_\u0012,G\u000e\u0005\u0006\u0002F\u0006E\u0017Q[As\u0003wL1!a5i\u0005\u0015iu\u000eZ3m!\u0011\t9.!7\r\u0001\u0011A\u00111\\A]\u0005\u0004\tiNA\u0001N#\u0011\ty.a4\u0011\u0007=\t\t/C\u0002\u0002dB\u0011qAT8uQ&tw\r\u0005\u0003\u0002X\u0006\u001dH\u0001CAu\u0003s\u0013\r!a;\u0003\u0003A\u000bB!a8\u0002nB!\u0011q^A{\u001d\u0011\tI&!=\n\u0007\u0005M\b.A\u0003N_\u0012,G.\u0003\u0003\u0002x\u0006e(A\u0003)be\u0006lW\r^3sg*\u0019\u00111\u001f5\u0011\t\u0005]\u0017Q \u0003\t\u0003\u007f\fIL1\u0001\u0003\u0002\t\tq*\u0005\u0003\u0002`\n\r\u0001\u0003BAx\u0005\u000bIAAa\u0002\u0002z\n1q*\u001e;qkRDq!XA]\u0001\u0004\t\t\u0002\u0003\u0005\u00028\u0005e\u0006\u0019AA\t\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#\tq\u0001\\8bI\u0006cG\u000e\u0006\u0002\u0003\u0014A1qB!\u0006uiRL1Aa\u0006\u0011\u0005\u0019!V\u000f\u001d7fg!9!1\u0004\u0001\u0005\n\tu\u0011\u0001\u00037pC\u0012$\u0015\r^1\u0015\t\u0005E!q\u0004\u0005\b\u0005C\u0011I\u00021\u0001\u0017\u0003!!\u0017\r^1gS2,\u0007b\u0002B\u0013\u0001\u0011\u0005!qE\u0001\u0013GJ,\u0017\r^3XK\u0006$\b.\u001a:UC\ndW\r\u0006\u0003\u0002\u0012\t%\u0002b\u0002B\u0011\u0005G\u0001\rA\u0006\u0005\b\u0005[\u0001A\u0011\u0001B\u0018\u0003E\u0019'/Z1uK\u000e+gn];t)\u0006\u0014G.\u001a\u000b\u0005\u0003#\u0011\t\u0004C\u0004\u0003\"\t-\u0002\u0019\u0001\f\t\u000f\tU\u0002\u0001\"\u0001\u00038\u0005\u00012M]3bi\u0016\u001c%/[7f)\u0006\u0014G.\u001a\u000b\u0005\u0003#\u0011I\u0004C\u0004\u0003\"\tM\u0002\u0019\u0001\f\t\u000f\tu\u0002\u0001\"\u0001\u0003@\u0005Q1oY8sK\u00163XM\u001c;\u0015\u0011\t\u0005#Q\nB,\u0005o\"bAa\u0011\u0003J\t-\u0003cA\b\u0003F%\u0019!q\t\t\u0003\u000b\u0019cw.\u0019;\t\ra\u0012Y\u0004q\u0001;\u0011\u0019!%1\ba\u0002\r\"A!q\nB\u001e\u0001\u0004\u0011\t&A\u0003de&lW\rE\u0002T\u0005'J1A!\u0016\u0003\u0005\u0015\u0019%/[7f\u0011!\tiMa\u000fA\u0002\te\u0003\u0007\u0003B.\u0005?\u0012iGa\u001d\u0011\u0015\u0005\u0015\u0017\u0011\u001bB/\u0005W\u0012\t\b\u0005\u0003\u0002X\n}C\u0001\u0004B1\u0005/\n\t\u0011!A\u0003\u0002\t\r$aA0%cE!\u0011q\u001cB3!\ry!qM\u0005\u0004\u0005S\u0002\"aA!osB!\u0011q\u001bB7\t1\u0011yGa\u0016\u0002\u0002\u0003\u0005)\u0011\u0001B2\u0005\ryFE\r\t\u0005\u0003/\u0014\u0019\b\u0002\u0007\u0003v\t]\u0013\u0011!A\u0001\u0006\u0003\u0011\u0019GA\u0002`IMBa\u0001\u001fB\u001e\u0001\u0004!\b\"\u0003B>\u0001E\u0005I\u0011\u0001B?\u0003I9%)T'pI\u0016dG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t}$\u0006BA!\u0005\u0003[#Aa!\u0011\t\t\u0015%qR\u0007\u0003\u0005\u000fSAA!#\u0003\f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001b\u0003\u0012AC1o]>$\u0018\r^5p]&!!\u0011\u0013BD\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005+\u0003\u0011\u0013!C\u0001\u0005{\n!c\u0012\"N\u001b>$W\r\u001c\u0013eK\u001a\fW\u000f\u001c;%k!I!\u0011\u0014\u0001\u0012\u0002\u0013\u0005!1T\u0001\u0013\u000f\nkUj\u001c3fY\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u001e*\"\u0011q\nBA\u0011%\u0011\t\u000bAI\u0001\n\u0003\u0011i(A\tE\u00196{G-\u001a7%I\u00164\u0017-\u001e7uIQB\u0011B!*\u0001#\u0003%\tAa*\u0002#\u0011cUj\u001c3fY\u0012\"WMZ1vYR$S'\u0006\u0002\u0003**\"\u0011q\u0011BA\u0011%\u0011i\u000bAI\u0001\n\u0003\u00119+A\tE\u00196{G-\u001a7%I\u00164\u0017-\u001e7uIYB\u0011B!-\u0001#\u0003%\tAa-\u0002#\u0011cUj\u001c3fY\u0012\"WMZ1vYR$s'\u0006\u0002\u00036*\"\u0011Q\u0013BA\u0011%\u0011I\fAI\u0001\n\u0003\u0011Y,A\tE\u00196{G-\u001a7%I\u00164\u0017-\u001e7uIa*\"A!0+\t\u0005M&\u0011Q\u0004\b\u0005\u0003\u0014\u0001\u0012\u0001Bb\u0003=\u0019\u0005.[2bO>\u001c%/[7f\u0003B\u0004\bcA*\u0003F\u001a1\u0011A\u0001E\u0001\u0005\u000f\u001c2A!2\u000f\u0011\u001dy%Q\u0019C\u0001\u0005\u0017$\"Aa1\t\u0011\t='Q\u0019C\u0001\u0005#\fA!\\1j]R\u0019aPa5\t\u0011\tU'Q\u001aa\u0001\u0005/\fA!\u0019:hgB!q\"!.\u0017\u0011!\u0011YN!2\u0005\u0002\tu\u0017aB*F\u0003N{ejU\u000b\u0003\u0005/D\u0001B!9\u0003F\u0012\u0005!1]\u0001\nO\u0016$8+Z1t_:$B!!\u0011\u0003f\"A!q\u001dBp\u0001\u0004\t\t%A\u0003n_:$\b\u000e\u0003\u0006\u0003l\n\u0015\u0017\u0013!C\u0001\u0005[\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TC\u0001BxU\r1\"\u0011\u0011\u0005\u000b\u0005g\u0014)-%A\u0005\u0002\t5\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S\u0007")
public class ChicagoCrimeApp {
    private final String weatherFile;
    private final String censusFile;
    private final String crimesFile;
    private final String datePattern;
    private final String dateTimeZone;
    private final transient SparkContext sc;
    private final transient SQLContext sqlContext;
    private final transient H2OContext h2oContext;

    public static String $lessinit$greater$default$5() {
        return ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$4();
    }

    public static int getSeason(int n) {
        return ChicagoCrimeApp$.MODULE$.getSeason(n);
    }

    public static String[] SEASONS() {
        return ChicagoCrimeApp$.MODULE$.SEASONS();
    }

    public static void main(String[] stringArray) {
        ChicagoCrimeApp$.MODULE$.main(stringArray);
    }

    public String datePattern() {
        return this.datePattern;
    }

    public String dateTimeZone() {
        return this.dateTimeZone;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public H2OContext h2oContext() {
        return this.h2oContext;
    }

    public Tuple2<GBMModel, DeepLearningModel> train(SchemaRDD weatherTable, SchemaRDD censusTable, SchemaRDD crimesTable) {
        SQLContext sqlc = this.sqlContext();
        H2OContext h2oc = this.h2oContext();
        this.sqlContext().registerRDDAsTable(weatherTable, "chicagoWeather");
        this.sqlContext().registerRDDAsTable(censusTable, "chicagoCensus");
        this.sqlContext().registerRDDAsTable(crimesTable, "chicagoCrime");
        SchemaRDD crimeWeather = this.sqlContext().sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |a.Year, a.Month, a.Day, a.WeekNum, a.HourOfDay, a.Weekend, a.Season, a.WeekDay,\n        |a.IUCR, a.Primary_Type, a.Location_Description, a.Community_Area, a.District,\n        |a.Arrest, a.Domestic, a.Beat, a.Ward, a.FBI_Code,\n        |b.minTemp, b.maxTemp, b.meanTemp,\n        |c.PERCENT_AGED_UNDER_18_OR_OVER_64, c.PER_CAPITA_INCOME, c.HARDSHIP_INDEX,\n        |c.PERCENT_OF_HOUSING_CROWDED, c.PERCENT_HOUSEHOLDS_BELOW_POVERTY,\n        |c.PERCENT_AGED_16__UNEMPLOYED, c.PERCENT_AGED_25__WITHOUT_HIGH_SCHOOL_DIPLOMA\n        |FROM chicagoCrime a\n        |JOIN chicagoWeather b\n        |ON a.Year = b.year AND a.Month = b.month AND a.Day = b.day\n        |JOIN chicagoCensus c\n        |ON a.Community_Area = c.Community_Area_Number")).stripMargin());
        H2OFrame crimeWeatherDF = this.h2oContext().createDataFrame(crimeWeather);
        String[] keys = (String[])((Object[])new String[]{"train.hex", "test.hex"});
        double[] ratios = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8, 0.2}), ClassTag$.MODULE$.Double());
        Frame[] frs = DemoUtils$.MODULE$.splitFrame(crimeWeatherDF, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])keys), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(ratios));
        Tuple2 tuple2 = new Tuple2((Object)frs[0], (Object)frs[1]);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Frame train = (Frame)tuple2._1();
            Frame test = (Frame)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)train, (Object)test);
            Frame train2 = (Frame)tuple23._1();
            Frame test2 = (Frame)tuple23._2();
            GBMModel gbmModel = this.GBMModel(this.h2oContext().createDataFrame(train2), this.h2oContext().createDataFrame(test2), this.h2oContext().symbolToString(Symbol$.MODULE$.apply("Arrest")), this.GBMModel$default$4(), this.GBMModel$default$5(), this.GBMModel$default$6(), h2oc);
            Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> tuple24 = this.binomialMetrics((Model)gbmModel, this.h2oContext().createDataFrame(train2), this.h2oContext().createDataFrame(test2));
            if (tuple24 != null) {
                Tuple2 tuple25;
                ModelMetricsBinomial trainMetricsGBM = (ModelMetricsBinomial)tuple24._1();
                ModelMetricsBinomial testMetricsGBM = (ModelMetricsBinomial)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)trainMetricsGBM, (Object)testMetricsGBM);
                ModelMetricsBinomial trainMetricsGBM2 = (ModelMetricsBinomial)tuple26._1();
                ModelMetricsBinomial testMetricsGBM2 = (ModelMetricsBinomial)tuple26._2();
                DeepLearningModel dlModel = this.DLModel(this.h2oContext().createDataFrame(train2), this.h2oContext().createDataFrame(test2), this.h2oContext().symbolToString(Symbol$.MODULE$.apply("Arrest")), this.DLModel$default$4(), this.DLModel$default$5(), this.DLModel$default$6(), this.DLModel$default$7(), this.DLModel$default$8(), h2oc);
                Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> tuple27 = this.binomialMetrics((Model)dlModel, this.h2oContext().createDataFrame(train2), this.h2oContext().createDataFrame(test2));
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    ModelMetricsBinomial trainMetricsDL = (ModelMetricsBinomial)tuple27._1();
                    ModelMetricsBinomial testMetricsDL = (ModelMetricsBinomial)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)trainMetricsDL, (Object)testMetricsDL);
                    ModelMetricsBinomial trainMetricsDL2 = (ModelMetricsBinomial)tuple29._1();
                    ModelMetricsBinomial testMetricsDL2 = (ModelMetricsBinomial)tuple29._2();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Model performance:\n          |  GBM:\n          |    train AUC = ", "\n          |    test  AUC = ", "\n          |  DL:\n          |    train AUC = ", "\n          |    test  AUC = ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMetricsGBM2.auc()._auc), BoxesRunTime.boxToDouble((double)testMetricsGBM2.auc()._auc), BoxesRunTime.boxToDouble((double)trainMetricsDL2.auc()._auc), BoxesRunTime.boxToDouble((double)testMetricsDL2.auc()._auc)})))).stripMargin());
                    return new Tuple2((Object)gbmModel, (Object)dlModel);
                }
                throw new MatchError(tuple27);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public void shutdown(SparkContext sc) {
        sc.stop();
        H2O.shutdown((int)0);
    }

    public GBMModel GBMModel(H2OFrame train, H2OFrame test, String response, int ntrees, int depth, GBMModel.GBMParameters.Family family, H2OContext h2oContext) {
        GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
        gbmParams._train = h2oContext.dataFrameToKey((Frame)train);
        gbmParams._valid = h2oContext.dataFrameToKey((Frame)test);
        gbmParams._response_column = response;
        gbmParams._ntrees = ntrees;
        gbmParams._max_depth = depth;
        gbmParams._distribution = family;
        GBM gbm = new GBM(gbmParams);
        GBMModel model = (GBMModel)gbm.trainModel().get();
        return model;
    }

    public int GBMModel$default$4() {
        return 10;
    }

    public int GBMModel$default$5() {
        return 6;
    }

    public GBMModel.GBMParameters.Family GBMModel$default$6() {
        return GBMModel.GBMParameters.Family.bernoulli;
    }

    public DeepLearningModel DLModel(H2OFrame train, H2OFrame test, String response, int epochs, double l1, double l2, DeepLearningModel.DeepLearningParameters.Activation activation, int[] hidden, H2OContext h2oContext) {
        DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
        dlParams._train = h2oContext.dataFrameToKey((Frame)train);
        dlParams._valid = h2oContext.dataFrameToKey((Frame)test);
        dlParams._response_column = response;
        dlParams._epochs = epochs;
        dlParams._l1 = l1;
        dlParams._l2 = l2;
        dlParams._activation = activation;
        dlParams._hidden = hidden;
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel model = (DeepLearningModel)dl.trainModel().get();
        return model;
    }

    public int DLModel$default$4() {
        return 10;
    }

    public double DLModel$default$5() {
        return 1.0E-4;
    }

    public double DLModel$default$6() {
        return 1.0E-4;
    }

    public DeepLearningModel.DeepLearningParameters.Activation DLModel$default$7() {
        return DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
    }

    public int[] DLModel$default$8() {
        return new int[]{200, 200};
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> binomialMetrics(Model<M, P, O> model, H2OFrame train, H2OFrame test) {
        model.score((Frame)train).delete();
        model.score((Frame)test).delete();
        return new Tuple2((Object)DemoUtils$.MODULE$.binomialMM(model, (Frame)train), (Object)DemoUtils$.MODULE$.binomialMM(model, (Frame)test));
    }

    public Tuple3<SchemaRDD, SchemaRDD, SchemaRDD> loadAll() {
        SQLContext sqlc = this.sqlContext();
        H2OContext h2oc = this.h2oContext();
        SchemaRDD weatherTable = this.h2oContext().asSchemaRDD(this.createWeatherTable(this.weatherFile), sqlc);
        this.sqlContext().registerRDDAsTable(weatherTable, "chicagoWeather");
        SchemaRDD censusTable = this.h2oContext().asSchemaRDD(this.createCensusTable(this.censusFile), sqlc);
        this.sqlContext().registerRDDAsTable(censusTable, "chicagoCensus");
        SchemaRDD crimeTable = this.h2oContext().asSchemaRDD(this.createCrimeTable(this.crimesFile), sqlc);
        this.sqlContext().registerRDDAsTable(crimeTable, "chicagoCrime");
        return new Tuple3((Object)weatherTable, (Object)censusTable, (Object)crimeTable);
    }

    private H2OFrame loadData(String datafile) {
        return new H2OFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URI[]{new URI(datafile)}));
    }

    /*
     * WARNING - void declaration
     */
    public H2OFrame createWeatherTable(String datafile) {
        void var2_2;
        H2OFrame table = this.loadData(datafile);
        table.remove(0).remove();
        table.update(null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public H2OFrame createCensusTable(String datafile) {
        void var2_2;
        H2OFrame table = this.loadData(datafile);
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])table.names()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String n) {
                return n.trim().replace(' ', '_').replace('+', '_');
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        table._names = colNames;
        table.update(null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public H2OFrame createCrimeTable(String datafile) {
        void var2_2;
        H2OFrame table = this.loadData(datafile);
        Vec dateCol = table.vec(2);
        table.add((Frame)new RefineDateColumn(this.datePattern(), this.dateTimeZone()).doIt(dateCol));
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])table.names()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String n) {
                return n.trim().replace(' ', '_');
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        table._names = colNames;
        table.remove(2).remove();
        table.update(null);
        return var2_2;
    }

    public float scoreEvent(Crime crime, Model<?, ?, ?> model, SchemaRDD censusTable, SQLContext sqlContext, H2OContext h2oContext) {
        SchemaRDD srdd;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ChicagoCrimeApp.class.getClassLoader());
        public final class Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Crime")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator1$1(ChicagoCrimeApp $outer) {
            }
        }
        SchemaRDD x$7 = srdd = sqlContext.createSchemaRDD(sqlContext.sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Crime[]{crime})), sqlContext.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Crime.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator1$1(this)));
        Option x$8 = Option$.MODULE$.apply((Object)sqlContext.DslSymbol(Symbol$.MODULE$.apply("Community_Area")).$eq$eq$eq((Expression)sqlContext.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("Community_Area_Number"))));
        JoinType x$9 = censusTable.join$default$2();
        H2OFrame row = h2oContext.createDataFrame(censusTable.join(x$7, x$9, x$8));
        Frame predictTable = model.score((Frame)row);
        double probOfArrest = predictTable.vec("true").at(0L);
        return (float)probOfArrest;
    }

    public ChicagoCrimeApp(String weatherFile, String censusFile, String crimesFile, String datePattern, String dateTimeZone, SparkContext sc, SQLContext sqlContext, H2OContext h2oContext) {
        this.weatherFile = weatherFile;
        this.censusFile = censusFile;
        this.crimesFile = crimesFile;
        this.datePattern = datePattern;
        this.dateTimeZone = dateTimeZone;
        this.sc = sc;
        this.sqlContext = sqlContext;
        this.h2oContext = h2oContext;
    }
}

