/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Model;
import hex.deeplearning.DeepLearningModel;
import hex.tree.gbm.GBMModel;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.examples.h2o.ChicagoCrimeApp;
import org.apache.spark.examples.h2o.ChicagoCrimeApp$;
import org.apache.spark.examples.h2o.Crime;
import org.apache.spark.examples.h2o.Crime$;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ChicagoCrimeAppSmall$ {
    public static final ChicagoCrimeAppSmall$ MODULE$;

    static {
        new ChicagoCrimeAppSmall$();
    }

    public void main(String[] args) {
        SparkContext sc = new SparkContext(DemoUtils$.MODULE$.configure("ChicagoCrimeTest"));
        DemoUtils$.MODULE$.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"examples/smalldata/chicagoAllWeather.csv", "examples/smalldata/chicagoCensus.csv", "examples/smalldata/chicagoCrimes10k.csv"}));
        SQLContext sqlContext = new SQLContext(sc);
        H2OContext h2oContext = new H2OContext(sc).start();
        ChicagoCrimeApp app = new ChicagoCrimeApp(SparkFiles$.MODULE$.get("chicagoAllWeather.csv"), SparkFiles$.MODULE$.get("chicagoCensus.csv"), SparkFiles$.MODULE$.get("chicagoCrimes10k.csv"), ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$4(), ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$5(), sc, sqlContext, h2oContext);
        Tuple3<SchemaRDD, SchemaRDD, SchemaRDD> tuple3 = app.loadAll();
        if (tuple3 != null) {
            SchemaRDD crimesTable;
            SchemaRDD censusTable;
            SchemaRDD crimesTable2;
            SchemaRDD censusTable2;
            SchemaRDD weatherTable = (SchemaRDD)tuple3._1();
            Tuple3 tuple32 = new Tuple3((Object)weatherTable, (Object)(censusTable2 = (SchemaRDD)tuple3._2()), (Object)(crimesTable2 = (SchemaRDD)tuple3._3()));
            Tuple3 tuple33 = tuple32;
            SchemaRDD weatherTable2 = (SchemaRDD)tuple33._1();
            Tuple2<GBMModel, DeepLearningModel> tuple2 = app.train(weatherTable2, censusTable = (SchemaRDD)tuple33._2(), crimesTable = (SchemaRDD)tuple33._3());
            if (tuple2 != null) {
                Tuple2 tuple22;
                GBMModel gbmModel = (GBMModel)tuple2._1();
                DeepLearningModel dlModel = (DeepLearningModel)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)gbmModel, (Object)dlModel);
                GBMModel gbmModel2 = (GBMModel)tuple23._1();
                DeepLearningModel dlModel2 = (DeepLearningModel)tuple23._2();
                Seq crimeExamples = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Crime[]{Crime$.MODULE$.apply("02/08/2015 11:43:58 PM", (short)1811, "NARCOTICS", "STREET", false, (short)422, (byte)4, (byte)7, (byte)46, (byte)18, Crime$.MODULE$.apply$default$11(), Crime$.MODULE$.apply$default$12(), Crime$.MODULE$.apply$default$13(), Crime$.MODULE$.apply$default$14(), Crime$.MODULE$.apply$default$15()), Crime$.MODULE$.apply("02/08/2015 11:00:39 PM", (short)1150, "DECEPTIVE PRACTICE", "RESIDENCE", false, (short)923, (byte)9, (byte)14, (byte)63, (byte)11, Crime$.MODULE$.apply$default$11(), Crime$.MODULE$.apply$default$12(), Crime$.MODULE$.apply$default$13(), Crime$.MODULE$.apply$default$14(), Crime$.MODULE$.apply$default$15())}));
                crimeExamples.foreach((Function1)new Serializable(sqlContext, h2oContext, app, censusTable, gbmModel2, dlModel2){
                    public static final long serialVersionUID = 0L;
                    private final SQLContext sqlContext$1;
                    private final H2OContext h2oContext$1;
                    private final ChicagoCrimeApp app$1;
                    private final SchemaRDD censusTable$1;
                    private final GBMModel gbmModel$1;
                    private final DeepLearningModel dlModel$1;

                    public final void apply(Crime crime) {
                        float arrestProbGBM = (float)100 * this.app$1.scoreEvent(crime, (Model<?, ?, ?>)this.gbmModel$1, this.censusTable$1, this.sqlContext$1, this.h2oContext$1);
                        float arrestProbDL = (float)100 * this.app$1.scoreEvent(crime, (Model<?, ?, ?>)this.dlModel$1, this.censusTable$1, this.sqlContext$1, this.h2oContext$1);
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |Crime: ", "\n            |  Probability of arrest best on DeepLearning: ", " %\n            |  Probability of arrest best on GBM: ", " %\n                                                                                                                                    |\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{crime, BoxesRunTime.boxToFloat((float)arrestProbDL), BoxesRunTime.boxToFloat((float)arrestProbGBM)})))).stripMargin());
                    }
                    {
                        this.sqlContext$1 = sqlContext$1;
                        this.h2oContext$1 = h2oContext$1;
                        this.app$1 = app$1;
                        this.censusTable$1 = censusTable$1;
                        this.gbmModel$1 = gbmModel$1;
                        this.dlModel$1 = dlModel$1;
                    }
                });
                app.shutdown(sc);
                return;
            }
            throw new MatchError(tuple2);
        }
        throw new MatchError(tuple3);
    }

    private ChicagoCrimeAppSmall$() {
        MODULE$ = this;
    }
}

