/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.splitframe.ShuffleSplitFrame;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.CitiBikeSharingDemo$;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.examples.h2o.GTimer;
import org.apache.spark.examples.h2o.NYWeather;
import org.apache.spark.examples.h2o.NYWeatherParse$;
import org.apache.spark.examples.h2o.TimeSplit;
import org.apache.spark.examples.h2o.TimeTransform;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import org.apache.spark.sql.catalyst.expressions.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.fvec.H2OFrame;

public final class CitiBikeSharingDemo$ {
    public static final CitiBikeSharingDemo$ MODULE$;
    private final String DIR_PREFIX;
    private final int TREES;

    static {
        new CitiBikeSharingDemo$();
    }

    public String DIR_PREFIX() {
        return this.DIR_PREFIX;
    }

    public int TREES() {
        return this.TREES;
    }

    public void main(String[] args) {
        SparkConf conf = DemoUtils$.MODULE$.configure("Sparkling Water Meetup: Predict occupation of citi bike station in NYC");
        SparkContext sc = new SparkContext(conf);
        H2OContext h2oContext = new H2OContext(sc).start();
        SQLContext sqlContext = new SQLContext(sc);
        GTimer gTimer = new GTimer();
        gTimer.start();
        URI[] dataFiles = (URI[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"2013-07.csv", "2013-08.csv", "2013-09.csv", "2013-10.csv", "2013-11.csv", "2013-12.csv", "2014-01.csv", "2014-02.csv", "2014-03.csv", "2014-04.csv", "2014-05.csv", "2014-06.csv", "2014-07.csv", "2014-08.csv"}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String f) {
                return new File(CitiBikeSharingDemo$.MODULE$.DIR_PREFIX(), f).toURI();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URI.class)));
        H2OFrame dataf = new H2OFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])dataFiles));
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])dataf.names()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String n) {
                return n.replace(' ', '_');
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        dataf._names = colNames;
        dataf.update(null);
        gTimer.stop("H2O: parse");
        gTimer.start();
        H2OFrame startTimeF = dataf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("starttime")}));
        dataf.add((Frame)new TimeSplit().doIt(startTimeF));
        dataf.update(null);
        Predef$.MODULE$.println((Object)dataf);
        gTimer.stop("H2O: split start time column");
        SchemaRDD brdd = h2oContext.asSchemaRDD(dataf, sqlContext);
        sqlContext.registerRDDAsTable(brdd, "brdd");
        SchemaRDD bph = sqlContext.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT Days, start_station_id, count(*) bikes\n        |FROM brdd\n        |GROUP BY Days, start_station_id ")).stripMargin());
        Predef$.MODULE$.println((Object)Predef$.MODULE$.refArrayOps((Object[])bph.take(10)).mkString("\n"));
        gTimer.start();
        H2OFrame bphf = h2oContext.createDataFrame(bph);
        gTimer.stop("Spark: do SQL query").start();
        H2OFrame daysVec = bphf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("Days")}));
        Frame finalTable = bphf.add((Frame)new TimeTransform().doIt(daysVec));
        gTimer.stop("H2O: time transformation");
        Predef$.MODULE$.println((Object)finalTable);
        this.buildModel(h2oContext.createDataFrame(finalTable), gTimer, h2oContext);
        RDD weatherData = sc.textFile(new StringBuilder().append((Object)this.DIR_PREFIX()).append((Object)"31081_New_York_City__Hourly_2013.csv").toString(), sc.textFile$default$2());
        RDD weatherRdd = weatherData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final NYWeather apply(String[] row) {
                return NYWeatherParse$.MODULE$.apply(row);
            }
        }, ClassTag$.MODULE$.apply(NYWeather.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(NYWeather x$2) {
                return !x$2.isWrongRow();
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(NYWeather x$3) {
                Option<Object> option = x$3.HourLocal();
                Some some = new Some((Object)BoxesRunTime.boxToInteger((int)12));
                return !(option != null ? !option.equals((Object)some) : some != null);
            }
        });
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_CitiBikeSharingDemo$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.NYWeather")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_CitiBikeSharingDemo$$typecreator1$1() {
            }
        }
        sqlContext.registerRDDAsTable(sqlContext.createSchemaRDD(weatherRdd, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_CitiBikeSharingDemo$$typecreator1$1())), "weatherRdd");
        sqlContext.registerRDDAsTable(h2oContext.asSchemaRDD(h2oContext.createDataFrame(finalTable), sqlContext), "bikesRdd");
        SchemaRDD bikesWeatherRdd = sqlContext.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT b.Days, b.start_station_id, b.bikes, b.Month, b.DayOfWeek,\n        |w.DewPoint, w.HumidityFraction, w.Prcp1Hour, w.Temperature, w.WeatherCode1\n        | FROM bikesRdd b\n        | JOIN weatherRdd w\n        | ON b.Days = w.Days\n        |\n      ")).stripMargin());
        this.buildModel(h2oContext.createDataFrame(bikesWeatherRdd), gTimer, h2oContext);
        Predef$.MODULE$.println((Object)gTimer);
        sc.stop();
    }

    public double r2(GBMModel model, Frame fr) {
        return ((ModelMetricsSupervised)ModelMetrics.getFromDKV((Model)model, (Frame)fr)).r2();
    }

    public GBMModel buildModel(H2OFrame df, GTimer gTimer, H2OContext h2oContext) {
        gTimer.start();
        Key[] keys = (Key[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"train.hex", "test.hex", "hold.hex"}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Key<? extends Keyed<? extends Keyed<?>>> apply(String x$4) {
                return Key.make((String)x$4);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Key.class)));
        double[] ratios = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.6, 0.3, 0.1}), ClassTag$.MODULE$.Double());
        Frame[] frs = ShuffleSplitFrame.shuffleSplitFrame((Frame)df, (Key[])keys, (double[])ratios, (long)1234567689L);
        Frame train = frs[0];
        Frame test = frs[1];
        Frame hold = frs[2];
        gTimer.stop("H2O: split frame");
        GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
        gbmParams._train = h2oContext.dataFrameToKey(train);
        gbmParams._valid = h2oContext.dataFrameToKey(test);
        gbmParams._response_column = h2oContext.symbolToString(Symbol$.MODULE$.apply("bikes"));
        gbmParams._ntrees = this.TREES();
        gbmParams._max_depth = 6;
        gTimer.start();
        GBM gbm = new GBM(gbmParams);
        GBMModel gbmModel = (GBMModel)gbm.trainModel().get();
        gTimer.stop("H2O: gbm model training");
        gbmModel.score(train).remove();
        gbmModel.score(test).remove();
        gbmModel.score(hold).remove();
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |r2 on train: ", "\n          |r2 on test:  ", "\n          |r2 on hold:  ", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.r2(gbmModel, train)), BoxesRunTime.boxToDouble((double)this.r2(gbmModel, test)), BoxesRunTime.boxToDouble((double)this.r2(gbmModel, hold))})))).stripMargin());
        train.delete();
        test.delete();
        hold.delete();
        return gbmModel;
    }

    public void basicStats(SchemaRDD brdd, SQLContext sqlContext) {
        brdd.first();
        brdd.count();
        sqlContext.registerRDDAsTable(brdd, "brdd");
        SchemaRDD tGBduration = sqlContext.sql("SELECT bikeid, SUM(tripduration) FROM brdd GROUP BY bikeid");
        Row[] bottom10 = (Row[])tGBduration.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row r) {
                return r.getLong(1);
            }
        }, tGBduration.sortBy$default$2(), tGBduration.sortBy$default$3(), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long()).take(10);
        Row minDurationBikeId = (Row)tGBduration.min(package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row r) {
                return r.getLong(1);
            }
        }, (Ordering)Ordering.Long$.MODULE$));
        Row row = bottom10[0];
        Row row2 = minDurationBikeId;
        Predef$.MODULE$.assert(!(row != null ? !row.equals(row2) : row2 != null));
        Row maxDurationBikeId = (Row)tGBduration.min(package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row r) {
                return -r.getLong(1);
            }
        }, (Ordering)Ordering.Long$.MODULE$));
    }

    public void withTimer(GTimer timer, String round, Function0<BoxedUnit> b) {
        timer.start();
        try {
            b.apply$mcV$sp();
            return;
        }
        finally {
            timer.stop(round);
        }
    }

    private CitiBikeSharingDemo$() {
        MODULE$ = this;
        this.DIR_PREFIX = "/Users/michal/Devel/projects/h2o/repos/h2o2/bigdata/laptop/citibike-nyc/";
        this.TREES = 1;
    }
}

