/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningParameters;
import java.io.File;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.examples.h2o.Airlines;
import org.apache.spark.examples.h2o.AirlinesWithWeatherDemo$;
import org.apache.spark.examples.h2o.Weather;
import org.apache.spark.examples.h2o.WeatherParse$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.package;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import water.app.SparkContextSupport;
import water.fvec.Frame;
import water.fvec.H2OFrame;

public final class AirlinesWithWeatherDemo$
implements SparkContextSupport {
    public static final AirlinesWithWeatherDemo$ MODULE$;

    static {
        new AirlinesWithWeatherDemo$();
    }

    public SparkConf configure(String appName) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling Water: Join of Airlines with Weather Data");
        SparkContext sc = new SparkContext(conf);
        H2OContext h2oContext = new H2OContext(sc).start();
        this.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.absPath("examples/smalldata/Chicago_Ohare_International_Airport.csv"), this.absPath("examples/smalldata/allyears2k_headers.csv.gz")}));
        RDD wrawdata = sc.textFile(SparkFiles$.MODULE$.get("Chicago_Ohare_International_Airport.csv"), 3).cache();
        RDD weatherTable = wrawdata.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Weather apply(String[] row) {
                return WeatherParse$.MODULE$.apply(row);
            }
        }, ClassTag$.MODULE$.apply(Weather.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Weather x$2) {
                return !x$2.isWrongRow();
            }
        });
        H2OFrame airlinesData = new H2OFrame(new File(SparkFiles$.MODULE$.get("allyears2k_headers.csv.gz")));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator1$1() {
            }
        }
        RDD airlinesTable = h2oContext.asRDD(airlinesData, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator1$1()), ClassTag$.MODULE$.apply(Airlines.class));
        RDD flightsToORD = airlinesTable.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Airlines f) {
                Option<String> option = f.Dest();
                Some some = new Some((Object)"ORD");
                return !(option != null ? !option.equals((Object)some) : some != null);
            }
        });
        flightsToORD.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nFlights to ORD: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)flightsToORD.count())})));
        SQLContext sqlContext = new SQLContext(sc);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator2$1() {
            }
        }
        sqlContext.implicits().rddToDataFrameHolder(flightsToORD, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator2$1())).toDF().registerTempTable("FlightsToORD");
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Weather")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator3$1() {
            }
        }
        sqlContext.implicits().rddToDataFrameHolder(weatherTable, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator3$1())).toDF().registerTempTable("WeatherORD");
        DataFrame bigTable = sqlContext.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |f.Year,f.Month,f.DayofMonth,\n        |f.CRSDepTime,f.CRSArrTime,f.CRSElapsedTime,\n        |f.UniqueCarrier,f.FlightNum,f.TailNum,\n        |f.Origin,f.Distance,\n        |w.TmaxF,w.TminF,w.TmeanF,w.PrcpIn,w.SnowIn,w.CDD,w.HDD,w.GDD,\n        |f.ArrDelay\n        |FROM FlightsToORD f\n        |JOIN WeatherORD w\n        |ON f.Year=w.Year AND f.Month=w.Month AND f.DayofMonth=w.Day\n        |WHERE f.ArrDelay IS NOT NULL")).stripMargin());
        H2OFrame train = h2oContext.asH2OFrame(bigTable.repartition(4));
        DeepLearningParameters dlParams = new DeepLearningParameters();
        dlParams._train = h2oContext.toH2OFrameKey((Frame)train);
        dlParams._response_column = h2oContext.symbolToString(Symbol$.MODULE$.apply("ArrDelay"));
        dlParams._epochs = 5.0;
        dlParams._activation = DeepLearningParameters.Activation.RectifierWithDropout;
        dlParams._hidden = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 100}), ClassTag$.MODULE$.Int());
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel dlModel = (DeepLearningModel)dl.trainModel().get();
        H2OFrame predictionH2OFrame = h2oContext.asH2OFrame(dlModel.score((Frame)h2oContext.asH2OFrame(bigTable))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("predict")}));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.h2o")), $m.staticModule("org.apache.spark.h2o.package")), $m.staticClass("org.apache.spark.h2o.DoubleHolder"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator4$1() {
            }
        }
        double[] predictionsFromModel = (double[])Predef$.MODULE$.refArrayOps((Object[])h2oContext.asRDD(predictionH2OFrame, ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo$$typecreator4$1()), ClassTag$.MODULE$.apply(package.DoubleHolder.class)).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(package.DoubleHolder x$3) {
                return BoxesRunTime.unboxToDouble((Object)x$3.result().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Double.NaN;
                    }
                }));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.doubleArrayOps(predictionsFromModel).mkString("\n===> Model predictions: ", ", ", ", ...\n"));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# R script for residual plot\n        |library(h2o)\n        |h = h2o.init()\n        |\n        |pred = h2o.getFrame(h, \"", "\")\n        |act = h2o.getFrame (h, \"", "\")\n        |\n        |predDelay = pred$predict\n        |actDelay = act$ArrDelay\n        |\n        |nrow(actDelay) == nrow(predDelay)\n        |\n        |residuals = predDelay - actDelay\n        |\n        |compare = cbind (as.data.frame(actDelay$ArrDelay), as.data.frame(residuals$predict))\n        |nrow(compare)\n        |plot( compare[,1:2] )\n        |\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{predictionH2OFrame._key, h2oContext.asH2OFrame((DataFrame)bigTable)._key})))).stripMargin());
        sc.stop();
    }

    private AirlinesWithWeatherDemo$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
    }
}

