/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.FrameSplitter;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningParameters;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.examples.h2o.Airlines;
import org.apache.spark.examples.h2o.AirlinesWithWeatherDemo2$;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.examples.h2o.Weather;
import org.apache.spark.examples.h2o.WeatherParse$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import water.H2O;
import water.Key;
import water.app.SparkContextSupport;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.fvec.Vec;

public final class AirlinesWithWeatherDemo2$
implements SparkContextSupport {
    public static final AirlinesWithWeatherDemo2$ MODULE$;

    static {
        new AirlinesWithWeatherDemo2$();
    }

    public SparkConf configure(String appName) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling Water Meetup: Use Airlines and Weather Data for delay prediction");
        SparkContext sc = new SparkContext(conf);
        H2OContext h2oContext = new H2OContext(sc).start();
        this.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.absPath("examples/smalldata/Chicago_Ohare_International_Airport.csv"), this.absPath("examples/smalldata/year2005.csv.gz")}));
        RDD wrawdata = sc.textFile(SparkFiles$.MODULE$.get("Chicago_Ohare_International_Airport.csv"), 3).cache();
        RDD weatherTable = wrawdata.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Weather apply(String[] row) {
                return WeatherParse$.MODULE$.apply(row);
            }
        }, ClassTag$.MODULE$.apply(Weather.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Weather x$2) {
                return !x$2.isWrongRow();
            }
        });
        H2OFrame airlinesData = new H2OFrame(new File(SparkFiles$.MODULE$.get("year2005.csv.gz")));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator1$1() {
            }
        }
        RDD airlinesTable = h2oContext.asRDD(airlinesData, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator1$1()), ClassTag$.MODULE$.apply(Airlines.class));
        RDD flightsToORD = airlinesTable.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Airlines f) {
                Option<String> option = f.Dest();
                Some some = new Some((Object)"ORD");
                return !(option != null ? !option.equals((Object)some) : some != null);
            }
        });
        flightsToORD.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nFlights to ORD: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)flightsToORD.count())})));
        SQLContext sqlContext = new SQLContext(sc);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Airlines")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator2$1() {
            }
        }
        sqlContext.implicits().rddToDataFrameHolder(flightsToORD, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator2$1())).toDF().registerTempTable("FlightsToORD");
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Weather")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator3$1() {
            }
        }
        sqlContext.implicits().rddToDataFrameHolder(weatherTable, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_h2o_AirlinesWithWeatherDemo2$$typecreator3$1())).toDF().registerTempTable("WeatherORD");
        DataFrame joinedTable = sqlContext.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |f.Year,f.Month,f.DayofMonth,\n        |f.CRSDepTime,f.CRSArrTime,f.CRSElapsedTime,\n        |f.UniqueCarrier,f.FlightNum,f.TailNum,\n        |f.Origin,f.Distance,\n        |w.TmaxF,w.TminF,w.TmeanF,w.PrcpIn,w.SnowIn,w.CDD,w.HDD,w.GDD,\n        |f.ArrDelay\n        |FROM FlightsToORD f\n        |JOIN WeatherORD w\n        |ON f.Year=w.Year AND f.Month=w.Month AND f.DayofMonth=w.Day")).stripMargin());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nResult of query: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)joinedTable.count())})));
        H2OFrame joinedH2OFrame = h2oContext.asH2OFrame(joinedTable);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1)new Serializable(joinedH2OFrame){
            public static final long serialVersionUID = 0L;
            private final H2OFrame joinedH2OFrame$1;

            public final Vec apply(int i) {
                return this.joinedH2OFrame$1.replace(i, this.joinedH2OFrame$1.vec(i).toCategoricalVec());
            }
            {
                this.joinedH2OFrame$1 = joinedH2OFrame$1;
            }
        });
        FrameSplitter sf = new FrameSplitter((Frame)joinedH2OFrame, new double[]{0.7, 0.2}, (Key[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"train", "valid", "test"}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Key<Frame> apply(String x$3) {
                return Key.make((String)x$3);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Key.class))), null);
        H2O.submitTask((H2O.H2OCountedCompleter)sf);
        Frame[] splits = sf.getResult();
        Frame trainTable = splits[0];
        Frame validTable = splits[1];
        Frame testTable = splits[2];
        DeepLearningParameters dlParams = new DeepLearningParameters();
        dlParams._train = h2oContext.toH2OFrameKey(trainTable);
        dlParams._response_column = h2oContext.symbolToString(Symbol$.MODULE$.apply("ArrDelay"));
        dlParams._valid = h2oContext.toH2OFrameKey(validTable);
        dlParams._epochs = 5.0;
        dlParams._activation = DeepLearningParameters.Activation.RectifierWithDropout;
        dlParams._hidden = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 100}), ClassTag$.MODULE$.Int());
        dlParams._reproducible = true;
        dlParams._force_load_balance = false;
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel dlModel = (DeepLearningModel)dl.trainModel().get();
        H2OFrame dlPredictTable = h2oContext.asH2OFrame(dlModel.score(testTable)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("predict")}));
        Object[] predictionsFromDlModel = (Object[])Predef$.MODULE$.refArrayOps((Object[])h2oContext.asDataFrame(dlPredictTable, sqlContext).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                return row.isNullAt(0) ? BoxesRunTime.boxToDouble((double)Double.NaN) : row.apply(0);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)predictionsFromDlModel.length));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.genericArrayOps((Object)predictionsFromDlModel).mkString("\n===> Model predictions: ", ", ", ", ...\n"));
        Predef$.MODULE$.printf(DemoUtils$.MODULE$.residualPlotRCode((Frame)dlPredictTable, h2oContext.symbolToString(Symbol$.MODULE$.apply("predict")), testTable, h2oContext.symbolToString(Symbol$.MODULE$.apply("ArrDelay")), DemoUtils$.MODULE$.residualPlotRCode$default$5()), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
        gbmParams._train = h2oContext.toH2OFrameKey(trainTable);
        gbmParams._response_column = h2oContext.symbolToString(Symbol$.MODULE$.apply("ArrDelay"));
        gbmParams._valid = h2oContext.toH2OFrameKey(validTable);
        gbmParams._ntrees = 100;
        GBM gbm = new GBM(gbmParams);
        GBMModel gbmModel = (GBMModel)gbm.trainModel().get();
        H2OFrame gbmPredictTable = h2oContext.asH2OFrame(gbmModel.score(testTable)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("predict")}));
        Predef$.MODULE$.printf(DemoUtils$.MODULE$.residualPlotRCode((Frame)gbmPredictTable, h2oContext.symbolToString(Symbol$.MODULE$.apply("predict")), testTable, h2oContext.symbolToString(Symbol$.MODULE$.apply("ArrDelay")), DemoUtils$.MODULE$.residualPlotRCode$default$5()), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        sc.stop();
    }

    private AirlinesWithWeatherDemo2$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
    }
}

