/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Distribution;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningParameters;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.ChicagoCrimeApp$;
import org.apache.spark.examples.h2o.Crime;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.examples.h2o.RefineDateColumn;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import water.app.ModelMetricsSupport;
import water.app.SparklingWaterApp;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.fvec.Vec;

@ScalaSignature(bytes="\u0006\u0001\tMh\u0001B\u0001\u0003\u00015\u0011qb\u00115jG\u0006<wn\u0011:j[\u0016\f\u0005\u000f\u001d\u0006\u0003\u0007\u0011\t1\u0001\u001b\u001ap\u0015\t)a!\u0001\u0005fq\u0006l\u0007\u000f\\3t\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!B\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t1!\u00199q\u0015\u0005I\u0012!B<bi\u0016\u0014\u0018BA\u000e\u0017\u0005E\u0019\u0006/\u0019:lY&twmV1uKJ\f\u0005\u000f\u001d\t\u0003+uI!A\b\f\u0003'5{G-\u001a7NKR\u0014\u0018nY:TkB\u0004xN\u001d;\t\u0011\u0001\u0002!\u0011!Q\u0001\n\u0005\n1b^3bi\",'OR5mKB\u0011!%\n\b\u0003\u001f\rJ!\u0001\n\t\u0002\rA\u0013X\rZ3g\u0013\t1sE\u0001\u0004TiJLgn\u001a\u0006\u0003IAA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I!I\u0001\u000bG\u0016t7/^:GS2,\u0007\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u0015\r\u0014\u0018.\\3t\r&dW\r\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003-!\u0017\r^3QCR$XM\u001d8\u0016\u0003\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!I\u0001\rI\u0006$X\rU1ui\u0016\u0014h\u000e\t\u0005\te\u0001\u0011)\u0019!C\u0001]\u0005aA-\u0019;f)&lWMW8oK\"AA\u0007\u0001B\u0001B\u0003%\u0011%A\u0007eCR,G+[7f5>tW\r\t\u0005\tm\u0001\u0011)\u0019!C!o\u0005\u00111oY\u000b\u0002qA\u0011\u0011HO\u0007\u0002\r%\u00111H\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\t{\u0001\u0011\t\u0011)A\u0005q\u0005\u00191o\u0019\u0011)\u0005qz\u0004CA\bA\u0013\t\t\u0005CA\u0005ue\u0006t7/[3oi\"A1\t\u0001BC\u0002\u0013\u0005C)\u0001\u0006tc2\u001cuN\u001c;fqR,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u001a\t1a]9m\u0013\tQuI\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!R\u0001\fgFd7i\u001c8uKb$\b\u0005\u000b\u0002L\u007f!Aq\n\u0001BC\u0002\u0013\u0005\u0003+\u0001\u0006ie=\u001cuN\u001c;fqR,\u0012!\u0015\t\u0003%Rk\u0011a\u0015\u0006\u0003\u0007\u0019I!!V*\u0003\u0015!\u0013tjQ8oi\u0016DH\u000f\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003R\u0003-A'g\\\"p]R,\u0007\u0010\u001e\u0011)\u0005Y{\u0004\"\u0002.\u0001\t\u0003Y\u0016A\u0002\u001fj]&$h\b\u0006\u0004]E\u000e$WM\u001a\u000b\u0005;~\u0003\u0017\r\u0005\u0002_\u00015\t!\u0001C\u000373\u0002\u0007\u0001\bC\u0003D3\u0002\u0007Q\tC\u0003P3\u0002\u0007\u0011\u000bC\u0003!3\u0002\u0007\u0011\u0005C\u0003*3\u0002\u0007\u0011\u0005C\u0003,3\u0002\u0007\u0011\u0005C\u0004.3B\u0005\t\u0019A\u0011\t\u000fIJ\u0006\u0013!a\u0001C!)\u0001\u000e\u0001C\u0001S\u0006)AO]1j]R1!.`A\u0003\u0003\u0013\u0001BaD6no&\u0011A\u000e\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00059,X\"A8\u000b\u0005A\f\u0018aA4c[*\u0011!o]\u0001\u0005iJ,WMC\u0001u\u0003\rAW\r_\u0005\u0003m>\u0014\u0001b\u0012\"N\u001b>$W\r\u001c\t\u0003qnl\u0011!\u001f\u0006\u0003uN\fA\u0002Z3fa2,\u0017M\u001d8j]\u001eL!\u0001`=\u0003#\u0011+W\r\u001d'fCJt\u0017N\\4N_\u0012,G\u000eC\u0003\u007fO\u0002\u0007q0\u0001\u0007xK\u0006$\b.\u001a:UC\ndW\rE\u0002G\u0003\u0003I1!a\u0001H\u0005%!\u0015\r^1Ge\u0006lW\r\u0003\u0004\u0002\b\u001d\u0004\ra`\u0001\fG\u0016t7/^:UC\ndW\r\u0003\u0004\u0002\f\u001d\u0004\ra`\u0001\fGJLW.Z:UC\ndW\rC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u0011\u001d\u0013U*T8eK2$b\"a\u0005\u0002\u0018\u0005u\u0012\u0011IA#\u0003\u001f\n\u0019\u0006F\u0002n\u0003+AaaTA\u0007\u0001\b\t\u0006b\u00025\u0002\u000e\u0001\u0007\u0011\u0011\u0004\t\u0005\u00037\t9D\u0004\u0003\u0002\u001e\u0005Mb\u0002BA\u0010\u0003cqA!!\t\u000209!\u00111EA\u0017\u001d\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\r1\u0011bAA\u001b'\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u0011\u0001\u0002\u0013\u001aP\rJ\fW.\u001a\u0006\u0004\u0003k\u0019\u0006\u0002CA \u0003\u001b\u0001\r!!\u0007\u0002\tQ,7\u000f\u001e\u0005\b\u0003\u0007\ni\u00011\u0001\"\u0003!\u0011Xm\u001d9p]N,\u0007BCA$\u0003\u001b\u0001\n\u00111\u0001\u0002J\u00051a\u000e\u001e:fKN\u00042aDA&\u0013\r\ti\u0005\u0005\u0002\u0004\u0013:$\bBCA)\u0003\u001b\u0001\n\u00111\u0001\u0002J\u0005)A-\u001a9uQ\"Q\u0011QKA\u0007!\u0003\u0005\r!a\u0016\u0002\r\u0019\fW.\u001b7z!\u0011\tI&a\u0019\u000f\t\u0005m\u0013q\f\b\u0005\u0003K\ti&C\u0001u\u0013\r\t\tg]\u0001\r\t&\u001cHO]5ckRLwN\\\u0005\u0005\u0003K\n9G\u0001\u0004GC6LG.\u001f\u0006\u0004\u0003C\u001a\bbBA6\u0001\u0011\u0005\u0011QN\u0001\b\t2ku\u000eZ3m)I\ty'a\u001d\u0002v\u0005]\u0014\u0011PA?\u0003\u000f\u000bY)!)\u0015\u0007]\f\t\b\u0003\u0004P\u0003S\u0002\u001d!\u0015\u0005\bQ\u0006%\u0004\u0019AA\r\u0011!\ty$!\u001bA\u0002\u0005e\u0001bBA\"\u0003S\u0002\r!\t\u0005\u000b\u0003w\nI\u0007%AA\u0002\u0005%\u0013AB3q_\u000eD7\u000f\u0003\u0006\u0002\u0000\u0005%\u0004\u0013!a\u0001\u0003\u0003\u000b!\u0001\\\u0019\u0011\u0007=\t\u0019)C\u0002\u0002\u0006B\u0011a\u0001R8vE2,\u0007BCAE\u0003S\u0002\n\u00111\u0001\u0002\u0002\u0006\u0011AN\r\u0005\u000b\u0003\u001b\u000bI\u0007%AA\u0002\u0005=\u0015AC1di&4\u0018\r^5p]B!\u0011\u0011SAN\u001d\u0011\t\u0019*a&\u000f\t\u0005m\u0013QS\u0005\u0003uNL1!!'z\u0003Y!U-\u001a9MK\u0006\u0014h.\u001b8h!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0002BAO\u0003?\u0013!\"Q2uSZ\fG/[8o\u0015\r\tI*\u001f\u0005\u000b\u0003G\u000bI\u0007%AA\u0002\u0005\u0015\u0016A\u00025jI\u0012,g\u000eE\u0003\u0010\u0003O\u000bI%C\u0002\u0002*B\u0011Q!\u0011:sCfDq!!,\u0001\t\u0003\ty+A\bcS:|W.[1m\u001b\u0016$(/[2t+!\t\t,a3\u0002Z\u0006=H\u0003CAZ\u0003{\u000bY0!@\u0011\r=Y\u0017QWA[!\u0011\t9,!/\u000e\u0003ML1!a/t\u0005Qiu\u000eZ3m\u001b\u0016$(/[2t\u0005&tw.\\5bY\"A\u0011qXAV\u0001\u0004\t\t-A\u0003n_\u0012,G\u000e\u0005\u0006\u00028\u0006\r\u0017qYAl\u0003[L1!!2t\u0005\u0015iu\u000eZ3m!\u0011\tI-a3\r\u0001\u0011A\u0011QZAV\u0005\u0004\tyMA\u0001N#\u0011\t\t.!1\u0011\u0007=\t\u0019.C\u0002\u0002VB\u0011qAT8uQ&tw\r\u0005\u0003\u0002J\u0006eG\u0001CAn\u0003W\u0013\r!!8\u0003\u0003A\u000bB!!5\u0002`B!\u0011\u0011]At\u001d\u0011\tY&a9\n\u0007\u0005\u00158/A\u0003N_\u0012,G.\u0003\u0003\u0002j\u0006-(A\u0003)be\u0006lW\r^3sg*\u0019\u0011Q]:\u0011\t\u0005%\u0017q\u001e\u0003\t\u0003c\fYK1\u0001\u0002t\n\tq*\u0005\u0003\u0002R\u0006U\b\u0003BAq\u0003oLA!!?\u0002l\n1q*\u001e;qkRDq\u0001[AV\u0001\u0004\tI\u0002\u0003\u0005\u0002@\u0005-\u0006\u0019AA\r\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007\tq\u0001\\8bI\u0006cG\u000e\u0006\u0002\u0003\u0006A1qBa\u0002\u0000\u007f~L1A!\u0003\u0011\u0005\u0019!V\u000f\u001d7fg!9!Q\u0002\u0001\u0005\n\t=\u0011\u0001\u00037pC\u0012$\u0015\r^1\u0015\t\u0005e!\u0011\u0003\u0005\b\u0005'\u0011Y\u00011\u0001\"\u0003!!\u0017\r^1gS2,\u0007b\u0002B\f\u0001\u0011\u0005!\u0011D\u0001\u0013GJ,\u0017\r^3XK\u0006$\b.\u001a:UC\ndW\r\u0006\u0003\u0002\u001a\tm\u0001b\u0002B\n\u0005+\u0001\r!\t\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0003E\u0019'/Z1uK\u000e+gn];t)\u0006\u0014G.\u001a\u000b\u0005\u00033\u0011\u0019\u0003C\u0004\u0003\u0014\tu\u0001\u0019A\u0011\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*\u0005\u00012M]3bi\u0016\u001c%/[7f)\u0006\u0014G.\u001a\u000b\u0005\u00033\u0011Y\u0003C\u0004\u0003\u0014\t\u0015\u0002\u0019A\u0011\t\u000f\t=\u0002\u0001\"\u0001\u00032\u0005Q1oY8sK\u00163XM\u001c;\u0015\u0011\tM\"q\bB%\u0005S\"bA!\u000e\u0003<\tu\u0002cA\b\u00038%\u0019!\u0011\b\t\u0003\u000b\u0019cw.\u0019;\t\r\r\u0013i\u0003q\u0001F\u0011\u0019y%Q\u0006a\u0002#\"A!\u0011\tB\u0017\u0001\u0004\u0011\u0019%A\u0003de&lW\rE\u0002_\u0005\u000bJ1Aa\u0012\u0003\u0005\u0015\u0019%/[7f\u0011!\tyL!\fA\u0002\t-\u0003\u0007\u0003B'\u0005#\u0012yF!\u001a\u0011\u0015\u0005]\u00161\u0019B(\u0005;\u0012\u0019\u0007\u0005\u0003\u0002J\nEC\u0001\u0004B*\u0005\u0013\n\t\u0011!A\u0003\u0002\tU#aA0%cE!\u0011\u0011\u001bB,!\ry!\u0011L\u0005\u0004\u00057\u0002\"aA!osB!\u0011\u0011\u001aB0\t1\u0011\tG!\u0013\u0002\u0002\u0003\u0005)\u0011\u0001B+\u0005\ryFE\r\t\u0005\u0003\u0013\u0014)\u0007\u0002\u0007\u0003h\t%\u0013\u0011!A\u0001\u0006\u0003\u0011)FA\u0002`IMBq!a\u0002\u0003.\u0001\u0007q\u0010C\u0005\u0003n\u0001\t\n\u0011\"\u0001\u0003p\u0005\u0011rIQ'N_\u0012,G\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\tH\u000b\u0003\u0002J\tM4F\u0001B;!\u0011\u00119H!!\u000e\u0005\te$\u0002\u0002B>\u0005{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}\u0004#\u0001\u0006b]:|G/\u0019;j_:LAAa!\u0003z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\u001d\u0005!%A\u0005\u0002\t=\u0014AE$C\u001b6{G-\u001a7%I\u00164\u0017-\u001e7uIUB\u0011Ba#\u0001#\u0003%\tA!$\u0002%\u001d\u0013U*T8eK2$C-\u001a4bk2$HEN\u000b\u0003\u0005\u001fSC!a\u0016\u0003t!I!1\u0013\u0001\u0012\u0002\u0013\u0005!qN\u0001\u0012\t2ku\u000eZ3mI\u0011,g-Y;mi\u0012\"\u0004\"\u0003BL\u0001E\u0005I\u0011\u0001BM\u0003E!E*T8eK2$C-\u001a4bk2$H%N\u000b\u0003\u00057SC!!!\u0003t!I!q\u0014\u0001\u0012\u0002\u0013\u0005!\u0011T\u0001\u0012\t2ku\u000eZ3mI\u0011,g-Y;mi\u00122\u0004\"\u0003BR\u0001E\u0005I\u0011\u0001BS\u0003E!E*T8eK2$C-\u001a4bk2$HeN\u000b\u0003\u0005OSC!a$\u0003t!I!1\u0016\u0001\u0012\u0002\u0013\u0005!QV\u0001\u0012\t2ku\u000eZ3mI\u0011,g-Y;mi\u0012BTC\u0001BXU\u0011\t)Ka\u001d\b\u000f\tM&\u0001#\u0001\u00036\u0006y1\t[5dC\u001e|7I]5nK\u0006\u0003\b\u000fE\u0002_\u0005o3a!\u0001\u0002\t\u0002\te6#\u0002B\\\u001d\tm\u0006cA\u000b\u0003>&\u0019!q\u0018\f\u0003'M\u0003\u0018M]6D_:$X\r\u001f;TkB\u0004xN\u001d;\t\u000fi\u00139\f\"\u0001\u0003DR\u0011!Q\u0017\u0005\t\u0005\u000f\u00149\f\"\u0001\u0003J\u0006!Q.Y5o)\u0011\u0011YM!5\u0011\u0007=\u0011i-C\u0002\u0003PB\u0011A!\u00168ji\"A!1\u001bBc\u0001\u0004\u0011).\u0001\u0003be\u001e\u001c\b\u0003B\b\u0002(\u0006B\u0001B!7\u00038\u0012\u0005!1\\\u0001\b'\u0016\u000b5k\u0014(T+\t\u0011)\u000e\u0003\u0005\u0003`\n]F\u0011\u0001Bq\u0003%9W\r^*fCN|g\u000e\u0006\u0003\u0002J\t\r\b\u0002\u0003Bs\u0005;\u0004\r!!\u0013\u0002\u000b5|g\u000e\u001e5\t\u0015\t%(qWI\u0001\n\u0003\u0011Y/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005[T3!\tB:\u0011)\u0011\tPa.\u0012\u0002\u0013\u0005!1^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b")
public class ChicagoCrimeApp
implements SparklingWaterApp,
ModelMetricsSupport {
    private final String weatherFile;
    private final String censusFile;
    private final String crimesFile;
    private final String datePattern;
    private final String dateTimeZone;
    private final transient SparkContext sc;
    private final transient SQLContext sqlContext;
    private final transient H2OContext h2oContext;

    public static String configure$default$1() {
        return ChicagoCrimeApp$.MODULE$.configure$default$1();
    }

    public static <M> M loadSparkModel(URI uRI) {
        return ChicagoCrimeApp$.MODULE$.loadSparkModel(uRI);
    }

    public static void exportSparkModel(Object object, URI uRI) {
        ChicagoCrimeApp$.MODULE$.exportSparkModel(object, uRI);
    }

    public static String absPath(String string) {
        return ChicagoCrimeApp$.MODULE$.absPath(string);
    }

    public static void addFiles(SparkContext sparkContext, Seq<String> seq) {
        ChicagoCrimeApp$.MODULE$.addFiles(sparkContext, seq);
    }

    public static SparkConf configure(String string) {
        return ChicagoCrimeApp$.MODULE$.configure(string);
    }

    public static String $lessinit$greater$default$5() {
        return ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$4();
    }

    public static int getSeason(int n) {
        return ChicagoCrimeApp$.MODULE$.getSeason(n);
    }

    public static String[] SEASONS() {
        return ChicagoCrimeApp$.MODULE$.SEASONS();
    }

    public static void main(String[] stringArray) {
        ChicagoCrimeApp$.MODULE$.main(stringArray);
    }

    public double r2(GBMModel model, Frame fr) {
        return ModelMetricsSupport.class.r2((ModelMetricsSupport)this, (GBMModel)model, (Frame)fr);
    }

    public <T extends ModelMetrics, M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> T modelMetrics(Model<M, P, O> model, Frame fr) {
        return (T)ModelMetricsSupport.class.modelMetrics((ModelMetricsSupport)this, model, (Frame)fr);
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> ModelMetricsBinomial binomialMM(Model<M, P, O> model, Frame fr) {
        return ModelMetricsSupport.class.binomialMM((ModelMetricsSupport)this, model, (Frame)fr);
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> ModelMetricsMultinomial multinomialMM(Model<M, P, O> model, Frame fr) {
        return ModelMetricsSupport.class.multinomialMM((ModelMetricsSupport)this, model, (Frame)fr);
    }

    public H2OFrame loadH2OFrame(String datafile) {
        return SparklingWaterApp.class.loadH2OFrame((SparklingWaterApp)this, (String)datafile);
    }

    public void shutdown() {
        SparklingWaterApp.class.shutdown((SparklingWaterApp)this);
    }

    public String datePattern() {
        return this.datePattern;
    }

    public String dateTimeZone() {
        return this.dateTimeZone;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public H2OContext h2oContext() {
        return this.h2oContext;
    }

    public Tuple2<GBMModel, DeepLearningModel> train(DataFrame weatherTable, DataFrame censusTable, DataFrame crimesTable) {
        SQLContext sqlc = this.sqlContext();
        H2OContext h2oc = this.h2oContext();
        weatherTable.registerTempTable("chicagoWeather");
        censusTable.registerTempTable("chicagoCensus");
        crimesTable.registerTempTable("chicagoCrime");
        DataFrame crimeWeather = this.sqlContext().sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |a.Year, a.Month, a.Day, a.WeekNum, a.HourOfDay, a.Weekend, a.Season, a.WeekDay,\n        |a.IUCR, a.Primary_Type, a.Location_Description, a.Community_Area, a.District,\n        |a.Arrest, a.Domestic, a.Beat, a.Ward, a.FBI_Code,\n        |b.minTemp, b.maxTemp, b.meanTemp,\n        |c.PERCENT_AGED_UNDER_18_OR_OVER_64, c.PER_CAPITA_INCOME, c.HARDSHIP_INDEX,\n        |c.PERCENT_OF_HOUSING_CROWDED, c.PERCENT_HOUSEHOLDS_BELOW_POVERTY,\n        |c.PERCENT_AGED_16__UNEMPLOYED, c.PERCENT_AGED_25__WITHOUT_HIGH_SCHOOL_DIPLOMA\n        |FROM chicagoCrime a\n        |JOIN chicagoWeather b\n        |ON a.Year = b.year AND a.Month = b.month AND a.Day = b.day\n        |JOIN chicagoCensus c\n        |ON a.Community_Area = c.Community_Area_Number")).stripMargin());
        H2OFrame crimeWeatherDF = this.h2oContext().asH2OFrame(crimeWeather);
        DemoUtils$.MODULE$.allStringVecToCategorical(crimeWeatherDF);
        String[] keys = (String[])((Object[])new String[]{"train.hex", "test.hex"});
        double[] ratios = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8, 0.2}), ClassTag$.MODULE$.Double());
        Frame[] frs = DemoUtils$.MODULE$.splitFrame(crimeWeatherDF, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])keys), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(ratios));
        Tuple2 tuple2 = new Tuple2((Object)frs[0], (Object)frs[1]);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Frame train = (Frame)tuple2._1();
            Frame test = (Frame)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)train, (Object)test);
            Frame train2 = (Frame)tuple23._1();
            Frame test2 = (Frame)tuple23._2();
            GBMModel gbmModel = this.GBMModel(this.h2oContext().asH2OFrame(train2), this.h2oContext().asH2OFrame(test2), this.h2oContext().symbolToString(Symbol$.MODULE$.apply("Arrest")), this.GBMModel$default$4(), this.GBMModel$default$5(), this.GBMModel$default$6(), h2oc);
            Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> tuple24 = this.binomialMetrics((Model)gbmModel, this.h2oContext().asH2OFrame(train2), this.h2oContext().asH2OFrame(test2));
            if (tuple24 != null) {
                Tuple2 tuple25;
                ModelMetricsBinomial trainMetricsGBM = (ModelMetricsBinomial)tuple24._1();
                ModelMetricsBinomial testMetricsGBM = (ModelMetricsBinomial)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)trainMetricsGBM, (Object)testMetricsGBM);
                ModelMetricsBinomial trainMetricsGBM2 = (ModelMetricsBinomial)tuple26._1();
                ModelMetricsBinomial testMetricsGBM2 = (ModelMetricsBinomial)tuple26._2();
                DeepLearningModel dlModel = this.DLModel(this.h2oContext().asH2OFrame(train2), this.h2oContext().asH2OFrame(test2), this.h2oContext().symbolToString(Symbol$.MODULE$.apply("Arrest")), this.DLModel$default$4(), this.DLModel$default$5(), this.DLModel$default$6(), this.DLModel$default$7(), this.DLModel$default$8(), h2oc);
                Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> tuple27 = this.binomialMetrics((Model)dlModel, this.h2oContext().asH2OFrame(train2), this.h2oContext().asH2OFrame(test2));
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    ModelMetricsBinomial trainMetricsDL = (ModelMetricsBinomial)tuple27._1();
                    ModelMetricsBinomial testMetricsDL = (ModelMetricsBinomial)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)trainMetricsDL, (Object)testMetricsDL);
                    ModelMetricsBinomial trainMetricsDL2 = (ModelMetricsBinomial)tuple29._1();
                    ModelMetricsBinomial testMetricsDL2 = (ModelMetricsBinomial)tuple29._2();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Model performance:\n          |  GBM:\n          |    train AUC = ", "\n          |    test  AUC = ", "\n          |  DL:\n          |    train AUC = ", "\n          |    test  AUC = ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMetricsGBM2.auc()._auc), BoxesRunTime.boxToDouble((double)testMetricsGBM2.auc()._auc), BoxesRunTime.boxToDouble((double)trainMetricsDL2.auc()._auc), BoxesRunTime.boxToDouble((double)testMetricsDL2.auc()._auc)})))).stripMargin());
                    return new Tuple2((Object)gbmModel, (Object)dlModel);
                }
                throw new MatchError(tuple27);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public GBMModel GBMModel(H2OFrame train, H2OFrame test, String response, int ntrees, int depth, Distribution.Family family, H2OContext h2oContext) {
        GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
        gbmParams._train = h2oContext.toH2OFrameKey((Frame)train);
        gbmParams._valid = h2oContext.toH2OFrameKey((Frame)test);
        gbmParams._response_column = response;
        gbmParams._ntrees = ntrees;
        gbmParams._max_depth = depth;
        gbmParams._distribution = family;
        GBM gbm = new GBM(gbmParams);
        GBMModel model = (GBMModel)gbm.trainModel().get();
        return model;
    }

    public int GBMModel$default$4() {
        return 10;
    }

    public int GBMModel$default$5() {
        return 6;
    }

    public Distribution.Family GBMModel$default$6() {
        return Distribution.Family.bernoulli;
    }

    public DeepLearningModel DLModel(H2OFrame train, H2OFrame test, String response, int epochs, double l1, double l2, DeepLearningParameters.Activation activation, int[] hidden, H2OContext h2oContext) {
        DeepLearningParameters dlParams = new DeepLearningParameters();
        dlParams._train = h2oContext.toH2OFrameKey((Frame)train);
        dlParams._valid = h2oContext.toH2OFrameKey((Frame)test);
        dlParams._response_column = response;
        dlParams._epochs = epochs;
        dlParams._l1 = l1;
        dlParams._l2 = l2;
        dlParams._activation = activation;
        dlParams._hidden = hidden;
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel model = (DeepLearningModel)dl.trainModel().get();
        return model;
    }

    public int DLModel$default$4() {
        return 10;
    }

    public double DLModel$default$5() {
        return 1.0E-4;
    }

    public double DLModel$default$6() {
        return 1.0E-4;
    }

    public DeepLearningParameters.Activation DLModel$default$7() {
        return DeepLearningParameters.Activation.RectifierWithDropout;
    }

    public int[] DLModel$default$8() {
        return new int[]{200, 200};
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> binomialMetrics(Model<M, P, O> model, H2OFrame train, H2OFrame test) {
        model.score((Frame)train).delete();
        model.score((Frame)test).delete();
        return new Tuple2((Object)this.binomialMM(model, (Frame)train), (Object)this.binomialMM(model, (Frame)test));
    }

    public Tuple3<DataFrame, DataFrame, DataFrame> loadAll() {
        SQLContext sqlc = this.sqlContext();
        H2OContext h2oc = this.h2oContext();
        DataFrame weatherTable = this.h2oContext().asDataFrame(this.createWeatherTable(this.weatherFile), sqlc);
        weatherTable.registerTempTable("chicagoWeather");
        DataFrame censusTable = this.h2oContext().asDataFrame(this.createCensusTable(this.censusFile), sqlc);
        censusTable.registerTempTable("chicagoCensus");
        DataFrame crimeTable = this.h2oContext().asDataFrame(this.createCrimeTable(this.crimesFile), sqlc);
        crimeTable.registerTempTable("chicagoCrime");
        return new Tuple3((Object)weatherTable, (Object)censusTable, (Object)crimeTable);
    }

    private H2OFrame loadData(String datafile) {
        return new H2OFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URI[]{new URI(datafile)}));
    }

    /*
     * WARNING - void declaration
     */
    public H2OFrame createWeatherTable(String datafile) {
        void var2_2;
        H2OFrame table = this.loadData(datafile);
        table.remove(0).remove();
        table.update(null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public H2OFrame createCensusTable(String datafile) {
        void var2_2;
        H2OFrame table = this.loadData(datafile);
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])table.names()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String n) {
                return n.trim().replace(' ', '_').replace('+', '_');
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        table._names = colNames;
        table.update(null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public H2OFrame createCrimeTable(String datafile) {
        void var2_2;
        H2OFrame table = this.loadData(datafile);
        Vec dateCol = table.vec(2);
        table.add((Frame)new RefineDateColumn(this.datePattern(), this.dateTimeZone()).doIt(dateCol));
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])table.names()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String n) {
                return n.trim().replace(' ', '_');
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        table._names = colNames;
        table.remove(2).remove();
        table.update(null);
        return var2_2;
    }

    public float scoreEvent(Crime crime, Model<?, ?, ?> model, DataFrame censusTable, SQLContext sqlContext, H2OContext h2oContext) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ChicagoCrimeApp.class.getClassLoader());
        public final class Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.Crime")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator1$1(ChicagoCrimeApp $outer) {
            }
        }
        DataFrame srdd = sqlContext.implicits().rddToDataFrameHolder(sqlContext.sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Crime[]{crime})), sqlContext.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Crime.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator1$1(this))).toDF();
        H2OFrame row = h2oContext.asH2OFrame(censusTable.join(srdd).where(sqlContext.implicits().symbolToColumn(Symbol$.MODULE$.apply("Community_Area")).$eq$eq$eq((Object)Symbol$.MODULE$.apply("Community_Area_Number"))));
        DemoUtils$.MODULE$.allStringVecToCategorical(row);
        Frame predictTable = model.score((Frame)row);
        double probOfArrest = predictTable.vec("true").at(0L);
        return (float)probOfArrest;
    }

    public ChicagoCrimeApp(String weatherFile, String censusFile, String crimesFile, String datePattern, String dateTimeZone, SparkContext sc, SQLContext sqlContext, H2OContext h2oContext) {
        this.weatherFile = weatherFile;
        this.censusFile = censusFile;
        this.crimesFile = crimesFile;
        this.datePattern = datePattern;
        this.dateTimeZone = dateTimeZone;
        this.sc = sc;
        this.sqlContext = sqlContext;
        this.h2oContext = h2oContext;
        SparklingWaterApp.class.$init$((SparklingWaterApp)this);
        ModelMetricsSupport.class.$init$((ModelMetricsSupport)this);
    }
}

