/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningParameters;
import hex.tree.gbm.GBMModel;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.examples.h2o.DemoUtils$;
import org.apache.spark.examples.h2o.HamOrSpamDemo$;
import org.apache.spark.examples.h2o.SMS;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.mllib.feature.HashingTF;
import org.apache.spark.mllib.feature.IDF;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import water.Key;
import water.app.ModelMetricsSupport;
import water.app.SparkContextSupport;
import water.fvec.Frame;
import water.fvec.H2OFrame;

public final class HamOrSpamDemo$
implements SparkContextSupport,
ModelMetricsSupport {
    public static final HamOrSpamDemo$ MODULE$;
    private final String DATAFILE;
    private final Seq<String> TEST_MSGS;

    static {
        new HamOrSpamDemo$();
    }

    public double r2(GBMModel model, Frame fr) {
        return ModelMetricsSupport.class.r2((ModelMetricsSupport)this, (GBMModel)model, (Frame)fr);
    }

    public <T extends ModelMetrics, M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> T modelMetrics(Model<M, P, O> model, Frame fr) {
        return (T)ModelMetricsSupport.class.modelMetrics((ModelMetricsSupport)this, model, (Frame)fr);
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> ModelMetricsBinomial binomialMM(Model<M, P, O> model, Frame fr) {
        return ModelMetricsSupport.class.binomialMM((ModelMetricsSupport)this, model, (Frame)fr);
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> ModelMetricsMultinomial multinomialMM(Model<M, P, O> model, Frame fr) {
        return ModelMetricsSupport.class.multinomialMM((ModelMetricsSupport)this, model, (Frame)fr);
    }

    public SparkConf configure(String appName) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public String DATAFILE() {
        return this.DATAFILE;
    }

    public Seq<String> TEST_MSGS() {
        return this.TEST_MSGS;
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling Water Meetup: Ham or Spam (spam text messages detector)");
        SparkContext sc = new SparkContext(conf);
        this.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.absPath(new StringBuilder().append((Object)"examples/smalldata/").append((Object)this.DATAFILE()).toString())}));
        H2OContext h2oContext = new H2OContext(sc).start();
        SQLContext sqlContext = new SQLContext(sc);
        RDD<String[]> data = this.load(sc, this.DATAFILE());
        RDD hamSpam = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String[] r) {
                return r[0];
            }
        }, ClassTag$.MODULE$.apply(String.class));
        RDD message = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String[] r) {
                return r[1];
            }
        }, ClassTag$.MODULE$.apply(String.class));
        RDD<Seq<String>> tokens = this.tokenize((RDD<String>)message);
        Tuple3<HashingTF, IDFModel, RDD<Vector>> tuple3 = this.buildIDFModel(tokens, this.buildIDFModel$default$2(), this.buildIDFModel$default$3());
        if (tuple3 != null) {
            Tuple3 tuple32;
            HashingTF hashingTF = (HashingTF)tuple3._1();
            IDFModel idfModel = (IDFModel)tuple3._2();
            RDD tfidf = (RDD)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)hashingTF, (Object)idfModel, (Object)tfidf);
            ObjectRef hashingTF2 = new ObjectRef((Object)((HashingTF)tuple33._1()));
            ObjectRef idfModel2 = new ObjectRef((Object)((IDFModel)tuple33._2()));
            RDD tfidf2 = (RDD)tuple33._3();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.SMS")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator1$1() {
                }
            }
            DataFrame resultRDD = sqlContext.implicits().rddToDataFrameHolder(hamSpam.zip(tfidf2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SMS apply(Tuple2<String, Vector> v) {
                    return new SMS((String)v._1(), (Vector)v._2());
                }
            }, ClassTag$.MODULE$.apply(SMS.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator1$1())).toDF();
            H2OFrame table = h2oContext.asH2OFrame(resultRDD);
            table.replace(table.find("target"), table.vec("target").toCategoricalVec()).remove();
            String[] keys = (String[])((Object[])new String[]{"train.hex", "valid.hex"});
            double[] ratios = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8}), ClassTag$.MODULE$.Double());
            Frame[] frs = DemoUtils$.MODULE$.split(table, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])keys), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(ratios));
            Tuple2 tuple2 = new Tuple2((Object)frs[0], (Object)frs[1]);
            if (tuple2 != null) {
                Tuple2 tuple22;
                Frame train = (Frame)tuple2._1();
                Frame valid = (Frame)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)train, (Object)valid);
                Frame train2 = (Frame)tuple23._1();
                Frame valid2 = (Frame)tuple23._2();
                table.delete();
                DeepLearningModel dlModel = this.buildDLModel(train2, valid2, this.buildDLModel$default$3(), this.buildDLModel$default$4(), this.buildDLModel$default$5(), this.buildDLModel$default$6(), h2oContext);
                ModelMetricsBinomial trainMetrics = this.binomialMM((Model)dlModel, train2);
                ModelMetricsBinomial validMetrics = this.binomialMM((Model)dlModel, valid2);
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |AUC on train data = ", "\n         |AUC on valid data = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMetrics.auc()._auc), BoxesRunTime.boxToDouble((double)validMetrics.auc()._auc)})))).stripMargin());
                this.TEST_MSGS().foreach((Function1)new Serializable(sc, h2oContext, sqlContext, hashingTF2, idfModel2, dlModel){
                    public static final long serialVersionUID = 0L;
                    private final SparkContext sc$1;
                    private final H2OContext h2oContext$1;
                    private final SQLContext sqlContext$1;
                    private final ObjectRef hashingTF$1;
                    private final ObjectRef idfModel$1;
                    private final DeepLearningModel dlModel$1;

                    public final void apply(String msg) {
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |\"", "\" is ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, HamOrSpamDemo$.MODULE$.isSpam(msg, this.sc$1, this.dlModel$1, (HashingTF)this.hashingTF$1.elem, (IDFModel)this.idfModel$1.elem, HamOrSpamDemo$.MODULE$.isSpam$default$6(), this.sqlContext$1, this.h2oContext$1) ? "SPAM" : "HAM"})))).stripMargin());
                    }
                    {
                        this.sc$1 = sc$1;
                        this.h2oContext$1 = h2oContext$1;
                        this.sqlContext$1 = sqlContext$1;
                        this.hashingTF$1 = hashingTF$1;
                        this.idfModel$1 = idfModel$1;
                        this.dlModel$1 = dlModel$1;
                    }
                });
                sc.stop();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(tuple3);
    }

    public RDD<String[]> load(SparkContext sc, String dataFile) {
        return sc.textFile(SparkFiles$.MODULE$.get(dataFile), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String l) {
                return l.split("\t");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] r) {
                return !r[0].isEmpty();
            }
        });
    }

    public RDD<Seq<String>> tokenize(RDD<String> data) {
        Seq ignoredWords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the", "a", "", "in", "on", "at", "as", "not", "for"}));
        Seq ignoredChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{',', ':', ';', '/', '<', '>', '\"', '.', '(', ')', '?', '-', '\'', '!', '0', '1'}));
        RDD texts = data.map((Function1)new Serializable(ignoredWords, ignoredChars){
            public static final long serialVersionUID = 0L;
            public final Seq ignoredWords$1;
            private final Seq ignoredChars$1;

            public final Seq<String> apply(String r) {
                ObjectRef smsText = new ObjectRef((Object)r.toLowerCase());
                this.ignoredChars$1.foreach((Function1)new Serializable(this, smsText){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef smsText$1;

                    public final void apply(char c) {
                        this.smsText$1.elem = ((String)this.smsText$1.elem).replace(c, ' ');
                    }
                    {
                        this.smsText$1 = smsText$1;
                    }
                });
                String[] words = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)smsText.elem).split(" ")).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;

                    public final boolean apply(String w) {
                        return !this.$outer.ignoredWords$1.contains((Object)w) && w.length() > 2;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).distinct();
                return Predef$.MODULE$.refArrayOps((Object[])words).toSeq();
            }
            {
                this.ignoredWords$1 = ignoredWords$1;
                this.ignoredChars$1 = ignoredChars$1;
            }
        }, ClassTag$.MODULE$.apply(Seq.class));
        return texts;
    }

    public Tuple3<HashingTF, IDFModel, RDD<Vector>> buildIDFModel(RDD<Seq<String>> tokens, int minDocFreq, int hashSpaceSize) {
        HashingTF hashingTF = new HashingTF(hashSpaceSize);
        RDD tf = hashingTF.transform(tokens);
        IDFModel idfModel = new IDF(minDocFreq).fit(tf);
        RDD expandedText = idfModel.transform(tf);
        return new Tuple3((Object)hashingTF, (Object)idfModel, (Object)expandedText);
    }

    public int buildIDFModel$default$2() {
        return 4;
    }

    public int buildIDFModel$default$3() {
        return 1024;
    }

    public DeepLearningModel buildDLModel(Frame train, Frame valid, int epochs, double l1, double l2, int[] hidden, H2OContext h2oContext) {
        DeepLearningParameters dlParams = new DeepLearningParameters();
        dlParams._model_id = Key.make((String)"dlModel.hex");
        dlParams._train = h2oContext.toH2OFrameKey(train);
        dlParams._valid = h2oContext.toH2OFrameKey(valid);
        dlParams._response_column = h2oContext.symbolToString(Symbol$.MODULE$.apply("target"));
        dlParams._epochs = epochs;
        dlParams._l1 = l1;
        dlParams._hidden = hidden;
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel dlModel = (DeepLearningModel)dl.trainModel().get();
        dlModel.score(train).delete();
        dlModel.score(valid).delete();
        return dlModel;
    }

    public int buildDLModel$default$3() {
        return 10;
    }

    public double buildDLModel$default$4() {
        return 0.001;
    }

    public double buildDLModel$default$5() {
        return 0.0;
    }

    public int[] buildDLModel$default$6() {
        return (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{200, 200}), ClassTag$.MODULE$.Int());
    }

    public boolean isSpam(String msg, SparkContext sc, DeepLearningModel dlModel, HashingTF hashingTF, IDFModel idfModel, double hamThreshold, SQLContext sqlContext, H2OContext h2oContext) {
        RDD msgRdd = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.h2o.SMS")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator2$1() {
            }
        }
        DataFrame msgVector = sqlContext.implicits().rddToDataFrameHolder(idfModel.transform(hashingTF.transform(this.tokenize((RDD<String>)msgRdd))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SMS apply(Vector v) {
                return new SMS("?", v);
            }
        }, ClassTag$.MODULE$.apply(SMS.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator2$1())).toDF();
        H2OFrame msgTable = h2oContext.asH2OFrame(msgVector);
        msgTable.remove(0);
        Frame prediction = dlModel.score((Frame)msgTable);
        return prediction.vecs()[1].at(0L) < hamThreshold;
    }

    public double isSpam$default$6() {
        return 0.5;
    }

    private HamOrSpamDemo$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
        ModelMetricsSupport.class.$init$((ModelMetricsSupport)this);
        this.DATAFILE = "smsData.txt";
        this.TEST_MSGS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Michal, beer tonight in MV?", "We tried to contact you re your reply to our offer of a Video Handset? 750 anytime any networks mins? UNLIMITED TEXT?"}));
    }
}

