/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.FrameSplitter;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsSupervised;
import hex.splitframe.ShuffleSplitFrame;
import hex.tree.gbm.GBMModel;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.h2o.H2OContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.sys.package$;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.parser.BufferedString;

public final class DemoUtils$ {
    public static final DemoUtils$ MODULE$;

    static {
        new DemoUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public SparkConf configure(String appName) {
        void var2_2;
        SparkConf conf = new SparkConf().setAppName(appName);
        conf.setIfMissing("spark.master", (String)package$.MODULE$.env().getOrElse((Object)"spark.master", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "local";
            }
        }));
        return var2_2;
    }

    public String configure$default$1() {
        return "Sparkling Water Demo";
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        files.foreach((Function1)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;

            public final void apply(String f) {
                this.sc$1.addFile(f);
            }
            {
                this.sc$1 = sc$1;
            }
        });
    }

    public void printFrame(H2OFrame fr) {
        new MRTask<Nothing$>(){

            public void map(Chunk[] cs) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Chunks: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])cs).mkString(",")).toString());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cs[0]._len).foreach$mVc$sp((Function1)new Serializable(this, cs){
                    public static final long serialVersionUID = 0L;
                    private final Chunk[] cs$1;

                    public final void apply(int r) {
                        this.apply$mcVI$sp(r);
                    }

                    public void apply$mcVI$sp(int r) {
                        Predef$.MODULE$.refArrayOps((Object[])this.cs$1).foreach((Function1)new Serializable(this, r){
                            public static final long serialVersionUID = 0L;
                            private final int r$1;

                            public final void apply(Chunk c) {
                                BufferedString vstr = new BufferedString();
                                if (c.vec().isString()) {
                                    c.atStr(vstr, this.r$1);
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)vstr.toString()).append((Object)",").toString());
                                } else if (c.vec().isCategorical()) {
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)c.vec().domain()[(int)c.at8(this.r$1)]).append((Object)", ").toString());
                                } else {
                                    Predef$.MODULE$.print((Object)new StringBuilder().append(c.atd(this.r$1)).append((Object)", ").toString());
                                }
                            }
                            {
                                this.r$1 = r$1;
                            }
                        });
                        Predef$.MODULE$.println();
                    }
                    {
                        this.cs$1 = cs$1;
                    }
                });
            }
        }.doAll((Frame)fr);
    }

    public H2OFrame allStringVecToCategorical(H2OFrame hf) {
        ((IterableLike)Predef$.MODULE$.refArrayOps((Object[])hf.vecs()).indices().filter((Function1)new Serializable(hf){
            public static final long serialVersionUID = 0L;
            private final H2OFrame hf$1;

            public final boolean apply(int idx) {
                return this.apply$mcZI$sp(idx);
            }

            public boolean apply$mcZI$sp(int idx) {
                return this.hf$1.vec(idx).isString();
            }
            {
                this.hf$1 = hf$1;
            }
        })).foreach((Function1)new Serializable(hf){
            public static final long serialVersionUID = 0L;
            private final H2OFrame hf$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                this.hf$1.replace(idx, this.hf$1.vec(idx).toCategoricalVec()).remove();
            }
            {
                this.hf$1 = hf$1;
            }
        });
        DKV.put((Keyed)hf);
        return hf;
    }

    public String residualPlotRCode(Frame prediction, String predCol, Frame actual, String actCol, H2OContext h2oContext) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (h2oContext == null) {
            tuple22 = new Tuple2((Object)"127.0.0.1", (Object)"54321");
        } else {
            String[] s = h2oContext.h2oLocalClient().split(":");
            tuple22 = tuple2 = new Tuple2((Object)s[0], (Object)s[1]);
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            String ip = (String)tuple2._1();
            String port = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)ip, (Object)port);
            String ip2 = (String)tuple24._1();
            String port2 = (String)tuple24._2();
            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# R script for residual plot\n        |library(h2o)\n        |h = h2o.init(ip=\"", "\", port=", ")\n        |\n        |pred = h2o.getFrame(h, \"", "\")\n        |act = h2o.getFrame (h, \"", "\")\n        |\n        |predDelay = pred$", "\n        |actDelay = act$", "\n        |\n        |nrow(actDelay) == nrow(predDelay)\n        |\n        |residuals = predDelay - actDelay\n        |\n        |compare = cbind (as.data.frame(actDelay$ArrDelay), as.data.frame(residuals$predict))\n        |nrow(compare)\n        |plot( compare[,1:2] )\n        |\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ip2, port2, prediction._key, actual._key, predCol, actCol})))).stripMargin();
        }
        throw new MatchError((Object)tuple2);
    }

    public H2OContext residualPlotRCode$default$5() {
        return null;
    }

    public Frame[] splitFrame(H2OFrame df, Seq<String> keys, Seq<Object> ratios) {
        Key[] ks = (Key[])((TraversableOnce)keys.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Key<Frame> apply(String x$2) {
                return Key.make((String)x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Key.class));
        Frame[] frs = ShuffleSplitFrame.shuffleSplitFrame((Frame)df, (Key[])ks, (double[])((double[])ratios.toArray(ClassTag$.MODULE$.Double())), (long)1234567689L);
        return frs;
    }

    public Frame[] split(H2OFrame df, Seq<String> keys, Seq<Object> ratios) {
        Key[] ks = (Key[])((TraversableOnce)keys.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Key<Frame> apply(String x$3) {
                return Key.make((String)x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Key.class));
        FrameSplitter splitter = new FrameSplitter((Frame)df, (double[])ratios.toArray(ClassTag$.MODULE$.Double()), ks, null);
        H2O.submitTask((H2O.H2OCountedCompleter)splitter);
        return splitter.getResult();
    }

    public double r2(GBMModel model, Frame fr) {
        return ((ModelMetricsSupervised)ModelMetrics.getFromDKV((Model)model, (Frame)fr)).r2();
    }

    public <T extends ModelMetrics, M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> T modelMetrics(Model<M, P, O> model, Frame fr) {
        return (T)ModelMetrics.getFromDKV(model, (Frame)fr);
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> ModelMetricsBinomial binomialMM(Model<M, P, O> model, Frame fr) {
        return (ModelMetricsBinomial)this.modelMetrics(model, fr);
    }

    private DemoUtils$() {
        MODULE$ = this;
    }
}

