/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import java.io.File;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.ml.spark.models.svm.SVM;
import org.apache.spark.ml.spark.models.svm.SVMModel;
import org.apache.spark.ml.spark.models.svm.SVMParameters;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.collection.Seq;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.support.SparkContextSupport;

public final class SparkSVMDemo$
implements SparkContextSupport {
    public static final SparkSVMDemo$ MODULE$;

    static {
        new SparkSVMDemo$();
    }

    public SparkConf configure(String appName, String defaultMaster) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName, (String)defaultMaster);
    }

    public SparkContext sparkContext(SparkConf conf) {
        return SparkContextSupport.class.sparkContext((SparkContextSupport)this, (SparkConf)conf);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public String enforceLocalSparkFile(String file) {
        return SparkContextSupport.class.enforceLocalSparkFile((SparkContextSupport)this, (String)file);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public String configure$default$2() {
        return SparkContextSupport.class.configure$default$2((SparkContextSupport)this);
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling Water: Spark SVM demo.", this.configure$default$2());
        SparkContext sc = new SparkContext(conf);
        H2OContext h2oContext = H2OContext$.MODULE$.getOrCreate(sc);
        SQLContext sqLContext = SparkSession$.MODULE$.builder().getOrCreate().sqlContext();
        this.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.absPath("examples/smalldata/bcwd.csv")}));
        H2OFrame breastCancerData = new H2OFrame(new File(SparkFiles$.MODULE$.get("bcwd.csv")));
        breastCancerData.replace(breastCancerData.numCols() - 1, breastCancerData.lastVec().toCategoricalVec());
        breastCancerData.update();
        SVMParameters parms = new SVMParameters();
        parms._train = breastCancerData.key();
        parms._response_column = "label";
        SVM svm = new SVM(parms, h2oContext);
        SVMModel svmModel = (SVMModel)svm.trainModel().get();
        Frame predictionH2OFrame = svmModel.score((Frame)breastCancerData);
        Row[] predictionsFromModel = (Row[])h2oContext.asDataFrame(predictionH2OFrame, h2oContext.asDataFrame$default$2(), sqLContext).collect();
        Predef$.MODULE$.println((Object)Predef$.MODULE$.refArrayOps((Object[])predictionsFromModel).mkString("\n===> Model predictions: ", ",\n", ", ...\n"));
        if (System.getProperty("spark.ext.h2o.preserve.executors") == null) {
            sc.stop();
        }
        h2oContext.stop(h2oContext.stop$default$1());
    }

    private SparkSVMDemo$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
    }
}

