/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import java.io.File;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.Airlines;
import org.apache.spark.examples.h2o.AirlinesParse$;
import org.apache.spark.examples.h2o.DeepLearningDemoWithoutExtension$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.h2o.package;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import water.api.TestUtils$;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.fvec.Vec;
import water.support.H2OFrameSupport$;
import water.support.SparkContextSupport;
import water.support.SparkSessionSupport;

public final class DeepLearningDemoWithoutExtension$
implements SparkContextSupport,
SparkSessionSupport {
    public static final DeepLearningDemoWithoutExtension$ MODULE$;
    private final transient SparkSession spark;
    private final transient SQLContext sqlContext;
    private volatile transient byte bitmap$trans$0;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;
    private static Symbol symbol$5;
    private static Symbol symbol$6;
    private static Symbol symbol$7;
    private static Symbol symbol$8;
    private static Symbol symbol$9;
    private static Symbol symbol$10;
    private static Symbol symbol$11;
    private static Symbol symbol$12;
    private static Symbol symbol$13;
    private static Symbol symbol$14;
    private static Symbol symbol$15;

    static {
        symbol$1 = Symbol$.MODULE$.apply("Year");
        symbol$2 = Symbol$.MODULE$.apply("Month");
        symbol$3 = Symbol$.MODULE$.apply("DayofMonth");
        symbol$4 = Symbol$.MODULE$.apply("DayOfWeek");
        symbol$5 = Symbol$.MODULE$.apply("CRSDepTime");
        symbol$6 = Symbol$.MODULE$.apply("CRSArrTime");
        symbol$7 = Symbol$.MODULE$.apply("UniqueCarrier");
        symbol$8 = Symbol$.MODULE$.apply("FlightNum");
        symbol$9 = Symbol$.MODULE$.apply("TailNum");
        symbol$10 = Symbol$.MODULE$.apply("CRSElapsedTime");
        symbol$11 = Symbol$.MODULE$.apply("Origin");
        symbol$12 = Symbol$.MODULE$.apply("Dest");
        symbol$13 = Symbol$.MODULE$.apply("Distance");
        symbol$14 = Symbol$.MODULE$.apply("IsDepDelayed");
        symbol$15 = Symbol$.MODULE$.apply("predict");
        new DeepLearningDemoWithoutExtension$();
    }

    private SparkSession spark$lzycompute() {
        DeepLearningDemoWithoutExtension$ deepLearningDemoWithoutExtension$ = this;
        synchronized (deepLearningDemoWithoutExtension$) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.spark = SparkSessionSupport.class.spark((SparkSessionSupport)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.spark;
        }
    }

    public SparkSession spark() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sqlContext$lzycompute() {
        DeepLearningDemoWithoutExtension$ deepLearningDemoWithoutExtension$ = this;
        synchronized (deepLearningDemoWithoutExtension$) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.sqlContext = SparkSessionSupport.class.sqlContext((SparkSessionSupport)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.sqlContext;
        }
    }

    public SQLContext sqlContext() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.sqlContext$lzycompute() : this.sqlContext;
    }

    public SparkConf configure(String appName, String defaultMaster) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName, (String)defaultMaster);
    }

    public SparkContext sparkContext(SparkConf conf) {
        return SparkContextSupport.class.sparkContext((SparkContextSupport)this, (SparkConf)conf);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public void addFiles(SparkSession spark, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkSession)spark, files);
    }

    public String enforceLocalSparkFile(String file) {
        return SparkContextSupport.class.enforceLocalSparkFile((SparkContextSupport)this, (String)file);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public String configure$default$2() {
        return SparkContextSupport.class.configure$default$2((SparkContextSupport)this);
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling water: DL demo without Spark modification", this.configure$default$2());
        SparkContext sc = this.sparkContext(conf);
        H2OContext h2oContext = H2OContext$.MODULE$.getOrCreate(sc);
        H2OFrame airlinesData = new H2OFrame(new File(TestUtils$.MODULE$.locate("smalldata/airlines/allyears2k_headers.zip")));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.h2o.Airlines").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator1$1() {
            }
        }
        Dataset airlinesTable = h2oContext.asDataFrame((Frame)airlinesData, h2oContext.asDataFrame$default$2(), this.sqlContext()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Airlines apply(Row row) {
                return AirlinesParse$.MODULE$.apply(row);
            }
        }, this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator1$1())));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of all flights via RDD#count call: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)airlinesTable.count())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of all flights via H2O#Frame#count: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)airlinesData.numRows())})));
        airlinesTable.toDF().createOrReplaceTempView("airlinesTable");
        String query = "SELECT * FROM airlinesTable WHERE Dest LIKE 'SFO'";
        H2OFrame result = h2oContext.implicits().asH2OFrameFromDataFrame(this.sqlContext().sql(query));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n===> Number of flights with destination in SFO: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)result.numRows())})));
        Predef$.MODULE$.println((Object)"\n====> Running DeepLearning on the result of SQL query\n");
        H2OFrame train2 = result.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$1, symbol$2, symbol$3, symbol$4, symbol$5, symbol$6, symbol$7, symbol$8, symbol$9, symbol$10, symbol$11, symbol$12, symbol$13, symbol$14}));
        H2OFrameSupport$.MODULE$.withLockAndUpdate((Frame)train2, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vec apply(H2OFrame fr) {
                return fr.replace(fr.numCols() - 1, fr.lastVec().toCategoricalVec());
            }
        });
        DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
        dlParams._train = h2oContext.implicits().toH2OFrameKeyFromH2OFrame(train2);
        dlParams._response_column = h2oContext.implicits().symbolToString(symbol$14);
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel dlModel = (DeepLearningModel)dl.trainModel().get();
        Predef$.MODULE$.println((Object)"\n====> Making prediction with help of DeepLearning model\n");
        H2OFrame predictionH2OFrame = h2oContext.implicits().asH2OFrameFromFrame(dlModel.score((Frame)result)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$15}));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.h2o")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.h2o.package")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.h2o.DoubleHolder"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator2$1() {
            }
        }
        Object[] predictionsFromModel = (Object[])Predef$.MODULE$.refArrayOps((Object[])h2oContext.asRDD(predictionH2OFrame, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_h2o_DeepLearningDemoWithoutExtension$$typecreator2$1()), ClassTag$.MODULE$.apply(package.DoubleHolder.class)).take(10)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(package.DoubleHolder x$1) {
                return x$1.result().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NaN";
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.genericArrayOps((Object)predictionsFromModel).mkString("\n===> Model predictions: ", ", ", ", ...\n"));
        if (System.getProperty("spark.ext.h2o.preserve.executors") == null) {
            sc.stop();
        }
        h2oContext.stop(h2oContext.stop$default$1());
    }

    private DeepLearningDemoWithoutExtension$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
        SparkSessionSupport.class.$init$((SparkSessionSupport)this);
    }
}

