/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.ChicagoCrimeApp$;
import org.apache.spark.examples.h2o.Crime;
import org.apache.spark.examples.h2o.RefineDateColumn;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.fvec.H2OFrame$;
import water.fvec.Vec;
import water.munging.JoinMethod;
import water.parser.ParseSetup;
import water.support.H2OFrameSupport;
import water.support.JoinSupport;
import water.support.ModelMetricsSupport;
import water.support.SparklingWaterApp;

@ScalaSignature(bytes="\u0006\u0001\r-b\u0001B\u0001\u0003\u00015\u0011qb\u00115jG\u0006<wn\u0011:j[\u0016\f\u0005\u000f\u001d\u0006\u0003\u0007\u0011\t1\u0001\u001b\u001ap\u0015\t)a!\u0001\u0005fq\u0006l\u0007\u000f\\3t\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u00019!Bd\b\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012aB:vaB|'\u000f\u001e\u0006\u00023\u0005)q/\u0019;fe&\u00111D\u0006\u0002\u0012'B\f'o\u001b7j]\u001e<\u0016\r^3s\u0003B\u0004\bCA\u000b\u001e\u0013\tqbCA\nN_\u0012,G.T3ue&\u001c7oU;qa>\u0014H\u000f\u0005\u0002\u0016A%\u0011\u0011E\u0006\u0002\u0010\u0011JzeI]1nKN+\b\u000f]8si\"A1\u0005\u0001B\u0001B\u0003%A%A\u0006xK\u0006$\b.\u001a:GS2,\u0007CA\u0013)\u001d\tya%\u0003\u0002(!\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9\u0003\u0003\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003%\u0003)\u0019WM\\:vg\u001aKG.\u001a\u0005\t]\u0001\u0011\t\u0011)A\u0005I\u0005Q1M]5nKN4\u0015\u000e\\3\t\u0011A\u0002!Q1A\u0005\u0002E\n1\u0002Z1uKB\u000bG\u000f^3s]V\tA\u0005\u0003\u00054\u0001\t\u0005\t\u0015!\u0003%\u00031!\u0017\r^3QCR$XM\u001d8!\u0011!)\u0004A!b\u0001\n\u0003\t\u0014\u0001\u00043bi\u0016$\u0016.\\3[_:,\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u001b\u0011\fG/\u001a+j[\u0016TvN\\3!\u0011!I\u0004A!b\u0001\n\u0003R\u0014AA:d+\u0005Y\u0004C\u0001\u001f>\u001b\u00051\u0011B\u0001 \u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!\u0001\u0005A!A!\u0002\u0013Y\u0014aA:dA!\u0012qH\u0011\t\u0003\u001f\rK!\u0001\u0012\t\u0003\u0013Q\u0014\u0018M\\:jK:$\b\u0002\u0003$\u0001\u0005\u000b\u0007I\u0011I$\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001I!\tIE*D\u0001K\u0015\tYe!A\u0002tc2L!!\u0014&\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003I\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011)\u00059\u0013\u0005\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011I*\u0002\u0015!\u0014tnQ8oi\u0016DH/F\u0001U!\t)v+D\u0001W\u0015\t\u0019a!\u0003\u0002Y-\nQ\u0001JM(D_:$X\r\u001f;\t\u0011i\u0003!\u0011!Q\u0001\nQ\u000b1\u0002\u001b\u001ap\u0007>tG/\u001a=uA!\u0012\u0011L\u0011\u0005\u0006;\u0002!\tAX\u0001\u0007y%t\u0017\u000e\u001e \u0015\r}+gm\u001a5j)\u0011\u0001'm\u00193\u0011\u0005\u0005\u0004Q\"\u0001\u0002\t\u000beb\u0006\u0019A\u001e\t\u000b\u0019c\u0006\u0019\u0001%\t\u000bIc\u0006\u0019\u0001+\t\u000b\rb\u0006\u0019\u0001\u0013\t\u000b1b\u0006\u0019\u0001\u0013\t\u000b9b\u0006\u0019\u0001\u0013\t\u000fAb\u0006\u0013!a\u0001I!9Q\u0007\u0018I\u0001\u0002\u0004!\u0003\"B6\u0001\t\u0003a\u0017!\u0002;sC&tGcB7\u0002\u0002\u0005%\u0012Q\u0006\t\u0005\u001f9\u0004(0\u0003\u0002p!\t1A+\u001e9mKJ\u0002\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u0007\u001d\u0014WN\u0003\u0002vm\u0006!AO]3f\u0015\u00059\u0018a\u00015fq&\u0011\u0011P\u001d\u0002\t\u000f\nkUj\u001c3fYB\u00111P`\u0007\u0002y*\u0011QP^\u0001\rI\u0016,\u0007\u000f\\3be:LgnZ\u0005\u0003\u007fr\u0014\u0011\u0003R3fa2+\u0017M\u001d8j]\u001elu\u000eZ3m\u0011\u001d\t\u0019A\u001ba\u0001\u0003\u000b\tAb^3bi\",'\u000fV1cY\u0016\u0004B!a\u0002\u0002$9!\u0011\u0011BA\u0010\u001d\u0011\tY!!\b\u000f\t\u00055\u00111\u0004\b\u0005\u0003\u001f\tIB\u0004\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002D\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA&\u0007\u0013\r\t\tCS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)#a\n\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA\u0011\u0015\"9\u00111\u00066A\u0002\u0005\u0015\u0011aC2f]N,8\u000fV1cY\u0016Dq!a\fk\u0001\u0004\t)!A\u0006de&lWm\u001d+bE2,\u0007bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\t\u000f\nkUj\u001c3fYRq\u0011qGA\u001e\u0003\u001b\n\t&!\u0016\u0002`\u0005\rDc\u00019\u0002:!1!+!\rA\u0004QCqa[A\u0019\u0001\u0004\ti\u0004\u0005\u0003\u0002@\u0005\u001dc\u0002BA!\u0003\u000brA!a\u0003\u0002D%\u00111AB\u0005\u0004\u0003C1\u0016\u0002BA%\u0003\u0017\u0012\u0001\u0002\u0013\u001aP\rJ\fW.\u001a\u0006\u0004\u0003C1\u0006\u0002CA(\u0003c\u0001\r!!\u0010\u0002\tQ,7\u000f\u001e\u0005\b\u0003'\n\t\u00041\u0001%\u0003!\u0011Xm\u001d9p]N,\u0007BCA,\u0003c\u0001\n\u00111\u0001\u0002Z\u00051a\u000e\u001e:fKN\u00042aDA.\u0013\r\ti\u0006\u0005\u0002\u0004\u0013:$\bBCA1\u0003c\u0001\n\u00111\u0001\u0002Z\u0005)A-\u001a9uQ\"Q\u0011QMA\u0019!\u0003\u0005\r!a\u001a\u0002\r\u0019\fW.\u001b7z!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\nQ!\u001e;jYNT1!!\u001dw\u0003!9WM\\7pI\u0016d\u0017\u0002BA;\u0003W\u0012!\u0003R5tiJL'-\u001e;j_:4\u0015-\\5ms\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0014a\u0002#M\u001b>$W\r\u001c\u000b\u0013\u0003{\n\t)a!\u0002\u0006\u0006\u001d\u00151RAK\u00033\u000bY\fF\u0002{\u0003\u007fBaAUA<\u0001\b!\u0006bB6\u0002x\u0001\u0007\u0011Q\b\u0005\t\u0003\u001f\n9\b1\u0001\u0002>!9\u00111KA<\u0001\u0004!\u0003BCAE\u0003o\u0002\n\u00111\u0001\u0002Z\u00051Q\r]8dQND!\"!$\u0002xA\u0005\t\u0019AAH\u0003\ta\u0017\u0007E\u0002\u0010\u0003#K1!a%\u0011\u0005\u0019!u.\u001e2mK\"Q\u0011qSA<!\u0003\u0005\r!a$\u0002\u00051\u0014\u0004BCAN\u0003o\u0002\n\u00111\u0001\u0002\u001e\u0006Q\u0011m\u0019;jm\u0006$\u0018n\u001c8\u0011\t\u0005}\u0015Q\u0017\b\u0005\u0003C\u000byK\u0004\u0003\u0002$\u0006-f\u0002BAS\u0003SsA!!\u0005\u0002(&\tq/\u0003\u0002~m&\u0019\u0011Q\u0016?\u0002#\u0011+W\r\u001d'fCJt\u0017N\\4N_\u0012,G.\u0003\u0003\u00022\u0006M\u0016A\u0006#fKBdU-\u0019:oS:<\u0007+\u0019:b[\u0016$XM]:\u000b\u0007\u00055F0\u0003\u0003\u00028\u0006e&AC!di&4\u0018\r^5p]*!\u0011\u0011WAZ\u0011)\ti,a\u001e\u0011\u0002\u0003\u0007\u0011qX\u0001\u0007Q&$G-\u001a8\u0011\u000b=\t\t-!\u0017\n\u0007\u0005\r\u0007CA\u0003BeJ\f\u0017\u0010C\u0004\u0002H\u0002!\t!!3\u0002\u001f\tLgn\\7jC2lU\r\u001e:jGN,\u0002\"a3\u0002f\u0006M(\u0011\u0002\u000b\t\u0003\u001b\f9N!\u0006\u0003\u0018A1qB\\Ah\u0003\u001f\u0004B!!5\u0002T6\ta/C\u0002\u0002VZ\u0014A#T8eK2lU\r\u001e:jGN\u0014\u0015N\\8nS\u0006d\u0007\u0002CAm\u0003\u000b\u0004\r!a7\u0002\u000b5|G-\u001a7\u0011\u0015\u0005E\u0017Q\\Aq\u0003c\u00149!C\u0002\u0002`Z\u0014Q!T8eK2\u0004B!a9\u0002f2\u0001A\u0001CAt\u0003\u000b\u0014\r!!;\u0003\u00035\u000bB!a;\u0002\\B\u0019q\"!<\n\u0007\u0005=\bCA\u0004O_RD\u0017N\\4\u0011\t\u0005\r\u00181\u001f\u0003\t\u0003k\f)M1\u0001\u0002x\n\t\u0001+\u0005\u0003\u0002l\u0006e\b\u0003BA~\u0005\u0003qA!!*\u0002~&\u0019\u0011q <\u0002\u000b5{G-\u001a7\n\t\t\r!Q\u0001\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(bAA\u0000mB!\u00111\u001dB\u0005\t!\u0011Y!!2C\u0002\t5!!A(\u0012\t\u0005-(q\u0002\t\u0005\u0003w\u0014\t\"\u0003\u0003\u0003\u0014\t\u0015!AB(viB,H\u000fC\u0004l\u0003\u000b\u0004\r!!\u0010\t\u0011\u0005=\u0013Q\u0019a\u0001\u0003{AqAa\u0007\u0001\t\u0003\u0011i\"A\u0004m_\u0006$\u0017\t\u001c7\u0015\u0005\t}\u0001#C\b\u0003\"\u0005\u0015\u0011QAA\u0003\u0013\r\u0011\u0019\u0003\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*\u0005AAn\\1e\t\u0006$\u0018\r\u0006\u0004\u0002>\t-\"q\u0006\u0005\b\u0005[\u0011)\u00031\u0001%\u0003!!\u0017\r^1gS2,\u0007B\u0003B\u0019\u0005K\u0001\n\u00111\u0001\u00034\u0005\tRn\u001c3jMf\u0004\u0016M]:feN+G/\u001e9\u0011\u000f=\u0011)D!\u000f\u0003:%\u0019!q\u0007\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\u0007\t}\u0002$\u0001\u0004qCJ\u001cXM]\u0005\u0005\u0005\u0007\u0012iD\u0001\u0006QCJ\u001cXmU3ukBDqAa\u0012\u0001\t\u0003\u0011I%\u0001\nde\u0016\fG/Z,fCRDWM\u001d+bE2,G\u0003BA\u001f\u0005\u0017BqA!\f\u0003F\u0001\u0007A\u0005C\u0004\u0003P\u0001!\tA!\u0015\u0002#\r\u0014X-\u0019;f\u0007\u0016t7/^:UC\ndW\r\u0006\u0003\u0002>\tM\u0003b\u0002B\u0017\u0005\u001b\u0002\r\u0001\n\u0005\b\u0005/\u0002A\u0011\u0001B-\u0003A\u0019'/Z1uK\u000e\u0013\u0018.\\3UC\ndW\r\u0006\u0003\u0002>\tm\u0003b\u0002B\u0017\u0005+\u0002\r\u0001\n\u0005\b\u0005?\u0002A\u0011\u0001B1\u0003)\u00198m\u001c:f\u000bZ,g\u000e\u001e\u000b\t\u0005G\u0012yG!\u001f\u0003\u001aR1!Q\rB6\u0005[\u00022a\u0004B4\u0013\r\u0011I\u0007\u0005\u0002\u0006\r2|\u0017\r\u001e\u0005\u0007\r\nu\u00039\u0001%\t\rI\u0013i\u0006q\u0001U\u0011!\u0011\tH!\u0018A\u0002\tM\u0014!B2sS6,\u0007cA1\u0003v%\u0019!q\u000f\u0002\u0003\u000b\r\u0013\u0018.\\3\t\u0011\u0005e'Q\fa\u0001\u0005w\u0002\u0004B! \u0003\u0002\n=%Q\u0013\t\u000b\u0003#\fiNa \u0003\u000e\nM\u0005\u0003BAr\u0005\u0003#ABa!\u0003z\u0005\u0005\t\u0011!B\u0001\u0005\u000b\u00131a\u0018\u00132#\u0011\tYOa\"\u0011\u0007=\u0011I)C\u0002\u0003\fB\u00111!\u00118z!\u0011\t\u0019Oa$\u0005\u0019\tE%\u0011PA\u0001\u0002\u0003\u0015\tA!\"\u0003\u0007}##\u0007\u0005\u0003\u0002d\nUE\u0001\u0004BL\u0005s\n\t\u0011!A\u0003\u0002\t\u0015%aA0%g!A\u00111\u0006B/\u0001\u0004\t)\u0001C\u0005\u0003\u001e\u0002\t\n\u0011\"\u0001\u0003 \u0006\u0011rIQ'N_\u0012,G\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\tK\u000b\u0003\u0002Z\t\r6F\u0001BS!\u0011\u00119K!-\u000e\u0005\t%&\u0002\u0002BV\u0005[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=\u0006#\u0001\u0006b]:|G/\u0019;j_:LAAa-\u0003*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t]\u0006!%A\u0005\u0002\t}\u0015AE$C\u001b6{G-\u001a7%I\u00164\u0017-\u001e7uIUB\u0011Ba/\u0001#\u0003%\tA!0\u0002%\u001d\u0013U*T8eK2$C-\u001a4bk2$HEN\u000b\u0003\u0005\u007fSC!a\u001a\u0003$\"I!1\u0019\u0001\u0012\u0002\u0013\u0005!qT\u0001\u0012\t2ku\u000eZ3mI\u0011,g-Y;mi\u0012\"\u0004\"\u0003Bd\u0001E\u0005I\u0011\u0001Be\u0003E!E*T8eK2$C-\u001a4bk2$H%N\u000b\u0003\u0005\u0017TC!a$\u0003$\"I!q\u001a\u0001\u0012\u0002\u0013\u0005!\u0011Z\u0001\u0012\t2ku\u000eZ3mI\u0011,g-Y;mi\u00122\u0004\"\u0003Bj\u0001E\u0005I\u0011\u0001Bk\u0003E!E*T8eK2$C-\u001a4bk2$HeN\u000b\u0003\u0005/TC!!(\u0003$\"I!1\u001c\u0001\u0012\u0002\u0013\u0005!Q\\\u0001\u0012\t2ku\u000eZ3mI\u0011,g-Y;mi\u0012BTC\u0001BpU\u0011\tyLa)\t\u0013\t\r\b!%A\u0005\n\t\u0015\u0018A\u00057pC\u0012$\u0015\r^1%I\u00164\u0017-\u001e7uII*\"Aa:+\t\tM\"1U\u0004\b\u0005W\u0014\u0001\u0012\u0001Bw\u0003=\u0019\u0005.[2bO>\u001c%/[7f\u0003B\u0004\bcA1\u0003p\u001a1\u0011A\u0001E\u0001\u0005c\u001cRAa<\u000f\u0005g\u00042!\u0006B{\u0013\r\u00119P\u0006\u0002\u0014'B\f'o[\"p]R,\u0007\u0010^*vaB|'\u000f\u001e\u0005\b;\n=H\u0011\u0001B~)\t\u0011i\u000f\u0003\u0005\u0003\u0000\n=H\u0011AB\u0001\u0003\u0011i\u0017-\u001b8\u0015\t\r\r1\u0011\u0002\t\u0004\u001f\r\u0015\u0011bAB\u0004!\t!QK\\5u\u0011!\u0019YA!@A\u0002\r5\u0011\u0001B1sON\u0004BaDAaI!A1\u0011\u0003Bx\t\u0003\u0019\u0019\"A\u0004T\u000b\u0006\u001bvJT*\u0016\u0005\r5\u0001\u0002CB\f\u0005_$\ta!\u0007\u0002\u0013\u001d,GoU3bg>tG\u0003BA-\u00077A\u0001b!\b\u0004\u0016\u0001\u0007\u0011\u0011L\u0001\u0006[>tG\u000f\u001b\u0005\u000b\u0007C\u0011y/%A\u0005\u0002\r\r\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004&)\u001aAEa)\t\u0015\r%\"q^I\u0001\n\u0003\u0019\u0019#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\u000e")
public class ChicagoCrimeApp
implements SparklingWaterApp,
ModelMetricsSupport,
H2OFrameSupport {
    private final String weatherFile;
    private final String censusFile;
    private final String crimesFile;
    private final String datePattern;
    private final String dateTimeZone;
    private final transient SparkContext sc;
    private final transient SQLContext sqlContext;
    private final transient H2OContext h2oContext;
    private final String water$support$JoinSupport$$MERGE_RAPIDS;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("Arrest");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("Community_Area");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("Community_Area_Number");

    public static String configure$default$2() {
        return ChicagoCrimeApp$.MODULE$.configure$default$2();
    }

    public static String configure$default$1() {
        return ChicagoCrimeApp$.MODULE$.configure$default$1();
    }

    public static <M> M loadSparkModel(URI uRI) {
        return ChicagoCrimeApp$.MODULE$.loadSparkModel(uRI);
    }

    public static void exportSparkModel(Object object, URI uRI) {
        ChicagoCrimeApp$.MODULE$.exportSparkModel(object, uRI);
    }

    public static String absPath(String string) {
        return ChicagoCrimeApp$.MODULE$.absPath(string);
    }

    public static String enforceLocalSparkFile(String string) {
        return ChicagoCrimeApp$.MODULE$.enforceLocalSparkFile(string);
    }

    public static void addFiles(SparkContext sparkContext, Seq<String> seq) {
        ChicagoCrimeApp$.MODULE$.addFiles(sparkContext, seq);
    }

    public static SparkContext sparkContext(SparkConf sparkConf) {
        return ChicagoCrimeApp$.MODULE$.sparkContext(sparkConf);
    }

    public static SparkConf configure(String string, String string2) {
        return ChicagoCrimeApp$.MODULE$.configure(string, string2);
    }

    public static String $lessinit$greater$default$5() {
        return ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return ChicagoCrimeApp$.MODULE$.$lessinit$greater$default$4();
    }

    public static int getSeason(int n) {
        return ChicagoCrimeApp$.MODULE$.getSeason(n);
    }

    public static String[] SEASONS() {
        return ChicagoCrimeApp$.MODULE$.SEASONS();
    }

    public static void main(String[] stringArray) {
        ChicagoCrimeApp$.MODULE$.main(stringArray);
    }

    public <T extends Frame> Frame[] splitFrame(T fr, Seq<String> keys, Seq<Object> ratios) {
        return H2OFrameSupport.class.splitFrame((H2OFrameSupport)this, fr, keys, ratios);
    }

    public <T extends Frame> Frame[] split(T fr, Seq<String> keys, Seq<Object> ratios) {
        return H2OFrameSupport.class.split((H2OFrameSupport)this, fr, keys, ratios);
    }

    public <T extends Frame> T withLockAndUpdate(T fr, Function1<T, Object> f) {
        return (T)H2OFrameSupport.class.withLockAndUpdate((H2OFrameSupport)this, fr, f);
    }

    public <T extends Frame> T allStringVecToCategorical(T fr) {
        return (T)H2OFrameSupport.class.allStringVecToCategorical((H2OFrameSupport)this, fr);
    }

    public String water$support$JoinSupport$$MERGE_RAPIDS() {
        return this.water$support$JoinSupport$$MERGE_RAPIDS;
    }

    public void water$support$JoinSupport$_setter_$water$support$JoinSupport$$MERGE_RAPIDS_$eq(String x$1) {
        this.water$support$JoinSupport$$MERGE_RAPIDS = x$1;
    }

    public Frame join(Frame left, Frame right, boolean allX, boolean allY, int[] byX, int[] byY, JoinMethod method) {
        return JoinSupport.class.join((JoinSupport)this, (Frame)left, (Frame)right, (boolean)allX, (boolean)allY, (int[])byX, (int[])byY, (JoinMethod)method);
    }

    public Frame leftJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.leftJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public Frame rightJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.rightJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public Frame innerJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.innerJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public Frame outerJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.outerJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public boolean join$default$3() {
        return JoinSupport.class.join$default$3((JoinSupport)this);
    }

    public boolean join$default$4() {
        return JoinSupport.class.join$default$4((JoinSupport)this);
    }

    public int[] join$default$5() {
        return JoinSupport.class.join$default$5((JoinSupport)this);
    }

    public int[] join$default$6() {
        return JoinSupport.class.join$default$6((JoinSupport)this);
    }

    public JoinMethod join$default$7() {
        return JoinSupport.class.join$default$7((JoinSupport)this);
    }

    public JoinMethod leftJoin$default$3() {
        return JoinSupport.class.leftJoin$default$3((JoinSupport)this);
    }

    public JoinMethod rightJoin$default$3() {
        return JoinSupport.class.rightJoin$default$3((JoinSupport)this);
    }

    public JoinMethod innerJoin$default$3() {
        return JoinSupport.class.innerJoin$default$3((JoinSupport)this);
    }

    public JoinMethod outerJoin$default$3() {
        return JoinSupport.class.outerJoin$default$3((JoinSupport)this);
    }

    public <T extends ModelMetrics> ModelMetricsSupport.ModelMetricsExtractor<T> modelMetrics() {
        return ModelMetricsSupport.class.modelMetrics((ModelMetricsSupport)this);
    }

    public H2OFrame loadH2OFrame(String datafile) {
        return SparklingWaterApp.class.loadH2OFrame((SparklingWaterApp)this, (String)datafile);
    }

    public void shutdown() {
        SparklingWaterApp.class.shutdown((SparklingWaterApp)this);
    }

    public String datePattern() {
        return this.datePattern;
    }

    public String dateTimeZone() {
        return this.dateTimeZone;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public H2OContext h2oContext() {
        return this.h2oContext;
    }

    public Tuple2<GBMModel, DeepLearningModel> train(Dataset<Row> weatherTable, Dataset<Row> censusTable, Dataset<Row> crimesTable) {
        SQLContext sqlc = this.sqlContext();
        H2OContext h2oc = this.h2oContext();
        weatherTable.createOrReplaceTempView("chicagoWeather");
        censusTable.createOrReplaceTempView("chicagoCensus");
        crimesTable.createOrReplaceTempView("chicagoCrime");
        Dataset crimeWeather = this.sqlContext().sql(new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |a.Year, a.Month, a.Day, a.WeekNum, a.HourOfDay, a.Weekend, a.Season, a.WeekDay,\n        |a.IUCR, a.Primary_Type, a.Location_Description, a.Community_Area, a.District,\n        |a.Arrest, a.Domestic, a.Beat, a.Ward, a.FBI_Code,\n        |b.minTemp, b.maxTemp, b.meanTemp,\n        |c.PERCENT_AGED_UNDER_18_OR_OVER_64, c.PER_CAPITA_INCOME, c.HARDSHIP_INDEX,\n        |c.PERCENT_OF_HOUSING_CROWDED, c.PERCENT_HOUSEHOLDS_BELOW_POVERTY,\n        |c.PERCENT_AGED_16__UNEMPLOYED, c.PERCENT_AGED_25__WITHOUT_HIGH_SCHOOL_DIPLOMA\n        |FROM chicagoCrime a\n        |JOIN chicagoWeather b\n        |ON a.Year = b.year AND a.Month = b.month AND a.Day = b.day\n        |JOIN chicagoCensus c\n        |ON a.Community_Area = c.Community_Area_Number")).stripMargin());
        H2OFrame crimeWeatherDF = this.h2oContext().implicits().asH2OFrameFromDataFrame(crimeWeather);
        this.withLockAndUpdate((Frame)crimeWeatherDF, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChicagoCrimeApp $outer;

            public final H2OFrame apply(H2OFrame fr) {
                return this.$outer.allStringVecToCategorical(fr);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String[] keys = (String[])((Object[])new String[]{"train.hex", "test.hex"});
        double[] ratios = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8, 0.2}), ClassTag$.MODULE$.Double());
        Frame[] frs = this.splitFrame(crimeWeatherDF, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])keys), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(ratios));
        Tuple2 tuple2 = new Tuple2((Object)frs[0], (Object)frs[1]);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Frame train2 = (Frame)tuple2._1();
            Frame test = (Frame)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)train2, (Object)test);
            Frame train3 = (Frame)tuple23._1();
            Frame test2 = (Frame)tuple23._2();
            GBMModel gbmModel = this.GBMModel(this.h2oContext().implicits().asH2OFrameFromFrame(train3), this.h2oContext().implicits().asH2OFrameFromFrame(test2), this.h2oContext().implicits().symbolToString(symbol$1), this.GBMModel$default$4(), this.GBMModel$default$5(), this.GBMModel$default$6(), h2oc);
            Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> tuple24 = this.binomialMetrics((Model)gbmModel, this.h2oContext().implicits().asH2OFrameFromFrame(train3), this.h2oContext().implicits().asH2OFrameFromFrame(test2));
            if (tuple24 != null) {
                Tuple2 tuple25;
                ModelMetricsBinomial trainMetricsGBM = (ModelMetricsBinomial)tuple24._1();
                ModelMetricsBinomial testMetricsGBM = (ModelMetricsBinomial)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)trainMetricsGBM, (Object)testMetricsGBM);
                ModelMetricsBinomial trainMetricsGBM2 = (ModelMetricsBinomial)tuple26._1();
                ModelMetricsBinomial testMetricsGBM2 = (ModelMetricsBinomial)tuple26._2();
                DeepLearningModel dlModel = this.DLModel(this.h2oContext().implicits().asH2OFrameFromFrame(train3), this.h2oContext().implicits().asH2OFrameFromFrame(test2), this.h2oContext().implicits().symbolToString(symbol$1), this.DLModel$default$4(), this.DLModel$default$5(), this.DLModel$default$6(), this.DLModel$default$7(), this.DLModel$default$8(), h2oc);
                Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> tuple27 = this.binomialMetrics((Model)dlModel, this.h2oContext().implicits().asH2OFrameFromFrame(train3), this.h2oContext().implicits().asH2OFrameFromFrame(test2));
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    ModelMetricsBinomial trainMetricsDL = (ModelMetricsBinomial)tuple27._1();
                    ModelMetricsBinomial testMetricsDL = (ModelMetricsBinomial)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)trainMetricsDL, (Object)testMetricsDL);
                    ModelMetricsBinomial trainMetricsDL2 = (ModelMetricsBinomial)tuple29._1();
                    ModelMetricsBinomial testMetricsDL2 = (ModelMetricsBinomial)tuple29._2();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Model performance:\n          |  GBM:\n          |    train AUC = ", "\n          |    test  AUC = ", "\n          |  DL:\n          |    train AUC = ", "\n          |    test  AUC = ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMetricsGBM2.auc()), BoxesRunTime.boxToDouble((double)testMetricsGBM2.auc()), BoxesRunTime.boxToDouble((double)trainMetricsDL2.auc()), BoxesRunTime.boxToDouble((double)testMetricsDL2.auc())})))).stripMargin());
                    return new Tuple2((Object)gbmModel, (Object)dlModel);
                }
                throw new MatchError(tuple27);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public GBMModel GBMModel(H2OFrame train2, H2OFrame test, String response, int ntrees, int depth, DistributionFamily family, H2OContext h2oContext) {
        GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
        gbmParams._train = h2oContext.implicits().toH2OFrameKeyFromH2OFrame(train2);
        gbmParams._valid = h2oContext.implicits().toH2OFrameKeyFromH2OFrame(test);
        gbmParams._response_column = response;
        gbmParams._ntrees = ntrees;
        gbmParams._max_depth = depth;
        gbmParams._distribution = family;
        GBM gbm = new GBM(gbmParams);
        GBMModel model = (GBMModel)gbm.trainModel().get();
        return model;
    }

    public int GBMModel$default$4() {
        return 10;
    }

    public int GBMModel$default$5() {
        return 6;
    }

    public DistributionFamily GBMModel$default$6() {
        return DistributionFamily.bernoulli;
    }

    public DeepLearningModel DLModel(H2OFrame train2, H2OFrame test, String response, int epochs, double l1, double l2, DeepLearningModel.DeepLearningParameters.Activation activation, int[] hidden, H2OContext h2oContext) {
        DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
        dlParams._train = h2oContext.implicits().toH2OFrameKeyFromH2OFrame(train2);
        dlParams._valid = h2oContext.implicits().toH2OFrameKeyFromH2OFrame(test);
        dlParams._response_column = response;
        dlParams._epochs = epochs;
        dlParams._l1 = l1;
        dlParams._l2 = l2;
        dlParams._activation = activation;
        dlParams._hidden = hidden;
        DeepLearning dl = new DeepLearning(dlParams);
        DeepLearningModel model = (DeepLearningModel)dl.trainModel().get();
        return model;
    }

    public int DLModel$default$4() {
        return 10;
    }

    public double DLModel$default$5() {
        return 1.0E-4;
    }

    public double DLModel$default$6() {
        return 1.0E-4;
    }

    public DeepLearningModel.DeepLearningParameters.Activation DLModel$default$7() {
        return DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
    }

    public int[] DLModel$default$8() {
        return new int[]{200, 200};
    }

    public <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> Tuple2<ModelMetricsBinomial, ModelMetricsBinomial> binomialMetrics(Model<M, P, O> model, H2OFrame train2, H2OFrame test) {
        return new Tuple2((Object)this.modelMetrics().apply(model, (Frame)train2), (Object)this.modelMetrics().apply(model, (Frame)test));
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, Dataset<Row>> loadAll() {
        SQLContext sqlc = this.sqlContext();
        H2OContext h2oc = this.h2oContext();
        Dataset weatherTable = this.h2oContext().asDataFrame((Frame)this.createWeatherTable(this.weatherFile), this.h2oContext().asDataFrame$default$2(), sqlc);
        weatherTable.createOrReplaceTempView("chicagoWeather");
        Dataset censusTable = this.h2oContext().asDataFrame((Frame)this.createCensusTable(this.censusFile), this.h2oContext().asDataFrame$default$2(), sqlc);
        censusTable.createOrReplaceTempView("chicagoCensus");
        Dataset crimeTable = this.h2oContext().asDataFrame((Frame)this.createCrimeTable(this.crimesFile), this.h2oContext().asDataFrame$default$2(), sqlc);
        crimeTable.createOrReplaceTempView("chicagoCrime");
        return new Tuple3((Object)weatherTable, (Object)censusTable, (Object)crimeTable);
    }

    private H2OFrame loadData(String datafile, Function1<ParseSetup, ParseSetup> modifyParserSetup) {
        URI uri = URI.create(datafile);
        ParseSetup parseSetup = (ParseSetup)modifyParserSetup.apply((Object)H2OFrame$.MODULE$.parserSetup((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URI[]{uri})));
        return new H2OFrame(parseSetup, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new URI[]{new URI(datafile)}));
    }

    private Function1<ParseSetup, ParseSetup> loadData$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ParseSetup apply(ParseSetup x) {
                return (ParseSetup)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public H2OFrame createWeatherTable(String datafile) {
        H2OFrame table = this.loadData(datafile, this.loadData$default$2());
        return this.withLockAndUpdate((Frame)table, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(H2OFrame x$4) {
                x$4.remove(0).remove();
            }
        });
    }

    public H2OFrame createCensusTable(String datafile) {
        H2OFrame table = this.loadData(datafile, this.loadData$default$2());
        return this.withLockAndUpdate((Frame)table, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(H2OFrame fr) {
                String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])fr.names()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String n) {
                        return n.trim().replace(' ', '_').replace('+', '_');
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                fr._names = colNames;
            }
        });
    }

    public H2OFrame createCrimeTable(String datafile) {
        H2OFrame table = this.loadData(datafile, (Function1<ParseSetup, ParseSetup>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ParseSetup apply(ParseSetup parseSetup) {
                String[] colNames = parseSetup.getColumnNames();
                byte[] typeNames = parseSetup.getColumnTypes();
                Predef$.MODULE$.refArrayOps((Object[])colNames).indices().foreach$mVc$sp((Function1)new Serializable(this, colNames, typeNames){
                    public static final long serialVersionUID = 0L;
                    private final String[] colNames$1;
                    private final byte[] typeNames$1;

                    public final void apply(int idx) {
                        this.apply$mcVI$sp(idx);
                    }

                    public void apply$mcVI$sp(int idx) {
                        String string = this.colNames$1[idx];
                        String string2 = "Date";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            this.typeNames$1[idx] = 2;
                        }
                    }
                    {
                        this.colNames$1 = colNames$1;
                        this.typeNames$1 = typeNames$1;
                    }
                });
                return parseSetup;
            }
        });
        return this.withLockAndUpdate((Frame)table, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChicagoCrimeApp $outer;

            public final void apply(H2OFrame fr) {
                Vec dateCol = fr.vec(2);
                fr.add((Frame)new RefineDateColumn(this.$outer.datePattern(), this.$outer.dateTimeZone()).doIt(dateCol));
                String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])fr.names()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String n) {
                        return n.trim().replace(' ', '_');
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                fr._names = colNames;
                fr.remove(2).remove();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public float scoreEvent(Crime crime, Model<?, ?, ?> model, Dataset<Row> censusTable, SQLContext sqlContext, H2OContext h2oContext) {
        SparkContext qual$1 = sqlContext.sparkContext();
        Seq x$8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Crime[]{crime}));
        int x$9 = qual$1.parallelize$default$2();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ChicagoCrimeApp.class.getClassLoader());
        public final class Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.h2o.Crime").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator2$1(ChicagoCrimeApp $outer) {
            }
        }
        Dataset srdd = sqlContext.implicits().rddToDatasetHolder(qual$1.parallelize(x$8, x$9, ClassTag$.MODULE$.apply(Crime.class)), sqlContext.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_ChicagoCrimeApp$$typecreator2$1(this)))).toDF();
        H2OFrame row = h2oContext.implicits().asH2OFrameFromDataFrame(censusTable.join(srdd).where(sqlContext.implicits().symbolToColumn(symbol$2).$eq$eq$eq((Object)symbol$3)));
        this.withLockAndUpdate((Frame)row, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChicagoCrimeApp $outer;

            public final H2OFrame apply(H2OFrame fr) {
                return this.$outer.allStringVecToCategorical(fr);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Frame predictTable = model.score((Frame)row);
        double probOfArrest = predictTable.vec("true").at(0L);
        return (float)probOfArrest;
    }

    public ChicagoCrimeApp(String weatherFile, String censusFile, String crimesFile, String datePattern, String dateTimeZone, SparkContext sc, SQLContext sqlContext, H2OContext h2oContext) {
        this.weatherFile = weatherFile;
        this.censusFile = censusFile;
        this.crimesFile = crimesFile;
        this.datePattern = datePattern;
        this.dateTimeZone = dateTimeZone;
        this.sc = sc;
        this.sqlContext = sqlContext;
        this.h2oContext = h2oContext;
        SparklingWaterApp.class.$init$((SparklingWaterApp)this);
        ModelMetricsSupport.class.$init$((ModelMetricsSupport)this);
        JoinSupport.class.$init$((JoinSupport)this);
        H2OFrameSupport.class.$init$((H2OFrameSupport)this);
    }
}

