/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.h2o;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.h2o.HamOrSpamDemo$;
import org.apache.spark.examples.h2o.SMS;
import org.apache.spark.examples.h2o.TestUtils$;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.mllib.feature.HashingTF;
import org.apache.spark.mllib.feature.IDF;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import water.Key;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.munging.JoinMethod;
import water.support.H2OFrameSupport;
import water.support.H2OFrameSupport$;
import water.support.JoinSupport;
import water.support.ModelMetricsSupport;
import water.support.SparkContextSupport;

public final class HamOrSpamDemo$
implements SparkContextSupport,
ModelMetricsSupport,
H2OFrameSupport {
    public static final HamOrSpamDemo$ MODULE$;
    private final String DATAFILE;
    private final Seq<String> TEST_MSGS;
    private final String water$support$JoinSupport$$MERGE_RAPIDS;
    private static Symbol symbol$1;

    static {
        symbol$1 = Symbol$.MODULE$.apply("target");
        new HamOrSpamDemo$();
    }

    public <T extends Frame> Frame[] splitFrame(T fr, Seq<String> keys, Seq<Object> ratios) {
        return H2OFrameSupport.class.splitFrame((H2OFrameSupport)this, fr, keys, ratios);
    }

    public <T extends Frame> Frame[] split(T fr, Seq<String> keys, Seq<Object> ratios) {
        return H2OFrameSupport.class.split((H2OFrameSupport)this, fr, keys, ratios);
    }

    public <T extends Frame> T withLockAndUpdate(T fr, Function1<T, Object> f) {
        return (T)H2OFrameSupport.class.withLockAndUpdate((H2OFrameSupport)this, fr, f);
    }

    public <T extends Frame> T allStringVecToCategorical(T fr) {
        return (T)H2OFrameSupport.class.allStringVecToCategorical((H2OFrameSupport)this, fr);
    }

    public <T extends Frame> T columnsToCategorical(T fr, int[] colIndices) {
        return (T)H2OFrameSupport.class.columnsToCategorical((H2OFrameSupport)this, fr, (int[])colIndices);
    }

    public <T extends Frame> T columnsToCategorical(T fr, String[] colNames) {
        return (T)H2OFrameSupport.class.columnsToCategorical((H2OFrameSupport)this, fr, (String[])colNames);
    }

    public String water$support$JoinSupport$$MERGE_RAPIDS() {
        return this.water$support$JoinSupport$$MERGE_RAPIDS;
    }

    public void water$support$JoinSupport$_setter_$water$support$JoinSupport$$MERGE_RAPIDS_$eq(String x$1) {
        this.water$support$JoinSupport$$MERGE_RAPIDS = x$1;
    }

    public <T extends Frame> Frame join(T left, T right, boolean allX, boolean allY, JoinMethod method) {
        return JoinSupport.class.join((JoinSupport)this, left, right, (boolean)allX, (boolean)allY, (JoinMethod)method);
    }

    public Frame leftJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.leftJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public Frame rightJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.rightJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public Frame innerJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.innerJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public Frame outerJoin(Frame left, Frame right, JoinMethod method) {
        return JoinSupport.class.outerJoin((JoinSupport)this, (Frame)left, (Frame)right, (JoinMethod)method);
    }

    public <T extends Frame> boolean join$default$3() {
        return JoinSupport.class.join$default$3((JoinSupport)this);
    }

    public <T extends Frame> boolean join$default$4() {
        return JoinSupport.class.join$default$4((JoinSupport)this);
    }

    public <T extends Frame> JoinMethod join$default$5() {
        return JoinSupport.class.join$default$5((JoinSupport)this);
    }

    public JoinMethod leftJoin$default$3() {
        return JoinSupport.class.leftJoin$default$3((JoinSupport)this);
    }

    public JoinMethod rightJoin$default$3() {
        return JoinSupport.class.rightJoin$default$3((JoinSupport)this);
    }

    public JoinMethod innerJoin$default$3() {
        return JoinSupport.class.innerJoin$default$3((JoinSupport)this);
    }

    public JoinMethod outerJoin$default$3() {
        return JoinSupport.class.outerJoin$default$3((JoinSupport)this);
    }

    public <T extends ModelMetrics> ModelMetricsSupport.ModelMetricsExtractor<T> modelMetrics() {
        return ModelMetricsSupport.class.modelMetrics((ModelMetricsSupport)this);
    }

    public SparkConf configure(String appName, String defaultMaster) {
        return SparkContextSupport.class.configure((SparkContextSupport)this, (String)appName, (String)defaultMaster);
    }

    public SparkContext sparkContext(SparkConf conf) {
        return SparkContextSupport.class.sparkContext((SparkContextSupport)this, (SparkConf)conf);
    }

    public void addFiles(SparkContext sc, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkContext)sc, files);
    }

    public void addFiles(SparkSession spark, Seq<String> files) {
        SparkContextSupport.class.addFiles((SparkContextSupport)this, (SparkSession)spark, files);
    }

    public String enforceLocalSparkFile(String file) {
        return SparkContextSupport.class.enforceLocalSparkFile((SparkContextSupport)this, (String)file);
    }

    public String absPath(String path) {
        return SparkContextSupport.class.absPath((SparkContextSupport)this, (String)path);
    }

    public void exportSparkModel(Object model, URI destination) {
        SparkContextSupport.class.exportSparkModel((SparkContextSupport)this, (Object)model, (URI)destination);
    }

    public <M> M loadSparkModel(URI source) {
        return (M)SparkContextSupport.class.loadSparkModel((SparkContextSupport)this, (URI)source);
    }

    public String configure$default$1() {
        return SparkContextSupport.class.configure$default$1((SparkContextSupport)this);
    }

    public String configure$default$2() {
        return SparkContextSupport.class.configure$default$2((SparkContextSupport)this);
    }

    public String DATAFILE() {
        return this.DATAFILE;
    }

    public Seq<String> TEST_MSGS() {
        return this.TEST_MSGS;
    }

    public void main(String[] args) {
        SparkConf conf = this.configure("Sparkling Water Meetup: Ham or Spam (spam text messages detector)", this.configure$default$2());
        SparkContext sc = new SparkContext(conf);
        this.addFiles(sc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TestUtils$.MODULE$.locate(new StringBuilder().append((Object)"smalldata/").append((Object)this.DATAFILE()).toString())}));
        H2OContext h2oContext = H2OContext$.MODULE$.getOrCreate(sc);
        SQLContext sqlContext = SparkSession$.MODULE$.builder().getOrCreate().sqlContext();
        RDD<String[]> data = this.load(sc, this.DATAFILE());
        RDD hamSpam = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String[] r) {
                return r[0];
            }
        }, ClassTag$.MODULE$.apply(String.class));
        RDD message = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String[] r) {
                return r[1];
            }
        }, ClassTag$.MODULE$.apply(String.class));
        RDD<Seq<String>> tokens = this.tokenize((RDD<String>)message);
        Tuple3<HashingTF, IDFModel, RDD<Vector>> tuple3 = this.buildIDFModel(tokens, this.buildIDFModel$default$2(), this.buildIDFModel$default$3());
        if (tuple3 != null) {
            Tuple3 tuple32;
            HashingTF hashingTF = (HashingTF)tuple3._1();
            IDFModel idfModel = (IDFModel)tuple3._2();
            RDD tfidf = (RDD)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)hashingTF, (Object)idfModel, (Object)tfidf);
            HashingTF hashingTF2 = (HashingTF)tuple33._1();
            IDFModel idfModel2 = (IDFModel)tuple33._2();
            RDD tfidf2 = (RDD)tuple33._3();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.examples.h2o.SMS").asType().toTypeConstructor();
                }

                public Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator2$1() {
                }
            }
            Dataset resultRDD = sqlContext.implicits().rddToDatasetHolder(hamSpam.zip(tfidf2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SMS apply(Tuple2<String, Vector> v) {
                    return new SMS((String)v._1(), (Vector)v._2());
                }
            }, ClassTag$.MODULE$.apply(SMS.class)), sqlContext.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator2$1()))).toDF();
            H2OFrame table = h2oContext.implicits().asH2OFrameFromDataFrame(resultRDD);
            H2OFrameSupport$.MODULE$.withLockAndUpdate((Frame)table, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(H2OFrame fr) {
                    fr.replace(fr.find("target"), fr.vec("target").toCategoricalVec()).remove();
                }
            });
            String[] keys = (String[])((Object[])new String[]{"train.hex", "valid.hex"});
            double[] ratios = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8}), ClassTag$.MODULE$.Double());
            Frame[] frs = this.split(table, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])keys), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(ratios));
            Tuple2 tuple2 = new Tuple2((Object)frs[0], (Object)frs[1]);
            if (tuple2 != null) {
                Tuple2 tuple22;
                Frame train2 = (Frame)tuple2._1();
                Frame valid = (Frame)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)train2, (Object)valid);
                Frame train3 = (Frame)tuple23._1();
                Frame valid2 = (Frame)tuple23._2();
                table.delete();
                DeepLearningModel dlModel = this.buildDLModel(train3, valid2, this.buildDLModel$default$3(), this.buildDLModel$default$4(), this.buildDLModel$default$5(), this.buildDLModel$default$6(), h2oContext);
                ModelMetricsBinomial trainMetrics = (ModelMetricsBinomial)this.modelMetrics().apply((Model)dlModel, train3);
                ModelMetricsBinomial validMetrics = (ModelMetricsBinomial)this.modelMetrics().apply((Model)dlModel, valid2);
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |AUC on train data = ", "\n         |AUC on valid data = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMetrics.auc()), BoxesRunTime.boxToDouble((double)validMetrics.auc())})))).stripMargin());
                this.TEST_MSGS().foreach((Function1)new Serializable(sc, h2oContext, sqlContext, hashingTF2, idfModel2, dlModel){
                    public static final long serialVersionUID = 0L;
                    private final SparkContext sc$1;
                    private final H2OContext h2oContext$1;
                    private final SQLContext sqlContext$1;
                    private final HashingTF hashingTF$1;
                    private final IDFModel idfModel$1;
                    private final DeepLearningModel dlModel$1;

                    public final void apply(String msg) {
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |\"", "\" is ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, HamOrSpamDemo$.MODULE$.isSpam(msg, this.sc$1, this.dlModel$1, this.hashingTF$1, this.idfModel$1, HamOrSpamDemo$.MODULE$.isSpam$default$6(), this.sqlContext$1, this.h2oContext$1) ? "SPAM" : "HAM"})))).stripMargin());
                    }
                    {
                        this.sc$1 = sc$1;
                        this.h2oContext$1 = h2oContext$1;
                        this.sqlContext$1 = sqlContext$1;
                        this.hashingTF$1 = hashingTF$1;
                        this.idfModel$1 = idfModel$1;
                        this.dlModel$1 = dlModel$1;
                    }
                });
                h2oContext.stop(true);
                return;
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(tuple3);
    }

    public RDD<String[]> load(SparkContext sc, String dataFile) {
        return sc.textFile(this.enforceLocalSparkFile(dataFile), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String l) {
                return l.split("\t", 2);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] r) {
                return !r[0].isEmpty();
            }
        });
    }

    public RDD<Seq<String>> tokenize(RDD<String> data) {
        Seq ignoredWords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the", "a", "", "in", "on", "at", "as", "not", "for"}));
        Seq ignoredChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{',', ':', ';', '/', '<', '>', '\"', '.', '(', ')', '?', '-', '\'', '!', '0', '1'}));
        RDD texts = data.map((Function1)new Serializable(ignoredWords, ignoredChars){
            public static final long serialVersionUID = 0L;
            public final Seq ignoredWords$1;
            private final Seq ignoredChars$1;

            public final Seq<String> apply(String r) {
                ObjectRef smsText = ObjectRef.create((Object)r.toLowerCase());
                this.ignoredChars$1.foreach((Function1)new Serializable(this, smsText){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef smsText$1;

                    public final void apply(char c) {
                        this.smsText$1.elem = ((String)this.smsText$1.elem).replace(c, ' ');
                    }
                    {
                        this.smsText$1 = smsText$1;
                    }
                });
                String[] words = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)smsText.elem).split(" ")).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;

                    public final boolean apply(String w) {
                        return !this.$outer.ignoredWords$1.contains((Object)w) && w.length() > 2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).distinct();
                return Predef$.MODULE$.refArrayOps((Object[])words).toSeq();
            }
            {
                this.ignoredWords$1 = ignoredWords$1;
                this.ignoredChars$1 = ignoredChars$1;
            }
        }, ClassTag$.MODULE$.apply(Seq.class));
        return texts;
    }

    public Tuple3<HashingTF, IDFModel, RDD<Vector>> buildIDFModel(RDD<Seq<String>> tokens, int minDocFreq, int hashSpaceSize) {
        HashingTF hashingTF = new HashingTF(hashSpaceSize);
        RDD tf = hashingTF.transform(tokens);
        IDFModel idfModel = new IDF(minDocFreq).fit(tf);
        RDD expandedText = idfModel.transform(tf);
        return new Tuple3((Object)hashingTF, (Object)idfModel, (Object)expandedText);
    }

    public int buildIDFModel$default$2() {
        return 4;
    }

    public int buildIDFModel$default$3() {
        return 1024;
    }

    public DeepLearningModel buildDLModel(Frame train2, Frame valid, int epochs, double l1, double l2, int[] hidden, H2OContext h2oContext) {
        DeepLearningModel.DeepLearningParameters dlParams = new DeepLearningModel.DeepLearningParameters();
        dlParams._train = h2oContext.implicits().toH2OFrameKeyFromFrame(train2);
        dlParams._valid = h2oContext.implicits().toH2OFrameKeyFromFrame(valid);
        dlParams._response_column = h2oContext.implicits().symbolToString(symbol$1);
        dlParams._epochs = epochs;
        dlParams._l1 = l1;
        dlParams._hidden = hidden;
        DeepLearning dl = new DeepLearning(dlParams, Key.make((String)"dlModel.hex"));
        return (DeepLearningModel)dl.trainModel().get();
    }

    public int buildDLModel$default$3() {
        return 10;
    }

    public double buildDLModel$default$4() {
        return 0.001;
    }

    public double buildDLModel$default$5() {
        return 0.0;
    }

    public int[] buildDLModel$default$6() {
        return (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{200, 200}), ClassTag$.MODULE$.Int());
    }

    public boolean isSpam(String msg, SparkContext sc, DeepLearningModel dlModel, HashingTF hashingTF, IDFModel idfModel, double hamThreshold, SQLContext sqlContext, H2OContext h2oContext) {
        RDD msgRdd = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.h2o.SMS").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator4$1() {
            }
        }
        Dataset msgVector = sqlContext.implicits().rddToDatasetHolder(idfModel.transform(hashingTF.transform(this.tokenize((RDD<String>)msgRdd))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SMS apply(Vector v) {
                return new SMS("?", v);
            }
        }, ClassTag$.MODULE$.apply(SMS.class)), sqlContext.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_h2o_HamOrSpamDemo$$typecreator4$1()))).toDF();
        H2OFrame msgTable = h2oContext.implicits().asH2OFrameFromDataFrame(msgVector);
        msgTable.remove(0);
        Frame prediction = dlModel.score((Frame)msgTable);
        return prediction.vecs()[1].at(0L) < hamThreshold;
    }

    public double isSpam$default$6() {
        return 0.5;
    }

    private HamOrSpamDemo$() {
        MODULE$ = this;
        SparkContextSupport.class.$init$((SparkContextSupport)this);
        ModelMetricsSupport.class.$init$((ModelMetricsSupport)this);
        JoinSupport.class.$init$((JoinSupport)this);
        H2OFrameSupport.class.$init$((H2OFrameSupport)this);
        this.DATAFILE = "smsData.txt";
        this.TEST_MSGS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Michal, beer tonight in MV?", "We tried to contact you re your reply to our offer of a Video Handset? 750 anytime any networks mins? UNLIMITED TEXT?"}));
    }
}

